/* -*- c++ -*-
 *
 * $Id: prefs.h,v 1.19 2003/07/23 18:04:39 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: prefs.h,v $
 * Revision 1.19  2003/07/23 18:04:39  gibreel
 * Support for multiple host definitions using HostManager. Configurable
 * charset encoding.
 *
 * Revision 1.18  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.17  2003/06/29 10:56:30  dipesh
 * converted search-pref "Ask for filename on starting a new download" to the
 * KAction "Download as..." to be more flexible and remember some more
 * searchpage values.
 *
 * Revision 1.16  2003/06/28 21:55:13  gibreel
 * Configurable coloured source list.
 *
 * Revision 1.15  2003/06/28 10:42:25  dipesh
 * Added search-pref "Ask for filename on starting a new download".
 *
 * Revision 1.14  2003/06/27 12:50:39  dipesh
 * added search-pref to optional display numbers of files found on tabs,
 * searchfilter does understand filesizes (fe. >2MB), use function-inline
 * where it make sense and some other things.
 *
 * Revision 1.13  2003/06/23 18:26:29  dipesh
 * Added initial search-prefs, more later
 *
 * Revision 1.12  2003/06/19 22:05:52  gibreel
 * Merged the General and Donkey prefs pages back together.
 *
 * Revision 1.11  2003/06/19 17:04:32  gibreel
 * Minor code cleanups and attempt to fix the crash bugs on
 * disconnect/reconnect. Both kmldonkey and libkmldonkey now clean out their
 * state data when the connection with the core is lost.
 *
 * Revision 1.10  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.9  2003/06/09 23:45:36  gibreel
 * Availability threshold config uses a KIntNumInput instead of a QSlider.
 *
 * Revision 1.8  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.7  2003/05/30 11:53:00  dipesh
 * Optional colored Downloadlist
 *
 * Revision 1.6  2003/05/26 15:49:46  gibreel
 * Improved connect/disconnect code: added KActions for connecting to and
 * disconnecting from the mldonkey core, and an option for trying to stay
 * connected at all times (behaving essentially like the applet does).
 *
 * Revision 1.5  2003/05/26 14:31:46  dipesh
 * Added prefs; Statusbar-label's + save on exit
 *
 * Revision 1.4  2003/05/03 13:51:57  dipesh
 * Added "Show Toolbar" and "Show Statusbar" to the the Prefs and create KMLDonkeyPreferences-instance only if needed and not already at startup.
 *
 * Revision 1.2  2003/04/27 16:10:08  gibreel
 * Applied another patch from dipesh <dipesh@gmx.de> which adds the Show All
 * Servers action to the prefs dialog, and cleans up prefs handling a little.
 * The prefs dialog now also remembers its size.
 *
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 */

#ifndef __kmldonkey_prefs_h__
#define __kmldonkey_prefs_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qtabwidget.h>
#include <qvbox.h>
#include <qtooltip.h>
#include <kdialogbase.h>
#include <kcolorbutton.h>
#include "fontselector.h"

class QCheckBox;
class KPushButton;
class KIntNumInput;
class KComboBox;

class ColorSelector : public QHBox
{
public:
    ColorSelector(QWidget* parent, const char* name, const QString caption, const QString tooltip) : QHBox(parent, name) {
        new QLabel(caption, this);
        Button = new KColorButton(this, "colorButton");
        QToolTip::add(this, tooltip);
    }
    const QColor color() { return Button->color(); }
    void setColor(const QColor &color) { Button->setColor(color); }
private:
    KColorButton *Button;
};

class KMLDonkeyPrefGeneralPage : public QVBox
{
public:
    KMLDonkeyPrefGeneralPage(QWidget *parent = 0);

    void setEncoding(const QString& encoding);
    QString getEncoding();

    QCheckBox *ShowToolbarCheckbox,
              *ShowStatusbarCheckbox,
              *StatusbarLabelsCheckbox,
              *SaveStatCheckbox,
              *PersistentReconnectCheckbox,
              *ShowAllServersCheckbox,
              *DebugConsoleCheckbox;
    KComboBox *encodingSelector;
};

class KMLDonkeyPrefSearchPage : public QVBox
{
public:
    KMLDonkeyPrefSearchPage(QWidget *parent);

    QCheckBox *activateNewTabsCheckbox,
              *closeTabsOnDisconnectCheckbox,
              *showNumbersOnTabsCheckbox;
};

class KMLDonkeyPrefColorPage : public QTabWidget
{
    Q_OBJECT
public:
    KMLDonkeyPrefColorPage(QWidget *parent = 0);

    QCheckBox *colorServerCheckbox;
    ColorSelector *colorServerNotConnected,
                  *colorServerBlacklisted,
                  *colorServerConnecting,
                  *colorServerConnected;

    QCheckBox *colorSearchCheckbox;
    ColorSelector *colorSearchFewSources,
                  *colorSearchManySources,
                  *colorSearchAlreadyDone;
    KIntNumInput *searchSourcesThresholdSlider;

    QCheckBox *colorDownloadCheckbox;
    ColorSelector *downloadingColorSelect,
                  *pausedColorSelect,
                  *lookingColorSelect,
                  *queuedColorSelect;

    ColorSelector *noSourcesColorSelect,
                  *fewSourcesColorSelect,
                  *manySourcesColorSelect,
                  *completeColorSelect;
    KIntNumInput* availabilityThresholdSlider;

    QCheckBox *colorSourcesCheckbox;
    ColorSelector *colorSourceNotConnected,
                  *colorSourceBlacklisted,
                  *colorSourceConnecting,
                  *colorSourceQueued,
                  *colorSourceDownloading;

private:
    QVBox *serverPage,
          *searchPage,
          *downloadPage,
          *sourcePage;
public slots:
    void colorServer(bool);
    void colorSearch(bool);
    void colorDownload(bool);
    void colorSources(bool);
};

class KMLDonkeyPrefFontPage : public QFrame
{
public:
    KMLDonkeyPrefFontPage(QWidget *parent = 0);

    FontSelector *consoleFontSelect,
                 *listFontSelect;
};

class KMLDonkeyPreferences : public KDialogBase
{
    Q_OBJECT
public:
    KMLDonkeyPreferences(QWidget* parent = 0);

    KMLDonkeyPrefGeneralPage* generalPage;
    KMLDonkeyPrefSearchPage* searchPage;
    KMLDonkeyPrefColorPage* colorPage;
    KMLDonkeyPrefFontPage* fontPage;

protected slots:
    void saveSize();
};

#endif // __kmldonkey_prefs_h__
