/* -*- c++ -*-
 *
 * $Id: sharepage.h,v 1.4 2003/07/30 15:03:33 dipesh Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: sharepage.h,v $
 * Revision 1.4  2003/07/30 15:03:33  dipesh
 * Added "Share directory" and "Unshare directory"
 *
 * Revision 1.3  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.2  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#ifndef __kmldonkey_sharepage_h__
#define __kmldonkey_sharepage_h__

#include <qobject.h>
#include <qvbox.h>
#include <qintdict.h>

#include "clipboard.h"
#include "page.h"

class KActionCollection;

class KMLDonkeyPreferences;
class InfoList;

class SharePage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    SharePage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

public slots:
    void shareUpdated(int share);
    void shareRemoved(int share);

protected slots:
    void contextUpload(KListView*,QListViewItem*,const QPoint&);

    void actionRefreshShared();
    void actionShareDirectory();
    void actionUnshareDirectory();

    void actionActivatePage();

protected:

private:
    QSplitter *uploadSplitter;
    InfoList *uploadView, *uploadersView;

    QIntDict<SharedFile> shareList;
};

#endif
