/*
 * $Id: searchinfo.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: searchinfo.cpp,v $
 * Revision 1.8  2003/07/14 19:14:45  dipesh
 * display multible filenames as tooltip
 *
 * Revision 1.7  2003/07/09 12:33:29  dipesh
 * Sorry, fixed a little typo
 *
 * Revision 1.6  2003/07/08 16:51:29  dipesh
 * Better handling of multible filenames
 *
 * Revision 1.5  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.4  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.3  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.2  2003/05/17 17:27:22  dipesh
 * More search-stuff; added avaibility-column, use the listfont, some smaller fixes
 *
 * Revision 1.1  2003/05/11 08:33:01  dipesh
 * Added initial Search-functionality.
 *
 *
 */

#include "searchinfo.h"

SearchInfo::SearchInfo(int id)
{
    num = id;
    results.setAutoDelete(true);
}

int SearchInfo::searchNo() const { return num; }
const QIntDict<ResultInfo>& SearchInfo::searchResults() const { return results; }
void SearchInfo::addResult(ResultInfo* result) { results.replace(result->resultNo(), result); }

ResultInfo::ResultInfo(DonkeyMessage* msg)
{
    int i;

    num = msg->readInt32();
    net = msg->readInt32();

    QString s;
    for (i = msg->readInt16(); i; i--) {
        s = msg->readString();
        names.append(s);
        if (name.length() < s.length()) name = s;
    }

    md4 = QByteArray(16);
    for (i=0; i<16; i++) {
        md4[i] = msg->readInt8();
    }

    size = msg->readInt32();
    format = msg->readString();
    t = msg->readString();

    for (i = msg->readInt16(); i; i--) {
        msg->readTag(tags);
    }

    comment = msg->readString();
    already_done = msg->readInt8() > 0;
}

ResultInfo::~ResultInfo()
{
}

int ResultInfo::resultNo() const { return num; }
const QString& ResultInfo::resultName() const { return name; }
const QStringList& ResultInfo::resultNames() const { return names; }
int32 ResultInfo::resultSize() const { return size; }
int32 ResultInfo::resultNetwork() const { return net; }
const QString& ResultInfo::resultFormat() const { return format; }
const QMap<QString,QVariant>& ResultInfo::resultTags() const { return tags; }
const QString& ResultInfo::resultComment() const { return comment; }
const QByteArray& ResultInfo::resultMD4() const { return md4; }
bool ResultInfo::resultAlreadyDone() const { return already_done; }
