/*
 * $Id: shareinfo.cpp,v 1.3 2003/06/30 14:53:42 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: shareinfo.cpp,v $
 * Revision 1.3  2003/06/30 14:53:42  gibreel
 * Still hunting bugs in source management: implemented a lot of missing
 * message handlers pertaining to cleanup of client records. Quite a few bug
 * fixes. Protocol object now emits *Removed() signals corresponding to
 * *Updated() signals instead of sending update signals for removed records and
 * leaving the user to determine whether to remove the records.
 *
 * Revision 1.2  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.1  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 */


#include "shareinfo.h"



ShareInfo::ShareInfo(DonkeyMessage* msg, int)
{
    num = msg->readInt32();
    network = msg->readInt32();
    name = msg->readString();
    size = (int64)msg->readInt32();
    uploaded = msg->readInt64();
    requests = msg->readInt32();
    md4 = QByteArray(16);
    if (msg->opcode() >= 48)
        for (int i = 0; i < 16; i++)
            md4[i] = msg->readInt8();
}

ShareInfo::~ShareInfo()
{
}

void ShareInfo::updateShare(DonkeyMessage* msg, int)
{
    uploaded = msg->readInt64();
    requests = msg->readInt32();
}

const int ShareInfo::shareNo() { return num; }
const int ShareInfo::shareNetwork() { return network; }
const QString& ShareInfo::shareName() { return name; }
const int64 ShareInfo::shareSize() { return size; }
const int64 ShareInfo::shareUploaded() { return uploaded; }
const int ShareInfo::shareRequests() { return requests; }
const QByteArray& ShareInfo::shareMD4() { return md4; }
