/* -*- c++ -*-
 *
 * $Id: shareinfo.h,v 1.4 2003/07/23 18:06:12 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: shareinfo.h,v $
 * Revision 1.4  2003/07/23 18:06:12  gibreel
 * Added API doc generation using the KDE doc generation build system. Briefly
 * documented as many classes as necessary to produce useful documentation.
 *
 * Revision 1.3  2003/06/30 14:53:42  gibreel
 * Still hunting bugs in source management: implemented a lot of missing
 * message handlers pertaining to cleanup of client records. Quite a few bug
 * fixes. Protocol object now emits *Removed() signals corresponding to
 * *Updated() signals instead of sending update signals for removed records and
 * leaving the user to determine whether to remove the records.
 *
 * Revision 1.2  2003/06/13 18:20:02  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.1  2003/03/23 23:34:59  gibreel
 * A lot of API additions, especially lists keeping track of shared files and
 * clients.
 *
 */

#ifndef __libkmldonkey_shareinfo_h__
#define __libkmldonkey_shareinfo_h__

#include <qstring.h>
#include "donkeymessage.h"

//! Representation of a shared file.

class ShareInfo
{

    public:

    ShareInfo(DonkeyMessage* msg, int proto);
    ~ShareInfo();

    void updateShare(DonkeyMessage* msg, int proto);

    //! The numerical ID of the share.
    const int shareNo();
    //! The network the file is being shared on.
    const int shareNetwork();
    //! The file name of the share.
    const QString& shareName();
    //! The size of the shared file, in bytes.
    const int64 shareSize();
    //! The number of bytes uploaded to clients.
    const int64 shareUploaded();
    //! The number of requests received for this share.
    const int shareRequests();
    //! The MD4 hash of the shared file.
    const QByteArray& shareMD4();

private:

    int num, network;
    QString name;
    int64 size, uploaded;
    int requests;
    QByteArray md4;
};

#endif
