#!/usr/bin/perl

# Copyright 2000-2002 Katipo Communications
#
# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# Koha is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Koha; if not, write to the Free Software Foundation, Inc., 59 Temple Place,
# Suite 330, Boston, MA  02111-1307 USA

use strict;
use CGI;
use C4::Auth;
use C4::Context;
use C4::Output;
use C4::Interface::CGI::Output;
use C4::Circulation::Circ2;
use HTML::Template;

# Fixed variables
my $linecolor1='#ffffcc';
my $linecolor2='white';
my $backgroundimage="/images/background-mem.gif";
my $script_name="/cgi-bin/koha/admin/branches.pl";
my $pagepagesize=20;


#######################################################################################
# Main loop....
my $input = new CGI;
my $minlocation=$input->param('minlocation');
my $maxlocation=$input->param('maxlocation');
$maxlocation=$minlocation.'Z' unless $maxlocation;
my $datelastseen = $input->param('datelastseen');
my $offset = $input->param('offset');
my $markseen = $input->param('markseen');
$offset=0 unless $offset;
my $pagesize = $input->param('pagesize');
$pagesize=20 unless $pagesize;

my ($template, $borrowernumber, $cookie)
    = get_template_and_user({template_name => "reports/inventory.tmpl",
			     query => $input,
			     type => "intranet",
			     authnotrequired => 0,
			     flagsrequired => {editcatalogue => 1},
			     debug => 1,
			     });
$template->param(minlocation => $minlocation,
				maxlocation => $maxlocation,
				offset => $offset,
				pagesize => $pagesize,
				datelastseen => $datelastseen,
				);
if ($markseen) {
	foreach my $field ($input->param) {
		if ($field =~ /SEEN-(.*)/) {
			&itemseen($1);
		}
	}
}
if ($minlocation) {
	my $res = C4::Circulation::Circ2::listitemsforinventory($minlocation,$maxlocation,$datelastseen,$offset,$pagesize);
	$template->param(loop =>$res,
					nextoffset => ($offset+$pagesize),
					prevoffset => ($offset?$offset-$pagesize:0),
					);
}
output_html_with_http_headers $input, $cookie, $template->output;

# Local Variables:
# tab-width: 8
# End:
