#!/usr/bin/perl
use strict;
require Exporter;

use C4::Auth;
use C4::Interface::CGI::Output;
use C4::Context;
use CGI;
use C4::Database;
use HTML::Template;
use C4::SearchMarc;
use C4::Acquisition;
use C4::Biblio;
# use C4::Search;

my $classlist='';

my $dbh=C4::Context->dbh;
my $sth=$dbh->prepare("select description,itemtype from itemtypes order by description");
$sth->execute;
while (my ($description,$itemtype) = $sth->fetchrow) {
    $classlist.="<option value=\"$itemtype\">$description</option>\n";
}


my $query = new CGI;
my $op = $query->param("op");
my $type=$query->param('type');

my $startfrom=$query->param('startfrom');
$startfrom=0 if(!defined $startfrom);
my ($template, $loggedinuser, $cookie);
my $resultsperpage;
my $searchdesc;

if ($op eq "do_search") {
	my @marclist = $query->param('marclist');
	my @and_or = $query->param('and_or');
	my @excluding = $query->param('excluding');
	my @operator = $query->param('operator');
	my @value = $query->param('value');
	my $orderby = $query->param('orderby');
	my $desc_or_asc = $query->param('desc_or_asc');
	my $exactsearch = $query->param('exact');

	for (my $i=0;$i<=$#marclist;$i++) {
		if ($searchdesc) { # don't put the and_or on the 1st search term
			$searchdesc .= $and_or[$i].$excluding[$i]." ".($marclist[$i]?$marclist[$i]:"*").$operator[$i].$value[$i] if ($value[$i]);
		} else {
			$searchdesc = $excluding[$i].($marclist[$i]?$marclist[$i]:"*").$operator[$i].$value[$i] if ($value[$i]);
		}
	}
	$resultsperpage= $query->param('resultsperpage');
	$resultsperpage = 19 if(!defined $resultsperpage);
	
	if ($exactsearch) {
		foreach (@operator) {
			$_='=';
		}
	}
	# builds tag and subfield arrays
	my @tags;

	foreach my $marc (@marclist) {
		if ($marc) {
			my ($tag,$subfield) = MARCfind_marc_from_kohafield($dbh,$marc,'');
			if ($tag) {
				push @tags,$dbh->quote("$tag$subfield");
			} else {
				push @tags, $dbh->quote(substr($marc,0,4));
			}
		} else {
			push @tags, "";
		}
	}
	findseealso($dbh,\@tags);
	my ($results,$total) = catalogsearch($dbh, \@tags,\@and_or,
										\@excluding, \@operator, \@value,
										$startfrom*$resultsperpage, $resultsperpage,$orderby,$desc_or_asc);
	if ($total ==1) {
	if (C4::Context->preference("BiblioDefaultView") eq "normal") {
	     print $query->redirect("/cgi-bin/koha/opac-detail.pl?bib=".@$results[0]->{biblionumber});
	} elsif (C4::Context->preference("BiblioDefaultView") eq "marc") {
	     print $query->redirect("/cgi-bin/koha/opac-MARCdetail.pl?bib=".@$results[0]->{biblionumber});
	} else {
	     print $query->redirect("/cgi-bin/koha/opac-ISBDdetail.pl?bib=".@$results[0]->{biblionumber});
	}
	exit;
	}
	($template, $loggedinuser, $cookie)
		= get_template_and_user({template_name => "opac-searchresults.tmpl",
				query => $query,
				type => 'opac',
				authnotrequired => 1,
				debug => 1,
				});

	# multi page display gestion
	my $displaynext=0;
	my $displayprev=$startfrom;
	if(($total - (($startfrom+1)*($resultsperpage))) > 0 ){
		$displaynext = 1;
	}

	my @field_data = ();


	for(my $i = 0 ; $i <= $#marclist ; $i++)
	{
		push @field_data, { term => "marclist", val=>$marclist[$i] };
		push @field_data, { term => "and_or", val=>$and_or[$i] };
		push @field_data, { term => "excluding", val=>$excluding[$i] };
		push @field_data, { term => "operator", val=>$operator[$i] };
		push @field_data, { term => "value", val=>$value[$i] };
	}
	push @field_data, {term => "desc_or_asc", val => $desc_or_asc} if $desc_or_asc;
	push @field_data, {term => "orderby", val => $orderby} if $orderby;
	my @numbers = ();

	if ($total>$resultsperpage)
	{
		for (my $i=1; $i<$total/$resultsperpage+1; $i++)
		{
			if ($i<16)
			{
	    		my $highlight=0;
	    		($startfrom==($i-1)) && ($highlight=1);
	    		push @numbers, { number => $i,
					highlight => $highlight ,
					searchdata=> \@field_data,
					startfrom => ($i-1)};
			}
    	}
	}

	my $from = $startfrom*$resultsperpage+1;
	my $to;

 	if($total < (($startfrom+1)*$resultsperpage))
	{
		$to = $total;
	} else {
		$to = (($startfrom+1)*$resultsperpage);
	}
	my $defaultview = 'BiblioDefaultView'.C4::Context->preference('BiblioDefaultView');
	$template->param(results => $results,
							startfrom=> $startfrom,
							displaynext=> $displaynext,
							displayprev=> $displayprev,
							resultsperpage => $resultsperpage,
							orderby => $orderby,
							startfromnext => $startfrom+1,
							startfromprev => $startfrom-1,
							searchdata=>\@field_data,
							total=>$total,
							from=>$from,
							to=>$to,
							numbers=>\@numbers,
							searchdesc=> $searchdesc,
							$defaultview => 1,
							suggestion => C4::Context->preference("suggestion"),
							virtualshelves => C4::Context->preference("virtualshelves"),
							);

} else {
	($template, $loggedinuser, $cookie)
		= get_template_and_user({template_name => "opac-search.tmpl",
					query => $query,
					type => "opac",
					authnotrequired => 1,
				});
	
	
	$sth=$dbh->prepare("Select itemtype,description from itemtypes order by description");
	$sth->execute;
	my  @itemtype;
	my %itemtypes;
	push @itemtype, "";
	$itemtypes{''} = "";
	while (my ($value,$lib) = $sth->fetchrow_array) {
		push @itemtype, $value;
		$itemtypes{$value}=$lib;
	}
	
	my $CGIitemtype=CGI::scrolling_list( -name     => 'value',
				-values   => \@itemtype,
				-labels   => \%itemtypes,
				-size     => 1,
				-multiple => 0 );
	$sth->finish;
	
	my @branches;
	my @select_branch;
	my %select_branches;
	my ($count2,@branches)=branches();
	push @select_branch, "";
	$select_branches{''} = "";
	for (my $i=0;$i<$count2;$i++){
		push @select_branch, $branches[$i]->{'branchcode'};#
		$select_branches{$branches[$i]->{'branchcode'}} = $branches[$i]->{'branchname'};
	}
	my $CGIbranch=CGI::scrolling_list( -name     => 'value',
				-values   => \@select_branch,
				-labels   => \%select_branches,
				-size     => 1,
				-multiple => 0 );
	$sth->finish;
    
	$template->param('Disable_Dictionary'=>C4::Context->preference("Disable_Dictionary")) if (C4::Context->preference("Disable_Dictionary"));
	$template->param(classlist => $classlist,
					CGIitemtype => $CGIitemtype,
					CGIbranch => $CGIbranch,
					suggestion => C4::Context->preference("suggestion"),
					virtualshelves => C4::Context->preference("virtualshelves"),
	);
}

output_html_with_http_headers $query, $cookie, $template->output;
