#!/usr/bin/perl
use strict;
require Exporter;
use CGI;
use HTML::Template;

use C4::Auth;       # get_template_and_user
use C4::Acquisition;       # get_template_and_user
use C4::Interface::CGI::Output;
use C4::Koha;

my $input = new CGI;
my ($template, $borrowernumber, $cookie)
    = get_template_and_user({template_name => "opac-recacquisitions.tmpl",
			     type => "opac",
			     query => $input,
			     authnotrequired => 1,
			     flagsrequired => {borrow => 1},
			 });
my $dbh = C4::Context->dbh;
my $query="Select itemtype,description from itemtypes order by description";
my $sth=$dbh->prepare($query);
$sth->execute;
my  @itemtype;
my %itemtypes;
push @itemtype, "";
$itemtypes{''}="Any Document Type";
while (my ($value,$lib) = $sth->fetchrow_array) {
	push @itemtype, $value;
	$itemtypes{$value}=$lib;
}

my $CGIitemtype=CGI::scrolling_list( -name     => 'value',
			-values   => \@itemtype,
			-labels   => \%itemtypes,
			-size     => 1,
			-multiple => 0 );
$sth->finish;

my @branches;
my @select_branch;
my %select_branches;
my $branches = getallbranches();
my @branchloop;
foreach my $thisbranch (keys %$branches) {
        my $selected = 1 if (C4::Context->userenv && ($thisbranch eq C4::Context->userenv->{branch}));
        my %row =(value => $thisbranch,
                                selected => $selected,
                                branchname => $branches->{$thisbranch}->{'branchname'},
                        );
        push @branchloop, \%row;
}



# my $borrower = getmember('',$borrowernumber);
my @options;
my $counter=0;
$template->param(CGIitemtype => $CGIitemtype,
				branchloop=>\@branchloop
);
output_html_with_http_headers $input, $cookie, $template->output;
