#!/usr/bin/perl
use strict;
require Exporter;
use CGI;

use C4::Auth;
use C4::Koha;
use C4::Circulation::Circ2;
use C4::Reserves2;
use C4::Search;
use C4::Interface::CGI::Output;
use HTML::Template;
use C4::Date;

my $query = new CGI;
my ($template, $borrowernumber, $cookie) 
    = get_template_and_user({template_name => "opac-user.tmpl",
			     query => $query,
			     type => "opac",
			     authnotrequired => 0,
			     flagsrequired => {borrow => 1},
			     debug => 1,
			     });

# get borrower information ....
my ($borr, $flags) = getpatroninformation(undef, $borrowernumber);

$borr->{'dateenrolled'} = format_date($borr->{'dateenrolled'});
$borr->{'expiry'}       = format_date($borr->{'expiry'});
$borr->{'dateofbirth'}  = format_date($borr->{'dateofbirth'});
$borr->{'ethnicity'}    = fixEthnicity($borr->{'ethnicity'});

if($borr->{'debarred'} || $borr->{'gonenoaddress'} || $borr->{'lost'}){
	$borr->{'flagged'} =1;
}

if ($borr->{'amountoutstanding'} > 5) {
    $borr->{'amountoverfive'} = 1;
}
if (5 >= $borr->{'amountoutstanding'} && $borr->{'amountoutstanding'} > 0 ) {
    $borr->{'amountoverzero'} = 1;
}
if ($borr->{'amountoutstanding'} < 0) {
    $borr->{'amountlessthanzero'} = 1;
    $borr->{'amountoutstanding'} = -1*($borr->{'amountoutstanding'});
}

$borr->{'amountoutstanding'} = sprintf "%.02f", $borr->{'amountoutstanding'};

my @bordat;
$bordat[0] = $borr;

$template->param(BORROWER_INFO => \@bordat);
$template->param(borrowernumber => $borrowernumber);

#get issued items ....
my $issues = getissues($borr);

my $count = 0;
my $overdues_count = 0;
my @overdues;
my @issuedat;
foreach my $key (keys %$issues) {
    my $issue = $issues->{$key};
    $issue->{'date_due'}  = format_date($issue->{'date_due'});

    # check for reserves
    my ($restype, $res) = CheckReserves($issue->{'itemnumber'});
    if ($restype) {
	$issue->{'reserved'} = 1;
    }

    my ($numaccts,$accts,$total) = getboracctrecord(undef,$borr);
    my $charges = 0;
    foreach my $ac (@$accts) {
	if ($ac->{'itemnumber'} == $issue->{'itemnumber'}) {
	    $charges += $ac->{'amountoutstanding'} if $ac->{'accounttype'} eq 'F'; 
	    $charges += $ac->{'amountoutstanding'} if $ac->{'accounttype'} eq 'L';
	} 
    }
    $issue->{'charges'} = $charges;

    # get publictype for icon
    
    my $publictype = $issue->{'publictype'};
    $issue->{$publictype} = 1;

    # check if item is renewable
    my %env;
    my $status = renewstatus(\%env,$borrowernumber, $issue->{'itemnumber'});

    $issue->{'status'} = $status;

    if ($issue->{'overdue'}) {
	push @overdues, $issue;
	$overdues_count++;
	$issue->{'overdue'} = 1;
    } else {
	$issue->{'issued'} = 1;
    }
    push @issuedat, $issue;
    $count++;
}

$template->param(ISSUES => \@issuedat);
$template->param(issues_count => $count);

$template->param(OVERDUES => \@overdues);
$template->param(overdues_count => $overdues_count);

my $branches = getbranches();

# now the reserved items....
my ($rcount, $reserves) = FindReserves(undef, $borrowernumber);
foreach my $res (@$reserves) {
    $res->{'reservedate'}  = format_date($res->{'reservedate'});
    my $publictype = $res->{'publictype'};
    $res->{$publictype} = 1;
    $res->{'waiting'} = 1 if $res->{'found'} eq 'W';
    $res->{'branch'} = $branches->{$res->{'branchcode'}}->{'branchname'};
}

$template->param(RESERVES => $reserves);
$template->param(reserves_count => $rcount);

my @waiting;
my $wcount = 0;
foreach my $res (@$reserves) {
    if ($res->{'itemnumber'}) {
	my $item = getiteminformation('',$res->{'itemnumber'},'');
	$res->{'holdingbranch'} = $branches->{$item->{'holdingbranch'}}->{'branchname'};
	$res->{'branch'} = $branches->{$res->{'branchcode'}}->{'branchname'};
	if($res->{'holdingbranch'} eq $res->{'branch'}){
			$res->{'atdestination'} = 1;
		}
	push @waiting, $res;
	$wcount++;
    }
}

$template->param(WAITING => \@waiting);
$template->param(waiting_count => $wcount,
				textmessaging => $borr->{textmessaging},
				OpacPasswordChange => C4::Context->preference("OpacPasswordChange"),
				opaclargeimage => C4::Context->preference("opaclargeimage"),
                LibraryName => C4::Context->preference("LibraryName"),
                OpacNav => C4::Context->preference("OpacNav"),
                opaccredits => C4::Context->preference("opaccredits"),
                opacreadinghistory => C4::Context->preference("opacreadinghistory"),
                opacsmallimage => C4::Context->preference("opacsmallimage"),
                opaclayoutstylesheet => C4::Context->preference("opaclayoutstylesheet"),
                opaccolorstylesheet => C4::Context->preference("opaccolorstylesheet"),
                opaclanguagesdisplay => C4::Context->preference("opaclanguagesdisplay"),
				opacbookbag => C4::Context->preference("opacbookbag"),

);

output_html_with_http_headers $query, $cookie, $template->output;

