/*  Programik do gry w kropki; kro83.cc - glowny plik.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006 Bartek Dyda <bkropki@yahoo.co.uk>.
 *
 *  Some ideas by Rafal Pikula (1999,2001,2002,2003,2004,2005,2006)
 *
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#define WERSJA_KROPEK 83
#define WERSJA_KROPEK_LOW 39

// To potrzebne tez w pla_skl.h; odejmij 13 zeby dostac max. glebokosc analizy bez rozszerzen
//#define MAX_GLEB_ANALIZY (13+8+4+1)
// Nie mozna przesadzac z uwagi na (np.) historia_waga

//Wersja do rozgrywania turniejow w trybie tekstowym: wlacz TEKSTOWY
//#define TEKSTOWY

// super-stopery:
//#define SA_STOPERY

//#define NTEST  (dawno niesprawdzana opcja)

// wylaczona SZYBKOSC daje mozliwosc sprawdzania zakresu w WezUC itp.
// ale spowalnia (dawno niesprawdzana opcja)
#define SZYBKOSC

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <assert.h>  // assert()
//#define assert(p) ;
#include <values.h>  // MAXLONG

#ifdef TEKSTOWY
 #define GrFlush()
#endif

#ifndef USTALONA_WLK_PLANSZY
unsigned short int wlkx=20;
unsigned short int wlky=20;
unsigned int wlkx4wlky4= (20+4)*(20+4);
#endif

#include "ekro.h"
// klasa "TPlansze", obiekt "plansze":
// klasa "TSkladowe", obiekt "skladowe":
// klasa "TTabliceLI", obiekt "tabliceLI":
TSkladowe skladowe;
TPlansze  plansze;
TTabliceLI tabliceLI;
Tup       up;   // ustalone pomocnicze
//
TSlowa slowa;
TStatystykaDlaAnalizy  statystyka_dla_analizy;
TStatystyki   statystyki_prog;
#ifndef TEKSTOWY
  char nazwa_pliku_pomocy[256];
#endif
#include "sstop3.cc"

unsigned long int zobrist[0x8000];
unsigned long long int zobrist2[0x8000];

struct TDwaUC
  {
  unsigned char x,y;
  int operator!=(TDwaUC p)
	 { return (this->x!=p.x || this->y!=p.y); };
  int operator==(TDwaUC p)
	 { return (this->x==p.x && this->y==p.y); };
  TDwaUC(unsigned char nx, unsigned char ny) { x=nx; y=ny; };
  TDwaUC() { ; };
  };

struct TRuch  { unsigned char x,y; long int ocena; };

TGra gra;
TEkran ekran;
TParametryGry pargry;
TStoper stoper[3];   // gracza 0, gracza 1, ogolny

//**************************** POCZWORNY STOS/KOLEJKA (KOLEJKA PRIORYTETOWA)
struct TStos4 {
  krint *stos[4];
  int   pocz[4],kon[4];
  TStos4();
  ~TStos4();
  void Wyczysc();
  };

TStos4::TStos4()
{
 for (int i=0; i<4; i++) {
   if ((stos[i] = (krint*) malloc(sizeof(krint)*2*max_powierzchnia_planszy)) ==NULL)
     {
       printf("Stos4[%d]: Za malo pamieci.",i);
       abort();
     }
 }
 Wyczysc();
}

TStos4::~TStos4()
{ for (int i=0; i<4; i++) free(stos[i]); }

void TStos4::Wyczysc()
{ pocz[0]=pocz[1]=pocz[2]=pocz[3]=max_powierzchnia_planszy;
  kon[0] =kon[1] =kon[2] =kon[3] =max_powierzchnia_planszy; }
//**************************** POCZWORNY STOS/KOLEJKA (KOLEJKA PRIORYTETOWA)
TStos4 q4;

//*************************************** TABLICA MIESZAJACA Z
// nowa tablica mieszajaca z kluczami Zobrista
//int HTABZ_ILE_TAB_WYKL = 16;
//int HTABZ_ILE_TAB      = (1<<HTABZ_ILE_TAB_WYKL);
int HTABZ_ILE_TAB      = (1<<16);
int HTABZ_MASKA        = (HTABZ_ILE_TAB-1);
#define HTABZ_PROG  10000;


struct HTablicaZKl {
  unsigned long long klucz;
  long int ocena;
  unsigned long  int czas; 
  unsigned short int niepotrzebne_pole;
  unsigned char gleb_i_rodzaj;
  unsigned char zobrist1;
  short int prop[2];
};
  
class HTablicaZ {
  HTablicaZKl *klucze;
  unsigned long  int akt_czas;
  unsigned long  int nieprzeterm; 
  unsigned long  int nieprz_poczan; 
  int czas_prog;
public:
  HTablicaZ();
  ~HTablicaZ();
  void PrzydzielPamiec();
  long int Wez(unsigned long long kl, unsigned long int klzob, int &rodzaj, 
	       unsigned short int &prop0, unsigned short int &prop1, int od_liscia);
  void Wstaw(unsigned long long kl, unsigned long int klzob, int gleb, long int ocena, int rodzaj, 
	     unsigned short int prop0, unsigned short int prop1, int od_liscia);
  void AnulujWpisy();
  void NowaGlebokosc();
  unsigned long int DajAktCzas() { return akt_czas; };
} htablicaZ;

HTablicaZ::HTablicaZ()
{
  klucze=NULL;
  akt_czas=1;
  nieprzeterm=1;
  nieprz_poczan=1;
  czas_prog=HTABZ_PROG;
}

void HTablicaZ::PrzydzielPamiec()
{
  long int pam = sizeof(HTablicaZKl) * HTABZ_ILE_TAB*2;
  klucze = (HTablicaZKl*) malloc(pam);
  assert(klucze!=NULL);
  // memset(klucze, 0, pam);
  for (int i=0; i<HTABZ_ILE_TAB*2; i++)
    klucze[i].czas=0;
}

inline HTablicaZ::~HTablicaZ() { free(klucze); }

inline void HTablicaZ::AnulujWpisy()  
{ 
  if (akt_czas > 1000000000) {  // zabezpieczenie np. przy b. dlugim turnieju
    for (int i=0; i<HTABZ_ILE_TAB*2; i++)
      klucze[i].czas=0;
    akt_czas=0;
  }
  nieprzeterm  = nieprz_poczan = ++akt_czas;
  akt_czas++;
  czas_prog=HTABZ_PROG;
}

inline void HTablicaZ::NowaGlebokosc()  
{ 
  nieprzeterm  = ++akt_czas;
  akt_czas++;
  czas_prog=HTABZ_PROG;
}

long int HTablicaZ::Wez(unsigned long long kl, unsigned long int klzob, int &rodzaj, 
			unsigned short int &prop0, unsigned short int &prop1,
			int od_liscia)
// od_liscia = ost_gleb-akt_gleb
// zwraca MAXLONG, gdy pozycji nie ma
// 2 dolne bity rodzaj: = 0: ocena dokladna; =1: ograniczenie dolne; =2: ograniczenie gorne
//    (np. =1 oznacza, ze prawdziwa ocena jest >= zwroconej oceny)
// rodzaj & 4  : czy jest ocena (czyli czy zwraca cos !=MAXLONG)
// gornych 5 bitow wyzerowanych
{
  STOPER_START_ZWEZ;
  int nr_tab = (klzob & HTABZ_MASKA) << 1;
  HTablicaZKl *k = &klucze[nr_tab];
  for (int i=0; i<2; i++)
    if (k[i].klucz==kl && k[i].zobrist1==(klzob>>24)) {
      // klucz jest, spr. czy nieprzeterminowany
      if (k[i].czas >= nieprzeterm) {
	rodzaj = ((k[i].gleb_i_rodzaj & 3) | 4);
	prop0 = k[i].prop[0];   prop1 = k[i].prop[1];
	STOPER_STOP_ZWEZ;
	return k[i].ocena;
      }
      else {  // klucz przeterminowany 
	if (k[i].czas >= nieprz_poczan) {
	  prop0 = k[i].prop[0];   prop1 = k[i].prop[1];
	  rodzaj = (k[i].gleb_i_rodzaj & 3);   // pokaz, jak wartosciowe sa propozycje (rodzaj==0: wartosciowe)
	}
	else { prop0 = prop1 =0;    rodzaj=0; }
	STOPER_STOP_ZWEZ;  
	return MAXLONG; 
      }
    }
  rodzaj=0;
  prop0 = prop1 = 0;
  STOPER_STOP_ZWEZ;
  return MAXLONG;  // klucza w ogole nie ma
}
    
void HTablicaZ::Wstaw(unsigned long long kl, unsigned long int klzob, int gleb, long int ocena, int rodzaj, 
		      unsigned short int prop0, unsigned short int prop1,
		      int od_liscia)
// od_liscia = ost_gleb-akt_gleb
// wstaw z preferencja najnizszych glebokosci klucza dla gleb<=6,
// dla glebszych preferowane nowsze klucze;
// mozna to zmienic...
{
  STOPER_START_ZWST;
  //assert(prop0<wlkx4wlky4 && prop1<wlkx4wlky4);
  //assert(prop0==0 || (prop0!=prop1));
  int nr_tab = (klzob & HTABZ_MASKA) << 1;
  HTablicaZKl *k = &klucze[nr_tab];
  for (int i=0; i<2; i++)
    if (k[i].klucz==kl && k[i].zobrist1==(klzob>>24)) {
      // klucz jest, wstaw nowa ocene i rodzaj
      if (k[i].czas >= nieprz_poczan) {
	// dodaj propozycje
	if (prop0) 
	  if (prop0!=k[i].prop[0])
	    {
	      k[i].prop[1] = prop1 ? prop1 : k[i].prop[0];
	      k[i].prop[0] = prop0;
	    }
	  else if (prop1)
	    k[i].prop[1] = prop1;
      }
      else { k[i].prop[0] = prop0;   k[i].prop[1] = prop1; }
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (gleb<<2)+rodzaj;
      statystyki_prog.ht_kolizja[0]++;
      STOPER_STOP_ZWST;
      return;
    }
  // klucza nie ma, spr. czy moze jest jakis przeterminowany
  for (int i=0; i<2; i++)
    if (k[i].czas < nieprz_poczan) {
      k[i].klucz = kl;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (gleb<<2)+rodzaj;
      k[i].zobrist1      = (klzob >> 24);
      k[i].prop[0] = prop0;   k[i].prop[1] = prop1;
      statystyki_prog.ht_kolizja[0]++;
      STOPER_STOP_ZWST;
      return;
    }
  // a moze jest jakis czesciowo przeterminowany
  for (int i=0; i<2; i++)
    if (k[i].czas < nieprzeterm &&
	k[i].gleb_i_rodzaj >= (7<<2)) {
      k[i].klucz = kl;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (gleb<<2)+rodzaj;
      k[i].zobrist1      = (klzob >> 24);
      k[i].prop[0] = prop0;   k[i].prop[1] = prop1;
      statystyki_prog.ht_kolizja[1]++;
      STOPER_STOP_ZWST;
      return;
    }
  // nie sa przeterminowane
  // moze jest jakis glebszy od akt. ?
  // (tutaj mozliwe inne strategie)
  if (gleb<=6) {
  int ag = (gleb<<2)+rodzaj;
  if (k[0].gleb_i_rodzaj > k[1].gleb_i_rodzaj)
    if (k[0].gleb_i_rodzaj > ag) {
      // wstaw
      k[0].klucz = kl;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[0].czas  = akt_czas;
      k[0].ocena = ocena;
      k[0].gleb_i_rodzaj = ag;
      k[0].zobrist1      = (klzob >> 24);
      k[0].prop[0] = prop0;   k[0].prop[1] = prop1;
      statystyki_prog.ht_kolizja[2]++;
      STOPER_STOP_ZWST;
      return;
    }
    else if (k[1].gleb_i_rodzaj > ag) {
       // wstaw
      k[1].klucz = kl;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[1].czas  = akt_czas;
      k[1].ocena = ocena;
      k[1].gleb_i_rodzaj = ag;
      k[1].zobrist1      = (klzob >> 24);
      k[1].prop[0] = prop0;   k[1].prop[1] = prop1;
      statystyki_prog.ht_kolizja[2]++;
      STOPER_STOP_ZWST;
      return;
    }
  }
  else
    { // ruch o gleb >=7
    int nr;
    if (k[0].gleb_i_rodzaj >= (8<<2))      // zastepujemy tylko klucze na gleb >=7+1=8
      if (k[1].gleb_i_rodzaj >= (8<<2))    // mamy dwoch kandydatow
	nr= (k[0].czas >= k[1].czas);  // wybierz starszego z kandydatow
      else nr=0;   // jeden kandydat, nr 0
    else
      if (k[1].gleb_i_rodzaj >= (8<<2))
	nr=1;
      else { statystyki_prog.ht_kolizja[3]++; STOPER_STOP_ZWST; return; } // nie ma kandydatow
    // wstaw
    k[nr].klucz = kl;
    if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
    k[nr].czas  = akt_czas;
    k[nr].ocena = ocena;
    k[nr].gleb_i_rodzaj = (gleb<<2)+rodzaj;
    k[nr].zobrist1      = (klzob >> 24);
    k[nr].prop[0] = prop0;   k[nr].prop[1] = prop1;
    statystyki_prog.ht_kolizja[2]++;
    STOPER_STOP_ZWST;
    return;
  }

  statystyki_prog.ht_kolizja[3]++;
  STOPER_STOP_ZWST;
}
//*************************************** TABLICA MIESZAJACA Z -- koniec

#ifdef SZYBKOSC
#define WezUC(t,x,y)  ((t)[(x)*(wlky+4)+(y)])
#define WezUI(t,x,y)  ((t)[(x)*(wlky+4)+(y)])
#define WezIndeksTab(x,y)  ((x)*(wlky+4)+(y))
#else

inline unsigned char& static WezUC(unsigned char* tab, int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("UC: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return tab[x*(wlky+4)+y]; }

inline unsigned int static WezIndeksTab(int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("IT: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return x*(wlky+4)+y; }

inline krint& static WezUI(unsigned int* tab, int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("UI: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return tab[x*(wlky+4)+y]; }
#endif  // ifdef SZYBKOSC

unsigned long int bseed1=0;
unsigned long int bseed2=0;

unsigned short int random(unsigned short int n)
{
 bseed1 = ((bseed1 << 12 ) + 150889) % 714025;
 bseed2 = ((bseed2 * 1597) + 51749 ) % 244944;
 return (bseed1 + bseed2) % n;
}

void brandomize()
{
 struct timeval czas;
 gettimeofday(&czas, NULL);
 bseed1 = czas.tv_sec % 714025;    // liczby 714025 i 244944
 bseed2 = czas.tv_sec % 244944;    // sa wzglednie pierwsze!
}

void UstawZobrist()
{
  unsigned long int bs1 = bseed1, bs2 = bseed2;
  bseed1 = 2005;  bseed2=44441;
  zobrist[0]=0;  zobrist2[0]=0;
  for (int i=1; i<sizeof(zobrist)/sizeof(zobrist[0]); i++) {
    zobrist[i] = random(4096);
    zobrist[i] <<= 11;
    zobrist[i] |= random(2048);
    zobrist[i] <<= 9;    
    zobrist[i] |= random(512);
    zobrist2[i] = random(1024);
    for (int j=0; j<6; j++) {
      zobrist2[i] <<= 9;
      zobrist2[i] |=  random(512);
    }
  }
  bseed1=bs1;  bseed2=bs2;
}

unsigned int tablica_kierunkow[9]={7,0,1, 6,8,2, 5,4,3};  // 8=bez sensu
int kierunki_dx[8] = {0,1,1,1, 0,-1,-1,-1};
int kierunki_dy[8] = {-1,-1,0,1, 1,1,0,-1};
void Polacz(unsigned char*tab, int x1, int y1, int x2, int y2)
// laczy kreska dwie (sasiednie) kropki (x1,y1) i (x2,y2)
{
 unsigned int kier=tablica_kierunkow[ (x2-x1) + (y2-y1)*3 +4];
 unsigned char maska=(1<<kier);
 tab[x1*(wlky+4)+y1] |= maska;
 kier^=4;  maska=(1<<kier);
 tab[x2*(wlky+4)+y2] |= maska;
}
int CzyPolaczone(unsigned char*tab, int x1, int y1, int x2, int y2)
// sprawdza czy dwie (sasiednie) kropki (x1,y1) i (x2,y2) sa polaczone
{
 unsigned int kier=tablica_kierunkow[ (x2-x1) + (y2-y1)*3 +4];
 unsigned char maska=(1<<kier);
 return (tab[x1*(wlky+4)+y1] & maska) != 0;
}

inline void static CzyscTablice(unsigned char* tab)
{ STOPER_START_TABL; memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void static CzyscTablice(krint* tab)
{ STOPER_START_TABL; memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void static CzyscTablice(skrint* tab)
{ STOPER_START_TABL;memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void static KopiujTablice(unsigned char* tab, unsigned char* skad)
{ STOPER_START_TABL; memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void static KopiujTablice(krint *tab, krint *skad)
{ STOPER_START_TABL;memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void static KopiujTablice(skrint *tab, skrint *skad)
{ STOPER_START_TABL;memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

int UstawOtoczenie(unsigned char otoczenie[9])
// uklad pol w tablicy otoczenie:
//   0 1 2
//   3 4 5
//   6 7 8.
{
 unsigned char czyja=otoczenie[4];
 // ponumeruj nasze kropki z sasiedztwa
 for (int i=0; i<4; i++)
   if (otoczenie[i]==czyja)
     otoczenie[i]=i+1;
   else
     otoczenie[i]=0;
 for (int i=5; i<9; i++)
   if (otoczenie[i]==czyja)
     otoczenie[i]=i;
   else
     otoczenie[i]=0;
 // teraz znajdz skladowe spojnosci
 int ost=0;
 if (otoczenie[1])
   {
   //if (otoczenie[0]) otoczenie[0]=1;  // -nie trzeba, bo to i tak =0 lub 1
   otoczenie[1]=1;
   if (otoczenie[2]) otoczenie[2]=1;
   if (otoczenie[3]) otoczenie[3]=1;
   if (otoczenie[5]) otoczenie[5]=1;
   ost=1;
   }
 if (otoczenie[3])
   {
   // [0] i [1] nie trzeba zmieniac
   otoczenie[3]=1;
   if (otoczenie[6]) otoczenie[6]=1;
   if (otoczenie[7]) otoczenie[7]=1;
   ost=1;
   }
 if (otoczenie[5])
   {
   if (!otoczenie[1] && (otoczenie[7]!=1)) ost++;
   // [1] nie trzeba zmieniac
   if (otoczenie[2]) otoczenie[2]=ost;
   otoczenie[5]=ost;
   if (otoczenie[7]) otoczenie[7]=ost;
   if (otoczenie[8]) otoczenie[8]=ost;
   }
 if (otoczenie[7]==7)
   {
   ost++;
   // [3] i [5] nie trzeba zmieniac - one sa w tym przypadku =0
   if (otoczenie[6]) otoczenie[6]=ost;
   otoczenie[7]=ost;
   if (otoczenie[8]) otoczenie[8]=ost;
   }
 else
   if (otoczenie[7])
     {
     if (otoczenie[6]) otoczenie[6]=otoczenie[7];
     if (otoczenie[8]) otoczenie[8]=otoczenie[7];
     }
 // ustaw ew. narozniki
 if (otoczenie[0] && !otoczenie[1] && !otoczenie[3])
   otoczenie[0]=++ost;
 if (otoczenie[2]==3)
   otoczenie[2]=++ost;
 if (otoczenie[6]==6)
   otoczenie[6]=++ost;
 if (otoczenie[8]==8)
   otoczenie[8]=++ost;
 return ost;
}

void ZnajdzSkladowa(krint *skl, unsigned char* pl,
                    unsigned int numskl,
                    unsigned int ind)
// [ind] - punkt, ktorego skladowa spojnosci chcemy znalezc
{
 unsigned char czyja = pl[ind];
 skl[ind] =numskl; // punkt p nalezy do swojej skladowej spojnosci
 // wsadz na stos [ind]
 krint *stos = skladowe.PrzydzielSkladowa();
 stos[0] = ind;
 int na_stosie = 1;
 do
   {
   ind = stos[--na_stosie];
   // przejdz punkty obok
   // idz w gore
   { unsigned int nind = ind +W_G;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+= W_DD;   // idz w dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     } }
   // idz w lewo gore
   { unsigned int nind = ind + W_LG;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w lewo
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w lewo dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   }
   // idz w prawo gore
   { unsigned int nind = ind+W_PG;
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w prawo
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   nind+=W_D;  // idz w prawo dol
   if (pl[nind]==czyja && skl[nind]!=numskl)
     {
     skl[nind] = numskl;
     stos[na_stosie++] = nind;
     }
   }
	}
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
}

void WezRozgr23(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3,
                unsigned char *plansz_p)
{
 KopiujTablice(rozgr2, rozgrywka);
 KopiujTablice(rozgr3, rozgrywka);
 for (int i=up.lg; i<=up.pd; i++)
   {
   if (plansz_p[i] & 0x33)  // pole jest wewnatrz stopu
     rozgr2[i]=0;           // wiec usun z niego ew. kropke w rozgr2
   if (plansz_p[i] & 0x5)   // pole jest wewnatrz stopu lub stalego stopu gr1
     rozgr3[i]=1;           // wiec wstaw kropke ,,1'' w rozgr3
   else if (plansz_p[i] & 0xa)
     rozgr3[i]=2;           // ...lub kropke ,,2'', jesli to jest u gracza 2
   }
}

void WezOtoczenie(unsigned char ot[9], int x, int y,
		  unsigned char* plansz_p, unsigned char* rozgrywka,
                  int ktory_gracz)
{
 // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
 ot[0]=(WezUC(plansz_p,x-1,y-1) & 3) ? 0 : WezUC(rozgrywka,x-1,y-1);
 ot[1]=(WezUC(plansz_p,x  ,y-1) & 3) ? 0 : WezUC(rozgrywka,x  ,y-1);
 ot[2]=(WezUC(plansz_p,x+1,y-1) & 3) ? 0 : WezUC(rozgrywka,x+1,y-1);
 ot[3]=(WezUC(plansz_p,x-1,y  ) & 3) ? 0 : WezUC(rozgrywka,x-1,y  );
 ot[4]=ktory_gracz;
 ot[5]=(WezUC(plansz_p,x+1,y  ) & 3) ? 0 : WezUC(rozgrywka,x+1,y  );
 ot[6]=(WezUC(plansz_p,x-1,y+1) & 3) ? 0 : WezUC(rozgrywka,x-1,y+1);
 ot[7]=(WezUC(plansz_p,x  ,y+1) & 3) ? 0 : WezUC(rozgrywka,x  ,y+1);
 ot[8]=(WezUC(plansz_p,x+1,y+1) & 3) ? 0 : WezUC(rozgrywka,x+1,y+1);
}

void WezOtoczenieUlatw(unsigned char ot[9], int x, int y,
                       unsigned char* rozgr2,
		       int ktory_gracz)
{
 ot[0]=WezUC(rozgr2,x-1,y-1);
 ot[1]=WezUC(rozgr2,x  ,y-1);
 ot[2]=WezUC(rozgr2,x+1,y-1);
 ot[3]=WezUC(rozgr2,x-1,y  );
 ot[4]=ktory_gracz;
 ot[5]=WezUC(rozgr2,x+1,y  );
 ot[6]=WezUC(rozgr2,x-1,y+1);
 ot[7]=WezUC(rozgr2,x  ,y+1);
 ot[8]=WezUC(rozgr2,x+1,y+1);
}

int PrzejdzWnetrze(unsigned char *rozgrywka, unsigned char *plansz_p,
                   unsigned char *plan, unsigned int ind, unsigned int &lewo,
                   int kto)
// zwraca 1, jesli jest (staly) stop (dla gracza kto)
// kropki wewnetrzne zostaja zaznaczone ,,1'',
//  (prawdopodobne) brzegowe -- 10,20,30 lub 40
// do ,,lewo'' wstawia indeks punktu brzegowego polozonego najbardziej na lewo
// (i na gorze, tj. o najmniejszym indeksie)
{
 CzyscTablice(plan);
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=1;   // zaznacz jako wnetrze
 int na_stosie=1;
 lewo=ind;
 do{
   ind = stos[--na_stosie];
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + up.dind[k];
     if (rozgrywka[nind]==kto && (plansz_p[nind] & 3)==0)
       {
       plan[nind]+=10;  // kropka brzegowa
       if (nind<lewo) lewo=nind;
       }
     else if (plan[nind]==0)
       {  // pole wewnatrz ew. stopu
       if (upl_marg[nind]<=2)
         {  // jestesmy na brzegu planszy, czyli stopu jednak nie ma
         skladowe.ZwolnijSkladowa(stos);
         return 0;
         }
       stos[na_stosie++]=nind;
       plan[nind]=1;  // zaznacz jako wewnetrzne
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 return 1;
}

int ZnajdzBrzegStopu(krint *dad, unsigned char *plan, unsigned int lewo)
// przechodzi graf w glab, zaczyna przechodzic punkty od najmniej do
// do najbardziej na lewo polozonego punktu
// Idziemy z punktu ,,lewo'', ktory jest punktem brzegowym najbardziej
//   wysunietym na lewo (o najmniejszym indeksie)
// We: plan[...] >= 10 -- pole [...] moze byc na brzegu (przejdz)
// Zwraca dlugosc sciezki (np. dla najprostszego panstwa zwraca 4).
{
 CzyscTablice(dad);
 // inicjacja, przydzial pamieci
 unsigned char *kierunki = plansze.PrzydzielPlansze();
 krint         *q = skladowe.PrzydzielSkladowa();
 int na_stosie=0;
 int kierunki_dind[8];
 for (int i=0; i<8; i++)
   kierunki_dind[i]= kierunki_dx[i]*W_P + kierunki_dy[i]*W_D;
 kierunki[na_stosie] = 0x74;  // 7=kier_ost, 4=kier;  kiedys bylo 5 * 0x11
 dad[ q[na_stosie++] = lewo+wlky+3 ] = lewo;
 //
 do
	{
	Nastepny_punkt:
	krint  pn = q[na_stosie-1];
	int kier     = (kierunki[na_stosie-1] & 0xf);
	int kier_ost = (kierunki[na_stosie-1] >> 4);
	if (--kier==-1) kier=7;
	while (kier!=kier_ost)
	  {
	  krint pn2 = pn + kierunki_dind[kier];
	  if (plan[pn2]>=10 && dad[pn2]==0)
		  {
		  dad[pn2] = pn;
        if (pn2==lewo)
          {
          plansze.ZwolnijPlansze(kierunki);
          skladowe.ZwolnijSkladowa(q);
          return na_stosie+1;
          }
		  // zapamietaj aktualny kierunek
		  kierunki[na_stosie-1] &= 0xf0;
		  kierunki[na_stosie-1] |= kier;
		  // wsadz na stos punkt pn2
		  q[na_stosie] = pn2;
		  int kk=(kier^4);    // wez przeciwny kierunek do ,,kier''
		  kierunki[na_stosie++] = (kk<<4) + kk;
		  goto Nastepny_punkt;
		  }
     if (--kier==-1) kier=7;
	  }
	// przeszlismy cala galaz, zdejmij punkt ze stosu
	na_stosie--;
	}
 while (na_stosie);
 plansze.ZwolnijPlansze(kierunki);
 skladowe.ZwolnijSkladowa(q);
 return 0;
}

int ZrobLatwyStop(unsigned char* rozgrywka, unsigned char* stopy,
                 unsigned char* rozgr2, unsigned char* rozgr3,
                 unsigned char* plansz_p, unsigned int ind, int kto)
// ind -- indeks pola w srodku, kto -- kto zamyka
// zwraca 1, gdy jest stop; 0, gdy staly stop
{
 if (rozgr2!=NULL) rozgr2[ind]=0;
 if (rozgr3!=NULL) rozgr3[ind]=kto;
 if (rozgrywka[ind]==0)
   {
   plansz_p[ind] |= (kto==1) ? 0x44:0x48;
   return 0;
   }
 else
   {
   plansz_p[ind] |= kto;
   if (stopy!=NULL)
     {
     int x=upl_x[ind], y=upl_y[ind];
     Polacz(stopy, x-1, y, x, y+1);
     Polacz(stopy, x+1, y, x, y+1);
     Polacz(stopy, x-1, y, x, y-1);
     Polacz(stopy, x+1, y, x, y-1);
     }
   return 1;
   }
}

void PolaWLancuchu(unsigned char *rozgrywka, unsigned char *plansz_p,
                   int ktory_gracz, unsigned int *pola, int ile)
// pola[i] -- lista *naszych* kropek,
// ustawia bit lancucha (0x10 lub 0x20) w plansz_p, jesli podane
//   pola sa wewnatrz lancuchow
{
 int maska_naszego_lancucha = ktory_gracz==1 ? 0x10:0x20;
 for (int i=0; i<ile; i++)
   {
   int jest=1;
   for (int k=0; k<4; k++)
     {
     unsigned int nind = pola[i] + up.dind[k];
     if (rozgrywka[nind]!=ktory_gracz && (plansz_p[nind] & 0xf)==0
  /*        && upl_marg[nind]>=2 */)
       { jest=0; break; }  // & 0xf, bo [nind] moze byc tylko wewnatrz
                          // naszego stopu (bo [pola[i]] jest nasza kropka)
     }
   if (jest) plansz_p[pola[i]] |= maska_naszego_lancucha;
   }
}

inline void UsunSkladowaZOt(unsigned char ot[9], unsigned char usun,
                            unsigned char zastap_przez)
{ for (int i=0; i<9; i++)  if (ot[i]==usun && i!=4)  ot[i]=zastap_przez; }

void OminPoleISasiadow(unsigned char ot[9], int nr)
{ // omin puste pola, ktore sa na pewno w tej samej skladowej co [nr]
 int do_spr[4] = {nr};
 ot[nr]=5;   // zaznacz
 int ile_do_spr=1;
 int sasiedzi1[4] = { 0, 0, 2, 6};
 int boczne1  [4] = { 3, 1, 1, 3};
 int sasiedzi2[4] = { 2, 6, 8, 8};
 int boczne2  [4] = { 5, 7, 7, 5};
 do
   {
   int p = do_spr[--ile_do_spr];
   // sprawdz sasiadow pola [p]
   if (ot[sasiedzi1[p>>1]]==0 && ot[boczne1[p>>1]]==0)
     { ot[boczne1[p>>1]]=5;  // zaznacz
     do_spr[ile_do_spr++]=p;
     }
   if (ot[sasiedzi2[p>>1]]==0 && ot[boczne2[p>>1]]==0)
     { ot[boczne2[p>>1]]=5;  // zaznacz
     do_spr[ile_do_spr++]=p;
     }
   }
 while (ile_do_spr);
}

void ZrobPanstwo(unsigned char* rozgrywka, unsigned char* stopy,
                 unsigned char* rozgr2, unsigned char* rozgr3,
                 unsigned char* plansz_p, int x, int y, int ktory_gracz,
                 int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
                 int &punktacja_ss, int lancuchy=0)
// (x,y)  - wlasnie postawiona kropka, przez gracza (ktory_gracz)
// USTAWIA ile_zdobytych, powierzchnia, powierzchnia2, punktacja_ss.
// Moze byc stopy==NULL (lub rozgr2, rozgr3)
// Jesli lancuchy!=0, to ustawia bit lancucha (0x10/0x20) w plansz_p,
//  o ile powstal jakis (staly) stop;
// jesli stopy!=NULL, to ustawia bit lancucha zawsze (i zmienna lancuchy
// jest ignorowana).
//
// Mozliwe optymalizacje:
// 1. ,,latwe'' stopy: stopy na 2 pola?;
// 2.  na ogol nie trzeba przechodzic wnetrza stopu jeszcze raz -- jesli
//   na brzegu sa wszystkie kropki, ktore zostaly zaznaczone przez
//   PrzejdzWnetrze() jako prawdopodobne brzegowe, to ta funkcja znajduje
//   tez cale wnetrze -- wiec mozna by zliczac i porownywac liczbe brzegowych
// Do uzupelnienia:
//     Gdy lancuchy==1 i stopy==NULL, to mozna by ustawiac lancuchy
//     tylko wtedy, gdy jest jakis (staly) stop -- bo wtedy funkcje znajdujace
//     najlepszy ruch wiedza, ze plansz_p sie zmienilo i odtwarzaja je.
{
 STOPER_START_ZPDA;
 ile_zdobytych = powierzchnia = powierzchnia2 = punktacja_ss = 0;
 // sprawdz wlasnie postawiona kropke - czy tworzy (staly) stop
// GrSetMode(GR_80_25_text);
 //
 unsigned char ot[9];
 WezOtoczenie(ot, x,y, plansz_p, rozgrywka, ktory_gracz);
 int ile_skl=UstawOtoczenie(ot);
 unsigned int indeks = WezIndeksTab(x,y);
 rozgrywka[indeks]=ktory_gracz;
 if (rozgr2!=NULL) rozgr2[indeks]=ktory_gracz;
 if (rozgr3!=NULL) rozgr3[indeks]=ktory_gracz;
 if (ile_skl<2)
   {
   if (ile_skl==1 && stopy!=NULL)
     { // sprawdz, czy kropki obok nie beda wewnatrz lancucha
     int ile=0;
     unsigned int brzegi[4];
     if (ot[1]) brzegi[ile++]=indeks-1;
     if (ot[7]) brzegi[ile++]=indeks+1;
     if (ot[3]) brzegi[ile++]=indeks-wlky-4;
     if (ot[5]) brzegi[ile++]=indeks+wlky+4;
     PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile);
     }
   STOPER_STOP_ZPDA;
   return;
   }
 {
 unsigned int brzegi[12];
 int ile_brz = 0;
 // sprawdz, czy mamy moze najprostsze panstwo
 // czy stop u gory?
 if (ot[0] && ot[2] && ot[0]!=ot[2]
     && !(plansz_p[indeks-2] &3) && rozgrywka[indeks-2]==ktory_gracz)
   {
   if (ZrobLatwyStop(rozgrywka, stopy, rozgr2, rozgr3,
                     plansz_p, indeks-1, ktory_gracz))
     ile_zdobytych++;
   else { powierzchnia++; punktacja_ss++; }
   brzegi[ile_brz++] = indeks-wlky-5;
   brzegi[ile_brz++] = indeks-2;
   brzegi[ile_brz++] = indeks+wlky+3;
   if (--ile_skl<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     STOPER_STOP_ZPDA;
     return;
     }
   ot[1]=ot[0];   UsunSkladowaZOt(ot, ot[2], ot[0]);
   }
 else if (ot[1])
   brzegi[ile_brz++] = indeks-1;
 // czy stop u dolu?
 if (ot[6] && ot[8] && ot[6]!=ot[8]
     && !(plansz_p[indeks+2] &3) && rozgrywka[indeks+2]==ktory_gracz)
   {
   if (ZrobLatwyStop(rozgrywka, stopy, rozgr2, rozgr3,
                     plansz_p, indeks+1, ktory_gracz))
     ile_zdobytych++;
   else { powierzchnia++; punktacja_ss++; }
   brzegi[ile_brz++] = indeks-wlky-3;
   brzegi[ile_brz++] = indeks+2;
   brzegi[ile_brz++] = indeks+wlky+5;
   if (--ile_skl<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     STOPER_STOP_ZPDA;
     return;
     }
   ot[7]=ot[6];   UsunSkladowaZOt(ot, ot[8], ot[6]);
   }
 else if (ot[7])
   brzegi[ile_brz++] = indeks+1;
 // czy stop z lewej?
 if (ot[0] && ot[6] && ot[0]!=ot[6] &&
    !(plansz_p[indeks-2*wlky-8] &3) && rozgrywka[indeks-2*wlky-8]==ktory_gracz)
   {
   if (ZrobLatwyStop(rozgrywka, stopy, rozgr2, rozgr3,
                     plansz_p, indeks-wlky-4, ktory_gracz))
     ile_zdobytych++;
   else { powierzchnia++; punktacja_ss++; }
   brzegi[ile_brz++] = indeks-2*wlky-8;
   brzegi[ile_brz++] = indeks-wlky-5;
   brzegi[ile_brz++] = indeks-wlky-3;
   if (--ile_skl<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     STOPER_STOP_ZPDA;
     return;
     }
   ot[3]=ot[0];   UsunSkladowaZOt(ot, ot[6], ot[0]);
   }
 else if (ot[3])
   brzegi[ile_brz++] = indeks-wlky-4;
 // czy stop z prawej?
 if (ot[2] && ot[8] && ot[2]!=ot[8] &&
    !(plansz_p[indeks+2*wlky+8] &3) && rozgrywka[indeks+2*wlky+8]==ktory_gracz)
   {
   if (ZrobLatwyStop(rozgrywka, stopy, rozgr2, rozgr3,
                     plansz_p, indeks+wlky+4, ktory_gracz))
     ile_zdobytych++;
   else { powierzchnia++; punktacja_ss++; }
   brzegi[ile_brz++] = indeks+wlky+3;
   brzegi[ile_brz++] = indeks+wlky+5;
   brzegi[ile_brz++] = indeks+2*wlky+8;
   if (--ile_skl<2)
     {
     if (lancuchy)
       PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
     STOPER_STOP_ZPDA;
     return;
     }
   ot[5]=ot[2];   UsunSkladowaZOt(ot, ot[8], ot[2]);
   }
 else if (ot[5])
   brzegi[ile_brz++] = indeks+wlky+4;
 if ((powierzchnia+ile_zdobytych && lancuchy) || stopy!=NULL)
   PolaWLancuchu(rozgrywka, plansz_p, ktory_gracz, brzegi, ile_brz);
 }
 {
 // przydziel pamiec
 unsigned char* plan =plansze.PrzydzielPlansze();
 krint* dad  =skladowe.PrzydzielSkladowa();
 krint* stos =skladowe.PrzydzielSkladowa();
 krint* wnetrze =skladowe.PrzydzielSkladowa();
 int dind[4] = {-1, -wlky-4, wlky+4, 1};  // kolejnosc jest wazna!
 int nr=1;
 do
   {
   int maska_naszego_stopu = ktory_gracz; //ktory_gracz==1 ? 0x11:0x22;
   int maska_naszego_st_stopu = ktory_gracz==1 ? 4:8; //ktory_gracz==1 ? 0x14:0x28;
   int maska_st_stopu_przec= ktory_gracz==1 ? 8:4;
   // szukaj wolnego pola
   while (nr<8 && ot[nr]!=0) nr+=2;
   if (nr>=8) break;  // wolnych pol juz nie ma
   unsigned int lewo, ind = indeks + dind[nr>>1];
   // przejdz skladowa tego wolnego pola
   if (PrzejdzWnetrze(rozgrywka, plansz_p, plan, ind, lewo, ktory_gracz))
     {
     ZnajdzBrzegStopu(dad, plan, lewo);
     // przejdz brzeg stopu
     {
     unsigned int pole=lewo;
     do {
       plan[pole]=60;   // 60=brzeg stopu
       pole=dad[pole];
       }
     while (pole!=lewo);
     }
     // przejdz jeszcze raz wnetrze stopu
     stos[0]=ind;
     int na_stosie=1, ile_wewnatrz=1;
     plan[ind]=59;  // 59=wnetrze stopu
     wnetrze[0]=ind;
     int ile_ssn=0, ile_ssp=0, ile_w=0, ile_pn=0, punkty_ssn=0, punkty_ssp=0;
     do{
       unsigned int nind = stos[--na_stosie];  // zdejmij pole
       // dodaj do zdobyczy
       if (rozgrywka[nind]==0)
         {  // puste pole
         if (plansz_p[nind]==0)
           ile_w++;  // wolne pole, optymalizacja (ten warunek najczesciej)
         else if (plansz_p[nind] & maska_naszego_st_stopu)
           {
           ile_ssn++;
           if (plansz_p[nind] & 0x40) punkty_ssn++;
           }
         else if (plansz_p[nind] & maska_st_stopu_przec)
           {
           ile_ssp++;
           if (plansz_p[nind] & 0x40) punkty_ssp++;
           }
         else if ((plansz_p[nind] & 3)==0)
           ile_w++;  // wolne pole
         }
       else if (rozgrywka[nind]!=ktory_gracz &&        // kropka przeciwnika
                (plansz_p[nind] & maska_naszego_stopu)==0) ile_pn++;
       // odwiedz sasiadow
       for (int k=0; k<4; k++)
         {
         unsigned int nnind = nind + dind[k];
         if (plan[nnind]<59)
           {
           stos[na_stosie++] = nnind;
           plan[nnind] = 59;  // zaznacz jako wewnetrzne
           wnetrze[ile_wewnatrz++] = nnind;
           }
         }
       }
     while (na_stosie);
     // oblicz punktacje
     if (ile_pn)
       { // stop! (tj. nie staly stop)
       ile_zdobytych += ile_pn;
       powierzchnia  -= ile_ssn;
       powierzchnia2 -= ile_ssp;
       punktacja_ss  = punkty_ssp - punkty_ssn;
       // ustaw wnetrze w odp. tablicach
       for (int i=0; i<ile_wewnatrz; i++)
         {
         plansz_p[wnetrze[i]] = ktory_gracz;  // pole wewn. stopu (ktory_gracz)
         if (rozgr2!=NULL) rozgr2[wnetrze[i]] = 0;
         if (rozgr3!=NULL) rozgr3[wnetrze[i]] = ktory_gracz;
         }
       // zaznacz brzeg
       if (stopy!=NULL)
        {
        unsigned int pole=lewo;
        int maska_naszego_lancucha = ktory_gracz==1 ? 0x10:0x20;
        do {
          Polacz(stopy, upl_x[pole], upl_y[pole],
                        upl_x[dad[pole]], upl_y[dad[pole]]);
          int jest=1;
          for (int k=0; k<4; k++)
            {
            unsigned int nind = pole + dind[k];
            if (rozgrywka[nind]!=ktory_gracz && (plansz_p[nind] & 0xf)==0
                /*&& upl_marg[nind]>=2 */)
              { jest=0; break; }  // & 0xf, bo [nind] moze byc tylko wewnatrz
                               // naszego stopu (bo [pole] jest nasza kropka)
            }
          if (jest) plansz_p[pole] |= maska_naszego_lancucha;
          pole=dad[pole];
          }
        while (pole!=lewo);
        }
       }
     else
       { // staly stop
       powierzchnia  += ile_w;
       int ile_zaznaczyc = (ile_w>=5) ? 3 : (ile_w>=2 ? 2 : ile_w);
       punktacja_ss = ile_zaznaczyc - punkty_ssn;
       // ustaw wnetrze w odp. tablicach
       for (int i=0; i<ile_wewnatrz; i++)
        if ((plansz_p[wnetrze[i]] & 3)==0)
         {
         if (rozgrywka[wnetrze[i]]==0)
           {
           plansz_p[wnetrze[i]] |= maska_naszego_st_stopu;  // nie ma potrzeby ustawiac bitu 0x10/0x20
           if (ile_zaznaczyc)
             { plansz_p[wnetrze[i]] |= 0x40;  ile_zaznaczyc--; }
           else plansz_p[wnetrze[i]] &= ~0x40;
           }
         if (rozgr2!=NULL) rozgr2[wnetrze[i]] = 0;
         if (rozgr3!=NULL) rozgr3[wnetrze[i]] = ktory_gracz;
         }
       // sprawdz, czy brzeg jest w lancuchu
       if (stopy!=NULL || lancuchy)
        {
        unsigned int pole=lewo;
        int maska_naszego_lancucha = ktory_gracz==1 ? 0x10:0x20;
        do {
          int jest=1;
          for (int k=0; k<4; k++)
            {
            unsigned int nind = pole + dind[k];
            if (rozgrywka[nind]!=ktory_gracz && (plansz_p[nind] & 0xf)==0)
              { jest=0; break; }  // & 0xf, bo [nind] moze byc tylko wewnatrz
                                 // naszego stopu (bo [pole] jest nasza kropka)
            }
          if (jest) plansz_p[pole] |= maska_naszego_lancucha;
          pole=dad[pole];
          }
        while (pole!=lewo);
        }
       }
     if (--ile_skl<2) break;
     // zaznacz pola, ktore sa wewnatrz akt. (stalego) stopu
     for (int k=0; k<4; k++)
       {
       unsigned int nind = indeks + dind[k];
       if (plan[nind]==59)  // pole wewnetrzne
         ot[2*k+1]=5;  // zaznacz jako zajete
       }
     }
   else
     { // omin puste pola, ktore sa na pewno w tej samej skladowej co [nr]
     OminPoleISasiadow(ot, nr);
     // zaznacz znalezione zewnetrzne pola
     for (int k=0; k<4; k++)
       {
       unsigned int nind = indeks + dind[k];
       if (plan[nind]==1 && ot[2*k+1]==0)  // pole zewnetrzne
         OminPoleISasiadow(ot, 2*k+1);
       }
     }
   }
 while (nr<8);
 plansze.ZwolnijPlansze(plan);    skladowe.ZwolnijSkladowa(dad);
 skladowe.ZwolnijSkladowa(stos);  skladowe.ZwolnijSkladowa(wnetrze);
 STOPER_STOP_ZPDA;
 }
}


int UstawPunktySS(unsigned char* plansz_p, unsigned char* plan,
                  unsigned int ind)
// [ind] -- pole *wewnatrz* stalego stopu, plan[ind]==0
// Ustawia bit 0x40 (pola punktowane) w stalym stopie zawierajacym [ind],
// zwraca liczbe, ktora trzeba dodac do punktacji_ss.
// Pola wewnatrz tego stopu zostaja zaznaczone na 1 w tablicy plan.
{
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=1;   // zaznacz jako wnetrze
 int na_stosie=1;
 int bylo_ss=0, pow=0, wnetrze[3];
 int maska = plansz_p[ind] & 0xf;
 do{
   ind = stos[--na_stosie];
   if (plansz_p[ind] & 0x40)
     { bylo_ss++; plansz_p[ind] &= ~0x40; }
   if (pow<3) wnetrze[pow]=ind;
   pow++;
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + up.dind[k];
     if (plan[nind]==0 && (plansz_p[nind] & maska))
       {
       stos[na_stosie++]=nind;
       plan[nind]=1;  // zaznacz jako wewnetrzne
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 int jest_ss=0;
 if (pow>=1) { plansz_p[wnetrze[0]] |= 0x40;   jest_ss++; }
 if (pow>=2) { plansz_p[wnetrze[1]] |= 0x40;   jest_ss++; }
 if (pow>=5) { plansz_p[wnetrze[2]] |= 0x40;   jest_ss++; }
 return jest_ss - bylo_ss;
}

/*
void UstawPlansz_pSS(unsigned char* rozgrywka, unsigned char* plansz_p)
// Ustawia bity: 0x10/0x20 (lancuchy) i 0x40 (pola punktowane) w plansz_p
// Przydatne po wczytaniu gry zapisanej stara wersja programu.
{
 unsigned char* plan =plansze.PrzydzielPlansze();
 CzyscTablice(plan);
 for (int i=0; i<wlkx4wlky4; i++) plansz_p[i] &= 0xf;
 for (int i=2; i<wlkx+2; i++)
   {
   unsigned int ind = WezIndeksTab(i,2);
   for (int y=2; y<wlky+2; y++)
     {
     if (plansz_p[ind] & 0xc)  // wewnatrz stalego stopu
       {
       if (plan[ind]==0) UstawPunktySS(plansz_p, plan, ind);
       }
     else if (plansz_p[ind]==0 && rozgrywka[ind]!=0)
       { // sprawdz pola sasiednie
       int kto = rozgrywka[ind];
       if ((rozgrywka[ind+1]==kto || plansz_p[ind+1]) &&
           (rozgrywka[ind-1]==kto || plansz_p[ind-1]) &&
           (rozgrywka[ind-wlky-4]==kto || plansz_p[ind-wlky-4]) &&
           (rozgrywka[ind+wlky+4]==kto || plansz_p[ind+wlky+4]))
         plansz_p[ind] |= (kto==1) ? 0x10 : 0x20;  // bit lancucha
       }
     ind++;
     }
   }
 plansze.ZwolnijPlansze(plan);
}
*/

/*
int TestPunktySS(unsigned char* plansz_p_arg)
// sprawdza, czy bity 0x40 sa dobrze ustawione, zwraca liczbe bledow
// (0 = wszystko dobrze)
// Bit 0x40 ustawiony poza stalym stopem jest liczony jako 10000
//  (dla ulatwienia identyfikacji rodzaju bledu).
{
 unsigned char* plan =plansze.PrzydzielPlansze();
 unsigned char* plansz_p =plansze.PrzydzielPlansze();
 CzyscTablice(plan);  KopiujTablice(plansz_p, plansz_p_arg);
 int blad=0;
 for (int i=0; i<wlkx4wlky4; i++)
   if (plansz_p[i] & 0xc)
     {
     if (plan[i]==0 && UstawPunktySS(plansz_p, plan, i)!=0)
       blad++;
     }
   else if (plansz_p[i] & 0x40) blad+=10000;
 plansze.ZwolnijPlansze(plan);
 plansze.ZwolnijPlansze(plansz_p);
}
*/

void ZrobRuch(unsigned char* rozgrywka, unsigned char* stopy,
	      unsigned char* plansz_p, int x, int y, int ktory_gracz,
	      int st_x, int st_y,
	      int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
	      int &ile_zdobytych2)
// (x,y)  - wlasnie postawiona kropka, przez gracza (ktory_gracz)
// (st_x, st_y) - poprzednio postawiona kropka (przez przeciwnika)
// Sprawdza, czy (st_x, st_y) jest wewnatrz stalego stopu gracza
//  (ktory_gracz).
{
 ile_zdobytych=0;  powierzchnia=0; powierzchnia2=0;  ile_zdobytych2=0;
 if ((WezUC(plansz_p,x,y) & 12)!=0) {
   unsigned int ind=WezIndeksTab(x,y);
   rozgrywka[ind]=ktory_gracz;
   if ( ((plansz_p[ind] & 4)!=0) ^ (ktory_gracz==1))
     {
       powierzchnia2--;    // postawilismy kropke do stalego stopu przeciwnika
       // nie zeruj bitu oznaczajacego staly stop, bo bedzie on potrzebny
       // tutaj nie uaktualniamy bitu 0x40 w plansz_p -- mozna by, ale to
       // nic nie daje -- za chwile i tak zostanie to uaktualnione
       //
       // sprawdz najprostszy 1-polowy brzuszek: taki mozna zamknac od razu
       int przec=3-ktory_gracz;
       if (rozgrywka[ind-1]==przec && rozgrywka[ind+1]==przec &&
	   rozgrywka[ind-wlky-4]==przec && rozgrywka[ind+wlky+4]==przec) {
	 plansz_p[ind] &= ~0x4c;  // wyzeruj bit stalego stopu i punktowanych
         plansz_p[ind] |= (przec==1) ? 0x11 : 0x22;  // bit lancucha i stopu
	 ile_zdobytych2++;   // przeciwnik zdobyl kropke
	 Polacz(stopy, x-1,y, x,y-1);
	 Polacz(stopy, x,y-1, x+1,y);
	 Polacz(stopy, x+1,y, x,y+1);
	 Polacz(stopy, x,y+1, x-1,y);
       }
     }
   else
     {
       powierzchnia--;    // postawilismy kropke do naszego stalego stopu
       plansz_p[ind] &= 0xb3;  // wyzeruj bit 0x4/0x8 oraz 0x40
       // uaktualnij bit 0x40 w plansz_p
       unsigned char* plan =plansze.PrzydzielPlansze();
       CzyscTablice(plan);
       for (int k=0; k<4; k++)
	 {
	   unsigned int nind = ind + up.dind[k];
	   if (rozgrywka[nind]==0 && plan[nind]==0)
	     UstawPunktySS(plansz_p, plan, nind);
	 }
       plansze.ZwolnijPlansze(plan);
     }
 }
 else
   {
     int punktacja_ss;
     ZrobPanstwo(rozgrywka, stopy, NULL, NULL, plansz_p, x,y, ktory_gracz,
		 ile_zdobytych,powierzchnia,powierzchnia2, punktacja_ss,1);
   }
 // teraz sprawdz, czy poprzednio postawiona kropka jest w stalym stopie
 if ((WezUC(plansz_p,st_x,st_y) & (2 << ktory_gracz))!=0)
   {
   unsigned int indeks = WezIndeksTab(st_x, st_y);
   plansz_p[indeks] &= 0xf3;  // wyczysc bity stalego stopu
   // przydziel pamiec
   unsigned char* plan =plansze.PrzydzielPlansze();
   krint* dad  =skladowe.PrzydzielSkladowa();
   krint* stos =skladowe.PrzydzielSkladowa();
   int dind[4] = {-1, -wlky-4, wlky+4, 1};
   // przejdz skladowa pola z kropka przeciwnika
   unsigned int lewo;
   PrzejdzWnetrze(rozgrywka, plansz_p, plan, indeks, lewo, ktory_gracz);
   ZnajdzBrzegStopu(dad, plan, lewo);
   // przejdz i zaznacz brzeg stopu
   {
   unsigned int pole=lewo;
   do {
     Polacz(stopy, upl_x[pole], upl_y[pole],
                   upl_x[dad[pole]], upl_y[dad[pole]]);
     plan[pole]=60;   // 60=brzeg stopu
     pole=dad[pole];
     }
   while (pole!=lewo);
   }
   // przejdz jeszcze raz wnetrze stopu
   stos[0]=indeks;
   int na_stosie=1;
   plan[indeks]=59;  // 59=wnetrze stopu
   ile_zdobytych++;
   do{
     unsigned int nind = stos[--na_stosie];  // zdejmij pole
     // dodaj do zdobyczy
     if (rozgrywka[nind]==0)
       {  // puste pole
       //if (plansz_p[nind] & 0x40) punktacja_ss--;
       powierzchnia--;
       }
     //else if (rozgrywka[nind]!=ktory_gracz) ile_zdobytych++;  -- jest tylko jedna kropka przec.
     // ustaw plansz_p
     plansz_p[nind] = ktory_gracz;
     // odwiedz sasiadow
     for (int k=0; k<4; k++)
       {
       unsigned int nnind = nind + dind[k];
       if (plan[nnind]<59)
         {
         stos[na_stosie++] = nnind;
         plan[nnind] = 59;  // zaznacz jako wewnetrzne
         }
       }
     }
   while (na_stosie);
   plansze.ZwolnijPlansze(plan);
   skladowe.ZwolnijSkladowa(dad);   skladowe.ZwolnijSkladowa(stos);
   }
}

int CzyMozliwyStop(krint *skl, unsigned char *rozgr2, int i, int j, int ktory_gracz)
// czy gracz (ktory_gracz) stawiajac kropke w miejscu (i,j) bedzie mial
// stop lub staly stop
{
 STOPER_START_CZYM;
 unsigned char ot[9];
 /*
 unsigned int ind = WezIndeksTab(i,j-1);
 unsigned int indl = ind-wlky-4, indp=ind+wlky+4;
 ot[0] = rozgr2[indl  ];   ot[1] = rozgr2[ind  ];   ot[2] = rozgr2[indp  ];
 ot[3] = rozgr2[indl+1];   ot[4] = ktory_gracz;     ot[5] = rozgr2[indp+1];
 ot[6] = rozgr2[indl+2];   ot[7] = rozgr2[ind+2];   ot[8] = rozgr2[indp+2];
 */
 WezOtoczenieUlatw(ot, i, j, rozgr2, ktory_gracz);
 int is=UstawOtoczenie(ot);
 if (is<=1) { STOPER_STOP_CZYM; return 0; }
 krint jakie_sa[5] = {0,0,0,0,0};
 int ind_ot = 0;
 for (int dy=-1; dy<=1; dy++)
  for (int dx=-1; dx<=1; dx++)
   {
   if (ind_ot!=4 && ot[ind_ot])
     jakie_sa[ot[ind_ot]] = WezUI(skl, i+dx, j+dy);
   ind_ot++;
   }
 STOPER_STOP_CZYM;
 // zobacz, czy laczymy taka sama skladowa
 if (jakie_sa[1]==jakie_sa[2])
   return 1;
 if (is==2) return 0;    // dwie rozne skladowe
 if (jakie_sa[1]==jakie_sa[3] || jakie_sa[2]==jakie_sa[3])
   return 1;
 if (is==3) return 0;    // trzy rozne skladowe
 if (jakie_sa[1]==jakie_sa[4] || jakie_sa[2]==jakie_sa[4] || jakie_sa[3]==jakie_sa[4])
   return 1;
 return 0;    // cztery rozne skladowe
}

void IleWolnegoMiejsca(unsigned char* rozgrywka, unsigned char* plansz_p,
                       int &ile_wolnego, int &ile_wolnego_poza_sts)
{
 ile_wolnego=0;
 ile_wolnego_poza_sts=0;
 for (int i=up.lg; i<=up.pd; i++)
   if (rozgrywka[i]==0 &&        // nie ma tu jeszcze kropki
       (plansz_p[i] & 3)==0 &&   // nie wewnatrz stopu
       upl_marg[i]>=2) {         // wewnatrz planszy
     ile_wolnego++;
     if ((plansz_p[i] & 12)==0)  // nie wewnatrz stalego stopu
       ile_wolnego_poza_sts++;
   }
}

void GraKoncowa(unsigned char* rozgrywka, unsigned char* plansz_p,
                int ktory_gracz, int &x, int &y, int st_x, int st_y)
// znajduje najlepszy ruch dla gracza (ktory_gracz)
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
// zwraca (0,0), gdy nie ma w ogole stalych stopow
//
// Mozliwe ulepszenie: powinien zwracac uwage na to, jakie stopy
//   powstana po wstawieniu kropki do wlasnego stopu.
//   np. podzial stopu 1x5 na dwa stopy 1x2 jest bardziej korzystny
//       niz podzial na jeden 1x1 i jeden 1x3.
{
 krint* stos    =skladowe.PrzydzielSkladowa();
 krint* wnetrze =skladowe.PrzydzielSkladowa();
 unsigned char* plan =plansze.PrzydzielPlansze();
 CzyscTablice(plan);
 int dind[4] = {-1,-wlky-4,wlky+4,1};
 int ot_dind[9] = { -wlky-5,-1,wlky+3, -wlky-4,0,wlky+4, -wlky-3,1,wlky+5 };
 int stary_ind = WezIndeksTab(st_x,st_y);
 int ocena_najl=0, ile_najl=0;
 unsigned int najlepsze[16] = {0}; // {0} wazne, gdy nie ma stalych stopow
 for (int i=3; i<wlkx+1; i++)  // i=3..wlkx, bo stale stopy moga byc tylko wewnatrz
   {
   unsigned int ind = WezIndeksTab(i,3);
   for (int y=3; y<wlky+1; y++)
    {
    if (rozgrywka[ind]==0 && (plansz_p[ind] & 0xc))
     {  // wewnatrz stalego stopu!
     int czyj_stop = (plansz_p[ind] & 0xc) >> 2;
     if (plan[ind]==0)  // jeszcze w nim nie bylismy?
       {  // znajdz wielkosc tego stalego stopu
       int na_stosie=1;  stos[0]=ind;  plan[ind]=10;
       int pow=0, ta_skl=0;
       do {
         unsigned int nind = stos[--na_stosie];
         wnetrze[pow++]=nind;
         if (nind==stary_ind) ta_skl=1;
         // idz na boki
         for (int k=0; k<4; k++)
           {
           unsigned int nnind = nind + dind[k];
           if (plan[nnind]==0 && rozgrywka[nnind]!=czyj_stop)
             plan[stos[na_stosie++] = nnind] = 10;
           }
         }
       while (na_stosie);
       if (pow<10) for (int j=0; j<pow; j++) plan[wnetrze[j]] = pow;
       if (ta_skl && czyj_stop==ktory_gracz)
         for (int j=0; j<pow; j++) plan[wnetrze[j]] |= 0x20;  // bonus +32
           // za postawienie kropki do tej samego naszego stopu, do ktorego
           // wstawil nam przed chwila przeciwnik
       }
     // znajdz liczbe skladowych
     unsigned char ot[9];
     for (int j=0; j<9; j++)
       ot[j] = rozgrywka[ind + ot_dind[j]];
     ot[4] = czyj_stop;
     int ocena = (UstawOtoczenie(ot) << 6) + plan[ind] +
                 (czyj_stop==ktory_gracz ? 0:16);
     // zapamietaj ruch
     if (ocena>ocena_najl)
       { ocena_najl=ocena;  najlepsze[0]=ind;  ile_najl=1; }
     else if (ocena==ocena_najl && ile_najl<16) najlepsze[ile_najl++]=ind;
     }
    ind++;
    }
   }
 skladowe.ZwolnijSkladowa(stos);   skladowe.ZwolnijSkladowa(wnetrze);
 plansze.ZwolnijPlansze(plan);
 // wybierz najlepszy ruch
 int ktory = (ile_najl<=1) ? 0 : random(ile_najl);
 x = upl_x[najlepsze[ktory]];
 y = upl_y[najlepsze[ktory]];
}

long int Bouzy(unsigned char *terytorium, unsigned char *rozgr2,
	       unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max,
	       int dilations, int erosions, int waga_Bo1, int waga_Bo2, int punkt_za_pole)
// na podstawie algorytmu Bouzy'ego do znajdowania terytorium
// zob. <ftp://www.joy.ne.jp/welcome/igs/Go/computer/bbthese.ps.Z>
// Moze byc terytorium==NULL.
{
 skrint* gotowe =skladowe.PrzydzielSkladowaI();
 skrint* robocze =skladowe.PrzydzielSkladowaI();
 CzyscTablice(gotowe);
 for (int i=up.lg; i<=up.pd; i++)
   if (rozgr2[i]==1) gotowe[i]=128;
   else if (rozgr2[i]==2) gotowe[i]=-128;
 if (marg_min.x<=2)   marg_min.x=3;
 if (marg_max.x>wlkx) marg_max.x=wlkx;
 if (marg_min.y<=2)   marg_min.y=3;
 if (marg_max.y>wlky) marg_max.y=wlky;
 for (int d=0; d<dilations; d++)
  {
  KopiujTablice(robocze, gotowe);
  if (marg_min.x>3) marg_min.x--;
  if (marg_max.x<wlkx) marg_max.x++;
  if (marg_min.y>3) marg_min.y--;
  if (marg_max.y<wlky) marg_max.y++;
  for (int i=marg_min.x; i<=marg_max.x; i++)
   {
   unsigned int indeks = WezIndeksTab(i,marg_min.y);
   for (int j=marg_min.y; j<=marg_max.y; j++) {
     if (rozgr3[indeks]==0) {
       if (gotowe[indeks]>=0 &&
	   gotowe[indeks-1]>=0 && gotowe[indeks+1]>=0 &&
	   gotowe[indeks-wlky-4]>=0 && gotowe[indeks+wlky+4]>=0)
	 {
	   if (gotowe[indeks-1]>0) robocze[indeks]++;
	   if (gotowe[indeks+1]>0) robocze[indeks]++;
	   if (gotowe[indeks-wlky-4]>0) robocze[indeks]++;
	   if (gotowe[indeks+wlky+4]>0) robocze[indeks]++;
	 }
       if (gotowe[indeks]<=0 &&
	   gotowe[indeks-1]<=0 && gotowe[indeks+1]<=0 &&
	   gotowe[indeks-wlky-4]<=0 && gotowe[indeks+wlky+4]<=0)
	 {
	   if (gotowe[indeks-1]<0) robocze[indeks]--;
	   if (gotowe[indeks+1]<0) robocze[indeks]--;
	   if (gotowe[indeks-wlky-4]<0) robocze[indeks]--;
	   if (gotowe[indeks+wlky+4]<0) robocze[indeks]--;
	 }
     }
     indeks++;
     }
   }
  { skrint *pom=gotowe;  gotowe=robocze;  robocze=pom; }
  }
 for (int e=0; e<erosions; e++)
  {
  KopiujTablice(robocze, gotowe);
  for (int i=3; i<=wlkx; i++)
   {
   unsigned int indeks = WezIndeksTab(i,3);
   for (int j=3; j<=wlky; j++)
     {
     if (rozgr3[indeks]==0)
     if (gotowe[indeks]>0)
       {
       if (//j>0 && 
	   gotowe[indeks-1]<=0) robocze[indeks]--;
       if (//j<wlky-1 && 
	   gotowe[indeks+1]<=0) robocze[indeks]--;
       if (//i>0 && 
	   gotowe[indeks-wlky-4]<=0) robocze[indeks]--;
       if (//i<wlkx-1 && 
	   gotowe[indeks+wlky+4]<=0) robocze[indeks]--;
       if (robocze[indeks]<0) robocze[indeks]=0;
       }
     else if (gotowe[indeks]<0)
       {
       if (//j>0 && 
	   gotowe[indeks-1]>=0) robocze[indeks]++;
       if (//j<wlky-1 && 
	   gotowe[indeks+1]>=0) robocze[indeks]++;
       if (//i>0 && 
	   gotowe[indeks-wlky-4]>=0) robocze[indeks]++;
       if (//i<wlkx-1 && 
	   gotowe[indeks+wlky+4]>=0) robocze[indeks]++;
       if (robocze[indeks]>0) robocze[indeks]=0;
       }
     indeks++;
     }
   }
  { skrint *pom=gotowe;  gotowe=robocze;  robocze=pom; }
  }
 // ustaw terytorium
 if (terytorium!=NULL) {
   CzyscTablice(terytorium);
   for (int i=0; i<wlkx4wlky4; i++)
     if (gotowe[i] //&& upl_marg[i]>2
	 && rozgr3[i]==0)
       terytorium[i] = (gotowe[i]>0) ? 1:2;
 }
 // oblicz punktacje
 long int ocena=0;
 if (punkt_za_pole) {
   waga_Bo2=-waga_Bo2;
   for (int i=up.lg; i<=up.pd; i++)
     if (gotowe[i] //&& upl_marg[i]>2
	 && rozgr3[i]==0)
       ocena+= (gotowe[i]>0) ? waga_Bo1:waga_Bo2;
 }
 else {
   long int ocen1=0, ocen2=0;
   for (int i=up.lg; i<=up.pd; i++)
     if (rozgr3[i]==0)
       if (gotowe[i]>0) ocen1++;
       else if (gotowe[i]<0) ocen2++;
   ocena = ocen1*waga_Bo1 - ocen2*waga_Bo2;
 }
 skladowe.ZwolnijSkladowa(gotowe);   skladowe.ZwolnijSkladowa(robocze);
 return ocena;
}



inline int min(int a, int b)
{ return (a<b) ? a:b; }

int WolnyStozek(const unsigned char *rozg, krint *obszar,
                int x, int y, int dx1, int dx2, int dy1, int dy2,
                unsigned short int kierunek)
// we: rozg, pola wewnatrz stopow ustawione na 0.
//     (x,y) -- wierzcholek stozka,
//     kierunek -- kierunek stozka,
//                 &1 - zawiera polprosta PG, &2 - LG, &4 - LD, &8 - PD,
//                 czyli maski to: gora=3, lewo=6, dol=12, prawo=9
//     dx1, dx2 -- odleglosc x od lewego i prawego marginesu
//     dy1, dy2 -- odleglosc y od gornego i dolnego marginesu
// zwraca 1 i zeruje bit 0x100 w obszarze, gdy stozek jest wolny,
// w przeciwnym razie zwraca 0 i nie zmienia obszaru
// Uwaga: bierzemy pod uwage tylko brzeg stozka!
{
 unsigned int indeks=WezIndeksTab(x,y);
 if (rozg[indeks]) return 0;   // wierzcholek jest zajety
 // sprawdz kierunek PG
 if (kierunek & 1)
   {
   int dokad = min(dx2, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+3;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek LG
 if (kierunek & 2)
   {
   int dokad = min(dx1, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+5;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek LD
 if (kierunek & 4)
   {
   int dokad = min(dx1, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+3;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek PD
 if (kierunek & 8)
   {
   int dokad = min(dx2, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+5;
     if (rozg[ind]) return 0;
     }
   }
 // stozek jest wolny -- ustaw to w obszarze
 obszar[indeks] &= ~(0x100);  // wierzcholek
 // ustaw kierunek PG
 if (kierunek & 1)
   {
   int dokad = min(dx2, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+3;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek LG
 if (kierunek & 2)
   {
   int dokad = min(dx1, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+5;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek LD
 if (kierunek & 4)
   {
   int dokad = min(dx1, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+3;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek PD
 if (kierunek & 8)
   {
   int dokad = min(dx2, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+5;
     obszar[ind] &= ~(0x100);
     }
   }
 return 1;
}

void ZaznaczNiecki(krint *obszar, const unsigned char *r3, int kto, int maska_kto, int maska_prz, int indeks)
{
  int przec=3-kto;
  if (r3[indeks]==kto && r3[indeks+1]==kto) {
    // szukaj niecek w poziomie
    int indn = indeks+wlky+4;
    while (r3[indn]==kto && r3[indn+1]==0 && r3[indn+2]!=przec)
      indn += wlky+4;
    if (r3[indn]==kto && r3[indn+1]==kto)
      // jest niecka!
      for (int p=indeks+wlky+5; p<indn; p+=wlky+4)
	obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
    // szukaj niecek w poziomie u gory
    indn = indeks+wlky+5;
    while (r3[indn]==kto && r3[indn-1]==0 && r3[indn-2]!=przec)
      indn += wlky+4;
    if (r3[indn]==kto && r3[indn-1]==kto) {
      // jest niecka!
      indn--;
      for (int p=indeks+wlky+4; p<indn; p+=wlky+4)
	obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
    }
    // teraz po skosie (wolne po pd lub lg stronie)
    if (r3[indeks+wlky+4]==kto && r3[indeks+wlky+3]==kto) {
      // prawe dolne
      if (r3[indeks+2*wlky+7]==kto && 
	  r3[indeks+wlky+5]!=przec && r3[indeks+2*wlky+8]!=przec &&
	  r3[indeks+2*wlky+9]!=przec && r3[indeks+3*wlky+11]!=przec &&
	  r3[indeks+3*wlky+12]!=przec)
	if (r3[indeks+2]!=przec && r3[indeks+wlky+6]!=przec && 
	    r3[indeks+2*wlky+10]!=przec && r3[indeks+3*wlky+13]!=przec) {
	  if (r3[indeks+wlky+5]==0) 
	    obszar[indeks+wlky+5] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2*wlky+8]==0) 
	    obszar[indeks+2*wlky+8] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2*wlky+8]==0 && r3[indeks+2*wlky+6]==kto &&
		 r3[indeks+3*wlky+10]==kto)
	  obszar[indeks+2*wlky+8] |= (maska_kto|maska_prz);   // bezsensowne dla obu
      // lewe gorne
      if (r3[indeks-wlky-3]==kto &&
	  r3[indeks-wlky-4]!=przec && r3[indeks-wlky-5]!=przec &&
	  r3[indeks-1]!=przec && r3[indeks-2]!=przec && r3[indeks+wlky+2]!=przec)
	if (r3[indeks-2*wlky-9]!=przec && r3[indeks-2*wlky-8]!=przec &&
	    r3[indeks-2*wlky-7]!=przec && r3[indeks-wlky-6]!=przec) {
	  if (r3[indeks-wlky-4]==0) 
	    obszar[indeks-wlky-4] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks-1]==0) 
	    obszar[indeks-1] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks-1]==0 && r3[indeks+2*wlky+6]==kto && 
		 r3[indeks+2*wlky+7]==kto)
	  obszar[indeks-1] |= (maska_kto|maska_prz);   // bezsensowne dla obu
    }
    // po skosie (wolne po pg lub ld stronie)
    if (r3[indeks+wlky+5]==kto && r3[indeks+wlky+6]==kto) {
      // prawe gorne
      if (r3[indeks+2*wlky+10]==kto && r3[indeks+wlky+4]!=przec && 
	  r3[indeks+2*wlky+8]!=przec && r3[indeks+2*wlky+9]!=przec &&
	  r3[indeks+3*wlky+13]!=przec && r3[indeks+3*wlky+14]!=przec)
	if (r3[indeks-1]!=przec && r3[indeks+wlky+3]!=przec && 
	    r3[indeks+2*wlky+7]!=przec && r3[indeks+3*wlky+12]!=przec) {
	  if (r3[indeks+wlky+4]==0)
	    obszar[indeks+wlky+4] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2*wlky+9]==0)
	    obszar[indeks+2*wlky+9] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2*wlky+9]==0 && r3[indeks+2*wlky+11]==kto &&
		 r3[indeks+3*wlky+15]==kto)
	  obszar[indeks+2*wlky+9] |= (maska_kto|maska_prz);   // bezsensowne dla obu
      // lewe dolne
      if (r3[indeks-wlky-4]==kto &&
	  r3[indeks-wlky-3]!=przec && r3[indeks-wlky-2]!=przec &&
	  r3[indeks+2]!=przec && r3[indeks+3]!=przec && r3[indeks+wlky+7]!=przec)
	if (r3[indeks-wlky-1]!=przec && r3[indeks-2*wlky-8]!=przec &&
	    r3[indeks-2*wlky-7]!=przec && r3[indeks-2*wlky-6]!=przec) {
	  if (r3[indeks-wlky-3]==0)
	    obszar[indeks-wlky-3] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2]==0)
	    obszar[indeks+2] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2]==0 && r3[indeks+2*wlky+10]==kto && 
		 r3[indeks+2*wlky+11]==kto)
		 obszar[indeks+2] |= (maska_kto|maska_prz);   // bezsensowne dla obu
    }
    // i na koniec pionowe
    if (r3[indeks-wlky-4]==kto) {
      indn = indeks+1;
      while (r3[indn]==kto && r3[indn-wlky-4]==0 && r3[indn-2*wlky-8]!=przec)
	indn++;
      if (r3[indn]==kto && r3[indn-wlky-4]==kto) {
	indn -= wlky+4;
	for (int p=indeks-wlky-3; p<indn; p++)
	  obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
      }
    }
    // i drugie pionowe
    if (r3[indeks+wlky+4]==kto) {
      indn = indeks+1;
      while (r3[indn]==kto && r3[indn+wlky+4]==0 && r3[indn+2*wlky+8]!=przec)
	indn++;
      if (r3[indn]==kto && r3[indn+wlky+4]==kto) {
	indn += wlky+4;
	for (int p=indeks+wlky+5; p<indn; p++)
	  obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
      }
    }
  }
}

int SprAntywezeObszar(const unsigned char *r3,int kto,int przec,unsigned int ind,int wbok, int wgore)
// zwraca indeks pola bezsensownego dla przec; przec tworzy weza
// szablon:
//
//                  (itd.)
//        o o o o o o o o o o o o o o o o
//      o o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o
//    o o o ? o o o o o o o o o
//    o o . x o o o o o o o o
//    o . x x . o o o o o o
//    . x x . o o o o o o
//        . o o o o o o
//
// x = kropka kto,    . = kropka przec
// o oznacza puste pole lub kropke x,
// ? - tu bedzie pole bezsensowne dla przec
// Kropka x w ld rogu ma wspolrzedna [ind], wbok, wgore jak na rysunku.
// Trzy lewe dolne kropki ,,x'' sa juz sprawdzone.
{
  if (r3[ind-wbok]!=przec || r3[ind+wgore]!=przec || r3[ind+2*wgore+wbok]!=przec ||
      r3[ind+wbok-wgore]!=przec || r3[ind+2*wbok]!=przec || r3[ind+2*wbok+wgore]!=kto ||
      r3[ind+2*(wbok+wgore)]!=kto || r3[ind+3*wbok+wgore]!=przec ||
      upl_marg[ind+2*wbok+3*wgore]<2)
    return 0;
  // sprawdzaj puste pola u gory
  {
    unsigned int ind0 = ind-wbok+wgore;
    do {
      unsigned int indakt = ind0;
      for (int i=0; i<6; i++) {   // pionowe odcinki dlugosci 6
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wgore;
      }
      ind0 += wgore+wbok;
    }
    while (upl_marg[ind0]>=2);
  }
  // sprawdzaj puste pola po prawej
  {
    unsigned int ind0 = ind+2*wbok-wgore;
    for (int y=0; y<4; y++) {
      unsigned int indakt = ind0;
      int dokad = (y<3) ? 6:8;
      for (int i=0; i<dokad; i++) {   // poziome odcinki dlugosci 6 lub 8
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wbok;
      }
      ind0 += (y<2) ? (wgore+wbok) : (wgore-wbok);
    }
  }
  // sprawdzaj puste pola po prawej u gory
  {
    unsigned int ind0 = ind+2*wbok+3*wgore;
    do {
      unsigned int indakt = ind0;
      for (int i=0; i<10; i++) {   // poziome odcinki dlugosci 10
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wbok;
      }
      ind0 += wgore+wbok;
    }
    while (upl_marg[ind0]>=2);
  }
  return ind+2*wbok+3*wgore;
}

void ZnajdzObszary(krint *obszar, const unsigned char *rozg, const unsigned char *r3=NULL)
// wypelnia tablice obszar, znaczenie bitow:
//  maska 0x01  -- pole w otoczce wypuklej wszystkich kropek,
//  maska 0x02  -- pole w otoczce wypuklej wszystkich kropek z marginesem 1,
//  maska 0x04  -- pole w otoczce wypuklej wszystkich kropek z marginesem 2,
//  maska 0x08  -- pole w otoczce wypuklej wszystkich kropek z marginesem 3,
//  maska 0x10, 0x20  -- pole w odleglosci 1, 2 od kropki gracza 1
//  maska 0x40, 0x80  -- pole w odleglosci 1, 2 od kropki gracza 2
//  maska 0x100 -- pole w otoczce wypuklej wszystkich kropek z wcieciami,
//  maska 0x200 -- j.w. ale dodatkowo margines na 1, ale inny (metryka typu L^1)
//  maska 0x400 -- j.w. ale margines na 2
//  maska 0x800 -- j.w. ale margines na 3
//  maska 0x1000 -- pole chwilowo bezsensowne dla gracza 1 (np. wewnatrz niecek gracza 2)
//  maska 0x2000 -- pole chwilowo bezsensowne dla gracza 2 (np. wewnatrz niecek gracza 1)
//    maska 0x3000 wypelniane tylko gdy r3!=NULL
// We: plansza z rozgrywka, pola wewnatrz stopow ustawione na 0.
//     Nie zmienia tablicy rozg ani r3 (opcjonalnej).
{
 // przygotuj tablice z parametrami ciec
 struct TCiecia  { int wspx, wspy, min, max; }
   ciecia[8];
 ciecia[0].wspx=1;  ciecia[0].wspy=0;   // te dwa musza
 ciecia[1].wspx=0;  ciecia[1].wspy=1;   // byc w tej kolejnosci!
 ciecia[2].wspx=1;  ciecia[2].wspy=1;
 ciecia[3].wspx=1;  ciecia[3].wspy=-1;
 ciecia[4].wspx=1;  ciecia[4].wspy=2;
 ciecia[5].wspx=2;  ciecia[5].wspy=1;
 ciecia[6].wspx=-1; ciecia[6].wspy=2;
 ciecia[7].wspx=2;  ciecia[7].wspy=-1;
 for (int i=0; i<8; i++)
   { ciecia[i].min=MAXINT;  ciecia[i].max=-MAXINT; }
 // teraz znajdz miejsca ciec
 for (int i=2; i<wlkx+2; i++)
  for (int j=2; j<wlky+2; j++)
   if (WezUC(rozg,i,j))
     {
     for (int c=0; c<8; c++)
       {
       int wart = ciecia[c].wspx*i + ciecia[c].wspy*j;
       if (wart > ciecia[c].max) ciecia[c].max=wart;
       if (wart < ciecia[c].min) ciecia[c].min=wart;
       }
	  }
 // i ustaw otoczke
 CzyscTablice(obszar);
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++)
  for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
    {
    int wewnatrz=0x101;
    for (int c=2; c<8; c++)
		{
      int wart = ciecia[c].wspx*i + ciecia[c].wspy*j;
      if (wart < ciecia[c].min || wart > ciecia[c].max)
        { wewnatrz=0; break; }
      }
    WezUI(obszar,i,j) = wewnatrz;
    }
 // teraz zrob wciecia, najpierw pionowe
 {
 int ys1 = ciecia[1].min, yk1 = ciecia[1].max;
 int ys2 = ciecia[1].max, yk2 = ciecia[1].min;
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++)
  {
  // wciecia od gory:
  {
  int do_konca=1;
  for (int y=ys1; y<=yk1; y++)
    if (!WolnyStozek(rozg, obszar, i,y, i-ciecia[0].min, ciecia[0].max-i,
         y-ciecia[1].min, ciecia[1].max-y, 3))
      {
      ys1=y-1;  if (ys1<ciecia[1].min) ys1=ciecia[1].min;
      yk1=y;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    ys1=yk1;
    if (++yk1>ciecia[1].max) yk1=ciecia[1].max;
    }
  }
  // wciecia od dolu:
  {
  int do_konca=1;
  for (int y=ys2; y>=yk2; y--)
    if (!WolnyStozek(rozg, obszar, i,y, i-ciecia[0].min, ciecia[0].max-i,
         y-ciecia[1].min, ciecia[1].max-y, 12))
      {
      ys2=y+1;  if (ys2>ciecia[1].max) ys2=ciecia[1].max;
      yk2=y;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    ys2=yk2;
    if (--yk2<ciecia[1].min) yk2=ciecia[1].min;
    }
  }
  }
 }
 // teraz wciecia poziome
 {
 int xs1 = ciecia[0].min, xk1 = ciecia[0].max;
 int xs2 = ciecia[0].max, xk2 = ciecia[0].min;
 for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
  {
  // wciecia z lewej:
  {
  int do_konca=1;
  for (int x=xs1; x<=xk1; x++)
    if (!WolnyStozek(rozg, obszar, x,j, x-ciecia[0].min, ciecia[0].max-x,
         j-ciecia[1].min, ciecia[1].max-j, 6))
      {
      xs1=x-1;  if (xs1<ciecia[0].min) xs1=ciecia[0].min;
      xk1=x;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    xs1=xk1;
    if (++xk1>ciecia[0].max) xk1=ciecia[0].max;
    }
  }
  // wciecia z prawej:
  {
  int do_konca=1;
  for (int x=xs2; x>=xk2; x--)
    if (!WolnyStozek(rozg, obszar, x,j, x-ciecia[0].min, ciecia[0].max-x,
         j-ciecia[1].min, ciecia[1].max-j, 9))
      {
      xs2=x+1;  if (xs2>ciecia[0].max) xs2=ciecia[0].max;
      xk2=x;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    xs2=xk2;
    if (--xk2<ciecia[0].min) xk2=ciecia[0].min;
    }
  }
  }
 }
 // teraz ustaw otoczke z marginesem i otoczenie kropek graczy 1 i 2
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++) {
  unsigned int indeks = WezIndeksTab(i,ciecia[1].min);
  for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
   {
   if (r3!=NULL) {
     ZaznaczNiecki(obszar, r3, 1, 0x1000, 0x2000, indeks);
     ZaznaczNiecki(obszar, r3, 2, 0x2000, 0x1000, indeks);
     // spr. antyweze
     if (r3[indeks]) {
       int kto=r3[indeks];
       int przec=3-kto;
       int maska = (przec<<12);  // == 0x1000 lub 0x2000
       if (r3[indeks+wlky+4]==kto)
	 if (r3[indeks+wlky+3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,wlky+4,-1)] |= maska;
	 else if (r3[indeks+wlky+5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,wlky+4,1)] |= maska;
       if (r3[indeks-wlky-4]==kto)
	 if (r3[indeks-wlky-5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-wlky-4,-1)] |= maska;
	 else if (r3[indeks-wlky-3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-wlky-4,1)] |= maska;
       if (r3[indeks-1]==kto)
	 if (r3[indeks-wlky-5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-1,-wlky-4)] |= maska;
	 else if (r3[indeks+wlky+3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-1,wlky+4)] |= maska;
       if (r3[indeks+1]==kto)
	 if (r3[indeks-wlky-3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,1,-wlky-4)] |= maska;
	 else if (r3[indeks+wlky+5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,1,wlky+4)] |= maska;
     }
   }
   // ustaw otoczke z marginesem -- bity 0x02, 0x04, 0x08
   if (obszar[indeks] & 1)
     {
     // wez margines
     for (int dx=-3; dx<=3; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-3; dy<=3; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int maska=8;    // ustaw pole na margines 3
       if (dx!=-3 && dx!=3 && dy!=-3 && dy!=3)
         {
         maska=12;     // ustaw pole na margines 2 i 3
         if (dx!=-2 && dx!=2 && dy!=-2 && dy!=2)
           maska=14;   // ustaw pole na margines 1,2 i 3
         }
		 WezUI(obszar,i+dx,j+dy) |= maska;
       }
     }
   // ustaw otoczenie kropek graczy 1 i 2 -- najstarsze 4 bity
   int gr=rozg[indeks];
   if (gr)
     {
     // wez margines
	  for (int dx=-2; dx<=2; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-2; dy<=2; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int maska= (gr==1) ? 0x20 : 0x80;    // ustaw pole na margines 2
       if (dx!=-2 && dx!=2 && dy!=-2 && dy!=2)
         maska= (gr==1) ? 0x30 : 0xc0;    // ustaw pole na margines 1 i 2
       WezUI(obszar,i+dx,j+dy) |= maska;
       }
     }
   // ustaw margines dla otoczki z wcieciami
   if (obszar[indeks] & 0x100)
     {
     for (int dx=-3; dx<=3; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-3; dy<=3; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int odl = (dx<0 ? -dx:dx) + (dy<0 ? -dy:dy);
       if (odl<=1)
         WezUI(obszar,i+dx,j+dy) |= 0xe00;
       else if (odl==2)
         WezUI(obszar,i+dx,j+dy) |= 0xc00;
       else if (odl==3)
         WezUI(obszar,i+dx,j+dy) |= 0x800;
       }
     }
   indeks++;
   }
 }
 obszar[0]=0;  // wyzeruj ew. maske 0x1000/0x2000 ustawiona przy antywezach
}

krint DajMaske(krint gr_na_ruchu, krint gr_nie_nr)
// zwraca maske dla obszaru, w argumentach sa maski obszarow graczy
{
 // najpierw sprobuj maske dla obszaru z wcieciami
 krint maska1=0x100;
 while (maska1<=0x800 && !(gr_nie_nr & maska1)) maska1<<=1;
 krint maska2=0x100;
 while (maska2<=0x400 && !(gr_na_ruchu & maska2)) maska2<<=1;
 maska2<<=2;   // gracz na ruchu musi miec zapas jednej maski + jednej na SNR !
 if (maska1<=0x800 && maska2<=0x800)
   return (maska1 | maska2);    // mozna tez wziac maksimum zamiast bitowego OR
 // nie udalo sie, wez maski dla obszaru bez wciec
 maska1=1;
 while (maska1<8 && !(gr_nie_nr & maska1)) maska1<<=1;
 maska2=1;
 while (maska2<4 && !(gr_na_ruchu & maska2)) maska2<<=1;
 maska2<<=1;   // gracz na ruchu musi miec zapas jednej maski, tu nie trzeba dodatkowej dla SNR!
 return (maska1 | maska2);    // mozna tez wziac maksimum zamiast bitowego OR
}

inline void MostkiDodajKropke(TDwaUC *mostki, int &ilem, TDwaUC p)
// dodaje punkt p do tablicy mostki
{
 if (ilem==0)
   {
   mostki[0]=p;  ilem=1; return;
   }
 if (ilem==1)
   {
   if (mostki[0]!=p)
     { mostki[1]=p;  ilem=2; }
   return;
   }
 if (ilem==2)
   {
   if (mostki[0]!=p && mostki[1]!=p)
     { mostki[2]=p;  ilem=3; }
   return;
   }
 if (ilem==3)
   {
   if (mostki[0]!=p && mostki[1]!=p && mostki[2]!=p)
     { mostki[3]=p;  ilem=4; }
   return;
   }
// jesli ilem==4, to wstawiana kropka musi juz byc w tablicy
// assert(mostki[0]==p || mostki[1]==p || mostki[2]==p || mostki[3]==p);
}

void DodajMozliweMostki(TDwaUC *mostki, int &ilem, TDwaUC g0, TDwaUC g2)
// Znajduje polozenie kropek pomiedzy g0 a g2 i dopisuje znalezione
// kropki do tablicy mostki, o ile juz
// ich nie ma w mostki[0],...,mostki[ilem-1].
{
 int dx = g2.x - g0.x;
 int dy = g2.y - g0.y;
 if (dx<=1 && dx>=-1 && dy<=1 && dy>=-1)
	return;  // kropki g0 i g2 kolo siebie!
 if (dx>2 || dx<-2 || dy>2 || dy<-2)
	return;  // kropki g0 i g2 za daleko od siebie
 if (dx==0)
   {  // musi byc dy== 2 lub -2
   if (dy==2)
     {
     if (g0.x>2) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y+1));
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y+1));
     if (g0.x<=wlkx) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y+1));
     return;
     }
   // tutaj dy==-2
   if (g0.x>2) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y-1));
   MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y-1));
   if (g0.x<=wlkx) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y-1));
   return;
   }
 // tutaj dx!=0
 if (dx>0)
   {
   if (dx==1)
     {
     // tutaj dy== 2 lub -2
     if (dy==2)
       {
       MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y+1));
       MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y+1));
       }
     else
       {
       MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y-1));
       MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y-1));
       }
     return;
     }
   // tutaj dx==2
   if (dy==0)
     {
     if (g0.y>2) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y-1));
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y));
     if (g0.y<=wlky) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y+1));
     return;
     }
   // tutaj dy!=0
   if (dy>0)
     {
     if (dy==1) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y));
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y+1));
     }
   else  // dy<0
     {
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y-1));
     if (dy==-1) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x+1, g0.y));
     }
   return;
   }
 // tutaj dx<0
 if (dx==-1)
   {
   // tutaj dy== 2 lub -2
   if (dy==2)
     {
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y+1));
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y+1));
     }
   else
     {
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y-1));
     MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x, g0.y-1));
     }
   return;
   }
 // tutaj dx==-2
 if (dy==0)
   {
   if (g0.y>2) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y-1));
   MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y));
   if (g0.y<=wlky) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y+1));
   return;
   }
 // tutaj dy!=0
 if (dy>0)
   {
   if (dy==1) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y));
   MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y+1));
   }
 else  // dy<0
   {
   MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y-1));
   if (dy==-1) MostkiDodajKropke(mostki, ilem, TDwaUC(g0.x-1, g0.y));
   }
}


long int OcenSkladoweM(unsigned char* rozgrywka, unsigned char* plansz_p,
		       int ktory_gracz, int na_ruchu,
		       krint* sklnr, krint *goradol,
		       krint *straty_skl,
		       unsigned int ile_sklnr,
		       krint* obszar, krint maska_obszar,
		       int &zagr_kr, int &zagr_ss,
		       int znam_mostki, unsigned int umiejetnosci, int waga_kropki)
// we: sklnr   -- skladowe ,,nierozerwalne''
//     goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     na_ruchu  -- czy gracz ,,ktory_gracz'' jest na ruchu
//     znam_mostki (=0,1,2,3) -- parametr okreslajacy styl gry
//     waga_kropki -- poprawka od wersji 83.32 (!)
//     Funkcja obchodzi tylko pola, dla ktorych (obszar[...] & maska_obszar)
// M w nazwie jest skrotem od ,,mostki''.
// W zagr_kr i zagr_ss zwraca straty zwiazane z podwojnym uderzeniem.
{
 unsigned char* rozg = plansze.PrzydzielPlansze();
 unsigned char* zap_rozg = plansze.PrzydzielPlansze();
 unsigned char* sciezka = plansze.PrzydzielPlansze();
 krint *skldlug = skladowe.PrzydzielSkladowa();
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *sciezka_ind = skladowe.PrzydzielSkladowa();
// CzyscTablice(rozg);  -- juz niepotrzebne
 long int ocena = 0;
 int przec = 3-ktory_gracz;
 // te zmienne sluza do pamietania zagrozen w 1., umozliwia analize podw. uderzenia
 int ile_zagrozen_w1=0;
 struct
   {
   TDwaUC jakie;
   int    kr,ss;
   long int ocena;
   } zagrozenia[20];
 int juz_jest_zap_rozg=0;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   TDwaUC gora;  gora=TDwaUC(upl_x[*goradol], upl_y[*goradol]);  goradol++;
   TDwaUC dol;   dol =TDwaUC(upl_x[*goradol], upl_y[*goradol]);  goradol++;
   if (gora.x) {  // gora.x==0 oznacza skladowa bezpieczna (kolo bandy)
     CzyscTablice(skldlug);
     // CzyscTablice(dad);  chyba niepotrzebne, choc mozna podczas debugowania
     // wstaw kropki do rozg
     if (juz_jest_zap_rozg)
       KopiujTablice(rozg, zap_rozg);
     else {
       for (int indeks=wlkx4wlky4-1; indeks>=0; indeks--)
         // u dolu spr. tez plansz_p & 0x3f, bo nie ma sensu chodzic przez
         // wnetrza stopow
         if ((obszar[indeks] & maska_obszar) && !(plansz_p[indeks] & 0x3f))
           rozg[indeks] = sklnr[indeks] ?
	     (sklnr[indeks]<30000 ? ktory_gracz:przec) :
	     przec;
         else rozg[indeks]=0;
       if (kolejnaskl+1<ile_sklnr)
         {
         juz_jest_zap_rozg=1;
         KopiujTablice(zap_rozg, rozg);
         }
     }
     q4.Wyczysc();
     krint *stosp = &q4.stos[0][max_powierzchnia_planszy];
     krint *stosk = stosp;      // aktualny stos to [stosp, stosk)
     // usun pionowa linie powyzej kropki ,,gora'' i dodaj prawa
     // czesc linii do kolejki
     {
     for (int j=gora.y+1; j<wlky+2; j++) {
       unsigned int indeks=WezIndeksTab(gora.x,j);
       if (sklnr[indeks]>=30000)
         {
         // zobacz trzy kropki na prawo
         for (int l=-1; l<=1; l++)
           {
           unsigned int ind=WezIndeksTab(gora.x+1,j+l);
           if (rozg[ind]==przec && !skldlug[ind])
             {
	       *stosk++ = ind;  
	       skldlug[ind]=1;     dad[ind]=WezIndeksTab(gora.x, j);
             }
           }
         }
       // usun krope
       rozg[indeks]=0;
     }
     // dodaj do kolejki pozostale kropki
     for (int j=gora.y; j<wlky+2; j++) {
       unsigned int indeks=WezIndeksTab(gora.x+1,j);
       if (rozg[indeks]==przec && !skldlug[indeks])
	 {
	   *stosk++=indeks;  dad[indeks]=WezIndeksTab(gora.x, j + (j==gora.y));
	   skldlug[indeks]=2;
	 }
     }
     }

     // przejdz dookola
     unsigned int dlug;
     int dlug_calej_sc=0;
     {
     TDwaUC skad;
     unsigned int teraz;
     do
       {
	 unsigned int indeks = *stosp++;
	 teraz = skldlug[indeks];
	 TDwaUC pn;
	 pn.x=upl_x[indeks];   pn.y=upl_y[indeks];
	 // czy juz jestesmy na miejscu?
	 if (pn.x==gora.x-1 && pn.y>=gora.y) {
	   skad=pn;
	   break;
	 }
	 unsigned int pn_ui = indeks;   // zapamietaj indeks
	 // pole lg
	 indeks -= (wlky+5);
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole ls
	 indeks++;
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole ld
	 indeks++;
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole sg
	 indeks+=(wlky+2);
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole sd
	 indeks+=2;
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole pg
	 indeks+=(wlky+2);
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole ps
	 indeks++;
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
	 // pole pd
	 indeks++;
	 if (rozg[indeks]==przec && skldlug[indeks] == 0)
	   {
	     dad[indeks]=pn_ui;
	     // sprawdz, czy jest polaczenie bezposrednie
	     if (sklnr[indeks]>=30000)  // tak?
	       {
		 skldlug[indeks]=teraz;
		 *(--stosp) = indeks;
	       }
	     else
	       {
		 skldlug[indeks]=teraz+1;
		 *stosk++ = indeks;
	       }
	   }
       }
     while (stosp<stosk);  //(!q.isEmpty());
     dlug=teraz;
     // wyczysc kolejke (w powyzszej petli jest break)
     stosp = stosk = &q4.stos[0][max_powierzchnia_planszy];     //     q.MakeEmpty();
     // czy sie udalo?
     if (dlug>=30000)
       {
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 assert(dlug<30000);
       }
     // teraz zobacz, jak doszlismy do ,,skad'' i ustaw sciezke
     teraz=WezIndeksTab(skad.x, skad.y);
     CzyscTablice(sciezka);
     // CzyscTablice(sciezka_ind);  chyba niepotrzebne, choc mozna podczas debugowania
     TDwaUC gdzie=skad;
     for (;;) {
       sciezka[teraz]=1;
       sciezka_ind[dlug_calej_sc++] = teraz;
       teraz = dad[teraz];
       gdzie.x = upl_x[teraz];       gdzie.y = upl_y[teraz];
       if (gdzie.x==gora.x && gdzie.y>gora.y)
         break;   // doszlismy juz na start
     }
     sciezka[teraz]=1;
     sciezka_ind[dlug_calej_sc++] = teraz;
     // czasami trzeba jeszcze dolozyc do sciezki fragment pionowej linii
     // (mozna by tez dodac dlugosc tego dolozonego kawalka, na razie tego
     //  nie robimy)
     {
     int j;
     int indeks = WezIndeksTab(gdzie.x, gdzie.y-1);
     for (j=gdzie.y-1; j>skad.y; j--)
       {
	 sciezka[indeks]=1;
	 sciezka_ind[dlug_calej_sc++] = indeks;
	 indeks--;
       }
     indeks = WezIndeksTab(gdzie.x, gdzie.y+1);
     for (j=gdzie.y+1; j<skad.y; j++)
       {
	 sciezka[indeks]=1;
	 sciezka_ind[dlug_calej_sc++] = indeks;
	 indeks++;
       }
     }
     }
     // znajdz dlugosc sciezki (jeszcze raz (!))
     // oraz znajdz mostki i wstaw inf. o nich do tablicy ,,dad''
     // (dad[...] == 0 - kropka przec, 1 - puste pole, 2,3,4 - mostek)
     TDwaUC zkropka, zkropki[5];  // ma znaczenie gdy dlugosc==1
     // i sluzy do znalezienia zagrozen w 1.
     // chyba wystarczyloby [4] -- maly zapas
     int ile_w_tab_kropki=0;    // ma znaczenie gdy dlugosc==ile_mostkow==1
     int dlugosc=0;
     int ile_mostkow=0;
     {
     sciezka_ind[dlug_calej_sc  ] = sciezka_ind[0];
     sciezka_ind[dlug_calej_sc+1] = sciezka_ind[1];
     unsigned int sind0 = sciezka_ind[0];
     unsigned int sind1 = sciezka_ind[1];
     for (int i=1; i<=dlug_calej_sc; i++) {
       unsigned int sind2 = sciezka_ind[i+1];
       if (sklnr[sind1]>=30000)
         dad[i]=0;   // kropka przeciwnika
       else
	 {
	   dlugosc++;  zkropka=TDwaUC(upl_x[sind1], upl_y[sind1]);
	   if (sklnr[sind1]>0)   // ta sytuacja nie powinna miec miejsca, ale moze, bo dodajemy kawalek pionowej linii bez zadnej kontroli
	     //|| sklnr[sind0]<30000 || sklnr[sind2]<30000)
	     dad[i]=1;   // ustaw puste pole bez mostku (chociaz tu jest nasza kropka...)
	   else  // puste pole -- moze jest mostek?
	     {
	       TDwaUC skad[3], dokad[3];
	       int ile_skad, ile_dokad;
	       int g0x=upl_x[sind0], g0y=upl_y[sind0];
	       int g1x=upl_x[sind1], g1y=upl_y[sind1];
	       int g2x=upl_x[sind2], g2y=upl_y[sind2];
	       if (sklnr[sind0]>=30000)
		 { skad[0]=TDwaUC(g0x,g0y); ile_skad=1; }
	       else ile_skad=0;
	       if (sklnr[sind2]>=30000)
		 { dokad[0]=TDwaUC(g2x,g2y); ile_dokad=1; }
	       else ile_dokad=0;
	       // zbadaj, czy sa kropki w poblizu
	       if (umiejetnosci & 4)
		 {
		   if (g0x!=g1x && g0y!=g1y)
		     { // pola sind0 i sind1 sa na ukos
		       if (WezUI(sklnr, g0x, g1y) >=30000)
			 skad[ile_skad++]=TDwaUC(g0x, g1y);
		       if (WezUI(sklnr, g1x, g0y) >=30000)
			 skad[ile_skad++]=TDwaUC(g1x, g0y);
		     }
		   if (g1x!=g2x && g1y!=g2y)
		     { // pola g1 i g2 sa na ukos
		       if (WezUI(sklnr, g1x, g2y) >=30000)
			 dokad[ile_dokad++]=TDwaUC(g1x, g2y);
		       if (WezUI(sklnr, g2x, g1y) >=30000)
			 dokad[ile_dokad++]=TDwaUC(g2x, g1y);
		     }
		 }
	       // znajdz mozliwe mostki
	       if (ile_skad && ile_dokad)
		 {
		   TDwaUC mostki[4];
		   int ilem = 0;
		   for (int sk=0; sk<ile_skad; sk++)
		     for (int dok=0; dok<ile_dokad; dok++)
		       DodajMozliweMostki(mostki, ilem, skad[sk], dokad[dok]);
		   dad[i]=0;
		   while (--ilem>=0)
		     {
		       unsigned int ind=WezIndeksTab(mostki[ilem].x, mostki[ilem].y);
		       if (rozgrywka[ind]!=ktory_gracz && !(plansz_p[ind] & 15))
			 zkropki[ dad[i]++ ] = mostki[ilem];  // wolne pole
		     }
		   if (dad[i]>=2) ile_mostkow++;
		   ile_w_tab_kropki = dad[i];
		 }
	       else
		 dad[i]=1;  // puste pole bez mostku
	     }
	 }
       // wez nastepna krope
       sind0=sind1;
       sind1=sind2;
       }
     }
     // mostki sa juz ustawione, teraz oblicz dlugosc_mostki
     int dlugosc_mostki;
     if (dlugosc<=2 || ile_mostkow<=1)
       dlugosc_mostki = dlugosc - ile_mostkow;
     else   // dlugosc > 2 i wiecej niz 1 mostek
       {
       // przepisz cyklicznie tablice ,,dad''
       assert(2*dlugosc+6 < (wlkx+4)*(wlky+4));  // +6, bo czasami patrzymy
       {
       for (int i=1; i<=dlug_calej_sc+6; i++)    // o 5 pol w przod
	 dad[dlug_calej_sc+i] = dad[i]; }
       // znajdz pierwszy mostek
       int i=0;
       while (dad[++i]<=1);
       int koniec=i+dlug_calej_sc;
       int dobre_mostki=0;
       do {
         i++;  // przejdz dalej
         // szukaj nastepnego mostku
         int linia=0;
         do {
           if (dad[i]==1) {  // opusc puste pola
             linia=0;  while (dad[++i]==1);
	   }
           // przejdz linie kropek
	   while (dad[i]==0) { linia++; i++; }
	 }
         while (dad[i]<=1);
         // mamy mostek, przed ktorym bylo ,,linia'' kropek
         if (linia>=5)
           dobre_mostki++;
         else if (linia>=2)
	   { // moze jest linia dlugosci 5 w przod
	   int jest=1;
	   for (int j=1; j<=5; j++)
	     if (dad[i+j]) { jest=0; break; }
	   dobre_mostki+=jest;
	   }
       }
       while (i<koniec);
       dlugosc_mostki = dlugosc - dobre_mostki;
       }
     
     int straty = straty_skl[kolejnaskl];
     int kropki = straty / waga_kropki;          //
     int sstopy = straty - waga_kropki*kropki;   // symulacja strat
     
     // mamy juz wszystkie parametry: (dlug, kropki, sstopy)
     // a takze (dlugosc, dlugosc_mostki)
     // Dobrze by bylo, gdyby dlug==dlugosc, ale tak byc nie musi!
     long int ocena_skl;
     {
       int d= (4-znam_mostki)*dlugosc + znam_mostki*dlugosc_mostki;
       ocena+= ocena_skl = d-straty-4 - (120*straty) / (d+4);
     }
     // zapamietaj zagrozenia w jednym
     if (dlugosc==1 && (umiejetnosci & 1)) {
       if (ile_mostkow==0)
         {
	   zkropki[0]=zkropka;
	   ile_w_tab_kropki=1;
         }
       for (int zk=0; zk<ile_w_tab_kropki; zk++)
         {
	 // wstaw zkropke do zagrozen
         int i=0;
         while (i<ile_zagrozen_w1)
           {
           if (zagrozenia[i].jakie==zkropki[zk]) break;
           i++;
           }
         if (i==ile_zagrozen_w1 && ile_zagrozen_w1<20) {
           zagrozenia[ile_zagrozen_w1].jakie=zkropki[zk];
           zagrozenia[ile_zagrozen_w1].kr=kropki;
           zagrozenia[ile_zagrozen_w1].ss=sstopy;
           zagrozenia[ile_zagrozen_w1].ocena=ocena_skl;
           ile_zagrozen_w1++;
           if (dlugosc_mostki==0 && ile_zagrozen_w1<20)
             {  // jeszcze raz to samo -- bo jest mostek
             zagrozenia[ile_zagrozen_w1].jakie=zkropki[zk];
	     zagrozenia[ile_zagrozen_w1].kr=kropki;
             zagrozenia[ile_zagrozen_w1].ss=sstopy;
             zagrozenia[ile_zagrozen_w1].ocena=ocena_skl;
             ile_zagrozen_w1++;
             }
	 }
         }
     }
   }
   }
 plansze.ZwolnijPlansze(rozg);
 plansze.ZwolnijPlansze(zap_rozg);
 plansze.ZwolnijPlansze(sciezka);
 skladowe.ZwolnijSkladowa(sciezka_ind);
 skladowe.ZwolnijSkladowa(skldlug);
 skladowe.ZwolnijSkladowa(dad);
 // sprawdz podwojne uderzenia
 if (ile_zagrozen_w1 && (umiejetnosci & 1))
   {
   if (na_ruchu)
     { // odrzuc najgorsze zagrozenie
     int najg=0;
     for (int i=1; i<ile_zagrozen_w1; i++)
       if (zagrozenia[i].kr>zagrozenia[najg].kr ||
           (zagrozenia[i].kr==zagrozenia[najg].kr &&
	    zagrozenia[i].ss>zagrozenia[najg].ss))
	 najg=i;
     zagrozenia[najg].kr=0;
     zagrozenia[najg].ss=0;
     zagrozenia[najg].ocena=0;
     }
   // znajdz najgorsze zagrozenie
   zagr_kr=0;  zagr_ss=0;
   int najg=0;
   for (int i=1; i<ile_zagrozen_w1; i++)
     if (zagrozenia[i].kr>zagrozenia[najg].kr ||
	 (zagrozenia[i].kr==zagrozenia[najg].kr &&
	  zagrozenia[i].ss>zagrozenia[najg].ss))
       najg=i;
   zagr_kr=zagrozenia[najg].kr;    zagr_ss=zagrozenia[najg].ss;
   ocena -= zagrozenia[najg].ocena;
   }
 else {
   zagr_kr=0;  zagr_ss=0;
 }
 return ocena;
}


int UstawSkladoweNR(krint* sklnr, krint* goradol,
		    krint *straty_skl,
		    unsigned char* rozg, unsigned char* dod_inf,
     		    unsigned char *rozgrywka, unsigned char *plansz_p,
		    int ktory_gracz, int maska,
		    TDwaUC marg3_min, TDwaUC marg3_max,
		    int waga_kropki)
// we: rozg -- plansza z rozgrywka (wewnatrz stopow kropki wlasciciela stopu)
//             nie niszczy tej tablicy!!!
//     (dod_inf[...] & maska) -- czy na polu [...] jest zagrozenie
//                               dla gracza ktory_gracz
//     marg3_min, _max -- jaka czesc planszy nalezy obejsc
// wy: sklnr, goradol,
//     zwraca liczbe skladowych NR
//     kropki przeciwnika ustawia na 30000
// NR jest skrotem od ,,nierozerwalne''
// szablony:
//    A:   o      B:   .     C:   ,     D:   ,      E: , o    F: o .
//       , o .       , o o      . o .      o o .       o .       , o
//         .           .          o          .
// o  oznacza nie-kropke przeciwnika,
// .          nasza kropke,
// ,          nasza kropke, od ktorej zaczynamy rozpoznawanie szablonu
{
 CzyscTablice(sklnr);
 int przec=3-ktory_gracz;
 {
 for (int i=marg3_min.x; i<=marg3_max.x; i++)
  {
  unsigned int indeks_ij=WezIndeksTab(i,marg3_min.y-1);
  for (int j=marg3_min.y; j<=marg3_max.y; j++) {
    indeks_ij++;
    if (rozg[indeks_ij]==ktory_gracz)
      {
	sklnr[indeks_ij]=50000u;    // zaznacz (chwilowo) nasza kropke
	if (rozg[indeks_ij+wlky+3]==ktory_gracz)    //WezUC(rozg,i+1,j-1)
	  {
	    // szablon typu   , ?   czyli ABCDE
	    //                ? .
	    unsigned int indeks_p= indeks_ij+wlky+4; // WezIndeksTab(i+1,j);
	    unsigned int indeks_d= indeks_ij-1;      // WezIndeksTab(i,j-1);
	    if (rozg[indeks_p]!=przec)
	      {
		// szablon typu   , o   czyli ABE
		//                ? .
		if (rozg[indeks_p]==0)  // puste pole
		  {  // szablon ABE
		    if (rozg[indeks_d]!=przec)  // szablon E
		      {
			if (rozg[indeks_d]==0 && !(dod_inf[indeks_d] & maska))
			  sklnr[indeks_d]=50000u;
			if (!(dod_inf[indeks_p] & maska))
			  sklnr[indeks_p]=50000u;
		      }
		    else   // zostaje jeszcze szablon AB
		      if (!(dod_inf[indeks_p] & maska))
			{
			  unsigned int indeks_pp=indeks_ij+2*wlky+8; //WezIndeksTab(i+2,j);
			  unsigned int indeks_pg=indeks_ij+wlky+5;   //WezIndeksTab(i+1,j+1);
			  if ((rozg[indeks_pp]==ktory_gracz && rozg[indeks_pg]!=przec)//A
			      || (rozg[indeks_pg]==ktory_gracz && rozg[indeks_pp]!=przec))//B
			    sklnr[indeks_p]=50000u;
			}
		  }
		else  // na prawo nasza kropka -- tylko szablon E mozliwy
		  if (rozg[indeks_d]==0 && !(dod_inf[indeks_d] & maska))
		    sklnr[indeks_d]=50000u;
	      }
	    else  // dajemy else, bo sytuacje bez else i tak uchwycimy w szablonie E
	      // moze szablon CD ?
	      if (rozg[indeks_d]==0 && !(dod_inf[indeks_d] & maska))
		{
		  unsigned int indeks_dd=indeks_ij-2;      //WezIndeksTab(i,j-2);
		  unsigned int indeks_ld=indeks_ij-wlky-5; //WezIndeksTab(i-1,j-1);
		  if ((rozg[indeks_dd]==ktory_gracz && rozg[indeks_ld]!=przec)//D
		      || (rozg[indeks_ld]==ktory_gracz && rozg[indeks_dd]!=przec))//C
		    sklnr[indeks_d]=50000u;
		}
	  }
	// sprawdz jeszcze szablon F
	if (rozg[indeks_ij+wlky+5]==ktory_gracz)  //WezUC(rozg,i+1,j+1)
	  {
	    unsigned int indeks_g=indeks_ij+1;        //WezIndeksTab(i,j+1);
	    unsigned int indeks_p=indeks_ij+wlky+4;   //WezIndeksTab(i+1,j);
	    if (rozg[indeks_p]==0)  // puste pole
	      {
		if (rozg[indeks_g]!=przec)
		  {
		    if (!(dod_inf[indeks_p] & maska))
		      sklnr[indeks_p]=50000u;
		    if (rozg[indeks_g]==0 && !(dod_inf[indeks_g] & maska))
		      sklnr[indeks_g]=50000u;
		  }
	      }
	    else if (rozg[indeks_p]!=przec && rozg[indeks_g]==0 &&
		     !(dod_inf[indeks_g] & maska))
	      sklnr[indeks_g]=50000u;
	  }
      }
  }
  }
 }
 // szukaj skladowych
 int ile_s=0;
 krint* stos=skladowe.PrzydzielSkladowa();
 int maska_stopu_przec = ktory_gracz==1 ? 2:1;
 int maska_sstopu      = ktory_gracz==1 ? 4:8;
 for (int px=2; px<wlkx+2; px++)
  {
  unsigned int indeks=WezIndeksTab(px,1);
  for (int py=2; py<wlky+2; py++) {
    indeks++;
    if (sklnr[indeks]==50000u) {
      // przejdz przez skladowa kropki p = [indeks]
      unsigned int ndol=indeks, ngora=indeks;
      int bezpieczne = 0;
      unsigned int na_stosie=1;
      stos[0]=indeks;  ile_s++;
      sklnr[indeks]=ile_s;    // zaznacz, ze pole jest na stosie
      unsigned int kropki=0, sstopy=0;
      do {
	// odwiedz pole
	unsigned int ind=stos[--na_stosie];
	if (upl_marg[ind]==2) bezpieczne=1;
	if (upl_y[ind]<upl_y[ndol]) ndol=ind;
	else if (upl_y[ind]>upl_y[ngora]) ngora=ind;
	// dodaj straty
	if (rozgrywka[ind]==ktory_gracz &&
	    !(plansz_p[ind] & maska_stopu_przec))
	  kropki++;
	if (rozgrywka[ind]==0 &&
	    (plansz_p[ind] & maska_sstopu))
	  sstopy++;
	// idz w dol
	if (sklnr[ind+1]==50000u)
	  {
	    stos[na_stosie++]= ind+1;
	    sklnr[ind+1]=ile_s; }
	// idz w gore
	if (sklnr[ind-1]==50000u)
          {
	    stos[na_stosie++]= ind-1;
	    sklnr[ind-1]=ile_s; }
	// idz w lewo
	if (sklnr[ind-wlky-4]==50000u)
	  {
	    stos[na_stosie++]= ind-wlky-4;
	    sklnr[ind-wlky-4]=ile_s; }
	// idz w prawo
	if (sklnr[ind+wlky+4]==50000u)
          {
	    stos[na_stosie++]= ind+wlky+4;
	    sklnr[ind+wlky+4]=ile_s; }
      }
      while (na_stosie);
      // ustaw goradol
      if (bezpieczne)
	{
	  *goradol++=0;  *goradol++=0;
	}
      else
	{
	  *goradol++=ngora;
	  *goradol++=ndol;
	}
      // ustaw straty
      *straty_skl++ = waga_kropki*kropki+sstopy;
    }
    else if (rozg[indeks]==przec)
      sklnr[indeks]=30000;
  }
  }
 // koniec!
 skladowe.ZwolnijSkladowa(stos);
 return ile_s;
}

unsigned long int szabl32_banda[5][3] =
// uklad pol: np.
//   0 . 1
//   2 3 4
  { {0x00ac, 0x00b1, 0x00e2 },
    {0x005c, 0x0072, 0x00d1 },
    {0x00a0, 0x00b5, 0x00ea },
    {0x0003, 0x0037, 0x00cb },
    {0x0050, 0x0076, 0x00d9 } };

unsigned long int szabl32[8][3] =
// uklad pol: np.
//   0 1 2
//   3 . 4
//   5 6 7
  { {0xf03000, 0xf5756a, 0xfaba95 },
    {0x000cc3, 0x656deb, 0x9a9ed7 },
    {0x3cc000, 0x7de9a9, 0xbed656 },
    {0x0003f0, 0x9557fa, 0x6aabf5 },
//    {0xffffff, 0x000000, 0x000000 },  srodkowe, niepotrzebne pole
    {0x00030f, 0x59abaf, 0xa6575f },
    {0xc3c000, 0xd7d69a, 0xebe965 },
    {0x000c3c, 0x569ebe, 0xa96d7d },
    {0x0f3000, 0x5fbaa6, 0xaf7559 } };

unsigned long long szabl_chwil[16][3] = {

  /* wersja 83.35-, szabl2_chwil.cc
{0xffffb7b78403dbdULL, 0xffffcfcf4bcce77ULL, 0xf03843030c35ULL },
{0x222205050509000ULL, 0xddddfffffaf6fc6ULL, 0x5050000039ULL },
{0xffffeded210cafbULL, 0xffff3f3f1e335feULL, 0xf00c21c0c00faULL },
{0x111182828242000ULL, 0xeeeeffff7dbd3f3ULL, 0x82820000c0cULL },
{0x444428282824000ULL, 0xbbbbffffd7dbf3cULL, 0x282800000c3ULL },
{0xffffdede12c0f6eULL, 0xfffff3f3e133f9bULL, 0xf000c0120c0cf0aULL },
{0x888850505090000ULL, 0x7777ffffaf6fcf9ULL, 0x50500000306ULL },
{0xffff7b7b48307d7ULL, 0xfffffcfcb4ccbedULL, 0xf00304803033c5ULL },
{0xffffb7b78403dbdULL, 0xf03843030c35ULL, 0xffffcfcf4bcce77ULL },
{0x222205050509000ULL, 0x5050000039ULL, 0xddddfffffaf6fc6ULL },
{0xffffeded210cafbULL, 0xf00c21c0c00faULL, 0xffff3f3f1e335feULL },
{0x111182828242000ULL, 0x82820000c0cULL, 0xeeeeffff7dbd3f3ULL },
{0x444428282824000ULL, 0x282800000c3ULL, 0xbbbbffffd7dbf3cULL },
{0xffffdede12c0f6eULL, 0xf000c0120c0cf0aULL, 0xfffff3f3e133f9bULL },
{0x888850505090000ULL, 0x50500000306ULL, 0x7777ffffaf6fcf9ULL },
{0xffff7b7b48307d7ULL, 0xf00304803033c5ULL, 0xfffffcfcb4ccbedULL }};
  */

  //  wersja z szabl3_chwil_nowe, z szablonami bezs dla jednego z graczy
{0xdfb7b7ffffdbdULL, 0x7fcfcfffffe77ULL, 0xf0384000fc35ULL },
{0x9405052222000ULL, 0xfbffffddddfc6ULL, 0x5050000039ULL },
{0xbfededffffafbULL, 0xef3f3fffff5feULL, 0xf0c2100f00faULL },
{0xc882821111000ULL, 0xf7ffffeeee3f3ULL, 0x82820000c0cULL },
{0x3228284444000ULL, 0xfdffffbbbbf3cULL, 0x282800000c3ULL },
{0xefdedefffff6eULL, 0xbff3f3fffff9bULL, 0xfc012f000f0aULL },
{0x6150508888000ULL, 0xfeffff7777cf9ULL, 0x50500000306ULL },
{0x7f7b7bffff7d7ULL, 0xdffcfcffffbedULL, 0xf30480f003c5ULL },
{0xdf00b7b7ffffdbdULL, 0x7f000384000fc35ULL, 0xf00cfcfffffe77ULL },
{0x940005052222000ULL, 0xfb0005050000039ULL, 0xffffddddfc6ULL },
{0xbf00ededffffafbULL, 0xef000c2100f00faULL, 0xf003f3fffff5feULL },
{0xc80082821111000ULL, 0xf70082820000c0cULL, 0xffffeeee3f3ULL },
{0x320028284444000ULL, 0xfd00282800000c3ULL, 0xffffbbbbf3cULL },
{0xef00dedefffff6eULL, 0xbf00c012f000f0aULL, 0xf00f3f3fffff9bULL },
{0x610050508888000ULL, 0xfe0050500000306ULL, 0xffff7777cf9ULL },
{0x7f007b7bffff7d7ULL, 0xdf0030480f003c5ULL, 0xf00fcfcffffbedULL }};
unsigned long long int szabl_chwil_maski[3]= 
  {0xfffffffffffULL, 0xfffffffffffffULL, 0xff00fffffffffffULL};



int PoleBezs12(unsigned char *rozgr3, unsigned int indeks, int chwilowe, int kto=0)
// chwilowe!=0 oznacza, ze bierzemy tez pod uwage chwilowe bezsensowne
//  w tym przypadku mozna podac gracza na ruchu (kto==0 oznacza, ze nie generujemy
//  bezsensownych dla jednego z graczy)
{
  if (upl_marg[indeks]<=2) return 0;   // bierzemy pod uwage tylko pola wewnetrzne
  STOPER_START_BEZS;
  {
  unsigned long int dozwolone = szabl32[0][rozgr3[indeks-wlky-4-1]];
  dozwolone &= szabl32[1][rozgr3[indeks-1]];
  dozwolone &= szabl32[2][rozgr3[indeks+wlky+4-1]];
  dozwolone &= szabl32[6][rozgr3[indeks+1]];
  if (dozwolone) {
    dozwolone &= szabl32[3][rozgr3[indeks-wlky-4]];
    dozwolone &= szabl32[4][rozgr3[indeks+wlky+4]];
    dozwolone &= szabl32[5][rozgr3[indeks-wlky-4+1]];
    dozwolone &= szabl32[7][rozgr3[indeks+wlky+4+1]];
    if (dozwolone) { STOPER_STOP_BEZS; return 1; }  // jest jakis szablon
  }
  }
  if (chwilowe) {
    for (int nrs=0; nrs<=8; nrs+=8) {
      unsigned long long int dozwolone = szabl_chwil[nrs+0][rozgr3[indeks-wlky-4-1]];
      dozwolone &= szabl_chwil[nrs+1][rozgr3[indeks-1]];
      dozwolone &= szabl_chwil[nrs+2][rozgr3[indeks+wlky+4-1]];
      dozwolone &= szabl_chwil[nrs+6][rozgr3[indeks+1]];
      if (dozwolone) {
	dozwolone &= szabl_chwil[nrs+3][rozgr3[indeks-wlky-4]];
	dozwolone &= szabl_chwil[nrs+4][rozgr3[indeks+wlky+4]];
	dozwolone &= szabl_chwil[nrs+5][rozgr3[indeks-wlky-4+1]];
	dozwolone &= szabl_chwil[nrs+7][rozgr3[indeks+wlky+4+1]];
	if (dozwolone & szabl_chwil_maski[kto])
	  { STOPER_STOP_BEZS; return 2; }  // jest jakis szablon chwilowy
      }
    }
  }
  STOPER_STOP_BEZS;
  return 0;
}


void ZnajdzBezs12(unsigned char *bezs, unsigned char *rozgr3,
                  TDwaUC marg1_min, TDwaUC marg1_max, int chwilowe=0)
// ustawia bezs[...] != 0, gdy nie ma sensu analizowac ruchow na polu [...]
// marg1_... - marginesy z zapasem na 1 pole
// Mozliwe ulepszenia: znalezienie skladowych _na_pewno_ bezpiecznych
//  -- takich skladowych nie ma sensu znowu laczyc z banda
// chwilowe!=0 oznacza, ze szukamy tez pol chwilowo bezs. (takie ustawione na 2)
{
 CzyscTablice(bezs);
 // narozniki sa zawsze bez sensu
 WezUC(bezs,2,2)=1;        WezUC(bezs,2,wlky+1)=1;
 WezUC(bezs,wlkx+1,2)=1;   WezUC(bezs,wlkx+1,wlky+1)=1;
 // zbadaj bandy
 if (marg1_min.x<=2)
   { // lewa banda
   unsigned int indeks = WezIndeksTab(2, marg1_min.y);
   for (int j=marg1_min.y; j<=marg1_max.y; j++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-1]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+1]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks+wlky+4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks+wlky+4  ]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks++;
     }
   }
 if (marg1_max.x>wlkx)
   { // prawa banda
   unsigned int indeks = WezIndeksTab(wlkx+1, marg1_min.y);
   for (int j=marg1_min.y; j<=marg1_max.y; j++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-1]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+1]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks-wlky-4  ]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks-wlky-4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks++;
     }
   }
 if (marg1_min.y<=2)
   { // gorna banda
   unsigned int indeks = WezIndeksTab(marg1_min.x, 2);
   for (int i=marg1_min.x; i<=marg1_max.x; i++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-wlky-4]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+wlky+4]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4+1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks       +1]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks+=wlky+4;
     }
   }
 if (marg1_max.y>wlky)
   { // dolna banda
   unsigned int indeks = WezIndeksTab(marg1_min.x, wlky+1);
   for (int i=marg1_min.x; i<=marg1_max.x; i++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-wlky-4]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+wlky+4]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks       -1]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4-1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks+=wlky+4;
     }
   }
 // zbadaj wnetrze
 if (marg1_min.x<=2) marg1_min.x=3;
 if (marg1_min.y<=2) marg1_min.y=3;
 if (marg1_max.x>wlkx) marg1_max.x=wlkx;
 if (marg1_max.y>wlky) marg1_max.y=wlky;
 for (int i=marg1_min.x; i<=marg1_max.x; i++)
  {
  unsigned int indeks = WezIndeksTab(i, marg1_min.y);
  for (int j=marg1_min.y; j<=marg1_max.y; j++)
    {
    if (rozgr3[indeks]==0)
      // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
      bezs[indeks]= PoleBezs12(rozgr3, indeks, chwilowe);
    indeks++;
    }
  }
}

#define  BYLECO   1
#define  WOLNE    2
#define  NASZA    4
#define  PRZEC    8
#define  PUSTE    16
#define  NIENASZA 32
// WOLNE oznacza puste pole, na ktorym nie ma zagrozenia i ktore
// nie jest jeszcze zaznaczone oraz jest wewnatrz planszy;
// PUSTE oznacza puste pole, na ktorym moze byc zagrozenie lub zaznaczenie,
// a nawet poza plansza
typedef unsigned char TSzablon[9];
#define ILE_SZABLONOW 34
TSzablon szablony[ILE_SZABLONOW] = {
  // najpierw 4 szablony 2x2
  { WOLNE,NASZA,BYLECO, NASZA,PRZEC,BYLECO, BYLECO,BYLECO,BYLECO },
  { PRZEC,NASZA,BYLECO, NASZA,WOLNE,BYLECO, BYLECO,BYLECO,BYLECO },
  { NASZA,WOLNE,BYLECO, PRZEC,NASZA,BYLECO, BYLECO,BYLECO,BYLECO },
  { NASZA,PRZEC,BYLECO, WOLNE,NASZA,BYLECO, BYLECO,BYLECO,BYLECO },
  // dwa szablony typu D
  { BYLECO,NASZA,BYLECO, PRZEC,WOLNE,PRZEC, BYLECO,NASZA,BYLECO },
  { BYLECO,PRZEC,BYLECO, NASZA,WOLNE,NASZA, BYLECO,PRZEC,BYLECO },
  // cztery szablony typu A
  { NASZA,NIENASZA,BYLECO, PRZEC,WOLNE,NIENASZA, BYLECO,NASZA,BYLECO },
  { NASZA,PRZEC,BYLECO,    NIENASZA,WOLNE,NASZA, BYLECO,NIENASZA,BYLECO },
  { BYLECO,NIENASZA,NASZA, NIENASZA,WOLNE,PRZEC, BYLECO,NASZA,BYLECO },
  { BYLECO,PRZEC,NASZA,    NASZA,WOLNE,NIENASZA, BYLECO,NIENASZA,BYLECO },
  // cztery szablony typu B
  { BYLECO,NASZA,BYLECO,    NIENASZA,WOLNE,PRZEC, BYLECO,NIENASZA,NASZA },
  { BYLECO,NIENASZA,BYLECO, NASZA,WOLNE,NIENASZA, BYLECO,PRZEC,NASZA },
  { BYLECO,NASZA,BYLECO,    PRZEC,WOLNE,NIENASZA, NASZA,NIENASZA,BYLECO },
  { BYLECO,NIENASZA,BYLECO, NIENASZA,WOLNE,NASZA, NASZA,PRZEC,BYLECO },
  // cztery szablony typu C
  { BYLECO,NASZA,NIENASZA,  PRZEC,PRZEC,WOLNE,    BYLECO,NASZA,NIENASZA },
  { BYLECO,PRZEC,BYLECO,    NASZA,PRZEC,NASZA,    NIENASZA,WOLNE,NIENASZA },
  { NIENASZA,NASZA,BYLECO,  WOLNE,PRZEC,PRZEC,    NIENASZA,NASZA,BYLECO },
  { NIENASZA,WOLNE,NIENASZA,NASZA,PRZEC,NASZA,    BYLECO,PRZEC,BYLECO } ,
  // szablony - antyweze
  { PUSTE,WOLNE,PUSTE,      PUSTE,PRZEC,NASZA,    NASZA,PRZEC,NASZA },
  { PUSTE,WOLNE,PUSTE,      NASZA,PRZEC,PUSTE,    NASZA,PRZEC,NASZA },
  { PUSTE,NASZA,NASZA,      WOLNE,PRZEC,PRZEC,    PUSTE,PUSTE,NASZA },
  { PUSTE,PUSTE,NASZA,      WOLNE,PRZEC,PRZEC,    PUSTE,NASZA,NASZA },
  { NASZA,PRZEC,NASZA,      NASZA,PRZEC,PUSTE,    PUSTE,WOLNE,PUSTE },
  { NASZA,PRZEC,NASZA,      PUSTE,PRZEC,NASZA,    PUSTE,WOLNE,PUSTE },
  { NASZA,PUSTE,PUSTE,      PRZEC,PRZEC,WOLNE,    NASZA,NASZA,PUSTE },
  { NASZA,NASZA,PUSTE,      PRZEC,PRZEC,WOLNE,    NASZA,PUSTE,PUSTE },
  // szablony umozliwiajace zastosowanie prostej sztuczki -- mostku
  { PUSTE,PUSTE,NASZA,      WOLNE,PRZEC,BYLECO,   NASZA,BYLECO,BYLECO },
  { PUSTE,WOLNE,NASZA,      PUSTE,PRZEC,BYLECO,   NASZA,BYLECO,BYLECO },
  { BYLECO,BYLECO,NASZA,    BYLECO,PRZEC,PUSTE,   NASZA,WOLNE,PUSTE },
  { BYLECO,BYLECO,NASZA,    BYLECO,PRZEC,WOLNE,   NASZA,PUSTE,PUSTE },
  { NASZA,WOLNE,PUSTE,      BYLECO,PRZEC,PUSTE,   BYLECO,BYLECO,NASZA },
  { NASZA,PUSTE,PUSTE,      BYLECO,PRZEC,WOLNE,   BYLECO,BYLECO,NASZA },
  { NASZA,BYLECO,BYLECO,    PUSTE,PRZEC,BYLECO,   PUSTE,WOLNE,NASZA },
  { NASZA,BYLECO,BYLECO,    WOLNE,PRZEC,BYLECO,   PUSTE,PUSTE,NASZA }
  };


void UstawCiekawe(unsigned char* rozgr2, unsigned char* rozgr3,
                  unsigned char* dod_inf, int ktory_gracz, int maska,
                  int i, int j, krint* zagrozenia, int &ile_zagrozen)
// Ustawia bit 4 (maska 32) w polach dod_inf,
// zwieksza ile_zagrozen i dopisuje nowe zagrozenia do tablicy.
// Nie zmienia rozgr2 ani rozgr3.
{
 TSzablon sz;
 // ustaw szablon z planszy
 {
 unsigned int ind=WezIndeksTab(i,j);
 int przec = 3-ktory_gracz;
 int p = 0;
 for (int di=0; di<3; di++)
  {
  for (int dj=0; dj<3; dj++)
   {
   if (rozgr2[ind]==ktory_gracz)
     sz[p] = NASZA | BYLECO;
   else if (rozgr2[ind]==przec)
     sz[p] = PRZEC | NIENASZA | BYLECO;
   else if (rozgr3[ind]==0)
     {
	  if ((dod_inf[ind] & maska) || (j+dj>wlky+1 || i+di>wlkx+1))
       sz[p] = PUSTE | NIENASZA | BYLECO; // zagrozone lub zaznaczone, albo poza plansza
     else
       sz[p] = WOLNE | PUSTE | NIENASZA | BYLECO;  // wolne
     }
   else
     sz[p] = NIENASZA | BYLECO;
   ind++; p++;
   }
  ind+=wlky+1;
  }
 }
 // sprawdzaj kolejne szablony
 TSzablon *szablon=szablony;
 for (int nr_szablonu=0; nr_szablonu<ILE_SZABLONOW; nr_szablonu++)
   {
   int ok=1, puste;
   for (int p=0; p<9; p++)
     {
     if (!(sz[p] & (*szablon)[p]))
       { ok=0; break; }
     if ((*szablon)[p]==WOLNE)
       puste=p;
     }
   if (ok) // zgadza sie z szablonem!
     {
     sz[puste] &= (~WOLNE); // to pole juz nie bedzie puste - ustawiamy zagr.
     int di=0, dj=puste;
     if (dj>=3) { dj-=3; di++; }
     if (dj>=3) { dj-=3; di++; }
     // ustaw zagrozenie
     WezUC(dod_inf, i+di, j+dj) |= 32;
     zagrozenia[ile_zagrozen++] = ((i+di)<<8) + j+dj;
     }
   szablon++;
   }
}

void Spermutuj(krint *tab, int odkad, int dokad)
// Permutuje elementy:  tab[odkad], tab[odkad+1], ..., tab[dokad-1].
{
 for (int i=dokad-1; i>odkad; i--)
   {
   int np = random(i-odkad+1) + odkad;
   // zamien [np] z [i]
   krint tmp=tab[i];
   tab[i]=tab[np];  tab[np]=tmp;
   }
}

void ZnajdzNajlepszyRuchSNR2(unsigned char* rozgrywka, unsigned char* plansz_p,
	  int ktory_gracz,
	  TGraczO gracz,
//     int agresja, int przejmuje_sie, int znam_mostki, int dokl_analizy,
//     unsigned int umiejetnosci,
     int &x, int &y, int st_x, int st_y)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
// SNR w nazwie funkcji jest skrotem od ,,skladowe nierozerwalne''
// W strukturce gracz patrzymy na pola agresja, przejmuje_sie, dokl_analizy
//  oraz umiejetnosci.
// parametry agresja (= -9,...,9)
// oraz przejmuje_sie (= 30..129)
// odpowiadaja za styl gry;
// a parametr dokl_analizy (=1,2) za sile (WYLACZONY -- wersje 75+)
// Zdefiniowane bity ,,umiejetnosci'':
//   bit 0 (maska &1)  -- rozpoznaje podw. uderzenia w OcenSkladoweM(),
//   bit 1 (maska &2)  -- rozpoznaje podw. uderzenia w ZnajdzNajlRuchSNR2(),
//   bit 2 (maska &4)  -- ulepszone rozpoznawanie mostkow.
  // bit 4 (maska &0x10)  niska ocena duzych brzuszkow
// W porownaniu do ZNRuchSNR() potrafi analizowac na glebokosci ,,1/2''.
{
 if (st_x==0 && st_y==0)
   {
     // to jest pierwsza kropka!
     int margx = (wlkx>>2)-1;
     margx=margx<2 ? 2:margx;
     int margy = (wlky>>2)-1;
     margy=margy<2 ? 2:margy;
     x = 2+margx+random(wlkx-2*margx);
     y = 2+margy+random(wlky-2*margy);
     return;
   }
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka, plansz_p, ile_wolnego, ile_wolnego_poza);

 if (ile_wolnego_poza) { // sa jakies wolne miejsca poza stalymi stopami
   int znam_mostki=2;  // (=0,1,2,3)
   // zapamietaj rozgrywke i plansz_p
   unsigned char* t1 = plansze.PrzydzielPlansze();
   unsigned char* t2 = plansze.PrzydzielPlansze();
   unsigned char* t3 = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   unsigned int dokad=(wlkx+4)*(wlky+4);
   KopiujTablice(t1, rozgrywka);
   KopiujTablice(t2, plansz_p);
   // przygotuj plansze z rozgrywka, usuwajac (rozgr2)
   //  lub wstawiajac (rozgr3) kropki wewnatrz stopow
   WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
   KopiujTablice(t3, rozgr3);
   // przygotuj tablice z numerami skladowych
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   CzyscTablice(skl_tab);
   TDwaUC rog_min = TDwaUC(wlkx+2, wlky+2), rog_max = TDwaUC(0,0);
   int maska_naszego_stopu = ktory_gracz==1 ? 4+1:8+2;
   {
   unsigned int num_skl_n=1;
   unsigned int num_skl_p=30001;
   TDwaUC p;
   for (p.x=2; p.x<wlkx+2; p.x++)
    for (p.y=2; p.y<wlky+2; p.y++)
      {
      unsigned int indeks_ij = WezIndeksTab(p.x,p.y);
      unsigned char kr=rozgr2[indeks_ij];
		if (kr!=0)
        {
        if (p.x<rog_min.x) rog_min.x=p.x;
        if (p.y<rog_min.y) rog_min.y=p.y;
        if (p.x>rog_max.x) rog_max.x=p.x;
        if (p.y>rog_max.y) rog_max.y=p.y;
        if (skl_tab[indeks_ij]==0)
        if (kr==ktory_gracz)
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_n++, indeks_ij);
        else
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_p++, indeks_ij);
        }
      }
   }
   // wez margines na jedno pole
   if (rog_min.x>2) rog_min.x--;      if (rog_min.y>2) rog_min.y--;
   if (rog_max.x<=wlkx) rog_max.x++;  if (rog_max.y<=wlky) rog_max.y++;
   // znajdz zagrozenia
   krint *zagrozenia  = skladowe.PrzydzielSkladowa();
   // tablica dod_inf (dodatkowe informacje) -- znaczenie bitow:
   //   & 1  -- stawiajac tu kropke przeciwnik ma staly stop
   //   & 2  -- stawiajac tu kropke przeciwnik ma stop
   //   & 4  -- to pole moge zamknac natychmiast
   //           (czyli tu przeciwnik nie powinien stawiac kropki)
   //   & 8  -- stawiajac tu kropke mam stop (staly lub zwykly)
	//   & 16 -- to pole moze zostac natychmiast zamkniete przez przeciwnika
   //           (czyli tu nie powinienem stawiac kropki)
   //   & 32 -- ten ruch jest ,,ciekawy'' (zagrozenie lub szansa)
   //   & 128 - ten ruch bedzie analizowany, tj. bedziemy probowac stawiac
   //           tu nasza kropke (kropke przeciwnika niekoniecznie)
   unsigned char* dod_inf = plansze.PrzydzielPlansze();
   CzyscTablice(dod_inf);
   int ile_zagrozen=0, max_ile_zd=0, max_pow=0;
   unsigned int najgrozniejsze=0;  // indeks najgrozniejszego zagrozenia
   int ile_bezs=0;   // ile jest ruchow bezsensownych (dod_inf[...] & 16)
   {
   for (int i=rog_min.x; i<=rog_max.x; i++)
    for (int j=rog_min.y; j<=rog_max.y; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if (rozgr3[indeks_ij]==0 && CzyMozliwyStop(skl_tab, rozgr2, i,j, 3-ktory_gracz))
      {
      int ile_zd=0, pow=0, pow2=0;
      int punktacja_ss;
      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz,
                  ile_zd,pow,pow2,punktacja_ss);
      if (gracz.umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
      rozgrywka[indeks_ij]=0;  // usun kropke
      if (ile_zd>0 || pow>0)
        {
        zagrozenia[ile_zagrozen++]=(i<<8)+j;
        if (pow>0)    dod_inf[indeks_ij]|=33;
        if (ile_zd>0) dod_inf[indeks_ij]|=34;
        if (ile_zd>max_ile_zd || (ile_zd==max_ile_zd && pow-pow2>max_pow))
          {
          max_ile_zd=ile_zd;  max_pow=pow-pow2;
          najgrozniejsze=indeks_ij;
          }
        }
      if (ile_zd || pow || pow2)
        {
        for (int i=dokad-1; i>=0; i--)
          if (plansz_p[i]!=t2[i])
            dod_inf[i]|=16;
        KopiujTablice(plansz_p, t2);
        }
      }
     }
   }
   // niektore sposrod znalezionych zagrozen moga byc pozorne, sprawdz to
   // i dodatkowo znajdz szanse
	{
   for (int i=rog_min.x; i<=rog_max.x; i++)
    for (int j=rog_min.y; j<=rog_max.y; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if (rozgr3[indeks_ij]==0 && CzyMozliwyStop(skl_tab, rozgr2, i,j, ktory_gracz))
      {
      int ile_zd=0, pow=0, pow2=0;
      int punktacja_ss;
      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz,
                  ile_zd,pow,pow2,punktacja_ss);
      if (gracz.umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
      rozgrywka[indeks_ij]=0;  // usun kropke
      if (ile_zd>0 || pow>0)
        {
        dod_inf[indeks_ij] |= 40;     // mozemy cos zamknac, wiec
        dod_inf[indeks_ij] &= (~16);  // moze ten ruch nie jest taki zly...
        // zapamietaj ruch jako ciekawy
        zagrozenia[ile_zagrozen++]=(i<<8)+j;
        }
      else if (dod_inf[indeks_ij] & 16)
        ile_bezs++;                // ten ruch jest zly!
      if (ile_zd || pow || pow2)
        {
        for (int i=dokad-1; i>=0; i--)
          if (plansz_p[i]!=t2[i])
            dod_inf[i]|=4;
        KopiujTablice(plansz_p, t2);
        }
      }
     }
   }
   // czy sa jakies dobre ruchy?
   if (ile_bezs==ile_wolnego_poza)
     { // wszystkie ruchy sa bezsensowne! (czy to w ogole mozliwe?)
     int ktory=random(ile_wolnego_poza);
     for (int i=2; i<wlkx+2; i++)
      for (int j=2; j<wlky+2; j++)
        if ((WezUC(plansz_p,i,j) & 15)==0 && // nie wewnatrz stopu lub sstopu
             WezUC(rozgrywka,i,j)==0)        // nie ma tu jeszcze kropki
          if ((ktory--) ==0)
            {
            x=i;  y=j;
            goto Wyjdz_stad;
            }
     }
	// znajdz szanse i zagrozenia dla struktury (tzn. dla skladowych)
   {
   for (int i=rog_min.x; i<=rog_max.x; i++)
    for (int j=rog_min.y; j<=rog_max.y; j++)
     {
     // ustaw ruchy, ktore pozwalaja nam ,,wylezc''
	  UstawCiekawe(rozgr2, rozgr3, dod_inf, ktory_gracz, 32+4, i,j,
						zagrozenia, ile_zagrozen);
	  // ustaw ruchy, ktore pozwalaja ,,wylezc'' przeciwnikowi
	  UstawCiekawe(rozgr2, rozgr3, dod_inf, 3-ktory_gracz, 32+16, i,j,
						zagrozenia, ile_zagrozen);
	  }
	}
   // i dodatkowe szanse i zagrozenia dla struktury
	{
	krint *obszar = skladowe.PrzydzielSkladowa();
	ZnajdzObszary(obszar, rozgr2);
/* WYLACZONE w wersjach 75+
	if (gracz.dokl_analizy>=2)
	  {
	  for (int i=rog_min.x; i<=rog_max.x; i++)
		for (int j=rog_min.y; j<=rog_max.y; j++)
		 {
		 unsigned int indeks_ij = WezIndeksTab(i,j);
		 if (rozgr3[indeks_ij]==0 &&                  // puste pole
			  (dod_inf[indeks_ij] & 0x14)==0 &&
			  (obszar[indeks_ij] & 0x50)==0x50)        // blisko innych kropek
			zagrozenia[ile_zagrozen++] = (i<<8)+j;
		 }
	  } */
	// wywal z zagrozen glupie ruchy
	{
	int z=ile_zagrozen-1;
	while (z>=0)
	  {
	  int iz = (zagrozenia[z] >> 8);
	  int jz = (zagrozenia[z] & 0xff);
	  unsigned int indeks_ijz = WezIndeksTab(iz,jz);
	  if ((dod_inf[indeks_ijz] & 7) == 4)  // stawiajac tu kropke przeciwnik
		 {          // nic nie zyskuje, a wstawiona kropke moze zaraz stracic
		 ile_zagrozen--;
		 if (z<ile_zagrozen) zagrozenia[z]=zagrozenia[ile_zagrozen];
		 }
	  z--;
	  }
	}
	// przygotuj sie do analizy kolejnych ruchow
	long int ocena_najl= -MAXLONG-1;
	krint *sklnr  =skladowe.PrzydzielSkladowa(),
	  *goradol=skladowe.PrzydzielSkladowa(),
	  *straty_skl=skladowe.PrzydzielSkladowa();
	unsigned char *plansz_p2  = plansze.PrzydzielPlansze(),
					  *rozgr3_nowa= plansze.PrzydzielPlansze();
   TDwaUC marg3_min=rog_min, marg3_max=rog_max;
   if ((marg3_min.x-=2) < 2) marg3_min.x=2;
	if ((marg3_min.y-=2) < 2) marg3_min.y=2;
	if ((marg3_max.x+=2) >= wlkx+2) marg3_max.x=wlkx+1;
	if ((marg3_max.y+=2) >= wlky+2) marg3_max.y=wlky+1;
	// znajdz ruchy, ktore trzeba przeanalizowac
	krint *kolejne_ruchy=skladowe.PrzydzielSkladowa();
	int ile_ruchow=0;
	{
	int ile_spermut=0;
	for (int i=marg3_min.x; i<=marg3_max.x; i++)
	 for (int j=marg3_min.y; j<=marg3_max.y; j++)
		{
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if ((dod_inf[indeks_ij] & 0x30)==0x20  // analizuj tylko ciekawe i takie, ze postawionej kropki nie stracimy natychmiast
			  && rozgr3[indeks_ij]==0)
		  {
		  kolejne_ruchy[ile_ruchow++] = (i<<8)+j;
		  dod_inf[indeks_ij] |= 128;
		  }
		}
   Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
   ile_spermut=ile_ruchow;
   // znajdz bezsensowne...
   {
   unsigned char *bezs = plansze.PrzydzielPlansze();
   ZnajdzBezs12(bezs, rozgr3, marg3_min, marg3_max);
   // teraz wez kolejne otoczki
   for (int m=0; m<=3; m++)
     {
     int maski[4]={0x50, 1,2,4};
     int maska=maski[m];
     for (int i=marg3_min.x; i<=marg3_max.x; i++)
      for (int j=marg3_min.y; j<=marg3_max.y; j++)
        {
        unsigned int indeks_ij = WezIndeksTab(i,j);
        if ((obszar[indeks_ij] & maska)==maska
            && (dod_inf[indeks_ij] & 0x90)==0
            && rozgr3[indeks_ij]==0
            && !bezs[indeks_ij])
          {
          kolejne_ruchy[ile_ruchow++] = (i<<8)+j;
          dod_inf[indeks_ij] |= 128;
          }
        }
     Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
     ile_spermut=ile_ruchow;
     }
   plansze.ZwolnijPlansze(bezs);
   }
   }
   // sprawdz, ile jest ruchow...
   if (ile_ruchow<=1)
     {
     if (ile_ruchow==1)
       {
       x=(kolejne_ruchy[0] >> 8);
       y=(kolejne_ruchy[0] & 0xff);
       goto Zwolnij_pamiec;
       }
     // trzeba znalezc jakis sensowny ruch (jesli tutaj dojdziemy,
     //  to chyba nie moze byc zadnych zagrozen! -- wiec mozna ten ruch
     //  wylosowac...
     int ktory=random(ile_wolnego_poza);
     for (int i=0; i<wlkx; i++)
      {
      unsigned int indeks=WezIndeksTab(i+2,2);
      for (int j=0; j<wlky; j++)
        {
        if ((plansz_p[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
             rozgrywka[indeks]==0)        // nie ma tu jeszcze kropki
          if ((ktory--) ==0)
            {
            x=i+2;  y=j+2;
            goto Zwolnij_pamiec;
            }
        indeks++;
        }
      }
     printf("Blad... ,,mucha'' - przycisnij cos");
     #ifndef TEKSTOWY
     GrKeyRead();
     #endif
     strcpy(pargry.nz1, "krbladm.z");
     gra.ObsluzZdarzenie(ZD_ZAPIS);
     exit(1);  // blad!
     }
   {
   // znajdz odpowiedzi przeciwnika, po ktorych mozliwe podwojne uderzenie
   // znaczenie bitow:
   //   0-7  zagrozenia w odpowiednich kierunkach, zob. kierunki_dx i _dy
   //   8-11 numer (pewnego) zagrozenia, ktore juz jest
   //  12-15 liczba zagrozen, ktore juz sa
   // Jesli jest tylko jedno zagrozenie w ogole, lub zadnego zagrozenia
   // juz teraz, to ustawiamy podw_uderz[...]=0.
	krint *podw_uderz  =skladowe.PrzydzielSkladowa();
   unsigned char *plansz_p_PU =plansze.PrzydzielPlansze();
   if (gracz.umiejetnosci & 2)
     {
     CzyscTablice(podw_uderz);
     for (int z=0; z<ile_zagrozen; z++)
       {
       int i = (zagrozenia[z] >> 8);
       int j = (zagrozenia[z] & 0xff);
       unsigned int indeks_ij = WezIndeksTab(i,j);
       unsigned int pu=0;
       int ile_juz_zagr=0, num_zagr=0, przyszlych_zagr=0;
       int maska=1;
       int odtworz_plansz_p=0;
       // zrob ruch
       int kr=0, pow=0, pow2=0;
       if (dod_inf[indeks_ij] & 3)  // przeciwnik zamyka (staly) stop
         {
         int punktacja_ss;
         ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz,
                     kr, pow, pow2, punktacja_ss);
         odtworz_plansz_p = (kr || pow || pow2);
	 if (gracz.umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
         KopiujTablice(plansz_p2, plansz_p);
         }
       else
         rozgrywka[indeks_ij] = 3-ktory_gracz;  // zrob ruch
       // teraz zrob drugi ruch
       for (int k=0; k<8; k++)
         {
         int ni = i + kierunki_dx[k];
         int nj = j + kierunki_dy[k];
         unsigned int indeks_nij = WezIndeksTab(ni,nj);
	 if (ni>=2 && ni<wlkx+2 && nj>=2 && nj<wlky+2 &&
	     rozgr3[indeks_nij]==0)
	   {
	     // zrob drugi ruch
	     kr=0;  pow=0;  pow2=0;
	     int punktacja_ss;
	     ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, ni,nj,3-ktory_gracz,
			 kr, pow, pow2, punktacja_ss);
	     //  if (gracz.umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	     if (kr || pow || pow2)
	       {
		 if (kr)
		   { ile_juz_zagr++;  num_zagr=k;  pu|=maska; }
		 else
		   { przyszlych_zagr++;  pu|=maska; }
		 // odtworz plansze
		 KopiujTablice(plansz_p, odtworz_plansz_p ? plansz_p2:t2);
	       }
	     WezUC(rozgrywka, ni, nj)=0;  // usun kropke
	   }
	 maska<<=1;
	 }
       rozgrywka[indeks_ij]=0;
		 if (odtworz_plansz_p)
			KopiujTablice(plansz_p, t2);
		 // zapamietaj dane o podwojnych uderzeniach
		 if (ile_juz_zagr && (ile_juz_zagr+przyszlych_zagr >=2))
			podw_uderz[indeks_ij] = (pu | (num_zagr<<8) | (ile_juz_zagr<<12));
		 }
	  }
	// analizuj!
	KopiujTablice(rozgr3, t3);
	for (int kol_ruch=0; kol_ruch<ile_ruchow; kol_ruch++)
	  {
	  int i=(kolejne_ruchy[kol_ruch] >> 8);
	  int j=(kolejne_ruchy[kol_ruch] & 0xff);
	  unsigned int indeks_ij = WezIndeksTab(i,j);
	  int zyski_k=0, zyski_ss=0, odtworz_plansz_p=0;
	  // zrob ruch i zobacz jakie sa zyski
	  if (dod_inf[indeks_ij] & 8)  // zamykam (staly) stop
	    {
	      int pow2=0, punktacja_ss;
	      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz,
			  zyski_k, zyski_ss, pow2, punktacja_ss);
	      odtworz_plansz_p = (zyski_k || zyski_ss || pow2);
	      KopiujTablice(plansz_p2, plansz_p);
	      if (gracz.umiejetnosci & 0x10)
		zyski_ss=punktacja_ss;
	      else
		zyski_ss -= pow2;
	    }
	  else
	    rozgrywka[indeks_ij] = ktory_gracz;  // zrob ruch
	  // analizuj ,,ciekawe'' odpowiedzi przeciwnika
	  long int ocena = MAXLONG;
	  {
	  for (int z=0; z<ile_zagrozen; z++)
	    {
	      int iz = (zagrozenia[z] >> 8);
	      int jz = (zagrozenia[z] & 0xff);
	      if (iz==i && jz==j)
		continue;  // zagrozenie nieaktualne - postawilismy kropke
	      unsigned int indeks_ijz = WezIndeksTab(iz,jz);
	      if (plansz_p[indeks_ijz] & maska_naszego_stopu)
		continue;  // zagrozenie nieaktualne - zamknelismy (staly) stop
	      // wykonaj ruch i oblicz straty
	      int straty_ss=0, straty_k=0, odtworz_plansz_p2=0;
	      int zyski_kn=zyski_k, zyski_ssn=zyski_ss;
	      if (dod_inf[indeks_ijz] & 3)  // przeciwnik (byc moze) zamyka (staly) stop
		{
		  int pow2=0, punktacja_ss;
		  ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, iz,jz,3-ktory_gracz,
			      straty_k,straty_ss,pow2,punktacja_ss);
		  odtworz_plansz_p2=(straty_k || straty_ss || pow2);
		  if (gracz.umiejetnosci & 0x10) 
		    straty_ss=punktacja_ss;
		  else
		    straty_ss -=pow2;
		}
	      else
		rozgrywka[indeks_ijz]=3-ktory_gracz;  // postaw kropke
	      // znamy juz straty, mamy ustawiona rozgrywke i plansz_p
	      // teraz uaktualnij rozgr3
		 {
		 rozgr3[indeks_ij]=ktory_gracz;
		 rozgr3[indeks_ijz]=3-ktory_gracz;
		 if (odtworz_plansz_p || odtworz_plansz_p2)
			{
			for (unsigned int i=0; i<dokad; i++)
			  {
           if (plansz_p[i] & 0x5)  // pole jest wewnatrz stopu lub stalego stopu gr1
             rozgr3[i]=1;          // wiec wstaw kropke ,,1'' w rozgr3
           else if (plansz_p[i] & 0xa)
             rozgr3[i]=2;          // ...lub kropke ,,2'', jesli to jest u gracza 2
			  }
			}
		 }
		 // ocen moje skladowe
		 long int moje_s, jego_s=MAXLONG;
		 {
		 int ile_sklnr=UstawSkladoweNR(sklnr, goradol, straty_skl,
					       rozgr3, dod_inf, rozgrywka, plansz_p,
					       ktory_gracz, 16, marg3_min, marg3_max,
					       gracz.waga_kropki);
		 int zagr_kr, zagr_ss;
		 moje_s=OcenSkladoweM(rozgrywka, plansz_p,
				      ktory_gracz, 1,
				      sklnr, goradol, straty_skl,
				      ile_sklnr,
				      obszar, DajMaske(obszar[indeks_ij], obszar[indeks_ijz]),
				      zagr_kr, zagr_ss,
				      znam_mostki, gracz.umiejetnosci, gracz.waga_kropki);
		 straty_k+=zagr_kr;  straty_ss+=zagr_ss;
		 // sprawdz podwojne uderzenia
		 if ((gracz.umiejetnosci & 2) && podw_uderz[indeks_ijz] &&
		     (podw_uderz[indeks_ijz]>0x1000 ||
		      (i-iz<=1 && i-iz>=-1 && j-jz<=1 && j-jz>=-1)))
		   {
		     int num_zagr = ((podw_uderz[indeks_ijz] & 0x0f00) >> 8);
		     int strac_kr_PU = 0;  // stracone kropki w wyniku podw. uderzenia
		     int ile_fakt_zagr=0;
		     int maska=1, k=-1;
		     do
		       {
			 if (++k) maska<<=1;
			 if (k==num_zagr) { k++; maska<<=1; }
			 if (k==8)
			   if (jego_s==MAXLONG)
			     break;   // nie bedzie podwojnego uderzenia
			   else
			     {
			       k=num_zagr;
			       maska=0xff;  // zagrozenie num_zagr na pewno jest
			     }
  if (podw_uderz[indeks_ijz] & maska)
    {
      // wez pole
      int ni=iz+kierunki_dx[k];
      int nj=jz+kierunki_dy[k];
      unsigned int indeks_nij;
      if ((ni!=i || nj!=j) &&
	  (plansz_p[indeks_nij=WezIndeksTab(ni,nj)] &
	   maska_naszego_stopu)==0)
	{
	  // mozna stawiac kropke
	  int kr=0, pow=0, pow2=0,punktacja_ss;
	  if (jego_s==MAXLONG)
	    KopiujTablice(plansz_p_PU, plansz_p);
	  ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, ni,nj,3-ktory_gracz,
		      kr,pow,pow2,punktacja_ss);
	  // if (gracz.umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	  if (kr)
	    {
	      // ustaw rozgr3_nowa
	      {
		KopiujTablice(rozgr3_nowa, rozgrywka);
		for (unsigned int i=0; i<dokad; i++)
		  {
		    if (plansz_p[i] & 0x5)  // pole jest wewnatrz stopu lub stalego stopu gr1
		      rozgr3_nowa[i]=1;     // wiec wstaw kropke ,,1'' w rozgr3_nowa
		    else if (plansz_p[i] & 0xa)
		      rozgr3_nowa[i]=2;     // ...lub kropke ,,2'', jesli to jest u gracza 2
		  }
	      }
	      ile_sklnr=UstawSkladoweNR(sklnr, goradol, straty_skl,
				 rozgr3_nowa, dod_inf, rozgrywka, plansz_p,
				 3-ktory_gracz, 4, marg3_min, marg3_max, gracz.waga_kropki);
	      long int jego_s2=OcenSkladoweM(rozgrywka, plansz_p,
	 3-ktory_gracz, 0,
	 sklnr, goradol, straty_skl,
         ile_sklnr,
	 obszar, DajMaske(obszar[indeks_ijz] & obszar[indeks_nij], obszar[indeks_ij]),
	 zagr_kr, zagr_ss,
	 znam_mostki, gracz.umiejetnosci, gracz.waga_kropki);
	      if (jego_s2<jego_s) jego_s=jego_s2;
	      if (kr>strac_kr_PU) strac_kr_PU=kr;
	      ile_fakt_zagr++;
	    }
	  if (kr || pow || pow2)
	    KopiujTablice(plansz_p, plansz_p_PU);
	  rozgrywka[indeks_nij]=0;
	}
    }
		       }
		     while (k!=num_zagr);
		     if (ile_fakt_zagr>=2)
			  straty_k+=strac_kr_PU;
			else
			  jego_s=MAXLONG;
			}
		 if (jego_s==MAXLONG)
			{
			// ocen jego skladowe bez podw. uderzen
			ile_sklnr=UstawSkladoweNR(sklnr, goradol, straty_skl,
						  rozgr3, dod_inf,rozgrywka, plansz_p,
						  3-ktory_gracz, 4, marg3_min, marg3_max,
						  gracz.waga_kropki);
			jego_s=OcenSkladoweM(rozgrywka, plansz_p,
					     3-ktory_gracz, 0,
					     sklnr, goradol, straty_skl,
					     ile_sklnr,
					     obszar, DajMaske(obszar[indeks_ijz], obszar[indeks_ij]),
					     zagr_kr, zagr_ss,
					     znam_mostki, gracz.umiejetnosci, gracz.waga_kropki);
			}
		 zyski_kn+=zagr_kr;  zyski_ssn+=zagr_ss;
		 }
		 // usun kropke
		 rozgrywka[indeks_ijz]=0;
		 if (odtworz_plansz_p2)
			KopiujTablice(plansz_p, odtworz_plansz_p ? plansz_p2 : t2);
		 KopiujTablice(rozgr3, t3);
		 // wszystkie parametry znane, ocen pozycje po odpowiedzi wroga
		 long int oc = gracz.wagi_n.sk*moje_s -
		   gracz.wagi_p.zd *(gracz.waga_kropki*straty_k+straty_ss) -
		   gracz.wagi_p.sk*jego_s +
		   gracz.wagi_n.zd*(gracz.waga_kropki*zyski_kn+zyski_ssn);
		 // teraz ciecia alfa-beta
		 if (oc<ocena) ocena=oc;
		 if (ocena<ocena_najl)
			{
			// przesun obecna odpowiedz przeciwnika w gore
			int nz=z/2;  krint tmp=zagrozenia[z];
			zagrozenia[z]=zagrozenia[nz]; zagrozenia[nz]=tmp;
			break;   // tutaj jest ciecie alfa-beta
			}
		 }
	  }
	  if (ocena==MAXLONG)  // to nalezaloby wyeliminowac dodajac jakies zagrozenia
		 {
		 // ocen nasz ruch na glebokosci 0
		 // ustaw rozgr3
		 {
		 rozgr3[indeks_ij]=ktory_gracz;
		 if (odtworz_plansz_p)
			{
			for (unsigned int i=0; i<dokad; i++)
			  {
           if (plansz_p[i] & 0x5)  // pole jest wewnatrz stopu lub stalego stopu gr1
             rozgr3[i]=1;          // wiec wstaw kropke ,,1'' w rozgr3
           else if (plansz_p[i] & 0xa)
             rozgr3[i]=2;          // ...lub kropke ,,2'', jesli to jest u gracza 2
			  }
			}
		 }
		 // ocen moje skladowe
		 long int moje_s, jego_s;
		 int straty_ss=0, straty_k=0;
		 {
		 int ile_sklnr=UstawSkladoweNR(sklnr, goradol, straty_skl,
					       rozgr3, dod_inf,rozgrywka, plansz_p,
					       ktory_gracz, 16, marg3_min, marg3_max,
					       gracz.waga_kropki);
		 int zagr_kr, zagr_ss;
		 moje_s=OcenSkladoweM(rozgrywka, plansz_p,
				      ktory_gracz, 0,
				      sklnr, goradol, straty_skl,
				      ile_sklnr,
				      obszar, DajMaske(obszar[indeks_ij], 0xffff),
				      straty_k, straty_ss,
				      znam_mostki, gracz.umiejetnosci, gracz.waga_kropki);
		 // ...i jego skladowe
		 ile_sklnr=UstawSkladoweNR(sklnr, goradol, straty_skl,
					   rozgr3, dod_inf, rozgrywka, plansz_p,
					   3-ktory_gracz, 4, marg3_min, marg3_max,
					   gracz.waga_kropki);
		 jego_s=OcenSkladoweM(rozgrywka, plansz_p,
				      3-ktory_gracz, 1,
				      sklnr, goradol, straty_skl,
				      ile_sklnr,
				      obszar, DajMaske(0xffff, obszar[indeks_ij]),
				      zagr_kr, zagr_ss,
				      znam_mostki, gracz.umiejetnosci, gracz.waga_kropki);
		 zyski_k+=zagr_kr;  zyski_ss+=zagr_ss;
		 }
		 // wszystkie parametry znane, ocen pozycje
		 ocena = gracz.wagi_n.sk*moje_s -
		   gracz.wagi_p.zd *(gracz.waga_kropki*straty_k+straty_ss) -
		   gracz.wagi_p.sk*jego_s +
		   gracz.wagi_n.zd*(gracz.waga_kropki*zyski_k+zyski_ss);
		 }
	  // zapamietaj ruch, jesli jest najlepszy
	  if (ocena>ocena_najl)
		 {
		 ocena_najl=ocena;
		 x=i; y=j;
		 }
	  // usun nasza kropke
	  rozgrywka[indeks_ij]=0;
	  KopiujTablice(rozgr3, t3);   // to nalezy odtwarzac zawsze
	  if (odtworz_plansz_p)
		 KopiujTablice(plansz_p, t2);
	  }
	skladowe.ZwolnijSkladowa(podw_uderz);
	plansze.ZwolnijPlansze(plansz_p_PU);
   }
   Zwolnij_pamiec:;
	plansze.ZwolnijPlansze(plansz_p2);
	plansze.ZwolnijPlansze(rozgr3_nowa);
	skladowe.ZwolnijSkladowa(obszar);
	skladowe.ZwolnijSkladowa(straty_skl);
	skladowe.ZwolnijSkladowa(sklnr);
   skladowe.ZwolnijSkladowa(goradol);
   skladowe.ZwolnijSkladowa(kolejne_ruchy);
   }
   // koniec
   Wyjdz_stad:
   KopiujTablice(rozgrywka, t1);
   KopiujTablice(plansz_p , t2);
   plansze.ZwolnijPlansze(t1);
   plansze.ZwolnijPlansze(t2);
   plansze.ZwolnijPlansze(t3);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(dod_inf);
   skladowe.ZwolnijSkladowa(zagrozenia);
   skladowe.ZwolnijSkladowa(skl_tab);
	return;
	}
 else if (ile_wolnego)
	{
   GraKoncowa(rozgrywka, plansz_p, ktory_gracz, x, y, st_x, st_y);
   if (x!=0) return;
	}
 x=-1; y=-1;
}

#define ZAKAZ_PG  1
#define ZAKAZ_PD  2
#define ZAKAZ_LD  4
#define ZAKAZ_LG  8


struct TMostki12
  {
  private:
  unsigned short int mwlky;
  public:
    int dx[12], dy[12], dind[12], puste1[12], puste2[12], puste3[12];
  int nie_nasza1a[8], nie_nasza2a[8], nie_nasza1b[8], nie_nasza2b[8];
  TMostki12()
    {
    dx[0]=-1; dx[1]=1; dx[2]=2; dx[3]=2; dx[4]=1; dx[5]=-1; dx[6]=-2; dx[7]=-2;
    dy[0]=-2; dy[1]=-2; dy[2]=-1; dy[3]=1; dy[4]=2; dy[5]=2; dy[6]=1; dy[7]=-1;
    dx[8]=0;  dx[9]=2;  dx[10]=0;  dx[11]=-2;
    dy[8]=-2; dy[9]=0;  dy[10]=2;  dy[11]=0;
    mwlky=0;
    };
  void Inicjuj();
  }
  most12;

void TMostki12::Inicjuj()
{
 if (mwlky!=wlky)
   {
   mwlky=wlky;
   for (int i=0; i<12; i++)
     dind[i] = dx[i]*(wlky+4) + dy[i];
   // mostek 0 -- lewy gorny gorny
   puste1[0]= -wlky-4 -1;   puste2[0]= -1;
   nie_nasza1a[0]=-wlky-4;  nie_nasza2a[0]=-2*wlky-8-1;
   nie_nasza1b[0]=-2;       nie_nasza2b[0]=  wlky+4 -1;
   // mostek 1 -- prawy gorny gorny
   puste1[1]= wlky+4 -1;    puste2[1]= -1;
   nie_nasza1a[1]= wlky+4;  nie_nasza2a[1]= 2*wlky+8-1;
   nie_nasza1b[1]=-2;       nie_nasza2b[1]= -wlky-4 -1;
   // mostek 2 -- prawy prawy gorny
   puste1[2]= wlky+4 -1;    puste2[2]= wlky+4;
   nie_nasza1a[2]=2*wlky+8; nie_nasza2a[2]=  wlky+4+1;
   nie_nasza1b[2]=-1;       nie_nasza2b[2]=  wlky+4 -2;
   // mostek 3 -- prawy prawy dolny
   puste1[3]= wlky+4 +1;    puste2[3]= wlky+4;
   nie_nasza1a[3]=2*wlky+8; nie_nasza2a[3]=  wlky+4-1;
   nie_nasza1b[3]= 1;       nie_nasza2b[3]=  wlky+4 +2;
   // mostek 4 -- prawy dolny dolny
   puste1[4]= 1;            puste2[4]= wlky+4 +1;
   nie_nasza1a[4]= wlky+4;  nie_nasza2a[4]= 2*wlky+8+1;
   nie_nasza1b[4]= 2;       nie_nasza2b[4]= -wlky-4 +1;
   // mostek 5 -- lewy dolny dolny
   puste1[5]= 1;            puste2[5]= -wlky-4 +1;
   nie_nasza1a[5]= -wlky-4; nie_nasza2a[5]=-2*wlky-8+1;
   nie_nasza1b[5]= 2;       nie_nasza2b[5]=  wlky+4 +1;
   // mostek 6 -- lewy lewy dolny
   puste1[6]= -wlky-4;      puste2[6]= -wlky-4 +1;
   nie_nasza1a[6]=-2*wlky-8;nie_nasza2a[6]= -wlky-4-1;
   nie_nasza1b[6]= 1;       nie_nasza2b[6]= -wlky-4 +2;
   // mostek 7 -- lewy lewy dolny
   puste1[7]= -wlky-4;      puste2[7]= -wlky-4 -1;
   nie_nasza1a[7]=-2*wlky-8;nie_nasza2a[7]= -wlky-4+1;
   nie_nasza1b[7]= -1;      nie_nasza2b[7]= -wlky-4 -2;
   // mostki 8-11 sa uzywane przez TRobaki::OcenRuch() (!)
   for (int i=0; i<8; i++)
     puste3[i]=dind[i];  // sztuczka: puste3 niewazne dla mostkow 0-7
   // mostek 8 -- gorny gorny
   puste1[8]=-wlky-5;    puste2[8]=-1;    puste1[8]=wlky+3;
   // mostek 9 -- prawy prawy
   puste1[9]=wlky+3;     puste2[9]=wlky+4;    puste1[9]=wlky+5;
   // mostek 10 -- dolny dolny
   puste1[10]=-wlky-3;    puste2[10]=1;    puste1[10]=wlky+5;
   // mostek 11 -- lewy lewy
   puste1[11]=-wlky-5;    puste2[11]=-wlky-4;    puste1[11]=-wlky-3;
   }
}

void ZnajdzMostki12(krint *mostki, unsigned char *rozgr2, unsigned char *rozgr3,
         TDwaUC marg_min, TDwaUC marg_max, int ktory_gracz)
// Znajduje mostki w podanym obszarze i zaznacza je w tablicy mostki
// w bitach 0-11 jak na rysunku. NIE ZMIENIA tablicy mostki poza tym obszarem!
//                0 8 1               +----->
//              7       2             |    os x
//              b   .   9             |
//              6       3             | os y
//                5 a 4               v
//   (w srodku nasza kropka, z ktorej ,,wyskakujemy'' mostkiem 0-9,a,b).
//
// we: mostki         -- _wyzerowana_ lub juz odpowiednio ustawiona tablica
//     rozgr2, rozgr3 -- jak zwykle
//     marg_min, _max -- obszar, w ktorym nalezy znalezc mostki,
//     ktory_gracz    -- czyich mostkow szukamy.
// Funkcja jest ,,lokalna'' w tym sensie, ze wartosc mostki[x][y]
// zalezy _tylko_ od pozycji w kwadracie [x-2,x+2] x [y-2,y+2] -- mozna
// ja wywolac dla obszaru, ktory sie zmienil z marginesem wielkosci 2.
// Uwaga: trzeba wywolac most12.Inicjuj(), jesli zmienila sie wielkosc planszy
{
 STOPER_START_ZM12;
 for (int i=marg_min.x; i<=marg_max.x; i++)
  {
  unsigned int ind = WezIndeksTab(i, marg_min.y);
  for (int j=marg_min.y; j<=marg_max.y; j++)
   {
   mostki[ind]=0;
   if (rozgr2[ind]==ktory_gracz)
     {  // jest (srodkowa) kropka, trzeba sprawdzic, czy sa mostki
     krint maska=1;
     for (int nrm=0; nrm<8; nrm++)
       {
       if (rozgr2[ind + most12.dind[nrm]] == ktory_gracz &&    // druga nasza kropka
           rozgr3[ind + most12.puste1[nrm]] == 0 &&         //  wolne pola miedzy
           rozgr3[ind + most12.puste2[nrm]] == 0 &&         //  naszymi kropkami
           (rozgr3[ind + most12.nie_nasza1a[nrm]] != ktory_gracz ||       // mostek
            rozgr3[ind + most12.nie_nasza2a[nrm]] != ktory_gracz)  &&     // nie
           (rozgr3[ind + most12.nie_nasza1b[nrm]] != ktory_gracz ||       // jest
            rozgr3[ind + most12.nie_nasza2b[nrm]] != ktory_gracz) )       // trywialny
         {  // jest nietrywialny mostek!
         mostki[ind] |= maska;
         }
       maska <<= 1;
       }
     // teraz sprawdz ososno, czy sa poziome i pionowe mostki
     // mostek 8 -- gorny gorny
     if (rozgr2[ind-2] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0x3)   &&         // nie ma mostku LGG ani PGG
         rozgr3[ind-1       ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4-1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind-1]==0) +
                        (i>2 && rozgr3[ind-wlky-4-1] ==0) +
                        (i<=wlkx && rozgr3[ind+wlky+4-1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x100;
       }
     // mostek 9 -- prawy prawy
     if (rozgr2[ind+2*wlky+8] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0xc)   &&        // nie ma mostku PPG ani PPD
         rozgr3[ind+wlky+4  ] != ktory_gracz &&    // mostek
         rozgr3[ind+wlky+4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind+wlky+4]==0) +
                        (j>2 && rozgr3[ind+wlky+4-1] ==0) +
                        (j<=wlky && rozgr3[ind+wlky+4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x200;
       }
     // mostek 10 -- dolny dolny
     if (rozgr2[ind+2] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0x30)  &&         // nie ma mostku LDD ani PDD
         rozgr3[ind+1       ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4+1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind+1]==0) +
                        (i>2 && rozgr3[ind-wlky-4+1] ==0) +
                        (i<=wlkx && rozgr3[ind+wlky+4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x400;
       }
     // mostek 11 -- lewy lewy
     if (rozgr2[ind-2*wlky-8] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0xc0)  &&        // nie ma mostku LLG ani LLD
         rozgr3[ind-wlky-4  ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind-wlky-4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind-wlky-4]==0) +
                        (j>2 && rozgr3[ind-wlky-4-1] ==0) +
                        (j<=wlky && rozgr3[ind-wlky-4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x800;
       }
     }
   ind++;
   }
  }
 STOPER_STOP_ZM12;
}

class TCiete {
public:
  short int pion_min[max_bok_planszy+2], pion_max[max_bok_planszy+2],
            poz_min[max_bok_planszy+2] , poz_max[max_bok_planszy+2];
private:
  int zmienione_pion_min, zmienione_pion_max,zmienione_poz_min, zmienione_poz_max;
  void UaktualnijCiecieMin(short int *ct, int ost_el);
  void UaktualnijCiecieMax(short int *ct, int ost_el);
public:
  void DodajKropke(int i, int j, int okrazana);
  void DodajKropke(int ind, int okrazana=1);
  void DodajOkrKropkeZOpozn(int ind);
  void DodajKropkeZOpozn(int ind, int okrazana);
  void Zeruj();
  void RozpocznijDodawanieZOpozn();
  void UaktualnijCiecia();
  void Skopiuj(const TCiete &arg);
  };

void TCiete::Skopiuj(const TCiete &arg)
{
  memcpy(&pion_min[2], &arg.pion_min[2], sizeof(pion_min[0])*wlkx);
  memcpy(&pion_max[2], &arg.pion_max[2], sizeof(pion_max[0])*wlkx);
  memcpy(&poz_min[2], &arg.poz_min[2], sizeof(poz_min[0])*wlky);
  memcpy(&poz_max[2], &arg.poz_max[2], sizeof(poz_max[0])*wlky);
}

void DodajKropkeDoCieciaMin(short int *ct, int i, int wart, int ost_el)
{
 if (ct[i]>wart)
   {
   ct[i]=wart;
   int nwart=wart+1;
   for (int x=i-1; x>=2; x--)
     if (ct[x]>nwart) ct[x]=nwart++;
     else break;
   nwart=wart+1;
   for (int x=i+1; x<ost_el; x++)
     if (ct[x]>nwart) ct[x]=nwart++;
     else break;
   }
}

void DodajKropkeDoCieciaMax(short int *ct, int i, int wart, int ost_el)
{
 if (ct[i]<wart)
   {
   ct[i]=wart;
   int nwart=wart-1;
   for (int x=i-1; x>=2; x--)
     if (ct[x]<nwart) ct[x]=nwart--;
     else break;
   nwart=wart-1;
   for (int x=i+1; x<ost_el; x++)
     if (ct[x]<nwart) ct[x]=nwart--;
     else break;
   }
}

void TCiete::DodajKropke(int i, int j, int okrazana)
// dodaje kropke (i,j) do tablicy ciec
{
 STOPER_START_CIET;
 if (okrazana)
   {
   if (i>2 && i<=wlkx && j>2 && j<=wlky)     // jest we wnetrzu planszy
    {
    if (j>=pion_max[i])
      DodajKropkeDoCieciaMax(pion_max, i,j+1, wlkx+2);  // (nie wlky+2)
    if (j<=pion_min[i])
      DodajKropkeDoCieciaMin(pion_min, i,j-1, wlkx+2);  // tu ma byc wlkx+2 !
    if (i>=poz_max[j])
      DodajKropkeDoCieciaMax(poz_max, j,i+1, wlky+2);
    if (i<=poz_min[j])
      DodajKropkeDoCieciaMin(poz_min, j,i-1, wlky+2);
    }
   }
 else {
   if (j>pion_max[i])
     DodajKropkeDoCieciaMax(pion_max, i,j, wlkx+2);
   if (j<pion_min[i])
     DodajKropkeDoCieciaMin(pion_min, i,j, wlkx+2);
   if (i>poz_max[j])
     DodajKropkeDoCieciaMax(poz_max, j,i, wlky+2);
   if (i<poz_min[j])
     DodajKropkeDoCieciaMin(poz_min, j,i, wlky+2);
   }
 STOPER_STOP_CIET;
}

void TCiete::DodajKropke(int ind, int okrazana)
{  DodajKropke(upl_x[ind], upl_y[ind], okrazana); }

inline void TCiete::RozpocznijDodawanieZOpozn()
{ zmienione_pion_min = zmienione_pion_max = zmienione_poz_min = zmienione_poz_max =0; }

void TCiete::DodajOkrKropkeZOpozn(int ind)
// potem trzeba wywolac TCiete::UaktualnijCiecia
{
  STOPER_START_CIET;
  if (upl_marg[ind]>2) {
    int i=upl_x[ind], j=upl_y[ind];
    if (j>=pion_max[i]) { pion_max[i]=j+1; zmienione_pion_max=1; }
    if (j<=pion_min[i]) { pion_min[i]=j-1; zmienione_pion_min=1; }
    if (i>=poz_max[j])  { poz_max[j]=i+1; zmienione_poz_max=1; }
    if (i<=poz_min[j])  { poz_min[j]=i-1; zmienione_poz_min=1; }
  }
  STOPER_STOP_CIET;
}

void TCiete::DodajKropkeZOpozn(int ind, int okrazana)
// potem trzeba wywolac TCiete::UaktualnijCiecia
{
  if (okrazana) DodajOkrKropkeZOpozn(ind);
  else {
    int i=upl_x[ind], j=upl_y[ind];
    if (j>pion_max[i]) { pion_max[i]=j; zmienione_pion_max=1; }
    if (j<pion_min[i]) { pion_min[i]=j; zmienione_pion_min=1; }
    if (i>poz_max[j])  { poz_max[j]=i; zmienione_poz_max=1; }
    if (i<poz_min[j])  { poz_min[j]=i; zmienione_poz_min=1; }
  }
}

void TCiete::Zeruj()
{ 
  short int maksxy=max_bok_planszy*2+8;
  for (int i=0; i<max_bok_planszy+2; i++)
    {
      pion_min[i] = maksxy;
      pion_max[i] = -maksxy;
      poz_min[i] = maksxy;
      poz_max[i] = -maksxy;
    }
}

void TCiete::UaktualnijCiecieMin(short int *ct, int ost_el)
// zmniejsza ct tak, aby bylo wykresem f. Lipchitza o stalej 1
// ost_el == wlkx+2 lub wlky+2
{
  // przejdz w prawo
  int nwart = ct[2]+1;
  for (int i=3; i<ost_el; i++) {
    if (nwart<ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart++;
  }
  // przejdz w lewo
  nwart = ct[ost_el-1]+1;
  for (int i=ost_el-2; i>=2; i--) {
    if (nwart<ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart++;
  }
}

void TCiete::UaktualnijCiecieMax(short int *ct, int ost_el)
// zwieksza ct tak, aby bylo wykresem f. Lipchitza o stalej 1
// ost_el == wlkx+2 lub wlky+2
{
  // przejdz w prawo
  int nwart = ct[2]-1;
  for (int i=3; i<ost_el; i++) {
    if (nwart>ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart--;
  }
  // przejdz w lewo
  nwart = ct[ost_el-1]-1;
  for (int i=ost_el-2; i>=2; i--) {
    if (nwart>ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart--;
  }
}

void TCiete::UaktualnijCiecia()
{
  STOPER_START_CIET;
  if (zmienione_pion_max) UaktualnijCiecieMax(pion_max, wlkx+2);
  if (zmienione_pion_min) UaktualnijCiecieMin(pion_min, wlkx+2);
  if (zmienione_poz_max) UaktualnijCiecieMax(poz_max, wlky+2);
  if (zmienione_poz_min) UaktualnijCiecieMin(poz_min, wlky+2);
  STOPER_STOP_CIET;
}

long int OcenSkladowe12(unsigned char *rozgr2, unsigned char *rozgr3,
			krint *goradol,
			krint *straty_skl,
			long int *oceny_skladowych,
			unsigned int ile_sklnr,
			unsigned char *zakazane, krint *mostki_arg,
			int ktory_gracz,
			const TCiete &ciete,
			krint *dad,  //dad==dod_pola, dodajemy do tego inne kropki
			int funkcja_sk, int waga_kropki)
// we: 
//     goradol -- indeks najnizej polozonej kropki 1,2,3,... skladowej (najnizej na ekranie)
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     mostki_arg -- mostki (z ZnajdzMostki12())
//     funkcja_sk -- ==2 (stara funkcja) lub ==3 (nowa funkcja oceniajaca) 
//                   kiedys (umiejetnosci & 8)
//     Funkcja obchodzi tylko pola zaznaczone w ciete, lub takie, dla ktorych
//      (dod_pola[...] ==60002). Tablica dod_pola nazywa sie (na liscie
//     argumentow) ,,dad'' i jest niszzczona!
{
 STOPER_START_OS12;
 krint *mostki  = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 krint *mostki_stos = skladowe.PrzydzielSkladowa();
 long int ocena = 0;
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++) {
   unsigned int gora = *goradol++;
   if (gora)   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       // jesli zmieniasz 60002 na cos innego, to zmien tez Antyweze()!
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j])
             if (rozgr3[indeks]==0)
              dad[indeks]=60002; // puste pole w obszarze? -- wstawiamy 60002
             else if (rozgr2[indeks]==przec)
              dad[indeks]=60000; // kropki przeciwnika ustawiamy w dad na 60000
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // przygotuj mostki usuwajac te, ktore wskakuja na pionowa linie
     // lub przez nia przechodza; dodaj kropki z pionowej linii do kolejki
     KopiujTablice(mostki, mostki_arg);
     q4.Wyczysc();
     {
     unsigned int indm2= gora-2*wlky-8;
     unsigned int ind  = gora;
     unsigned int indp1= gora  +   wlky + 4;
     unsigned int indp2= indp1 +   wlky + 4;
     for (int j=upl_y[gora]; j<wlky+2; j++)
       {
       mostki[indm2++] &= ~(0x20c);  // zabronione mostki typu PPx
       // dodaj kropke do kolejki (oczywiscie dla j==gora.y zawsze jest dad[ind]==0)
       if (dad[ind]==60000)
         { q4.stos[1][q4.kon[1]++]=ind;   dad[ind]=ind; }
       else if (dad[ind]==60002)
         { q4.stos[3][q4.kon[3]++]=ind;   dad[ind]=ind; }
       mostki[ind++  ] &= ~(0xde1);  // zabronione mostki typu LLx (0x8c0),
                                  // Lx(0x021) oraz D,G (0x500)
       mostki[indp1++] &= ~(0x8e1);  // zabronione mostki typu LLx i Lx
       mostki[indp2++] &= ~(0x8c0);  // zabronione mostki typu LLx
       }
     }
     // obejdz skladowa
     unsigned int skad, gdzie;
     long int dlug;
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = ind_pionowa_max - wlky-4;
     int na_stosie_m = 0;
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3])
         { // jesli jestes tutaj, to blad!
         printf("Blad: nie udalo sie obejsc skladowej.\n");
         printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
     #ifndef TEKSTOWY
         GrKeyRead();
     #endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
         exit(1);
         }
       int indeks_qteraz   = (teraz & 3);
       int indeks_qterazp2 = ((teraz+2) & 3);
       // FAZA 1: przejdz jeden poziom bez mostkow, zapamietujac ew. mostki
       //         na osobnym stosie mostki_stos
       do
         {
         // zdejmij ze stosu
         krint pn_ind = q4.stos[indeks_qteraz][q4.pocz[indeks_qteraz]++];
         krint gdzie_ind = dad[pn_ind];   // z jakiego pola wystartowalismy
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x  == gora.x-1
           gdzie = gdzie_ind;    // gdzie.x == gora.x
           dlug=teraz-1;
           goto Obeszlismy;
           }
         {
         // idz w gore
         krint ind=pn_ind-1;
         if (dad[ind]>=60000)
           {
           if (dad[ind]==60000)     // jest polaczenie bezposrednie?
             q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
           else
             q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
           dad[ind]=gdzie_ind;
           }
         }
         {
         // idz w dol
         krint ind=pn_ind+1;
         if (dad[ind]>=60000)
           {
           if (dad[ind]==60000)     // jest polaczenie bezposrednie?
             q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
           else
             q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
           dad[ind]=gdzie_ind;
           }
         }
         {
         // idz w lewo
         krint ind=pn_ind-wlky-4;
         if (dad[ind]>=60000)
           {
           if (dad[ind]==60000)     // jest polaczenie bezposrednie?
             q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
           else
             q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
           dad[ind]=gdzie_ind;
           }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         Idz_tylko_w_prawo:;
         {
         // idz w prawo
         krint ind=pn_ind+wlky+4;
         if (dad[ind]>=60000)
           {
           if (dad[ind]==60000)     // jest polaczenie bezposrednie?
             q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
           else
             q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
           dad[ind]=gdzie_ind;
           }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         // sprawdz, czy sa jakies mostki do analizy w FAZIE 2
         if (mostki[pn_ind])
           {
           // (tu mozna sprawdzic, czy np. sa 3 mostki pod rzad lub 2 zle pod rzad)
           // W tej chwili to ciezko (w dad jest pole startu, a nie ostatnio
           // odwiedzone), ale to mozna osiagnac szybciej w FAZIE 2 -- przechodzac
           // mostek poziomy mozna zerowac flage dopuszczajaca taki mostek w polu,
           // na ktore skaczemy -- to pozwoli uniknac ,,2 zlych pod rzad''.
           // Wykrycie 3 pod rzad wymagaloby juz chyba pamietania informacji
           // w dodatkowej tablicy, ale to tez chyba lepiej robic w FAZIE 2.
           mostki_stos[na_stosie_m++]=pn_ind;
           }
         }
       while (q4.pocz[indeks_qteraz] < q4.kon[indeks_qteraz]);
       // wyczysc aktualny stos i wez nastepny priorytet
       q4.pocz[indeks_qteraz] = q4.kon[indeks_qteraz] = max_powierzchnia_planszy;
       teraz++;
       // FAZA 2 -- przejdz ewentualne mostki
       while (na_stosie_m)
         {
         unsigned int indeks = mostki_stos[--na_stosie_m];
         krint gdzie_ind = dad[indeks];   // z jakiego pola wystartowalismy
         krint  maska = 1;
         for (int m=0; m<12; m++)
           {
           if (mostki[indeks] & maska)
             {
             unsigned int ind = indeks + most12.dind[m];
             if (dad[ind]>=60000)   // pole jeszcze nie odwiedzone
               {
               dad[ind]=gdzie_ind;
               q4.stos[teraz & 3][q4.kon[teraz & 3]++] = ind;
               }
             }
           maska<<=1;
           }
         }
       }
     }
     Obeszlismy:;
     // moze mamy zabronione miejsce (anty-waz)?
     if (skad == gdzie-wlky-4 -1)
       {
       if (zakazane[skad] & ZAKAZ_PD) dlug+=2;
       }
     else if (skad == gdzie-wlky-4 +1)
       {
       if (zakazane[skad] & ZAKAZ_PG) dlug+=2;
       }
     else
       {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       skad+= wlky+4;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug+=2;
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug+=2;
       }
     // ocen skladowa
     {
     long int straty=straty_skl[kolejnaskl];
     if ((funkcja_sk==3) && straty==waga_kropki)
       {
       static long int oceny_1[9] =  {-34,-23,-17,-13,-11,-9,-6,-4,-2};
       // to stare wartosci dla waga_kropki==5: {-169,-113,-85,-67,-54,-44,-30,-20,-10};
       // stand. wsp. to {-169,-113,-85,-67,-54,-44,-37,-30,-25} (dla waga_kropki==5)
       if (dlug<9)
         ocena += oceny_skladowych[kolejnaskl] = straty*oceny_1[dlug];
       else
         ocena += oceny_skladowych[kolejnaskl] = -2*straty;
       }
     else
       {
       dlug <<= 1;
       ocena += oceny_skladowych[kolejnaskl] =
                dlug - straty - 4 - (straty << 7) / (dlug+4);
       }
     }
     }
   else oceny_skladowych[kolejnaskl] = 0;  // bezpieczna skladowa
   }
 skladowe.ZwolnijSkladowa(mostki);
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(mostki_stos);
 STOPER_STOP_OS12;
 return ocena;
}

inline long int OcenSkladowaBM(long int straty, int dlug, int funkcja_sk)
{
  if (funkcja_sk==4) {
    const int mnozniki[13] = {64,58,46,40,34,  27,22,17,13,10,  8,6,5}; 
    int skm = (dlug<13) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
    return (dlug<<2) - straty - 4 - skm; 
  }
  else {
    const int mnozniki[13] = {80,62,52,44,37,  31,25,20,15,11,  8,6,5};
    int skm = (dlug<13) ? ((straty*mnozniki[dlug])) : ((straty<<7) / (2*dlug+1));  // bylo << 6 i moze wtedy lepiej gral... (?)
    return (dlug<<2) - straty - 4 - (skm >> 1);   // TUTAJ skm>>1 !!
  }
}

long int OcenSkladoweBM(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			long int *oceny_skladowych,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
// UWAGA: oceny_skladowych[0..ile_sklnr-1] powinny byc ustawione na MAXLONG
//  lub na wlasciwa ocene
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 long int ocena = 0;
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if (gora) {   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
    if (oceny_skladowych[kolejnaskl]==MAXLONG) 
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      {
	      dad[indeks] = dad_tab[kary[indeks]];
//             if (rozgr3[indeks]==0)
//              assert(dad[indeks]==60001+kary[indeks]); // puste pole w obszarze? -- wstawiamy 60001,2,3
//             else if (rozgr2[indeks]==przec)
//              assert(dad[indeks]==60000); // kropki przeciwnika ustawiamy w dad na 60000
//	     else assert(dad[indeks]==0);
	      }
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     //     for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
     for (int ind=ind_pionowa_max; ind>ind_pionowa_min; ind--)  // 83.18
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   int nrt = dad[ind]-60000;
	   stos[nrt]++; *stos[nrt]=ind; q4.kon[nrt]++;  
	   dad[ind]=ind; 
	 }
     // obejdz skladowa
     unsigned int skad, gdzie;
     long int dlug=0;
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = WezIndeksTab(upl_x[gora]-1, wlky+1);
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) goto Znaleziony_najmn;
	 }
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
         krint gdzie_ind = dad[pn_ind];   // z jakiego pola wystartowalismy
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x==gora.x-1
           gdzie = gdzie_ind;    // gdzie.x==gora.x
           // dlug jest juz ustawione
           goto Obeszlismy;
           }
         {
         // idz w gore
         krint ind=pn_ind-1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=gdzie_ind;
           }
         }
         {
         // idz w dol
         krint ind=pn_ind+1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=gdzie_ind;
           }
         }
         {
         // idz w lewo
         krint ind=pn_ind-wlky-4;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=gdzie_ind;
           }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
           }
         Idz_tylko_w_prawo:;
         {
         // idz w prawo
         krint ind=pn_ind+wlky+4;
	 if (dad[ind]>=60000)
	   {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	   dad[ind]=gdzie_ind;
	   }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind; 
	     }
           }
         }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       skad+=wlky+4;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug++;
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug++;
     }
     // ocen skladowa
     {
       //     const int mnozniki[18] = {64,52,46,40,35,  30,26,22,19,16,  14,12,10,8,7,  6,5,4};
       //     int skm = (dlug<18) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
     const int mnozniki[13] = {64,58,46,40,34,  27,22,17,13,10,  8,6,5}; 
     long int straty=straty_skl[kolejnaskl];
     int skm = (dlug<13) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
     oceny_skladowych[kolejnaskl] =
       (dlug<<2) - straty - 4 - skm;  //(straty << 6) / (dlug+2);
     }
     }
    ocena += oceny_skladowych[kolejnaskl];
   }
   else oceny_skladowych[kolejnaskl]=0;  // bezpieczna
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 STOPER_STOP_OS12;
 return ocena;
}

void OcenSkladoweBMsciezki(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			       krint *dlugosci, krint *sciezki,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 CzyscTablice(sciezki);
 int maska=0x8000;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if ((maska<<=1)==0x10000) maska=1;
   if (gora)   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      {
	      dad[indeks] = dad_tab[kary[indeks]];
//             if (rozgr3[indeks]==0)
//              assert(dad[indeks]==60001+kary[indeks]); // puste pole w obszarze? -- wstawiamy 60001,2,3
//             else if (rozgr2[indeks]==przec)
//              assert(dad[indeks]==60000); // kropki przeciwnika ustawiamy w dad na 60000
//	     else assert(dad[indeks]==0);
	      }
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     //for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
     for (int ind=ind_pionowa_max; ind>ind_pionowa_min; ind--)  // 83.18
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   int nrt = dad[ind]-60000;
	   stos[nrt]++; *stos[nrt]=ind; q4.kon[nrt]++;  
	   dad[ind]=ind; 
	 }
     // obejdz skladowa
     unsigned int skad;
     long int dlug=0;
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = WezIndeksTab(upl_x[gora]-1, wlky+1);
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) goto Znaleziony_najmn;
	 }
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x==gora.x-1
           // dlug jest juz ustawione
           goto Obeszlismy;
           }
         {
         // idz w gore
         krint ind=pn_ind-1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
           }
         }
         {
         // idz w dol
         krint ind=pn_ind+1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
           }
         }
         {
         // idz w lewo
         krint ind=pn_ind-wlky-4;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
           }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
           }
         Idz_tylko_w_prawo:;
         {
         // idz w prawo
         krint ind=pn_ind+wlky+4;
	 if (dad[ind]>=60000)
	   {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	   dad[ind]=pn_ind;
	   }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind; 
	     }
           }
         }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       int gdzie=skad;
       do {
	 sciezki[gdzie] |= maska;
	 gdzie = dad[gdzie];
       } while (gdzie != dad[gdzie]);
       sciezki[gdzie] |= maska;
       skad+=wlky+4;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug++;   // tego nie dodawaj do sciezki
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug++;
     }
     // zapamietaj dlugosc
     dlugosci[kolejnaskl] = dlug;
     }
   else dlugosci[kolejnaskl] = 0;  // bezpieczna skladowa
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 STOPER_STOP_OS12;
}


class TObieg {
  // katy sa ustawione w sposob naturalny (nie tak jak dla wsp. ekranowych),
  // nie jest to zreszta istotne (wplywa tylko na znak)
  short int katy[2*max_bok_planszy-1][2*max_bok_planszy-1];
  int biegunx, bieguny;
  struct TPoleOb {
    int x,y;   // tutaj short int to za malo (chyba ze dalej bedzie konwersja na int w mnozeniu)
    float tg;
  };
  void PosortujPola(TPoleOb*, int, int);
public:
  short int pelny_obrot, polowa_obrotu;
  TObieg();
  void UstawBiegun(int b);
  short int ZmianaKierunku(int ind0, int ind1);
} obieg;

TObieg::TObieg()
{
  for (int i=0; i<max_bok_planszy; i++)
    katy[max_bok_planszy-1+i][max_bok_planszy-1]=0;   // ustaw biegun i prawa polprosta
  TPoleOb *pola = new TPoleOb[(max_bok_planszy-1)*(max_bok_planszy-1)];
  int ilepol=0;
  for (int i=1; i<max_bok_planszy; i++)
    for (int j=1; j<max_bok_planszy; j++) {
      pola[ilepol].x = max_bok_planszy-1 +i;
      pola[ilepol].y = max_bok_planszy-1 +j;
      pola[ilepol].tg= float(i) / float(j);
      ilepol++;
    }
  // posortuj pola rosnaco ze wzgledu na .tg
  PosortujPola(pola, 0, ilepol-1);
  // ustawiaj kierunki
  int kier=1;  
  katy[pola[0].x][pola[0].y]=1;   // pierwsze pole ustaw recznie
  for (int i=1; i<ilepol; i++) {
    if (pola[i].x*pola[i-1].y != pola[i-1].x*pola[i].y)  // zmienil sie kierunek
      kier++;
    katy[pola[i].x][pola[i].y]=kier;
  }
  kier++;
  delete[] pola;
  // pozostale 3 cwiartki ustaw przez obroty
  for (int i=1; i<max_bok_planszy; i++)
    for (int j=0; j<max_bok_planszy; j++) {
      short int kat1 = katy[max_bok_planszy-1 +i][max_bok_planszy-1 +j];
      katy[max_bok_planszy-1 -j][max_bok_planszy-1 +i] = kat1 + kier;
      katy[max_bok_planszy-1 -i][max_bok_planszy-1 -j] = kat1 + 2*kier;
      katy[max_bok_planszy-1 +j][max_bok_planszy-1 -i] = kat1 + 3*kier;
    }
  polowa_obrotu = 2*kier;
  pelny_obrot   = 4*kier;
}

void TObieg::PosortujPola(TPoleOb* tab, int l, int r)
// sortuje tab[l],...,tab[p]  (rekurencyjne QuickSort ze stosem max. const*log(r-l))
{
  int i,j;
 Sortuj:;
  i=l, j=r;
  TPoleOb x = tab[(l+r)/2];
  do {
    while (tab[i].tg<x.tg) i++;
    while (x.tg<tab[j].tg) j--;
    if (i<=j) {
      TPoleOb tmp = tab[i];
      tab[i] = tab[j];
      tab[j] = tmp;
      i++;  j--;
    }
  } while (i<=j);
  if (j-l<r-i) {
    if (l<j) PosortujPola(tab, l,j);
    if (i<r) {  // posortuj (i,r)
      l=i; 
      goto Sortuj;
    }
  }
  else {
    if (i<r) PosortujPola(tab, i,r);
    if (l<j) {  // posortuj (l,j)
      r=j;
      goto Sortuj;
    }
  }
}  

void TObieg::UstawBiegun(int b)
{  biegunx=upl_x[b];  bieguny=upl_y[b]; }

short int TObieg::ZmianaKierunku(int ind0, int ind1)
// zmiana kierunku przy przejsciu z pola [ind0] na pole [ind1];
// biegun musi byc wczesniej ustawiony funkcja UstawBiegun()
{
  int wsp0x = upl_x[ind0] - biegunx;
  int wsp1x = upl_x[ind1] - biegunx;
  int wsp0y = upl_y[ind0] - bieguny;
  int wsp1y = upl_y[ind1] - bieguny;
  if (wsp0y+wsp1y!=-1 || wsp0x+wsp1x<=0)
    return katy[max_bok_planszy-1 + wsp1x][max_bok_planszy-1 + wsp1y] -
        katy[max_bok_planszy-1 + wsp0x][max_bok_planszy-1 + wsp0y];
  // jedna z kropek jest na prawej polprostej, a druga ponizej
  if (wsp0y<0)  // tutaj wsp1y=0 oraz wsp1x>0, wiec kierunek1 = 0
    return pelny_obrot - katy[max_bok_planszy-1 + wsp0x][max_bok_planszy-1 + wsp0y];
  // tutaj wsp0y=0 oraz wsp0x>0, wiec kierunek0 = 0
  return katy[max_bok_planszy-1 + wsp1x][max_bok_planszy-1 + wsp1y] - pelny_obrot;
}


long int OcenSkladoweBMkaty(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			       long int *oceny_skladowych,
			       krint *dlugosci, krint *sciezki,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
// UWAGA: oceny_skladowych[0..ile_sklnr-1] powinny byc ustawione na MAXLONG
//  lub na wlasciwa ocene
// Moze byc oceny_skladowych==NULL albo (dlugosci==sciezki==NULL)  (wersja uniwersalna)
// Wersja ,,katy'' uzywa nowej klasy TObieg do badania, czy obeszlismy lancuch kropek
// dookola (83.28).
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 krint *dlug_sc = skladowe.PrzydzielSkladowa();   // dlugosc sciezki
 skrint *katy   = skladowe.PrzydzielSkladowaI();
 unsigned char przec = 3-ktory_gracz;
 long int ocena = 0;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 if (sciezki) CzyscTablice(sciezki);
 int maska=0x8000;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if ((maska<<=1)==0x10000) maska=1;
   if (gora) {  // gora==0 oznacza skladowa bezpieczna (kolo bandy)
    if (oceny_skladowych==NULL || oceny_skladowych[kolejnaskl]==MAXLONG) 
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      dad[indeks] = dad_tab[kary[indeks]];
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     int dlug_pocz_kropki;
     for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   // moze lepiej dodac nastepna kropke?
	   if (dad[ind+1]>=60000 && dad[ind+1]+2<=dad[ind]) ind++;
	   dlug_pocz_kropki = dad[ind]-60000;
	   stos[0]++; *stos[0]=ind; q4.kon[0]++;  
	   dad[ind]=ind;
	   katy[ind]=0;
	   dlug_sc[ind]=0;
	   break;   // TYLKO JEDNA KROPKE dodajemy!
	 }
     // obejdz skladowa
     obieg.UstawBiegun(gora);
     unsigned int pole1, pole2;
     long int dlug=0, dlug_zap=50000;   // 50000 = max. dlug
     {
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) 
	     if (2*dlug<dlug_zap)    // czy jeszcze trzeba obchodzic?
	       goto Znaleziony_najmn;   // tak, moze znajdzie sie jakas krotsza sciezka
	     else goto Obeszlismy;   // nie
	 }
	 if (dlug_zap<50000) goto Obeszlismy;
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
	 skrint akt_kat = katy[pn_ind];
         {
         // idz w dol
         krint ind=pn_ind+1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
	   dlug_sc[ind]=dlug+nrt;
	   katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	 else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	   int roznica = akt_kat - katy[ind];
	   if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	     dlug_zap = dlug + dlug_sc[ind];
	     pole1 = ind;  pole2 = pn_ind;
	   }
         }
	 }
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
         {
         // idz w lewo
         krint ind=pn_ind-wlky-4;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
	   dlug_sc[ind]=dlug+nrt;
	   katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	 else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	   int roznica = akt_kat - katy[ind];
	   if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	     dlug_zap = dlug + dlug_sc[ind];
	     pole1 = ind;  pole2 = pn_ind;
	   }
         }
	 }
         {
         // idz w prawo
         krint ind=pn_ind+wlky+4;
	 if (dad[ind]>=60000)
	   {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
           dad[ind]=pn_ind;
	   dlug_sc[ind]=dlug+nrt;
	   katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	   }
	 else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	   int roznica = akt_kat - katy[ind];
	   if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	     dlug_zap = dlug + dlug_sc[ind];
	     pole1 = ind;  pole2 = pn_ind;
	   }
         }
	 }
         {
         // idz w gore
         krint ind=pn_ind-1;
         if (dad[ind]>=60000)
           {
	   int nrt = dad[ind]-60000;
	   stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;
           dad[ind]=pn_ind;
	   dlug_sc[ind]=dlug+nrt;
	   katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	 else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	   int roznica = akt_kat - katy[ind];
	   if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	     dlug_zap = dlug + dlug_sc[ind];
	     pole1 = ind;  pole2 = pn_ind;
	   }
	 }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
	 }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     // mozna by bylo sprawdzic, czy nie ma samoprzeciec... (pomijamy na razie)
     // (...)
     dlug = dlug_zap + dlug_pocz_kropki;
     if (sciezki) {
       // zaznacz sciezke
       do {
	 sciezki[pole1] |= maska;
	 pole1 = dad[pole1];
       } while (pole1 != dad[pole1]);
       sciezki[pole1] |= maska;
       do {
	 sciezki[pole2] |= maska;
	 pole2 = dad[pole2];
       } while (pole2 != dad[pole2]);
       // sciezki[pole2] |= maska;   // to juz niepotrzebne
       // zapamietaj dlugosc
       dlugosci[kolejnaskl] = dlug;
     }
     // ocen skladowa
     if (oceny_skladowych) {
       const int mnozniki[13] = {80,62,52,44,37,  31,25,20,15,11,  8,6,5};
       long int straty=straty_skl[kolejnaskl];
       int skm = (dlug<13) ? ((straty*mnozniki[dlug])) : ((straty<<7) / (2*dlug+1));   // bylo << 6
       oceny_skladowych[kolejnaskl] =
	 (dlug<<2) - straty - 4 - (skm >> 1);
     }
     }
    if (oceny_skladowych) ocena += oceny_skladowych[kolejnaskl];
   }
   else { 
     if (oceny_skladowych) oceny_skladowych[kolejnaskl]=0;  // bezpieczna
     if (dlugosci) dlugosci[kolejnaskl] = 0;  // bezpieczna skladowa
   }
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 skladowe.ZwolnijSkladowa(dlug_sc);
 skladowe.ZwolnijSkladowa(katy);
 STOPER_STOP_OS12;
 return ocena;
}



void ZnajdzSkladowe(krint *skl_tab, unsigned char *rozg, int ktory_gracz)
// znajduje skladowe dla obu graczy; w rozg powinno byc rozgr2, ew. rozgr3,
//  ale z rozgr3 jest mniej efektywnie
{
 STOPER_START_ZSKL;
 CzyscTablice(skl_tab);
 unsigned int num_skl_n=1;
 unsigned int num_skl_p=30001;
 unsigned int indeks_ij = up.lg;
 for (int i=0; i<wlkx; i++) {
  for (int j=0; j<wlky; j++)
    {
    unsigned char kr=rozg[indeks_ij];
    if (kr!=0)
      {
      if (skl_tab[indeks_ij]==0)
      if (kr==ktory_gracz)
        ZnajdzSkladowa(skl_tab, rozg, num_skl_n++, indeks_ij);
      else
        ZnajdzSkladowa(skl_tab, rozg, num_skl_p++, indeks_ij);
      }
    indeks_ij++;
    }
  indeks_ij+=4;
 }
 STOPER_STOP_ZSKL;
}

int DodajKropkeDoSkl(krint *wynik, krint *we, unsigned char *rozgr2,
     unsigned int indeks, int czyja, krint numskl)
// dodaje pojedyncza kropke [indeks] (czyja) do skladowych z we
//  i zapisuje w wynik
// jesli kropka tworzy oddzielna skladowa, to otrzyma ona numer numskl
// Zwraca liczbe skladowych, ktore sasiadowaly z kropka [indeks].
{
 krint jakies[6] = {0,0,0,0,0,0};   // 6 wystarczy!
 int iles=0;
 // zapamietaj wystepujace numery skladowych, zerowego w kolejnosci numeru
 //  nie zapamietuj wiecej niz raz
 unsigned int ind=indeks-wlky-4-1;    // lewo gora
 if (rozgr2[ind]==czyja)  { jakies[0]=we[ind];  iles=1; }
 ind++;   // lewo
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // lewo dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind=indeks-1;  // gora
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind+=2;   // dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind=indeks+wlky+4-1;    // prawo gora
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // prawo
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 ind++;   // prawo dol
 if (rozgr2[ind]==czyja && we[ind]!=jakies[0]) jakies[iles++]=we[ind];
 if (iles<=1)
   {  // dodaj kropke
   KopiujTablice(wynik, we);
   wynik[indeks] = (iles==0) ? numskl : jakies[0];
   return iles;
   }
 // sa przynajmniej 2 skladowe; usun jakies[1] z nastepnych pol
 for (int i=iles-1; i>=2; i--)
   if (jakies[i]==jakies[1])
     jakies[i] = jakies[--iles];   // usun (powtarzajacy sie) numer jakies[i]
 if (iles==2)
   { // sa dwie skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 2;
   }
 // sa przynajmniej 2 skladowe; usun jakies[2] z nastepnych pol
 for (int i=iles-1; i>=3; i--)
   if (jakies[i]==jakies[2])
     jakies[i] = jakies[--iles];   // usun (powtarzajacy sie) numer jakies[i]
 if (iles==2)
   { // sa dwie skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 2;
   }
 if (iles==3)
   { // sa trzy skladowe, sklej je do jakies[0]
   for (int i=up.lg; i<=up.pd; i++)
     wynik[i] = (we[i]==jakies[1] || we[i]==jakies[2]) ? jakies[0] : we[i];
   wynik[indeks]=jakies[0];
   return 3;
   }
 // sa cztery skladowe, sklej je do jakies[0]
 for (int i=up.lg; i<=up.pd; i++)
   wynik[i] = (we[i]==jakies[1] || we[i]==jakies[2] || we[i]==jakies[3]) ?
                jakies[0] : we[i];
 wynik[indeks]=jakies[0];
 return 4;
}

struct TGrozby {
  krint lista[8];    // w przyszlosci moze byc potrzeba wiecej
  int   ile, ile_sing, ile_zawarte;
  krint zdobycze[8]; // liczba zamykanych kropek
  krint zawarte[8];  // te pola sa zawarte w zamykanych przez grozby panstwach
  int   dind[8];     // wypelniane przez DodajGrozbySasiedzkie()
  unsigned long id[8];   // klucz Zobrista zamykanych kropek
  unsigned char czy_singul[8];   // czy grozba ,,singularna'', tj. z tylko jednym ruchem obronny
  unsigned char czy_bezs[8];     // czy grozba jest zawarta w innej (jesli tak, to ruch przec. tu bez sensu)
  void DodajGrozbySasiedzkie(unsigned char *rozgrywka, unsigned char *rozgr3,
			     unsigned char *plansz_p, krint *skl, unsigned int ind);
  void SprawdzOdpPrzec(unsigned char *rozgrywka, unsigned char *rozgr3,
		       unsigned char *plansz_p, unsigned int ind);
  void UstawSing();
  TGrozby() { ile=0; ile_sing=0; };
private:
  void SprKandNaGrozbe(unsigned char *rozgrywka, unsigned char *rozgr3,
		       unsigned char *plansz_p, krint *skl, unsigned int ind, int indsrodka, int kto);
  int PrzejdzWnetrzeZobr(unsigned char *rozgrywka, unsigned char *plansz_p,
			 unsigned char *plan, unsigned int ind, int kto, 
			 unsigned long &zobr, int zazn_na);
};
  
void TGrozby::DodajGrozbySasiedzkie(unsigned char *rozgrywka, unsigned char *rozgr3,
				    unsigned char *plansz_p, krint *skl, unsigned int ind)
// [ind] to swiezo postawiona kropka gracza, ktorego grozb szukamy
{
  STOPER_START_GROZ;
  ile=0;  ile_zawarte=0;
  int kto = rozgrywka[ind];
  dind[0] = -1;       dind[1] = 1;        dind[2]= -wlky-4;  dind[3] = wlky+4;
  dind[4] = -wlky-5;  dind[5] = -wlky-3;  dind[6]= wlky+3;   dind[7] = wlky+5;
  for (int i=0; i<8; i++) {
    int nind = ind + dind[i];
    if (rozgr3[nind]==0 && upl_marg[nind]>=2 &&
	CzyMozliwyStop(skl, rozgr3, upl_x[nind], upl_y[nind], kto))
      SprKandNaGrozbe(rozgrywka, rozgr3, plansz_p, skl, nind, ind, kto);
  }
  STOPER_STOP_GROZ;
}

void TGrozby::UstawSing()
{
  STOPER_START_GROZ;
  for (int i=0; i<ile; i++) czy_bezs[i]=0;
  // nie sa singularne grozby, dla ktorych istnieja gorsze grozby (gorsze, tzn. zamykajace
  // te same kropki + pewne dodatkowe)
  for (int i=0; i<ile_zawarte; i++)
    for (int j=0; j<ile; j++)
      if (zawarte[i]==lista[j])
	{ czy_singul[j]=0; czy_bezs[j]=1;  break; }
  // a teraz sprawdz ,,rowne'' grozby (sprawdzenie powyzej nie wystarczy - jedna grozba zawsze zostanie!)
  for (int i=0; i<ile-1; i++)
    if (czy_singul[i]) 
      // sprawdz, czy aktualna grozba wystepuje tez pozniej
      for (int j=i+1; j<ile; j++)
	if (id[j]==id[i]) 
	  czy_singul[i] = czy_singul[j] = 0;  // jesli tak, to (prawdopodobnie) nie jest singularna
  STOPER_STOP_GROZ;
}

int TGrozby::PrzejdzWnetrzeZobr(unsigned char *rozgrywka, unsigned char *plansz_p,
				unsigned char *plan, unsigned int ind, int kto, 
				unsigned long &zobr, int zazn_na)
// zwraca liczbe zdobytych kropek, jesli jest stop (dla gracza kto)
// kropki wewnetrzne zostaja ustawione na ,,zazn_na'',
//   brzegowe -- niezaznaczone
// W zobr zwraca kod Zobrista zamknietych kropek.
// Nie nalezy czyscic tablicy plan!
{
 STOPER_START_GROZ;
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=zazn_na;   // zaznacz jako wnetrze
 int na_stosie=1;
 int zdob = 0;
 zobr = 0;
 int przec = 3-kto;
 do{
   ind = stos[--na_stosie];
   if (rozgrywka[ind]==przec && (plansz_p[ind] & kto)==0)  // kropka przec nie wewnatrz naszego stopu
     {
       zdob++;
       zobr ^= zobrist[ind];
     }
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + dind[k];
     if (rozgrywka[nind]==kto && (plansz_p[nind] & 3)==0)
       { // kropka brzegowa -- ale nic nie robimy...
       }
     else if (plan[nind]==0)
       {  // pole wewnatrz ew. stopu
       if (upl_marg[nind]<=2)
         {  // jestesmy na brzegu planszy, czyli stopu jednak nie ma
         skladowe.ZwolnijSkladowa(stos);
	 STOPER_STOP_GROZ;
         return 0;
         }
       stos[na_stosie++]=nind;
       plan[nind]=zazn_na;  // zaznacz jako wewnetrzne
       }
     else if (plan[nind]!=zazn_na)  // bylismy tu wczesniej, czyli stopu nie bedzie!
       {
         skladowe.ZwolnijSkladowa(stos);
	 STOPER_STOP_GROZ;
         return 0;
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 STOPER_STOP_GROZ;
 return zdob;
}

void TGrozby::SprKandNaGrozbe(unsigned char *rozgrywka, unsigned char *rozgr3,
			      unsigned char *plansz_p, krint *skl, 
			      unsigned int ind, int indsrodka, int kto)
{
  STOPER_START_GROZ;
  unsigned char *plan = plansze.PrzydzielPlansze();
  CzyscTablice(plan);
  int zdob=0;
  unsigned long kod = 0;
  rozgrywka[ind] = rozgr3[ind] = kto;
  // przechodz wolne pola
  int zaznaczone[5] = {0,0,0,0,0};
  for (int s=0; s<4; s++) {
    int nind = ind + dind[s];
    int zd;
    unsigned long zobr;
    if (plan[nind]==0 && rozgr3[nind]!=kto && upl_marg[nind]>=2   // nieodwiedzone wolne pole
	&& (zd = PrzejdzWnetrzeZobr(rozgrywka, plansz_p,
				    plan,  nind, kto, zobr, s+1)))
      {
	zaznaczone[s+1]=1;
	zdob += zd;
	kod ^= zobr;
      }
  }
  if (zdob) {
    lista[ile]    = ind;
    zdobycze[ile] = zdob;
    id[ile]       = kod;
    czy_singul[ile]=1;  // tymczasowo...
    ile++;
    // dodaj zamkniete pola do zawartych
    for (int i=0; i<8; i++)
      if (zaznaczone[plan[indsrodka + dind[i]]]) {
	int nr=0;
	while (nr<ile_zawarte && zawarte[nr]!=indsrodka + dind[i]) nr++;
	zawarte[nr] = indsrodka + dind[i];
	ile_zawarte += (nr==ile_zawarte);
      }
  }
  rozgrywka[ind] = rozgr3[ind] = 0;     // odtworz
  plansze.ZwolnijPlansze(plan);
  STOPER_STOP_GROZ;
}

void TGrozby::SprawdzOdpPrzec(unsigned char *rozgrywka, unsigned char *rozgr3,
			      unsigned char *plansz_p, unsigned int ind)
// [ind] to swiezo postawiona kropka przeciwnika gracza, ktorego grozby sprawdzamy
// sprawdza, ktore grozby sa (byc moze) singularne
// Najpierw nalezy wywolac UstawSing()!
{
  STOPER_START_GROZ;
  unsigned char *r=NULL, *pp=NULL;
  int kto;
  for (int i=0; i<ile; i++)
    if (czy_singul[i] && lista[i]!=ind) {
      if (rozgr3[lista[i]] == 0)  // mozna zagrac?
	{
	  if (r==NULL) {
	    r  = plansze.PrzydzielPlansze();
	    pp = plansze.PrzydzielPlansze();
	    kto= 3-rozgrywka[ind];
	  }
	  KopiujTablice(r, rozgrywka);
	  KopiujTablice(pp,plansz_p);
	  int ile_zd,pow,pow2,pss;
	  ZrobPanstwo(r, NULL, NULL, NULL, pp, upl_x[lista[i]], upl_y[lista[i]],
		      kto, ile_zd,pow,pow2,pss);
	  if (ile_zd==0) czy_singul[i]=0;
	}
      else czy_singul[i]=0;   // miejsce na nasza grozbe zostalo zamkniete
    }
  if (r!=NULL) { plansze.ZwolnijPlansze(r);    plansze.ZwolnijPlansze(pp);  }
  STOPER_STOP_GROZ;
}


void Antyweze(unsigned char *zakazane, krint *dod_pola,
              unsigned char *rozgr3, int kto,
              TDwaUC marg0_min, TDwaUC marg0_max)
// kto       -- dla kogo antyweze,
// marg0_... -- wsp. prostokata zawierajacego wszystkie kropki
// wy: uaktualnia zakazane i ustawia dod_pola
{
 STOPER_START_AW;
 unsigned char przec=3-kto;
 for (int i=marg0_min.x; i<=marg0_max.x; i++)
   {
   unsigned int indeks = WezIndeksTab(i, marg0_min.y);
   for (int j=marg0_min.y; j<=marg0_max.y; j++)
     {
     if (rozgr3[indeks]==przec)
       {
       if (rozgr3[indeks-1]==kto)
         { // mozliwe szablony:
         //       0 . ?             ? . 0
         //  (a)  0 x x        (b)  x x 0
         //       0 0 .             . 0 0
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         if (rozgr3[indeks+1]==0)
           {
           unsigned int ind_l = indeks-wlky-4;
           unsigned int ind_p = indeks+wlky+4;
           if (rozgr3[ind_l]==0)
             { // szablon (a) ??
             if (rozgr3[ind_l-1]==0 && rozgr3[ind_l+1]==0 &&
                 rozgr3[ind_p]==przec && rozgr3[ind_p+1]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_LG;
               zakazane[ind_l   ] |= ZAKAZ_PD;
               dod_pola[ind_l+1]=60002;
               }
             }
           else  // szablon (b) ??
             if (rozgr3[ind_l]==przec && rozgr3[ind_l+1]==kto &&
                 rozgr3[ind_p]==0 && rozgr3[ind_p-1]==0 && rozgr3[ind_p+1]==0)
               {
               zakazane[indeks+1] |= ZAKAZ_PG;
               zakazane[ind_p   ] |= ZAKAZ_LD;
               dod_pola[ind_p+1]=60002;
               }
           }
         }
       else if (rozgr3[indeks-1]==przec)
         { // mozliwe szablony:
         //       ? x .             . x ?
         //  (c)  . x 0        (d)  0 x .
         //       0 0 0             0 0 0
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+wlky+4;
         if (rozgr3[indeks+1]==0 && rozgr3[ind_l+1]==0 && rozgr3[ind_p+1]==0)
           {
           if (rozgr3[ind_l]==kto)
             { // szablon (c) ??
             if (rozgr3[ind_p]==0 && rozgr3[ind_p-1]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_PG;
               zakazane[ind_p   ] |= ZAKAZ_LD;
               dod_pola[ind_p+1]=60002;
               }
             }
           else  // szablon (d) ??
             if (rozgr3[ind_l]==0 && rozgr3[ind_l-1]==kto && rozgr3[ind_p]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_LG;
               zakazane[ind_l   ] |= ZAKAZ_PD;
               dod_pola[ind_l+1]=60002;
               }
           }
         }
       else if (rozgr3[indeks+1]==przec)  // tutaj rozgr3[indeks-1]==0
         { // mozliwe szablony:
         //       0 0 0             0 0 0
         //  (e)  . x 0        (f)  0 x .
         //       ? x .             . x ?
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+wlky+4;
         if (rozgr3[indeks-1]==0 && rozgr3[ind_l-1]==0 && rozgr3[ind_p-1]==0)
           {
           if (rozgr3[ind_l]==kto)
             { // szablon (e) ??
             if (rozgr3[ind_p]==0 && rozgr3[ind_p+1]==kto)
               {
               zakazane[indeks-1] |= ZAKAZ_PD;
               zakazane[ind_p   ] |= ZAKAZ_LG;
               dod_pola[ind_p-1]=60002;
               }
             }
           else  // szablon (f) ??
             if (rozgr3[ind_l]==0 && rozgr3[ind_l+1]==kto && rozgr3[ind_p]==kto)
               {
               zakazane[indeks-1] |= ZAKAZ_LD;
               zakazane[ind_l   ] |= ZAKAZ_PG;
               dod_pola[ind_l-1]=60002;
               }
           }
         }
       else if (rozgr3[indeks+1]==kto)  // tutaj rozgr3[indeks-1]==0
         { // mozliwe szablony:
         //       . 0 0             0 0 .
         //  (g)  x x 0        (h)  0 x x
         //       ? . 0             0 . ?
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+wlky+4;
         if (rozgr3[ind_l]==przec)
           { // szablon (g) ??
           if (rozgr3[ind_l-1]==kto &&
               rozgr3[ind_p]==0 && rozgr3[ind_p-1]==0 && rozgr3[ind_p+1]==0)
             {
             zakazane[indeks-1] |= ZAKAZ_PD;
             zakazane[ind_p   ] |= ZAKAZ_LG;
             dod_pola[ind_p-1]=60002;
             }
           }
         else  // szablon (h) ??
           if (rozgr3[ind_l]==0 && rozgr3[ind_p-1]==kto &&
               rozgr3[ind_l-1]==0 && rozgr3[ind_l+1]==0)
             {
             zakazane[indeks-1] |= ZAKAZ_LD;
             zakazane[ind_l   ] |= ZAKAZ_PG;
             dod_pola[ind_l-1]=60002;
             }
         }
       }
     indeks++;
     }
   }
 STOPER_STOP_AW;
}

/****************************************************************************/
struct TBanda {
  unsigned char *b, *wbezp[2];
  unsigned char btab[max_bok_planszy], wbezptab[2][max_bok_planszy];
  int ind0, wdol, wbok;   // nazwy jak dla lewej bandy; ind0 zawsze jest naroznikiem, ustawiane na zewnatrz
  int dlug;               // ==wlkx dla poziomej, ==wlky dla pionowej bandy
  static int tab_bezp[2][11+5], tab_nast_aktb[2][11+5];   // wystarczy 11, +5 dla wyrownania
  static int tab_wynik[14];
  void Ustaw(const unsigned char *r3);
  void DodajKropke(const TBanda &pop, int od_gory, int od_boku, int czyja);
  void UstawWewnBezp();   // ustawia wbezp[][] na podstawie b[]
  void UstawWnetrzeBandy(unsigned char *bezpieczne, const unsigned char *r3);
  int  UstawJesliZmienione(const unsigned char *r3, const TBanda &pop);
  void Kopiuj(const TBanda &pop);
  void KopiujBezpieczne(unsigned char *nbezp, const unsigned char *sbezp);
};

int TBanda::tab_bezp[2][16] = {{3,3,0,0, 4,4,0,0, 0,0,0,  0,0,0,0,0}, {3,0,3,0, 0,0,0,0, 4,0,4,  0,0,0,0,0}};
// stara wersja, dajaca bledne wyniki:
// int TBanda::tab_nast_aktb[2][16] = {{2,1,0,0, 1,1,0,0, 0,2,0,  0,0,0,0,0}, {2,0,1,0, 0,0,2,0, 1,0,1,  0,0,0,0,0}};
// nowa wersja (83.27+)
int TBanda::tab_nast_aktb[2][16] = {{3,1,0,0, 2,2,0,0, 0,0,0,  0,0,0,0,0}, {3,0,1,0, 0,0,0,0, 2,0,2,  0,0,0,0,0}};
int TBanda::tab_wynik[14] = {0,0,0,1,2, 2,2,2,2,2, 2,2,2,2 };

void TBanda::Ustaw(const unsigned char *r3)
{
  b = btab;
  int ind = ind0;
  for (int i=0; i<dlug; i++) {
    b[i] = (r3[ind] << 2) | r3[ind+wbok];
    ind += wdol;
  }
  UstawWewnBezp();
}

int TBanda::UstawJesliZmienione(const unsigned char *r3, const TBanda &pop)
{
  b = btab;
  int ind = ind0, zmienione=0;
  for (int i=0; i<dlug; i++) {
    b[i] = (r3[ind] << 2) | r3[ind+wbok];
    if (b[i]!=pop.b[i]) zmienione=1;
    ind += wdol;
  }
  if (zmienione) UstawWewnBezp();
  else {
    wbezp[0] = pop.wbezp[0];
    wbezp[1] = pop.wbezp[1];
  }
  return zmienione;
}

void TBanda::DodajKropke(const TBanda &pop, int od_gory, int od_boku, int czyja)
{
  switch (od_boku) {
  case 0:
    b=btab;
    for (int i=0; i<dlug; i++) b[i]=pop.b[i];
    b[od_gory] &= ~0xc;
    b[od_gory] |= (czyja << 2);
    UstawWewnBezp();
    break;
  case 1:
    b=btab;
    for (int i=0; i<dlug; i++) b[i]=pop.b[i];
    b[od_gory] &= ~3;
    b[od_gory] |= czyja;
    UstawWewnBezp();
    break;
  default:
    b=pop.b;
    wbezp[0]=pop.wbezp[0];    wbezp[1]=pop.wbezp[1];
    break;
  }
}

void TBanda::UstawWewnBezp()
// ustawia wbezp[][] na podstawie b[]
{
  for (int g=0; g<2; g++) {
    wbezp[g] = wbezptab[g];
    int p=2-g;
    { // idz w dol
      if ((b[0] & 3)==g+1) wbezp[g][0]=4;  // bezpieczne;   & 3 == obok bandy
      int pierwszy =1, akt_bezp = ((b[0] & 3) != p);
      for (int i=1; i<dlug-1; i++) {
	if (b[i]==(g?6:9))
	  { wbezp[g][i] = akt_bezp ? (2+pierwszy):0;     pierwszy=0; }
	else
	  wbezp[g][i] = ((b[i] & 3)==p) ? 0 : (tab_bezp[g][b[i]] + akt_bezp);
	switch (tab_nast_aktb[g][b[i]]) {
	case 0: akt_bezp=0; break;
	case 1: akt_bezp=1; pierwszy=0; break;
	case 2: akt_bezp=1; pierwszy=1; break;
	case 3: break;  // bez zmian
	}
      }
    }
    { // idz w gore
      if ((b[dlug-1] & 3)==g+1) wbezp[g][dlug-1]=4;  // bezpieczne
      int pierwszy =1, akt_bezp = ((b[dlug-1] & 3) != p);
      for (int i=dlug-2; i>=1; i--) {
	if ((b[i] & 3)!=p)
	  if (b[i]==(g?6:9))
	    { wbezp[g][i] += akt_bezp ? (2+pierwszy):0;     pierwszy=0; }
	  else
	    wbezp[g][i] += akt_bezp;  
	switch (tab_nast_aktb[g][b[i]]) {
	case 0: akt_bezp=0; break;
	case 1: akt_bezp=1; pierwszy=0; break;
	case 2: akt_bezp=1; pierwszy=1; break;
	case 3: break;  // bez zmian
	}
      }
    }
  }
}

void TBanda::UstawWnetrzeBandy(unsigned char *bezpieczne, const unsigned char *r3)
{
  int ind = ind0 + 2*wdol;
  for (int i=2; i<dlug-2; i++) {
    bezpieczne[ind] = r3[ind] ? 2:0;
    bezpieczne[ind+wbok] = r3[ind+wbok] ? tab_wynik[wbezp[r3[ind+wbok]-1][i]] : 0;
    ind += wdol;
  }
}
  
void TBanda::Kopiuj(const TBanda &pop)
{
  b=pop.b;    wbezp[0]=pop.wbezp[0];    wbezp[1]=pop.wbezp[1];
}

void TBanda::KopiujBezpieczne(unsigned char *nbezp, const unsigned char *sbezp)
{
  int ind=ind0;
  for (int i=0; i<dlug; i++) {
    nbezp[ind] = sbezp[ind];       nbezp[ind+wbok] = sbezp[ind+wbok];
    ind+=wdol;
  }
}

class TBandy {
  TBanda lewa,prawa,gora,dol;
  unsigned char *tab_bezp;
  void UstawLGrog(unsigned char *bezp, const unsigned char *r3);
  void UstawPGrog(unsigned char *bezp, const unsigned char *r3);
  void UstawLDrog(unsigned char *bezp, const unsigned char *r3);
  void UstawPDrog(unsigned char *bezp, const unsigned char *r3);
public:
  unsigned char *bezpieczne;
  void Inicjuj();
  void Zwolnij();
  void Kopiuj(const TBandy &pop);
  void UaktualnijBezpieczne(const TBandy &pop, const unsigned char *r3, int indeks, int czy_stop);
  void UstawBezpieczne(const unsigned char *r3);
};

void TBandy::Inicjuj()
{
  bezpieczne = tab_bezp = plansze.PrzydzielPlansze();
  CzyscTablice(tab_bezp);
  lewa.ind0 = WezIndeksTab(2,2);        lewa.wdol = 1;       lewa.wbok = wlky+4;    lewa.dlug = wlky;
  prawa.ind0 = WezIndeksTab(wlkx+1,2);  prawa.wdol = 1;      prawa.wbok = -wlky-4;  prawa.dlug = wlky;
  gora.ind0 = WezIndeksTab(2,2);        gora.wdol = wlky+4;  gora.wbok = 1;         gora.dlug = wlkx;
  dol.ind0 = WezIndeksTab(2,wlky+1);    dol.wdol = wlky+4;   dol.wbok = -1;         dol.dlug = wlkx;
}

void TBandy::Zwolnij()
{
  plansze.ZwolnijPlansze(tab_bezp);
}

void TBandy::UstawLGrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(2,2);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog+wlky+4]=r3[rog+wlky+4] ? 2:0;
  bezp[rog+1]=r3[rog+1] ? 2:0;
  rog+=wlky+5;
  if (r3[rog]) {
    int b = lewa.wbezp[r3[rog]-1][1] >? gora.wbezp[r3[rog]-1][1];
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawPGrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(wlkx+1,2);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog-wlky-4]=r3[rog-wlky-4] ? 2:0;
  bezp[rog+1]=r3[rog+1] ? 2:0;
  rog-=wlky+3;
  if (r3[rog]) {
    int b = prawa.wbezp[r3[rog]-1][1] >? gora.wbezp[r3[rog]-1][wlkx-2];
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawLDrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(2,wlky+1);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog+wlky+4]=r3[rog+wlky+4] ? 2:0;
  bezp[rog-1]=r3[rog-1] ? 2:0;
  rog+=wlky+3;
  if (r3[rog]) {
    int b = dol.wbezp[r3[rog]-1][1] >? lewa.wbezp[r3[rog]-1][wlky-2];
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawPDrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(wlkx+1,wlky+1);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog-wlky-4]=r3[rog-wlky-4] ? 2:0;
  bezp[rog-1]=r3[rog-1] ? 2:0;
  rog-=wlky+5;
  if (r3[rog]) {
    int b = dol.wbezp[r3[rog]-1][wlkx-2] >? prawa.wbezp[r3[rog]-1][wlky-2];
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UaktualnijBezpieczne(const TBandy &pop, const unsigned char *r3, int indeks, int czy_stop)
{
  if (czy_stop) {
    int zmienione;
    zmienione  = lewa.UstawJesliZmienione(r3, pop.lewa);
    zmienione |= prawa.UstawJesliZmienione(r3, pop.prawa);
    zmienione |= gora.UstawJesliZmienione(r3, pop.gora);
    zmienione |= dol.UstawJesliZmienione(r3, pop.dol);
    if (zmienione) {
      bezpieczne = tab_bezp;
      lewa.UstawWnetrzeBandy(bezpieczne, r3);  prawa.UstawWnetrzeBandy(bezpieczne, r3);
      gora.UstawWnetrzeBandy(bezpieczne, r3);  dol.UstawWnetrzeBandy(bezpieczne, r3);
      UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
      UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
    }
    else bezpieczne = pop.bezpieczne;
  }
  else if (upl_marg[indeks]<=3) {
   bezpieczne = tab_bezp;
   if (upl_x[indeks]<=3) {
     lewa.DodajKropke(pop.lewa, upl_y[indeks]-2, upl_x[indeks]-2, r3[indeks]);
     prawa.Kopiuj(pop.prawa);
   }
   else if (upl_x[indeks]>=wlkx) {
     prawa.DodajKropke(pop.prawa, upl_y[indeks]-2, wlkx+1-upl_x[indeks], r3[indeks]);
     lewa.Kopiuj(pop.lewa);
   }
   else {
     prawa.Kopiuj(pop.prawa);
     lewa.Kopiuj(pop.lewa);
   }
   if (upl_y[indeks]<=3) {
     gora.DodajKropke(pop.gora, upl_x[indeks]-2, upl_y[indeks]-2, r3[indeks]);
     dol.Kopiuj(pop.dol);
   }
   else if (upl_y[indeks]>=wlky) {
     dol.DodajKropke(pop.dol, upl_x[indeks]-2, wlky+1-upl_y[indeks], r3[indeks]);
     gora.Kopiuj(pop.gora);
   }
   else {
     dol.Kopiuj(pop.dol);
     gora.Kopiuj(pop.gora);
   }
   // teraz ustaw bezpieczne - wnetrza band
   if (upl_x[indeks]<=3) {
     lewa.UstawWnetrzeBandy(bezpieczne, r3);
     prawa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else if (upl_x[indeks]>=wlkx) {
     prawa.UstawWnetrzeBandy(bezpieczne, r3);
     lewa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else {
     prawa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
     lewa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   if (upl_y[indeks]<=3) {
     gora.UstawWnetrzeBandy(bezpieczne, r3);
     dol.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else if (upl_y[indeks]>=wlky) {
     dol.UstawWnetrzeBandy(bezpieczne, r3);
     gora.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else {
     dol.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
     gora.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   // ustawianie naroznikow jest szybkie, nie warto juz chyba sprawdzac, ktore sie mogly zmienic
   UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
   UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
  }
  else // nic sie nie zmienilo
    Kopiuj(pop);
}

void TBandy::Kopiuj(const TBandy &pop)
{
  bezpieczne = pop.bezpieczne;
  lewa.Kopiuj(pop.lewa);
  prawa.Kopiuj(pop.prawa);
  gora.Kopiuj(pop.gora);
  dol.Kopiuj(pop.dol);
}

void TBandy::UstawBezpieczne(const unsigned char *r3)
{
  bezpieczne = tab_bezp;
  lewa.Ustaw(r3);  prawa.Ustaw(r3);  gora.Ustaw(r3);  dol.Ustaw(r3);
  lewa.UstawWnetrzeBandy(bezpieczne, r3);  prawa.UstawWnetrzeBandy(bezpieczne, r3);
  gora.UstawWnetrzeBandy(bezpieczne, r3);  dol.UstawWnetrzeBandy(bezpieczne, r3);
  UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
  UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
}



/****************************************************************************/
class TPoziom;

class TRobaki {
  friend class TPoziom;  // naprawde tylko TPoziom::OcenBMsciezki
  // wskazniki:
  krint *robaki, *nast_kropka_robaka;    // skladowe (musza miec wlkx4wlky4 el.)
  krint *polaczenia;                     // listy (moga miec nieco mniej niz wlkx4wlky4 el.)
  krint *straty, *dolne_kropki;          // tablice indeksowane
  unsigned char *na_pewno_bezp;          //    numerami robakow
  int ost_nr_robaka, ile_polaczen2;      // ile_polaczen2 = liczba polaczen x 2
  // tablice:
  krint *robaki_tab, *nast_kropka_robaka_tab;
  //  krint *lista_naszych_tab, *lista_naszych;
  //  int   ile_naszych;
  krint *polaczenia_tab;
  krint *straty_tab, *dolne_kropki_tab;
  unsigned char *na_pewno_bezp_tab;
  // zmienne dla UsunKropke():
  int ind_robaka, zap_wart_npbezp, zap_indeks, zap_dolna, sposob_odtw;
  // zmienne ustawiane (raz na zawsze) na zewnatrz klasy:
  int czyje;   // czyje sa te robaki
  int maska_sstopu;
  //  
  void DodajPolaczenia(unsigned int indeks);
  void SkopiujPotrzebne(krint *poprz);
  int ZakazanePomiedzy(unsigned char *zakazane, unsigned int k1, unsigned int k2);
public:
  void Przydziel();
  void Zwolnij();
  void UstawCzyje(int kto, int niska_ocena_duzych_brz);
  void Inicjuj(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3, 
	       unsigned char *plansz_p);
  void DodajKropke(TRobaki &poprz, unsigned char *rozgrywka, unsigned char *rozgr2,
		   unsigned char *rozgr3, unsigned char *plansz_p, unsigned int indeks,
		   int byl_stop, int byl_sstop);
  void UaktualnijGleb();
  void UsunKropke();
  void OdtworzKropke();
  int  ZnajdzRobakiMatki(unsigned char *rozgr3, unsigned char *zakazane, unsigned char *bezpieczne,
			 TDwaUC marg3_min, TDwaUC marg3_max,
			 krint *goradol, krint *stratyskl);
  int  ZnajdzRobakiMatki(unsigned char *rozgr3, unsigned char *zakazane, unsigned char *bezpieczne,
			 TDwaUC marg3_min, TDwaUC marg3_max,
			 krint *goradol, krint *stratyskl,
			 krint *polaczony_z, krint *dolne_m);
  void UstawZakazane(unsigned char *zakazane, const unsigned char *rozgr3, const krint *skl_tab) const;
  //  friend void TPoziom::OcenBMsciezki(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  //  long int WezPoprawkeNaSklPop(unsigned char *rozgr3, long int *oceny);
  //  void PorownajZeSklnr(krint *sklnr, krint *stratynr, krint *goradol, int ilesklnr);
  void UstawPolaczonyZ_sklad(krint *polaczony_z) const;
  void ZnajdzSkladowe(krint *skl_tab, int nrpoczskl) const;
  int OcenRuch(unsigned char *rozgr3, krint *polaczony_z, unsigned int indeks, 
	       int nasze, int &poziom_bezp) const;
  TRobaki& operator=(const TRobaki& arg);
};

/******************************************************************************************/

struct TAnaliza {
  unsigned char *rozgr2, *rozgr3, *plansz_p;
  krint         *skl_tab, *lista_ruchow;
  long int      *oceny_ht;            // oceny pobrane z htablicy (==MAXLONG: brak)
  krint         *propoz[2];           // propoz[...][ind]: najlepsze 2 kontynuacje po wykonaniu ruchu [ind]
  unsigned char *rodzaj_oc_ht;        // rodzaj oceny (1,0,2: oszacowanie dolne, dokladna, osz. gorne)
  int           byl_przeglad_ht;
  int           x,y;                  // wspolrzedne
  unsigned int  indeks;               //    ruchu
  unsigned int  hindeks;              // indeks dla tablicy mieszajacej, =indeks lub indeks|0x2000,
           // |0x4000 ozn. ruch przeciwnika
  int           ktory_teraz;          // kto na ruchu
  int           nr_ruchu, ost_ruch;   // ruchy na liscie ruchow
  int           pocz_ruch;            // nr_ruchu=pocz_ruch,...,ost_ruch-1
  long int      zyski, straty;        // zyski = waga*zyski_k+zyski_ss, podobnie straty
  int           ile_kr_zd_teraz;      // ile kropek zdobylismy w _tym_ ruchu
  long int      ocena;                // ocena ruchu          <- gdy brak oceny
  long int      alfa,beta,alfapocz;   // do ciec alfa-beta (alfapocz wydaje sie niepotrzebne...)
  int           byl_stop;             // =1 gdy po drodze byl stop
  int           jest_stop_sstop;      // =1 gdy teraz byl (staly) stop
  unsigned long htab_zobrist;
  unsigned long long htab_zobrist2;
  unsigned char *tab_r2, *tab_r3;     // tablice na rozgr2, rozgr3
  unsigned char *tab_pp;              // tablica na plansz_p
  TDwaUC        marg0_min, marg0_max;
  krint         *lista_ruchow_pelna, *lista_ruchow_lisc; // wskazniki do latwego
  int           ile_ruchow_pelna, ile_ruchow_lisc;         // przelaczania miedzy listami ruchow
  krint         maska_lisc, maska_upr, maska_pelna;           // maska do schemat_ruchow[]
  krint         najlepszyr;   // najlepsza kontynuacja
  TCiete        ciete[2];             // ciete obszary
  long long int historia_waga;        // te wartosc dodajemy do historii, gdy ruch daje ciecie beta
  int           ile_zagrozen;
  krint         *zagrozenia;
  TGrozby       grozby;
  int           sex_limit, sex_limit_podw;
  int           ost_gleb;
  struct TSasiedzi {
    krint parz[20], niep[20], lisc[8];
    int ile_p, ile_n, ile_lisc;
    static unsigned char* tab_sas;
    unsigned int antywaz;
    krint odblokowuja[10];
    } sasiedzi;
  TRobaki robaki[2];
  TBandy  bandy;     // do badania, ktore kropki bezpieczne
// statyczne pola
  static int polaboczne_dind[20];
  static int polaboczne_dx[20];
  static int polaboczne_dy[20];
  static long long int historia[(max_bok_planszy+4)*(max_bok_planszy+4)];
  static long long int historia_max;
  static unsigned short int historia_sort[(max_bok_planszy+4)*(max_bok_planszy+4)];
  static unsigned char *bezp_na_zawsze;      // kropki na zawsze bezpieczne
  // symetrie:
  static int sa_symetrie;
  static unsigned char* symetrie;
  // stoper:
  static TStoper czas;
  static int     czas_przekr;
  static TGraczO gracz;
  // wyswietlanie:
#ifndef TEKSTOWY
  int ost_gleb_max;
#endif
  // metody
  void InicjujCiecia(unsigned char*);
  void UstawBezpNaZawsze();
  void UstawLancuchyWplanszp();   // 83.30+
  void DodajBezsensowne(unsigned char *schemat_ruchow);
  }
  ang[MAX_GLEB_ANALIZY+2];

int TAnaliza::polaboczne_dind[20];
int TAnaliza::czas_przekr;        
TGraczO TAnaliza::gracz;          
TStoper TAnaliza::czas;           
int TAnaliza::polaboczne_dx[20]={-1,-1,-1,0,0,1,1,1,
                               -2,-2,-2,-1,-1,0,0,1,1,2,2,2};
int TAnaliza::polaboczne_dy[20]={-1,0,1,-1,1,-1,0,1,
                               -1,0,1,-2,2,-2,2,-2,2,-1,0,1};
unsigned char* TAnaliza::TSasiedzi::tab_sas;
long long int TAnaliza::historia_max;
long long int TAnaliza::historia[];
unsigned short int TAnaliza::historia_sort[];
unsigned char* TAnaliza::bezp_na_zawsze;
int TAnaliza::sa_symetrie;
unsigned char* TAnaliza::symetrie;

/*
class TTestSasiadow {
  krint *ruchy, *ruchy_p;
  int ile_r, ile_r_p;
public:
  void Inicjacja();
  void Sprawdz(unsigned char *schemat_ruchow, int akt, int ost);
  void Koniec();
} test_sasiadow;
void TTestSasiadow::Inicjacja()
{
  ruchy=skladowe.PrzydzielSkladowa();
  ruchy_p=skladowe.PrzydzielSkladowa();
  ile_r   = ang[1].ost_ruch - ang[1].pocz_ruch;
  ile_r_p = ang[2].ost_ruch - ang[2].pocz_ruch;
  for (int i=0; i<ile_r; i++)
    ruchy[i] = ang[1].lista_ruchow[ ang[1].pocz_ruch+i ];
  for (int i=0; i<ile_r_p; i++)
    ruchy_p[i] = ang[2].lista_ruchow[ ang[2].pocz_ruch+i ];
}
void TTestSasiadow::Sprawdz(unsigned char *schemat_ruchow, int akt, int ost)
  // wywolywane z wypelnionym ang[akt].lista_ruchow
{
  int blad=0;
  if (ang[1].ost_ruch - ang[1].pocz_ruch !=ile_r)
    { ekran.WyswietlNapis("Inna liczba ruchow"); blad=1; }
  // porownaj liste ruchow
  unsigned char *bufor = plansze.PrzydzielPlansze();
  CzyscTablice(bufor);
  for (int i=0; i<ile_r; i++) bufor[ruchy[i]]=1;
  for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++)
    if (bufor[ang[1].lista_ruchow[i]]==1)
      bufor[ang[1].lista_ruchow[i]]=0;
    else
      { ekran.WyswietlNapis("Inne ruchy"); blad=1; }
  // badaj sasiadow
  if (akt==1) {
    int ok=1;
    for (int i=0; i<wlkx4wlky4; i++)
      if (ang[0].sasiedzi.tab_sas[i]) { ok=0; break; }
    if (!ok)
      { ekran.WyswietlNapis("Niepuste tab_sas"); blad=1; }
  }
  // sprawdz, czy nie ma podwojnych lub bezsensownych ruchow
  for (int g=2; g<=akt; g++) {
    CzyscTablice(bufor);
    for (int i=ang[g].pocz_ruch; i<ang[g].ost_ruch; i++) {
      unsigned int ind = ang[g].lista_ruchow[i];
      if (ind>=wlkx4wlky4 || upl_marg[ind]<2)
	{ ekran.WyswietlNapis("Nieprawidlowy ruch"); blad=1; }
      else {
	if (++bufor[ind] >=2)
	  { ekran.WyswietlNapis("Powtorzony ruch"); blad=1; }
	// sprawdz, czy ruch sensowny
	if ((schemat_ruchow[ind] & 0x3f)==0) { // nie chce mi sie dokladniej sprawdzac...
	  // sprawdz odleglosc od innych kropek
	  int ok=0;
	  for (int ig=1; ig<g; ig++) {
	    int d = ind-ang[ig].indeks;
	    if (d<0) d=-d;
	    if (upl_marg[d]<=2) { ok=1; break; }
	  }
	  if (!ok)
	    { ekran.WyswietlNapis("Dziwny ruch"); blad=1; }
	}
      }
    }
  }
  if (blad)
    {
      GrKeyRead();
    }
  plansze.ZwolnijPlansze(bufor);
}
void TTestSasiadow::Koniec()
{skladowe.ZwolnijSkladowa(ruchy); 
 skladowe.ZwolnijSkladowa(ruchy_p); } 
*/

void ZaznaczSymetrie_P()
// zaznacza prawa polplaszczyzne w TAnaliza::symetrie
{
  for (int i=(wlkx+5)/2; i<wlkx+2; i++) {
    unsigned int ind = WezIndeksTab(i,2);
    for (int j=0; j<wlky; j++)
      TAnaliza::symetrie[ind+j]=1;
  }
}

void ZaznaczSymetrie_D()
// zaznacza dolna polplaszczyzne w TAnaliza::symetrie
{
  for (int j=(wlky+5)/2; j<wlky+2; j++) {
    unsigned int ind = WezIndeksTab(1,j);
    for (int i=0; i<wlkx; i++)
      TAnaliza::symetrie[ind+=wlky+4]=1;
  }
}

void UstawSymetrie(unsigned char *r)
// we: plansza z rozgrywka (NIE rozgr2, NIE rozgr3)
// ustawia odpowiednio pola statyczne TAnaliza::symetrie oraz TAnaliza::sa_symetrie
{
  TAnaliza::sa_symetrie=0;
  CzyscTablice(TAnaliza::symetrie);
  // sprawdz symetrie wzgl. pionowej osi
  for (int i=2; i<=wlkx; i++) {
    unsigned int ind1 = WezIndeksTab(i,2);
    unsigned int ind2 = WezIndeksTab(wlkx+3-i,2);
    if (ind1>=ind2) {
      // jest symetria wzgl. pionowej osi!
      TAnaliza::sa_symetrie|=1;
      ZaznaczSymetrie_P();
      break;
    }
    // sprawdzaj kolumne
    for (int j=0; j<wlky; j++) {
      if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
	goto Nie_ma_symetrii_pion;
      ind1++; ind2++;
    }
  }
 Nie_ma_symetrii_pion:;
  // sprawdz symetrie wzgl. poziomej osi
  for (int j=2; j<=wlky; j++) {
    unsigned int ind1 = WezIndeksTab(2,j);
    unsigned int ind2 = WezIndeksTab(2,wlky+3-j);
    if (ind1>=ind2) {
      // jest symetria wzgl. poziomej osi!
      TAnaliza::sa_symetrie|=2;
      ZaznaczSymetrie_D();
      break;
    }
    // sprawdzaj wiersz
    for (int i=0; i<wlkx; i++) {
      if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
	goto Nie_ma_symetrii_poz;
      ind1+=wlky+4; ind2+=wlky+4;
    }
  }
 Nie_ma_symetrii_poz:;
  // sprawdz obrot o pi
  for (int ind1=up.lg; ind1<=up.pd; ind1++) {
    unsigned int ind2 = wlkx4wlky4 -1 -ind1;
    if (ind1>=ind2) {
      // jest obrot o pi
      if (TAnaliza::sa_symetrie==0) {
	TAnaliza::sa_symetrie|=4;
	if ((wlkx & 1)==0) ZaznaczSymetrie_P();   // wybierz lepsza wersje z dwoch
	else ZaznaczSymetrie_D();                 // (mozna by zawsze lepiej: czasami mozna usunac kawalek srodkowej linii)
      }
      break;
    }
    if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
      goto Nie_ma_obrotu_o_pi;
  }
  Nie_ma_obrotu_o_pi:;
}

void CzyscZakazaneWProstokacie(unsigned char *zakazane, krint *dod_pola,
			       TDwaUC marg3_min, TDwaUC marg3_max)
// wybiorczo czysci zakazane na brzegu prostokata
// i calkowicie wewnatrz, wewnatrz czysci tez dod_pola
// prostokat powinien miec wymiary min. 2x2 (4 kropki)
{
 {  // lewa banda razem z naroznikami
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x,marg3_min.y);
 zakazane[indeks_ij++] &= ~(ZAKAZ_PD);   // wyzeruj zakaz PD, jesli jest
 for (int j=marg3_min.y+1; j<marg3_max.y; j++)
   zakazane[indeks_ij++] &= ~(ZAKAZ_PD | ZAKAZ_PG);
 zakazane[indeks_ij++] &= ~(ZAKAZ_PG);
 }
 {  // prawa banda razem z naroznikami
 unsigned int indeks_ij=WezIndeksTab(marg3_max.x,marg3_min.y);
 zakazane[indeks_ij++] &= ~(ZAKAZ_LD);
 for (int j=marg3_min.y+1; j<marg3_max.y; j++)
   zakazane[indeks_ij++] &= ~(ZAKAZ_LD | ZAKAZ_LG);
 zakazane[indeks_ij++] &= ~(ZAKAZ_LG);
 }
 {  // gorna banda bez naroznikow
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x+1,marg3_min.y);
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
   {
   zakazane[indeks_ij] &= ~(ZAKAZ_LD | ZAKAZ_PD);   indeks_ij+=wlky+4;
   }
 }
 {  // dolna banda bez naroznikow
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x+1,marg3_max.y);
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
   {
   zakazane[indeks_ij] &= ~(ZAKAZ_LG | ZAKAZ_PG);   indeks_ij+=wlky+4;
   }
 }
 // wnetrze
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
  {
  unsigned int indeks_ij=WezIndeksTab(i,marg3_min.y+1);
  for (int j=marg3_min.y+1; j<marg3_max.y; j++)
    {
    dod_pola[indeks_ij]=0;  zakazane[indeks_ij++]=0;
    }
  }
}


void UstawZakazane12_B(unsigned char *zakazane,
		       const unsigned char* rozg, const krint *skl_tab,
		       int indeks_ij, int ktory_gracz)
// sprawdza szablon typu B z lewa kropka w [indeks_ij]
{
  // mozliwe szablony typu B
  unsigned int ind_p= indeks_ij+wlky+4;
  unsigned int ind_g= indeks_ij-1;
  int przec=3-ktory_gracz;
  if (rozg[ind_p]==0)
    {
      if (rozg[ind_g]==0)
	{   // ,,czysty'' szablon typu B -- oba pola puste
	  zakazane[ind_g] |= ZAKAZ_PD;
	  zakazane[ind_p] |= ZAKAZ_LG;
	}
      else if (rozg[ind_g]==przec) {
	// szablony kolo bandy
	if (TAnaliza::gracz.umiejetnosci & 0x200)
	  if ((upl_x[indeks_ij]==3 && rozg[indeks_ij-2]==ktory_gracz &&
	       rozg[ind_p-2]!=0 && rozg[indeks_ij-wlky-5]==0) ||
	      (upl_y[indeks_ij]==4 && rozg[indeks_ij-wlky-5]==ktory_gracz && 
	       rozg[indeks_ij-wlky-4]!=0 && rozg[indeks_ij-2]==0)) {
	    // sprawdz, czy jest zagrozenie na polu [ind_p] zwiazane z kropka [ind_g]
	    int s=skl_tab[ind_g], ind_pp = ind_p+wlky+4;
	    if (skl_tab[ind_pp-1]!=s && skl_tab[ind_pp]!=s && skl_tab[ind_pp+1]!=s &&
		skl_tab[ind_p+1]!=s && skl_tab[indeks_ij+1]!=s) {
	      zakazane[ind_g] |= ZAKAZ_PD;
	      zakazane[ind_p] |= ZAKAZ_LG;
	    }
	    return;
	  }
	// zwykle szablony
	if (upl_marg[ind_p]>=3)
	{
	  // mozliwe szablony typu BL:
	  //    x .
	  //    , w ?
	  //      ?
	  unsigned int ind_pp= ind_p+wlky+4;
	  unsigned int ind_pd= ind_p+1;
	  // jesli jedno z pol jest wolne, a drugie nasze...
	  if ((rozg[ind_pp] | rozg[ind_pd]) == ktory_gracz)
	    {
	      // sprawdz, czy nie ma zagrozenia na polu [ind_p]
	      krint jakie_s[3];
	      jakie_s[0] = skl_tab[ind_g];
	      jakie_s[1] = 0;       // zero nie moze oznaczac
	      jakie_s[2] = 0;       // skladowej przeciwnika
	      // pole (ppg)
	      unsigned int ind_ppg = ind_pp-1;
	      if (rozg[ind_ppg]==przec)
		if (skl_tab[ind_ppg] == jakie_s[0])
		  return;
		else
		  jakie_s[1]=skl_tab[ind_ppg];  
	      // pole (ppd)
	      unsigned int ind_ppd = ind_pp+1;
	      if (rozg[ind_ppd]==przec)
		if (skl_tab[ind_ppd] == jakie_s[0] || skl_tab[ind_ppd] == jakie_s[1])
		  return;
		else
		  jakie_s[2]=skl_tab[ind_ppd];
	      // pole (d)
	      unsigned int ind_d = indeks_ij+1;
	      if (rozg[ind_d]!=przec ||
		  (skl_tab[ind_d] != jakie_s[0] &&
		   skl_tab[ind_d] != jakie_s[1] &&
		   skl_tab[ind_d] != jakie_s[2]))
		{ // szablon typu BL !
		  zakazane[ind_g] |= ZAKAZ_PD;
		  zakazane[ind_p] |= ZAKAZ_LG;
		}
	    }
	}
      }
    }
  else if (rozg[ind_p]==przec && rozg[ind_g]==0) {
    // szablony kolo bandy
    if (TAnaliza::gracz.umiejetnosci & 0x200)
      if ((upl_x[indeks_ij]==wlkx-1 && rozg[ind_p+1]==ktory_gracz &&
	   rozg[indeks_ij+1]!=0 && rozg[ind_p+wlky+4]==0) ||
	  (upl_y[indeks_ij]==wlky && rozg[ind_p+2*wlky+8]==ktory_gracz && 
	   rozg[ind_p+2*wlky+7]!=0 && rozg[ind_p+1]==0)) {
	// sprawdz, czy jest zagrozenie na polu [ind_g] zwiazane z kropka [ind_p]
	int s=skl_tab[ind_p], ind_l=indeks_ij-wlky-4;
	if (skl_tab[ind_p-2]!=s && skl_tab[indeks_ij-2]!=s && skl_tab[ind_l-2]!=s &&
	    skl_tab[ind_l-1]!=s && skl_tab[ind_l]!=s) {
	  zakazane[ind_g] |= ZAKAZ_PD;
	  zakazane[ind_p] |= ZAKAZ_LG;
	}
	return;
      }
    // zwykle szablony
    if (upl_marg[ind_g]>=3)
    {
      // mozliwe szablony typu BP:
      //      ?
      //    ? w .
      //      , x
      unsigned int ind_gg= indeks_ij-2;
      unsigned int ind_lg= indeks_ij-wlky-5;
      // jesli jedno z pol jest wolne, a drugie nasze...
      if ((rozg[ind_gg] | rozg[ind_lg]) == ktory_gracz)
	{
	  // sprawdz, czy nie ma zagrozenia na polu [ind_g]
	  krint jakie_s[3];
	  jakie_s[0] = skl_tab[ind_p];
	  jakie_s[1] = 0;       // zero nie moze oznaczac
	  jakie_s[2] = 0;       // skladowej przeciwnika
	  // pole (pgg)
	  unsigned int ind_pgg = ind_p-2;
	  if (rozg[ind_pgg]==przec)
	    if (skl_tab[ind_pgg] == jakie_s[0])
	      return;
	    else
	      jakie_s[1]=skl_tab[ind_pgg];  
	  // pole (lgg)
	  unsigned int ind_lgg = ind_lg-1;
	  if (rozg[ind_lgg]==przec)
	    if (skl_tab[ind_lgg] == jakie_s[0] || skl_tab[ind_lgg] == jakie_s[1])
	      return;
	    else
	      jakie_s[2]=skl_tab[ind_lgg];
	  // pole (l)
	  unsigned int ind_l = ind_lg+1;
	  if (rozg[ind_l]!=przec ||
	      (skl_tab[ind_l] != jakie_s[0] &&
	       skl_tab[ind_l] != jakie_s[1] &&
	       skl_tab[ind_l] != jakie_s[2]))
	    { // szablon typu BP !
	      zakazane[ind_g] |= ZAKAZ_PD;
	      zakazane[ind_p] |= ZAKAZ_LG;
	    }
	}
    }
  }
}


void UstawZakazane12_A(unsigned char *zakazane,
		       const unsigned char* rozg, const krint *skl_tab,
		       int indeks_ij, int ktory_gracz)
// sprawdza szablon typu A z lewa kropka w [indeks_ij]
{
  // mozliwe szablony typu A
  unsigned int ind_p= indeks_ij+wlky+4;
  unsigned int ind_d= indeks_ij+1;     
  int przec=3-ktory_gracz;
  if (rozg[ind_p]==0)
    {
      if (rozg[ind_d]==0)
	{   // ,,czysty'' szablon typu A -- oba pola puste
	  zakazane[ind_d] |= ZAKAZ_PG;
	  zakazane[ind_p] |= ZAKAZ_LD;
	}
      else if (rozg[ind_d]==przec) {
	// szablony kolo bandy
	if (TAnaliza::gracz.umiejetnosci & 0x200)
	  if ((upl_x[indeks_ij]==3 && rozg[indeks_ij+2]==ktory_gracz &&
	       rozg[ind_p+1]!=0 && rozg[indeks_ij-wlky-4]==0) ||
	      (upl_y[indeks_ij]==wlky-1 && rozg[indeks_ij-wlky-3]==ktory_gracz && 
	       rozg[indeks_ij-wlky-4]!=0 && rozg[indeks_ij+2]==0)) {
	    // sprawdz, czy jest zagrozenie na polu [ind_p] zwiazane z kropka [ind_d]
	    int s=skl_tab[ind_d], ind_pp = ind_p+wlky+4;
	    if (skl_tab[ind_pp-1]!=s && skl_tab[ind_pp]!=s && skl_tab[ind_pp+1]!=s &&
		skl_tab[ind_p-1]!=s && skl_tab[indeks_ij-1]!=s) {
	      zakazane[ind_d] |= ZAKAZ_PG;
	      zakazane[ind_p] |= ZAKAZ_LD;
	    }
	    return;
	  }
	// zwykle szablony
	if (upl_marg[ind_p]>=3)
	{
	  // mozliwe szablony typu AL:
	  //      ?
	  //    , w ?
	  //    x .
	  unsigned int ind_pp= ind_p+wlky+4;
	  unsigned int ind_pg= ind_p-1;
	  // jesli jedno z pol jest wolne, a drugie nasze...
	  if ((rozg[ind_pp] | rozg[ind_pg]) == ktory_gracz)
	    {
	      // sprawdz, czy nie ma zagrozenia na polu [ind_p]
	      krint jakie_s[3];
	      jakie_s[0] = skl_tab[ind_d];
	      jakie_s[1] = 0;       // zero nie moze oznaczac
	      jakie_s[2] = 0;       // skladowej przeciwnika
	      // pole (ppg)
	      unsigned int ind_ppg = ind_pp-1;
	      if (rozg[ind_ppg]==przec)
		if (skl_tab[ind_ppg] == jakie_s[0])
		  return;
		else
		  jakie_s[1]=skl_tab[ind_ppg];
	      // pole (ppd)
	      unsigned int ind_ppd = ind_pp+1;
	      if (rozg[ind_ppd]==przec)
		if (skl_tab[ind_ppd] == jakie_s[0] || skl_tab[ind_ppd] == jakie_s[1])
		  return;
		else
		  jakie_s[2]=skl_tab[ind_ppd];
	      // pole (g)
	      unsigned int ind_g = indeks_ij-1;
	      if (rozg[ind_g]!=przec ||
		  (skl_tab[ind_g] != jakie_s[0] &&
		   skl_tab[ind_g] != jakie_s[1] &&
		   skl_tab[ind_g] != jakie_s[2]))
		{ // szablon typu AL !
		  zakazane[ind_d] |= ZAKAZ_PG;
		  zakazane[ind_p] |= ZAKAZ_LD;
		}
	    }
	}
      }
    }
  else if (rozg[ind_p]==przec && rozg[ind_d]==0) {
    // szablony kolo bandy
    if (TAnaliza::gracz.umiejetnosci & 0x200)
      if ((upl_x[indeks_ij]==wlkx-1 && rozg[ind_p-1]==ktory_gracz &&
	   rozg[indeks_ij-1]!=0 && rozg[ind_p+wlky+4]==0) ||
	  (upl_y[indeks_ij]==3 && rozg[ind_p+wlky+4]==ktory_gracz && 
	   rozg[indeks_ij+wlky+5]!=0 && rozg[ind_p-1]==0)) {
	// sprawdz, czy jest zagrozenie na polu [ind_d] zwiazane z kropka [ind_p]
	int s=skl_tab[ind_p], ind_l = indeks_ij-wlky-4;
	if (skl_tab[ind_p+2]!=s && skl_tab[indeks_ij+2]!=s && skl_tab[ind_l]!=s &&
	    skl_tab[ind_l+1]!=s && skl_tab[ind_l+2]!=s) {
	  zakazane[ind_d] |= ZAKAZ_PG;
	  zakazane[ind_p] |= ZAKAZ_LD;
	}
	return;
      }
    // zwykle szablony
    if (upl_marg[ind_d]>=3)
    {
      // mozliwe szablony typu AP:
      //      , x
      //    ? w .
      //      ?
      unsigned int ind_dd= indeks_ij+2;
      unsigned int ind_ld= indeks_ij-wlky-3;
      // jesli jedno z pol jest wolne, a drugie nasze...
      if ((rozg[ind_dd] | rozg[ind_ld]) == ktory_gracz)
	{
	  // sprawdz, czy nie ma zagrozenia na polu [ind_d]
	  krint jakie_s[3];
	  jakie_s[0] = skl_tab[ind_p];
	  jakie_s[1] = 0;       // zero nie moze oznaczac
	  jakie_s[2] = 0;       // skladowej przeciwnika
	  // pole (pdd)
	  unsigned int ind_pdd = ind_p+2;
	  if (rozg[ind_pdd]==przec)
	    if (skl_tab[ind_pdd] == jakie_s[0])
	      return;
	    else
	      jakie_s[1]=skl_tab[ind_pdd]; 
	  // pole (ldd)
	  unsigned int ind_ldd = ind_ld+1;
	  if (rozg[ind_ldd]==przec)
	    if (skl_tab[ind_ldd] == jakie_s[0] || skl_tab[ind_ldd] == jakie_s[1])
	      return;
	    else
	      jakie_s[2]=skl_tab[ind_ldd];
	  // pole (l)
	  unsigned int ind_l = ind_ld-1;
	  if (rozg[ind_l]!=przec ||
	      (skl_tab[ind_l] != jakie_s[0] &&
	       skl_tab[ind_l] != jakie_s[1] &&
	       skl_tab[ind_l] != jakie_s[2]))
	    { // szablon typu AP !
	      zakazane[ind_d] |= ZAKAZ_PG;
	      zakazane[ind_p] |= ZAKAZ_LD;
	    }
	}
    }
  }
}


void UstawZakazane12(unsigned char *zakazane,
		     unsigned char* rozg, krint *skl_tab,
		     int ktory_gracz,
		     TDwaUC marg3_min, TDwaUC marg3_max)
// we: rozg -- plansza z rozgrywka (wewnatrz stopow kropki wlasciciela stopu)
//             nie niszczy tej tablicy!!!
//     skl_tab  -- tablica ze skladowymi, jak po wywolaniu ZnajdzSkladowe(),
//                 choc niekoniecznie tak. Istotne sa tylko skladowe
//                 przeciwnika, sposob ich numeracji jest bez znaczenia, z tym
//                 ze 0 nie moze oznaczac jednej ze skladowych (przeciwnika).
//     marg3_min, _max -- jaka czesc planszy nalezy obejsc
//                 NIE ZERUJE TABLICY zakazane NIGDZIE!
//                 Dlatego nalezy wyczyscic zakazane[] przed wolaniem tej
//                 funkcji, albo przy uzyciu CzyscZakazaneWProstokacie(), albo
//                 przy uzyciu CzyscTablice().
// Funkcja jest ,,lokalna'' w tym sensie, ze wartosc zakazane[x][y]
// zalezy _tylko_ od pozycji w kwadracie [x-2,x+2] x [y-2,y+2] -- mozna
// ja wywolac dla obszaru, ktory sie zmienil z marginesem wielkosci 2.
//
// szablony:
//    A: , w      B: w .
//       w .         , w
// w  oznacza puste pole
// .          nasza kropke,
// ,          nasza kropke, od ktorej zaczynamy rozpoznawanie szablonu
// Dodatkowo rozpatrujemy warianty szablonow A i B, w ktorym jedno z pustych
//  pol jest zastapione kropka przeciwnika (wariant L, jesli jest to lewe pole,
//  lub wariant P, jesli jest to prawe pole).
// Okreslenia ,,w gore'' i ,,w dol'' odnosza sie do wsp. ekranowych
//   (zwrot osi pionowej w dol).
{
 STOPER_START_UZAK;
 for (int i=marg3_min.x; i<=marg3_max.x; i++)
  {
  unsigned int indeks_ij=WezIndeksTab(i,marg3_min.y);
  for (int j=marg3_min.y; j<=marg3_max.y; j++)
    {
      if (rozg[indeks_ij]==ktory_gracz)
	{
	  if (rozg[indeks_ij+wlky+3]==ktory_gracz)
	    UstawZakazane12_B(zakazane, rozg, skl_tab, indeks_ij, ktory_gracz);
	  if (rozg[indeks_ij+wlky+5]==ktory_gracz)
	    UstawZakazane12_A(zakazane, rozg, skl_tab, indeks_ij, ktory_gracz);
	}
      indeks_ij++;
    }
  }
 STOPER_STOP_UZAK;
}

void TAnaliza::UstawBezpNaZawsze()
// Zzaznacza kropki na zawsze bezpieczne w TAnaliza::bezp_na_zawsze[].
// Wykorzystuje pole rozgr3.
{
  krint *stos = skladowe.PrzydzielSkladowa();
  CzyscTablice(TAnaliza::bezp_na_zawsze);
  int dind[4] = {-wlky-4,-1,1,wlky+4};
  for (int i=up.lg; i<=up.pd; i++)
    if (upl_marg[i]==2 && rozgr3[i] && TAnaliza::bezp_na_zawsze[i]==0) {
      // przejdz skladowa kropki [i]
      int kto=rozgr3[i], na_stosie=1;
      stos[0]=i;  TAnaliza::bezp_na_zawsze[i]=1;
      do {
	int p=stos[--na_stosie];
	for (int s=0; s<4; s++) {
	  int ps = p+dind[s];
	  if (rozgr3[ps]==kto && TAnaliza::bezp_na_zawsze[ps]==0) {
	    TAnaliza::bezp_na_zawsze[ps]=1;
	    stos[na_stosie++] = ps;
	  }
	}
      }
      while (na_stosie);
    }
  skladowe.ZwolnijSkladowa(stos);
}

void TAnaliza::UstawLancuchyWplanszp()
// korzysta z pol: rozgr3, bezp_na_zawsze
// modyfikuje    : bity lancuchow w plansz_p, rozgr2
{
  int dind[4] = {-wlky-4,-1,1,wlky+4};
  int maska[3] = {0, 0x10, 0x20};
  for (int i=up.lg; i<=up.pd; i++)
    if (upl_marg[i]<=3 && rozgr2[i])
      if (upl_marg[i]==2) {
	for (int k=0; k<4; k++)
	  if ((rozgr3[i+dind[k]]==0 || !bezp_na_zawsze[i+dind[k]]) &&
	      upl_marg[i+dind[k]]>=2)
	    goto Kropka_potrzebna1;
	// usun kropke z rozgr2
	plansz_p[i] |= maska[rozgr3[i]];
	rozgr2[i]=0;
      Kropka_potrzebna1:;
      }
      else {  // jestesmy obok bandy
	for (int k=0; k<4; k++)
	  if ((rozgr3[i+dind[k]]==0 || !bezp_na_zawsze[i+dind[k]]) &&    // 3 sasiadow nie-kolo-bandy jest bezpiecznych
	      upl_marg[i+dind[k]]>=3)                                    // a kolo bandy jest cokolwiek
	    goto Kropka_potrzebna2;
	// usun kropke z rozgr2
	plansz_p[i] |= maska[rozgr3[i]];
	rozgr2[i]=0;
      Kropka_potrzebna2:;
      }
}

void TAnaliza::DodajBezsensowne(unsigned char *schemat_ruchow)
// dodaje bezsensowne pola do tablicy schemat_ruchow (ustawia na 0xff)
// uzywa pol: rozgr3, bezp_na_zawsze
{
  unsigned char *skl     = plansze.PrzydzielPlansze();
  unsigned char *ciekawe = plansze.PrzydzielPlansze();
  krint *pola_skl = skladowe.PrzydzielSkladowa();
  krint *stos     = skladowe.PrzydzielSkladowa();
  CzyscTablice(ciekawe);
  CzyscTablice(skl);
  for (int i=2; i<wlkx+2; i++) {
    int ind = WezIndeksTab(i,2);
    for (int j=2; j<wlky+2; j++) {
      if (rozgr3[ind]==0 && skl[ind]==0) {
	// szukaj skladowej spojnosci pola [ind]
	stos[0]=ind;  skl[ind]=1;
	int ile_pol=0, na_stosie=1, skl_ok=1;
	do {
	  int indeks=stos[--na_stosie];
	  if (skl_ok) {
	    if (rozgr3[indeks-1] && !bezp_na_zawsze[indeks-1] ||
		rozgr3[indeks+1] && !bezp_na_zawsze[indeks+1] ||
		rozgr3[indeks-wlky-4] && !bezp_na_zawsze[indeks-wlky-4] ||
		rozgr3[indeks+wlky+4] && !bezp_na_zawsze[indeks+wlky+4])
	      skl_ok=0;
	    pola_skl[ile_pol++]=indeks;
	  }
	  // odwiedz i zaznacz sasiadow
	  if (rozgr3[indeks-1]==0 && upl_marg[indeks-1]>=2 && skl[indeks-1]==0)
	    skl[ stos[na_stosie++]=indeks-1 ] =1;
	  if (rozgr3[indeks+1]==0 && upl_marg[indeks+1]>=2 && skl[indeks+1]==0)
	    skl[ stos[na_stosie++]=indeks+1 ] =1;
	  if (rozgr3[indeks-wlky-4]==0 && upl_marg[indeks-wlky-4]>=2 && skl[indeks-wlky-4]==0)
	    skl[ stos[na_stosie++]=indeks-wlky-4 ] =1;
	  if (rozgr3[indeks+wlky+4]==0 && upl_marg[indeks+wlky+4]>=2 && skl[indeks+wlky+4]==0)
	    skl[ stos[na_stosie++]=indeks+wlky+4 ] =1;
	}
	while (na_stosie);
	if (skl_ok) {
	  // sprawdz, gdzie sa mozliwe brzuszki
	  for (int p=0; p<ile_pol; p++) {
	    int ip = pola_skl[p];
	    if (upl_marg[ip]>=3) {
	      int kto=(rozgr3[ip-1] | rozgr3[ip+1] | rozgr3[ip-wlky-4] | rozgr3[ip+wlky+4]);
	      if (kto<3)  // mozliwy brzuszek w [ip]
		ciekawe[ip-1] = ciekawe[ip+1] = ciekawe[ip-wlky-4] = ciekawe[ip+wlky+4] = 1;
	    }
	  }
	  // pola, ktore sa nieciekawe zaznacz jako bezsensowne
	  for (int p=0; p<ile_pol; p++)
	    if (!ciekawe[pola_skl[p]])
	      schemat_ruchow[pola_skl[p]]=0xff;
	}
      }
      ind++;
    }
  }
  skladowe.ZwolnijSkladowa(pola_skl);
  skladowe.ZwolnijSkladowa(stos);
  plansze.ZwolnijPlansze(skl);
  plansze.ZwolnijPlansze(ciekawe);
}

/*****************************************************************/
  
void TRobaki::Przydziel()
{
  nast_kropka_robaka = nast_kropka_robaka_tab = skladowe.PrzydzielSkladowa();
  robaki        = robaki_tab         = skladowe.PrzydzielSkladowa();
  //  lista_naszych = lista_naszych_tab  = skladowe.PrzydzielSkladowa();
  polaczenia    = polaczenia_tab     = skladowe.PrzydzielSkladowa();
  straty        = straty_tab         = skladowe.PrzydzielSkladowa();       // na to wystarczy
  dolne_kropki  = dolne_kropki_tab   = &straty_tab[ (wlkx4wlky4/2) & ~1];  // polowa tablicy
  na_pewno_bezp = na_pewno_bezp_tab  = plansze.PrzydzielPlansze();
}

void TRobaki::Zwolnij()
{
  skladowe.ZwolnijSkladowa(robaki_tab);
  skladowe.ZwolnijSkladowa(nast_kropka_robaka_tab);
  //  skladowe.ZwolnijSkladowa(lista_naszych_tab);
  skladowe.ZwolnijSkladowa(polaczenia_tab);
  skladowe.ZwolnijSkladowa(straty_tab);
  plansze.ZwolnijPlansze(na_pewno_bezp_tab);
}

void TRobaki::UstawCzyje(int kto, int niska_ocena_duzych_brz)
{
  czyje = kto;
  maska_sstopu = kto==1 ? 4:8;
  if (niska_ocena_duzych_brz) maska_sstopu|=0x40;   // pola punktowane
}

void TRobaki::Inicjuj(unsigned char *rozgrywka, unsigned char *rozgr2, 
		      unsigned char *rozgr3, unsigned char *plansz_p)
{
  krint *stos = skladowe.PrzydzielSkladowa();
  ost_nr_robaka = 0;
  nast_kropka_robaka = nast_kropka_robaka_tab;
  robaki = robaki_tab;    polaczenia = polaczenia_tab;   straty = straty_tab;
  dolne_kropki  = dolne_kropki_tab;    na_pewno_bezp = na_pewno_bezp_tab;
  CzyscTablice(robaki);    CzyscTablice(nast_kropka_robaka);
  straty[0]=0;  dolne_kropki[0]=0;  na_pewno_bezp[0]=0;   // to moze ulatwiac niektore rzeczy
  for (int indeks=up.lg; indeks<=up.pd; indeks++)
    if (rozgr2[indeks]==czyje && robaki[indeks]==0) {
      unsigned int na_stosie=1;
      stos[0]=indeks;    
      robaki[indeks] = ++ost_nr_robaka;
      int doly=upl_y[indeks],  dol=indeks;
      int wart=0, bezp=0;
      int poprz_ind;
      do {
	unsigned int ind = stos[--na_stosie];
	nast_kropka_robaka[ind] = poprz_ind;
	poprz_ind=ind;
	bezp |= (upl_marg[ind]==2);
	if (upl_y[ind]>doly) { doly=upl_y[ind];  dol=ind; }
	// dodaj straty
	if (rozgrywka[ind]==czyje)
	  wart+=TAnaliza::gracz.waga_kropki;    // kropka
	else if ((plansz_p[ind] & maska_sstopu) == maska_sstopu)
	  wart++;     // staly stop
	// idz w dol
	unsigned int nowy_ind = ind+1;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	// idz w gore
	nowy_ind = ind-1;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	// idz w lewo
	nowy_ind = ind-wlky-4;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	// idz w prawo
	nowy_ind = ind+wlky+4;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
      }
      while (na_stosie);
      nast_kropka_robaka[indeks] = poprz_ind;
      straty[ost_nr_robaka] = wart;
      na_pewno_bezp[ost_nr_robaka] = bezp;
      dolne_kropki[ost_nr_robaka] = dol;
    }
  skladowe.ZwolnijSkladowa(stos);
  // ustaw polaczenia
  ile_polaczen2=0;
  for (int indeks=up.lg; indeks<=up.pd; indeks++)
    if (rozgr2[indeks]==czyje) {
      if (upl_marg[indeks]==3 && !na_pewno_bezp[robaki[indeks]]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = 0;          // czyli potencjalne polaczenie z banda
      }
      if (robaki[indeks+wlky+3] && robaki[indeks+wlky+3]!=robaki[indeks]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = indeks+wlky+3;
      }
      if (robaki[indeks+wlky+5] && robaki[indeks+wlky+5]!=robaki[indeks]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = indeks+wlky+5;
      }
    }
  /*
  // sprawdz, czy wszystko ok
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
      do {
	int pom = nast_kropka_robaka[p];
	if (pom==0 || robaki[pom]!=i || upl_y[pom]>upl_y[indpocz])
	  printf("blad_u");
	p=pom;
      } while (p!=indpocz);
    }
  */
}

void TRobaki::DodajPolaczenia(unsigned int indeks)
{
  if (upl_marg[indeks]==3 && !na_pewno_bezp[robaki[indeks]]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = 0;          // czyli potencjalne polaczenie z banda
  }
  if (robaki[indeks+wlky+3] && robaki[indeks+wlky+3]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks+wlky+3;
  }
  if (robaki[indeks+wlky+5] && robaki[indeks+wlky+5]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks+wlky+5;
  }
  if (robaki[indeks-wlky-3] && robaki[indeks-wlky-3]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks-wlky-3;
  }
  if (robaki[indeks-wlky-5] && robaki[indeks-wlky-5]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks-wlky-5;
  }
}

void TRobaki::SkopiujPotrzebne(krint *poprz)
{
  int ile_bylo2 = ile_polaczen2;
  ile_polaczen2=0;
  for (int i=0; i<ile_bylo2; i+=2) {
    krint k1 = *poprz++;
    krint k2 = *poprz++;
    if (robaki[k1])
      if (k2) {  // polaczenie nie z banda
	if (robaki[k2] && robaki[k1]!=robaki[k2]) {
	  polaczenia[ile_polaczen2++] = k1;
	  polaczenia[ile_polaczen2++] = k2;
	}
      }
      else if (!na_pewno_bezp[robaki[k1]]) {
	// polaczenie z banda!
	polaczenia[ile_polaczen2++] = k1;
	polaczenia[ile_polaczen2++] = 0;  // =k2;
      }
  }
}

void TRobaki::DodajKropke(TRobaki &poprz, unsigned char *rozgrywka, unsigned char *rozgr2,
			  unsigned char *rozgr3, unsigned char *plansz_p, unsigned int indeks,
			  int byl_stop, int byl_sstop)
{
  STOPER_START_ROBD;
  zap_indeks = indeks;
  ost_nr_robaka = poprz.ost_nr_robaka;
  ile_polaczen2 = poprz.ile_polaczen2;
  //  ile_naszych   = poprz.ile_naszych;
  if (rozgrywka[indeks]==czyje) {
    //lista_naszych = poprz.lista_naszych;
    //lista_naszych[ile_naszych++] = indeks;
    if (!byl_sstop) {
      int nr_robaka = ost_nr_robaka+1;
      poprz.straty[nr_robaka]=0;
      // zobacz, ilu mamy sasiadow i zapamietaj indeks najwiekszego w ind_robaka
      int ile_robakow_sasiaduje=0;
      int dind[4] = {-1,1,-wlky-4,wlky+4};
      for (int b=0; b<4; b++) {
	unsigned int nind = indeks+dind[b];
	if (poprz.robaki[nind])
	  if (ile_robakow_sasiaduje==0) {
	    ile_robakow_sasiaduje=1;
	    nr_robaka = poprz.robaki[nind];
	    ind_robaka= nind;
	  }
	else
	  if (poprz.straty[nr_robaka] < poprz.straty[poprz.robaki[nind]]) {
	    ile_robakow_sasiaduje=2;
	    nr_robaka = poprz.robaki[nind];
	    ind_robaka= nind;
	  }
	  else if (nr_robaka!=poprz.robaki[nind])
	    ile_robakow_sasiaduje=2;
      }
      // a teraz dodaj kropke
      sposob_odtw = ile_robakow_sasiaduje;
      switch (ile_robakow_sasiaduje) {
      case 0:    // postawiona kropka jest izolowana - tworzy nowego robaka
	nast_kropka_robaka = poprz.nast_kropka_robaka;
	robaki=poprz.robaki;                straty=poprz.straty;
	dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
	// dodaj kropke
	robaki[indeks]=nr_robaka;
	na_pewno_bezp[nr_robaka] = (upl_marg[indeks]==2);
	straty[nr_robaka] = TAnaliza::gracz.waga_kropki;
	nast_kropka_robaka[indeks] = indeks;
	dolne_kropki[nr_robaka]=indeks;
	ost_nr_robaka++;
	// znajdz nowe polaczenia
	polaczenia=poprz.polaczenia;
	DodajPolaczenia(indeks);
	break;
      case 1:    // dopisujemy kropke do istniejacego robaka
	nast_kropka_robaka = poprz.nast_kropka_robaka;
	robaki=poprz.robaki;                straty=poprz.straty;
	dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
	// dodaj kropke
	robaki[indeks]=nr_robaka;
	zap_wart_npbezp = na_pewno_bezp[nr_robaka];
	na_pewno_bezp[nr_robaka] |= (upl_marg[indeks]==2);
	straty[nr_robaka] += TAnaliza::gracz.waga_kropki;
	nast_kropka_robaka[indeks] = nast_kropka_robaka[ind_robaka];
	nast_kropka_robaka[ind_robaka] = indeks;
	zap_dolna = dolne_kropki[nr_robaka];
	if (ind_robaka==indeks-1 &&   // to powinno przyspieszyc...
	    upl_y[zap_dolna] < upl_y[indeks])
	  dolne_kropki[nr_robaka]=indeks;
	// znajdz nowe polaczenia
	polaczenia=poprz.polaczenia;
	DodajPolaczenia(indeks);
	break;
      case 2:   // kropka laczy dwa istniejace robaki (lub nawet wiecej niz dwa)
	nast_kropka_robaka = nast_kropka_robaka_tab;
	robaki=robaki_tab;               straty=straty_tab;
	dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
	KopiujTablice(robaki, poprz.robaki);    
	KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
	memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
	memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
	memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
	// dodaj postawiona kropke do najwiekszego robaka
	robaki[indeks]=nr_robaka;
	na_pewno_bezp[nr_robaka] |= (upl_marg[indeks]==2);
	straty[nr_robaka] += TAnaliza::gracz.waga_kropki;
	nast_kropka_robaka[indeks] = nast_kropka_robaka[ind_robaka];
	nast_kropka_robaka[ind_robaka] = indeks;
	if (ind_robaka==indeks-1 &&   // to powinno przyspieszyc...
	    upl_y[dolne_kropki[nr_robaka]] < upl_y[indeks])
	  dolne_kropki[nr_robaka]=indeks;
	// polacz robaki
	for (int b=0; b<4; b++) {
	  unsigned int nind = indeks+dind[b];
	  if (robaki[nind] && robaki[nind]!=nr_robaka) {
	    // dolacz robaka (nind) do [nr_robaka]
	    int drugi_robak = robaki[nind];
	    {
	      int p=nind;
	      do {
		robaki[p]=nr_robaka;
		p=nast_kropka_robaka[p];
	      } while (p!=nind);
	    }
	    {
	      int zap=nast_kropka_robaka[indeks];
	      nast_kropka_robaka[indeks] = nast_kropka_robaka[nind];
	      nast_kropka_robaka[nind] = zap;
	    }
	    straty[nr_robaka]+=straty[drugi_robak];
	    straty[drugi_robak]=0;
	    if (upl_y[dolne_kropki[nr_robaka]] < upl_y[dolne_kropki[drugi_robak]])
	      dolne_kropki[nr_robaka] = dolne_kropki[drugi_robak];
	    dolne_kropki[drugi_robak]=0;
	    na_pewno_bezp[nr_robaka] |= na_pewno_bezp[drugi_robak];
	    na_pewno_bezp[drugi_robak]=0;
	  }
	}
	polaczenia = polaczenia_tab;
	SkopiujPotrzebne(poprz.polaczenia);  // kopiuje do (ile_polaczen2/2) polaczen
	DodajPolaczenia(indeks);
	break;
      }
    }
    else {  // byl stop -- cos zamknelismy!
      nast_kropka_robaka = nast_kropka_robaka_tab;
      robaki=robaki_tab;               straty=straty_tab;
      dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
      KopiujTablice(robaki, poprz.robaki);    
      KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
      memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
      memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
      memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
      krint *stos = skladowe.PrzydzielSkladowa();
      unsigned int na_stosie=1;
      stos[0]=indeks;    
      robaki[indeks] = ++ost_nr_robaka;
      int doly=upl_y[indeks],  dol=indeks;
      int wart=0, bezp=0;
      int poprz_ind;
      do {
	unsigned int ind = stos[--na_stosie];
	nast_kropka_robaka[ind] = poprz_ind;
	poprz_ind=ind;
	bezp |= (upl_marg[ind]==2);
	if (upl_y[ind]>doly) { doly=upl_y[ind];  dol=ind; }
	// dodaj straty
	if (rozgrywka[ind]==czyje)
	  wart+=TAnaliza::gracz.waga_kropki;    // kropka
	else if ((plansz_p[ind] & maska_sstopu) == maska_sstopu)
	  wart++;     // staly stop
	// idz w dol
	unsigned int nowy_ind = ind+1;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]!=ost_nr_robaka) {
	  // skasuj poprzedniego robaka
	  if (robaki[nowy_ind]) {
	    straty[robaki[nowy_ind]] = dolne_kropki[robaki[nowy_ind]] =0;
	    na_pewno_bezp[robaki[nowy_ind]] =0;
	  }
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	}
	// idz w gore
	nowy_ind = ind-1;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]!=ost_nr_robaka) {
	  // skasuj poprzedniego robaka
	  if (robaki[nowy_ind]) {
	    straty[robaki[nowy_ind]] = dolne_kropki[robaki[nowy_ind]] =0;
	    na_pewno_bezp[robaki[nowy_ind]] =0;
	  }
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	}
	// idz w lewo
	nowy_ind = ind-wlky-4;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]!=ost_nr_robaka) {
	  // skasuj poprzedniego robaka
	  if (robaki[nowy_ind]) {
	    straty[robaki[nowy_ind]] = dolne_kropki[robaki[nowy_ind]] =0;
	    na_pewno_bezp[robaki[nowy_ind]] =0;
	  }
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	}
	// idz w prawo
	nowy_ind = ind+wlky+4;
	if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]!=ost_nr_robaka) {
	  // skasuj poprzedniego robaka
	  if (robaki[nowy_ind]) {
	    straty[robaki[nowy_ind]] = dolne_kropki[robaki[nowy_ind]] =0;
	    na_pewno_bezp[robaki[nowy_ind]] =0;
	  }
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	}
      }
      while (na_stosie);
      skladowe.ZwolnijSkladowa(stos);
      nast_kropka_robaka[indeks] = poprz_ind;
      straty[ost_nr_robaka] = wart;
      na_pewno_bezp[ost_nr_robaka] = bezp;
      dolne_kropki[ost_nr_robaka] = dol;
      // ustaw polaczenia
      polaczenia = polaczenia_tab;
      SkopiujPotrzebne(poprz.polaczenia);  // kopiuje do (ile_polaczen2/2) polaczen
      DodajPolaczenia(indeks);
      sposob_odtw=2;  // = niczego nie trzeba odtwarzac
    }
  }
  else if (byl_stop) {  // przeciwnik cos zamknal!
    nast_kropka_robaka = nast_kropka_robaka_tab;
    robaki=robaki_tab;               straty=straty_tab;
    dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
    KopiujTablice(robaki, poprz.robaki);    
    KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
    memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
    memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
    memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
    //lista_naszych = lista_naszych_tab;
    //ile_naszych=0;
    //for (int i=0; i<poprz.ile_naszych; i++)
    //  if (rozgr2[poprz.lista_naszych[i]]==czyje)
    //    lista_naszych[ile_naszych++] = poprz.lista_naszych[i];
    // usun zamkniete robaki
    for (int i=1; i<=ost_nr_robaka; i++)
      if (dolne_kropki[i] && rozgr3[dolne_kropki[i]]!=czyje) {
	unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
	do {
	  int pom = nast_kropka_robaka[p];
	  robaki[p]=0;  nast_kropka_robaka[p]=0;
	  p=pom;
	} while (p!=indpocz);
	dolne_kropki[i]=0;
	straty[i]=0;
	na_pewno_bezp[i]=0;
      }
    // ustaw polaczenia
    polaczenia = polaczenia_tab;
    SkopiujPotrzebne(poprz.polaczenia);  // kopiuje do (ile_polaczen2/2) polaczen
    sposob_odtw=2;  // = niczego nie trzeba odtwarzac
  }
  else {  // przecwinik niczego nie zamyka...
    nast_kropka_robaka = poprz.nast_kropka_robaka;
    robaki=poprz.robaki;                straty=poprz.straty;
    dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
    //lista_naszych = poprz.lista_naszych;
    polaczenia=poprz.polaczenia;
    sposob_odtw=2;  // = niczego nie trzeba odtwarzac
  }
  /*
  // sprawdz, czy wszystko ok
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
      int dlug=0;
      do {
	int pom = nast_kropka_robaka[p];
	dlug++;
	if (pom==0 || robaki[pom]!=i || dlug>=wlkx4wlky4 || upl_y[pom]>upl_y[indpocz])
	  printf("blad_d1");
	p=pom;
      } while (p!=indpocz);
    }     
  for (int i=0; i<wlkx4wlky4; i++)
    if (rozgr2[i]==czyje && robaki[i]==0)
      printf("blad_d2");
  */
  STOPER_STOP_ROBD;
}

void TRobaki::UaktualnijGleb()
// zapamietaj, ze domyslnie nie nalezy niczego odtwarzac (byc moze nie dodalismy kropki)
{  sposob_odtw=2; }

void TRobaki::UstawPolaczonyZ_sklad(krint *polaczony_z) const
// ustawia tablice polaczony_z tak, aby
//   polaczony_z[robaki[ind1]] == polaczony_z[robaki[ind2]]   <=> 
//           <=>  [ind1] i [ind2] naleza do tej samej skladowej
{
  for (int i=1; i<=ost_nr_robaka; i++)
    polaczony_z[i]=i;
  // badaj polaczenia
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (k2) {
      int nr1=robaki[k1], nr2=robaki[k2];
      while (polaczony_z[nr1]!=nr1) nr1=polaczony_z[nr1];
      while (polaczony_z[nr2]!=nr2) nr2=polaczony_z[nr2];
      // polacz (nr1) z (nr2)
      if (nr1>nr2)
	polaczony_z[nr1]=nr2;
      else
	polaczony_z[nr2]=nr1;
    }
  }
  // zrob ,,kanoniczne'' polaczenia
  for (int i=ost_nr_robaka; i>1; i--)
    if (polaczony_z[i]!=i) {
      int nr=polaczony_z[i];
      while (nr!=polaczony_z[nr]) nr=polaczony_z[nr];
      polaczony_z[i]=nr;
    }
}

void TRobaki::ZnajdzSkladowe(krint *skl_tab, int nrpoczskl) const
// dziala jak ZnajdzSkladowe
// znajduje skladowe dla JEDNEGO gracza; skl_tab powinna byc wstepnie wyczyszczona (moze miec
//  tez ustawione skladowe 2. gracza)
{
  krint *polaczony_z;
  polaczony_z   = skladowe.PrzydzielSkladowa();
  UstawPolaczonyZ_sklad(polaczony_z);
  // teraz mozna ustawiac skl_tab
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int ind0 = dolne_kropki[i];
      unsigned int ind = ind0;
      int nrskl = nrpoczskl + polaczony_z[i];
      do {
	skl_tab[ind] = nrskl;
	ind = nast_kropka_robaka[ind];
      } while (ind!=ind0);
    }
  skladowe.ZwolnijSkladowa(polaczony_z);
}

TRobaki& TRobaki::operator=(const TRobaki& arg)
// Funkcja zaklada, ze this!=&arg
// ustawia wszystkie wskazniki w (this) na odp. wskazniki (arg)
{
  nast_kropka_robaka = arg.nast_kropka_robaka;
  robaki        = arg.robaki;             straty        = arg.straty;
  dolne_kropki  = arg.dolne_kropki;       na_pewno_bezp = arg.na_pewno_bezp;
  //lista_naszych = arg.lista_naszych;
  polaczenia    = arg.polaczenia;

  ost_nr_robaka = arg.ost_nr_robaka;
  ile_polaczen2 = arg.ile_polaczen2;
  //  ile_naszych   = arg.ile_naszych;
  sposob_odtw   = 2;   // niczego nie odtwarzaj!
  // nie kopiuj  czyje ani maska_sstopu;
}

void TRobaki::UsunKropke()
{
  switch (sposob_odtw) {
  case 0:
    // dla testu zeruj tez na_pewno_bezp...dolne_kropki:
    //      na_pewno_bezp[ost_nr_robaka]=straty[ost_nr_robaka]=dolne_kropki[ost_nr_robaka]=0;
    robaki[zap_indeks]=0;
    nast_kropka_robaka[zap_indeks] = 0;
    break;
  case 1:
    nast_kropka_robaka[ind_robaka] = nast_kropka_robaka[zap_indeks];
    nast_kropka_robaka[zap_indeks] = 0;
    na_pewno_bezp[robaki[zap_indeks]]= zap_wart_npbezp;
    straty[robaki[zap_indeks]] -= TAnaliza::gracz.waga_kropki;
    if (dolne_kropki[robaki[zap_indeks]]==zap_indeks)
      dolne_kropki[robaki[zap_indeks]] = zap_dolna;
    robaki[zap_indeks]=0;
    break;
  case 2:   // nic nie trzeba odtwarzac...
    break;
  }
}

void TRobaki::OdtworzKropke()
// odtwarza kropke usunieta funkcja UsunKropke().
{
  switch (sposob_odtw) {
  case 0:
    robaki[zap_indeks]=ost_nr_robaka;
    nast_kropka_robaka[zap_indeks] = zap_indeks;
    break;
  case 1:
    nast_kropka_robaka[zap_indeks] = nast_kropka_robaka[ind_robaka];
    nast_kropka_robaka[ind_robaka] = zap_indeks;
    robaki[zap_indeks] = robaki[ind_robaka];
    na_pewno_bezp[robaki[zap_indeks]] |= (upl_marg[zap_indeks]==2);
    straty[robaki[zap_indeks]] += TAnaliza::gracz.waga_kropki;
    if (upl_y[zap_indeks]>upl_y[zap_dolna])
      dolne_kropki[robaki[zap_indeks]] = zap_indeks;
    break;
  case 2:   // nic nie trzeba odtwarzac...
    break;
  }
}

int TRobaki::ZakazanePomiedzy(unsigned char *zakazane, unsigned int k1, unsigned int k2)
// zwraca 0, gdy nie jest zakazane, lub cos !=0 w przeciwnym razie
// k1,k2 powinny sie stykac po przekatnej
{
  if (k1<k2)
    if (k2==k1+wlky+3)
      return (zakazane[k2+1] & ZAKAZ_LG);
    else
      return (zakazane[k2-1] & ZAKAZ_LD);
  else
    if (k1==k2+wlky+3)
      return (zakazane[k1+1] & ZAKAZ_LG);
    else
      return (zakazane[k1-1] & ZAKAZ_LD);
}

int TRobaki::ZnajdzRobakiMatki(unsigned char *rozgr3, unsigned char *zakazane, unsigned char *bezpieczne,
			       TDwaUC marg3_min, TDwaUC marg3_max,
			       krint *goradol, krint *stratyskl,
			       krint *polaczony_z, krint *dolne_m)
// zwraca liczbe ustawionych skladowych w ,,goradol'' i ,,stratyskl''
{
  STOPER_START_ROBM;
  krint *straty_m, *bezp_m;   // _m jest skrotem od matki
  straty_m      = skladowe.PrzydzielSkladowa();
  bezp_m        = skladowe.PrzydzielSkladowa();
  for (int i=1; i<=ost_nr_robaka; i++) {
    bezp_m[i] = na_pewno_bezp[i] ? 2:0;
    polaczony_z[i]=i;
  }
  memcpy(dolne_m, dolne_kropki, sizeof(dolne_m[0])*(ost_nr_robaka+1));
  memcpy(straty_m, straty, sizeof(straty_m[0])*(ost_nr_robaka+1));
  // badaj polaczenia
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (k2) {
      if (ZakazanePomiedzy(zakazane,k1,k2)) {
	int nr1=robaki[k1], nr2=robaki[k2];
	while (polaczony_z[nr1]!=nr1) nr1=polaczony_z[nr1];
	while (polaczony_z[nr2]!=nr2) nr2=polaczony_z[nr2];
	// polacz (nr1) z (nr2)
	if (nr1>nr2)
	  polaczony_z[nr1]=nr2;
	else
	  polaczony_z[nr2]=nr1;
      }
    }
    else  // kolo bandy
      bezp_m[robaki[k1]] += bezpieczne[k1];
  }
  // zrob ,,kanoniczne'' polaczenia; pododawaj straty_m, bezp_m i dolne_m
  for (int i=ost_nr_robaka; i>1; i--)
    if (polaczony_z[i]!=i) {
      int nr=polaczony_z[i];
      while (nr!=polaczony_z[nr]) nr=polaczony_z[nr];
      polaczony_z[i]=nr;
      bezp_m[nr] += bezp_m[i];
      straty_m[nr] += straty_m[i];
      if (upl_y[dolne_m[i]] > upl_y[dolne_m[nr]])
	dolne_m[nr] = dolne_m[i];
    }
  // teraz mozna ustawiac ,,goradol'' i ,,stratyskl''
  int ileskl=0;
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i] && polaczony_z[i]==i && bezp_m[i]<2) {
      *goradol++   = dolne_m[i];
      *stratyskl++ = straty_m[i];
      ileskl++;
    }
  skladowe.ZwolnijSkladowa(straty_m);
  skladowe.ZwolnijSkladowa(bezp_m);
  STOPER_STOP_ROBM;
  return ileskl;
}



int TRobaki::ZnajdzRobakiMatki(unsigned char *rozgr3, unsigned char *zakazane, unsigned char *bezpieczne,
			       TDwaUC marg3_min, TDwaUC marg3_max,
			       krint *goradol, krint *stratyskl)
{
  krint *polaczony_z, *dolne_m;
  polaczony_z   = skladowe.PrzydzielSkladowa();
  dolne_m       = skladowe.PrzydzielSkladowa();
  int wynik = ZnajdzRobakiMatki(rozgr3, zakazane, bezpieczne,
				marg3_min, marg3_max,
				goradol, stratyskl, polaczony_z, dolne_m);
  skladowe.ZwolnijSkladowa(polaczony_z);
  skladowe.ZwolnijSkladowa(dolne_m);
  return wynik;
}

void TRobaki::UstawZakazane(unsigned char *zakazane, const unsigned char *rozgr3, 
			    const krint *skl_tab) const
{
  STOPER_START_UZAK;
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (k2) {
      if (k1<k2)
	if (k2==k1+wlky+3)
	  UstawZakazane12_B(zakazane, rozgr3, skl_tab, k1, czyje);
	else
	  UstawZakazane12_A(zakazane, rozgr3, skl_tab, k1, czyje);
      else
	if (k1==k2+wlky+3)
	  UstawZakazane12_B(zakazane, rozgr3, skl_tab, k2, czyje);
	else
	  UstawZakazane12_A(zakazane, rozgr3, skl_tab, k2, czyje);
    }
  }
  STOPER_STOP_UZAK;
}


int TRobaki::OcenRuch(unsigned char *rozgr3, krint *polaczony_z, unsigned int indeks, 
		      int nasze, int &poziom_bezp) const
// ocenia ruch [indeks], ocena jest z przedzialu ok. 0-90
// polaczony_z -- ustawione przez funkcje TRobaki::UstawPolaczonyZ_sklad()
// ,,nasze'' -- czy w [indeks] stawiamy kropke TRobaki::czyje, uzywane do sprawdzenia, czy
//              trzeba zwracac poziom_bezp (0,1,2,3) stawianej kropki (TYLKO gdy ,,nasze'').
// Uwaga: trzeba wywolac most12.Inicjuj(), jesli zmienila sie wielkosc planszy!!
{
  int ocena=0;
  // policz bezposrednich sasiadow
  int ile_rob=0, ile_sklad=0;
  int rob[8], sklad[20];    // z zapasem
  int dind[20] = {-wlky-5, -wlky-4, -wlky-3, -1,1, wlky+3, wlky+4, wlky+5};
  for (int i=0; i<8; i++) {
    unsigned int ind = indeks+dind[i];
    if (robaki[ind]) {
      if (ile_rob==0) {
	rob[ile_rob++]=robaki[ind];
	sklad[ile_sklad++]=polaczony_z[robaki[ind]];
      }
      else {
	for (int j=0; j<ile_rob; j++)
	  if (rob[j]==robaki[ind])
	    goto Nic_nie_rob;
	rob[ile_rob++]=robaki[ind];
	// skladowe
	sklad[ile_sklad]=polaczony_z[robaki[ind]];
	for (int j=0; j<ile_sklad; j++)
	  if (sklad[j]==polaczony_z[ile_sklad])
	    goto Nic_nie_rob;
	ile_sklad++;
      Nic_nie_rob:;
      }
    }
  }
  // i dalsi sasiedzi -- juz tylko skladowe
  int ile_dalszych_skl=0;
  for (int i=0; i<12; i++) {
    unsigned int ind=indeks+most12.dind[i];
    if (robaki[ind]) {
      int suma=ile_sklad+ile_dalszych_skl;
      sklad[suma]=polaczony_z[robaki[ind]];
      // sprawdz, czy tej skladowej juz nie bylo
      for (int j=0; j<suma; j++)
	if (sklad[j]==sklad[suma])
	  goto Juz_byla_skl;
      // zobacz, ile jest pustych sasiadow
      {
      int ile_pomiedzy = (rozgr3[indeks+most12.puste1[i]]==0) +
	(rozgr3[indeks+most12.puste2[i]]==0) +
	(rozgr3[indeks+most12.puste3[i]]==0);
      if (ile_pomiedzy>=2)
	ile_dalszych_skl++;       // zapamietaj nowa skladowa
      }
    Juz_byla_skl:;
    }
  }
  if (nasze) {
    // sprawdz desen -- czesciowo! to jest w PoleBezs12()
    if (ile_rob==1) {
      int przec=3-czyje;
      if ((rozgr3[indeks-1]==czyje && rozgr3[indeks-wlky-4]==czyje
	   && rozgr3[indeks-wlky-5]==czyje &&                                // LG
	  rozgr3[indeks+1]!=przec && rozgr3[indeks+wlky+4]!=przec) ||
	  (rozgr3[indeks-1]==czyje && rozgr3[indeks+wlky+4]==czyje
	   && rozgr3[indeks+wlky+3]==czyje &&                                // PG
	  rozgr3[indeks+1]!=przec && rozgr3[indeks-wlky-4]!=przec) ||
	  (rozgr3[indeks+1]==czyje && rozgr3[indeks+wlky+4]==czyje
	   && rozgr3[indeks+wlky+5]==czyje &&                                // PD
	  rozgr3[indeks-1]!=przec && rozgr3[indeks-wlky-4]!=przec) ||
	  (rozgr3[indeks+1]==czyje && rozgr3[indeks-wlky-4]==czyje
	   && rozgr3[indeks-wlky-3]==czyje &&                                // LD
	   rozgr3[indeks-1]!=przec && rozgr3[indeks+wlky+4]!=przec)) {
	poziom_bezp=0;
	return 0;
      }
      } 
    if (upl_marg[indeks]==2 || 
	na_pewno_bezp[robaki[indeks-1]] ||           // powinno byc
	na_pewno_bezp[robaki[indeks+1]] ||           // na_pewno_bezp[0]=0
	na_pewno_bezp[robaki[indeks-wlky-4]] ||
	na_pewno_bezp[robaki[indeks+wlky+4]])
      poziom_bezp=4;
    else
      poziom_bezp= (upl_marg[indeks]==3) + (ile_rob!=0) + (ile_dalszych_skl!=0);
    ocena+=poziom_bezp;
    }
  // przelicz ile_rob, ile_sklad, ile_dalszych_sklad na ocene
  // bonus za robaki
  const int ocena_ile_rob[5]={0,6,10,10,10};
  ocena += ocena_ile_rob[ile_rob];
  // bonus za skladowe
  const int ocena_ile_sklad[]={0,6,40,56,72, 72,72,72,72,72, 72,72};   // z zapasem
  ocena += ocena_ile_sklad[ile_sklad+ile_dalszych_skl];
  ocena += ile_dalszych_skl;   // bonus za mostek
  return ocena;
}


/*
long int TRobaki::WezPoprawkeNaSklPop(unsigned char *rozgr3, long int *oceny)
{
  long int pop=0;
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i] && polaczony_z[i]==i && bezp_m[i]<2) {
      // czy zamknieta?
      if (rozgr3[dolne_m[i]]!=czyje) pop += *oceny;
      oceny++;
    }
  return pop;
} */

/*
void TRobaki::PorownajZeSklnr(krint *sklnr, krint *stratynr, krint *goradol,
			      int ilesklnr)
{
  unsigned char *przetest=plansze.PrzydzielPlansze();
  CzyscTablice(przetest);
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i] && polaczony_z[i]==i) {
      int nrs = sklnr[dolne_kropki[i]];
      assert(bezp_m[i]>=2 || (nrs<30000 && stratynr[nrs-1] == straty_m[i]));
      if (nrs==50000 || goradol[(nrs-1)]==0)
	assert(bezp_m[i]>=2);
      else {
	assert(bezp_m[i]<2);
	assert(upl_y[dolne_m[i]] == upl_y[goradol[nrs-1]]);
      }
      przetest[nrs]=1;
    }
  for (int i=1; i<=ilesklnr; i++)
    assert(przetest[i]);
  plansze.ZwolnijPlansze(przetest);
} */

/**********************************************************************/


void UwzglednijKillerMoveSortuj(krint *lista, int n, int r1, int r2, int wart1, int wart2)
// stand. wart1=29000, wart2=14500
// powinno byc r1!=r2 (ew. moze byc r1==r2==0)
// moze byc r1!=0 i r2==0, ale NIE NA ODWROT
{
  int ile = (r1!=0)+(r2!=0);
  switch (ile) {
  case 2: {
    TAnaliza::historia_sort[r1]+=wart1;   // 1. miejsce w km
    TAnaliza::historia_sort[r2]+=wart2;    // 2. miejsce w km
    int skad=n-1, jest1=0, jest2=0;
    int dokad=skad;
    while (skad>=0)
      if (lista[skad]==r1)       { skad--;  jest1=1; }
      else if (lista[skad]==r2)  { skad--;  jest2=1; }
      else lista[dokad--] = lista[skad--];
    if (jest1) {
      lista[0]=r1;
      if (jest2) lista[1]=r2;
    }
    else if (jest2) lista[0]=r2; 
  }
  break;
  case 1: {
    TAnaliza::historia_sort[r1]+=wart1;   // 1. miejsce w km
    int skad=n-1, jest1=0;
    int dokad=skad;
    while (skad>=0)
      if (lista[skad]==r1) { skad--;  jest1=1; }
      else lista[dokad--] = lista[skad--];
    if (jest1) lista[0]=r1;
  }
  break;
  }  
}

inline void UwzglednijKillerMove(int akt_gleb, int ost_gleb)
// sortuje ang[akt_gleb].lista_ruchow tak, aby
// ,,killer moves'' wyladowaly na poczatku
// Zaklada, ze akt_gleb jest >=2
{
  unsigned short int prop0, prop1;
  int rodzaj;
  if (akt_gleb<=3) {
    htablicaZ.Wez(ang[akt_gleb-1].htab_zobrist2, ang[akt_gleb-1].htab_zobrist,
		  rodzaj, prop0, prop1, ost_gleb-akt_gleb);
    ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks] = prop0;
    ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks] = prop1;
  }
  else {
    prop0 = ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks];
    prop1 = ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks];
    rodzaj = (ang[akt_gleb-1].rodzaj_oc_ht[ang[akt_gleb-1].indeks] & 3);
    //assert(prop0<wlkx4wlky4 && prop1<wlkx4wlky4);
    //assert(prop0==0 || (prop0!=prop1));
  }
  //  if (akt_gleb<=5 || akt_gleb<ost_gleb-1)
  //  if (akt_gleb<=6 ||  akt_gleb<ost_gleb-2) {
  /*
    // calkiem dobre, choc kiepskie na test3/13 (79.22s)
  if (rodzaj==0 || akt_gleb<=5 || akt_gleb<ost_gleb-2) {
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : 500));
    int wart2 = rodzaj ? (wart1>>1) : 200;
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  /*
    // chyba lepsze, choc dalej kiepskie na test3/13 (ok. 76s)
  if (rodzaj==0 || akt_gleb<=5 || akt_gleb<ost_gleb-2) {
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    //    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : (ost_gleb-akt_gleb>=5 ? 2000 : 500)));
    //int wart2 = rodzaj ? (wart1>>1) : (akt_gleb<=3 ? 6000 : (ost_gleb-akt_gleb>=5 ? 800 : 200));
    int wart1 = (rodzaj ? 29500 : ((akt_gleb<=3 || ost_gleb-akt_gleb>=5) ? 15000 : 8000));
    int wart2 = rodzaj ? (wart1>>1) : ((akt_gleb<=3 || ost_gleb-akt_gleb>=5) ? 7000 : 2000);
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=3; wart2>>=4; }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  /*
  { // bardzo dobre! tylko test3/13 wolniej: 66.85s
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    //    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : (ost_gleb-akt_gleb>=5 ? 2000 : 500)));
    //int wart2 = rodzaj ? (wart1>>1) : (akt_gleb<=3 ? 6000 : (ost_gleb-akt_gleb>=5 ? 800 : 200));
    int wart1 = (rodzaj ? 29500 : 22000);
    int wart2 = rodzaj ? 14500: 11000;
    //if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=3; wart2>>=5; }
    //    if (akt_gleb>1+2*(ost_gleb-akt_gleb)) { wart1>>=3; wart2>>=5; }
    int prog_akt[] = {0,3,5,9,11,12,15,16,17,18,19,20,21,21,21,21,21,21,21,21,21};
    //    if (akt_gleb>prog_akt[ost_gleb-akt_gleb]) { wart1>>=(4-(ost_gleb-akt_gleb)); wart2>>=(6-(ost_gleb-akt_gleb)); }
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=(5+(akt_gleb/8)); wart2>>=(6+(akt_gleb/4)); }
    if (akt_gleb>7 && akt_gleb==ost_gleb-2) { wart1>>=(1+(akt_gleb/8)); wart2>>=(3+(akt_gleb/4)); }
    //if (akt_gleb>5 && rodzaj) { wart1>>=2; wart2>>=5; }
    //    for (int i=4; i<akt_gleb; i++)
    //      if (2*(ost_gleb-akt_gleb)<=i-1) { wart1>>=1; wart2>>=1; }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  { // ,,bdb+'' (66.23)
    int wart1 = (rodzaj ? 29500 : 22000);
    int wart2 = rodzaj ? 14500: 11000;
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=(4+(rodzaj!=0)+(akt_gleb/8)); wart2>>=(5+(rodzaj!=0)+(akt_gleb/4)); }
    if (akt_gleb>6 && akt_gleb==ost_gleb-2) { wart1>>=(1+(rodzaj!=0)+(akt_gleb/8)); wart2>>=(3+2*(rodzaj!=0)+(akt_gleb/4)); }
    if (akt_gleb>8 && akt_gleb==ost_gleb-3) { wart1>>=(1+(rodzaj!=0));   wart2>>=(3+2*(rodzaj!=0)); }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
}


krint SasiedziAW(krint *odblokowuja, const unsigned char* rozgr3,
		 int kto, int przec, unsigned int pole, int wprawo, int wgore)
  // zwraca 0 lub indeks antyweza
  // szablon:
  //   n  
  // n   o o n
  //   . x o n          <-- x tutaj ma wspolrzedna [pole]
  //     x .
  // objasnienie: x - kropka przec, . - kropka kto, o - puste pole,
  //  n - puste pole lub kropka przec
{
  if (rozgr3[pole+wgore] != 0     || rozgr3[pole+wprawo] != 0 ||
      rozgr3[pole-wgore] != przec || rozgr3[pole-wprawo] != kto)
    return 0;
  if (rozgr3[pole+wgore+wprawo] != 0   || rozgr3[pole+wgore+2*wprawo] == kto ||
      rozgr3[pole+2*wprawo]     == kto || rozgr3[pole-wgore+wprawo] != kto)
    return 0;
  if (rozgr3[pole-wprawo+2*wgore]==kto || rozgr3[pole-2*wprawo+wgore]==kto)
    return 0;
  if (upl_marg[pole+wgore]<=2)
    return 0;   // nie blokujemy na samej bandzie, ani tym bardziej poza plansza
  unsigned int ind = pole+2*(wprawo+wgore);
  while (upl_marg[ind]>=1) {
    if (rozgr3[ind]==kto) return 0;
    else if (rozgr3[ind]!=0) break;
    if (rozgr3[ind+wprawo]==kto) return 0;
    else if (rozgr3[ind+wprawo]!=0) break;
    if (rozgr3[ind-wprawo]==kto) return 0;
    else if (rozgr3[ind-wprawo]!=0) break;
    if (rozgr3[ind+wprawo-wgore]==kto) return 0;
    else if (rozgr3[ind+wprawo-wgore]!=0) break;
    ind += wprawo+wgore;
  }
  // ok, ustaw antyweze
  odblokowuja[0] = pole+wprawo;
  odblokowuja[1] = pole+2*wprawo;
  odblokowuja[2] = odblokowuja[0]+wgore;
  odblokowuja[3] = odblokowuja[1]+wgore;
  odblokowuja[4] = odblokowuja[2]+wgore;
  odblokowuja[5] = odblokowuja[3]+wgore;
  odblokowuja[6] = odblokowuja[4]-wprawo;
  odblokowuja[7] = odblokowuja[6]-wprawo;
  odblokowuja[8] = odblokowuja[7]-wgore;
  odblokowuja[9] = odblokowuja[8]-wprawo;
  return pole+wgore;
}

int PonadDwieKropki(unsigned char *r, unsigned int ind)
// zwraca 1, gdy w 20-kropkowym sasiedztwie kropki [ind]
// sa co najmniej dwie kropki
{
  int ile=0;
  unsigned int indp = ind + wlky+4 -2;
  for (int i=0; i<5; i++)       // na prawo od [ind]
    ile += (r[indp+i] != 0);
  indp+= wlky+4+1;
  for (int i=0; i<3; i++)       // 2 na prawo od [ind]
    ile += (r[indp+i] != 0);
  if (ile>=2) return 1;
  indp = ind -wlky-4 -2;
  for (int i=0; i<5; i++)       // na lewo od [ind]
    ile += (r[indp+i] != 0);
  indp-= wlky+4-1;
  for (int i=0; i<3; i++)       // 2 na lewo od [ind]
    ile += (r[indp+i] != 0);
  if (ile>=2) return 1;
  ile+= (r[ind-2]!=0);
  ile+= (r[ind-1]!=0);
  ile+= (r[ind+1]!=0);
  ile+= (r[ind+2]!=0);
  return (ile>=2);
}

int DodajSasiadow(krint *listar, krint *sasiedzi, int ile_sas,
		  unsigned char *schemat_ruchow, int maska)
  // dodaje max. ile_sas sasiadow do listar, zwraca liczbe dodanych
  // sasiadow. Nie dodaje tych ruchow, ktore maja ustawiona maske
  // w schemacie ruchow.
  // Funkcja pomocnicza dla DodajSasiadow(uchar*, int, int)
{
  int iledod=0;
  for (int i=0; i<ile_sas; i++) {
    if ((schemat_ruchow[*sasiedzi] & maska)==0)
      { *listar++ = *sasiedzi;  iledod++; }
    sasiedzi++;
  }
  return iledod;
}

void RuchyQuickSort(krint *tab, int n);

/*
#define MAX_DRUGI_RUCH 100000
class TDrugiRuch {
  krint *tab;
  int *nr_ruchu;
  int ile_ruchow1, ile_ruchow2;
public:
  TDrugiRuch() { tab=new krint[MAX_DRUGI_RUCH]; nr_ruchu=new int[max_powierzchnia_planszy]; };
  ~TDrugiRuch() { delete[] tab; delete[] nr_ruchu; };
  void Inicjuj();
  void Zapisz();
  void Sortuj();
} drugi_ruch;

void TDrugiRuch::Inicjuj()
// korzysta z ang[1].pocz_ruch, .ost_ruch, ang[1].lista_ruchow
{
  ile_ruchow1 = ang[1].ost_ruch-ang[1].pocz_ruch;
  if (ile_ruchow1==0) return;  // na wszelki wypadek
  ile_ruchow2 = MAX_DRUGI_RUCH / ile_ruchow1;
  for (int i=0; i<wlkx4wlky4; i++)
    nr_ruchu[i] = -1;  // inicjuj na -1, zeby wiedziec, ktore ruchy sa
  for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++)
    tab[  nr_ruchu[ang[1].lista_ruchow[i]] = (i-ang[1].pocz_ruch)*ile_ruchow2  ] =0;

}

void TDrugiRuch::Zapisz()
// korzysta z ang[1].indeks, ang[2].lista_ruchow, .pocz_ruch, .ost_ruch
{
  int baza=nr_ruchu[ang[1].indeks];
  if (baza==-1) return;  // nie mamy ruchu w bazie
  int ile=ang[2].ost_ruch-ang[2].pocz_ruch;
  if (ile>ile_ruchow2) ile=ile_ruchow2;
  if (ile)
    memcpy(&tab[baza], &ang[2].lista_ruchow[ang[2].pocz_ruch], sizeof(tab[0])*ile);
  if (ile<ile_ruchow2) tab[baza+ile]=0;   // zero konczace liste ruchow
}

void TDrugiRuch::Sortuj()
// korzysta z ang[1].indeks, ang[2].lista_ruchow, .pocz_ruch, .ost_ruch
{
  int baza=nr_ruchu[ang[1].indeks];
  if (baza==-1 || tab[baza]==0) return;  // nie mamy ruchu w bazie
  int ile=ang[2].ost_ruch-ang[2].pocz_ruch;
  for (int i=0; i<ile; i++)
    TAnaliza::historia_sort[ang[2].lista_ruchow[ang[2].pocz_ruch+i]] = ile-i;
  for (int i=0; i<ile_ruchow2; i++)
    if (tab[baza+i])
      TAnaliza::historia_sort[tab[baza+i]] += ile_ruchow2-i;  //= 2*max_powierzchnia_planszy -i;
    else break;
  RuchyQuickSort(&ang[2].lista_ruchow[ang[2].pocz_ruch], ile);
}
*/

void DodajSasiadow(unsigned char *schemat_ruchow, int akt, int ost)
  // tutaj ost>=3, akt>=2, akt<ost (akt==akt_gleb, ost==ost_gleb)
  // dodaje na kazdej glebokosci
  // maski w schemat_ruchow:
  //  1,2: lisc
  //  4,8: upr
  // 0x10,0x20: pelna lista
  // maski w ang[0].sasiedzi.tab_sas:
  //  1  : sasiedzi dodawani do ruchow gracza ang[1].ktory_gracz
  //  2  : sasiedzi dodawani do ruchow gracza ang[2].ktory_gracz
  //  4  : (nieuzywane)
  //  8  : ruch zabroniony (anty-waz)
  // 0x10: pole odblokowujace zabroniony ruch (anty-waz)
  // 0x20: sasiedzi dodawani do liscia gdy akt jest nieparzyste
  // 0x40: sasiedzi dodawani do liscia gdy akt jest parzyste
{
  STOPER_START_DSAS;
  // dodajemy sasiadow ruchu [akt-1]
  // do niep i parz wszystkie wolne pola (trzeba potem sprawdzac,
  // czy ruchow nie ma juz na listach ruchow: pelnych lub upr),
  // do liscia od razu tylko te, ktorych jeszcze nie ma (w lisciach
  // lub dotychczasowych sasiadach)
  {
    krint *sas1, *sas12;
    int *ile_s1, *ile_s12;
    int maska1, maska12, maska_lisc;
    if (akt & 1) {
      sas1 = ang[akt].sasiedzi.niep;
      sas12= ang[akt].sasiedzi.parz;
      ile_s1 = &ang[akt].sasiedzi.ile_n;
      ile_s12= &ang[akt].sasiedzi.ile_p;
      maska1=1;   maska12=2;   maska_lisc=0x20;
    } else {
      sas1 = ang[akt].sasiedzi.parz;
      sas12= ang[akt].sasiedzi.niep;
      ile_s1 = &ang[akt].sasiedzi.ile_p;
      ile_s12= &ang[akt].sasiedzi.ile_n;
      maska1=2;   maska12=1;   maska_lisc=0x40;
    }
    *ile_s1=0;  *ile_s12=0;  ang[akt].sasiedzi.ile_lisc=0;
    for (int p=0; p<20; p++) {
      unsigned int ind = ang[akt-1].indeks + ang[0].polaboczne_dind[p];
      //      if (PoleBezs12(ang[akt-1].rozgr3, ind, 1))
      //        continue;   // pole zupelnie lub chwilowo bezsensowne
      if (ang[akt-1].rozgr3[ind]==0 && upl_marg[ind]>=2) {  // wolne pole wewn. planszy
	if (p<8 && (ang[0].sasiedzi.tab_sas[ind] & maska1)==0) {
	  *sas1++ = ind;
	  (*ile_s1)++;
	  ang[0].sasiedzi.tab_sas[ind] |= maska1;
	}
	if ((ang[0].sasiedzi.tab_sas[ind] & maska12)==0) {
	  if (p<8 || upl_marg[ind]==3 || PonadDwieKropki(ang[akt-1].rozgr3,ind)) {
	    *sas12++ = ind;
	    (*ile_s12)++;
	    ang[0].sasiedzi.tab_sas[ind] |= maska12;
	  }
	}
	if (p<8 && (ang[0].sasiedzi.tab_sas[ind] & maska_lisc)==0 &&
	    (schemat_ruchow[ind] & ang[akt-1].maska_lisc)==0) {
	  ang[akt].sasiedzi.lisc[  ang[akt].sasiedzi.ile_lisc++  ]=ind;
	  ang[0].sasiedzi.tab_sas[ind] |= maska_lisc;
	}
      }
    }
  }
  // teraz dodaj sasiadow do listy
  if (akt==2) {
    // policz, ile sasiadow (z .parz) trzeba dodac
    int ile_dodac=0, ktore[8];
    for (int i=0; i<ang[2].sasiedzi.ile_p; i++) {
      unsigned int ind = ang[2].sasiedzi.parz[i];
      if ((schemat_ruchow[ind] & ang[2].maska_pelna)==0)
	{ ile_dodac++;  ktore[i]=1; }
      else ktore[i]=0;
    }
    if (ile_dodac) {
      // przesun w gore wszystkie ruchy z wyjatkiem 3 najlepszych (jesli sa 3)
      int skad = ang[2].pocz_ruch+3;
      for (int i=ang[2].ost_ruch-1; i>=skad; i--)
	ang[2].lista_ruchow[i+ile_dodac] = ang[2].lista_ruchow[i];
      // wstaw sasiadow
      if (ang[2].ost_ruch - ang[2].pocz_ruch <3)  skad=ang[2].ost_ruch;
      for (int i=0; i<ang[2].sasiedzi.ile_p; i++)
	if (ktore[i]) 
	  ang[2].lista_ruchow[skad++] = ang[2].sasiedzi.parz[i];
      ang[2].ost_ruch += ile_dodac;
    }
    /*
      // tu chyba tak nie mozna -- ang[2].lista_ruchow jest taka sama dla kolejnych pierwszych ruchow!
    if (ost>=6) {  // filtruj bezsensowne
      int dokad=0;
      for (int i=0; i<ang[2].ost_ruch; i++) {
	unsigned int ind = ang[2].lista_ruchow[ang[2].pocz_ruch + i];
	if (!PoleBezs12(ang[1].rozgr3, ind, 1))
	  ang[2].lista_ruchow[dokad++] = ind;
      }
      ang[2].pocz_ruch=0;
      ang[2].ost_ruch =dokad;
    }
    */
  } 
  else if (akt<ost-1) 
    {
    // tutaj mamy miec w [akt] pelna liste ruchow
    int iler = ang[akt-2].ost_ruch - ang[akt-2].pocz_ruch;
    int ilenajl = (iler<3) ? iler:3;
    // przepisz najlepsze
    for (int i=0; i<ilenajl; i++)
      ang[akt].lista_ruchow[i] = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
    int dokad = ilenajl;
    // przepisz sasiadow
    if (akt & 1) {
      // przepisz niep z poziomow [akt-1] i [akt]
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.niep,
			     ang[akt-1].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_pelna);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.niep,
			     ang[akt].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_pelna);
    } else { // j.w., ale przepisujemy z parz
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.parz,
			     ang[akt-1].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_pelna);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.parz,
			     ang[akt].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_pelna);
    }
    /*
      // tu tez tak nie mozna -- pozniej juz nigdy nie dodamy usunietych ruchow!
      // (one pozostana zaznaczone w schemat_ruchow)

    if (akt<ost-4) {
      // przegladnij, czy nie ma bezsensownych
      int dokad2=0;
      for (int i=0; i<dokad; i++)
	if (!PoleBezs12(ang[akt-1].rozgr3, ang[akt].lista_ruchow[i], 1))
	  ang[akt].lista_ruchow[dokad2++] = ang[akt].lista_ruchow[i];
      dokad=dokad2;
      // przepisz reszte ruchow filtrujac bezsensowne
      for (int i=ilenajl; i<iler; i++) {
	unsigned int ind = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
	if (!PoleBezs12(ang[akt-1].rozgr3, ind, 1))
	  ang[akt].lista_ruchow[dokad++] = ind;
      }
    }
    else  // przepisz reszte ruchow
    */
      for (int i=ilenajl; i<iler; i++)
	ang[akt].lista_ruchow[dokad++] = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
    // ustaw pocz_ruch i ost_ruch
    ang[akt].pocz_ruch=0;
    ang[akt].ost_ruch =dokad;
  } 
  else 
    {  // akt==ost-1, akt>2
    // wypelnij tablice [akt].lista_ruchow uproszczonymi
    // przepisz do 3 najlepszych
    int dokad=0, skad=ang[akt-2].pocz_ruch;
    while (skad < ang[akt-2].ost_ruch) {
      unsigned int ind = ang[akt-2].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & (ang[akt].maska_upr | ang[akt].maska_pelna)) !=
	   ang[akt].maska_pelna) {
	// pow. warunek spelniony <=> ruch jest na liscie upr, lub nie ma go
	// na liscie pelnej, a w konsekwencji jest jednym z sasiadow
	ang[akt].lista_ruchow[dokad++] = ind;
	if (dokad==3) break;  // tylko 3 najlepsze!
      }
    }
    // przepisz sasiadow
    if (akt & 1) {
      // przepisz niep z poziomow [akt-1] i [akt]
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.niep,
			     ang[akt-1].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_upr);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.niep,
			     ang[akt].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_upr);
    } else { // j.w., ale przepisujemy z parz
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.parz,
			     ang[akt-1].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_upr);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.parz,
			     ang[akt].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_upr);
    }
    // przepisz reszte ruchow
    while (skad < ang[akt-2].ost_ruch) {
      unsigned int ind = ang[akt-2].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & (ang[akt].maska_upr | ang[akt].maska_pelna)) !=
	   ang[akt].maska_pelna)
	// pow. warunek spelniony <=> ruch jest na liscie upr, lub nie ma go
	// na liscie pelnej, a w konsekwencji jest jednym z sasiadow
	ang[akt].lista_ruchow[dokad++] = ind;
    }
    // ustaw pocz_ruch i ost_ruch
    ang[akt].pocz_ruch=0;
    ang[akt].ost_ruch =dokad;
  } 
  // teraz zobacz, czy trzeba wypelnic lisc
  if (akt+1==ost) {
    int gleb_skad = (akt&1)+1;
    // przepisz do 3 najlepszych
    int dokad=0, skad=ang[gleb_skad].pocz_ruch;
    while (skad < ang[gleb_skad].ost_ruch) {
      unsigned int ind = ang[gleb_skad].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & ang[ost].maska_lisc)!=0) {
	ang[ost].lista_ruchow[dokad++] = ind;
	if (dokad==3) break;  // tylko 3 najlepsze!
      }
    }
    // przepisz wszystkich sasiadow
    //for (int g=gleb_skad+1; g<=akt; g+=2)
    for (int g=akt; g>=2; g-=2)                 // tak szybciej na ogol
      for (int r=0; r<ang[g].sasiedzi.ile_lisc; r++)
	ang[ost].lista_ruchow[dokad++] = ang[g].sasiedzi.lisc[r];
    // przepisz reszte ruchow
    while (skad < ang[gleb_skad].ost_ruch) {
      unsigned int ind = ang[gleb_skad].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & ang[ost].maska_lisc)!=0)
	ang[ost].lista_ruchow[dokad++] = ind;
    }

    /*
    // posortuj ruchy 3,..,dokad
    if (dokad>8) {
      int sortuj_do = dokad;  //>20 ? 20:dokad;

      ang[akt-1].robaki[ang[ost].ktory_teraz-1].UstawPolaczonyZ_sklad(TAnaliza::polaczony_z[0]);
      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
	int poziom_bezp;
	int ocena=
	  ang[akt-1].robaki[ang[ost].ktory_teraz-1].OcenRuch(
   	    ang[akt-1].rozgr3, 
	    TAnaliza::polaczony_z[0], ind, 1, poziom_bezp);
	TAnaliza::historia_sort[ind]= ocena + 2*(sortuj_do-i);
	} 

      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
	TAnaliza::historia_sort[ind] = 2*(sortuj_do-i);
      }

      int oceny[3]={2000,1000,500};
      for (int g=1; g<akt; g++) {
	for (int i=0; i<3; i++)
	  if (ang[g].pocz_ruch+i < ang[g].ost_ruch)
	    TAnaliza::historia_sort[ang[g].lista_ruchow[ang[g].pocz_ruch+i]] +=
	      oceny[i];
	oceny[0]*=5;   oceny[1]*=5;  oceny[2]*=5;  
	oceny[0]/=6;   oceny[1]/=6;  oceny[2]/=6;
      }
      for (int g=1; g<akt; g++) 
	TAnaliza::historia_sort[ang[g].indeks]=0;

      RuchyQuickSort(&ang[ost].lista_ruchow[0], sortuj_do);
      // odtworz
      for (int i=up.lg; i<=up.pd; i++)
      	TAnaliza::historia_sort[i]= 1;

      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
      	TAnaliza::historia_sort[ind]= 1;
      }
    }
    */

    // ustaw pocz_ruch i ost_ruch
    ang[ost].pocz_ruch=0;
    ang[ost].ost_ruch =dokad;
  }
 if (TAnaliza::gracz.umiejetnosci & 0x40) {
 // zobacz czy sa nowe antyweze
 if ((akt & 1) && akt>=3) {
   unsigned int pole = ang[akt-1].indeks;
   int przec = ang[akt-1].ktory_teraz;
   int kto   = ang[akt].ktory_teraz;
   int wprawo[8] = {1,1,-1,-1,+wlky+4,+wlky+4,-wlky-4,-wlky-4 };
   int wgore [8] = {+wlky+4,-wlky-4,+wlky+4,-wlky-4, 1,-1, 1,-1 };
   for (int i=0; i<8; i++)
     if ((ang[akt].sasiedzi.antywaz =
	  SasiedziAW(ang[akt].sasiedzi.odblokowuja, ang[akt-1].rozgr3, //bylo ang[akt].rozgr3 (popr: 82.35)
		     kto, przec, pole, wprawo[i], wgore[i]))!=0)
       break;
   if (ang[akt].sasiedzi.antywaz) {
     ang[0].sasiedzi.tab_sas[ ang[akt].sasiedzi.antywaz ] |= 8;
     for (int i=0; i<10; i++)
       ang[0].sasiedzi.tab_sas[ ang[akt].sasiedzi.odblokowuja[i] ] |= 0x10;
   }
 }
 // zobacz, czy poprzedni ruch odblokowuje jakies zablokowane przez antyweze ruchy
 if (akt>=4 && (ang[0].sasiedzi.tab_sas[ ang[akt-1].indeks ] & 0x10)) {
   unsigned int ind = ang[akt-1].indeks;
   for (int g=3; g<akt; g+=2)
     if (ang[g].sasiedzi.antywaz)
       for (int i=0; i<10; i++)
	 if (ang[g].sasiedzi.odblokowuja[i] == ind)
	   { ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] &= (~8); break; }
 }
 // usun z listy ruchow ruchy zablokowane przez antyweze, dodaj odblokowane
 if ((akt & 1) && akt>=3) {
   int sa_antyweze = 0;
   for (int g=3; g<=akt; g++)
     if (ang[g].sasiedzi.antywaz) { sa_antyweze=1; break; }
   if (sa_antyweze) {
     int dokad = ang[akt].pocz_ruch;
     for (int i=ang[akt].pocz_ruch; i<ang[akt].ost_ruch; i++) {
       unsigned int ind = ang[akt].lista_ruchow[i];
       if ((ang[0].sasiedzi.tab_sas[ind] & 8) == 0)
	 ang[akt].lista_ruchow[dokad++] = ind;
     }
     ang[akt].ost_ruch = dokad;
     // dodaj odblokowane
     for (int g=3; g<akt; g+=2)
       if (ang[g].sasiedzi.antywaz && 
	   (ang[0].sasiedzi.tab_sas[ang[g].sasiedzi.antywaz] & 8) == 0) {
	 // dodaj ruch .antywaz, jesli go nie ma
	 int jest=0;
	 for (int i=ang[akt].pocz_ruch; i<ang[akt].ost_ruch; i++)
	   if (ang[akt].lista_ruchow[i] == ang[g].sasiedzi.antywaz)
	     { jest=1; break; }
	 if (!jest)
	   ang[akt].lista_ruchow[ ang[akt].ost_ruch++ ] = ang[g].sasiedzi.antywaz;
       }
   }
 }
 }
 // if (akt<=6) // && akt<ost-1) // drugi warunek: optymalizacja?? -- wywoluj rzadziej
 UwzglednijKillerMove(akt,ost);
 // if (akt==2)   drugi_ruch.Sortuj();
 STOPER_STOP_DSAS;
}


void UsunSasiadow(unsigned char *schemat_ruchow, int akt)
{
  if (akt==1) {
    // trzeba usunac sasiadow z listy ruchow
    int dokad=0;
    for (int skad=ang[2].pocz_ruch; skad<ang[2].ost_ruch; skad++) {
      unsigned int ind = ang[2].lista_ruchow[skad];
      if ((schemat_ruchow[ind] & ang[2].maska_pelna)!=0)
	ang[2].lista_ruchow[dokad++] = ind;
    }
    ang[2].pocz_ruch=0;   ang[2].ost_ruch=dokad;
  }
  for (int i=0; i<ang[akt+1].sasiedzi.ile_n; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.niep[i] ] &= (~1);
  for (int i=0; i<ang[akt+1].sasiedzi.ile_p; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.parz[i] ] &= (~2);
  int antymaska_lisc = (akt&1) ? ~0x40 : ~0x20;
  for (int i=0; i<ang[akt+1].sasiedzi.ile_lisc; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.lisc[i] ] &= antymaska_lisc;
  if (TAnaliza::gracz.umiejetnosci & 0x40) {
  // antyweze
  if ((akt & 1)==0 && ang[akt+1].sasiedzi.antywaz) {
    // usun odblokowujace
    for (int i=0; i<10; i++)
      ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.odblokowuja[i] ] &= (~0x10);
    // dodaj (z powrotem) poprzednie odblokowujace
    for (int g=3; g<akt; g+=2)
      if (ang[g].sasiedzi.antywaz)
	for (int i=0; i<10; i++)
	  ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.odblokowuja[i] ] |= 0x10;
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.antywaz ] &= (~8);
  }
  // dodaj odblokowane poprzednio antyweze
  for (int g=3; g<=akt; g+=2)
    if (ang[g].sasiedzi.antywaz && 
	(ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] & 8)==0) {
      // czy ten [g].antywaz jest odblokowany?
      for (int gg=g+1; gg<akt; gg++) {
	unsigned int ind = ang[gg].indeks;
	for (int i=0; i<10; i++)
	  if (ang[gg].sasiedzi.odblokowuja[i] == ind)
	    goto Jednak_odblokowany;
      }
      ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] |= 8;
    Jednak_odblokowany:;
    }
  }
}

int WykonajRuchNrJesliMozna(unsigned char *rozgrywka, int akt_gleb, int sprawdzaj_bezs=0)
// zwraca 1, gdy mozna, 0 = nie mozna
// uaktualnia tez historia_sort
{
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  // wez aktualny ruch
  int i = angakt.x =
    upl_x[angakt.lista_ruchow[ angakt.nr_ruchu ]];
  int j = angakt.y =
    upl_y[angakt.lista_ruchow[ angakt.nr_ruchu ]];
  unsigned int indeks = angakt.hindeks = angakt.indeks = 
    angakt.lista_ruchow[ angakt.nr_ruchu ];
  if (sprawdzaj_bezs) {
    int bezs = PoleBezs12(angpop.rozgr3, indeks, 1,   angakt.ktory_teraz);
    if (bezs) {
      TAnaliza::historia_sort[indeks] = bezs-1;  // wywal ruch na koniec lub calkowicie, gdy trwale bezs.
      return 0;  // nie wykonuj ruchu!
    }
  }
  if ((akt_gleb & 1)==0) angakt.hindeks|=0x4000;
  // czy jest sens robic ten ruch?
  if (upl_marg[indeks]==2) {
    // sprawdz, czy kropka kolo pola jest bezpieczna
    int nind;
    if (i==2) nind=indeks+wlky+4;
    else if (i>wlkx) nind=indeks-wlky-4;
    else if (j==2) nind=indeks+1;
    else nind=indeks-1;
    if (angpop.bandy.bezpieczne[nind]>=2) {
      TAnaliza::historia_sort[indeks]=1;  // wywal ruch na koniec, bo
      return 0;                           // nie ma sensu go wykonywac!
    }
  }
  // czy mozna zrobic ten ruch?
  if (angpop.rozgr3[indeks]==0) {  // mozna!
    int ile_zd=0, pow=0, pow2=0;
    angakt.byl_stop = angpop.byl_stop;
    if (CzyMozliwyStop(angpop.skl_tab, angpop.rozgr2, i,j,
		       angakt.ktory_teraz))  {
      angakt.plansz_p = angakt.tab_pp;
      angakt.rozgr2 = angakt.tab_r2;
      angakt.rozgr3 = angakt.tab_r3;
      KopiujTablice(angakt.plansz_p, angpop.plansz_p);
      KopiujTablice(angakt.rozgr2  , angpop.rozgr2);
      KopiujTablice(angakt.rozgr3  , angpop.rozgr3);
      int punktacja_ss;
      ZrobPanstwo(rozgrywka, NULL, angakt.rozgr2,angakt.rozgr3, angakt.plansz_p, i,j,
		  angakt.ktory_teraz, ile_zd,pow,pow2, punktacja_ss, 1);  // dla testu 1 !
      if (ile_zd || pow || pow2) {
	if (ile_zd)
	  { angakt.byl_stop=1;  angakt.hindeks |= 0x2000; }
	if (!(TAnaliza::gracz.umiejetnosci & 0x10))  // punktacja_ss (& 0x10) zamiast pow-pow2 (! & 0x10)
	  punktacja_ss = pow-pow2;
	{
	  int punkty = (ile_zd << 11) + (punktacja_ss<<10);
	  TAnaliza::historia_sort[indeks] += (punkty<10000) ? punkty : 10000;
	}
	angakt.zyski  = ((akt_gleb&1) ? TAnaliza::gracz.wagi_n.zd : TAnaliza::gracz.wagi_p.zd)*
	  (TAnaliza::gracz.waga_kropki*ile_zd + punktacja_ss)
	  + angpop.straty;
      }
      else
	angakt.zyski  = angpop.straty;
    }
    else {
      // nie ma stopu, zrob ruch ,,recznie''
      angakt.rozgr2 = angpop.rozgr2;
      angakt.rozgr2[indeks] = angakt.ktory_teraz;
      angakt.rozgr3 = angpop.rozgr3;
      angakt.rozgr3[indeks] = angakt.ktory_teraz;
      rozgrywka[indeks] = angakt.ktory_teraz;
      angakt.plansz_p = angpop.plansz_p;
      angakt.zyski  = angpop.straty;
    }
    // przepisz straty (zyski juz sa), ustaw oceny na MAXLONG
    angakt.straty    = angpop.zyski;
    angakt.ile_kr_zd_teraz = ile_zd;
    angakt.jest_stop_sstop = (ile_zd || pow);
    angakt.ocena     = MAXLONG;
#ifndef TEKSTOWY
    angakt.ost_gleb_max = akt_gleb;
#endif 
    // ustaw klucz
    angakt.htab_zobrist = (angpop.htab_zobrist ^ zobrist[angakt.hindeks]);
    angakt.htab_zobrist2 = (angpop.htab_zobrist2 ^ zobrist2[angakt.hindeks]);
    return 1;
  }
  else {
    TAnaliza::historia_sort[indeks]=0;  // wywal ruch na koniec (usun go), bo
    return 0;                           // nie da sie go wykonac
  }
}


void UstawKaryBMnasze(unsigned char *kary, TCiete &ciete, unsigned char *zakazane,
		      const unsigned char *r2, const unsigned char *r3, int ind, int kto, int przec)
// [ind] jest nasza, nieizolowana kropka
{
  if (upl_marg[ind]>=3) {
    if (r3[ind+1]==0) {
      if (r3[ind+wlky+4]==0 && r3[ind+wlky+5]==0 && (r3[ind-wlky-3]!=przec || r3[ind+wlky+3]!=przec)) {
	// naroznik PD
	if (kary[ind+wlky+5]==0) {
	  kary[ind+wlky+5]=1;  ciete.DodajOkrKropkeZOpozn(ind+wlky+5);
	}
	zakazane[ind+1] |= ZAKAZ_PG;      zakazane[ind+wlky+4] |= ZAKAZ_LD;
      }
      if (r3[ind-wlky-4]==0 && r3[ind-wlky-3]==0 && (r3[ind-wlky-5]!=przec || r3[ind+wlky+5]!=przec)) {
	// naroznik LD
	if (kary[ind-wlky-3]==0) {
	  kary[ind-wlky-3]=1;  ciete.DodajOkrKropkeZOpozn(ind-wlky-3);
	}
	zakazane[ind+1] |= ZAKAZ_LG;      zakazane[ind-wlky-4] |= ZAKAZ_PD;
      }
      if (kary[ind+1]==0) {
	kary[ind+1]=1;  ciete.DodajOkrKropkeZOpozn(ind+1);
      }
    }
    if (r3[ind-1]==0) {
      if (r3[ind+wlky+3]==0 && r3[ind+wlky+4]==0 && (r3[ind-wlky-5]!=przec || r3[ind+wlky+5]!=przec)) {
	// naroznik PG
	if (kary[ind+wlky+3]==0) {
	  kary[ind+wlky+3]=1;  ciete.DodajOkrKropkeZOpozn(ind+wlky+3);
	}
	zakazane[ind-1] |= ZAKAZ_PD;      zakazane[ind+wlky+4] |= ZAKAZ_LG;
      }
      if (r3[ind-wlky-5]==0 && r3[ind-wlky-4]==0 && (r3[ind-wlky-3]!=przec || r3[ind+wlky+3]!=przec)) {
	// naroznik LG
	if (kary[ind-wlky-5]==0) {
	  kary[ind-wlky-5]=1;  ciete.DodajOkrKropkeZOpozn(ind-wlky-5);
	}
	zakazane[ind-1] |= ZAKAZ_LD;      zakazane[ind-wlky-4] |= ZAKAZ_PG;
      }
      if (kary[ind-1]==0) {
	kary[ind-1]=1;  ciete.DodajOkrKropkeZOpozn(ind-1);
      }
    }
    if (r3[ind-wlky-4]==0 && kary[ind-wlky-4]==0)
      { kary[ind-wlky-4]=1;  ciete.DodajOkrKropkeZOpozn(ind-wlky-4); }
    if (r3[ind+wlky+4]==0 && kary[ind+wlky+4]==0)
      {	kary[ind+wlky+4]=1;  ciete.DodajOkrKropkeZOpozn(ind+wlky+4); }
  }
}

void UstawKaryBM(unsigned char *kary, TCiete &ciete, unsigned char *zakazane,
		 const unsigned char *r2, const unsigned char *r3, 
		 int kto,
		 TDwaUC marg3_min, TDwaUC marg3_max)
// we: r2,r3 -- plansze z rozgrywka (rozgr2, rozgr3 odpowiednio)
//              nie niszczy tych tablic!!!
//              Uwaga: zamiast r2 mozna podac r3, ale wtedy dziala wolniej!
//     (TAnaliza::gracz.testowe & 1) -- redukcja kar kolo mostkow przec
//     (TAnaliza::gracz.testowe & 2) -- wykrywanie hurraoptymistycznych atakow (antyweze) - ZMIENIONE W 83.30 !
//     (TAnaliza::gracz.testowe & 4) -- izolowane kropki tez generuja kary (choc mniejsze)
//     marg3_min, _max -- jaka czesc planszy nalezy obejsc
//                 NIE ZERUJE TABLICY kary NIGDZIE!
//                 Dlatego nalezy wyczyscic kary[] przed wolaniem tej funkcji.
//                 Moze dodac kary w promieniu 1 lub 2 pol od podanego marginesu.
// Funkcja jest ,,lokalna'' w tym sensie, ze jesli dodano kropke na polu (x,y),
// to wystarczy wyczyscic kary[] w kwadracie [x-1,x+1] x [y-1,y+1] i wywolac
// te funkcje w (nieco wiekszym!) kwadracie [x-2,x+2] x [y-2,y+2].
// Dodaje tez kropki do ciete.
// Dodaje rowniez kierunki zakazane.
// Czyszczenie tych kierunkow: po wykonaniu ruchu przec w obszarze [x-2,x+2]x[y-2,y+2].
// (W naszej sytuacji niepotrzebne, bo jako ostatni ruch wykonuje zawsze ,,kto'').
//
// ,,BM'' w nazwie jest skrotem od ,,bez mostkow'' (nazwa nowej f. oceniajacej).
//
// kary: ==0 puste pole bez kary
//       ==1 puste pole, kara +1
//       ==2 puste pole, kara +2  (aktualnie nieuzywane)
//       ==3 kropka przec bez kary
//       ==4 kropka przec, kara +1
//       ==5 pole wewnatrz stopu lub nasza kropka
{
 STOPER_START_KARY;
 int przec=3-kto;
 krint *pola_bez_kary = skladowe.PrzydzielSkladowa();
 int ile_pol_bez_kary=0;
 ciete.RozpocznijDodawanieZOpozn();
 for (int i=marg3_min.x; i<=marg3_max.x; i++)
  {
  unsigned int ind = WezIndeksTab(i,marg3_min.y);
  for (int j=marg3_min.y; j<=marg3_max.y; j++)
    {
      if (r2[ind]==kto) {

	if ( (r3[ind-1]==kto || r3[ind+1]==kto || r3[ind-wlky-4]==kto || r3[ind+wlky+4]==kto)
	     ||
	     // tutaj: nie ma sasiadow z boku!
	     ((r3[ind-wlky-5]==kto || r3[ind-wlky-3]==kto ||        // sa sasiedzi na ukos
	       r3[ind+wlky+3]==kto || r3[ind+wlky+5]==kto) &&       // (kropka nie jest izolowana)
	      ((TAnaliza::gracz.testowe & 2)==0 ||
	       (r3[ind-1]==przec)+(r3[ind+1]==przec)+(r3[ind-wlky-4]==przec)+(r3[ind+wlky+4]==przec) < 2)))
	  UstawKaryBMnasze(kary, ciete, zakazane, r2, r3, ind, kto, przec);
	else if ((TAnaliza::gracz.testowe & 4) && 
		 upl_marg[ind]>=3) {   // izolowana kropka nie kolo bandy
	  if (r3[ind-wlky-4]==0 && kary[ind-wlky-4]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind-wlky-4); kary[ind-wlky-4]=1; }
	  if (r3[ind+wlky+4]==0 && kary[ind+wlky+4]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind+wlky+4); kary[ind+wlky+4]=1; }
	  if (r3[ind-1]==0 && kary[ind-1]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind-1); kary[ind-1]=1; }
	  if (r3[ind+1]==0 && kary[ind+1]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind+1); kary[ind+1]=1; }
	}

	kary[ind]=5;  // nasze kropki ustaw na 5 -- przeciwnik ich nie przechodzi
      }
      else if (r2[ind]==przec)
	{ if (kary[ind]==0) kary[ind]=3; }
      else if (r3[ind])  // tutaj r2[ind]==0, czyli jestesmy wewn. stopu
	kary[ind]=5;
      else   // tutaj wolne pole 
	if (TAnaliza::gracz.testowe & 1) { 
	  if ((r3[ind-wlky-4] & r3[ind-wlky-3] & przec) &&
	      (r3[ind+wlky+4] & r3[ind+wlky+5] & przec) &&
	      //	      r3[ind+1]!=przec)   // dolne mostki
	      r3[ind+1]==0)   // dolne mostki
	    pola_bez_kary[ile_pol_bez_kary++]=ind;
	  else
	    if ((r3[ind-wlky-4] & r3[ind-wlky-5] & przec) &&
		(r3[ind+wlky+4] & r3[ind+wlky+3] & przec) &&
		//	      r3[ind-1]!=przec)   // gorne mostki
		r3[ind-1]==0)   // gorne mostki
	      pola_bez_kary[ile_pol_bez_kary++]=ind;
	    else
	      if ((r3[ind-wlky-5] & r3[ind-1] & przec) &&
		  (r3[ind-wlky-3] & r3[ind+1] & przec) &&
		  //	      r3[ind-wlky-4]!=przec)   // lewe mostki
		  r3[ind-wlky-4]==0)   // lewe mostki
		pola_bez_kary[ile_pol_bez_kary++]=ind;
	      else
		if ((r3[ind+wlky+3] & r3[ind-1] & przec) &&
		    (r3[ind+wlky+5] & r3[ind+1] & przec) &&
		    //	      r3[ind+wlky+4]!=przec)   // prawe mostki
		    r3[ind+wlky+4]==0)   // prawe mostki
		  pola_bez_kary[ile_pol_bez_kary++]=ind;
	}
      ind++;
    }
  }
 if (TAnaliza::gracz.testowe & 1)
 for (int i=0; i<ile_pol_bez_kary; i++)
   if (kary[pola_bez_kary[i]]) kary[pola_bez_kary[i]]--;
 // for (int i=0; i<ile_pol_bez_kary; i++)
 //   kary[pola_bez_kary[i]]=0;
 skladowe.ZwolnijSkladowa(pola_bez_kary);
 ciete.UaktualnijCiecia();
 STOPER_STOP_KARY;
}



struct TPoziom {     // ta klasa zawiera zmienne sluzace do oceny JEDNEGO z graczy
  unsigned char *zakazane;
  krint         *dod_pola;
  krint         *mostki;  
  unsigned char *kary;
  TCiete        ciete;
  long int      *oceny_skladowych;
  //  krint         *sklnr;
  int           ile_sklnr, ile_sklnr_p;
  long int      ocena;           // ocena!=MAXLONG : byc moze tablice powyzej
  unsigned long long    zobr;    //   zawieraja aktualna informacje (trzeba jeszcze por. zobr)
  // zmienne optymalizacyjne (na gleb o 1 mniejszej)
  unsigned char *zakazane_p; 
  krint         *dod_pola_p;
  krint         *mostki_p;  
  unsigned char *kary_p;
  TCiete        ciete_p;
  int           sa_mostki, sa_zakazane, sa_kary, sa_oceny;         // czy tablice *..._p
  unsigned long long    zobr_p;                                    //   zawieraja aktualna informacje
  // pomocnicze:
  //  krint         *straty_skl;
  krint         *goradol, *goradol_p, *straty_skl_p, *dlugosci_p, *sciezki_p;
  //
  void Ocen(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  void OcenBM(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  void OcenBMsciezki(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza* ang1, int preferuj_sc);
  long int WezPoprawkeNaSklPop(unsigned char *rozgr3, int kto);
  void PrzydzielPamiec();    // przy okazji inicjuje obiekt
  void ZwolnijPamiec();
};


void TPoziom::PrzydzielPamiec()
{
  oceny_skladowych  = tabliceLI.Przydziel();
  zakazane = plansze.PrzydzielPlansze();
  dod_pola = skladowe.PrzydzielSkladowa();
  mostki   = skladowe.PrzydzielSkladowa();
  //  sklnr    = skladowe.PrzydzielSkladowa();
  ocena    = MAXLONG;
  zakazane_p = plansze.PrzydzielPlansze();
  dod_pola_p = skladowe.PrzydzielSkladowa();
  mostki_p   = skladowe.PrzydzielSkladowa();
  sa_mostki = 0;  sa_zakazane=0;  sa_kary=0;
  //  straty_skl = skladowe.PrzydzielSkladowa();
  goradol    = skladowe.PrzydzielSkladowa();
  // na ...BM nie przydzielamy pamieci, bo BM nie korzysta z dod_pola (ani mostki)
  kary   = (unsigned char*) dod_pola;
  kary_p = (unsigned char*) dod_pola_p;
  goradol_p = skladowe.PrzydzielSkladowa();
  straty_skl_p = skladowe.PrzydzielSkladowa();
  dlugosci_p = skladowe.PrzydzielSkladowa();
  sciezki_p = skladowe.PrzydzielSkladowa();
}
void TPoziom::ZwolnijPamiec()
{
  tabliceLI.Zwolnij(oceny_skladowych);
  plansze.ZwolnijPlansze(zakazane);
  skladowe.ZwolnijSkladowa(dod_pola);
  skladowe.ZwolnijSkladowa(mostki);
  //  skladowe.ZwolnijSkladowa(sklnr);
// i optymalizacyjne:
  plansze.ZwolnijPlansze(zakazane_p);
  skladowe.ZwolnijSkladowa(dod_pola_p);
  skladowe.ZwolnijSkladowa(mostki_p);
// pomocnicze:
  //  skladowe.ZwolnijSkladowa(straty_skl);
  skladowe.ZwolnijSkladowa(goradol);
  skladowe.ZwolnijSkladowa(goradol_p);
  skladowe.ZwolnijSkladowa(straty_skl_p);
  skladowe.ZwolnijSkladowa(dlugosci_p);
  skladowe.ZwolnijSkladowa(sciezki_p);
}

void TPoziom::Ocen(unsigned char *rozgrywka,
		   TAnaliza& ang0, TAnaliza const* ang1)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL)
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    STOPER_START_SSTO;
    CzyscTablice(zakazane);
    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
    //    UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
    //		    ang0.ktory_teraz,  ang0.marg0_min, ang0.marg0_max);
    ile_sklnr = 
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0; STOPER_STOP_SSTO; goto Zwolnij_pamiec; }
    // wypelnij mostki od poczatku
    CzyscTablice(mostki);
    ZnajdzMostki12(mostki, ang0.rozgr2, ang0.rozgr3,
		   ang0.marg0_min, ang0.marg0_max,
		   3-ang0.ktory_teraz);
    CzyscTablice(dod_pola);
    if (TAnaliza::gracz.umiejetnosci & 0x20)
      Antyweze(zakazane, dod_pola, ang0.rozgr3, 3-ang0.ktory_teraz,
	       ang0.marg0_min, ang0.marg0_max);
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj zakazanych z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobrist2)  // czy sa mostki w poprzednim ruchu?
	{ 
        STOPER_START_POPR;
	sa_zakazane=1;   // nie ma, wiec je znajdz
	sa_mostki=0;
	zobr_p=ang1->htab_zobrist2;
	CzyscTablice(zakazane_p);
	CzyscTablice(dod_pola_p);
	// usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	// moga byc wspolne dla roznych glebokosci
	ang0.rozgr2[ ang0.indeks ]=0;
	ang0.rozgr3[ ang0.indeks ]=0;

	ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
//  	UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
//  			ang0.ktory_teraz,  // nie ang1 !
//  			ang1->marg0_min, ang1->marg0_max);

	if (TAnaliza::gracz.umiejetnosci & 0x20)        // to tutaj potrzebne, bo ma wplyw na zakazane
	  Antyweze(zakazane_p, dod_pola_p, ang1->rozgr3,
		   ang1->ktory_teraz,         // nie 3-ktory_gracz!
		   ang1->marg0_min, ang1->marg0_max);
	// odtworz kropki
	ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
        STOPER_STOP_POPR;
	}
      KopiujTablice(zakazane, zakazane_p);
      KopiujTablice(dod_pola, dod_pola_p);   // to potrzebne, bo czyscimy ...WProstokacie().
      TDwaUC marg_most_min, marg_most_max;
      marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
      marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
      marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
      marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      CzyscZakazaneWProstokacie(zakazane, dod_pola, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);
      // Tu nie trzeba antywezy, pomimo ze one wplywaja na zakazane (bo ten wplyw nie
      // ma znaczenia dla ZnajdzRobakiMatki()).
      ile_sklnr = 
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec; }
      // trzeba jednak ustawic mostki...
      if (!sa_mostki)
	{ 
        STOPER_START_POPR;
	sa_mostki=1;   // nie ma, wiec je znajdz
	//zobr_p=ang1->htab_zobrist2;   // ta rownosc musi zachodzic
	CzyscTablice(mostki_p);
	// usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	// moga byc wspolne dla roznych glebokosci
	ang0.rozgr2[ ang0.indeks ]=0;
	ang0.rozgr3[ ang0.indeks ]=0;
	ZnajdzMostki12(mostki_p, ang1->rozgr2, ang1->rozgr3,
		       ang1->marg0_min, ang1->marg0_max,
		       ang1->ktory_teraz);  // nie 3-ktory_gracz!
	// odtworz kropki
	ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
        STOPER_STOP_POPR;
	}
      KopiujTablice(mostki, mostki_p);
      ZnajdzMostki12(mostki, ang0.rozgr2, ang0.rozgr3,
		     marg_most_min, marg_most_max,
		     3-ang0.ktory_teraz);
      if (TAnaliza::gracz.umiejetnosci & 0x20)
	Antyweze(zakazane, dod_pola, ang0.rozgr3, 3-ang0.ktory_teraz,
		 marg_most_min, marg_most_max);
    }      
  ocena = 
    OcenSkladowe12(ang0.rozgr2, ang0.rozgr3,
		   goradol, straty_skl, oceny_skladowych,
		   ile_sklnr, zakazane, mostki,
		   ang0.ktory_teraz,
		   ang0.ciete[ang0.ktory_teraz-1],
		   dod_pola, TAnaliza::gracz.funkcja_sk, TAnaliza::gracz.waga_kropki);
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobrist2;
}

long int TPoziom::WezPoprawkeNaSklPop(unsigned char *rozgr3, int kto)
// kto = kogo ocenialismy (1 lub 2)
{
  long int pop=0;
  for (int i=0; i<ile_sklnr; i++) {
    int gora = goradol[i];
    if (gora && rozgr3[gora]!=kto) pop += oceny_skladowych[i];
    }
  return pop;
}

void TPoziom::OcenBM(unsigned char *rozgrywka,
		     TAnaliza& ang0, TAnaliza const* ang1)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL)
// BM to skrot od ,,bez mostkow''
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    // wypelnij wszystko od poczatku
    STOPER_START_SSTO;
    CzyscTablice(zakazane);

    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
//      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
//  		    ang0.ktory_teraz,
//  		    ang0.marg0_min, ang0.marg0_max);

    ile_sklnr=
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0; STOPER_STOP_SSTO;  goto Zwolnij_pamiec; }
    CzyscTablice(kary);
    //memcpy(&ciete, &ang0.ciete[ang0.ktory_teraz-1], sizeof(ciete));
    ciete.Skopiuj(ang0.ciete[ang0.ktory_teraz-1]);
    UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz,
		ang0.marg0_min, ang0.marg0_max);
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj tablic z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobrist2)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_zakazane=1;   // nie ma, wiec je znajdz
  	  sa_kary=0;  sa_oceny=0;
	  zobr_p=ang1->htab_zobrist2;
	  CzyscTablice(zakazane_p);
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  ang0.rozgr2[ ang0.indeks ]=0;
	  ang0.rozgr3[ ang0.indeks ]=0;

	  ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
//  	  UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
//  			  ang0.ktory_teraz,  // nie ang1 !
//  			  ang1->marg0_min, ang1->marg0_max);

	  // odtworz kropki
	  ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	  ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(zakazane, zakazane_p);
      TDwaUC marg_most_min, marg_most_max;
      /*
      if (TAnaliza::gracz.testowe & 3) {  // testowy antywaz   Wydaje sie, ze & 1 jest zupelnie niepotrzebne (83.28-83.30)
	marg_most_min.x = (ang0.x <=6) ? 2 : ang0.x-4;
	marg_most_min.y = (ang0.y <=6) ? 2 : ang0.y-4;
	marg_most_max.x = (ang0.x >=wlkx-3) ? wlkx+1 : ang0.x+4;
	marg_most_max.y = (ang0.y >=wlky-3) ? wlky+1 : ang0.y+4;
      }
      else */
      {
	marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
	marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
	marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
	marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      }
      // mozna by napisac funkcje do czyszczenia zakazanych specjalnie dla BM, teraz trzeba 
      // wpisywac bezsensowne ,,mostki''
      CzyscZakazaneWProstokacie(zakazane, mostki, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);
      ile_sklnr=
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec; }
      // trzeba jednak ustawic kary...
      if (!sa_kary)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_kary=1;   // nie ma, wiec je znajdz
	  //zobr_p=ang1->htab_zobrist2;   // tutaj juz musi byc rownosc
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  ang0.rozgr2[ ang0.indeks ]=0;
	  ang0.rozgr3[ ang0.indeks ]=0;
	  //memcpy(&ciete_p, &(ang1->ciete[ang0.ktory_teraz-1]), sizeof(ciete_p));
	  ciete_p.Skopiuj(ang1->ciete[ang0.ktory_teraz-1]);
	  CzyscTablice(kary_p);
	  UstawKaryBM(kary_p, ciete_p, zakazane_p, ang1->rozgr2, ang1->rozgr3, ang0.ktory_teraz,
		      ang1->marg0_min, ang1->marg0_max);   // bylo poczatkowo DodajPolaBM()...
	  // odtworz kropki
	  ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	  ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(kary, kary_p);
      //memcpy(&ciete, &ciete_p, sizeof(ciete));
      ciete.Skopiuj(ciete_p);
      ciete.DodajKropke(ang0.x, ang0.y, 1);
      /*
      if (TAnaliza::gracz.testowe & 2) {  // testowy antywaz   Chyba & 3, gdy powyzej tez & 3...
	// wyczysc kary w kwadracie 5x5 wokol akt. kropki
	int indeks0 = ang0.indeks-2*wlky-8;
	for (int i=0; i<5; i++) {
	  for (int j=-2; j<=2; j++)
	    kary[indeks0+j] = 0;
	  indeks0 += wlky+4;
	}
      }
      else */
      {
	// wyczysc kary w kwadracie 3x3 wokol akt. kropki
	for (int i=-wlky-4; i<=wlky+4; i+=wlky+4)
	  for (int j=-1; j<=1; j++)
	    kary[ang0.indeks+i+j] = 0;
      }
      UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz, 
		  marg_most_min, marg_most_max);
    }
  for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=MAXLONG;
  ocena = (TAnaliza::gracz.funkcja_sk==4) ?
    OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		   goradol, straty_skl, oceny_skladowych,
		   ile_sklnr, zakazane, 
		   ang0.ktory_teraz,
		   ciete, kary)
    :
    OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, oceny_skladowych, NULL, NULL,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobrist2;
}

void TPoziom::OcenBMsciezki(unsigned char *rozgrywka,
			    TAnaliza& ang0, TAnaliza* ang1, int preferuj_sc)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL); nie jest const z uwagi na uakt. robaki
// BM to skrot od ,,bez mostkow''
// preferuj_sc = 0 lub 1; gdy 1, to raczej znajdujemy sciezki
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    // wypelnij wszystko od poczatku
    STOPER_START_SSTO;
    CzyscTablice(zakazane);

    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
//      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
//  		    ang0.ktory_teraz,
//  		    ang0.marg0_min, ang0.marg0_max);

    ile_sklnr=
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0;  STOPER_STOP_SSTO;  goto Zwolnij_pamiec; }
    CzyscTablice(kary);
    //memcpy(&ciete, &ang0.ciete[ang0.ktory_teraz-1], sizeof(ciete));
    ciete.Skopiuj(ang0.ciete[ang0.ktory_teraz-1]);
    UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz,
		ang0.marg0_min, ang0.marg0_max);
    for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=MAXLONG;
    ocena = (TAnaliza::gracz.funkcja_sk==4) ?
      OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		     goradol, straty_skl, oceny_skladowych,
		     ile_sklnr, zakazane, 
		     ang0.ktory_teraz,
		     ciete, kary)
      :
      OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
			 goradol, straty_skl, oceny_skladowych, NULL, NULL,
			 ile_sklnr, zakazane, 
			 ang0.ktory_teraz,
			 ciete, kary);      
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj tablic z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobrist2)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_zakazane=1;   // nie ma, wiec je znajdz
	  sa_kary=0;   sa_oceny=0;
	  zobr_p=ang1->htab_zobrist2;
	  CzyscTablice(zakazane_p);
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  ang0.rozgr2[ ang0.indeks ]=0;
	  ang0.rozgr3[ ang0.indeks ]=0;

	  ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
//  	  UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
//  			  ang0.ktory_teraz,  // nie ang1 !
//  			  ang1->marg0_min, ang1->marg0_max);

	  // odtworz kropki
	  ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	  ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(zakazane, zakazane_p);
      TDwaUC marg_most_min, marg_most_max;
      /*
      if (TAnaliza::gracz.testowe & 3) {  // testowy antywaz   Wydaje sie, ze & 1 jest zupelnie niepotrzebne (83.28-83.30)
	marg_most_min.x = (ang0.x <=6) ? 2 : ang0.x-4;
	marg_most_min.y = (ang0.y <=6) ? 2 : ang0.y-4;
	marg_most_max.x = (ang0.x >=wlkx-3) ? wlkx+1 : ang0.x+4;
	marg_most_max.y = (ang0.y >=wlky-3) ? wlky+1 : ang0.y+4;
      }
      else */
      {
	marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
	marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
	marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
	marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      }
      // mozna by napisac funkcje do czyszczenia zakazanych specjalnie dla BM, teraz trzeba 
      // wpisywac bezsensowne ,,mostki''
      CzyscZakazaneWProstokacie(zakazane, mostki, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);

      krint *polaczony_z, *dolne_m;
      polaczony_z   = skladowe.PrzydzielSkladowa();
      dolne_m       = skladowe.PrzydzielSkladowa();
      ile_sklnr=
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.rozgr3, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl,
							  polaczony_z, dolne_m);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec_1; }
      // trzeba jednak ustawic kary i oceny...
      if (!sa_kary)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_kary=1;   // nie ma, wiec je znajdz
	  //zobr_p=ang1->htab_zobrist2;   // tutaj juz musi byc rownosc
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  ang0.rozgr2[ ang0.indeks ]=0;
	  ang0.rozgr3[ ang0.indeks ]=0;
	  //memcpy(&ciete_p, &(ang1->ciete[ang0.ktory_teraz-1]), sizeof(ciete_p));
	  ciete_p.Skopiuj(ang1->ciete[ang0.ktory_teraz-1]);
	  CzyscTablice(kary_p);
	  UstawKaryBM(kary_p, ciete_p, zakazane_p, ang1->rozgr2, ang1->rozgr3, ang0.ktory_teraz,
		      ang1->marg0_min, ang1->marg0_max);   // bylo poczatkowo DodajPolaBM()...
	  /*
	  int ile_na_ost;   // ile nowych robakow na ost. gleb. (0 lub 1)
	  {
	    int aktr = ang0.robaki[ang0.ktory_teraz-1].robaki[ang0.indeks];
	    ile_na_ost= (polaczony_z[aktr]!=aktr);   // jesli aktualna kropka nie tworzy nowego robaka-matki
	  }
	  if (ile_sklnr-ile_na_ost + preferuj_sc>=2) 
	  */
	  STOPER_STOP_POPR;    // tutaj stop, bo sciezek i tak nie mozna by znajdowac na 2 gleb. przed ostatnia
	  {
	    ang0.robaki[ang0.ktory_teraz-1].UsunKropke();	  
	    ile_sklnr_p=
	      ang1->robaki[ang0.ktory_teraz-1
	        ].ZnajdzRobakiMatki(ang1->rozgr3, zakazane_p, ang1->bandy.bezpieczne,
				    ang1->marg0_min, ang1->marg0_max,
				    goradol_p, straty_skl_p);
	    ang0.robaki[ang0.ktory_teraz-1].OdtworzKropke();	  
	    if (preferuj_sc+ile_sklnr_p>=2) {
	      sa_oceny=1;
	      if (TAnaliza::gracz.funkcja_sk==4)
		OcenSkladoweBMsciezki(ang1->rozgr2, ang1->rozgr3,
				      goradol_p, straty_skl_p,
				      dlugosci_p, sciezki_p,
				      ile_sklnr_p,
				      zakazane_p, 
				      ang0.ktory_teraz,
				      ciete_p, kary_p);
	      else
		OcenSkladoweBMkaty(ang1->rozgr2, ang1->rozgr3,
				   goradol_p, straty_skl_p,
				   NULL, dlugosci_p, sciezki_p,
				   ile_sklnr_p,
				   zakazane_p, 
				   ang0.ktory_teraz,
				   ciete_p, kary_p);
	    }
	  }
	  // odtworz kropki
	  ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
	  ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
	}
      KopiujTablice(kary, kary_p);
      //memcpy(&ciete, &ciete_p, sizeof(ciete));
      ciete.Skopiuj(ciete_p);
      ciete.DodajKropke(ang0.x, ang0.y, 1);
      /*
      if (TAnaliza::gracz.testowe & 2) {  // testowy antywaz   Chyba & 3, gdy powyzej tez & 3...
	// wyczysc kary w kwadracie 5x5 wokol akt. kropki
	int indeks0 = ang0.indeks-2*wlky-8;
	for (int i=0; i<5; i++) {
	  for (int j=-2; j<=2; j++)
	    kary[indeks0+j] = 0;
	  indeks0 += wlky+4;
	}
      }
      else
      */
      {
	// wyczysc kary w kwadracie 3x3 wokol akt. kropki
	for (int i=-wlky-4; i<=wlky+4; i+=wlky+4)
	  for (int j=-1; j<=1; j++)
	    kary[ang0.indeks+i+j] = 0;
      }
      UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz, 
		  marg_most_min, marg_most_max);
      for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=MAXLONG;
      if (sa_oceny) {
	// zaznacz zmienione sciezki
	int zmienione=0;
	{	
	  int indeks0 = ang0.indeks-2*wlky-8;
	  for (int i=0; i<5; i++) {
	    for (int j=-2; j<=2; j++)
	      if (kary[indeks0+j]!=kary_p[indeks0+j])
		zmienione |= sciezki_p[indeks0+j];
	      else {
		int doszly = zakazane[indeks0+j] & ~zakazane_p[indeks0+j];
		if (doszly) {
		  if (doszly & ZAKAZ_LG)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j-wlky-5]);
		  if (doszly & ZAKAZ_PG)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j+wlky+3]);
		  if (doszly & ZAKAZ_LD)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j-wlky-3]);
		  if (doszly & ZAKAZ_PD)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j+wlky+5]);
		}
	      }
	    indeks0 += wlky+4;
	  }
        }
	// teraz przepisz nie zmienione dlugosci
	int maska=0x8000;
	for (int i=0; i<ile_sklnr_p; i++) {
	  if ((maska<<=1)==0x10000) maska=1;
	  if ((zmienione & maska)==0) {
	    int kr = goradol_p[i];
	    if (kr==0) continue;
	    int nkr = dolne_m[polaczony_z[ang0.robaki[ang0.ktory_teraz-1].robaki[kr]]];
	    for (int j=0; j<ile_sklnr; j++)
	      if (goradol[j]==nkr) { 
		oceny_skladowych[j]=OcenSkladowaBM(straty_skl[j], dlugosci_p[i], TAnaliza::gracz.funkcja_sk);
	      break;
	      }
	  }
	}
      }

      ocena = (TAnaliza::gracz.funkcja_sk==4) ?
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, oceny_skladowych,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary)
	:
	OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
			   goradol, straty_skl, oceny_skladowych, NULL, NULL,
			   ile_sklnr, zakazane, 
			   ang0.ktory_teraz,
			   ciete, kary);

      /*
      {
      long int *test = tabliceLI.Przydziel();
      for (int i=0; i<ile_sklnr; i++) test[i]=MAXLONG;
      long int ocena_test = 
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, test,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);
      for (int i=0; i<ile_sklnr; i++)
	if (test[i]!=oceny_skladowych[i]) {
	  printf("Jest %ld, powinno byc %ld.",oceny_skladowych[i], test[i]);
	  if (test[i]==0 || oceny_skladowych==0)
	    printf(" POWAZNY BLAD!\n");
	  else printf("\n");
	}

      for (int i=0; i<ile_sklnr; i++) test[i]=MAXLONG;
      ocena_test = 
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, test,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);

      tabliceLI.Zwolnij(test);
      }
      */

    Zwolnij_pamiec_1:;
      skladowe.ZwolnijSkladowa(polaczony_z);
      skladowe.ZwolnijSkladowa(dolne_m);
    }
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobrist2;
}


class TOcenaLFO {
  signed char *punkty;
  int ocena_p, jest_ocena;
  static signed char tabocen[256];
  unsigned long long    zobr;
  inline signed char OcenPole(const unsigned char *rozgr3, int indeks);
  void  UstawPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max);
  int  ObliczPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max);
public:
  void Przydziel();
  void Zwolnij();
  void Zeruj() { jest_ocena=0; };
  long int Ocen(const TAnaliza& ang0, const TAnaliza* ang1);
};

signed char TOcenaLFO::tabocen[256] = {
 0, 1,-1, 0,  1, 2, 0, 0, -1, 0,-2, 0,  0, 0, 0, 0,
 1, 2, 0, 0,  2, 5, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
-1, 0,-2, 0,  0, 0,-1, 0, -2, 0,-5, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 1, 2, 0, 0,  2, 5, 1, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 2, 5, 0, 0,  5, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0,-1, 0,  1, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
-1, 0,-2, 0,  0, 0, 0, 0, -2,-1,-5, 0,  0, 0, 0, 0,
 0, 1, 0, 0,  0, 0, 0, 0, -1, 0, 0, 0,  0, 0, 0, 0,
-2, 0,-5, 0,  0, 0, 0, 0, -5, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
};

  
inline signed char TOcenaLFO::OcenPole(const unsigned char *rozgr3, int indeks)
{
  if (rozgr3[indeks]==0) {
    int nr = (int(rozgr3[indeks-1]) << 6) | (rozgr3[indeks+wlky+4] << 4) | (rozgr3[indeks+1] << 2) | rozgr3[indeks-wlky-4];
    return tabocen[nr];
  }
  else return 0;
}

void  TOcenaLFO::UstawPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max)
{
  if (marg_min.x>=3) marg_min.x--;
  if (marg_min.y>=3) marg_min.y--;
  if (marg_max.x<=wlkx) marg_max.x++;
  if (marg_max.y<=wlky) marg_max.y++;
  CzyscTablice((unsigned char*) punkty);
  ocena_p=0;
  for (int i=marg_min.x; i<=marg_max.x; i++) {
    unsigned int ind = WezIndeksTab(i, marg_min.y);
    for (int j=marg_min.y; j<=marg_max.y; j++) {
      ocena_p += punkty[ind] = OcenPole(rozgr3, ind);
      ind++;
    }
  }
}

int  TOcenaLFO::ObliczPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max)
{
  if (marg_min.x>=3) marg_min.x--;
  if (marg_min.y>=3) marg_min.y--;
  if (marg_max.x<=wlkx) marg_max.x++;
  if (marg_max.y<=wlky) marg_max.y++;
  int ocena=0;
  for (int i=marg_min.x; i<=marg_max.x; i++) {
    unsigned int ind = WezIndeksTab(i, marg_min.y);
    for (int j=marg_min.y; j<=marg_max.y; j++) {
      ocena += OcenPole(rozgr3, ind);
      ind++;
    }
  }
  return ocena;
}


void TOcenaLFO::Przydziel()
{  punkty = (signed char*) plansze.PrzydzielPlansze(); }

void TOcenaLFO::Zwolnij()
{  plansze.ZwolnijPlansze((unsigned char*) punkty); }

long int TOcenaLFO::Ocen(const TAnaliza& ang0, const TAnaliza* ang1)
{
  long int ocena;
  if (ang1==NULL || ang0.jest_stop_sstop)
    ocena = ObliczPunkty(ang0.rozgr3, ang0.marg0_min, ang0.marg0_max);
  else {
    if (!jest_ocena || zobr!=ang1->htab_zobrist2)  // czy jest ocena w poprzednim ruchu?
      { jest_ocena=1;   // nie ma, wiec ja znajdz
	zobr=ang1->htab_zobrist2;
	UstawPunkty(ang1->rozgr3, ang1->marg0_min, ang1->marg0_max);
      }
    unsigned int ind = ang0.indeks;
    ocena = ocena_p - (punkty[ind-wlky-4] + punkty[ind-1] + punkty[ind] + punkty[ind+1] + punkty[ind+wlky+4])
      + int(OcenPole(ang0.rozgr3, ind-wlky-4)) + int(OcenPole(ang0.rozgr3, ind-1))
      + int(OcenPole(ang0.rozgr3, ind+1))      + int(OcenPole(ang0.rozgr3, ind+wlky+4));
  }
  return (ang0.ktory_teraz==1) ? ocena : -ocena;
}


class TOcenaSkl12 {
  TPoziom poz[2];   // poc[0]: oceny na [ost], poc[1]: oceny na [ost-1]
  TOcenaLFO ocenalfo;
public:
  long int OcenPozycje12(unsigned char *rozgrywka, int ostatni_to_ja, 
			 TAnaliza& ang0, TAnaliza& ang1, TAnaliza *ang2, int sciezki);
  long int OcenPozycje12TylkoTaGleb(unsigned char *rozgrywka, int ostatni_to_ja, 
				    TAnaliza& ang0, const TAnaliza& ang1);
  void PrzydzielPamiec();
  void Zeruj();
  void ZwolnijPamiec();
}
osk12;

void TOcenaSkl12::PrzydzielPamiec()
{
  poz[0].PrzydzielPamiec();
  poz[1].PrzydzielPamiec();
  ocenalfo.Przydziel();
}
void TOcenaSkl12::ZwolnijPamiec()
{
  poz[0].ZwolnijPamiec();
  poz[1].ZwolnijPamiec();
  ocenalfo.Zwolnij();
}
void TOcenaSkl12::Zeruj()
{ poz[0].ocena = MAXLONG;  poz[1].ocena = MAXLONG;
  poz[0].sa_mostki=0;      poz[1].sa_mostki=0; 
  poz[0].sa_zakazane=0;    poz[1].sa_zakazane=0;   
  poz[0].sa_kary=0;        poz[1].sa_kary=0;
  ocenalfo.Zeruj();
} 


long int TOcenaSkl12::OcenPozycje12(unsigned char *rozgrywka, int ostatni_to_ja, 
				    TAnaliza& ang0, TAnaliza& ang1, TAnaliza* ang2,
				    int sciezki)
// ang0: ostatnia gleb, ang1: przedostatnia, ang2: przed-przedostatnia
// Moze byc ang2==NULL, co oznacza, ze jestesmy na glebokosci 1.
// Zmienna ostatni_to_ja mowi, czy ostatnim graczem jest ten, dla ktorego analizujemy,
// czyli ang[1].ktory_teraz; ostatni_to_ja == (akt_gleb & 1), gdzie akt_gleb to gleb. oceny;
// lub ostatni_to_ja == (ang[akt_gleb].ktory_teraz == ang[1].ktory_teraz).
// sciezki: -1 -> nie uzywaj w ogole OcenBMsciezki(),
//           0 -> uzywaj OcenBMsciezki(), ale nie znajduj sciezek, gdy malo skladowych
//           1 -> uzywaj OcenBMsciezki(); nie bedzie ciecia beta, wiec raczej znajdz sciezki
{ 
  long int ocena_Bo;
  if (TAnaliza::gracz.Bouzy_dil) {
    if (ang[0].ktory_teraz==2) {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_n.Bo, TAnaliza::gracz.wagi_p.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (!ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
    else {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_p.Bo, TAnaliza::gracz.wagi_n.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
  }
  else ocena_Bo=0;
  if (TAnaliza::gracz.waga_latwe_pole)
    ocena_Bo += int(TAnaliza::gracz.waga_latwe_pole) * ocenalfo.Ocen(ang0, &ang1);
  if (TAnaliza::gracz.funkcja_sk) {
  // wez ocene skladowych drugiego gracza
  if (poz[1].ocena == MAXLONG || poz[1].zobr!=ang1.htab_zobrist2) {
    // trzeba jednak ocenic...
    // usun kropke z rozgr2,3, rozgrywka (przed analiza o 1 plycej)
    ang0.rozgr2[ ang0.indeks ]=0;
    ang0.rozgr3[ ang0.indeks ]=0;
    rozgrywka[ ang0.indeks ]=0;
    //
    switch (TAnaliza::gracz.funkcja_sk) {
    case 2:
    case 3:
      poz[1].Ocen(rozgrywka, ang1, ang2);
      break;
    case 4:
    case 5:     // funkcja T - inny algorytm okrazania
      if (sciezki>=0)
	poz[1].OcenBMsciezki(rozgrywka, ang1, ang2, sciezki);
      else
	poz[1].OcenBM(rozgrywka, ang1, ang2);
      break;
    }
    // odtworz kropke w rozgr2,3, rozgrywka (po ew. analiza o 1 plycej)
    ang0.rozgr2[ ang0.indeks ]=ang0.ktory_teraz;
    ang0.rozgr3[ ang0.indeks ]=ang0.ktory_teraz;
    rozgrywka[ ang0.indeks ]=ang0.ktory_teraz;
  }

  // teraz ocena dla nas
  switch (TAnaliza::gracz.funkcja_sk) {
  case 2:
  case 3:
    poz[0].Ocen(rozgrywka, ang0, &ang1);
    break;
  case 4:
  case 5:     // funkcja T - inny algorytm okrazania
    if (sciezki>=0)
      poz[0].OcenBMsciezki(rozgrywka, ang0, &ang1, sciezki);
    else
      poz[0].OcenBM(rozgrywka, ang0, &ang1);
    break;
  }
  // jesli zdobylismy teraz jakies kropki, to ocena_skl_pop wymaga
  // poprawki (trzeba anulowac oceny zamknietych wlasnie skladowych)
  long int ocena;
  long int ocena_skl_pop = poz[1].ocena;
  long int ocena_skl     = poz[0].ocena;

  if (ang0.ile_kr_zd_teraz)
    ocena_skl_pop -= 
      poz[1].WezPoprawkeNaSklPop(ang0.rozgr3, ang1.ktory_teraz);
      //    ang1.robaki[ang1.ktory_teraz-1].WezPoprawkeNaSklPop(ang0.rozgr3, poz[1].oceny_skladowych);
  // oblicz ocene pozycji z punktu widzenia akt. gracza
  if (ostatni_to_ja)   // ocena dla komputera
    ocena = TAnaliza::gracz.wagi_n.sk*ocena_skl - ang0.straty
      - TAnaliza::gracz.wagi_p.sk*ocena_skl_pop + ang0.zyski;
  else  // ocena dla przeciwnika -- dlatego minus...
    ocena = -TAnaliza::gracz.wagi_n.sk*ocena_skl_pop + ang0.zyski +
      TAnaliza::gracz.wagi_p.sk*ocena_skl - ang0.straty;
  return ocena+ocena_Bo;
  }
  else
    return ocena_Bo + ang0.zyski - ang0.straty;
}

long int TOcenaSkl12::OcenPozycje12TylkoTaGleb(unsigned char *rozgrywka, int ostatni_to_ja, 
					       TAnaliza& ang0, const TAnaliza& ang1)
// jak OcenPozycje12(), ale ocenia tylko ang0
{
  long int ocena_Bo;
  if (TAnaliza::gracz.Bouzy_dil) {
    if (ang[0].ktory_teraz==2) {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_n.Bo, TAnaliza::gracz.wagi_p.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (!ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
    else {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_p.Bo, TAnaliza::gracz.wagi_n.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
  }
  else ocena_Bo=0;
  if (TAnaliza::gracz.waga_latwe_pole)
    ocena_Bo += int(TAnaliza::gracz.waga_latwe_pole) * ocenalfo.Ocen(ang0, &ang1);
  int funkcja_sk = TAnaliza::gracz.funkcja_sk ? TAnaliza::gracz.funkcja_sk : 3;    // wez ./x, gdy brak f.oc.
  // teraz ocena dla nas
  switch (funkcja_sk) {
  case 2:
  case 3:
    poz[0].Ocen(rozgrywka, ang0, &ang1);
    break;
  case 4:
  case 5:     // funkcja T - inny algorytm okrazania
    poz[0].OcenBM(rozgrywka, ang0, &ang1);
    break;
  }
  long int ocena;
  long int ocena_skl_pop = 0;
  long int ocena_skl     = poz[0].ocena;
  // oblicz ocene pozycji z punktu widzenia akt. gracza
  if (ostatni_to_ja)   // ocena dla komputera
    ocena = TAnaliza::gracz.wagi_n.sk*ocena_skl - ang0.straty
      - TAnaliza::gracz.wagi_p.sk*ocena_skl_pop + ang0.zyski;
  else  // ocena dla przeciwnika -- dlatego minus...
    ocena = -TAnaliza::gracz.wagi_n.sk*ocena_skl_pop + ang0.zyski +
      TAnaliza::gracz.wagi_p.sk*ocena_skl - ang0.straty;
  return ocena+ocena_Bo;
}


void TAnaliza::InicjujCiecia(unsigned char *rozgr)
// inicjuje ciete[0-1]
// zakladamy, ze rozgr nie jest pusta!
// TRZEBA UWAZAC na sytuacje, w ktorej wszystkie kropki leza na bandzie!
// (ale to istotne tylko wtedy, gdy jeden z graczy nie postawil jeszcze kropki)
// Nalezy wywolac z rozgr3!!
{
  unsigned char *bezp = plansze.PrzydzielPlansze();
  {
    CzyscTablice(bezp);
    int dind[4] = {-wlky-4,-1,1,wlky+4};
    // ustaw wewnetrzne bezpieczne
    for (int i=up.lg; i<=up.pd; i++)
      if (bezp_na_zawsze[i]) {
	int ile_sasiadow = 0;
	for (int k=0; k<4; k++)
	  ile_sasiadow += (bezp_na_zawsze[i+dind[k]]>0 || upl_marg[i+dind[k]]==1);
	bezp[i]= 1 + (ile_sasiadow==4);
      }
  }
  // bezp juz gotowe
  for (int i=0; i<2; i++) {
    ciete[i].Zeruj();
    ciete[i].RozpocznijDodawanieZOpozn();
  }
  /* bez wykorzystania bezp:
  for (int i=up.lg; i<=up.pd; i++)
    if (rozgr[i]) {
      ciete[0].DodajKropkeZOpozn(i, (rozgr[i]==1) );
      ciete[1].DodajKropkeZOpozn(i, (rozgr[i]==2) );
    }
  */
  for (int i=up.lg; i<=up.pd; i++)
    if (rozgr[i])
      if (bezp[i]==0){
	ciete[0].DodajKropkeZOpozn(i, (rozgr[i]==1) );
	ciete[1].DodajKropkeZOpozn(i, (rozgr[i]==2) );
      }
      else if (bezp[i]==1)
	ciete[2-rozgr[i]].DodajKropkeZOpozn(i,0);
  ciete[0].UaktualnijCiecia();   ciete[1].UaktualnijCiecia();
  plansze.ZwolnijPlansze(bezp);
}

void ZnajdzListeRuchow12(unsigned char *rozgrywka, unsigned char *plansz_p,
			 unsigned char *rozgr2, unsigned char *rozgr3,
			 krint *skl_tab, 
			 TDwaUC marg_min[4], TDwaUC marg_max[4],
			 int &ile_ruchow, int &ile_ruchow_przec,
			 krint *kolejne_ruchy,  krint *ruchy_przec,
			 unsigned char *schemat_ruchow,
			 const TGraczO &gracz,
			 int ktory_gracz)
// we: rozgrywka, plansz_p
//     pozostale tablice zostana wypelnione, ALE trzeba na nie przydzielic
//     pamiec na zewnatrz funkcji
// Ustawia tez ang[1].zagrozenia i ang[1].ile_zagrozen.
{
  // przydziel pamiec
  krint *zagrozenia  = skladowe.PrzydzielSkladowa();
  krint *szanse      = skladowe.PrzydzielSkladowa();
  unsigned char* dod_inf = plansze.PrzydzielPlansze();
  unsigned char* ile_razy= plansze.PrzydzielPlansze();
  unsigned char* plansz_p_arg = plansze.PrzydzielPlansze();
  unsigned char* rozgrywka_arg = plansze.PrzydzielPlansze();
  KopiujTablice(plansz_p_arg, plansz_p);
  KopiujTablice(rozgrywka_arg, rozgrywka);
  krint *obszar = skladowe.PrzydzielSkladowa();
  unsigned char *bezs = plansze.PrzydzielPlansze();

  // przygotuj plansze z rozgrywka, usuwajac (rozgr2)
  //  lub wstawiajac (rozgr3) kropki wewnatrz stopow
  WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
  // przygotuj tablice z numerami skladowych
  CzyscTablice(skl_tab);
  marg_min[0] = TDwaUC(wlkx+2, wlky+2), marg_max[0] = TDwaUC(0,0);
  int maska_naszego_stopu = ktory_gracz==1 ? 4+1:8+2;
  int maska_stopu_przec   = (maska_naszego_stopu ^ 0xf);
  {
    unsigned int num_skl_n=1;
    unsigned int num_skl_p=30001;
    TDwaUC p;
    for (p.x=2; p.x<wlkx+2; p.x++)
      for (p.y=2; p.y<wlky+2; p.y++)
	{
	  unsigned int indeks_ij = WezIndeksTab(p.x,p.y);
	  unsigned char kr=rozgr2[indeks_ij];
	  if (kr!=0)
	    {
	      if (p.x<marg_min[0].x) marg_min[0].x=p.x;
	      if (p.y<marg_min[0].y) marg_min[0].y=p.y;
	      if (p.x>marg_max[0].x) marg_max[0].x=p.x;
	      if (p.y>marg_max[0].y) marg_max[0].y=p.y;
	      if (skl_tab[indeks_ij]==0)
		if (kr==ktory_gracz)
		  ZnajdzSkladowa(skl_tab, rozgr2, num_skl_n++, indeks_ij);
		else
		  ZnajdzSkladowa(skl_tab, rozgr2, num_skl_p++, indeks_ij);
	    }
	}
  }
  // wez margines na jedno, dwa, trzy pola
  for (int i=1; i<4; i++)
    {
      marg_min[i].x = (marg_min[i-1].x>2) ? (marg_min[i-1].x-1) : 2;
      marg_max[i].x = (marg_max[i-1].x<=wlkx) ? (marg_max[i-1].x+1) : wlkx+1;
      marg_min[i].y = (marg_min[i-1].y>2) ? (marg_min[i-1].y-1) : 2;
      marg_max[i].y = (marg_max[i-1].y<=wlky) ? (marg_max[i-1].y+1) : wlky+1;
    }
  // znajdz zagrozenia
  // tablica dod_inf (dodatkowe informacje) -- znaczenie bitow:
  //   & 1  -- stawiajac tu kropke przeciwnik ma staly stop
  //   & 2  -- stawiajac tu kropke przeciwnik ma stop
  //   & 4  -- to pole moge zamknac natychmiast
  //           (czyli tu przeciwnik nie powinien stawiac kropki)
  //   & 8  -- stawiajac tu kropke mam stop (staly lub zwykly)
  //   & 16 -- to pole moze zostac natychmiast zamkniete przez przeciwnika
  //           (czyli tu nie powinienem stawiac kropki)
  //   & 32 -- ten ruch jest ,,ciekawy'' (zagrozenie lub szansa)
  //   & 64 -- jest w tablicy ruchy_przec[]
  //   & 128-- jest w tablicy kolejne_ruchy[]
  CzyscTablice(dod_inf);
  CzyscTablice(ile_razy);
  int ile_zagrozen=0;
  int ile_szans=0;
  int moga_byc_nieunikn=0;
  {
    for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
      for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	{
	  unsigned int indeks_ij = WezIndeksTab(i,j);
	  if (rozgr3[indeks_ij]==0 && CzyMozliwyStop(skl_tab, rozgr2, i,j, 3-ktory_gracz))
	    {
	      int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz,
			  ile_zd,pow,pow2,punktacja_ss);
	      rozgrywka[indeks_ij]=0;  // usun kropke
	      if (ile_zd>0 || pow>0)
		{
		  zagrozenia[ile_zagrozen++]=indeks_ij;
		  if (pow>0)    dod_inf[indeks_ij]|=33;
		  if (ile_zd>0) dod_inf[indeks_ij]|=34;
		}
	      if (ile_zd || pow || pow2)
		{
		  for (int i=up.lg; i<=up.pd; i++)
		    if (plansz_p[i]!=plansz_p_arg[i])
		      {
			dod_inf[i]|=16;
			if (ile_razy[i]<255)
			  {
			    ile_razy[i]++;
			    if (!moga_byc_nieunikn)
			      moga_byc_nieunikn = (ile_razy[i] >= 2);
			  }
			plansz_p[i]=plansz_p_arg[i];
		      }
		}
	    }
	}
  }
  if (!moga_byc_nieunikn || gracz.dokl_analizy==1)   // nieuniknione darujemy sobie na gleb==1
    {  // na pewno nie ma nieuniknionych zagrozen -- tylko znajdz szanse
      for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	  {
	    unsigned int indeks_ij = WezIndeksTab(i,j);
	    if (rozgr3[indeks_ij]==0 && CzyMozliwyStop(skl_tab, rozgr2, i,j, ktory_gracz))
	      {
		int ile_zd=0, pow=0, pow2=0, punktacja_ss;
		ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz,
			    ile_zd,pow,pow2, punktacja_ss);
		rozgrywka[indeks_ij]=0;  // usun kropke
		if (ile_zd>0 || pow>0)
		  {
		    dod_inf[indeks_ij] |= 40;     // mozemy cos zamknac, wiec
		    dod_inf[indeks_ij] &= (~16);  // moze ten ruch nie jest taki zly...
		    // zapamietaj ruch jako ciekawy
		    szanse[ile_szans++]=indeks_ij;
		  }
		if (ile_zd || pow || pow2)
		  {
		    for (int i=up.lg; i<=up.pd; i++)
		      if (plansz_p[i]!=plansz_p_arg[i])
			{
			  dod_inf[i]|=4;
			  plansz_p[i]=plansz_p_arg[i];
			}
		  }
	      }
	  }
    }
  else
    {
      // znajdz szanse i zagrozenia, ktore nie sa nieuniknione (w 1. ruchu,
      //   bez analizy ew. naszych podw. uderzen)
      {
	unsigned char* plansz_p2 = plansze.PrzydzielPlansze();
	unsigned char* pom       = plansze.PrzydzielPlansze();
	CzyscTablice(pom);
	for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	  for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	    {
	      unsigned int indeks_ij = WezIndeksTab(i,j);
	      if (rozgr3[indeks_ij]==0 && CzyMozliwyStop(skl_tab, rozgr2, i,j, ktory_gracz))
		{
		  int ile_zd=0, pow=0, pow2=0, punktacja_ss;
		  ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz,
			      ile_zd,pow,pow2, punktacja_ss);
		  rozgrywka[indeks_ij]=0;  // usun kropke
		  if (ile_zd>0 || pow>0)
		    {
		      dod_inf[indeks_ij] |= 40;     // mozemy cos zamknac, wiec
		      dod_inf[indeks_ij] &= (~16);  // moze ten ruch nie jest taki zly...
		      // zapamietaj ruch jako ciekawy
		      szanse[ile_szans++]=indeks_ij;
		      // sprawdz, czy likwiduje jakies zagrozenia
		      KopiujTablice(plansz_p2, plansz_p);
		      for (int z=0; z<ile_zagrozen; z++)
			{
			  if (zagrozenia[z]==indeks_ij)
			    continue;  // zagrozenie nieaktualne - postawilismy kropke
			  int iz = upl_x[zagrozenia[z]];
			  int jz = upl_y[zagrozenia[z]];
			  unsigned int indeks_ijz = zagrozenia[z];
			  if (plansz_p[indeks_ijz] & maska_naszego_stopu)
			    continue;  // zagrozenie nieaktualne - zamknelismy (staly) stop
			  // wykonaj ruch
			  int ile_zd=0, pow=0, pow2=0;
			  ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, iz,jz,3-ktory_gracz,
				      ile_zd,pow,pow2, punktacja_ss);
			  rozgrywka[indeks_ijz]=0;  // usun kropke
			  if (ile_zd || pow || pow2)
			    {
			      for (int i=up.lg; i<=up.pd; i++)
				if (plansz_p2[i]!=plansz_p[i])
				  {
				    pom[i]=1;
				    plansz_p2[i]=plansz_p[i];
				  }
			    }
			}
		      // wyzeruj zlikwidowane zagrozenia
		      {
			for (int i=up.lg; i<=up.pd; i++)
			  if (!pom[i])
			    ile_razy[i]=0;   // wyzeruj ew. zagrozenie
			  else
			    pom[i]=0;        // odtworz tablice pom (same zera)
			
		      }
		    }
		  if (ile_zd || pow || pow2)
		    {
		      for (int i=up.lg; i<=up.pd; i++)
			if (plansz_p[i]!=plansz_p_arg[i])
			  {
			    dod_inf[i]|=4;
			    plansz_p[i]=plansz_p_arg[i];
			  }
		    }
		}
	    }
	plansze.ZwolnijPlansze(plansz_p2);
	plansze.ZwolnijPlansze(pom);
      }
      
      // znajdz szanse zwiazane z naszymi podwojnymi uderzeniami, ktore pozwalaja
      // uniknac nieuniknionych, zdawaloby sie, zagrozen
      // (...)  na razie tego nie ma (...)
      //
      // to, czego sie nie da obronic, zamknij, zeby nas nie oglupialo
      // ale wstawiaj kropki tylko w (przynajmniej) podwojnie zagrozone miejsca
      {
	unsigned char* plansz_p2    = plansze.PrzydzielPlansze();
	// badaj zagrozenia
	moga_byc_nieunikn=0;
	for (int z=ile_zagrozen-1; z>=0; z--)
	  {
	    int iz = upl_x[zagrozenia[z]];
	    int jz = upl_y[zagrozenia[z]];
	    unsigned int indeks_ijz = zagrozenia[z];
	    unsigned int indeks_ijz_d[4] =
	    {indeks_ijz-1, indeks_ijz+wlky+4, indeks_ijz+1, indeks_ijz-wlky-4 };
	    if (ile_razy[indeks_ijz]<=1 &&
		((ile_razy[indeks_ijz_d[0]]>=2 && (plansz_p[indeks_ijz_d[0]] & 15)==0) ||
		 (ile_razy[indeks_ijz_d[1]]>=2 && (plansz_p[indeks_ijz_d[1]] & 15)==0) ||
		 (ile_razy[indeks_ijz_d[2]]>=2 && (plansz_p[indeks_ijz_d[2]] & 15)==0) ||
		 (ile_razy[indeks_ijz_d[3]]>=2 && (plansz_p[indeks_ijz_d[3]] & 15)==0)))
	      {
		KopiujTablice(plansz_p2, plansz_p);
		// wykonaj ruch(y)
		int ile_zd=0, pow=0, pow2=0;
		int wyk[4] = {0,0,0,0};   // wykonane ruchy
		int di[4] = {0,1,0,-1}, dj[4] = {-1,0,1,0};
		int zap_rozg[4];
		for (int nr=0; nr<4; nr++)
		  if (ile_razy[indeks_ijz_d[nr]]>=2 && (plansz_p[indeks_ijz_d[nr]] & 15)==0)
		    {
		      wyk[nr]=1;
		      zap_rozg[nr]=rozgrywka[indeks_ijz_d[nr]];
		      int punktacja_ss;
		      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, iz+di[nr],jz+dj[nr],3-ktory_gracz,
				  ile_zd,pow,pow2, punktacja_ss);
		    }
		if (wyk[0] || wyk[1] || wyk[2] || wyk[3])
		  {
		    int zle=0;
		    for (int i=up.lg; i<=up.pd; i++)
		      if (plansz_p2[i]!=plansz_p[i] && ile_razy[i]<=1)
			{zle=1; break; }
		    if (zle)
		      { // usun kropki
			for (int nr=0; nr<4; nr++)
			  if (wyk[nr]) rozgrywka[indeks_ijz_d[nr]]=zap_rozg[nr];
			KopiujTablice(plansz_p, plansz_p2);
		      }
		    else moga_byc_nieunikn=1;
		  }
	      }
	  }
	plansze.ZwolnijPlansze(plansz_p2);
      }
      if (moga_byc_nieunikn)
	{
	  // ustaw na nowo skl_tab oraz rozgr2, rozgr3
	  WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
	  ZnajdzSkladowe(skl_tab, rozgr2, ktory_gracz);
	  // wyzeruj bity przeciwnika w dod_inf
	  for (int i=up.lg; i<=up.pd; i++)
	    if (dod_inf[i] & 0x8)      // stawiajac tu kropke mam stop? (szansa)
	      dod_inf[i] &= ~(0x13);   // tak
	    else
	      dod_inf[i] &= ~(0x33);   // nie! => wyzeruj tez bit ciekawego ruchu
	  // ustaw na nowo dod_inf,
	  // usun niepotrzebne zagrozenia (takie, ktore juz nie sa zagrozeniami)
	  unsigned char *plansz_p2 = plansze.PrzydzielPlansze();
	  for (int z=ile_zagrozen-1; z>=0; z--)
	    {
	      int iz = upl_x[zagrozenia[z]];
	      int jz = upl_y[zagrozenia[z]];
	      unsigned int indeks_ijz = zagrozenia[z];
	      if (rozgrywka[indeks_ijz]==0 && (plansz_p[indeks_ijz] & 0xf)==0)
		{
		  int ile_zd=0, pow=0, pow2=0, punktacja_ss;
		  KopiujTablice(plansz_p2, plansz_p);
		  ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, iz,jz,3-ktory_gracz,
			      ile_zd,pow,pow2, punktacja_ss);
		  rozgrywka[indeks_ijz]=0;  // usun kropke
		  if (ile_zd || pow || pow2)
		    {
		      if (pow>0)    dod_inf[indeks_ijz]|=33;
		      if (ile_zd>0) dod_inf[indeks_ijz]|=34;
		      for (int i=up.lg; i<=up.pd; i++)
			if (plansz_p[i]!=plansz_p2[i] && (dod_inf[i] & 0x8)==0)
			  // stawiajac tu kropke tylko ja tracimy...
			  dod_inf[i]|=16;
		    }
		  else
		    zagrozenia[z] = zagrozenia[--ile_zagrozen];  // dziala nawet gdy [z] jest ostatnim zagrozeniem
		}
	      else
		zagrozenia[z] = zagrozenia[--ile_zagrozen];  // dziala nawet gdy [z] jest ostatnim zagrozeniem
	    }
	  // sprawdz, czy sa jakies nowe zagrozenia (to chyba niemozliwe...)
	  // (ale ustaw tylko bity 0x1, 0x2, zeby moc pozniej unikac wywolywania
	  //  ZrobPanstwoDoAnalizy()).
	  for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	    for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
         {
	   unsigned int indeks_ij = WezIndeksTab(i,j);
	   if (rozgr3[indeks_ij]==0 && (dod_inf[indeks_ij] & 0x3)==0 &&
	       CzyMozliwyStop(skl_tab, rozgr2, i,j, 3-ktory_gracz))
	     {
	       int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	       KopiujTablice(plansz_p2, plansz_p);
	       ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, i,j,3-ktory_gracz,
			   ile_zd,pow,pow2, punktacja_ss);
	       rozgrywka[indeks_ij]=0;  // usun kropke
	       if (ile_zd || pow || pow2)
		 {
		   // zagrozenia[ile_zagrozen++]=indeks_ij;  // te nowe sztuczne zagr. nas nie interesuja
		   if (pow>0)    dod_inf[indeks_ij]|=1;
		   if (ile_zd>0) dod_inf[indeks_ij]|=2;
		 }
	     }
         }
	  plansze.ZwolnijPlansze(plansz_p2);
	}
    }
  plansze.ZwolnijPlansze(ile_razy);
  // tutaj mamy ustawione:
  //   rozgrywka,plansz_p    -- w sposob pozwalajacy uniknac oglupiania;
  //   rozgr2,rozgr3,skl_tab,zagrozenia,szanse,dod_inf   -- jak zwykle.
  // wypelnij ang[1].zagrozenia
  ang[1].ile_zagrozen=0;
  for (int i=0; i<ile_szans; i++)
    if (dod_inf[szanse[i]] & 8)
      ang[1].zagrozenia[ ang[1].ile_zagrozen++ ] = szanse[i];
  // wypelnij kolejne_ruchy i ruchy_przec
  ile_ruchow=0, ile_ruchow_przec=0;
  ZnajdzObszary(obszar, rozgr2, rozgr3);
  most12.Inicjuj();    // trzeba wywolac przed ZnajdzMostki12() oraz TRobaki::OcenRuch
  {
    ZnajdzBezs12(bezs, rozgr3, marg_min[1], marg_max[1], 1);
    // zbadaj, czy sa kropki obu graczy
    int drugi_ruch;
    { 
      int sa[2]={0,0};
      for (int i=up.lg; i<=up.pd; i++) if (rozgr3[i]) sa[rozgr3[i]-1]++;
      drugi_ruch = (sa[0]==0 || sa[1]==0);
    }
    if (gracz.dokl_analizy>1)
      {
	// najpierw ruchy przeciwnika, wez sensowne zagrozenia
	for (int z=0; z<ile_zagrozen; z++)
	  {
	    unsigned int indeks_ijz = zagrozenia[z];
	    if ((dod_inf[indeks_ijz] & 7)!=4)   // gdy przeciwnik nie ma stopu, a moze stracic krope
	      {
		ruchy_przec[ile_ruchow_przec++] = zagrozenia[z];
		dod_inf[indeks_ijz] |= 0x40;
	      }
	  }
	if (!drugi_ruch) {
	  // wez otoczke
	  int maska_blisko = (ktory_gracz==1) ? 0x20a0 : 0x10a0;  // dla przeciwnika
	  for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	    for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	      {
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if (rozgr3[indeks_ij]==0 &&         // puste pole
		    ((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
		     (obszar[indeks_ij] & maska_blisko) == 0xa0  // i jest blisko innych kropek
		     // (odl. 2-przec, 2-gracz), oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
		     && !bezs[indeks_ij])              // i nie jest ewidentnie bez sensu
		    || (dod_inf[indeks_ij] & 0x70)==0x20)   // lub jest ciekawy, nieanalizowany i niezagrozony
		  {
		    ruchy_przec[ile_ruchow_przec++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x40;
		  }
	      }
	  // bierz kolejne otoczki, jesli potrzeba
	  {
	    int maski[4]={1,0x200,0x400,0x800};
	    int maska_bezs = (ktory_gracz==1) ? 0x2000 : 0x1000;  // dla przeciwnika
	    for (int i=0; (i<gracz.listy_ruchow[1] || (i<4 && ile_ruchow_przec<2)); i++) {
	      int maska=maski[i];
	      for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
		for (int j=marg_min[2].y; j<=marg_max[2].y; j++)
		  {
		    unsigned int indeks_ij = WezIndeksTab(i,j);
		    if (rozgr3[indeks_ij]==0 &&         // puste pole
			((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
			 (obszar[indeks_ij] & (maska | maska_bezs)) == maska  // jest w otoczce oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
			 && !bezs[indeks_ij]))              // i nie jest ewidentnie bez sensu
		      {
			ruchy_przec[ile_ruchow_przec++] = indeks_ij;
			dod_inf[indeks_ij] |= 0x40;
		      }
		  }
	    }
	  }
	}
	else {  // to jest drugi ruch -- wez otoczke z marginesem 2
	  int maska = 4;
	  int maska_bezs = (ktory_gracz==1) ? 0x2000 : 0x1000;  // dla przeciwnika	  
	  for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
	    for (int j=marg_min[2].y; j<=marg_max[2].y; j++)
	      {
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if (rozgr3[indeks_ij]==0 &&         // puste pole
		    ((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
		     (obszar[indeks_ij] & (maska | maska_bezs)) == maska  // jest w otoczce oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
		     && !bezs[indeks_ij]))              // i nie jest ewidentnie bez sensu
		  {
		    ruchy_przec[ile_ruchow_przec++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x40;
		  }
	      }
	}
      }
    // wez ruchy dla nas
    {
      int ile_spermut=0;
      for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	  {
	    unsigned int indeks_ij = WezIndeksTab(i,j);
	    if ((dod_inf[indeks_ij] & 0x30)==0x20  // analizuj tylko ciekawe i takie, ze postawionej kropki nie stracimy natychmiast
		&& rozgr3[indeks_ij]==0)
		  {
		    kolejne_ruchy[ile_ruchow++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x80;
		  }
	  }
      Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
      ile_spermut=ile_ruchow;
      // teraz wez kolejne otoczki
      int maska_bezsensu = (ktory_gracz==1) ? 0x1000 : 0x2000;
      for (int m=0; (m<=4+gracz.listy_ruchow[0] || (m<=5 && ile_ruchow<3)); m++)
	{
	  int maski[6]={0x50, 0xa0, 1, 0x200,0x400, 0x800};
	  int maska=maski[m];
	  if (drugi_ruch) maska = 4;
	  for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
	    for (int j=marg_min[2].y; j<=marg_max[2].y; j++)
	      {
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if ((obszar[indeks_ij] & (maska|maska_bezsensu))==maska
		    && (dod_inf[indeks_ij] & 0x90)==0
		    && rozgr3[indeks_ij]==0
		    && !bezs[indeks_ij])
		  {
		    kolejne_ruchy[ile_ruchow++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x80;
		  }
	      }
	  Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
	  ile_spermut=ile_ruchow;
	  if (drugi_ruch) break;
	}
    }
  }
  // ruchy do analizy gotowe, sprawdz, ile ich jest
  if (ile_ruchow<=1)
    {
      if (ile_ruchow==1)
	goto Zwolnij_pamiec;
      // trzeba znalezc jakis sensowny ruch (jesli tutaj dojdziemy,
      //  to chyba nie moze byc zadnych zagrozen! -- wiec mozna ten ruch
      //  wylosowac...
      int ile_wolnego, ile_wolnego_poza;
      IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
      int ktory=random(ile_wolnego_poza);
      for (int i=0; i<wlkx; i++)
	{
	  unsigned int indeks=WezIndeksTab(i+2,2);
	  for (int j=0; j<wlky; j++)
	    {
	      if ((plansz_p_arg[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
		  rozgrywka_arg[indeks]==0)        // nie ma tu jeszcze kropki
		if ((ktory--) ==0)
		  {
		    kolejne_ruchy[0] = WezIndeksTab(i+2,j+2);
		    ile_ruchow=1;  // zeby wybrac ruch nr 0
		    goto Zwolnij_pamiec;
		  }
	      indeks++;
	    }
	}
#ifndef TEKSTOWY
      printf("Blad... ,,pajak'' - przycisnij cos"); GrKeyRead();
#endif
     strcpy(pargry.nz1, "krbladp.z");
     gra.ObsluzZdarzenie(ZD_ZAPIS);
      exit(1);  // blad!
    }
   {
     // znajdz listy ruchow dla lisci
     CzyscTablice(schemat_ruchow);
     // ustaw marginesy na 0xff, to pozwoli nie analizowac ruchow poza plansza
     {  // pionowe marginesy:
       unsigned int ind=WezIndeksTab(0,0);
       for (int y=0; y<2*(wlky+4); y++) schemat_ruchow[ind++]=0xff;
       ind=WezIndeksTab(wlkx+2,0);
       for (int y=0; y<2*(wlky+4); y++) schemat_ruchow[ind++]=0xff;
       ind=WezIndeksTab(0,0);
       unsigned int ind2=WezIndeksTab(0,1), ind3=WezIndeksTab(0,wlky+2), ind4=WezIndeksTab(0,wlky+3);
       for (int x=0; x<wlkx+4; x++)
	 {  // poziome marginesy:
	   schemat_ruchow[ind ]=0xff;  ind +=wlky+4;
	   schemat_ruchow[ind2]=0xff;  ind2+=wlky+4;
	   schemat_ruchow[ind3]=0xff;  ind3+=wlky+4;
	   schemat_ruchow[ind4]=0xff;  ind4+=wlky+4;
	 }
     }
     // zaznacz tez istniejace kropki, co nie jest konieczne, ale przyspiesza
     for (int i=up.lg; i<=up.pd; i++)
       if (rozgr3[i] || bezs[i]==1) schemat_ruchow[i]=0xff;   // || bezs[i]==1 : wersje 82.08+/83.12+
     {
       // ruchy dla nas
       krint maska = (ktory_gracz==1) ? 0x10: 0x40;  // maska ,,w odleglosci 1 od naszej kropki''
       if (gracz.listy_ruchow[3]) maska*=2;  // wez jednak maske ,,w odleglosci 2 od naszej kropki''
       krint maska_upr = (ktory_gracz==1) ? 0x60: 0x90;  // maska ,,2 od naszej kropki lub 1 od przeciwnika''
       if (gracz.listy_ruchow[2]) maska_upr=0xa0;  // wez jednak maske ,,w odleglosci 2 od jakiejkolwiek kropki''
       for (int r=0; r<ile_ruchow; r++)
	 {
	   unsigned int indeks = kolejne_ruchy[r];
	   if (obszar[indeks] & maska)
	     schemat_ruchow[indeks] |= 1;
	   if (obszar[indeks] & maska_upr)
	     //        && (obszar[indeks] & 2))       // jest w otoczce z marginesem 1
	     schemat_ruchow[indeks] |= 4;   // maska ruchu uproszczonego
	 }
       if (gracz.listy_ruchow[3])
	 maska ^= 0xa0;  // wez druga maske
       else
	 maska ^= 0x50;  // wez druga maske
       if (!gracz.listy_ruchow[2])
	 maska_upr ^= 0xf0;  //  wez druga maske
       else ;   // tutaj maska symetryczna!
       for (int r=0; r<ile_ruchow_przec; r++)
	 {
	   unsigned int indeks = ruchy_przec[r];
	   if (obszar[indeks] & maska)
	     schemat_ruchow[indeks] |= 2;
	   if (obszar[indeks] & maska_upr)
	     schemat_ruchow[indeks] |= 8;   // maska ruchu uproszczonego
	 }
     }
     // uzupelnij dane w schemat_ruchow
     for (int i=0; i<ile_ruchow; i++)
       schemat_ruchow[kolejne_ruchy[i]] |= 0x10;
     for (int i=0; i<ile_ruchow_przec; i++)
       schemat_ruchow[ruchy_przec[i]] |= 0x20;
   }

 Zwolnij_pamiec:;
   plansze.ZwolnijPlansze(bezs);
   plansze.ZwolnijPlansze(dod_inf);
   plansze.ZwolnijPlansze(plansz_p_arg);
   plansze.ZwolnijPlansze(rozgrywka_arg);
   skladowe.ZwolnijSkladowa(zagrozenia);
   skladowe.ZwolnijSkladowa(szanse);
   skladowe.ZwolnijSkladowa(obszar);
}

void UaktualnijCiete(int akt_gleb, int ostatnia)
// ostatnia = (akt_gleb==ost_gleb)
{
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  if (ostatnia) {
      // uaktualnij ciete obszary, ale tylko dla akt. gracza
      int kto = angakt.ktory_teraz-1;
      //     memcpy(&angakt.ciete[kto], &angpop.ciete[kto], sizeof(angpop.ciete[0]));
      angakt.ciete[kto].Skopiuj(angpop.ciete[kto]);
      angakt.ciete[kto].DodajKropke(angakt.x,angakt.y,1);
  }
  else {
    //memcpy(&angakt.ciete[0], &angpop.ciete[0], 2*sizeof(angakt.ciete[0]));
    angakt.ciete[0].Skopiuj(angpop.ciete[0]);
    angakt.ciete[1].Skopiuj(angpop.ciete[1]);
    angakt.ciete[0].DodajKropke(angakt.x, angakt.y, angakt.ktory_teraz==1);
    angakt.ciete[1].DodajKropke(angakt.x, angakt.y, angakt.ktory_teraz==2);
  }
}

void UaktualnijMargSklBezp(int akt_gleb)
// najpierw ustaw robaki! (wazne dla skladowych!)
{
  STOPER_START_BEZP;
  // uaktualnij marginesy
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  int i=angakt.x; 
  int j=angakt.y;
  angakt.marg0_min.x = (i <? angpop.marg0_min.x);
  angakt.marg0_min.y = (j <? angpop.marg0_min.y);
  angakt.marg0_max.x = (i >? angpop.marg0_max.x);
  angakt.marg0_max.y = (j >? angpop.marg0_max.y);
  // ustaw bezpieczne
  angakt.bandy.UaktualnijBezpieczne(angpop.bandy, angakt.rozgr3, angakt.indeks, angakt.jest_stop_sstop);
  STOPER_STOP_BEZP;
  // szukaj skladowych
  if (angakt.ile_kr_zd_teraz) {  //  || pow || pow2  -- to niepotrzebne...
    //    ZnajdzSkladowe(angakt.skl_tab, angakt.rozgr2, angakt.ktory_teraz);
    CzyscTablice(angakt.skl_tab);
    angakt.robaki[0].ZnajdzSkladowe(angakt.skl_tab, (angakt.ktory_teraz==1 ? 1:30001));
    angakt.robaki[1].ZnajdzSkladowe(angakt.skl_tab, (angakt.ktory_teraz==1 ? 30001:1));
    /*
    // test:
    krint *skltest = skladowe.PrzydzielSkladowa();
    ZnajdzSkladowe(skltest, angakt.rozgr2, angakt.ktory_teraz);
    krint slownik[0x10000];
    for (int i=0; i<wlkx4wlky4; i++)
      slownik[skltest[i]] = angakt.skl_tab[i];
    for (int i=0; i<wlkx4wlky4; i++) {
      if (skltest[i]) // && angakt.rozgr2[i])
	if (slownik[skltest[i]]==0 || slownik[skltest[i]] != angakt.skl_tab[i])
	  {
	    printf("Blad: %d.!",i);
	    abort();
	  }
	else;
      else if (angakt.skl_tab[i] && angakt.rozgr3[i]==0) {
	printf("Blad 0: %d.!",i);
	abort();
      }
    }        
    skladowe.ZwolnijSkladowa(skltest);
    */
  }
  else
    DodajKropkeDoSkl(angakt.skl_tab, angpop.skl_tab,
		     angakt.rozgr2, angakt.indeks, angakt.ktory_teraz,
                      15000+akt_gleb);
}

void UaktualnijRobaki(unsigned char *rozgrywka, int akt_gleb)
{
  ang[akt_gleb].robaki[0].DodajKropke(ang[akt_gleb-1].robaki[0], rozgrywka, ang[akt_gleb].rozgr2,
				      ang[akt_gleb].rozgr3, ang[akt_gleb].plansz_p, ang[akt_gleb].indeks,
				      ang[akt_gleb].byl_stop, ang[akt_gleb].jest_stop_sstop);
  ang[akt_gleb].robaki[1].DodajKropke(ang[akt_gleb-1].robaki[1], rozgrywka, ang[akt_gleb].rozgr2,
				      ang[akt_gleb].rozgr3, ang[akt_gleb].plansz_p, ang[akt_gleb].indeks,
				      ang[akt_gleb].byl_stop, ang[akt_gleb].jest_stop_sstop);
}

void RuchySieveDown(krint *tab, int l, int p)
// przesiewamy w dol wg wartosci TAnaliza::historia_sort[], malejaco
{
  int j=2*l+1;
  krint x=tab[l];
  while (j<=p) {
    if (j<p &&
	TAnaliza::historia_sort[tab[j]] > TAnaliza::historia_sort[tab[j+1]])
      j++;
    if (TAnaliza::historia_sort[x] > TAnaliza::historia_sort[tab[j]]) {
      tab[l]=tab[j];
      l=j;  j=2*l+1;
    }
    else break;
  }
  tab[l]=x;
}

void RuchyHeapSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  STOPER_START_SORT;
  for (int i=n/2-1; i>=0; i--)
    RuchySieveDown(tab,i,n-1);
  for (int i=n-1; i>0; i--) {
    krint pom=tab[0];
    tab[0]=tab[i];
    tab[i]=pom;
    RuchySieveDown(tab,0,i-1);
  }
  STOPER_STOP_SORT;
}

void RuchyInsertionSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  for (int i=1; i<n; i++) {
    krint v = tab[i];
    int wart = TAnaliza::historia_sort[v];
    int j=i;
    while (j>0 && TAnaliza::historia_sort[tab[j-1]] < wart)
      { tab[j]=tab[j-1]; j--; }
    tab[j] = v;
  }
}

void RuchyQuickSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  STOPER_START_SORT;
  if (n<8) RuchyInsertionSort(tab,n);
  else {
    int na_stosie=2;
    int stos[32];      // potrzeba cos okolo 2 * log_2(maksymalne n)
    stos[0]=0;  stos[1]=n-1;
    do {
      int r=stos[--na_stosie];
      int l=stos[--na_stosie];
      do {
	// podziel tab[l],...,tab[r]
	int wart = TAnaliza::historia_sort[tab[(l+r)/2]];
	int i=l, j=r;
	do {
	  while (TAnaliza::historia_sort[tab[i]] > wart) i++;
	  while (TAnaliza::historia_sort[tab[j]] < wart) j--;
	  if (i<=j) { krint pom=tab[i];  tab[i]=tab[j];  tab[j]=pom; i++; j--; }
	}
	while (i<=j);
	// lista podzielona...
	if (j-l<r-i)
	  if (j-l<=5) {
	    RuchyInsertionSort(&tab[l], j-l+1);
	    if (r-i<=5)
	      { RuchyInsertionSort(&tab[i], r-i+1); break; }
	    else l=i;
	  }
	  else {
	    if (i<r) {
	      stos[na_stosie++] =i;
	      stos[na_stosie++] =r;
	    }
	    r=j;
	  }
	else
	  if (r-i<=5) {
	    RuchyInsertionSort(&tab[i], r-i+1);
	    if (j-l<=5)
	      { RuchyInsertionSort(&tab[l], j-l+1); break; }
	    else r=j;
	  }
	  else {
	    if (l<j) {
	      stos[na_stosie++] =l;
	      stos[na_stosie++] =j;
	    }
	    l=i;
	  }
      }
      while (l<r);
    }
    while (na_stosie);
    //    assert(TAnaliza::historia_sort[tab[0]] >= TAnaliza::historia_sort[tab[1]]);
    //    assert(TAnaliza::historia_sort[tab[1]] >= TAnaliza::historia_sort[tab[2]]);
  }
  STOPER_STOP_SORT;
}

void RuchySieveDown(krint *tab, int l, int p, long int *oceny)
// przesiewamy w dol wg wartosci oceny, malejaco
{
  int j=2*l+1;
  krint x=tab[l];
  while (j<=p) {
    if (j<p && oceny[tab[j]] > oceny[tab[j+1]])
      j++;
    if (oceny[x] > oceny[tab[j]]) {
      tab[l]=tab[j];
      l=j;  j=2*l+1;
    }
    else break;
  }
  tab[l]=x;
}

void RuchyHeapSort(krint *tab, int n, long int *oceny)
// sortujemy wg wartosci oceny, malejaco
{
  STOPER_START_SORT;
  for (int i=n/2-1; i>=0; i--)
    RuchySieveDown(tab,i,n-1,oceny);
  for (int i=n-1; i>0; i--) {
    krint pom=tab[0];
    tab[0]=tab[i];
    tab[i]=pom;
    RuchySieveDown(tab,0,i-1,oceny);
  }
  STOPER_STOP_SORT;
}


/*
void RuchyBubbleSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
// metoda stabilna (nie zmienia kolejnosci takich samych kluczy)
// dziala szybko, gdy jest duzo zer w historia_sort[]
{
  for (int i=1; i<n; i++) {  // i=koniec
    int posort=1;
    for (int j=n-1; j>=i; j--)
      if (TAnaliza::historia_sort[tab[j]] > TAnaliza::historia_sort[tab[j-1]]) {
	krint pom = tab[j];
	tab[j]    = tab[j-1];
	tab[j-1]  = pom;
	posort=0;
      }
    if (posort) return;
  }
}
*/

int ZapamietajOcene12(int ocena, int akt_gleb, int ost_gleb, int &x, int &y, int sortuj=1)
// zapamietuje ocene, sortuje ruchy
// zwraca 1, gdy jest ciecie beta, 0, gdy nie ma
{
  STOPER_START_ZAPO;
#ifndef TEKSTOWY
  ang[akt_gleb-1].ost_gleb_max = ang[akt_gleb-1].ost_gleb_max >? ang[akt_gleb].ost_gleb_max;
#endif
  unsigned int ind = ang[akt_gleb].indeks;
  if (-ocena < ang[akt_gleb-1].ocena) {  // dziala tez gdy (RHS)==MAXLONG
    ang[akt_gleb-1].ocena = -ocena;
    ang[akt_gleb-1].najlepszyr = ind;
    if (akt_gleb>=2)
      {
	int indpop = ang[akt_gleb-1].indeks;
	if (ang[akt_gleb-1].propoz[0][indpop] != ind) {
	  ang[akt_gleb-1].propoz[1][indpop] = ang[akt_gleb-1].propoz[0][indpop];
	  ang[akt_gleb-1].propoz[0][indpop] = ind;
	}
      }
    else
      if (akt_gleb==1) {
	x=ang[1].x;  y=ang[1].y;
      }
    if (sortuj)
    if (akt_gleb<=2) {
      if (akt_gleb==1) {
	ang[1].oceny_ht[ind] = ocena;   // wazne gdy sortuj==2 (dla else ponizej)
	// przesun na sama gore akt. ruch
	for (int i=ang[1].nr_ruchu; i>ang[1].pocz_ruch; i--)
	  ang[1].lista_ruchow[i] = ang[1].lista_ruchow[i-1];
	// zapamietaj najlepszy w [pocz]
	ang[1].lista_ruchow[ang[1].pocz_ruch] = ind;
      }
      else  // if (ocena<ang[0].ocena || sortuj==2)   // tylko gdy to dobry ruch! (ale to nie jest dobry pomysl)
      { // akt_gleb==2
	// przesun na sama gore akt. ruch
	for (int i=ang[2].nr_ruchu; i>ang[2].pocz_ruch; i--)
	  ang[2].lista_ruchow[i] = ang[2].lista_ruchow[i-1];
	// zapamietaj najlepszy w [pocz]
	ang[2].lista_ruchow[ang[2].pocz_ruch] = ind;
      }
    }
    else if (/*ost_gleb-akt_gleb>=2 &&*/ 
	     ang[akt_gleb].nr_ruchu > ang[akt_gleb].pocz_ruch+1) {
      ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu] =
	ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu-1];
      ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu-1] = ind;
    }

    // ciecia alfa-beta
    if (ocena>=ang[akt_gleb].alfa) ang[akt_gleb].alfa = ocena;
    if (ocena>=ang[akt_gleb].beta) {
      long long t = TAnaliza::historia[ind] += (ang[akt_gleb].historia_waga<<2);
      if (t>TAnaliza::historia_max) TAnaliza::historia_max = t;
      ang[akt_gleb-1].najlepszyr = 0;   // niekoniecznie jest najlepszy, tylko daje ciecie...
      STOPER_STOP_ZAPO;
      return 1;
    }
    else {  // dodaj mniej, bo tutaj nie ma ciecia...
      long long t = TAnaliza::historia[ind] += ang[akt_gleb].historia_waga;
      if (t>TAnaliza::historia_max) TAnaliza::historia_max = t;
    }
  }
  else if (sortuj==2 && akt_gleb==1) {
    ang[1].oceny_ht[ind]=ocena;
    // sortowanie
    int l=ang[1].pocz_ruch;
    int p=ang[1].nr_ruchu;   // przedzial [l,p)
    // znajdz miejsce dla akt. ruchu
    while (l<p) {
      int s=(l+p)/2;
      if (ang[1].oceny_ht[ang[1].lista_ruchow[s]] < ocena)
	p=s;
      else l=s+1;
    }
    if (l<ang[1].nr_ruchu) {
      for (int i=ang[1].nr_ruchu; i>l; i--)
	ang[1].lista_ruchow[i] = ang[1].lista_ruchow[i-1];
      ang[1].lista_ruchow[l] = ind;
    }
  } 
  STOPER_STOP_ZAPO;
  return 0;
}

void SortujRuchyA(unsigned char *rozgrywka, int akt_gleb)
  // akt_gleb==1 lub ==2
{
  osk12.Zeruj();
  if (akt_gleb==2) {
    ang[1].nr_ruchu = ang[1].pocz_ruch;
    ang[1].x=ang[1].y=ang[1].indeks = 0;
    ang[1].rozgr2 = ang[0].rozgr2;
    ang[1].rozgr3 = ang[0].rozgr3;   // bylo = ang[0].rozgr2, poprawione w 83.15
    ang[1].plansz_p = ang[0].plansz_p;
    ang[1].zyski  = ang[1].straty = ang[1].ile_kr_zd_teraz = ang[1].jest_stop_sstop = 0;
    // przepisz marginesy
    ang[1].marg0_min = ang[0].marg0_min;
    ang[1].marg0_max = ang[0].marg0_max;
    // przepisz bezpieczne
    ang[1].bandy.Kopiuj(ang[0].bandy);
    // przepisz skladowe
    KopiujTablice(ang[1].skl_tab, ang[0].skl_tab);
    // i ciete oraz robaki
    memcpy(ang[1].ciete, ang[0].ciete, sizeof(ang[1].ciete));
    ang[1].robaki[0] = ang[0].robaki[0];
    ang[1].robaki[1] = ang[0].robaki[1];
  }
  ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;
  long int *oceny = tabliceLI.Przydziel();
  while (ang[akt_gleb].nr_ruchu<ang[akt_gleb].ost_ruch) {
    if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb)) {
      // mozna wykonac ruch [akt_gleb].nr_ruchu!
      UaktualnijRobaki(rozgrywka, akt_gleb);
      UaktualnijMargSklBezp(akt_gleb);
      // ruch zrobiony, teraz go ocen
      UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
      oceny[ang[akt_gleb].indeks]
	= osk12.OcenPozycje12TylkoTaGleb(rozgrywka, (akt_gleb & 1), 
					 ang[akt_gleb], ang[akt_gleb-1]);
      // usun kropke
      ang[akt_gleb].rozgr2[ ang[akt_gleb].indeks ]=0;
      ang[akt_gleb].rozgr3[ ang[akt_gleb].indeks ]=0;
      rozgrywka[ ang[akt_gleb].indeks ]=0;
      ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
    }
    ang[akt_gleb].nr_ruchu++;
  }
  RuchyHeapSort(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
		ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch, oceny);
  ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;  
  osk12.Zeruj();   // na wszelki wypadek
  tabliceLI.Zwolnij(oceny);
}


inline long int QuiescenceS(unsigned char *rozgrywka, int akt_gleb)
// Uwaga: nie robi zadnych ciec beta - zwraca dokladna ocene!
{
  statystyka_dla_analizy.funk_ocen++;
  if ((TAnaliza::gracz.umiejetnosci & 0x100)==0 || 
      (ang[akt_gleb-1].ile_zagrozen==0 && ang[akt_gleb-1].grozby.ile==0)) {
    UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
    return osk12.OcenPozycje12(rozgrywka, (akt_gleb & 1), 
			       ang[akt_gleb], ang[akt_gleb-1], 
			       (akt_gleb>=2 ? &ang[akt_gleb-2] : NULL),
			       ang[akt_gleb].beta==MAXLONG);
  }
  int czy_jest_Q=0;
  long int ocena = -MAXLONG;
  ang[akt_gleb+1].nr_ruchu = 0;
  if (ang[akt_gleb+1].ost_ruch = ang[akt_gleb-1].ile_zagrozen)  // =, nie ==
    memcpy(ang[akt_gleb+1].lista_ruchow, ang[akt_gleb-1].zagrozenia, 
	   ang[akt_gleb-1].ile_zagrozen*sizeof(ang[akt_gleb-1].zagrozenia[0]));
  // dodaj grozby
  for (int i=0; i<ang[akt_gleb-1].grozby.ile; i++) {
    krint ind = ang[akt_gleb-1].grozby.lista[i];
    // sprawdz, czy nie ma juz takiego ruchu
    for (int j=ang[akt_gleb+1].ost_ruch-1; j>=0; j--)
      if (ang[akt_gleb+1].lista_ruchow[j]==ind)
	goto Juz_jest;
    // nie ma, dodaj
    ang[akt_gleb+1].lista_ruchow[ ang[akt_gleb+1].ost_ruch++ ]=ind;
  Juz_jest:;
  }
  while (ang[akt_gleb+1].nr_ruchu < ang[akt_gleb+1].ost_ruch) {
    if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb+1)) {
      if (ang[akt_gleb+1].ile_kr_zd_teraz) {
	if (!czy_jest_Q) {
	  czy_jest_Q=1;
	  // ustaw to, co zostalo wczesniej pominiete
	  UaktualnijCiete(akt_gleb, 0);
	  // alfa, beta pomijamy - i tak nieuzywane...
	}
	else statystyka_dla_analizy.funk_ocen++;  // kolejna ocena (pierwsze ,,++'' jest na poczatku)
	// ocen ruch
	UaktualnijRobaki(rozgrywka, akt_gleb+1);
	UaktualnijMargSklBezp(akt_gleb+1);
	UaktualnijCiete(akt_gleb+1, 1);
	long int ocena2 = osk12.OcenPozycje12(rozgrywka, ((akt_gleb+1) & 1), 
					      ang[akt_gleb+1], ang[akt_gleb], &ang[akt_gleb-1], -1);
	if (ocena2>ocena) ocena=ocena2;
	ang[akt_gleb+1].robaki[0].UsunKropke();       ang[akt_gleb+1].robaki[1].UsunKropke();
      }
      // usun kropke
      ang[akt_gleb+1].rozgr2[ ang[akt_gleb+1].indeks ]=0;
      ang[akt_gleb+1].rozgr3[ ang[akt_gleb+1].indeks ]=0;
      rozgrywka[ ang[akt_gleb+1].indeks ]=0;
    }
    // wez nastepny ruch
    ang[akt_gleb+1].nr_ruchu++;
  } 
  if (czy_jest_Q)
    return -ocena;
  UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
  return osk12.OcenPozycje12(rozgrywka, (akt_gleb & 1), 
			     ang[akt_gleb], ang[akt_gleb-1], 
			     (akt_gleb>=2 ? &ang[akt_gleb-2] : NULL),
			     ang[akt_gleb].beta==MAXLONG);
}

inline void HTWstaw(int akt_gleb, int ost_gleb, int ost_gleb16, 
		    long int ocena, int rodzaj, short int prop0, short int prop1)
// powinno byc akt_gleb>=1
{
  htablicaZ.Wstaw(ang[akt_gleb].htab_zobrist2, ang[akt_gleb].htab_zobrist, akt_gleb, ocena, rodzaj, prop0, prop1, ost_gleb-akt_gleb);
}

inline long int HTWez(int akt_gleb, int ost_gleb, int ost_gleb16, int &rodzaj)
// powinno byc akt_gleb>=1
{
  return
    htablicaZ.Wez(ang[akt_gleb].htab_zobrist2, ang[akt_gleb].htab_zobrist, rodzaj,
		  ang[akt_gleb].propoz[0][ang[akt_gleb].indeks],
		  ang[akt_gleb].propoz[1][ang[akt_gleb].indeks], ost_gleb-akt_gleb);
}
   
int AlfaBeta12(unsigned char *rozgrywka, unsigned char *schemat_ruchow, 
	       int ost_gleb, const TGraczO& gracz,
#ifndef TEKSTOWY
	       int pokaz_analize_max_gleb, 
#endif
	       int &x, int &y, int bez_ciec_beta=0, int zapamietuj_drugi_ruch=0)
// moze da sie wykorzystac na x,y zmienne ang[0].x,y ?
{
   ang[0].ocena    = MAXLONG;     // oznacza, ze oceny nie ma
   ang[1].nr_ruchu = 0;
   ang[0].ost_gleb = ost_gleb;    // do wysw. analizy
   // analizuj kolejne ruchy
   int akt_gleb=1;
   int ost_gleb16 = (ost_gleb<<4);
   long int ocena;
   Analizuj_nastepny:;
   ang[akt_gleb].byl_przeglad_ht=0;
   if (akt_gleb>=2) ang[akt_gleb].ile_zagrozen=0;
   // zrob przeglad htablicy
   ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;

   if (akt_gleb<ost_gleb)
    if (akt_gleb>=2) {   // MUSI byc co najmniej: akt_gleb<ost_gleb && akt_gleb>=3 (inaczej nie zainicjowane propoz)
     int hist_shift = 0;
     { long long int test=TAnaliza::historia_max;  
     while (test>8000) { test>>=1; hist_shift++;} }
     if (akt_gleb>=3) ang[akt_gleb].byl_przeglad_ht=1;      
     while (ang[akt_gleb].nr_ruchu < ang[akt_gleb].ost_ruch) {
       int ind = ang[akt_gleb].lista_ruchow[ ang[akt_gleb].nr_ruchu ];
       ang[akt_gleb].oceny_ht[ind] = MAXLONG;
       TAnaliza::historia_sort[ind]+= (TAnaliza::historia[ind] >> hist_shift);
       if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb, 1)) {
	 // mozna wykonac ruch [akt_gleb].nr_ruchu!
	 if (akt_gleb>=3) {
	   // czy pozycja jest w htablicy?
	   int rodzaj;
	   ang[akt_gleb].oceny_ht[ind] = ocena = HTWez(akt_gleb, ost_gleb, ost_gleb16, rodzaj);
	   ang[akt_gleb].rodzaj_oc_ht[ind] = rodzaj;
	   rodzaj &= 7;
	   if (rodzaj==4  ||
	       (rodzaj==5 && ocena>=ang[akt_gleb].beta) ||
	       (rodzaj==6 && ocena<=ang[akt_gleb].alfa)) {
	     statystyka_dla_analizy.wez_ht++;
	     if (ZapamietajOcene12(ocena, akt_gleb, ost_gleb, x, y, 0)) {
	       rozgrywka[ind] = 0;             // usun ruch
	       ang[akt_gleb].rozgr2[ind] = 0;
	       ang[akt_gleb].rozgr3[ind] = 0;
	       goto Ciecie_beta;
	     }
	     ang[akt_gleb].rodzaj_oc_ht[ind] |= 0x10;  // zaznacz ruch jako przegladniety
	   }
	   //if (rodzaj & 4)  // 83.36+
	   //  TAnaliza::historia_sort[ind]+= 3000;  // bonus za obecnosc w HT
	   //else if (ang[akt_gleb].propoz[0][ind])
	   //  TAnaliza::historia_sort[ind]+= 500;  // bonus za propozycje w HT
	 }
	 // sprawdz singularnosc grozb
	 if (ang[akt_gleb].jest_stop_sstop)
	   ang[akt_gleb-1].grozby.SprawdzOdpPrzec(rozgrywka, ang[akt_gleb].rozgr3, 
						  ang[akt_gleb].plansz_p, ind);
	 // usun ruch
	 rozgrywka[ind] = 0;
	 ang[akt_gleb].rozgr2[ind] = 0;
	 ang[akt_gleb].rozgr3[ind] = 0;
	 // sprawdz, czy ruch na [akt_gleb-1] nie byl bezsensowny
	 if (ang[akt_gleb].ile_kr_zd_teraz && 
	     ang[akt_gleb].rozgr3[ang[akt_gleb-1].indeks] == ang[akt_gleb].ktory_teraz &&
	     ang[akt_gleb-1].ile_kr_zd_teraz <= 1) {
	   // ruch bezsensowny, zmniejsz glebokosc i wez kolejny ruch
	   akt_gleb--;
	   unsigned int ind = ang[akt_gleb].indeks;
	   rozgrywka[ind] = 0;
	   ang[akt_gleb].rozgr2[ind] = 0;
	   ang[akt_gleb].rozgr3[ind] = 0;
	   ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
	   if (ost_gleb>=3 && akt_gleb<ost_gleb-1) UsunSasiadow(schemat_ruchow, akt_gleb);
	   ost_gleb = ang[akt_gleb].ost_gleb;
	   goto Kolejny_ruch;
	 }
	 // czy jest szansa?
	 if (ang[akt_gleb].jest_stop_sstop)
	   ang[akt_gleb].zagrozenia[ ang[akt_gleb].ile_zagrozen++ ] = ind;
       }
       else
	 ang[akt_gleb].rodzaj_oc_ht[ind] = 0x20;  // zaznacz ruch jako niewykonalny
       ang[akt_gleb].nr_ruchu++;
     }
     ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;
     ang[akt_gleb-1].grozby.ile_sing=0;
     // dodaj punkty za likwidowanie singularnych zagrozen
     for (int i=0; i<ang[akt_gleb-1].grozby.ile; i++)
       if (ang[akt_gleb-1].grozby.czy_singul[i] || !ang[akt_gleb-1].grozby.czy_bezs[i]) {
	 ang[akt_gleb-1].grozby.ile_sing+= (ang[akt_gleb-1].grozby.czy_singul[i]!=0);
	 int punkty = (ang[akt_gleb-1].grozby.zdobycze[i] << 11);
	 TAnaliza::historia_sort[ang[akt_gleb-1].grozby.lista[i]] += 
	   (punkty<10000) ? punkty : 10000;
       }
     // posortuj ruchy!
     if (akt_gleb>=3) { // na gleb==2 sie nie oplaca (!)
            // jesli jednak chcesz akt_gleb>=2, pamietaj o zmianie inicjowania historia_sort...
            // (wtedy ponizej trzeba ustawiac na 1 rowniez na akt_gleb==1)
       // dodaj punkty za zlikwidowane zagrozenia
       for (int i=ang[akt_gleb-1].ile_zagrozen-1; i>=0; i--)
	 TAnaliza::historia_sort[ ang[akt_gleb-1].zagrozenia[i] ] += 750;
       RuchyQuickSort(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
		     ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch);
       // usun niepotrzebne ruchy (dozwolne tylko dla akt_gleb>=3!!)
       while (ang[akt_gleb].ost_ruch > ang[akt_gleb].pocz_ruch) {
	 int ind = ang[akt_gleb].lista_ruchow[ang[akt_gleb].ost_ruch-1];
	 if (TAnaliza::historia_sort[ind]==0 &&
	     ((ang[akt_gleb].rodzaj_oc_ht[ind] & 0x20)!=0))
	   ang[akt_gleb].ost_ruch--;
	 else break;
       }
     }
    }
    else if (akt_gleb==1 && TAnaliza::sa_symetrie) {
      // symetrie!
      ang[1].byl_przeglad_ht=1;
      for (int i=ang[1].nr_ruchu; i < ang[1].ost_ruch; i++)
	ang[1].rodzaj_oc_ht[ ang[1].lista_ruchow[i] ] =
	  (TAnaliza::symetrie[ ang[1].lista_ruchow[i] ]) ? 0x10 : 0;   // przegladniety (=wywal) : do przegladniecia (=zostaw)

    }
   //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
   // analizuj kolejne ruchy!
   //_________________________________________________
   while (ang[akt_gleb].nr_ruchu < ang[akt_gleb].ost_ruch)
     {
       ang[akt_gleb].najlepszyr=0;
       if ((!ang[akt_gleb].byl_przeglad_ht || 
	    (ang[akt_gleb].rodzaj_oc_ht[ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu]] & 0x30)==0)
	   && WykonajRuchNrJesliMozna(rozgrywka, akt_gleb))
       {  // mozna wykonac ruch [akt_gleb].nr_ruchu!
#ifndef TEKSTOWY
	 if (akt_gleb<=pokaz_analize_max_gleb) {
	   ekran.NowyRuch(ang[0].ost_gleb, TJedenRuch(ang[1].x-2, ang[1].y-2), 
			  ang[1].nr_ruchu-ang[1].pocz_ruch, ang[1].ost_ruch-ang[1].pocz_ruch, 
			  akt_gleb);
	 }
#endif
       ang[akt_gleb].robaki[0].UaktualnijGleb();       ang[akt_gleb].robaki[1].UaktualnijGleb();
       // ustaw alfa i beta na nastepnym poziomie
       if (akt_gleb<ost_gleb) {
	 if (!bez_ciec_beta) {
	   ang[akt_gleb+1].alfapocz = ang[akt_gleb+1].alfa = -ang[akt_gleb].beta;
	   ang[akt_gleb+1].beta = -ang[akt_gleb].alfa;
	 }
	 else {
	   ang[akt_gleb+1].alfapocz = ang[akt_gleb+1].alfa = -MAXLONG;
	   ang[akt_gleb+1].beta = MAXLONG;
	 }
       }
       // czy pozycja jest w htablicy??
       if (ang[akt_gleb].byl_przeglad_ht) {
	 int ind = ang[akt_gleb].indeks;
	 ocena = ang[akt_gleb].oceny_ht[ind];
	 int rodzaj = ang[akt_gleb].rodzaj_oc_ht[ind];
	 if (rodzaj==6) {
	   if (ocena<=ang[akt_gleb].alfa) {
	     statystyka_dla_analizy.wez_ht++;
	     goto Zapamietaj_ocene_ale_nie_w_ht;
	   }
	   // ogr. gorne, wez minimum
	   ang[akt_gleb+1].alfa = - (ang[akt_gleb].beta <? ocena);
	 }
	 else if (rodzaj==5)  // ogr. dolne, wez maksimum
	   ang[akt_gleb+1].beta = - (ang[akt_gleb].alfa >? ocena);
       }
       else if (akt_gleb>=3) {
	 int rodzaj;
	 ocena = HTWez(akt_gleb, ost_gleb, ost_gleb16, rodzaj);
	 ang[akt_gleb].rodzaj_oc_ht[ ang[akt_gleb].indeks ] = rodzaj;
	 if (ocena!=MAXLONG) {
	   statystyka_dla_analizy.wez_ht++;
	   goto Zapamietaj_ocene_ale_nie_w_ht;
	 } 
       }
       UaktualnijRobaki(rozgrywka, akt_gleb);
       UaktualnijMargSklBezp(akt_gleb);
       // ruch zrobiony, teraz ocen lub idz w glab
       if (akt_gleb < ost_gleb)
         {
         UaktualnijCiete(akt_gleb, 0);  // 0 oznacza, ze akt_gleb < ost_gleb
	 // zapamietaj limity sex
	 ang[akt_gleb].ost_gleb  =ost_gleb;
	 ang[akt_gleb+1].sex_limit      = ang[akt_gleb].sex_limit;
	 ang[akt_gleb+1].sex_limit_podw = ang[akt_gleb].sex_limit_podw;
	 // dodaj grozby
	 ang[akt_gleb].grozby.ile=0;
	 if (akt_gleb<ost_gleb-1) {
	   if (akt_gleb>=2 || ang[1].sex_limit) {
	     ang[akt_gleb].grozby.DodajGrozbySasiedzkie(rozgrywka, ang[akt_gleb].rozgr3,
							ang[akt_gleb].plansz_p, ang[akt_gleb].skl_tab, 
							ang[akt_gleb].indeks);
	     ang[akt_gleb].grozby.UstawSing();
	     for (int i=up.lg; i<=up.pd; i++) TAnaliza::historia_sort[i]=1;
	   }
	   // sprawdz, czy powinnismy zrobic ,,singular extension''
	   if (//akt_gleb>=2 && 
	       ang[akt_gleb-1].grozby.ile_sing && 
	       ang[akt_gleb].sex_limit && 
	       (ang[akt_gleb-1].grozby.ile_sing==1 || ang[akt_gleb].sex_limit_podw)) {
	     // sprawdz, czy byla grozba singul
	     for (int i=0; i<ang[akt_gleb-1].grozby.ile; i++)
	       if (ang[akt_gleb-1].grozby.czy_singul[i] && 
		   ang[akt_gleb-1].grozby.lista[i] == ang[akt_gleb].indeks) {
		 // trzeba wydluzyc!!
		 ang[akt_gleb+1].sex_limit--;
		 if (ang[akt_gleb-1].grozby.ile_sing>=2) ang[akt_gleb+1].sex_limit_podw--;
		 ost_gleb++;
		 break;
	       }
	   }
	 }
	 else if (TAnaliza::gracz.umiejetnosci & 0x100)   // queiscence search
	   ang[akt_gleb].grozby.DodajGrozbySasiedzkie(rozgrywka, ang[akt_gleb].rozgr3,
						      ang[akt_gleb].plansz_p, ang[akt_gleb].skl_tab, 
						      ang[akt_gleb].indeks);
         akt_gleb++;
         if (ost_gleb>=3 && akt_gleb<ost_gleb)
           DodajSasiadow(schemat_ruchow, akt_gleb, ost_gleb);
	 else {
	   ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks]=0;
	   ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks]=0;
	 }
	 goto Analizuj_nastepny;
         }
       //       else   -- to jest w QuiescenceS()
       //         UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb

       Ocen_pozycje:;

       ocena = QuiescenceS(rozgrywka, akt_gleb);

       Zapamietaj_ocene:;
       if (akt_gleb==ost_gleb)
	 htablicaZ.Wstaw(ang[akt_gleb].htab_zobrist2, ang[akt_gleb].htab_zobrist, akt_gleb, 
			 ocena, 0,  0,0, 0);  // 0=ocena dokladna, 
               // 0,0 - brak propozycji kontynuacji, ostatnie 0: jestesmy w lisciu
       else
	 HTWstaw(akt_gleb, ost_gleb, ost_gleb16, ocena,
		 (ocena>=ang[akt_gleb].beta) ? 1 :        // 1 = ogr. dolne
		 ((ocena<=ang[akt_gleb].alfa) ? 2 : 0),  // .alfapocz ?; 2 = ogr. gorne
		 ang[akt_gleb].propoz[0][ang[akt_gleb].indeks],
		 ang[akt_gleb].propoz[1][ang[akt_gleb].indeks] );
       Zapamietaj_ocene_ale_nie_w_ht:;

       // usun kropke z rozgr2,3, rozgrywka
       ang[akt_gleb].rozgr2[ ang[akt_gleb].indeks ]=0;
       ang[akt_gleb].rozgr3[ ang[akt_gleb].indeks ]=0;
       rozgrywka[ ang[akt_gleb].indeks ]=0;
       ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
#ifndef TEKSTOWY
       if (akt_gleb<=pokaz_analize_max_gleb && akt_gleb<=7) {  // <=8 wymaga zmiany w ekran.cc:OcenionyRuch()
	 TSekwencjaRuchow ruchy;
	 for (int i=1; i<= akt_gleb; i++) {
	   ruchy.r[i-1].x = ang[i].x-2;  ruchy.r[i-1].y = ang[i].y-2;
	 }
	 ekran.OcenionyRuch(ang[0].ost_gleb, ang[akt_gleb].ost_gleb_max, ocena, &ruchy, akt_gleb);
       }
#endif

	 if (ZapamietajOcene12(ocena, akt_gleb, ost_gleb, x, y, 1+bez_ciec_beta))
	   break;   // ciecie beta
	 
	 // sprawdz czas
	 if (akt_gleb+2<=ost_gleb &&
	     (akt_gleb+3<=ost_gleb || akt_gleb<=2)) {
	   if (TAnaliza::gracz.czas_kiedy>=2 &&
	       (TAnaliza::gracz.czas_kiedy>2 ||
		(akt_gleb==1 && ang[1].nr_ruchu>ang[1].pocz_ruch)))
	     if (TAnaliza::czas.CzyJuz(TAnaliza::gracz.czas_sek, TAnaliza::gracz.czas_ssek)) {
	       TAnaliza::czas_przekr = 1;
	       return -ang[0].ocena;
	     }
#ifndef TEKSTOWY
	   if (TAnaliza::czas_przekr==2 && (akt_gleb==1 && ang[1].nr_ruchu>ang[1].pocz_ruch))
	     return -ang[0].ocena;   // wyjdz -- wcisnieto przycisk
	   // sprawdz klawiature
	   switch (ekran.CzyPrzerwacAnalize()) {
	   case -1:
	     TAnaliza::czas_przekr = 0;  // anuluj przerywanie analizy
	     break;
	   case 1:
	     TAnaliza::czas_przekr = 1;  // przerwij po glebokosci
	     break;
	   case 2:
	     TAnaliza::czas_przekr = 2;  // przerwij po zakonczeniu ruchu
	     break;
	   case 3:
	     TAnaliza::czas_przekr = 3;
	     return -ang[0].ocena;       // przerwij natychmiast
	   }
#endif
	 }
	 /*	 // przyspieszanie analizy (dla testu b. duzych glebokosci):
	 switch (random(10)) {
	 case 0: 
	 case 1:
	   break;
	 case 2: 
	 case 3:
	   ang[akt_gleb].nr_ruchu+=random(20); 
	   if (ang[akt_gleb].nr_ruchu>=ang[akt_gleb].ost_ruch)
	     ang[akt_gleb].nr_ruchu=ang[akt_gleb].ost_ruch-1;
	   break;
	 default:
	   ang[akt_gleb].nr_ruchu=ang[akt_gleb].ost_ruch-1;
	   break;
	   } */
       }
 Kolejny_ruch:;
     ang[akt_gleb].nr_ruchu++;
     if (akt_gleb<ost_gleb-1 && ang[akt_gleb].najlepszyr) { // && akt_gleb>=3) {
       // sortuj
       int najlepszy = ang[akt_gleb].najlepszyr;
       int pocz = ang[akt_gleb].nr_ruchu+1;
       if (akt_gleb==1 && pocz<ang[akt_gleb].pocz_ruch+4) pocz=ang[akt_gleb].pocz_ruch+4;   // tutaj nie przesuwaj za blisko poczatku
       int j=pocz;
       while (j<ang[akt_gleb].ost_ruch && ang[akt_gleb].lista_ruchow[j]!=najlepszy) j++;
       if (j<ang[akt_gleb].ost_ruch) {
	 // przenies ruchy w gore
	 for (int i=j; i>pocz; i--)
	   ang[akt_gleb].lista_ruchow[i] = ang[akt_gleb].lista_ruchow[i-1];
	 ang[akt_gleb].lista_ruchow[pocz] = najlepszy;
       }
     }
     }
 Ciecie_beta:;
   // przeszlismy cala galaz
   // zdejmij ze stosu
   akt_gleb--;
   if (ost_gleb>=3 && akt_gleb<ost_gleb-1) UsunSasiadow(schemat_ruchow, akt_gleb);
   ost_gleb = ang[akt_gleb].ost_gleb;
   // uwzglednij ocene ostatniej galezi, jesli jest oceniona
   if (akt_gleb>=1)
     {
     ocena = ang[akt_gleb].ocena;
     //     if (akt_gleb==1 && zapamietuj_drugi_ruch) drugi_ruch.Zapisz();
     if (ocena==MAXLONG)
       goto Ocen_pozycje;
     else
       goto Zapamietaj_ocene;  // usun kropke -- to jest w Zapamietaj_ocene
     }
   return -ang[0].ocena;
}

void ZnajdzNajlepszyRuch12(unsigned char* rozgrywka_arg, unsigned char* plansz_p_arg,
			   int ktory_gracz,
			   const TGraczO &gracz,
			   int &x, int &y, int st_x, int st_y, int wybierz_ruchy)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
// SNR w nazwie funkcji jest skrotem od ,,skladowe nierozerwalne''
// W strukturce gracz patrzymy na pola agresja, przejmuje_sie,
//  umiejetnosci oraz dokl_analizy.
// parametry agresja (= -9,...,9)
// oraz przejmuje_sie (= 30..129)
// odpowiadaja za styl gry;
// Zdefiniowane bity ,,umiejetnosci'':
//   na razie zadne, ale lepiej nie definiowac bitow 0x1,0x2,0x4 -- to ulatwi
//   zmiane poziomu miedzy 11 a 12 (poziom 11 wykorzystuje te bity)
{
 if (st_x==0 && st_y==0)
	{
	// to jest pierwsza kropka!
     int margx = (wlkx>>2)-1;
     margx=margx<2 ? 2:margx;
     int margy = (wlky>>2)-1;
     margy=margy<2 ? 2:margy;
     x = 2+margx+random(wlkx-2*margx);
     y = 2+margy+random(wlky-2*margy);
	return;
	}
 TAnaliza::gracz = gracz;    
 strcpy(TAnaliza::gracz.imie, gracz.imie);   // to ulatwia dodawanie testowych opcji...
 TAnaliza::czas_przekr=0;
 TAnaliza::czas.Zeruj();   TAnaliza::czas.Start();
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
 x=0; y=0;  // potrzebne w petli zwiekszajacej glebokosc
 if (ile_wolnego_poza) { // sa jakies wolne miejsca poza stalymi stopami

#ifndef TEKSTOWY
   if (gracz.dokl_analizy>=4) ekran.PoczatekAnalizy();
#endif
   int potrzeba_pamieci = gracz.dokl_analizy+1 + 
     ((gracz.dokl_analizy>=4) ? (gracz.sex_limit+gracz.sex_limit_podw) : 0) +
     ((gracz.dokl_analizy>=2) ? ((gracz.umiejetnosci & 0x100)!=0) : 0);
   // zapamietaj rozgrywke i plansz_p
   unsigned char* plansz_p  = plansze.PrzydzielPlansze();
   unsigned char* rozgrywka = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   KopiujTablice(rozgrywka, rozgrywka_arg);
   KopiujTablice(plansz_p, plansz_p_arg);
   
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   TDwaUC marg_min[4], marg_max[4];
   int ile_ruchow, ile_ruchow_przec;
   krint *kolejne_ruchy  = skladowe.PrzydzielSkladowa();
   krint *ruchy_przec    = skladowe.PrzydzielSkladowa();
   unsigned char *schemat_ruchow = plansze.PrzydzielPlansze();
   ang[1].zagrozenia = skladowe.PrzydzielSkladowa();

   ZnajdzListeRuchow12(rozgrywka, plansz_p,
		       rozgr2, rozgr3,
		       skl_tab, 
		       marg_min,  marg_max,
		       ile_ruchow, ile_ruchow_przec,
		       kolejne_ruchy,  ruchy_przec,
		       schemat_ruchow,
		       gracz,
			 ktory_gracz
		       );
     
   if (ile_ruchow==1) {
     x=upl_x[kolejne_ruchy[0]];
     y=upl_y[kolejne_ruchy[0]];
     goto Zwolnij_pamiec;
   }

   // znajdz dodatkowe bezsensowne ruchy, co wymaga wstepnego
   // zainicjowania niektorych pol ang[]
   ang[0].rozgr2   = rozgr2;
   ang[0].rozgr3   = rozgr3;
   ang[0].plansz_p = plansz_p;
   ang[0].marg0_min = marg_min[0];
   ang[0].marg0_max = marg_max[0];
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].UstawBezpNaZawsze();
   ang[0].UstawLancuchyWplanszp();  // eksperymentalne: 83.30+
   ang[0].DodajBezsensowne(schemat_ruchow);
   // teraz usun z list ruchow bezsensowne
   {
     int dokad=0, ruch=kolejne_ruchy[random(ile_ruchow)];
     for (int skad=0; skad<ile_ruchow; skad++)
       if (schemat_ruchow[kolejne_ruchy[skad]]!=0xff)
	 kolejne_ruchy[dokad++] = kolejne_ruchy[skad];
     ile_ruchow=dokad;
     if (ile_ruchow<=1) {
       if (ile_ruchow==0) { // wez wczesniej wylosowany ruch
	 x=upl_x[ruch];
	 y=upl_y[ruch];
       }
       else {
	 x=upl_x[kolejne_ruchy[0]];
	 y=upl_y[kolejne_ruchy[0]];
       }
     goto Zwolnij_pamiec2;
     }
     // teraz przeciwnika:
     dokad=0;
     for (int skad=0; skad<ile_ruchow_przec; skad++)
       if (schemat_ruchow[ruchy_przec[skad]]!=0xff)
	 ruchy_przec[dokad++] = ruchy_przec[skad];
     ile_ruchow_przec=dokad;
   }

   
   { 
   int docelowa_gleb=gracz.dokl_analizy;
   // przydziel pamiec
   // zainicjuj ang
   for (int i=0; i<=potrzeba_pamieci /*docelowa_gleb*/; i++)
     {
     ang[i].tab_pp=plansze.PrzydzielPlansze();
     ang[i].tab_r2=plansze.PrzydzielPlansze();
     ang[i].tab_r3=plansze.PrzydzielPlansze();
     ang[i].propoz[0]= i ? skladowe.PrzydzielSkladowa() : NULL;
     ang[i].propoz[1]= i ? skladowe.PrzydzielSkladowa() : NULL;
     //     if (i) {  // dla testu, teoretycznie niepotrzebne
     //  CzyscTablice(ang[i].propoz[0]);  CzyscTablice(ang[i].propoz[1]); }
     ang[i].bandy.Inicjuj();
     ang[i].skl_tab=(i==0) ? skl_tab : skladowe.PrzydzielSkladowa();
     if (i>=2) ang[i].zagrozenia = skladowe.PrzydzielSkladowa();
     ang[i].pocz_ruch=0;
     //     ang[i].historia_waga = (i<=docelowa_gleb) ? (1 << (docelowa_gleb-i)) : 0;
     ang[i].historia_waga=0;  // ustawiamy pozniej...
     if (i<potrzeba_pamieci) //docelowa_gleb)
       ang[i].oceny_ht =tabliceLI.Przydziel();
     ang[i].rodzaj_oc_ht=plansze.PrzydzielPlansze();
     if (i&1) {
       ang[i].ktory_teraz = ktory_gracz;
       ang[i].lista_ruchow= kolejne_ruchy;
       ang[i].ost_ruch = ile_ruchow;
       ang[i].lista_ruchow_pelna = kolejne_ruchy;
       ang[i].ile_ruchow_pelna   = ile_ruchow;
       ang[i].maska_lisc         = 1;
       ang[i].maska_upr          = 4; 
       ang[i].maska_pelna        = 0x10; }
     else {
       ang[i].ktory_teraz = 3-ktory_gracz;
       ang[i].lista_ruchow= ruchy_przec;
       ang[i].ost_ruch = ile_ruchow_przec;
       ang[i].lista_ruchow_pelna = ruchy_przec;
       ang[i].ile_ruchow_pelna   = ile_ruchow_przec;
       ang[i].maska_lisc         = 2;
       ang[i].maska_upr          = 8; 
       ang[i].maska_pelna        = 0x20; }
     if (i>2)
       ang[i].lista_ruchow=skladowe.PrzydzielSkladowa();
     // robaki:
     ang[i].robaki[0].Przydziel();
     ang[i].robaki[1].Przydziel();
     ang[i].robaki[0].UstawCzyje(1, TAnaliza::gracz.umiejetnosci & 0x10);
     ang[i].robaki[1].UstawCzyje(2, TAnaliza::gracz.umiejetnosci & 0x10);
     }
   krint *lista_lisc     = skladowe.PrzydzielSkladowa();
   osk12.PrzydzielPamiec();
   // zainicjuj ang[0]
   ang[0].htab_zobrist=0;  // na wszelki
   ang[0].htab_zobrist2=0; // wypadek
   ang[0].ile_zagrozen=0;  //
   ang[0].zyski    = 0;
   ang[0].straty   = 0;
   ang[0].byl_stop = 0;
   ang[0].jest_stop_sstop = 0;
   ang[0].nr_ruchu = 0;
   ang[0].indeks   = 0;   // zeby moc bezpiecznie ,,odtworzyc'' zmienne
   ang[0].ktory_teraz = 3-ktory_gracz;
   ang[1].sex_limit_podw = (docelowa_gleb>=4) ? gracz.sex_limit_podw : 0;
   ang[1].sex_limit      = (docelowa_gleb>=4) ? (gracz.sex_limit_podw + gracz.sex_limit) : 0;
   ang[0].InicjujCiecia(rozgr3);
   ang[0].bandy.UstawBezpieczne(rozgr3);
   ang[0].sasiedzi.ile_p   = ang[0].sasiedzi.ile_n = ang[0].sasiedzi.ile_lisc = 0;
   ang[1].sasiedzi.ile_p   = ang[1].sasiedzi.ile_n = ang[1].sasiedzi.ile_lisc = 0;
   ang[0].robaki[0].Inicjuj(rozgrywka, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[1].Inicjuj(rozgrywka, rozgr2, rozgr3, plansz_p);
   //drugi_ruch.Inicjuj();
// inicjuj pola statyczne
   ang[0].sasiedzi.tab_sas = plansze.PrzydzielPlansze();
   CzyscTablice(ang[0].sasiedzi.tab_sas);
   for (int p=0; p<20; p++)
     ang[0].polaboczne_dind[p] = ang[0].polaboczne_dx[p]*(wlky+4)
                               + ang[0].polaboczne_dy[p];
   for (int i=0; i<wlkx4wlky4; i++) TAnaliza::historia_sort[i]=1;
   memset(TAnaliza::historia, 0, wlkx4wlky4*sizeof(TAnaliza::historia[0]));
   TAnaliza::historia_max = 0;
   TAnaliza::symetrie = plansze.PrzydzielPlansze();
   UstawSymetrie(rozgrywka);
#ifndef TEKSTOWY
   if (wybierz_ruchy) {
     unsigned char *wr = plansze.PrzydzielPlansze();
     CzyscTablice(wr);
     for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++) {
       unsigned int ind = ang[1].lista_ruchow[i];
       wr[ind] |= 1;
       if (!TAnaliza::symetrie[ind]) wr[ind]|=2;
     }
     switch (ekran.WezListeRuchow(wr)) {
     case 0:
       break;  // escape = nic nie rob
     case -1:
       TAnaliza::sa_symetrie=0;   // zaakceptowane wszystkie ruchy
       break;
     case 1:
       // wzielismy nietrywialna liste ruchow!
       CzyscTablice(TAnaliza::symetrie);
       TAnaliza::sa_symetrie=1;
       for (int i=0; i<wlkx4wlky4; i++)
	 if ((wr[i] & 4)==0)              // ruch zostal wybrany,
	   TAnaliza::symetrie[i]=1;       // wiec usun go z analizy
       break;
     }
     plansze.ZwolnijPlansze(wr);
   }
#endif
   
   // przenies wybrane ruchy w gore listy
   if (TAnaliza::sa_symetrie)
     for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++) {
       unsigned int ind = ang[1].lista_ruchow[i];
       if (!TAnaliza::symetrie[ind]) {
	 // znajdz ostatni wybrany ruch na liscie, przenies posrednie w gore o jeden
	 int ost=i-1;
	 while (ost>=ang[1].pocz_ruch && TAnaliza::symetrie[ ang[1].lista_ruchow[ost] ]) {
	   ang[1].lista_ruchow[ost+1] = ang[1].lista_ruchow[ost];
	   ost--;
	 }
	 ang[1].lista_ruchow[ost+1] = ind;
       }
     }

   //test_sasiadow.Inicjacja();

#ifndef TEKSTOWY
   if (docelowa_gleb>3)  ekran.MinimaxPoczatek();
#endif
//#define POKAZ_MYSLENIE
//   if (docelowa_gleb>2) htablica.Wyczysc();
   htablicaZ.AnulujWpisy();  // to jest b. szybkie, wiec nie trzeba (ost_gleb>2)
   for (int ost_gleb=2; ost_gleb<=docelowa_gleb; ost_gleb++)
   {
#ifndef TEKSTOWY
     int pokaz_analize_max_gleb = (ost_gleb-3) <? 4;
#endif
   htablicaZ.NowaGlebokosc();  // to jest b. szybkie, wiec nie trzeba (ost_gleb>2)
   osk12.Zeruj();
   for (int i=1; i<ost_gleb; i++)
     ang[i].historia_waga = (2<<(ost_gleb-i));
   ang[ost_gleb].historia_waga = 1;
   // ustaw listy ruchow (uproszczone i liscie sa tez w DodajSasiadow())
   switch (ost_gleb)
     {
     case 2:
       if (docelowa_gleb>2) {
	 // posortuj ruchy na pelnej liscie
	 ang[2].lista_ruchow = ang[2].lista_ruchow_pelna;
	 ang[2].ost_ruch     = ang[2].ile_ruchow_pelna;
	 SortujRuchyA(rozgrywka, 2);
       }
       //SortujRuchyA(rozgrywka, 1);
       // ustaw ruchy w lisciu
       ang[2].lista_ruchow = lista_lisc;
       {
       int dokad=0;
       for (int i=0; i<ang[2].ile_ruchow_pelna; i++) {
	 unsigned int ind = ang[2].lista_ruchow_pelna[i];
	 if ((schemat_ruchow[ind] & ang[2].maska_lisc)!=0) {
	   ang[2].lista_ruchow[dokad++] = ind;
	 }
       }
       ang[2].ost_ruch = dokad;
       }
      break;
     case 3:
      ang[2].lista_ruchow = ang[2].lista_ruchow_pelna;
      ang[2].ost_ruch     = ang[2].ile_ruchow_pelna;
      break;
     }

   ang[1].alfapocz = ang[1].alfa = -MAXLONG;
   ang[1].beta     = MAXLONG; 
   int ocena = AlfaBeta12(rozgrywka, schemat_ruchow, ost_gleb, gracz, 
#ifndef TEKSTOWY
			  (docelowa_gleb>3) ? pokaz_analize_max_gleb : -1, 
#endif
			  x,y,
			  (docelowa_gleb>=5 && ost_gleb==2));
                   //	  (ost_gleb>3 && ost_gleb<docelowa_gleb));   // to nie przyspiesza!!

#ifdef NTEST
   if (ost_gleb==docelowa_gleb)
     {
     long int ile= htablica.StatWykorzystania();
     if (ile>max_wyk_htab) max_wyk_htab=ile;
     stat_wyk_htab += ile;
     stat_liczba_kr ++;
     }
#endif
   if (x==0) {
     // trzeba wylosowac jakis ruch -- sa same bezsensowne!
     int ile_wolnego, ile_wolnego_poza;
     IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
     int ktory=random(ile_wolnego_poza);
     for (int i=0; i<wlkx; i++)
       {
	 unsigned int indeks=WezIndeksTab(i+2,2);
	 for (int j=0; j<wlky; j++)
	   {
	     if ((plansz_p_arg[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
		 rozgrywka_arg[indeks]==0)        // nie ma tu jeszcze kropki
	       if ((ktory--) ==0) {
		 x=i+2; y=j+2;
		 goto Koniec_analizy;
	       }
	     indeks++;
	   }
       }
   }
   // sprawdz, czy trzeba wyjsc z analizy
   if (TAnaliza::czas_przekr || 
       (TAnaliza::gracz.czas_kiedy>=1 && 
	TAnaliza::czas.CzyJuz(TAnaliza::gracz.czas_sek, TAnaliza::gracz.czas_ssek))) {
     TAnaliza::czas_przekr = 1;
     break;  // wyjdz z analizy
   }

   }  // koniec analizy

   Koniec_analizy:;

   //test_sasiadow.Koniec();
   // koniec
   plansze.ZwolnijPlansze(TAnaliza::symetrie);
   plansze.ZwolnijPlansze(ang[0].sasiedzi.tab_sas);
   skladowe.ZwolnijSkladowa(lista_lisc);
   for (int i=0; i<=potrzeba_pamieci /*docelowa_gleb*/; i++)
     {
     ang[i].bandy.Zwolnij();
     plansze.ZwolnijPlansze(ang[i].tab_pp);
     plansze.ZwolnijPlansze(ang[i].tab_r2);
     plansze.ZwolnijPlansze(ang[i].tab_r3);
     if (i) {
       skladowe.ZwolnijSkladowa(ang[i].skl_tab);
       skladowe.ZwolnijSkladowa(ang[i].propoz[0]);
       skladowe.ZwolnijSkladowa(ang[i].propoz[1]);
     }
     if (i>=2) 
       skladowe.ZwolnijSkladowa(ang[i].zagrozenia);
     if (i<potrzeba_pamieci) //docelowa_gleb)
       tabliceLI.Zwolnij(ang[i].oceny_ht);
     plansze.ZwolnijPlansze(ang[i].rodzaj_oc_ht);
     if (i>2)  skladowe.ZwolnijSkladowa(ang[i].lista_ruchow);
     // robaki:
     ang[i].robaki[0].Zwolnij();
     ang[i].robaki[1].Zwolnij();
     }
   }
   osk12.ZwolnijPamiec();
   
 Zwolnij_pamiec2:;
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);

   Zwolnij_pamiec:;
#ifndef TEKSTOWY
   if (gracz.dokl_analizy>=4) ekran.KoniecAnalizy();
#endif

   skladowe.ZwolnijSkladowa(ang[1].zagrozenia);
   plansze.ZwolnijPlansze(schemat_ruchow);
   plansze.ZwolnijPlansze(rozgrywka);
   plansze.ZwolnijPlansze(plansz_p);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(ruchy_przec);
   skladowe.ZwolnijSkladowa(kolejne_ruchy);
   skladowe.ZwolnijSkladowa(skl_tab);
   return;
 }
else if (ile_wolnego)
{
  GraKoncowa(rozgrywka_arg, plansz_p_arg, ktory_gracz, x, y, st_x, st_y);
  if (x!=0) return;
}
x=-1; y=-1;
}
/****************************************************************************/


void ZnajdzNajlepszyRuch(unsigned char* rozgrywka, unsigned char* plansz_p,
			 int ktory_gracz, int poziom_gry, int umiejetnosci,
			 int &x, int &y, int st_x, int st_y)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
{
 if (st_x==0 && st_y==0)
   {
   // to jest pierwsza kropka!
     int margx = (wlkx>>2)-1;
     margx=margx<2 ? 2:margx;
     int margy = (wlky>>2)-1;
     margy=margy<2 ? 2:margy;
     x = 2+margx+random(wlkx-2*margx);
     y = 2+margy+random(wlky-2*margy);
   return;
   }
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka, plansz_p, ile_wolnego, ile_wolnego_poza);

 if (ile_wolnego_poza)  // sa jakies wolne miejsca poza stalymi stopami
   {
   // zapamietaj rozgrywke i plansz_p
   unsigned char* t1 = plansze.PrzydzielPlansze();
   unsigned char* t2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   KopiujTablice(t1, rozgrywka);
   KopiujTablice(t2, plansz_p);
   // przygotuj plansze z rozgrywka, usuwajac kropki wewnatrz stopow
   {
   unsigned int dokad=(wlkx+4)*(wlky+4);
   KopiujTablice(rozgr2, rozgrywka);
   for (unsigned int i=0; i<dokad; i++)
     if (plansz_p[i] & 0x33)  // pole jest wewnatrz stopu
       rozgr2[i]=0;           // wiec usun z niego ew. kropke
   }
   // przygotuj tablice z numerami skladowych (wersja 20+)
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   CzyscTablice(skl_tab);
   int margx_min=wlkx+2, margx_max=0, margy_min=wlky+2, margy_max=0;
   {
   unsigned int num_skl_n=1;
   unsigned int num_skl_p=30001;
   TDwaUC p;
   for (p.x=2; p.x<wlkx+2; p.x++)
    for (p.y=2; p.y<wlky+2; p.y++)
      {
      unsigned int indeks_ij = WezIndeksTab(p.x,p.y);
      unsigned char kr=rozgr2[indeks_ij];
      if (kr!=0)
        {
        if (p.x<margx_min) margx_min=p.x;
        if (p.x>margx_max) margx_max=p.x;
        if (p.y<margy_min) margy_min=p.y;
        if (p.y>margy_max) margy_max=p.y;
        if (skl_tab[indeks_ij]==0)
        if (kr==ktory_gracz)
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_n++, indeks_ij);
        else
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_p++, indeks_ij);
        }
      }
   }
   // przygotuj tablice z zapamietanymi premiami
   unsigned char* premie = plansze.PrzydzielPlansze();
   CzyscTablice(premie);
   if (poziom_gry>6)
     {
     for (int i=margx_min; i<=margx_max-2; i++)   // -2, bo 2 kropki na prawo musi byc kropka
      for (int j=margy_min; j<=margy_max; j++)
       {
       unsigned int indeks_ij = WezIndeksTab(i,j);
       unsigned int akt_s=skl_tab[indeks_ij];
       if (akt_s==0) continue;
       if (akt_s==WezUI(skl_tab,i+2,j+2))
         { // szansa! sa 2 kropki jednego koloru w opozycji przekatnej
         unsigned int inna_s=WezUI(skl_tab,i+1,j+1);
         if (inna_s!=0 &&
              ((inna_s <30000 && akt_s>=30000) ||
               (inna_s>=30000 && akt_s <30000)) )
           {
           // pozostaje sprawdzic, czy pola sa wolne
           if (i>2 && j<wlky-1 &&
                !WezUI(skl_tab,i-1,j+1) && !WezUI(skl_tab,i,j+1) &&
                !WezUI(skl_tab,i  ,j+2) && !WezUI(skl_tab,i+1,j+2) &&
                !WezUI(skl_tab,i+1,j+3))
             {
             WezUC(premie,i,j+2)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i-1,j+1)+=4;
               WezUC(premie,i  ,j+1)+=6;
               WezUC(premie,i+1,j+2)+=6;
               WezUC(premie,i+1,j+3)+=4;
               }
             }
           // a moze pola sa wolne po przeciwnej stronie?
           if (j>2 && i<wlkx-1 &&
                !WezUI(skl_tab,i+1,j-1) && !WezUI(skl_tab,i+1,j  ) &&
                !WezUI(skl_tab,i+2,j  ) && !WezUI(skl_tab,i+1,j+1) &&
                !WezUI(skl_tab,i+3,j+1))
             {
             WezUC(premie,i+2,j)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i+1,j-1)+=4;
               WezUC(premie,i+1,j  )+=6;
               WezUC(premie,i+2,j+1)+=6;
               WezUC(premie,i+3,j+1)+=4;
               }
             }
           }
         }
       // druga przekatna
       if (akt_s==WezUI(skl_tab,i+2,j-2))
         { // szansa! sa 2 kropki jednego koloru w opozycji przekatnej
         unsigned int inna_s=WezUI(skl_tab,i+1,j-1);
         if (inna_s!=0 &&
              ((inna_s <30000 && akt_s>=30000) ||
               (inna_s>=30000 && akt_s <30000)) )
           {
           // pozostaje sprawdzic, czy pola sa wolne
           if (i>2 && j>4 &&
                !WezUI(skl_tab,i-1,j-1) && !WezUI(skl_tab,i,j-1) &&
                !WezUI(skl_tab,i  ,j-2) && !WezUI(skl_tab,i+1,j-2) &&
                !WezUI(skl_tab,i+1,j-3))
             {
             WezUC(premie,i,j-2)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i-1,j-1)+=4;
               WezUC(premie,i  ,j-1)+=6;
               WezUC(premie,i+1,j-2)+=6;
               WezUC(premie,i+1,j-3)+=4;
               }
             }
           // a moze pola sa wolne po przeciwnej stronie?
           if (j<wlky+1 && i<wlkx-1 &&   // +1, -1 to nie pomylka
                !WezUI(skl_tab,i+1,j+1) && !WezUI(skl_tab,i+1,j  ) &&
                !WezUI(skl_tab,i+2,j  ) && !WezUI(skl_tab,i+2,j-1) &&
                !WezUI(skl_tab,i+3,j-1))
             {
             WezUC(premie,i+2,j)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i+1,j+1)+=4;
               WezUC(premie,i+1,j  )+=6;
               WezUC(premie,i+2,j-1)+=6;
               WezUC(premie,i+3,j-1)+=4;
               }
             }
           }
         }
       }
     }
   // znajdz zagrozenia
   krint *zagrozenia  = skladowe.PrzydzielSkladowa();
   krint *zagrozenia2 = skladowe.PrzydzielSkladowa();
   unsigned char* zagr_pola = plansze.PrzydzielPlansze();
   CzyscTablice(zagr_pola);
   int ile_zagrozen=0, ile_zagrozen2=0;
   {
   unsigned int indeks_zagrozen =0, ost_offset =(wlkx+4)*(wlky+4)-3;
   unsigned int indeks_zagrozen2=0, ost_offset2=(wlkx+4)*(wlky+4)-8;
   if (margx_min>2) margx_min--;
   if (margy_min>2) margy_min--;
   if (margx_max<wlkx+1) margx_max++;
   if (margy_max<wlky+1) margy_max++;
   for (int i=margx_min; i<=margx_max; i++)
    for (int j=margy_min; j<=margy_max; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if ((plansz_p[indeks_ij] & 15) ==0 &&
          rozgrywka[indeks_ij]==0)
      {
      unsigned char ot[9];
      // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
      WezOtoczenieUlatw(ot, i, j, rozgr2, 3-ktory_gracz);
      int is=UstawOtoczenie(ot), jest_zagr=0;
      if (is>=2)
        {
        int ile_zd=0, pow=0, pow2=0, punktacja_ss;
        ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz,
                    ile_zd,pow,pow2, punktacja_ss);
        if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	rozgrywka[indeks_ij]=0;  // usun kropke
        if (ile_zd>0 || pow>0)
          {
          jest_zagr=1;
          ile_zagrozen++;
          zagrozenia[indeks_zagrozen++]=(i<<8)+j;
          zagrozenia[indeks_zagrozen++]=ile_zd;
          zagrozenia[indeks_zagrozen++]=pow-pow2;
          if (indeks_zagrozen>ost_offset)
            goto Za_duzo_zagrozen;
          }
        if (ile_zd || pow || pow2)
          {
          int dokad=(wlkx+4)*(wlky+4);
          for (int i=dokad-1; i>=0; i--)
            if (plansz_p[i]!=t2[i])
              zagr_pola[i]=1;
          KopiujTablice(plansz_p, t2);
          }
        }
      // sprawdz, czy jest zagrozenie w dwoch ruchach
      if (!jest_zagr && poziom_gry>=6 && is>=1 &&
          indeks_zagrozen2<ost_offset2)
        {
        WezUC(rozgrywka,i,j)=3-ktory_gracz;  // postaw kropke
        WezUC(rozgr2   ,i,j)=3-ktory_gracz;  // postaw kropke
        int ile_ruchow=0;
        for (int dy=-1; dy<=1; dy++)
         for (int dx=-1; dx<=1; dx++)
           {
           int nx=i+dx, ny=j+dy;
           unsigned int indeks = WezIndeksTab(nx,ny);
           if (upl_marg[indeks]>=2 &&          // jest w planszy
               (plansz_p[indeks] & 15)==0 &&   // nie wewnatrz stopu
                rozgrywka[indeks]==0)          // nie ma tu kropki
             {
             unsigned char oto[9];
             WezOtoczenieUlatw(oto, nx, ny, rozgr2, 3-ktory_gracz);
             unsigned char is=UstawOtoczenie(oto);
             if (is>=2)
               {
               // szansa na stop
               int ile_zd=0, pow=0, pow2=0, punktacja_ss;
               ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, nx,ny, 3-ktory_gracz,
                           ile_zd,pow,pow2, punktacja_ss);
	       // if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	       if (ile_zd)
                 {
                 if (ile_ruchow==0)
                   {
                   zagrozenia2[indeks_zagrozen2+1]=(i<<8)+j;
                   zagrozenia2[indeks_zagrozen2+2]=ile_zd;
                   zagrozenia2[indeks_zagrozen2+3]=(nx<<8)+ny;
                   }
                 else
                   {
                   zagrozenia2[indeks_zagrozen2+3+ile_ruchow]=(nx<<8)+ny;
                   if (ile_zd > zagrozenia2[indeks_zagrozen2+2])
                     zagrozenia2[indeks_zagrozen2+2] = ile_zd;
                   }
                 ile_ruchow++;
                 }
               // odtworz
               if (ile_zd || pow || pow2)
                 KopiujTablice(plansz_p, t2);
               rozgrywka[indeks]=0;
               }
             }
           }
        //
        if (ile_ruchow>=2)
          {
          // naprawde jest zagrozenie
          zagrozenia2[indeks_zagrozen2]=ile_ruchow;
          indeks_zagrozen2+=(3+ile_ruchow);
          ile_zagrozen2++;
          }
        rozgrywka[indeks_ij]=0;  // usun kropke
        rozgr2[indeks_ij]=0;  // usun kropke
        }
      }
     }
   }
   Za_duzo_zagrozen:;
   // analizuj kolejne ruchy
   TRuch najl_ruchy[2];
   int ile_najl=0;
   najl_ruchy[0].ocena=-1000000000l;   // w praktyce to
   najl_ruchy[1].ocena=-1000000000l;   // jest -nieskonczonosc
   {
   for (int i=2; i<wlkx+2; i++)
    for (int j=2; j<wlky+2; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if ((plansz_p[indeks_ij] & 15) ==0 &&
          rozgrywka[indeks_ij]==0)
      {
      unsigned char ot[9];
      // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
      WezOtoczenieUlatw(ot, i, j, rozgr2, ktory_gracz);
      unsigned char ile_skl= UstawOtoczenie(ot);
      long int ocena=ile_skl+ile_skl;
      int odtworz_pp=0;
      int sa_zagr=0;
      if (ile_skl>=2)
        {
        // jest szansa na stop
        int ile_zd=0, pow=0, pow2=0, punktacja_ss;
        ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j, ktory_gracz,
                    ile_zd,pow,pow2, punktacja_ss);
	if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	ocena+=100l*ile_zd;
        ocena+= 30l*(pow-pow2);
        if (ile_zd || pow || pow2)
          {
          // sprawdz zagrozenia
          long int ocena_przec=0;
          unsigned int ind_zagr=0;
          unsigned char *pom=plansze.PrzydzielPlansze();
          KopiujTablice(pom, plansz_p);
          for (int z=0; z<ile_zagrozen; z++)
            {
            int x=(zagrozenia[ind_zagr] >> 8);
            int y=(zagrozenia[ind_zagr] & 0xff);
            //int straty=zagrozenia[ind_zagr++];
            //int straty_st_st=zagrozenia[ind_zagr++];
            ind_zagr+=3;
            if ((WezUC(plansz_p,x,y) & 15) ==0 && (x!=i || y!=j))
              {
              // trzeba sprawdzic zagrozenie
              int pom_int=0, straty=0, straty_st_st=0, punktacja_ss;
              ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, x,y,3-ktory_gracz,
                          straty,straty_st_st,pom_int,punktacja_ss);
	      if (umiejetnosci & 0x10) 
		straty_st_st=punktacja_ss;
	      else
		straty_st_st-=pom_int;
              long int tymcz=100l*straty + 30l*straty_st_st;
              //if (!sa_zagr) sa_zagr=(straty!=0);
               if (straty!=0) sa_zagr++;
              if (straty && tymcz>ocena_przec)  // stale stopy olewamy
                ocena_przec=tymcz;
              // odtworz
              KopiujTablice(plansz_p, pom);
              WezUC(rozgrywka,x,y)=0;
              }
            }
          ocena-=ocena_przec;
          plansze.ZwolnijPlansze(pom);
          //memcpy(plansz_p, t2, (wlkx+4)*(wlky+4));
          odtworz_pp=1;
          }
        else
          {
          //WezUC(rozgrywka,i,j)=0;  // usun kropke
          goto Zadnych_nowych_stopow;
          }
        //WezUC(rozgrywka,i,j)=0;  // usun kropke
        }
      else
        {
        Zadnych_nowych_stopow:
        // nie doszly zadne (stale) stopy
        long int ocena_przec=0;
        unsigned int ind_zagr=0;
        for (int z=0; z<ile_zagrozen; z++)
          {
          int x=(zagrozenia[ind_zagr] >> 8);
          int y=(zagrozenia[ind_zagr++] & 0xff);
          int straty=zagrozenia[ind_zagr++];
          int straty_st_st=zagrozenia[ind_zagr++];
          if (x!=i || y!=j)  // nie zlikwidowalismy zagrozenia
            {
            long int tymcz=100l*straty + 30l*straty_st_st;
            if (straty && tymcz>ocena_przec)  // stale stopy olewamy
              ocena_przec=tymcz;
            //if (!sa_zagr) sa_zagr=(straty!=0);
            if (straty!=0) sa_zagr++;
            }
          }
        // sprawdz, czy kropka nie zostanie od razu zamknieta
        if (WezUC(zagr_pola,i,j))
          {
          ocena_przec+=100;
          //sa_zagr++; //=1;
          }
        ocena-=ocena_przec;
        }
      // odejmij punkty za zagrozenia
      ocena-=5*sa_zagr;
      // a teraz sprawdz stopy w 2 ruchach
      int sa_mozl2=0;
      if (ile_skl>=1 && poziom_gry>=4 && !sa_zagr)
        {
        WezUC(rozgrywka,i,j)=ktory_gracz;  // postaw kropke
        WezUC(rozgr2   ,i,j)=ktory_gracz;  // postaw kropke
        unsigned char *pom=plansze.PrzydzielPlansze();
        KopiujTablice(pom, plansz_p);
        long int ocena_max1=-1000000000l, ocena_max2=-1000000000l;
        for (int dy=-1; dy<=1; dy++)
         for (int dx=-1; dx<=1; dx++)
           {
           int nx=i+dx, ny=j+dy;
           unsigned int indeks = WezIndeksTab(nx,ny);
           if (upl_marg[indeks]>=2 &&          // jest w planszy
               (plansz_p[indeks] & 15)==0 &&   // nie wewnatrz stopu
                rozgrywka[indeks]==0)          // nie ma tu kropki
             {
             unsigned char oto[9];
             //WezOtoczenie(oto, nx, ny, plansz_p, rozgrywka, ktory_gracz);
             WezOtoczenieUlatw(oto, nx, ny, rozgr2, ktory_gracz);
             unsigned char is=UstawOtoczenie(oto);
             if (is>=2)
               {
               // szansa na stop
               int ile_zd=0, pow=0, pow2=0, punktacja_ss;
               ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, nx,ny, ktory_gracz,
                           ile_zd,pow,pow2, punktacja_ss);
	       if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	       long int tymcz = 45l*ile_zd + 3l*(pow-pow2);
               if (tymcz>ocena_max1)
                 {
                 ocena_max2=ocena_max1;
                 ocena_max1=tymcz;
                 }
               else
                 if (tymcz>ocena_max2)
                   ocena_max2=tymcz;
               // odtworz
               if (ile_zd || pow || pow2)
                 KopiujTablice(plansz_p, pom);
               rozgrywka[indeks]=0;
               }
             }
           }
        //
        if (ocena_max1>-1000000000l) ocena+=ocena_max1;
        if (ocena_max2>-1000000000l)
          {
          ocena+=ocena_max2;
          sa_mozl2=1;
          }
        plansze.ZwolnijPlansze(pom);
        }
      if (odtworz_pp)
        KopiujTablice(plansz_p, t2);
      rozgrywka[indeks_ij]=0;  // usun kropke
      rozgr2[indeks_ij]=0;  // usun kropke
      // sprawdz zagrozenia w dwoch ruchach
      if (!sa_mozl2 && !sa_zagr && ile_zagrozen2)
        {
        unsigned int ind_zagr=0;
        for (int z=0; z<ile_zagrozen2; z++)
          {
          int ile_ruchow=zagrozenia2[ind_zagr++];
          int x=(zagrozenia2[ind_zagr] >> 8);
          int y=(zagrozenia2[ind_zagr++] & 0xff);
          int straty=zagrozenia2[ind_zagr++];
          if (x!=i || y!=j)  // nie zlikwidowalismy zagrozenia
            {
            int ile_zneutr=0;
            for (int nz=0; nz<ile_ruchow; nz++)
              {
              x=(zagrozenia2[ind_zagr] >> 8);            // wersja 80z3: General Protection Error
              y=(zagrozenia2[ind_zagr++] & 0xff);
              if (x==i && y==j)
                ile_zneutr++;   // zlikwidowalismy zagrozenie
              }
            if (ile_ruchow-ile_zneutr <=1)
              ocena+=17*straty;   // punkty za zlikwidowanie zagrozenia
            }
          else
            {
            ind_zagr+=ile_ruchow;               // dodane w wersji 80z3
            // punkty za zlikwidowanie zagrozenia
            ocena+=34*straty;
            }
          }
        }
      // a teraz dodatkowo "ocena intuicyjna"
      if (poziom_gry>=8)
      {
      unsigned int skl[8];
      int ile_skl_n=0, ile_skl_p=0, ile_razem=0;
      for (int dy=-1; dy<=1; dy++)
       for (int dx=-1; dx<=1; dx++)
         {
         int nx=i+dx, ny=j+dy;
         unsigned int s=WezUI(skl_tab, nx,ny);
         if (s)
           {
           for (int i=0; i<ile_razem; i++)
             if (skl[i]==s) goto Nast_punkt;
           if (WezUC(rozgr2,nx,ny)==ktory_gracz)
             ile_skl_n++;
           else
             ile_skl_p++;
           skl[ile_razem++]=s;
           }
         Nast_punkt:;
         }
      if (ile_skl_n>1)
        ocena+=3*(ile_skl_n-1); // punkty za laczenie wlasnych skladowych
      if (ile_skl_p>1)
        ocena+=5*(ile_skl_p-1); // punkty za utrudnianie przeciwnikowi laczenia
      }
      if (poziom_gry>6)
        ocena+=4*premie[indeks_ij];
      if (ile_skl>=1)
        {
        int lewo  = (ot[3] == ktory_gracz);
        int prawo = (ot[5] == ktory_gracz);
        int gora  = (ot[1] == ktory_gracz);
        int dol   = (ot[7] == ktory_gracz);
        if (lewo && gora)
          {
          if (ot[0]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[0]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (gora && prawo)
          {
          if (ot[2]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[2]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (prawo && dol)
          {
          if (ot[8]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[8]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (dol && lewo)
          {
          if (ot[6]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[6]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        }
      if (ile_skl==1)
        {
        if (ot[0]==ktory_gracz &&
          (WezUC(plansz_p,i-2,j) & 3)==0 &&
          WezUC(rozgrywka,i-2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j-2) & 3)==0 &&
          WezUC(rozgrywka,i,j-2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[2]==ktory_gracz &&
          (WezUC(plansz_p,i+2,j) & 3)==0 &&
          WezUC(rozgrywka,i+2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j-2) & 3)==0 &&
          WezUC(rozgrywka,i,j-2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[8]==ktory_gracz &&
          (WezUC(plansz_p,i+2,j) & 3)==0 &&
          WezUC(rozgrywka,i+2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j+2) & 3)==0 &&
          WezUC(rozgrywka,i,j+2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[6]==ktory_gracz &&
          (WezUC(plansz_p,i-2,j) & 3)==0 &&
          WezUC(rozgrywka,i-2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j+2) & 3)==0 &&
          WezUC(rozgrywka,i,j+2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        }
      /*
      if (ile_skl==1)  // premia za linie
        {
        if (ot[0] &&
          (WezUC(plansz_p,i-2,j-2) & 3)==0 &&
          WezUC(rozgrywka,i-2,j-2)==ktory_gracz)
          ocena++;
        if (ot[2] &&
          (WezUC(plansz_p,i+2,j-2) & 3)==0 &&
          WezUC(rozgrywka,i+2,j-2)==ktory_gracz)
          ocena++;
        if (ot[6] &&
          (WezUC(plansz_p,i-2,j+2) & 3)==0 &&
          WezUC(rozgrywka,i-2,j+2)==ktory_gracz)
          ocena++;
        if (ot[8] &&
          (WezUC(plansz_p,i+2,j+2) & 3)==0 &&
          WezUC(rozgrywka,i+2,j+2)==ktory_gracz)
          ocena++;
        } */
      // kara za duza odleglosc od kropki przeciwnika
      {
      int odl_x=i-st_x;            // tu bylo x zamiast st_x (wersje do 36)
      if (odl_x<0) odl_x=-odl_x;
      int odl_y=j-st_y;            // a tu y zamiast st_y    (wersje do 36)
      if (odl_y<0) odl_y=-odl_y;
      odl_x+=odl_y;
      if (odl_x>2) ocena--;
      if (odl_x>8) ocena--;
      if (odl_x>20) ocena--;
      if (odl_x>50) ocena--;
      }
      // sprawdz, jak dobry jest ten ruch
      if (ile_najl==2)
        {
        if (ocena>najl_ruchy[1].ocena)
          if (ocena>najl_ruchy[0].ocena)
            {
            najl_ruchy[1]=najl_ruchy[0];
            najl_ruchy[0].ocena=ocena;
            najl_ruchy[0].x    =i;
            najl_ruchy[0].y    =j;
            }
          else
            {
            najl_ruchy[1].ocena=ocena;
            najl_ruchy[1].x    =i;
            najl_ruchy[1].y    =j;
            }
        }
      else
        if (ile_najl==1 && ocena>najl_ruchy[0].ocena)
          {
          najl_ruchy[1]=najl_ruchy[0];
          najl_ruchy[0].ocena=ocena;
          najl_ruchy[0].x    =i;
          najl_ruchy[0].y    =j;
          }
        else
          {
          najl_ruchy[ile_najl].ocena=ocena;
          najl_ruchy[ile_najl].x    =i;
          najl_ruchy[ile_najl++].y    =j;
          }
      }
     }
   }
   if (poziom_gry==9)
     {
     int kt=0;
     if (ile_najl==2 && najl_ruchy[0].ocena==najl_ruchy[1].ocena)
       kt=random(2);
     x=najl_ruchy[kt].x;
     y=najl_ruchy[kt].y;
     }
   else
     {
     int ile = random(10000);
     if (ile>6000+poziom_gry*400 && ile_najl==2)
       {
       x=najl_ruchy[1].x;
       y=najl_ruchy[1].y;
       }
     else
       {
       x=najl_ruchy[0].x;
       y=najl_ruchy[0].y;
       }
     }
   plansze.ZwolnijPlansze(t1);
   plansze.ZwolnijPlansze(t2);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(zagr_pola);
   plansze.ZwolnijPlansze(premie);
   skladowe.ZwolnijSkladowa(zagrozenia);
   skladowe.ZwolnijSkladowa(zagrozenia2);
   skladowe.ZwolnijSkladowa(skl_tab);
   return;
   }
 else if (ile_wolnego) {
   GraKoncowa(rozgrywka, plansz_p, ktory_gracz, x, y, st_x, st_y);
   if (x!=0) return;
 }
 x=-1; y=-1;
}

//*****************************************************************************
// metody:
void TGraczO::DodajTekstCzas(char *s)
  // dodaje tekst ozn. ograniczenie czasowe do s
  // lub  ".bo"  (skrot od bez ograniczen)
{
  switch (czas_kiedy)
    {
    case 1: strcpy(s, "/g");  break;  // po kazdej glebokosci
    case 2: strcpy(s, "/r");  break;  // po kazdym ruchu
    case 3: strcpy(s, "/z");  break;  // zawsze
    default:  return;   // bez ograniczen
    }
  // dodaj czas
  if (czas_sek==0)
    { strcpy(&s[2], "1s");  return; }
  int ile_s = czas_sek + (czas_ssek>=50);
  if (ile_s<100 && ile_s!=60)
    { sprintf(&s[2], "%ds", ile_s); return; }
  int ile_m = ile_s/60 + (ile_s % 60 >=30);
  if (ile_m<100 && ile_m!=60)
    { sprintf(&s[2], "%dm", ile_m); return; }
  int ile_h = ile_m/60 + (ile_m % 60 >=30);
  if (ile_h<100 && ile_h % 24)
    { sprintf(&s[2], "%dh", ile_h); return; }
  int ile_d = ile_h/24 + (ile_h % 24 >=12);
  sprintf(&s[2], "%dd", ile_d);
}
 
void TGraczO::UstawImie()
// wstawia nazwe gracza komputerowego do pola imie_k
{
  memset(imie_k, 0, sizeof(imie_k));
  if (poziom_gry<=11) {
    sprintf(imie_k[0], "p%d", int(poziom_gry));
    if (poziom_gry==11) {
      if (wagi_n.sk+wagi_p.sk!=24)
	sprintf(&imie_k[0][strlen(imie_k[0])], "/%d-%d",
		int(wagi_n.sk), int(wagi_p.sk));
      else
	sprintf(&imie_k[0][strlen(imie_k[0])], "/%d", int(wagi_p.sk-12));
       int sa_um=0;
      if (umiejetnosci & 4)
	{ strcat(imie_k[0], "/m");  sa_um=1; }
      if (umiejetnosci & 0x10)
	if (sa_um) strcat(imie_k[0], "b");
	else { strcat(imie_k[0], "/b");  sa_um=1; }
      // ustaw imie 1
      sprintf(imie_k[1], "z%d-%d k=%d", int(wagi_n.zd), int(wagi_p.zd),
	      int(waga_kropki));
    }
    else {   // poziom 0-9
      if (umiejetnosci & 0x10)
	strcat(imie_k[0], "b");
    }
  }
  else {  // poziom 12
    sprintf(imie_k[0], "%d", int(dokl_analizy));
    if (dokl_analizy>=2 && (umiejetnosci & 0x100)) strcat(imie_k[0],"q");
    else if ((sex_limit || sex_limit_podw) && dokl_analizy>=4)
      strcat(imie_k[0],"+");
    if ((sex_limit || sex_limit_podw) && dokl_analizy>=4) {
      sprintf(&imie_k[0][strlen(imie_k[0])], "%d", int(sex_limit));
      if (sex_limit_podw)
	sprintf(&imie_k[0][strlen(imie_k[0])], "+%d", int(sex_limit_podw));
    }
    DodajTekstCzas(&imie_k[0][strlen(imie_k[0])]);
    const char styl_gry[3][2] = {"A","n","D"};
    if (czas_kiedy || ekran.CzyKrotkieImie()) strcat(imie_k[0], "/");
    if (funkcja_sk>0 && funkcja_sk<6) {
      const char literki[][2]  = {"0","u",".","x","t","T"};
      if (!czas_kiedy && !ekran.CzyKrotkieImie()) strcat(imie_k[0], literki[funkcja_sk]);
      if (wagi_n.sk+wagi_p.sk!=24)
	strcat(imie_k[0], styl_gry[(wagi_n.sk>wagi_p.sk) + (wagi_n.sk>=wagi_p.sk)]);
      else
	sprintf(&imie_k[0][strlen(imie_k[0])], "%d", int(wagi_p.sk-12));
      if (czas_kiedy || ekran.CzyKrotkieImie()) strcat(imie_k[0], literki[funkcja_sk]);
    }
    if (!czas_kiedy && !ekran.CzyKrotkieImie()) {  // dodaj jeszcze umiejetnosci
      sprintf(&imie_k[0][strlen(imie_k[0])], ":%d", int(waga_kropki));
      int sa_um=0;
      if (umiejetnosci & 0x20)     // antywaz
	{ strcat(imie_k[0], "o");  sa_um=1; }
      if (umiejetnosci & 0x40)     // antywaz
	{ strcat(imie_k[0], "s");  sa_um=1; }
      if (umiejetnosci & 0x80)     // antywaz
	{ strcat(imie_k[0], "u");  sa_um=1; }
      if (umiejetnosci & 0x10)
	{ strcat(imie_k[0], "b");  sa_um=1; }
      if (umiejetnosci & 0x200)
	{ strcat(imie_k[0], "B");  sa_um=1; }
      if (Bouzy_dil>0)
	if (waga_latwe_pole>0)
	  { strcat(imie_k[0], "P");  sa_um=1; }
	else
	  { strcat(imie_k[0], "p");  sa_um=1; }
      else
	if (waga_latwe_pole>0)
	  { strcat(imie_k[0], "l");  sa_um=1; }
      if (!sa_um) strcat(imie_k[0], "(nic)");
      sprintf(&imie_k[0][strlen(imie_k[0])], "%d", testowe); 
    }
    // teraz imie 1
    sprintf(imie_k[1], "z%d-%d", int(wagi_n.zd), int(wagi_p.zd));
    if (funkcja_sk>0 && funkcja_sk<6)
      if (wagi_n.sk+wagi_p.sk!=24)
	sprintf(&imie_k[1][strlen(imie_k[1])], "/s%d-%d", int(wagi_n.sk), int(wagi_p.sk));
      else
	sprintf(&imie_k[1][strlen(imie_k[1])], "/%d", int(wagi_p.sk-12));
    int nr=2;
    if (Bouzy_dil)
      sprintf(imie_k[nr++], "B%d,%d: %d-%d %c", int(Bouzy_dil), int(Bouzy_er),
	      int(wagi_n.Bo), int(wagi_p.Bo),
	      (opcje_Bouzy & 1) ? 'j':' ');
    sprintf(imie_k[nr], "k=%d l=%d", int(waga_kropki), int(waga_latwe_pole));
    sprintf(&imie_k[nr][strlen(imie_k[nr])], " N%dP%d%c%c um=", int(listy_ruchow[0]), int(listy_ruchow[1]),
	    (listy_ruchow[2] ? 'U':'u'), (listy_ruchow[3] ? 'L':'l')); 
    int sa_um=0;
    if (umiejetnosci & 0x20)     // antywaz
      { strcat(imie_k[nr], "o");  sa_um=1; }
    if (umiejetnosci & 0x40)     // antywaz
      { strcat(imie_k[nr], "s");  sa_um=1; }
    if (umiejetnosci & 0x80)     // antywaz
      { strcat(imie_k[nr], "u");  sa_um=1; }
    if (umiejetnosci & 0x10)
      { strcat(imie_k[nr], "b");  sa_um=1; }
    if (umiejetnosci & 0x200)
      { strcat(imie_k[nr], "B");  sa_um=1; }
    if (!sa_um) strcat(imie_k[nr], "(nic)");
    sprintf(&imie_k[nr][strlen(imie_k[nr])], "%d", testowe); 
  }
}

int TGraczO::Wstaw(unsigned char *s)
// Wstawia informacje o graczu z lancucha s, dlugosci 48 bajtow.
// W ,,s'' jest gracz w starym formacie TGracz, uzywanym
// jeszcze w plikach.
// Zwraca 1, gdy lancuch definiuje znanego gracza.
// Uwaga: nie zmienia imienia czlowieka, gdy gra komputer, ani parametrow kompa,
//        gdy gra czlowiek.
{
 if (s[0]==0 && s[1]==0)  // czlowiek?
   {
   komputer=0;
   s[39]=0;   // na wszelki wypadek, gdyby nie konczyl sie zerem
   strcpy(imie, (char*) &s[10]);
   return 1;
   }
 komputer=1;
 // poziom gry
 short int i= s[2] + (int(s[3])<<8);
 if (i>=0 && i<=12 && i!=10)
   poziom_gry=i;
 else return 0;
 int agresja;
 i= s[4] + (int(s[5])<<8);
 if (i>=-3 && i<=3)
   agresja = i*3;
 else if (i>=13 && i<=32)  // ,,nowa agresja''
   agresja = i-22;
 else return 0;   // zle ustawiona agresja
 wagi_n.sk = 12-agresja;   wagi_p.sk = 12+agresja;
 int przejmuje_sie;
 i= s[6] + (int(s[7])<<8);
 static int wsp_przejmuje_sie_tab[4]={32,40,51,64};
 if (i>=1 && i<=4)
   przejmuje_sie = wsp_przejmuje_sie_tab[i-1];
 else if (i>=30 && i<=129)
   przejmuje_sie = i;
 else return 0;   // zle ustawione przejmuje sie
 wagi_n.zd = przejmuje_sie*wagi_p.sk;   wagi_p.zd = przejmuje_sie*wagi_n.sk;
 // dokladnosc analizy
 i= s[8] + (int(s[9])<<8);
 if (i>=0 && i<=MAX_GLEB_ANALIZY-13)
   dokl_analizy=i >? 2;
 else return 0;   // zle ustawiona dokladnosc analizy
 // umiejetnosci
 i= s[46] + (int(s[47])<<8);
 funkcja_sk = (i&8) ? 3:2;
 i|=1;  i&=~(2|8);
 if (i & ~(1|2|4|8|0x10|0x20|0x40|0x80|0x100|0x200))
   return 0;      // zle ustawione umiejetnosci
 else umiejetnosci=i;
 waga_kropki=5;
 czas_kiedy=0;
 sex_limit= sex_limit_podw=0;
 Bouzy_dil=0;
 for (int i=0; i<4; i++) listy_ruchow[i]=0;
 UstawImie();
 return 1;
}


TGraczO& TGraczO::operator&=(TGraczO g)
// kopiuje informacje o graczu: jesli jest czlowiekiem, to tylko imie,
// jesli komputerem, to wszystko oprocz imienia
{
 if (komputer=g.komputer)  // ma byc =
   {
   poziom_gry  =g.poziom_gry;
   dokl_analizy=g.dokl_analizy;
   funkcja_sk  =g.funkcja_sk;
   Bouzy_dil   =g.Bouzy_dil;
   Bouzy_er    =g.Bouzy_er;
   opcje_Bouzy =g.opcje_Bouzy;
   waga_latwe_pole = g.waga_latwe_pole;
   czas_sek    =g.czas_sek;
   czas_ssek   =g.czas_ssek;
   czas_kiedy  =g.czas_kiedy;
   umiejetnosci=g.umiejetnosci;
   waga_kropki =g.waga_kropki;
   wagi_n      =g.wagi_n;
   wagi_p      =g.wagi_p;
   sex_limit   =g.sex_limit;
   sex_limit_podw =g.sex_limit_podw;
   testowe     =g.testowe;
   for (int i=0; i<4; i++) listy_ruchow[i]=g.listy_ruchow[i];   
   memcpy(imie_k, g.imie_k, sizeof(imie_k));
   }
 else
   strcpy(imie, g.imie);
 return *this;
}


short int ShortInt(unsigned char *b)
{
  short int w = b[1];
  w <<= 8;
  return (w| b[0]);
}
long int LongInt(unsigned char *b)
{
  long int w = b[3];
  w <<= 8;
  w |= b[2];
  w <<= 8;
  w |= b[1];
  w <<= 8;
  return (w| b[0]);
}
int ZapiszSI(unsigned char* buf, short int n)
{
  buf[0]= (n & 0xff);
  buf[1]= (n >> 8);
  return 2;
}
int ZapiszLI(unsigned char* buf, long int n)
{
  buf[0]= (n & 0xff);
  buf[1]= (n >> 8) & 0xff;
  buf[2]= (n >> 16) & 0xff;
  buf[3]= (n >> 24);
  return 4;
}

void TGraczO::Zapisz(FILE *f)
{
  unsigned char buf[120];
  int ile=0;
  ile += ZapiszSI(&buf[ile], komputer);
  ile += ZapiszSI(&buf[ile], poziom_gry);
  ile += ZapiszSI(&buf[ile], dokl_analizy);
  ile += ZapiszSI(&buf[ile], funkcja_sk);
  ile += ZapiszSI(&buf[ile], Bouzy_dil);
  ile += ZapiszSI(&buf[ile], Bouzy_er);
  ile += ZapiszLI(&buf[ile], czas_sek);
  ile += ZapiszLI(&buf[ile], czas_ssek);
  ile += ZapiszLI(&buf[ile], czas_kiedy);
  ile += ZapiszLI(&buf[ile], umiejetnosci);
  ile += ZapiszLI(&buf[ile], waga_kropki);
  ile += ZapiszLI(&buf[ile], wagi_n.zd);
  ile += ZapiszLI(&buf[ile], wagi_n.sk);
  ile += ZapiszLI(&buf[ile], wagi_n.Bo);
  ile += ZapiszLI(&buf[ile], wagi_p.zd);
  ile += ZapiszLI(&buf[ile], wagi_p.sk);
  ile += ZapiszLI(&buf[ile], wagi_p.Bo);
  ile += ZapiszSI(&buf[ile], sex_limit);
  ile += ZapiszSI(&buf[ile], sex_limit_podw);
  ile += ZapiszLI(&buf[ile], testowe);
  ile += ZapiszSI(&buf[ile], opcje_Bouzy );
  ile += ZapiszSI(&buf[ile], waga_latwe_pole);
  for (int i=0; i<4; i++)
    buf[ile++] = listy_ruchow[i];
  for (int i=0; i<12; i++)
    ile += ZapiszLI(&buf[ile], zapasowe[i]);
  assert(ile==sizeof(buf));
  fwrite(buf, 1, ile, f);
  fwrite(imie, 1, sizeof(imie), f);
  fwrite(imie_k, 1, sizeof(imie_k), f);
}

int TGraczO::Odczytaj(FILE *f)
  // zwraca 0, gdy blad; 1 gdy ok
{
  TGraczO pom;
  unsigned char buf[sizeof(TGraczO)];
  if (fread(&buf, 1, sizeof(TGraczO),f)!=sizeof(TGraczO))
    return 0;
  // wstaw buf do pom
  memcpy(&pom, buf, sizeof(pom));
//#ifdef HOST_WORDS_BIG_ENDIAN
  pom.komputer = ShortInt(&buf[0]);
  pom.poziom_gry = ShortInt(&buf[2]);
  pom.dokl_analizy = ShortInt(&buf[4]);
  pom.funkcja_sk = ShortInt(&buf[6]);
  pom.Bouzy_dil = ShortInt(&buf[8]);
  pom.Bouzy_er = ShortInt(&buf[10]);

  pom.czas_sek = LongInt(&buf[12]);
  pom.czas_ssek = LongInt(&buf[16]);
  pom.czas_kiedy = LongInt(&buf[20]);
  pom.umiejetnosci = LongInt(&buf[24]);
  pom.waga_kropki = LongInt(&buf[28]);
  pom.wagi_n.zd = LongInt(&buf[32]);
  pom.wagi_n.sk = LongInt(&buf[36]);
  pom.wagi_n.Bo = LongInt(&buf[40]);
  pom.wagi_p.zd = LongInt(&buf[44]);
  pom.wagi_p.sk = LongInt(&buf[48]);
  pom.wagi_p.Bo = LongInt(&buf[52]);

  pom.sex_limit = ShortInt(&buf[56]);
  pom.sex_limit_podw = ShortInt(&buf[58]);
  pom.testowe = LongInt(&buf[60]);
  pom.opcje_Bouzy = ShortInt(&buf[64]);
  pom.waga_latwe_pole = ShortInt(&buf[66]);
  //  signed char listy_ruchow[4];   // nasze, przec, przedost, lisc
  for (int i=0; i<12; i++)
    pom.zapasowe[i] = LongInt(&buf[72+4*i]);
//#endif  
  *this &= pom;
  return 1;
}

void TKalendarzRozgr::KazdyZKazdym(int ile_graczy)
{
 int wkol=(ile_graczy+1)/2;
 int nieparz = ile_graczy%2;
 int ost=0, pocz_kol=0;
 int dzielnik = ile_graczy-1+nieparz;
 int im=((ile_graczy-1)*(ile_graczy)) / 2;
 rozgr_w_sezonie = 2*im;
 if (mecze!=NULL) delete[] mecze;
 mecze = new TMecz[rozgr_w_sezonie];
 for (int kol=1; kol<=dzielnik; kol++)
   {
   for (int m=nieparz; m<wkol; m++)
     mecze[pocz_kol+m-nieparz].g1 = (ost+m) % dzielnik;
   ost = (ost+wkol) % dzielnik;
   for (int m=1; m<wkol; m++)
     mecze[pocz_kol+wkol-m-nieparz].g2 = (ost+m-1) % dzielnik;
   if (!nieparz)
     if (kol%2)
       mecze[pocz_kol].g2=ile_graczy-1;
     else
       {
       mecze[pocz_kol].g2=mecze[pocz_kol].g1;
       mecze[pocz_kol].g1=ile_graczy-1;
       }
   pocz_kol+=wkol-nieparz;
   }
 // dorob rewanze
 for (int i=0; i<im; i++)
   {
   mecze[im+i].g1 = mecze[im-1-i].g2;
   mecze[im+i].g2 = mecze[im-1-i].g1;
   }
}

TKalendarzRozgr& TKalendarzRozgr::operator=(TKalendarzRozgr& arg)
{
  if (mecze!=NULL) delete[] mecze;
  mecze = new TMecz[rozgr_w_sezonie = arg.rozgr_w_sezonie];
  memcpy(mecze, arg.mecze, sizeof(mecze[0])*rozgr_w_sezonie);
}

int TKalendarzRozgr::Odczytaj(FILE *f)
  // zwraca 0, gdy blad
{
  if (mecze!=NULL) delete[] mecze;
  unsigned char buf[4];
  // fread(&rozgr_w_sezonie, sizeof(rozgr_w_sezonie), 1, f);
  fread(buf, 1,2,f);
  rozgr_w_sezonie = ShortInt(buf);
  if (rozgr_w_sezonie<=0) return 0;
  mecze = new TMecz[rozgr_w_sezonie];
  // fread(mecze, sizeof(TMecz), rozgr_w_sezonie, f);
  for (int i=0; i<rozgr_w_sezonie; i++) {
    fread(buf, 1,4,f);
    mecze[i].g1 = ShortInt(&buf[0]);
    mecze[i].g2 = ShortInt(&buf[2]);
  }
  return 1;
}

int TKalendarzRozgr::Zapisz(FILE *f)
  // zwraca 0, gdy blad
{
  if (mecze!=NULL && rozgr_w_sezonie>0) {
    unsigned char buf[4];
    buf[0] = (rozgr_w_sezonie & 0xff);
    buf[1] = (rozgr_w_sezonie >> 8);
    fwrite(buf, 1,2,f);  //  fwrite(&rozgr_w_sezonie, sizeof(rozgr_w_sezonie), 1, f);
    for (int i=0; i<rozgr_w_sezonie; i++) {
      buf[0] = (mecze[i].g1 & 0xff);
      buf[1] = (mecze[i].g1 >> 8);
      buf[2] = (mecze[i].g2 & 0xff);
      buf[3] = (mecze[i].g2 >> 8);
      fwrite(buf, 1,4,f);
    }    // fwrite(mecze, sizeof(TMecz), rozgr_w_sezonie, f);
    return 1;
  }
  return 0;
}
 
void TTurniej::Zapisz()
// zapisuje akt. rozgrywke
{
 FILE *f=fopen(nazwa_t, "r+b");
 fseek(f, offset_rozgr + dlug_rozgr*
       (long(kalendarz.rozgr_w_sezonie)*ktory_sezon+ktory_mecz), SEEK_SET);
 gra.ZapiszRozgr(f, ktory_sezon, ktory_mecz);
 fclose(f);
}

inline int TTurniej::KtoryMecz()
{ return ktory_mecz; }

inline int  TTurniej::KtorySezon()
{ return ktory_sezon; }

void TTurniej::NowyMecz()
  // zaklada, ze aktualny mecz jest zakonczony i zapisany!
{
 if (++ktory_mecz == kalendarz.rozgr_w_sezonie)  { ktory_sezon++;  ktory_mecz=0; }
}

void TTurniej::WezGraczyWAktMeczu(TGraczO *gr)
{
 gr[0]&= gracze[ kalendarz.mecze[ktory_mecz].g1 ];
 gr[1]&= gracze[ kalendarz.mecze[ktory_mecz].g2 ];
}

int TTurniej::OdczytajNagl()
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje graczy, kalendarz i inne zmienne
//       i OTWIERA plik f!
{
 f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, gracze);
 if (jaki!=12) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 offset_rozgr=ftell(f);
 dlug_rozgr = 80+2*plx*ply;  // zob. TGra::ZapiszRozgr()
 return 1;
}

void TTurniej::UstawMecz(int nrs, int nrm)
{
  fseek(f,offset_rozgr+(nrs*kalendarz.rozgr_w_sezonie+nrm)*dlug_rozgr ,SEEK_SET);
}

int TTurniej::OdczytajInfoOMeczu(TMecz& m, int tylko_gra_srodkowa)
// zwraca pole startowe lub 0, gdy niedokonczona rozgrywka/koniec pliku
{ return TGra::OdczytajInfoOMeczu(f,m,tylko_gra_srodkowa); }

int TTurniej::ZapiszInfoOTurnieju(FILE *plik)
{
  long int gdzie = ftell(f);
  fseek(f,12,SEEK_SET);
  unsigned char buf[8];
  fread(buf,1,6,f);
  time_t czas = buf[5];  czas<<=8;
  czas|=buf[4];  czas<<=8;
  czas|=buf[3];  czas<<=8;
  czas|=buf[2];
  fprintf(plik,"Turniej rozpocz\352ty przez Kropki %d.%02d; %s",int(buf[0]),int(buf[1]),
	  ctime(&czas));
  // przedostatni mecz:
  fseek(f,-2*dlug_rozgr+12,SEEK_END);
  if (ftell(f)>offset_rozgr) {
    fread(buf,1,8,f);
    int whi = buf[1];  whi<<=8;  whi|=buf[0];
    int wlo = buf[3];  wlo<<=8;  wlo|=buf[2];
    czas = buf[7];  czas<<=8;
    czas|=buf[6];  czas<<=8;
    czas|=buf[5];  czas<<=8;
    czas|=buf[4];  
    fprintf(plik,"Przedostatni mecz zako\361czony przez Kropki %d.%02d; %s",whi,wlo,
	    ctime(&czas));
  }
  fseek(f,gdzie,SEEK_SET);
}

int TTurniej::Odczytaj()
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje rozgrywke i graczy
{
 FILE *f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, gracze);
 if (jaki!=12) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 offset_rozgr=ftell(f);
 dlug_rozgr = 80+2*plx*ply;  // zob. TGra::ZapiszRozgr()
 fseek(f,0,SEEK_END);
 if (ftell(f)>offset_rozgr) {
   fseek(f, -dlug_rozgr, SEEK_END);
   int numery[2];
   gra.OdczytajRozgr(f, numery);
   ktory_sezon = numery[0];  ktory_mecz = numery[1];
   WezGraczyWAktMeczu(gra.gr);
 }
 else {
   ktory_sezon = ktory_mecz = 0;
   WezGraczyWAktMeczu(gra.gr);
   gra.NowaGra(plx, ply);
 }
 fclose(f);
 return 1;
}

int TTurniej::OdczytajMecz(int nrs, int nrm)
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje rozgrywke i graczy
{
 FILE *f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, gracze);
 if (jaki!=12) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 dlug_rozgr = 80+2*plx*ply;  // zob. TGra::ZapiszRozgr()
 fseek(f, dlug_rozgr*(long(kalendarz.rozgr_w_sezonie)*nrs+nrm), SEEK_CUR);
 int numery[2];
 gra.OdczytajRozgr(f, numery);
 ktory_sezon = numery[0];  ktory_mecz = numery[1];
 WezGraczyWAktMeczu(gra.gr);
 fclose(f);
 return 1;
}

int TTurniej::Nowy()
// zwraca
//   1 = udalo sie, wczytuje rozgrywke i graczy
//   0 = cos nie tak
{
 // utworz plik turniejowy
 FILE *f=fopen(nazwa_t, "wb");
 if (f==NULL) return 0;
 unsigned char nagl[32] = {'k','r','o','t',15,0};
 nagl[6]=(plx & 0xff);   nagl[7]=(plx >> 8);
 nagl[8]=(ply & 0xff);   nagl[9]=(ply >> 8);
 nagl[10]=(ile_graczy & 0xff);
 nagl[11]=(ile_graczy >> 8);
 // informacyjne rzeczy
 nagl[12]=WERSJA_KROPEK;  nagl[13]=WERSJA_KROPEK_LOW;
 time_t now;  time(&now);
 unsigned long int teraz = now;
 nagl[14]= teraz & 0xff;
 nagl[15]= (teraz >> 8) & 0xff;
 nagl[16]= (teraz >> 16) & 0xff;
 nagl[17]= (teraz >> 24) & 0xff;
 for (int i=18; i<32; i++) nagl[i]=0;
 fwrite(nagl, 1, 32, f);
 for (int i=0; i<ile_graczy; i++)
   gracze[i].Zapisz(f);  // fwrite(gracze, sizeof(gracze[0]), ile_graczy, f);
 //kalendarz.KazdyZKazdym(ile_graczy);
 kalendarz=pargry.kalendarz;
 kalendarz.Zapisz(f);
 offset_rozgr = ftell(f);
 dlug_rozgr = 80+2*plx*ply;  // zob. TGra::ZapiszRozgr()
 ktory_sezon = ktory_mecz = 0;
 fclose(f);
 brandomize();
 WezGraczyWAktMeczu(gra.gr);
 gra.NowaGra(plx, ply);
 return 1;
}

//*************************

TGra::TGra()
{
 tryb=TRYB_GRA;    blokada=0;
 gr[0].komputer=0;  gr[0].poziom_gry=9;   // zmodyfikuj domyslne ustawienia
}

void TGra::PrzydzielPamiec()
{
 rozgr    = plansze.PrzydzielPlansze();
 stopy    = plansze.PrzydzielPlansze();
 plansz_p = plansze.PrzydzielPlansze();
 historia = skladowe.PrzydzielSkladowa();
 CzyscPlansze(1);
}

void TGra::NowaGra(int x, int y)
{
#ifdef USTALONA_WLK_PLANSZY
  assert(x==wlkx && y==wlky);
  CzyscPlansze(1);
#else
 if (x!=wlkx || y!=wlky)
   {
   // zwolnij pamiec
   plansze.ZwolnijPamiec();
   skladowe.ZwolnijPamiec();
   tabliceLI.ZwolnijPamiec();
   wlkx=x;  wlky=y;
   // przydziel z powrotem pamiec
   plansze.PrzydzielPamiec();
   skladowe.PrzydzielPamiec();
   tabliceLI.PrzydzielPamiec();
   PrzydzielPamiec();
   }
 else CzyscPlansze(1);
#endif
}

void TGra::CzyscPlansze(int zapamietaj_zarodek)
// rozpoczyna gre od nowa, nie zmienia wielkosci planszy ani graczy
{
 CzyscTablice(rozgr);
 CzyscTablice(stopy);
 CzyscTablice(plansz_p);
 ile_hist=1;
 historia[0]=0;  // bezsensowne miejsce
 ktory_gracz=0;   // gracz na ruchu
 ile_zd_do_konc[0]=ile_zd_do_konc[1]=ile_zd[0]=ile_zd[1]=pow_ss[0]=pow_ss[1]=0;
 koncowka=0;
 if (zapamietaj_zarodek) {
   zarodek_pocz[0] = bseed1;
   zarodek_pocz[1] = bseed2;
 }
 StoperyOdNowa();
 STOPER_ZERUJ_WSZYSTKIE;
}

int TGra::DNajlepszyRuch(int& x, int& y, int wybierz_ruchy)
// daje najlepszy ruch gracza (komputerowego) i zwraca 1,
// lub zwraca 0, gdy koniec gry
// wybierz_ruchy==1   <==>  wcisnieto ,,w'' (analiza z wyborem listy ruchow)
{
  if (ktory_gracz>=0) {
    switch (gr[ktory_gracz].poziom_gry)
      {
      case 11:
        ZnajdzNajlepszyRuchSNR2(rozgr, plansz_p, ktory_gracz+1,gr[ktory_gracz],
	  x,y,(historia[ile_hist-1] >> 8), (historia[ile_hist-1] & 0xff) );
        break;
      case 12:
        ZnajdzNajlepszyRuch12(rozgr, plansz_p, ktory_gracz+1, gr[ktory_gracz],
			      x,y,(historia[ile_hist-1] >> 8),(historia[ile_hist-1] & 0xff), wybierz_ruchy );
        break;
      default:
	 ZnajdzNajlepszyRuch(rozgr, plansz_p, ktory_gracz+1, gr[ktory_gracz].poziom_gry,
			    gr[ktory_gracz].umiejetnosci,
           x,y,(historia[ile_hist-1] >> 8),(historia[ile_hist-1] & 0xff) );
	 break;
      }
    return 1;
  }
  return 0;
}

void TGra::GlownaPetla()
{
 int zdarz = ZD_NIC;
 StoperyOdNowa();
 for (;;)
   {
   Poczatek_petli:;
   if (ktory_gracz>=0)   // gra sie nie skonczyla
   if (gr[ktory_gracz].komputer)
     {
     zdarz = (tryb & TRYB_PAUZA) ? ekran.CzekajNaZdarzenie() :
              ekran.DajZdarzenie();
     if (zdarz!=ZD_NIC && zdarz!=ZD_KROPKA) // ZD_NIC i ZD_KROPKA sa ignorowane
       {
       if (zdarz==ZD_KONIEC) return;
       else
         {
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
         }
       }
     if (tryb & TRYB_PAUZA) goto Poczatek_petli;
     // znajdz najlepszy ruch
     int x,y;
     DNajlepszyRuch(x,y);
     // wykonaj ruch
     if (tryb !=TRYB_CZAS) WykonajRuch(x,y);
     else WykonajRuch(historia[ile_hist] >> 8,  historia[ile_hist] & 0xff);
     StoperyWznow();
     }
   else  // na ruchu czlowiek
     {
     zdarz = ekran.CzekajNaZdarzenie();
     switch (zdarz)
       {
       case ZD_KROPKA:
       // postaw kropke, jesli to mozliwe
       if ((WezUC(plansz_p,pargry.x+2,pargry.y+2) & 3)==0) { // nie wewnatrz stopu
	 if (WezUC(rozgr,pargry.x+2,pargry.y+2)==0)  // nie ma tu jeszcze kropki
	   WykonajRuch(pargry.x+2,pargry.y+2, pargry.kod);
	 else if (pargry.kod==-1)
	   UstawRuch(pargry.x+2,pargry.y+2);
       }
       StoperyWznow();
       break;
       case ZD_KONIEC: return;
       default:
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
       }
     }
   else  // koniec gry
     {
     zdarz = ekran.CzekajNaZdarzenie();
     switch (zdarz)
       {
       case ZD_KONIEC: return;
       default:
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
       }
     }
   // sprawdz, czy gra sie skonczyla
   if (ktory_gracz==-1)
     {
//     if (blokada) ekran.WyswietlPlansze(WS_CALAPLANSZA);
     if (tryb==TRYB_TURNIEJ)
       {
       ekran.WyswietlInfoOMeczu();   // inf. na koniec meczu
       char s[30];
       ekran.WyswietlCzasGry();
       // zapamietaj wynik akt. meczu
       turniej.Zapisz();
       turniej.NowyMecz();
       turniej.WezGraczyWAktMeczu(gr);
       CzyscPlansze(1);
       ekran.WyswietlInfoOMeczu();   // inf. na poczatkek meczu
       if (!blokada)
         {
         ekran.WyswietlPlansze(WS_CALAPLANSZA);
         ekran.WyswietlGraczy();
         }
       GrFlush();
#ifdef TEKSTOWY
       // sprawdz, czy jest plik ,,koniec''
       FILE *ck = fopen("koniec","rb");
       if (ck!=NULL) {
	 fclose(ck);
	 return;  // koniec!
       }
#endif
       }
     else
       {
       char s[30];
       ekran.WyswietlCzasGry();
       if (tryb==TRYB_CZAS)
         { tryb=TRYB_GRA;  ekran.WyswietlTryb(); }
       GrFlush();
       }
     }
   }
}

void TGra::ObsluzZdarzenie(int zd)
// odczytuje zmienna globalna pargry
{
 if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ) turniej.Zapisz();
 switch (zd)
  {
  case ZD_NOWAGRA:
   gr[0]=pargry.gr[0];  gr[1]=pargry.gr[1];
   if (!gr[0].komputer || !gr[1].komputer)
     {
     if (blokada)
       { blokada=0;
       ekran.WyswietlBlokade();  
       GrFlush();
       }
     }
   NowaGra(pargry.x, pargry.y);
   if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ || (tryb & ~TRYB_PAUZA)==TRYB_CZAS)
     { tryb=TRYB_GRA | (tryb & TRYB_PAUZA);  ekran.WyswietlTryb(); }
   ekran.WyswietlPlansze(WS_NOWAPLANSZA);
   ekran.WyswietlGraczy();
   StoperyOdNowa();
   GrFlush();
   break;
  case ZD_COFNIJ:
   if (ile_hist>1 && pargry.ile<ile_hist-1)  // jesli jest sens cofac
     {
     unsigned char *rozgr_zap = plansze.PrzydzielPlansze();
     KopiujTablice(rozgr_zap, rozgr);
     CzyscPlansze();
     // wykonuj ruchy (poniewaz cofnelismy, nie ma grozby zakonczenia gry)
     int sprawdzaj = koncowka;
     for (int i=0; i<pargry.ile; i++)
       {
       // wykonaj ruch numer i
       int x=(historia[i+1] >> 8);
       int y=(historia[i+1] & 0xff);
       ktory_gracz = WezUC(rozgr_zap, x,y)-1;
       int ile_zdt=0,pow=0,pow2=0,ile_zdt2=0;
       ZrobRuch(rozgr,stopy, plansz_p, x,y, ktory_gracz+1,
                (historia[i] >> 8),
                (historia[i] & 0xff),
                ile_zdt,pow,pow2,ile_zdt2);
       ile_zd[ktory_gracz]+=ile_zdt;
       pow_ss[ktory_gracz]+=pow;
       pow_ss[1-ktory_gracz]+=pow2;
       ile_zd[1-ktory_gracz]+=ile_zdt2;
       if (sprawdzaj) {     // sprawdz, czy to juz koniec gry srodkowej
	 int ile_wolnego, ile_wolnego_poza_sts;
	 IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
	 if (!ile_wolnego_poza_sts) {
	   ile_zd_do_konc[0] = ile_zd[0];   ile_zd_do_konc[1] = ile_zd[1];
	   koncowka=1;
	   sprawdzaj=0;
	 }
       }
       }
     // ustaw gracza na ruchu
     {
     ile_hist=pargry.ile+1;
     int x=(historia[ile_hist] >> 8);
     int y=(historia[ile_hist] & 0xff);
     ktory_gracz = WezUC(rozgr_zap, x,y)-1;
     }
     plansze.ZwolnijPlansze(rozgr_zap);
     // ustaw tryb
     if (gr[ktory_gracz].komputer || (tryb & TRYB_PAUZA))
       tryb = TRYB_GRA | TRYB_PAUZA;
     else tryb = TRYB_GRA;
     StoperyWznow();
     ekran.WyswietlTryb();
     ekran.WyswietlPlansze(WS_CALAPLANSZA);
     GrFlush();     
     }
   break;
  case ZD_TRYB:
   switch (pargry.tryb)
     {
     case TRYB_PAUZA:   // wylacz pauze
       tryb &= ~TRYB_PAUZA;
       ekran.WyswietlTryb();
       StoperyWznow();
       GrFlush();
       break;
     case TRYB_PAUZA+1: // wlacz pauze
       tryb |= TRYB_PAUZA;
       ekran.WyswietlTryb();
       StoperyWstrzymaj();
       GrFlush();
       break;
     case TRYB_GRA:
       if ((tryb & ~TRYB_PAUZA)!=TRYB_GRA)
         { tryb=TRYB_GRA | (tryb & TRYB_PAUZA);  
         ekran.WyswietlTryb();   GrFlush(); }
       break;
     case TRYB_CZAS:
       if ((tryb & ~TRYB_PAUZA) !=TRYB_TURNIEJ &&
           ktory_gracz==-1 && gr[0].komputer && gr[1].komputer)
         {
         CzyscPlansze();
         tryb=TRYB_CZAS;
	      bseed1=15666;  bseed2=0;
         ekran.WyswietlTryb();
         pargry.x=bseed1;  pargry.y=bseed2;
         ekran.WyswietlInformacje(WS_NOWYZARODEK);
         if (!blokada)
           ekran.WyswietlPlansze(WS_CALAPLANSZA);
         // czekaj na nastepne tykniecie zegara
         {
         TStoper czekaj;
         czekaj.Start();
         while (!czekaj.CzyJuz(0,2));
         }
         StoperyOdNowa();
         GrFlush();
	 }
       break;
     case TRYB_TURNIEJ:
       if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
         {  // rozpocznij/odczytaj turniej
         // przepisz parametry z pargry
         strcpy(turniej.nazwa_t, pargry.nz1);
         if (pargry.kod==2)  // nowy
           {
           turniej.ile_graczy = pargry.ile;
           turniej.plx = pargry.x; turniej.ply = pargry.y;
           for (int i=0; i<turniej.ile_graczy; i++)
             turniej.gracze[i] &= pargry.gr[i];
           }
         if ((pargry.kod==1) ?  (turniej.Odczytaj()!=1) : (turniej.Nowy()!=1))
           {
           ekran.WyswietlInformacje(WS_BLADPLIKU);
           GrFlush();
	   break;
           }
         // turniej rozpoczety!
 	 if (ktory_gracz==-1) {
	   // wczytalismy zakonczona rozgrywke, rozpocznij nowa
	   turniej.NowyMecz();
	   turniej.WezGraczyWAktMeczu(gr);
	   CzyscPlansze(1);
	 }
         ekran.WyswietlPlansze(WS_NOWAPLANSZA);
         ekran.WyswietlGraczy();
         pargry.x=bseed1;  pargry.y=bseed2;
         ekran.WyswietlInformacje(WS_NOWYZARODEK);
         ekran.WyswietlInfoOMeczu();   // inf. na poczatkek meczu
         tryb=TRYB_TURNIEJ | (tryb & TRYB_PAUZA);
         ekran.WyswietlTryb();
	 GrFlush();
	 }
       break;
     }
   break;
  case ZD_ODCZYT_MECZU: {
   strcpy(turniej.nazwa_t, pargry.nz1);
   if (turniej.OdczytajMecz(pargry.x, pargry.y)!=1)
     {
       ekran.WyswietlInformacje(WS_BLADPLIKU);
       GrFlush();
       break;
     }
   // gra wczytana!
   ekran.WyswietlInformacje(WS_ODCZYTMECZU);
   tryb=TRYB_GRA | TRYB_PAUZA;
   ekran.WyswietlTryb();
   ekran.WyswietlWszystko();
   GrFlush();
   }
   break;
  case ZD_BLOKADA: if (blokada!=pargry.blokada)   // czy cos sie zmienia?
   {
   if (pargry.blokada)  // wlaczyc blokade mozna tylko gdy nie gra czlowiek
     { if (gr[0].komputer && gr[1].komputer) blokada=1; }
   else blokada=0;  // a wylaczyc mozna zawsze
   ekran.WyswietlBlokade();
   GrFlush();
   }
   break;
  case ZD_ZAPIS:
   // zapisz do pliku pargry.nz1
   {
   FILE *f = fopen(pargry.nz1,"wb");
   if (f==NULL)
     {
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     break;
     }
   unsigned char nagl[32] = {'k','r','o','b',15,0};
   nagl[6]=(wlkx & 0xff);   nagl[7]=(wlkx >> 8);
   nagl[8]=(wlky & 0xff);   nagl[9]=(wlky >> 8);
   nagl[10]=(ile_hist & 0xff);   nagl[11]=(ile_hist >> 8);
   // informacyjne rzeczy
   nagl[12]=WERSJA_KROPEK;  nagl[13]=WERSJA_KROPEK_LOW;
   time_t now;  time(&now);
   unsigned long int teraz = now;
   nagl[14]= teraz & 0xff;
   nagl[15]= (teraz >> 8) & 0xff;
   nagl[16]= (teraz >> 16) & 0xff;
   nagl[17]= (teraz >> 24) & 0xff;
   for (int i=18; i<32; i++) nagl[i]=0;
   fwrite(nagl, 1, 32, f);
   for (int i=0; i<2; i++)    // zapisz obu graczy
     gr[i].Zapisz(f);         //   fwrite(gr, sizeof(TGraczO), 2, f);
   ZapiszRozgr(f);
   fclose(f);
   }
   break;
  case ZD_ODCZYT:
   // odczytaj z pliku pargry.nz1
   {
   FILE *f = fopen(pargry.nz1,"rb");
   if (f==NULL)
     {
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     break;
     }
   int wx,wy,ile,ilzd[2],poss[2];
   TGraczO grtest[2];
   int r=DInfoOPliku(f, wx,wy,ile,grtest,ilzd,poss);
   if ((r&~8)<1 || (r&~8)>3 || (r>=8 && !OdczytajRozgr(f)))
     {
     fclose(f);
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     GrFlush();
     break;
     }
   gr[0] &= grtest[0];   gr[1] &= grtest[1];   // skopiuj graczy
   if (r<=3) {
     NowaGra(wx,wy);
     // wczytaj tablice
     fread(rozgr, sizeof(rozgr[0]), wlkx4wlky4, f);
     fread(stopy, sizeof(stopy[0]), wlkx4wlky4, f);
     fread(plansz_p, sizeof(plansz_p[0]), wlkx4wlky4, f);
     assert(sizeof(historia[0])==2);
     {
       unsigned char *buf = new unsigned char[2*wlkx4wlky4];
       assert(buf!=NULL);
       fread(buf, 1, 2*wlkx4wlky4, f);
       for (int i=0; i<wlkx4wlky4; i++) {
	 historia[i] = buf[2*i+1];
	 historia[i] <<= 8;
	 historia[i] |= buf[2*i];
       }
       delete[] buf;
     }
     fclose(f);
     ktory_gracz=r-2;
     ile_hist=ile+1;
     ile_zd[0]=ilzd[0];   ile_zd[1]=ilzd[1];
     pow_ss[0]=poss[0];   pow_ss[1]=poss[1];
     // nie jestesmy w turnieju, wiec nie musimy dokladnie znajdowac wyniku
     // po grze srodkowej...
     int ile_wolnego, ile_wolnego_poza_sts;
     IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
     if (koncowka = !ile_wolnego_poza_sts) {  // =, nie ==!
       ile_zd_do_konc[0] = ile_zd[0];   ile_zd_do_konc[1] = ile_zd[1];
       }
   }
   }
   tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer)?
             (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
   if (blokada && (!gr[0].komputer || !gr[1].komputer))
     {
     blokada=0;  ekran.WyswietlBlokade();
     }
   ekran.WyswietlPlansze(WS_NOWAPLANSZA);
   ekran.WyswietlGraczy();
   ekran.WyswietlTryb();
   StoperyOdNowa();
   GrFlush();
   break;
  case ZD_USTAWZARODEK:
   if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
     { bseed1=pargry.x;  bseed2=pargry.y;
     ekran.WyswietlInformacje(WS_NOWYZARODEK);
     GrFlush();
     }
   break;
  case ZD_USTAWZARODEKLOSOWY:
   if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
     { brandomize();
     pargry.x=bseed1;  pargry.y=bseed2;
     ekran.WyswietlInformacje(WS_NOWYZARODEK);
     GrFlush();
     }
   break;
  case ZD_OPUSCRUCH:
   if (ktory_gracz>=0 && !gr[ktory_gracz].komputer)
     {
     ktory_gracz=1-ktory_gracz;
     StoperyWznow();
     ekran.WyswietlPlansze(WS_KTONARUCHU);
     GrFlush();
     }
   break;
  case ZD_ZMIENGRACZY:
   if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ)
     tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer)?
                (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
   gr[0]=pargry.gr[0];  gr[1]=pargry.gr[1];
   if (!gr[0].komputer || !gr[1].komputer)
     {
     if ((tryb & ~TRYB_PAUZA)==TRYB_CZAS)
       tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer) ?
         (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
     if (blokada)
       { blokada=0;
       ekran.WyswietlBlokade(); }
     }
   ekran.WyswietlGraczy();
   ekran.WyswietlTryb();
   StoperyWznow();
   GrFlush();
   break;
  }
}

void TGra::WykonajRuch(int x, int y, int tylko_ruch)
// Wykonuje ruch (x,y) (nie sprawdza poprawnosci!);
// modyfikuje zdobycze i historie;
// sprawdza, czy gra sie skonczyla:
//   jesli tak, to dodaje ostatni stop (jesli jest), zatrzymuje stoper;
//   jesli nie, to zmienia gracza na ruchu
// wywoluje WyswietlPlansze() z odp. parametrem, jesli nie ma blokady
// lub gra sie zakonczyla.
// Ta funkcja nie wie niczego o turnieju: nie ustawia nowego meczu po
// zakonczeniu gry. Nie wywoluje WyswietlCzas().
//  Jesli tylko_ruch==1, to wykonuje ruch, nie zmienia gracza na ruchu,
//  nie zatrzymuje stoperow, niczego nie wyswietla (potrzebne do odczytywania
//  rozgrywki).
//  tylko_ruch==-1 oznacza to samo co 0, ale bez zmiany gracza (do ustawiania
//   pozycji do analizy)
{
 int ile_zdt=0,pow=0,pow2=0,ile_zdt2=0;
 ZrobRuch(rozgr,stopy, plansz_p, x,y, ktory_gracz+1,
          (historia[ile_hist-1] >> 8),
          (historia[ile_hist-1] & 0xff),
          ile_zdt,pow,pow2,ile_zdt2);
 ile_zd[ktory_gracz]+=ile_zdt;
 pow_ss[ktory_gracz]+=pow;
 pow_ss[1-ktory_gracz]+=pow2;
 ile_zd[1-ktory_gracz]+=ile_zdt2;
 historia[ile_hist++] = (x << 8) + y;
 // sprawdz, czy to juz koniec
 {
 int ile_wolnego, ile_wolnego_poza_sts;
 IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
 if (!ile_wolnego_poza_sts && !koncowka) {
   ile_zd_do_konc[0] = ile_zd[0];   ile_zd_do_konc[1] = ile_zd[1];
   koncowka=1;
 }
 if (tylko_ruch==1) return;  // w tym przypadku nie spr., czy koniec gry
 if (ile_wolnego || ile_wolnego_poza_sts)
   {
   if (tylko_ruch==0)
     ktory_gracz=1-ktory_gracz;
   }
 else
   {
   ktory_gracz=-1;      // ustaw koniec gry
   StoperyStop();
   }
 }
 // wyswietl kropke i ew. kreski, zdobycze, itp.; nie wyswietlaj czasu gry!
 if (!blokada)
  {
  if (ile_zdt || ile_zdt2) ekran.WyswietlPlansze(WS_STOP);
  else if (pow || pow2) ekran.WyswietlPlansze(WS_POWIERZCHNIA);
  else ekran.WyswietlPlansze(WS_KROPKA);
  GrFlush();
  }
 else if (ktory_gracz==-1)
  { ekran.WyswietlGraczy(); ekran.WyswietlPlansze(WS_CALAPLANSZA); 
  GrFlush(); }
}

void TGra::UstawRuch(int x, int y)
// Zamienia kropke na polu (x,y) na kropke gracza (jesli jest tam kropka przeciwnika)
// lub kasuje wlasna kropke.
// Pole (x,y) powinno byc NIE WEWNATRZ STOPU! (ale moze byc na brzegu stopu)
// Modyfikuje zdobycze i historie;
// sprawdza, czy gra sie skonczyla:
//   jesli tak, to dodaje ostatni stop (jesli jest), zatrzymuje stoper;
// wywoluje WyswietlPlansze() z odp. parametrem, jesli nie ma blokady
// lub gra sie zakonczyla.
// Nigdy nie zmienia gracza na ruchu.
{
  unsigned char *r = plansze.PrzydzielPlansze();
  KopiujTablice(r, rozgr);
  int ile_hist_zap = ile_hist;
  int kto = ktory_gracz;
  if (WezUC(rozgr,x,y)==ktory_gracz+1) {  // nasza kropka, trzeba ja skasowac
    WezUC(r,x,y) = 0;
    int miejsce = (x<<8)+y;
    int dokad=1;
    for (int i=1; i<ile_hist; i++)
      if (historia[i]!=miejsce)
	historia[dokad++] = historia[i];
    ile_hist_zap--;
  }
  else  // zamien kropke przeciwnika na nasza
    WezUC(r,x,y) = ktory_gracz+1;
  // wyczysc plansze i zacznij od nowa
  CzyscTablice(rozgr);
  CzyscTablice(stopy);
  CzyscTablice(plansz_p);
  ile_hist=1;
  historia[0]=0;  // bezsensowne miejsce
  ile_zd_do_konc[0]=ile_zd_do_konc[1]=ile_zd[0]=ile_zd[1]=pow_ss[0]=pow_ss[1]=0;
  for (int i=1; i<ile_hist_zap; i++) {
    int x = (historia[i] >> 8);
    int y = (historia[i] & 0xff);
    ktory_gracz = WezUC(r,x,y)-1;
    WykonajRuch(x,y, 1);
    }
  ktory_gracz=kto;
  // sprawdz, czy to juz koniec
  {
    int ile_wolnego, ile_wolnego_poza_sts;
    IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
    if (!ile_wolnego && !ile_wolnego_poza_sts) {
      ktory_gracz=-1;      // ustaw koniec gry
      StoperyStop();
    }
  }
  // wyswietl kropke i ew. kreski, zdobycze, itp.; nie wyswietlaj czasu gry!
  ekran.WyswietlPlansze(WS_CALAPLANSZA);
  GrFlush();
}

// funkcje zwracajace wartosci parametrow, ,,D'' od daj
int TGra::DTryb() { return tryb; }
int TGra::DBlokada() { return blokada; }
int TGra::DKropka(int x, int y) { return WezUC(rozgr,x+2,y+2); }
int TGra::DKreska(int x, int y) { return WezUC(stopy,x+2,y+2); }
int TGra::DKreska(int x, int y, int x2, int y2)
{ return CzyPolaczone(stopy, x+2, y+2, x2+2, y2+2); }
int TGra::DPlanszP(int x, int y) { return WezUC(plansz_p,x+2,y+2); }
int TGra::DIleKropek() { return ile_hist-1; }
int TGra::DOstKropkaX()
{ return ile_hist==1 ? -1: (historia[ile_hist-1] >> 8)-2; }
int TGra::DOstKropkaY()
{ return ile_hist==1 ? -1: (historia[ile_hist-1] & 0xff)-2; }
int TGra::DNaRuchu() { return ktory_gracz; }
int TGra::DKomputerNaRuchu() 
{ return (ktory_gracz>=0) ? gr[ktory_gracz].komputer : 0; }
int TGra::DWlkX() { return wlkx; }
int TGra::DWlkY() { return wlky; }
int TGra::DIleZd(int ng) { return ile_zd[ng]; }
int TGra::DPowSS(int ng) { return pow_ss[ng]; }
void TGra::DGracza(int nr, TGraczO &ngr) { ngr = gr[nr]; }
krint& TGra::DElTabl(krint* tab, int i, int j) const
{ return WezUI(tab,i+2,j+2); };
unsigned char& TGra::DElTabl(unsigned char* tab, int i, int j) const
{ return WezUC(tab,i+2,j+2); };
unsigned int TGra::DHTAktCzas()
{ return htablicaZ.DajAktCzas(); }
int TGra::DNrSezonu()
{ return turniej.KtorySezon()+1; }
int TGra::DNrMeczu()
{ return turniej.KtoryMecz()+1; }
int TGra:: DNrGracza(int gr)
{ return gr ? turniej.kalendarz.mecze[turniej.ktory_mecz].g2 : turniej.kalendarz.mecze[turniej.ktory_mecz].g1; }

void TGra::UstawImie(int nr, const char* noweimie)
{
  strncpy(gr[nr].imie, noweimie, sizeof(gr[nr].imie));
  gr[nr].imie[sizeof(gr[nr].imie)-1]=0;
}

int TGra::DPola(int *pola, int x, int y, int wx, int wy, int symetrie)
// dodaje od 1 do 8 pol do pola[]
{
  x+=2; y+=2;
  pola[0]=x*(wy+4)+y;
  int ile=1;
  if (symetrie) {
    // wez symetrie wzgledem x
    int wx4wy4 = (wx+4)*(wy+4);
    for (int i=ile-1; i>=0; i--) 
      if (pola[i]>=0 && pola[i]<wx4wy4) {
	x=pola[i] / (wy+4);   y=wy+3- pola[i] % (wy+4);
	int ind = x*(wy+4)+y;
	int juz_jest=0;
	for (int j=0; j<ile; j++)
	  if (pola[j]==ind) { juz_jest=1; break; }
	if (!juz_jest) pola[ile++]=ind;
      }
    // wez symetrie wzgledem y
    for (int i=ile-1; i>=0; i--)
      if (pola[i]>=0 && pola[i]<wx4wy4) {
	x=wx+3- pola[i]/(wy+4);   y= pola[i] % (wy+4);
	int ind = x*(wy+4)+y;
	int juz_jest=0;
	for (int j=0; j<ile; j++)
	  if (pola[j]==ind) { juz_jest=1; break; }
	if (!juz_jest) pola[ile++]=ind;
      }
    if (wx==wy) {
      // wez symetrie wzgl. przekatnej
      for (int i=ile-1; i>=0; i--)
	if (pola[i]>=0 && pola[i]<wx4wy4) {
	  x=pola[i] % (wy+4);   y=pola[i] / (wy+4);  // zamien x <--> y
	  int ind = x*(wy+4)+y;
	  int juz_jest=0;
	  for (int j=0; j<ile; j++)
	    if (pola[j]==ind) { juz_jest=1; break; }
	  if (!juz_jest) pola[ile++]=ind;
	}
    }
  }
  return ile;
}

int TGra::DSStoper(int i, char* s)
{
#ifdef SA_STOPERY
 char *nazwy[] = {"OcenSkl:", "UstawSk:", "ZrobPan:", "ZnMostk:", "aWeze  :", "ZnSklad:", 
		  "UstZak :", "DodSas :",
                  "UstKary:", "TCiete :", "RobDod :", "RobMatk:", "CzyStop:", "UaktBzp:",
		  "srtRuch:", "ZapOcen:", "bezsens:", "hWez   :", "hWstaw :",
		  "GdyStop:", "tablice:", "TGrozby:", "popGleb:"};
 if (i>=sizeof(nazwy)/sizeof(nazwy[0])) return 0;
 strcpy(s,nazwy[i]);
 sprintf(&s[8]," %d", int(ssPodaj(i)/10));
 // if (ssPodaj(i)<10 && ssPodaj(i)) strcat(s,"0");
 strcat(s,".");
 sprintf(&s[strlen(s)],"%d", int(ssPodaj(i)%10));
 strcat(s,"c");
 return 1;
#else
 return 0;
#endif
}

void TGra::DJakasTablice(krint* tabl, char *opis_bitow, int kod)
// funkcja dla testow
{
CzyscTablice(tabl);  memset(opis_bitow, 0, (16<<5));
 const char *cyferki="0123456789abcdef";
 switch (kod) {
 case 0:  // obszary
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   ZnajdzObszary(tabl, rozgr2, rozgr3);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   }
   strcpy(&opis_bitow[0<<5], "0: otoczka wszystkich kr");
   strcpy(&opis_bitow[1<<5], "1: j.w. ale margines 1");
   strcpy(&opis_bitow[2<<5], "2: j.w. ale margines 2");
   strcpy(&opis_bitow[3<<5], "3: j.w. ale margines 3");
   strcpy(&opis_bitow[4<<5], "4: odlegl. <=1 od gr 1");
   strcpy(&opis_bitow[5<<5], "5: odlegl. <=2 od gr 1");
   strcpy(&opis_bitow[6<<5], "6: odlegl. <=1 od gr 2");
   strcpy(&opis_bitow[7<<5], "7: odlegl. <=2 od gr 2");
   strcpy(&opis_bitow[8<<5], "8: otoczka z wcieciami");
   strcpy(&opis_bitow[9<<5], "9: j.w. ale L^1-marg. 1");
   strcpy(&opis_bitow[10<<5], "a: j.w. ale L^1-marg. 2");
   strcpy(&opis_bitow[11<<5], "b: j.w. ale L^1-marg. 3");
   strcpy(&opis_bitow[12<<5], "c: bezsensowne dla gr 1");
   strcpy(&opis_bitow[13<<5], "d: bezsensowne dla gr 2");
   break;
 case 1:
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].rozgr3 = rozgr3;
   ang[0].UstawBezpNaZawsze();
   ang[0].InicjujCiecia(rozgr3);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   }
   // przepisz obszary do tabl
   for (int i=2; i<wlkx+2; i++)
    {
    signed int j=ang[0].ciete[0].pion_min[i];
    if (j<=ang[0].ciete[0].pion_max[i])
      {
      unsigned int indeks = WezIndeksTab(i,j);
      do
        {
        if (i>=ang[0].ciete[0].poz_min[j] && i<=ang[0].ciete[0].poz_max[j])
          tabl[indeks]|=1;
        j++;  indeks++;
        }
      while (j<=ang[0].ciete[0].pion_max[i]);
      }
    }
   for (int i=2; i<wlkx+2; i++)
    {
    signed int j=ang[0].ciete[1].pion_min[i];
    if (j<=ang[0].ciete[1].pion_max[i])
      {
      unsigned int indeks = WezIndeksTab(i,j);
      do
        {
        if (i>=ang[0].ciete[1].poz_min[j] && i<=ang[0].ciete[1].poz_max[j])
          tabl[indeks]|=2;
        j++;  indeks++;
        }
      while (j<=ang[0].ciete[1].pion_max[i]);
      }
    }
   // przepisz ciecia do tabl
   for (int ktg=0; ktg<=1; ktg++) {
   for (int i=2; i<wlkx+2; i++)
     {
     if (ang[0].ciete[ktg].pion_min[i]>=2 && ang[0].ciete[ktg].pion_min[i]<=wlky+1)
       WezUI(tabl,i,ang[0].ciete[ktg].pion_min[i]) |= (4 << (4*ktg));
     if (ang[0].ciete[ktg].pion_max[i]>=2 && ang[0].ciete[ktg].pion_max[i]<=wlky+1)
       WezUI(tabl,i,ang[0].ciete[ktg].pion_max[i]) |= (8 << (4*ktg));
     }
   for (int j=2; j<wlky+2; j++)
     {
     if (ang[0].ciete[ktg].poz_min[j]>=2 && ang[0].ciete[ktg].poz_min[j]<=wlkx+1)
       WezUI(tabl,ang[0].ciete[ktg].poz_min[j],j) |= (16 << (4*ktg));
     if (ang[0].ciete[ktg].poz_max[j]>=2 && ang[0].ciete[ktg].poz_max[j]<=wlkx+1)
       WezUI(tabl,ang[0].ciete[ktg].poz_max[j],j) |= (32 << (4*ktg));
     } }
   strcpy(&opis_bitow[0<<5], "0: wokol g1");
   strcpy(&opis_bitow[1<<5], "1: wokol g2");
   strcpy(&opis_bitow[2<<5], "2: g1/min y");
   strcpy(&opis_bitow[3<<5], "3: g1/max y");
   strcpy(&opis_bitow[4<<5], "4: g1/min x");
   strcpy(&opis_bitow[5<<5], "5: g1/max x");
   strcpy(&opis_bitow[6<<5], "6: g2/min y");
   strcpy(&opis_bitow[7<<5], "7: g2/max y");
   strcpy(&opis_bitow[8<<5], "8: g2/min x");
   strcpy(&opis_bitow[9<<5], "9: g2/max x");
   break;
 case 2:  // terytorium
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   unsigned char* pom = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   // znajdz terytorium
//   int dil[4] = {5,4,5,4}, ero[4]={21,13,13,7};
//    int dil[4] = {5,4,3,2}, ero[4]={13,7,3,1};
   int ktg = ktory_gracz>=0 ? ktory_gracz : WezUC(rozgr, (historia[ile_hist-1] >> 8), (historia[ile_hist-1] & 0xff));
   int dil = gr[ktg].Bouzy_dil;
   int ero = gr[ktg].Bouzy_er;
   Bouzy(pom, rozgr2, rozgr3, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1), dil, ero,
	 1,1,0);   // 2 wagi i punkt_za_pole
   for (int i=0; i<wlkx4wlky4; i++) tabl[i]=pom[i];
   plansze.ZwolnijPlansze(pom);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   sprintf(&opis_bitow[0<<5], "0: terytorium (%d,%d) gr 1",dil,ero);
   sprintf(&opis_bitow[1<<5], "1: terytorium (%d,%d) gr 2",dil,ero);
   }
   break;
 case 3:  // bezpieczne
   {
     // ustaw wstepnie sklnr
     unsigned char* rozgr2 = plansze.PrzydzielPlansze();
     unsigned char* rozgr3 = plansze.PrzydzielPlansze();
     WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
     TBandy bandy;
     bandy.Inicjuj();
     bandy.UstawBezpieczne(rozgr3);
     const int tabelkab[4] = {0,1,2,2};
     for (int i=0; i<wlkx4wlky4; i++)
       tabl[i] = tabelkab[bandy.bezpieczne[i]];
     bandy.Zwolnij();

     plansze.ZwolnijPlansze(rozgr2);
     plansze.ZwolnijPlansze(rozgr3);
     strcpy(&opis_bitow[0<<5], "0: p\363\263-bezpieczne");
     strcpy(&opis_bitow[1<<5], "1: bezpieczne");
   // a teraz kropki bezpieczne na zawsze
   ang[0].rozgr2  = plansze.PrzydzielPlansze();
   ang[0].rozgr3  = plansze.PrzydzielPlansze();
   ang[0].plansz_p= plansze.PrzydzielPlansze();
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   unsigned char* bezs = plansze.PrzydzielPlansze();
   ang[0].marg0_min=TDwaUC(2,2);
   ang[0].marg0_max=TDwaUC(wlkx+1,wlky+1);
   KopiujTablice(ang[0].plansz_p, plansz_p);
   WezRozgr23(rozgr, ang[0].rozgr2, ang[0].rozgr3, ang[0].plansz_p);
   ang[0].UstawBezpNaZawsze();
   CzyscTablice(bezs);
   ang[0].DodajBezsensowne(bezs);
   for (int i=0; i<wlkx4wlky4; i++) 
     tabl[i] |= ((TAnaliza::bezp_na_zawsze[i]) ? 4 : 0) |   // bylo = zamiast |=, popr. w 83.15
       (bezs[i] ? 8:0);
   plansze.ZwolnijPlansze(bezs);
   plansze.ZwolnijPlansze(ang[0].rozgr2);
   plansze.ZwolnijPlansze(ang[0].rozgr3);
   plansze.ZwolnijPlansze(ang[0].plansz_p);
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   strcpy(&opis_bitow[2<<5], "2: bezp na zawsze");
   strcpy(&opis_bitow[3<<5], "3: bezsensowne");
   }
   break;
 case 4: { // lista ruchow
   int twp = plansze.ile_wolnych, tws=skladowe.ile_wolnych;
   unsigned char *rozgrywka = plansze.PrzydzielPlansze();
   unsigned char *plansz_p2 = plansze.PrzydzielPlansze();
   unsigned char *rozgr2    = plansze.PrzydzielPlansze();
   unsigned char *rozgr3    = plansze.PrzydzielPlansze();
   KopiujTablice(rozgrywka, rozgr);
   KopiujTablice(plansz_p2, plansz_p);
   
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   TDwaUC marg_min[4], marg_max[4];
   int ile_ruchow, ile_ruchow_przec;
   krint *kolejne_ruchy  = skladowe.PrzydzielSkladowa();
   krint *ruchy_przec    = skladowe.PrzydzielSkladowa();
   unsigned char *schemat_ruchow = plansze.PrzydzielPlansze();
   ang[1].zagrozenia = skladowe.PrzydzielSkladowa();
   int gleb = gr[ktory_gracz].dokl_analizy;
   gr[ktory_gracz].dokl_analizy=6;
   ZnajdzListeRuchow12(rozgrywka, plansz_p2,
		       rozgr2, rozgr3,
		       skl_tab, 
		       marg_min,  marg_max,
		       ile_ruchow, ile_ruchow_przec,
		       kolejne_ruchy,  ruchy_przec,
		       schemat_ruchow,
		       gr[ktory_gracz], ktory_gracz+1
		       );
   gr[ktory_gracz].dokl_analizy = gleb;
   for (int i=0; i<wlkx4wlky4; i++) {
     if (schemat_ruchow[i]==0xff)
       tabl[i] = (upl_marg[i]<=1) ? 0 : 0x40;
     else {
       if (schemat_ruchow[i] & 1)
	 tabl[i] |= 0x4;
       if (schemat_ruchow[i] & 2)
	 tabl[i] |= 0x20;
       if (schemat_ruchow[i] & 4)
	 tabl[i] |= 0x2;
       if (schemat_ruchow[i] & 8)
	 tabl[i] |= 0x10;
       if (schemat_ruchow[i] & 0x10)
	 tabl[i] |= 0x1;
       if (schemat_ruchow[i] & 0x20)
	 tabl[i] |= 0x8;
       if (PoleBezs12(rozgr3, i, 1)==2)
	 tabl[i] |= 0x80;	 
     }
   }
   {
     sprintf(&opis_bitow[0<<5], "0: ruchy gr%d",ktory_gracz+1);
     sprintf(&opis_bitow[1<<5], "1: ruchy gr%d, upr",ktory_gracz+1);
     sprintf(&opis_bitow[2<<5], "2: ruchy gr%d, li\266\346",ktory_gracz+1);
     sprintf(&opis_bitow[3<<5], "3: ruchy gr%d",2-ktory_gracz);
     sprintf(&opis_bitow[4<<5], "4: ruchy gr%d, upr",2-ktory_gracz);
     sprintf(&opis_bitow[5<<5], "5: ruchy gr%d, li\266\346",2-ktory_gracz);
     strcpy(&opis_bitow[6<<5], "6: pola bezsensowne/zakazane");
     strcpy(&opis_bitow[7<<5], "7: pola chwilowo bezsensowne");
   }
   plansze.ZwolnijPlansze(rozgrywka);
   plansze.ZwolnijPlansze(plansz_p2);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(schemat_ruchow);
   skladowe.ZwolnijSkladowa(skl_tab);
   skladowe.ZwolnijSkladowa(kolejne_ruchy);
   skladowe.ZwolnijSkladowa(ruchy_przec);
   skladowe.ZwolnijSkladowa(ang[1].zagrozenia);
   assert(twp == plansze.ile_wolnych); assert(tws==skladowe.ile_wolnych);
 }
 break;
 case 5: 
   if (DOstKropkaX()>=0)   // jest jakas kropka na planszy
   {  // grozby
   TGrozby grozby;
   unsigned char* r      = plansze.PrzydzielPlansze();
   unsigned char* r3     = plansze.PrzydzielPlansze();
   unsigned char* pp     = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   int kto = rozgr[ WezIndeksTab(DOstKropkaX()+2,DOstKropkaY()+2) ];
   ZnajdzSkladowe(skl_tab, rozgr2, kto);
   grozby.DodajGrozbySasiedzkie(rozgr, rozgr3,
				plansz_p, skl_tab, WezIndeksTab(DOstKropkaX()+2,DOstKropkaY()+2));
   grozby.UstawSing();
   CzyscTablice(tabl);
   for (int i=0; i<grozby.ile; i++)
     tabl[grozby.lista[i]] = grozby.czy_singul[i] ? 3:1;
   for (int i=2; i<wlkx+2; i++)
     for (int j=2; j<wlky+2; j++) {
       unsigned int ind=WezIndeksTab(i,j);
       if (rozgr3[ind]==0) {
	 KopiujTablice(r,rozgr);
	 KopiujTablice(r3,rozgr3);
	 KopiujTablice(pp,plansz_p);
	 int ile_zd,pow,pow2,pss;
	 ZrobPanstwo(r, NULL, NULL, r3, pp, i,j, 3-kto, ile_zd,pow,pow2,pss);
	 if (ile_zd || pow || pow2)
	   grozby.SprawdzOdpPrzec(r, r3, pp, ind);
       }
     }
   for (int i=0; i<grozby.ile; i++) {
     if (grozby.czy_singul[i]) tabl[grozby.lista[i]] |= 4;
     if (grozby.czy_bezs[i])   tabl[grozby.lista[i]] |= 8;
   }
   strcpy(&opis_bitow[0<<5], "0: wszystkie grozby");
   strcpy(&opis_bitow[1<<5], "1: byc moze singularne");
   strcpy(&opis_bitow[2<<5], "2: singularne");
   strcpy(&opis_bitow[3<<5], "3: ruchy bezs. dla przec");
   plansze.ZwolnijPlansze(r);
   plansze.ZwolnijPlansze(r3);
   plansze.ZwolnijPlansze(pp);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(skl_tab);
 }
 break;
 case 6: {  // rozne
   unsigned char* kary     = plansze.PrzydzielPlansze();
   unsigned char* zakazane = plansze.PrzydzielPlansze();
   unsigned char* rozgr2   = plansze.PrzydzielPlansze();
   unsigned char* rozgr3   = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   TAnaliza::gracz =  gr[  ktory_gracz>=0 ? ktory_gracz : WezUC(rozgr, (historia[ile_hist-1] >> 8), (historia[ile_hist-1] & 0xff))  ];
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].rozgr3 = rozgr3;
   ang[0].UstawBezpNaZawsze();
   for (int kto=1; kto<=2; kto++) {
     CzyscTablice(kary);
     ang[0].InicjujCiecia(rozgr3);
     UstawKaryBM(kary, ang[0].ciete[kto-1], zakazane,
		 rozgr2,  rozgr3, kto, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1));
     int maski[6] = {1,2,4,8,16,32};
     for (int i=0; i<wlkx4wlky4; i++) {
       tabl[i] |= (maski[kary[i]]<<(6*(kto-1)));
       int x=upl_x[i], y=upl_y[i];
       if (x>=ang[0].ciete[kto-1].poz_min[y]  && x<=ang[0].ciete[kto-1].poz_max[y] &&
	   y>=ang[0].ciete[kto-1].pion_min[x] && y<=ang[0].ciete[kto-1].pion_max[x])
	 tabl[i] |= (kto<<12);
     }
   }
   strcpy(&opis_bitow[0<<5], "0: kary==0 wokol gr 1");
   strcpy(&opis_bitow[1<<5], "1: kary==1 wokol gr 1");
   strcpy(&opis_bitow[2<<5], "2: kary==2 wokol gr 1");
   strcpy(&opis_bitow[3<<5], "3: kary==0p wokol gr 1");
   strcpy(&opis_bitow[4<<5], "4: kary==1p wokol gr 1");
   strcpy(&opis_bitow[5<<5], "5: wewn    wokol gr 1");
   strcpy(&opis_bitow[6<<5], "6: kary==0 wokol gr 2");
   strcpy(&opis_bitow[7<<5], "7: kary==1 wokol gr 2");
   strcpy(&opis_bitow[8<<5], "8: kary==2 wokol gr 2");
   strcpy(&opis_bitow[9<<5], "9: kary==0p wokol gr 2");
   strcpy(&opis_bitow[10<<5], "a: kary==1p wokol gr 2");
   strcpy(&opis_bitow[11<<5], "b: wewn    wokol gr 2");
   strcpy(&opis_bitow[12<<5], "c: ob.ciety wokol gr1");
   strcpy(&opis_bitow[13<<5], "d: ob.ciety wokol gr2");
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   plansze.ZwolnijPlansze(kary);
   plansze.ZwolnijPlansze(zakazane);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
 }
 break;
 case 7: { // podstawowe
   for (int i=0; i<wlkx4wlky4; i++) {
     tabl[i] = plansz_p[i];
     if (rozgr[i]==0 && (plansz_p[i] & 0xf)==0) tabl[i] |= 0x80;
   }
   strcpy(&opis_bitow[0<<5], "0: panstwa gr 1");
   strcpy(&opis_bitow[1<<5], "1: panstwa gr 2");
   strcpy(&opis_bitow[2<<5], "2: brzuszki gr 1");
   strcpy(&opis_bitow[3<<5], "3: brzuszki gr 2");
   strcpy(&opis_bitow[4<<5], "4: wewnetrzne gr 1");
   strcpy(&opis_bitow[5<<5], "5: wewnetrzne gr 2");
   strcpy(&opis_bitow[6<<5], "6: punktowane");
   strcpy(&opis_bitow[7<<5], "7: wolne pola");
 }
 break;
 case 8: { // robaki-ocena
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   krint *polaczony_z[2];
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[0].Przydziel();
   ang[0].robaki[1].Przydziel();
   ang[0].robaki[0].UstawCzyje(1, TAnaliza::gracz.umiejetnosci & 0x10);
   ang[0].robaki[1].UstawCzyje(2, TAnaliza::gracz.umiejetnosci & 0x10);
   ang[0].robaki[0].Inicjuj(rozgr, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[1].Inicjuj(rozgr, rozgr2, rozgr3, plansz_p);
   for (int i=0; i<2; i++) {
     polaczony_z[i] = skladowe.PrzydzielSkladowa();
     ang[0].robaki[i].UstawPolaczonyZ_sklad(polaczony_z[0]);
   }
   most12.Inicjuj();
   int przedzialy_g[16] = {20,40,60,80, 100,125,150,175, 200,240,280,320, 370,420,470, 100000};
   {
   int dolny=0;
   for (int i=0; i<16; i++) {
     sprintf(&opis_bitow[i<<5], "%c: ocena [%d-%d]", cyferki[i], dolny, przedzialy_g[i]-1);
     dolny=przedzialy_g[i];
   }
   }
   for (int i=0; i<wlkx4wlky4; i++) 
     if (upl_marg[i]>=2 && rozgr3[i]==0) {
       int poziom_bezp;
       int ocena=6*ang[0].robaki[ktory_gracz].OcenRuch(rozgr3, polaczony_z[ktory_gracz],
						       i, 1, poziom_bezp);
       if (poziom_bezp)
	 ocena+=poziom_bezp *
	   ang[0].robaki[ktory_gracz^1].OcenRuch(rozgr3, polaczony_z[ktory_gracz],
						 i, 0, poziom_bezp);
       int nr=0;
       while (ocena>=przedzialy_g[nr]) nr++;
       tabl[i] |= (1<< nr);
     }
   ang[0].robaki[0].Zwolnij();
   ang[0].robaki[1].Zwolnij();
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(polaczony_z[0]);
   skladowe.ZwolnijSkladowa(polaczony_z[1]);
 }
   break;
 }
}

/*
int TGra::TestSzybkosci(int kod, int iteracji, TStoper &czas)
  // zwraca 1, gdy ok, 0=blad
  // kody:
  // 0 = OcenPozycje12(), wariant optymistyczny
  // 1 = OcenPozycje12(), wariant pesymistyczny
{
  switch (kod) {
  case 2:
  case 3: // odczyt z ht
   break;
  case 4: // Bouzy
  case 5:
    {
      unsigned char* rozgr2 = plansze.PrzydzielPlansze();
      unsigned char* rozgr3 = plansze.PrzydzielPlansze();
      unsigned char* pom = plansze.PrzydzielPlansze();
      WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
      // znajdz terytorium
      int t=0;
      czas.Start();
      int d = kod==4?2:5;
      int e = kod==4?1:13;
      for (int i=0; i<iteracji; i++) {
	Bouzy(pom, rozgr2, rozgr3, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1), d,e, 1,1,0);   // 2 wagi i punkt_za_pole
	t+=pom[11];
      }
      plansze.ZwolnijPlansze(pom);
      plansze.ZwolnijPlansze(rozgr2);
      plansze.ZwolnijPlansze(rozgr3);
    }
    return 1;
  }
}
*/

void TGra::TZapis::Zapisz(FILE *f)
{   
  unsigned char buf[44];
  int ile=0;
  ile += ZapiszSI(&buf[ile], wx);
  ile += ZapiszSI(&buf[ile], wy);
  ile += ZapiszSI(&buf[ile], ik);
  ile += ZapiszSI(&buf[ile], ile_zd1);
  ile += ZapiszSI(&buf[ile], ile_zd2);
  ile += ZapiszSI(&buf[ile], slowo);
  ile += ZapiszSI(&buf[ile], wersja_hi);
  ile += ZapiszSI(&buf[ile], wersja_lo);

  ile += ZapiszLI(&buf[ile], data_utw);
  ile += ZapiszLI(&buf[ile], zarp1);
  ile += ZapiszLI(&buf[ile], zarp2);
  ile += ZapiszLI(&buf[ile], zark1);
  ile += ZapiszLI(&buf[ile], zark2);
  ile += ZapiszLI(&buf[ile], ktory_sezon);
  ile += ZapiszLI(&buf[ile], ktory_mecz);
  assert(ile==sizeof(buf));
  fwrite(buf, 1, ile, f);
}

int TGra::TZapis::Odczytaj(FILE *f)
// zwraca liczbe odczytanych bajtow
{
  unsigned char buf[44];
  int wynik = fread(buf, 1, 44, f);
  wx = ShortInt(&buf[0]);
  wy = ShortInt(&buf[2]);
  ik = ShortInt(&buf[4]);
  ile_zd1 = ShortInt(&buf[6]);
  ile_zd2 = ShortInt(&buf[8]);
  slowo = ShortInt(&buf[10]);
  wersja_hi = ShortInt(&buf[12]);
  wersja_lo = ShortInt(&buf[14]);

  data_utw = LongInt(&buf[16]);
  zarp1 = LongInt(&buf[20]);
  zarp2 = LongInt(&buf[24]);
  zark1 = LongInt(&buf[28]);
  zark2 = LongInt(&buf[32]);
  ktory_sezon = LongInt(&buf[36]);
  ktory_mecz = LongInt(&buf[40]);
  return wynik;
}

void TGra::ZapiszRozgr(FILE *f, int ktory_sezon, int ktory_mecz)
  // Zapisuje rozgrywke.
  // Format zapisu:
  //  0-5 short int wlkx, wlky, ile_kropek (=ile_hist-1);
  //  6-9 short int ile_zd1, ile_zd2;   (tylko do wyswietlania i statystyki)
  //  10-11 unsigned short int slowo;  (slowo stanu -- na razie zdefiniowany
  //           tylko bit 0: zakonczona rozgrywka?
  //                 bit 1: ktory gracz na ruchu 0-1?)
  //                 bit 2: czy zakonczona gra srodkowa? (83.37+, wczesniej zawsze 0)
  //  12-15 short int num_wersji_hi, num_wersji_lo;
  //  16-19 long int data_utw;  (=liczba sekund od 1 I 1970 roku)
  //  20-27 long int zarodek_pocz1, zarodek_pocz2;
  //  28-35 long int zarodek_kon1, zarodek_kon2;  // to ma sens tylko dla
  //               niezakonczonych rozgrywek
  //  36-43 long int ktory_sezon, ktory_mecz   // na potrzeby turnieju (normalnie =0)
  //  44-67 TStoper.Zapisz() x3  // czas gry (stoper[3])
  //  68-71 short int ile_zd_do_konc[2];   (do wysw. i stat., ile zd. w grze srodkowej)
  //  72-79  0,0,...,0  zarezerwowane
  //   unsigned short int historia_[wlkx*wlky]
  //  w historii pamietamy kolejne ruchy, a w najstarszym bicie - czyj ruch
  //  (gracza 0 czy 1?)
{
  TZapis zapis;
  zapis.wx = wlkx;
  zapis.wy = wlky;  
  zapis.ik = ile_hist-1;
  zapis.ile_zd1 = ile_zd[0];
  zapis.ile_zd2 = ile_zd[1];
  zapis.slowo = (ktory_gracz==-1) | ((ktory_gracz==1)<<1) | (koncowka ? 4:0);
  zapis.wersja_hi = WERSJA_KROPEK;
  zapis.wersja_lo = WERSJA_KROPEK_LOW;
  time_t now;  time(&now);
  zapis.data_utw = now;
  zapis.zarp1 = zarodek_pocz[0];
  zapis.zarp2 = zarodek_pocz[1];
  zapis.zark1 = bseed1;
  zapis.zark2 = bseed2;
  zapis.ktory_sezon= ktory_sezon;
  zapis.ktory_mecz = ktory_mecz;
  long int gdzie = ftell(f);
  zapis.Zapisz(f); //  fwrite(&zapis, 1, sizeof(zapis), f);
  for (int i=0; i<3; i++) stoper[i].Zapisz(f);
  assert(sizeof(ile_zd_do_konc[0])==2);
  {  
    unsigned char buf[4];
    ZapiszSI(&buf[0], ile_zd_do_konc[0]);
    ZapiszSI(&buf[2], ile_zd_do_konc[1]);
    fwrite(buf, 1, 4, f);  //  fwrite(ile_zd_do_konc, 2, 2, f);
  }
  int ile = gdzie +80 - ftell(f);
  static unsigned char zera[] = {0,0,0,0,0,0, 0,0,0,0,0,0};
  fwrite(zera, 1, ile, f);
  // zapisz historie
  unsigned char *pom = new unsigned char[2*wlkx*wlky];
  memset(pom, 0, 2*wlkx*wlky);
  for (int i=1; i<ile_hist; i++) {
    unsigned short int ind = WezIndeksTab((historia[i] >> 8), (historia[i] & 0xff));
    ZapiszSI(&pom[2*(i-1)], ind);
    if (rozgr[ind]==2) pom[2*(i-1)+1]|=0x80;
  }
  fwrite(pom, 1, 2*wlkx*wlky, f);
  delete[] pom;

  /*
  unsigned short int *pom = new unsigned short int[wlkx*wlky];
  memset(pom, 0, sizeof(pom[0])*wlkx*wlky);
  for (int i=1; i<ile_hist; i++) {
    pom[i-1] = 
      WezIndeksTab((historia[i] >> 8), (historia[i] & 0xff));
    if (rozgr[pom[i-1]]==2) pom[i-1]|=0x8000;
  }
  fwrite(pom, sizeof(pom[0]), wlkx*wlky, f);
  delete[] pom;
  */
}

int TGra::OdczytajRozgr(FILE *f, int *numery)
  // zobacz komentarz do ZapiszRozgr()
  // zwraca 1, gdy odczyta; 0, gdy blad 
  //  (w razie bledu wskaznik pliku bez zmian)
{
  TZapis zapis;
  long int gdzie = ftell(f);
  zapis.Odczytaj(f);  //  fread(&zapis, 1, sizeof(zapis), f);
  if (zapis.wx>max_bok_planszy || zapis.wy>max_bok_planszy ||
      zapis.wx<min_bok_planszy || zapis.wx<min_bok_planszy)
    { fseek(f, gdzie, SEEK_SET);
    return 0;
    }
  NowaGra(zapis.wx, zapis.wy);
  for (int i=0; i<3; i++) stoper[i].Odczytaj(f);
  assert(sizeof(ile_zd_do_konc[0])==2);
  //  fread(ile_zd_do_konc, 2, 2, f);
  {
    unsigned char buf[4];
    fread(buf, 1, 4, f);
    ile_zd_do_konc[0] = ShortInt(&buf[0]);
    ile_zd_do_konc[1] = ShortInt(&buf[2]);
  }
  koncowka = (zapis.slowo & 4)!=0;
  fseek(f, gdzie +80, SEEK_SET);
  // odczytaj historie
  /*
  unsigned short int *pom = new unsigned short int[wlkx*wlky];
  fread(pom, sizeof(pom[0]), zapis.wx*zapis.wy, f);
  historia[0]=0;  ile_hist=1;
  for (int i=0; i<zapis.ik; i++) {
    int x = upl_x[pom[i] & (~0x8000)];
    int y = upl_y[pom[i] & (~0x8000)];
    ktory_gracz = ((pom[i] & 0x8000) != 0);
    WykonajRuch(x,y, 1);
    }
  delete[] pom;
  */
  unsigned char *pom = new unsigned char[2*wlkx*wlky];
  fread(pom, 1, 2*zapis.wx*zapis.wy, f);
  historia[0]=0;  ile_hist=1;
  for (int i=0; i<zapis.ik; i++) {
    unsigned short int pomsi = ShortInt(&pom[2*i]);
    int x = upl_x[pomsi & (~0x8000)];
    int y = upl_y[pomsi & (~0x8000)];
    ktory_gracz = ((pomsi & 0x8000) != 0);
    WykonajRuch(x,y, 1);
    }
  delete[] pom;
  // ustaw numery
  if (numery!=NULL) { 
    numery[0] = zapis.ktory_sezon;
    numery[1] = zapis.ktory_mecz;
  }
  // ustaw gracza na ruchu
  ktory_gracz = (zapis.slowo&1) ? -1 : ((zapis.slowo & 2) != 0);
  // i zarodki
  bseed1 = zapis.zark1;
  bseed2 = zapis.zark2;
  return 1;
}


int TGra::OdczytajInfoOMeczu(FILE *f, TMecz& m, int tylko_gra_srodkowa)
// 0 == koniec pliku lub niedokonczona rozgrywka
// w przeciwnym razie zwraca indeks pola startowego
{
  TZapis zapis;
  long int gdzie = ftell(f);
  if (zapis.Odczytaj(f) < sizeof(zapis))
    return 0;
  m.nr_sez  = zapis.ktory_sezon;
  m.nr_mecz = zapis.ktory_mecz;
  for (int i=0; i<3; i++) m.czas[i].Odczytaj(f);
  if (tylko_gra_srodkowa) {
    unsigned char buf[4];
    fread(buf, 1,4,f);
    zapis.ile_zd1 = ShortInt(&buf[0]);
    zapis.ile_zd2 = ShortInt(&buf[2]);
  }
  m.ile_zd[0] = zapis.ile_zd1;
  m.ile_zd[1] = zapis.ile_zd2;
  fseek(f, gdzie + 80, SEEK_SET);
  krint pole_start;
  {
    unsigned char buf[2];
    fread(buf, 1,2,f);
    pole_start = ShortInt(buf);
  }
  fseek(f, gdzie + 80 + 2*zapis.wx*zapis.wy, SEEK_SET);
  return (zapis.slowo & 1) ? pole_start : 0;
}

int TGra::DInfoOPliku(const char* nazwa, int& wx, int& wy, int& ile,
                TGraczO* gracze, int* ile_zd, int* pow_ss)
// Kazdy ze wskaznikow gracze, ile_zd, pow_ss moze byc == NULL.
// zwraca 0, gdy plik nie istnieje
//  lub wartosc DInfoOPliku(plik)
{
 FILE *f = fopen(nazwa,"rb");
 if (f==NULL) return 0;
 int r=DInfoOPliku(f, wx,wy,ile,gracze,ile_zd,pow_ss);
 fclose(f);
 return r;
}

int TGra::DInfoOPliku(FILE* f, int& wx, int& wy, int& ile, TGraczO *gracze,
                int *ile_zd, int *pow_ss)
// Kazdy ze wskaznikow gracze, ile_zd, pow_ss moze byc == NULL.
// zwraca 1 - zakonczona rozgrywka, plik ok
//        2 - niezakonczona rozgrywka, ruch gracza 1, plik ok
//        3 - niezakonczona rozgrywka, ruch gracza 2, plik ok
//        4 - plik .t turnieju, ok
//        5 - plik .m turnieju, ok
//        9,10,11 - rozgrywka w wersji 15, plik ok, odp.: zakonczona, na ruchu 1,2
  //      12- plik .t turnieju w wersji 15, ok
// ujemna wartosc -- blad:
//  -1  zly ID
//  -2  zla wersja
//  -3  zly rozmiar planszy
//  -4  nieznany gracz
//  -5  za duzo lub za malo graczy (tylko dla turnieju, plik .t)
// wstawia
//   (wx,wy) - wielkosc planszy (typ pliku 1,2,3,4)
//    wx     - numer wersji (typ pliku 5)
//    ile    - ile kropek (typ 1,2,3), ile graczy (typ 4,12), ile sezonow (typ 5)
//    gracze - gracze (typ 1,2,3,4,12)
//    ile_zd,pow_ss - tylko dla typu 1,2,3
// W razie bledu nie zmienia wartosci *gracze, *ile_zd, *pow_ss,
// ale zmienia wx,wy,ile, jesli tylko blad jest <-2.
// W przypadku, gdy nie ma bledu, i plik jest typu 1,2,3,6 to wskaznik
// pliku jest ustawiony na poczatek tablic (rozgrywka, stopy, ...).
// UWAGA: W przypadku typu 9-11 nie ustawia ile_zd ani pow_ss (w wersji 15
//        te informacje sa w rozgrywce).
//
// Moga byc klopoty, jesli wolajacy spodziewa sie, ze podany plik
// ma n graczy, a w rzeczywistosci ma wiecej... (mozliwe np. przy podmianie
// dyskietki).
//
// Format pliku .z  (typ 1,2,3)
//   offset   typ        opis
//     +0     char[4]    'krob' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (11-14)
//     +6     int        wlkx planszy
//     +8     int        wlky planszy
//     +10    int        ile w historii (==ile postawiono kropek+1)
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int[7]     wolne pola (==0)
//     +32    TGracz[2]  gracze
//   kolejno...  rozgrywka, stopy, plansz_p, historia
// Wszystkie te tablice sa zapisane bez zadnego oszczedzania, tj. kazda
// ma (wlkx+4)*(wlky+4) pol.
// Uwagi: TGracz jest zapisywane bez ostatniego pola umiejetnosci (w. 11,12).
// Wersja 11 zapisuje przejmuje_sie wg starych zasad, 12 -- wg nowych.
// Wersja 13 zapisuje jak 12, ale z polem umiejetnosci.
// Wersja 14 ,,zna'' poziom 12 i nowy format agresji.
// Pola [+12] i [+14] pojawily sie w wersji 80 kropek.
//
// Format pliku .t  (typ 4)
//   offset   typ        opis
//     +0     char[4]    'krot' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (10-12)
//     +6     int        wlkx planszy (plx)
//     +8     int        wlky planszy (ply)
//     +10    int        ile_graczy
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int[7]     wolne pola (==0)
//     +32    TGracz[ile_graczy]  gracze
// Wersje plikow:
//    10  -- stary format przejmuje_sie, bez pola umiejetnosci
//    11  -- nowy format przejmuje_sie, bez pola umiejetnosci
//    12  -- nowy format przejmuje_sie, z polem umiejetnosci
// Pola [+12] i [+14] pojawily sie w wersji 80 kropek.
  // Typ 12: jak wyzej, a potem TKalendarzRozgr i kolejne rozgrywki
//
// Format pliku .m  (typ 5)
//   offset   typ        opis
//     +0     char[4]    'krom' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (teraz 10)
//     +6     int        ile_sezonow (juz w calosci rozegranych), czyli aktualny sezon
//     +8     int[12]    wolne pola (==0)
//     +32    TMecz[ile_meczow_w_sezonie]    (ile_sezonow+1 razy)
//
// Format pliku .z (typ 9-11 -- wersja pliku==15)
//   offset   typ        opis
//     +0     char[4]    'krob' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (15)
//     +6     int        wlkx planszy
//     +8     int        wlky planszy
//     +10    int        ile w historii (==ile postawiono kropek+1)
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int[7]     wolne pola (==0)
//     +32    TGraczO[2] gracze -- zob. TGraczO::Odczytaj()
//     +...   rozgrywka  -- zob. ZapiszRozgr().
{
 fseek(f,0,SEEK_SET);
 unsigned char nagl[32];
 memset(nagl, 0, 32);
 fread(nagl, 1, 32, f);
 if (nagl[0]!='k' || nagl[1]!='r' || nagl[2]!='o')
   return -1;  // nieprawidlowy ID
 int typ_pliku, wersja=nagl[4] + (nagl[5]<<8);
 switch (nagl[3])
   {
   case 'b':
     typ_pliku = 1;
     if (wersja<11 || wersja>15) return -2;   // nieznana wersja
     break;
   case 't':
     typ_pliku = 12;
     if (wersja!=15) return -2;   // nieznana wersja
     break;
   case 'm':
     // typ_pliku = 5;
     if (wersja!=10) return -2;   // nieznana wersja
     ile = (nagl[7] << 8) + nagl[6];
     wx = wersja;
     return 5;
   default:
     return -1;   // nieprawidlowy ID
   }
 wx = (nagl[7] << 8) + nagl[6];
 wy = (nagl[9] << 8) + nagl[8];
 ile = (nagl[11] << 8) + nagl[10];
 if (typ_pliku==1) ile--;   // z ile_hist zrob liczbe kropek
 if (wx>max_bok_planszy || wy>max_bok_planszy ||
     wx<min_bok_planszy || wx<min_bok_planszy)
   return -3;   // zly rozmiar planszy
 if (typ_pliku==12 && (ile<2 || ile>MAX_GRACZY_W_TURN))
   return -5;  // za duzo graczy
 int ile_graczy = (typ_pliku==12) ? ile : 2;
 TGraczO test_gr;
 if (wersja==15) {
   for (int i=0; i<ile_graczy; i++)
     if (!test_gr.Odczytaj(f)) return -4;  // nieznany gracz
   if (gracze!=NULL) { // wez informacje o graczach, jesli trzeba
     fseek(f, 32, SEEK_SET);
     for (int i=0; i<ile_graczy; i++)
       gracze[i].Odczytaj(f);
   }
   if (typ_pliku==12) {  // turniej
     int zap = ftell(f);
     short int ile_meczow_w_sez;
     //     fread(&ile_meczow_w_sez, 1, sizeof(ile_meczow_w_sez), f);
     {
       unsigned char buf[2];
       fread(buf, 1,2, f);
       ile_meczow_w_sez = ShortInt(buf);
     }
     fseek(f, ile_meczow_w_sez*sizeof(TKalendarzRozgr::TMecz), SEEK_CUR);
     int pocz = ftell(f);
     fseek(f, 0, SEEK_END);
     // ponizej jest -1, bo interesuja nas pelne sezony
     int ile = (ftell(f)-pocz-1) / ((80+2*wx*wy)*ile_meczow_w_sez);  // zob. TGra::ZapiszRozgr()
     fseek(f, zap, SEEK_SET);
     return 12;
   }
   TZapis zapis;
   zapis.Odczytaj(f); // fread(&zapis, 1, sizeof(zapis), f);
   fseek(f, -sizeof(zapis), SEEK_CUR);
   int kto = (zapis.slowo&1) ? -1 : ((zapis.slowo & 2) != 0);
   return 10+kto;   // rozgrywka w wersji 15
 }
 int dlug_TGracz = ((wersja + (typ_pliku==4)) >= 13) ? 48:46;
 int koniec_gry=0;
 unsigned char grs[12][48];
 for (int i=0; i<ile_graczy; i++)
   {
   grs[i][46]=1|4; grs[i][47]=0;  // ustaw umiejetnosci w razie gdyby dlug_TGracz==46
   fread(grs[i], 1, dlug_TGracz, f);
   if (!test_gr.Wstaw(grs[i]))
     return -4;  // nieznany gracz
   if (typ_pliku==4 && !test_gr.komputer)
     return -4;  // czlowiek w turnieju = nieznany gracz
   if (typ_pliku<4)
   if (grs[i][40]==0xff)   // koniec gry?
     koniec_gry++;
   else if (grs[i][40]==0)  // nie na ruchu?
     typ_pliku=3-i;
   }
 if (typ_pliku==1 && koniec_gry!=2)
   return -4;  // nie wiadomo, kto na ruchu -- blad ,,nieznany gracz''
 if (gracze!=NULL)  // wez informacje o graczach, jesli trzeba
 for (int i=0; i<ile_graczy; i++)
   {
   gracze[i].Wstaw(grs[i]);
   if (typ_pliku!=4)
     {
     if (ile_zd!=NULL)
       ile_zd[i] = grs[i][42] + (grs[i][43] << 8);
     if (pow_ss!=NULL)
       pow_ss[i] = grs[i][44] + (grs[i][45] << 8);
     }
   }
 return typ_pliku;
}


void TGra::StoperyOdNowa()
{
  for (int i=0; i<3; i++) {
    stoper[i].Stop();
    stoper[i].Start();
    if ((i<2 && i!=ktory_gracz) || (tryb & TRYB_PAUZA))
      stoper[i].Wstrzymaj();
  }
}

void TGra::StoperyWstrzymaj()
{
  for (int i=0; i<3; i++) stoper[i].Wstrzymaj();
}

void TGra::StoperyWznow()
{
  if ((tryb & TRYB_PAUZA)==0) {
    if (ktory_gracz>=0) {
      stoper[ktory_gracz].Wznow();  
      stoper[1-ktory_gracz].Wstrzymaj();
    }
    else for (int i=0; i<2; i++) stoper[i].Wstrzymaj();
    stoper[2].Wznow();
  }
  else for (int i=0; i<3; i++) stoper[i].Wstrzymaj();
}

void TGra::StoperyStop()
{
  for (int i=0; i<3; i++) stoper[i].Stop();
}


int main(int argc,char *arg[])
{
 UstawZobrist();
 brandomize();

 printf("Kropki.\n");
 statystyka_dla_analizy.funk_ocen = statystyka_dla_analizy.wez_ht = 0;
 for (int i=0; i<4; i++)
   statystyki_prog.ht_kolizja[i]=0;

 #ifdef TEKSTOWY
 {
   TSlowa opcje;
   if (opcje.Wczytaj("kropki.cfg")) {
     int pom=atoi(opcje["tabl_mieszajaca"]);
     if (pom>2000) pom=2000;
     if (pom>=3 && pom<=2000) {
       pom<<=20;  // przelicz na megabajty
       int podstawa=16;
       for (;;) {
	 long long int pamiec = sizeof(HTablicaZKl) * 2;
	 pamiec <<= podstawa;
	 if (pamiec<=pom)
	   HTABZ_ILE_TAB = 1u << podstawa;
	 else break;
	 // wez nastepny
	 podstawa++;
       }
       HTABZ_MASKA = HTABZ_ILE_TAB-1;

     }
     if (!slowa.Wczytaj(opcje["text"]) && !slowa.Wczytaj("kropkipl")) {
       printf("Nie ma pliku z tekstami!\n");
       return 1;
     }
   }
   else if (!slowa.Wczytaj("kropkipl")) {
       printf("Nie ma pliku z tekstami!\n");
       return 1;
   }
 }
 if (argc>=2)
   {
   plansze.PrzydzielPamiec();
   skladowe.PrzydzielPamiec();
   tabliceLI.PrzydzielPamiec();
   gra.PrzydzielPamiec();
   pargry.tryb = TRYB_TURNIEJ;
   strcpy(pargry.nz1, arg[1]);
   pargry.kod=1;
   gra.ObsluzZdarzenie(ZD_TRYB);
   if (gra.DTryb()!=TRYB_TURNIEJ) return 1;   // blad w pliku (inf. sie juz wyswietlila)
   }
 else  { printf("Potrzebny parametr: nazwa pliku turnieju (z roszszerzeniem).\n"); return 1; }
 #else

 int rx=640, ry=480;
#ifdef __XWIN__
 rx=750;   // domyslna wartosc dla XWIN
#endif
 // wez opcje z pliku ,,kropki.cfg''
 {
   strcpy(nazwa_pliku_pomocy, "krpomoc");
   TSlowa opcje;
   if (opcje.Wczytaj("kropki.cfg")) {
     rx = atoi(opcje["rozdzx"]);
     ry = atoi(opcje["rozdzy"]);
     int pom;
#ifndef USTALONA_WLK_PLANSZY
     pom=atoi(opcje["wlkx"]);
     if (pom>=min_bok_planszy && pom<=max_bok_planszy) wlkx=pom;
     pom=atoi(opcje["wlky"]);
     if (pom>=min_bok_planszy && pom<=max_bok_planszy) wlky=pom;
#endif
     if (strcmp(opcje["imie1"],"???")) gra.UstawImie(0, opcje["imie1"]);
     if (strcmp(opcje["imie2"],"???")) gra.UstawImie(1, opcje["imie2"]);
     //
     pom=atoi(opcje["tabl_mieszajaca"]);
     if (pom>2000) pom=2000;
     if (pom>=3 && pom<=2000) {
       pom<<=20;  // przelicz na megabajty
       int podstawa=16;
       for (;;) {
	 long long int pamiec = sizeof(HTablicaZKl) * 2;
	 pamiec <<= podstawa;
	 if (pamiec<=pom)
	   HTABZ_ILE_TAB = 1u << podstawa;
	 else break;
	 // wez nastepny
	 podstawa++;
       }
       HTABZ_MASKA = HTABZ_ILE_TAB-1;

     }
     if (!slowa.Wczytaj(opcje["text"]) && !slowa.Wczytaj("kropkipl")) {
       printf("Nie ma pliku z tekstami!\n");
       return 1;
     }
     if (strcmp(opcje["pomoc"], "???")==0)
       strcpy(nazwa_pliku_pomocy, opcje["pomoc"]);
     ekran.WezOpcje(opcje);
   }
   else if (!slowa.Wczytaj("kropkipl")) {
     printf("Nie ma pliku z tekstami!\n");
     return 1;
     }
 }
 // wez opcje z parametrow wywolania
 if (argc>=2) {
   rx = atoi(arg[1]);
   if (argc>=3)
     ry = atoi(arg[2]);
   else ry = (3*rx)/4;
 }
#ifdef __XWIN__
 if (rx<=0 || rx>2000) rx=750;
 if (ry<=0) ry=480;
 if (rx<=ry) ry=(3*rx)/4;
#else
 if (rx<800) rx=640;
 else if (rx<1024) rx=800;
 else rx=1024;
 ry=(3*rx)/4;
#endif

 plansze.PrzydzielPamiec();
 skladowe.PrzydzielPamiec();
 tabliceLI.PrzydzielPamiec();
 gra.PrzydzielPamiec();

 GrSetMode(GR_width_height_color_graphics, rx,ry,16);
 rx=GrSizeX();   ry=GrSizeY();
 GrMouseInit();
 GrMouseDisplayCursor();

 if (!GrMouseDetect())
  {
  printf("Nie ma myszy ?!");
  return 0;
  }
 {
 char tytul[80];
 sprintf(tytul, "Kropki %d.%d",int(WERSJA_KROPEK), int(WERSJA_KROPEK_LOW));
 GrSetWindowTitle(tytul);
 }
// ekran.InicjujKolory();
 ekran.UstawRozdzielczosc(rx,ry);
 ekran.WyswietlWszystko();
 #endif

 htablicaZ.PrzydzielPamiec();

 ekran.UstawWersje(WERSJA_KROPEK, WERSJA_KROPEK_LOW, 
		   HTABZ_ILE_TAB, 2, sizeof(HTablicaZKl));
 gra.GlownaPetla();
 #ifndef TEKSTOWY
 GrClose();
 #endif

}


