/*   Programik do gry w kropki.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006,2007 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "pla_skl.h"

//#define POKAZ_ILE_PAMIECI

#ifdef POKAZ_ILE_PAMIECI
int max_s=0, max_p=0, max_li=0, max_r=0;
void PokazIlePamieci()
{ printf("Wykorzystanie: pl = %d, s = %d, li = %d.\n",max_p, max_s, max_li); }
#endif

// upl to skrot od Ustalone PLansze
unsigned char upl_x[(max_bok_planszy+4)*(max_bok_planszy+4)];
unsigned char upl_y[(max_bok_planszy+4)*(max_bok_planszy+4)];
// upl_marg ma wartosc zero na samym brzegu tablicy, a pozniej kolejno 1,2,...
// (np. pole [...] jest wewn. planszy <=> upl_marg[...] >= 2)
unsigned char upl_marg[(max_bok_planszy+4)*(max_bok_planszy+4)];

extern struct Tup up;

void Tup::Ustaw()
{
  lg = 2*(wlky+4)+2;
  pd = (wlkx+1)*(wlky+4) + wlky+1;
  dind[0]=W_L;   dind[1]=W_G;   dind[2]=W_D;   dind[3]=W_P;
  dind[4]=W_LG;  dind[5]=W_LD;  dind[6]=W_PG;  dind[7]=W_PD;
  dind[8 ]=W_LLG;  dind[9 ]=W_LL;  dind[10]=W_LLD;
  dind[11]=W_LGG;  dind[12]=W_LDD; dind[13]=W_GG;
  dind[14]=W_DD;   dind[15]=W_PGG; dind[16]=W_PDD;
  dind[17]=W_PPG;  dind[18]=W_PP;  dind[19]=W_PPD;
  dind[20]=W_LLGG;  dind[21]=W_LLDD;  dind[22]=W_PPGG;  dind[23]=W_PPDD;
}

void TSkladowe::PrzydzielPamiec()
{
#ifndef USTALONA_WLK_PLANSZY
 wlkx4wlky4 = (wlkx+4)*(wlky+4);
#endif
 pam = (wlkx4wlky4 + 1) & ~0x1;
 skladowe[0] = (krint*) malloc(pam*ile_skladowych*sizeof(krint));
 assert(skladowe[0]!=NULL);
 for (int i=0; i<ile_skladowych; i++)
   { 
   if (i) skladowe[i] = &skladowe[i-1][pam];
   czy_zajete[i]=0;  ktore_wolne[i]=i;  gdzie_w_wolne[i]=i; 
   }
 ile_wolnych = ile_skladowych;
}

TSkladowe::TSkladowe()
{}

void TSkladowe::ZwolnijPamiec()
{
  free(skladowe[0]);
}

TSkladowe::~TSkladowe()
{
 ZwolnijPamiec();
}

krint* TSkladowe::PrzydzielSkladowa()
{
  if (ile_wolnych) {
    int nr = ktore_wolne[--ile_wolnych];
    czy_zajete[nr]=1;
#ifdef POKAZ_ILE_PAMIECI
    if (ile_skladowych-ile_wolnych > max_s) {
      max_s = ile_skladowych-ile_wolnych; PokazIlePamieci(); }
#endif
    return skladowe[nr];
  }
  abort();
  return NULL;
}

skrint* TSkladowe::PrzydzielSkladowaI()
{ return (skrint*) PrzydzielSkladowa(); }

void TSkladowe::ZwolnijSkladowa(krint* co)
{
  int nr = (co - skladowe[0]) / pam;
  //  assert(co==skladowe[nr]);
  if (czy_zajete[nr]) {
    czy_zajete[nr] = 0;
    gdzie_w_wolne[nr] = ile_wolnych;
    ktore_wolne[ile_wolnych++] = nr;
  }
  return;
  /*
  int l=0, p=ile_skladowych-1;
  do {
    int s=(l+p)>>1;
    if (co>skladowe[s]) l=s;
    else if (co<skladowe[s]) p=s;
    else {
      if (czy_zajete[s]) {
	czy_zajete[s] = 0;
	gdzie_w_wolne[s] = ile_wolnych;
	ktore_wolne[ile_wolnych++] = s;
      }
      return;
    }
  }
  while (l+1<p);
  if (co==skladowe[l] && czy_zajete[l]) {
    czy_zajete[l] = 0;
    gdzie_w_wolne[l] = ile_wolnych;
    ktore_wolne[ile_wolnych++] = l;
    return;
  }
  if (co==skladowe[p] && czy_zajete[p]) {
    czy_zajete[p] = 0;
    gdzie_w_wolne[p] = ile_wolnych;
    ktore_wolne[ile_wolnych++] = p;
    return;
  }
  */
}

void TSkladowe::ZwolnijSkladowa(skrint* co)
{ ZwolnijSkladowa((krint*) co); }


void TPlansze::PrzydzielPamiec()
{
#ifndef USTALONA_WLK_PLANSZY
 wlkx4wlky4 = (wlkx+4)*(wlky+4);
#endif
 pam = (wlkx4wlky4 + 3) & ~0x3;
 plansze[0] = (unsigned char*) malloc(pam*ile_planszy);
 assert(plansze[0]!=NULL);
 for (int i=0; i<ile_planszy; i++)
   { 
   if (i) plansze[i] = &plansze[i-1][pam];
   czy_zajete[i]=0;  ktore_wolne[i]=i;  gdzie_w_wolne[i]=i; 
   }
 ile_wolnych = ile_planszy;
 // ustaw ustalone plansze
 unsigned int indeks = 0;
 for (int i=0; i<wlkx+4; i++)
  for (int j=0; j<wlky+4; j++)
   {
   upl_x[indeks]=i;      upl_y[indeks]=j;
   int odl = (i<j) ? i:j;
   if (wlkx+3-i<odl) odl = wlkx+3-i;
   if (wlky+3-j<odl) odl = wlky+3-j;
   upl_marg[indeks] = odl;
   indeks++;
   }
 up.Ustaw();   // ustaw ustalone pomocnicze
}

TPlansze::TPlansze()
{}

void TPlansze::ZwolnijPamiec()
{
  free(plansze[0]);
}

TPlansze::~TPlansze()
{
 ZwolnijPamiec();
}

unsigned char* TPlansze::PrzydzielPlansze()
{
  if (ile_wolnych) {
    int nr = ktore_wolne[--ile_wolnych];
    czy_zajete[nr]=1;
#ifdef POKAZ_ILE_PAMIECI
    if (ile_planszy-ile_wolnych > max_p) {
      max_p = ile_planszy-ile_wolnych; PokazIlePamieci(); }
#endif
    return plansze[nr];
  }
  abort();
  return NULL;
}

void TPlansze::ZwolnijPlansze(unsigned char* co)
{
  int nr = (co - plansze[0]) / pam;
  //  assert(co==plansze[nr]);
  if (czy_zajete[nr]) {
    czy_zajete[nr] = 0;
    gdzie_w_wolne[nr] = ile_wolnych;
    ktore_wolne[ile_wolnych++] = nr;
  }
  return;
  /* 
  int l=0, p=ile_planszy;
  do {
    int s=(l+p)>>1;
    if (co>plansze[s]) l=s+1;
    else if (co<plansze[s]) p=s;
    else {
      if (czy_zajete[s]) {
	czy_zajete[s] = 0;
	gdzie_w_wolne[s] = ile_wolnych;
	ktore_wolne[ile_wolnych++] = s;
      }

      assert(s==nr);

      return;
    }
  }
  while (l<p);
  assert(1);
  */
}

//

void TTabliceLI::PrzydzielPamiec()
{
#ifndef USTALONA_WLK_PLANSZY
 wlkx4wlky4 = (wlkx+4)*(wlky+4);
#endif
 for (int i=0; i<ILE_TABLIC_LI; i++)
	{
	if ( (tab[i] = (long int*) malloc(wlkx4wlky4*sizeof(long int))) ==NULL)
	  {
	  printf("TabliceLI[%d]: Za malo pamieci.",i);
	  abort();
	  }
	zajete[i]=0;
	}
}

TTabliceLI::TTabliceLI()
{}

void TTabliceLI::ZwolnijPamiec()
{
 for (int i=0; i<ILE_TABLIC_LI; i++)
	if (tab[i] != NULL) free(tab[i]);
}

TTabliceLI::~TTabliceLI()
{
 ZwolnijPamiec();
}

long int* TTabliceLI::Przydziel()
{
 for (int i=0; i<ILE_TABLIC_LI; i++)
   if (!zajete[i])
     {
       zajete[i]=1;
#ifdef POKAZ_ILE_PAMIECI
       int ile_zajetych=0;
       for (int j=0; j<ILE_TABLIC_LI; j++)
	 if (zajete[j]) ile_zajetych++;
       if (ile_zajetych > max_li) {
	 max_li = ile_zajetych; PokazIlePamieci(); }
#endif
       return tab[i];
     }
 abort();
 return NULL;
}

void TTabliceLI::Zwolnij(long int* co)
{
 for (int i=0; i<ILE_TABLIC_LI; i++)
   if (tab[i]==co)
     {
       zajete[i]=0;
       return;
     }
}

int TTabliceLI::IleWolnych()
{
  int ile=0;
  for (int i=0; i<ILE_TABLIC_LI; i++)
    if (!zajete[i]) ile++;
  return ile;
}

//---------------------------------------

int TTabliceR::IlePam(int wx, int wy)
{
  return 4*wx*wy;   // max liczba ruchow
}

void TTabliceR::PrzydzielPamiec()
{
  pam = (IlePam(wlkx, wlky) + 12) & ~0x3;   // do 12 na zapas
  tab[0] = (krint*) malloc(pam*ILE_TABLIC_R*sizeof(krint));
  assert(tab[0]!=NULL);
  for (int i=0; i<ILE_TABLIC_R; i++)
   { 
   if (i) tab[i] = &tab[i-1][pam];
   czy_zajete[i]=0;  ktore_wolne[i]=i;  gdzie_w_wolne[i]=i; 
   }
  ile_wolnych = ILE_TABLIC_R;
}

TTabliceR::TTabliceR()
{}

void TTabliceR::ZwolnijPamiec()
{
  free(tab[0]);
}

TTabliceR::~TTabliceR()
{
  ZwolnijPamiec();
}

krint* TTabliceR::Przydziel()
{
  if (ile_wolnych) {
    int nr = ktore_wolne[--ile_wolnych];
    czy_zajete[nr]=1;
#ifdef POKAZ_ILE_PAMIECI
    if (ILE_TABLIC_R-ile_wolnych > max_r) {
      max_r = ILE_TABLIC_R-ile_wolnych; PokazIlePamieci(); }
#endif
    return tab[nr];
  }
  abort();
  return NULL;
}

void TTabliceR::Zwolnij(krint* co)
{
  int nr = (co - tab[0]) / pam;
  //  assert(co==tab[nr]);
  if (czy_zajete[nr]) {
    czy_zajete[nr] = 0;
    gdzie_w_wolne[nr] = ile_wolnych;
    ktore_wolne[ile_wolnych++] = nr;
  }
}
