/*   Programik do gry w kropki -- deklaracje podstawowych klas.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006,2007,2008 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef EKROXXYY__H
#define EKROXXYY__H

#include <assert.h>
#include "pla_skl.h"
#include "stoper.h"
#include "slownik.h"
#ifndef TEKSTOWY
  #include "X2grx.h"
  extern char nazwa_pliku_pomocy[256];
#endif
#include "sgftree.h"

extern TStoper stoper[3];
extern TSkladowe skladowe;
extern TPlansze  plansze;
extern TTabliceLI tabliceLI;
extern TSlowa slowa;

#define MAX_GRACZY_W_TURN  20

// stale trybu gry
#define  TRYB_GRA     0
#define  TRYB_EDYCJA  1
#define  TRYB_TURNIEJ 2
#define  TRYB_CZAS    3
// TRYB_PAUZA moze towarzyszyc dowolnemu z 4 pozostalych trybow (np. TRYB_GRA | TRYB_PAUZA)
// przy czym w trybie EDYCJI pauza jest ignorowana
#define  TRYB_PAUZA   4

#define WS_KTONARUCHU   0
#define WS_KROPKA       1
#define WS_POWIERZCHNIA 2
#define WS_STOP         3
#define WS_CALAPLANSZA  4
#define WS_NOWAPLANSZA  5
#define WS_NOWYZARODEK  100
#define WS_BLADPLIKU    101
#define WS_ODCZYTMECZU  102

#define ZD_NIC          0
#define ZD_NOWAGRA      1
#define ZD_COFNIJ       2
#define ZD_BLOKADA      3
#define ZD_ZAPIS        5
#define ZD_ODCZYT       6
#define ZD_USTAWZARODEK        7
#define ZD_USTAWZARODEKLOSOWY  8
#define ZD_OPUSCRUCH    9
#define ZD_ZMIENGRACZY  10
#define ZD_KROPKA       11
#define ZD_STOP_AKT     12   /* potrzebne 12-15 */
#define ZD_STOP         (ZD_STOP_AKT+2)

#define ZD_KONIEC       17
#define ZD_INFORMACJE   18   /* potrzebne 18-19 */
#define ZD_ODCZYT_MECZU 20
#define ZD_TRYB         22
 
#define ZD_ROZGR_POCZ   35
#define ZD_ROZGR_KON    36
#define ZD_ROZGR_NAST   37
#define ZD_ROZGR_POP    38

struct TGraczO {
  short int komputer;
  short int poziom_gry;
  short int dokl_analizy;            // glebokosc analizy
  short int funkcja_sk;
  short int Bouzy_dil, Bouzy_er;
  long int czas_sek, czas_ssek, czas_kiedy;
  unsigned long int umiejetnosci;
  long int waga_kropki;             // =wartosc zdobytej kropki/zdobytej powierzchnii
  struct TWagi {
    long int  zd, sk, Bo;
    int operator!=(const TWagi w) const {
      return (zd!=w.zd || sk!=w.sk || Bo!=w.Bo);
    };
  } wagi_n, wagi_p;
  short int sex_limit, sex_limit_podw;  // limit na singular extensions (82.35+)
  unsigned long int testowe;
  unsigned short int opcje_Bouzy;
  unsigned short int waga_latwe_pole;
  signed char listy_ruchow[4];   // nasze, przec, przedost, lisc
  unsigned long int iteracji;    // dla MC (poziom 13)
  short int funkcja_mc;          // dla MC (poziom 13), rodzaj funkcji grajacej losowo
  short int zapasowes;
  long int zapasowe[10];
  char imie[30], imie_k[5][30];
  void  UstawImie();
  int   Wstaw(unsigned char *s);
  void  Daj(unsigned char *s);
  TGraczO& operator&=(const TGraczO);
  int   operator==(const TGraczO) const;
  void  Odbij();
  int   Odczytaj(FILE *);
  void  Zapisz(FILE *);
  TGraczO()
    {
      memset(this, 0, sizeof(*this));
    komputer=1;  poziom_gry=12;
    strcpy(imie, "Pik");
    wagi_n.zd = 64*12;
    wagi_n.sk = 12;        // agresja =0
    wagi_p.zd = 64*12;     // przejmuje sie =64
    wagi_p.sk = 12;
    wagi_n.Bo = 30; wagi_p.Bo = 30;
    Bouzy_dil=Bouzy_er=0;
    opcje_Bouzy=1;
    waga_latwe_pole=0;
    dokl_analizy=8;  umiejetnosci=1|4|0x10|0x20|0x40|0x200; //|0x100;  QS nie
    funkcja_sk=5;
    waga_kropki=4;
    czas_kiedy=3;   // sprawdzaj czesto...
    czas_sek=3;
    czas_ssek=0;
    //sex_limit=1;  sex_limit_podw=0;
    sex_limit=0;  sex_limit_podw=0;
    testowe=0;
    listy_ruchow[0]=0;  // sensowne wydaja sie tez: (0,2,1,0), ew. (-1,2,1,0)  (choc to ostatnie ryzykowne)
    listy_ruchow[1]=3;
    listy_ruchow[2]=1;
    listy_ruchow[3]=0;
    iteracji = 10000;
    };
  private:
  void DodajTekstCzas(char *s);
  };

struct TKalendarzRozgr {
  short int rozgr_w_sezonie;
  struct TMecz {
    short int g1,g2;    // gracze, zaczyna g1
  } *mecze;
  int Odczytaj(FILE *f);
  int Zapisz(FILE *f);
  void KazdyZKazdym(int);
  TKalendarzRozgr& operator=(TKalendarzRozgr& arg);
  TKalendarzRozgr() {mecze=NULL;};
  ~TKalendarzRozgr() {if (mecze!=NULL) delete[] mecze;};
  };

struct TMecz {
  int nr_sez, nr_mecz;
  int ile_zd[2];
  TStoper czas[3];
};
  
struct TTurniej {
  int ile_graczy;
  int plx,ply;
  int zgry;
  TGraczO *gracze;
  TKalendarzRozgr  kalendarz;
  char nazwa_t[80];  // nazwa pliku .t
  int ktory_sezon;
  int ktory_mecz;         // aktualnie rozgrywany mecz
  int wersja_m;         // wersja pliku .m
    int offset_rozgr, dlug_rozgr;   // offset poczatku rozgrywek w pliku
  FILE *f;  // tylko do funkcji zw. ze statystyka
  // metody
    TTurniej() { gracze = new TGraczO[MAX_GRACZY_W_TURN]; assert(gracze!=NULL); f=NULL; };
  ~TTurniej() { delete[] gracze; if (f!=NULL) fclose(f); }
  void Zapisz();
  void WezGraczyWAktMeczu(TGraczO *gr);
  int Odczytaj(time_t &data_utw);
  int OdczytajMecz(time_t &data_utw, int nrs, int nrm);
  int Nowy();
  void NowyMecz();
  int  KtoryMecz();    // jest teraz
  int  KtorySezon();   // rozgrywany
  // do statystyki:
  int OdczytajNagl();
  void UstawMecz(int, int);
  int OdczytajInfoOMeczu(TMecz&, int tylko_gra_srodkowa);
  int ZapiszInfoOTurnieju(FILE*);
  private:

  };

struct TParametryGry  {
  int x,y,ile,tryb,blokada,kod,zasady;
  time_t data_utw;
  TGraczO gr[MAX_GRACZY_W_TURN];
  TKalendarzRozgr kalendarz;
  char nz1[256];
  };

struct TZdobycze {
  int zd, ss, pot_zd, pss;   // zdobycze, stale stopy, potencjalne zdobycze, punktowane ss
  void Zeruj() { zd=ss=pot_zd=pss=0; };
  TZdobycze& operator+=(TZdobycze z)
  {
    zd += z.zd;  ss += z.ss;  pot_zd += z.pot_zd;  pss += z.pss;
    return *this;
  };
};

struct TZobrist {
  unsigned long int z;
  unsigned long long int z2;
  TZobrist& operator^=(TZobrist);
  TZobrist& operator^=(int);
  void Zeruj() { z=0; z2=0; };
};

struct TRuchZam {   // ruch zamykajacy, dotyczy zasad_gry==2
  krint     ruch;
  TZdobycze zd[2];
  TZobrist  id;
};

struct TRuchyZam {
  TRuchZam *tab;
  int ile;
  int wlk_pam;
  void DodajRuch(krint, TZdobycze[2], TZobrist);
  TRuchyZam() { tab=NULL;  wlk_pam=0; };
  ~TRuchyZam() { Zwolnij(); wlk_pam=0; };
  void Przydziel();
  void Zwolnij() { if (tab!=NULL) { delete[] tab; tab=NULL; wlk_pam=0; } };
  void Zeruj() { ile=0; };
};

class TGra
  {
    friend class TTurniej;
  unsigned char *rozgr, *stopy, *plansz_p;
  krint *historia;
  SGFTree *drzewo;
  int ile_hist, ile_hist_kr;   // ile ruchow-1 w historii, ile post. kropek-1 w historii
  int ile_hist_czas;        // zapamietana wartosc ile_hist dla testu szybkosci rozgrywki
  int ile_hist_zapr;        // ...i dla podgladu (strzalki, dzialaja gdy nie ma kompa przy grze)
  int ktory_gracz_czas;     // zapamietany gracz na ruchu dla testu szybkosci
  int tryb, blokada;
  int ktory_gracz;   // ktory gracz na ruchu, =0 lub =1, lub -1, gdy koniec gry
  int stop;  // ma znaczenie przy regulach gry == 2, ==0 kropka, ==1 stop/postaw kropke,
             //   ==2 stop/zamknij panstwo
  //int ile_zd[2], pow_ss[2];
  TZdobycze pkt[2];
  TZobrist  kl_zobr;   // klucz Zobrista obecnej pozycji
  TRuchyZam ruchy_zam;
  int koncowka;                 // czy juz koncowka
  short int ile_zd_do_konc[2];  // wynik w grze srodkowej
  TGraczO gr[2];
  unsigned long int zarodek_pocz[2];  // poczatkowe wartosci bseed1,2
  TTurniej turniej;
  void WykonajRuch(int ruch, int tylko_ruch=0, int zostaw_stopy=0, char *sgf_ruch=NULL);
  void UstawRuch(int x, int y);
  // pomocnicza strukturka:
  struct TZapis {
    short int wx, wy, ik, ile_zd1, ile_zd2;
    unsigned short int slowo;
    short int wersja_hi, wersja_lo;
    long int data_utw;
    unsigned long int zarp1, zarp2, zark1, zark2;
    long int ktory_sezon, ktory_mecz;
    void Zapisz(FILE *f);
    int  Odczytaj(FILE *f);
  };
  // funkcje obslugujace pliki
  void ZapiszRozgr(FILE *f, int ktory_sezon=0, int ktory_mecz=0);
  int OdczytajRozgr(FILE *f, int zgry, time_t &data_utw, int *numery=NULL);
  int OdczytajSGF(const char *nazwa);
  static int OdczytajInfoOMeczu(FILE *f, TMecz&, int zgry, int tylko_gra_srodkowa);
  // funkcje SGF
  int ZagrajRuchSGF(SGFNode *node);
  void GrajDotadSGF(SGFNode *node);
  int GrajNastepnySGF(SGFNode *node);
  // funkcje obslugujace serwer:
  int NormujRuch(SGFNode *node);
  //
  public:
  void ObsluzZdarzenie(int zd);
  TGra();
  int  NowaGra(int x, int y, int zgry);
  void CzyscPlansze(int zapamietaj_zarodek=0);
  void CzyscDrzewo();
  void GlownaPetla();
  void PrzydzielPamiec();
  // do analizy
  int OszacujWynik();
  int OszacujWynikMC();
  int DNajlepszyRuch(krint *ruchy, int& x, int& y, int wybierz_ruchy=0);
  // funkcje zwracajace wartosci parametrow, ,,D'' od daj
  int DTryb();
  int DBlokada();
  int DStop();
  int DKropka(int x, int y);
  int DKreska(int x, int y);
  int DKreska(int x, int y, int x2, int y2);
  int DPlanszP(int x, int y);
  int DIleKropek();
  int DOstKropkaX();  int DOstKropkaY();
  int DKropkeNr(int nr);
  int DNaRuchu();
  int DKomputerNaRuchu();
  int DWlkX();    int DWlkY();
  int DZasadyGry();
  int DIleZd(int);   int DPowSS(int);   int DIlePotZd(int);
  void DGracza(int nr, TGraczO &ngr);
  int DPola(int*, int, int, int, int, int);
  unsigned int DHTAktCzas();
  void DJakasTablice(krint*, char*, int);
  //  int  TestSzybkosci(int kod, int iteracji, TStoper&);
  krint& DElTabl(krint*, int, int) const;
  unsigned char& DElTabl(unsigned char*, int, int) const;
  int DSStoper(int, char*);
  // funkcje obslugujace pliki
  int DInfoOPliku(const char*, int&, int&, int&, int&, TGraczO *gracze=NULL, 
                int *ile_zd=NULL, int *pow_ss=NULL);
  int DInfoOPliku(FILE*, int&, int&, int&, int&, TGraczO *gracze=NULL,
                int *ile_zd=NULL, int *pow_ss=NULL);
  int Serwer(char *nazwa1, char *nazwa2, int tez_stdout, int tylko_normuj);
  int Serwer_OszacujWynik(char *nazwa1);
  // funkcje obslugujace stopery
  void StoperyOdNowa();
  void StoperyWstrzymaj();
  void StoperyWznow();
  void StoperyStop();
  // funkcje obslugujace turniej
  int DNrSezonu();
  int DNrMeczu();
  int DNrGracza(int);
  // funkcje ustawiajace parametry (do obslugi pliku konfiguracyjnego)
  void UstawImie(int, const char*);
  // funkcje pomocnicze
  static int Str2Int(const char* s);
  };

// do pokazywania analizy:
struct TStatystykaDlaAnalizy {
  long long int funk_ocen, wez_ht;
};
extern TStatystykaDlaAnalizy  statystyka_dla_analizy;
struct TJedenRuch { 
  int x,y; 
  int ile_zam;   // ile ruchow zamykajacych
  int operator==(const TJedenRuch); 
  TJedenRuch(int nx, int ny, int nile_zam);
  TJedenRuch();
};
//typedef TJedenRuch TSekwencjaRuchow[8];
struct TSekwencjaRuchow {
  TJedenRuch r[8];
};

// statystyki programu:
struct TStatystyki {
  long long int ht_kolizja[4];
  // [0] = brak kolizji
  // [1] = mala kolizja, oznacza utrate pozycji, ktora moze pomoc tylko w sortowaniu
  // [2] = srednia kolizja, oznacza utrate pozycji, ktora zostala uznana
  //       za mniej wazna niz wstawiana
  // [3] = duza kolizja, oznacza niemoznosc wstawienia pozycji
};
extern TStatystyki   statystyki_prog;
// i deklaracje dla ekranu:

//
class TRysujPlansze;
class TRysujGraczy;
class TElMenu;
class TPlikiMenu;
class TTurniejMenu;
class TWiersze;
class TWierszeInf;
class TOpcjeWysw;

#ifdef TEKSTOWY
typedef int TKolor;
#else
class TPokazAnalize;
#endif

class TEkran
  {
  TRysujPlansze *plansza;
  TRysujGraczy  *gracze;
  TElMenu       *glowne_menu;
  TPlikiMenu    *pliki_menu;
  TTurniejMenu  *turniej_menu;
  TWierszeInf   *informacje;
#ifndef TEKSTOWY
  char tekst_rysuj[4];    // tekst do zaznaczania na planszy (zwykle pojedynczy symbol)
  public:
  TPokazAnalize *analiza;
  private:
#endif
   short int wgm[92];   // ,,gm'' to skrot
   TKolor    kgm[6];    // od glowne_menu
  int rozdz_x, rozdz_y;
  int wys_graczy;
  // anty-idle
  int czy_anty_idle;
  TStoper anty_idle;
  //
  /*
  TKolor  kolor_zolty, kolor_tla, kolor_menu, kolor1, kolor2;
  TKolor  kolor_zielony, kolor_zielony_tla;
  TKolor  kolor_tla_planszy, kolor_kratek, kolor_wyl_menu;
  TKolor  kolor_tla_gr, kolor_menu_gr, kolor_wyl_menu_gr;
  TKolor  kolor_obwodki;
  TKolor  kolor1_cien, kolor2_cien;
  */
  TKolor kolory[27];
  int kolory_rgb[27];   // dane rgb pow. kolorow
  int paleta;           // numer palety kolorow
  int krotkie_imie;
  int czcionka_bold;
  int opcje_zaawansowane;  // czy pokazywac opcje zaawansowane? (gracza, turniej,...)
  int jaki_font;
  static int byla_pomoc;
  int  UstawSzerGlMenu(int szer);
  int  Cofnij();
  int  WezNowaGre();
  private:
  void PokazStopy(int nr_maski);
  void PokazWolnePola();
  void PokazJakasTablice();
  //  void JakisTestSzybkosci();
  void WezOpcje();
  public:
  void ZaladujFont(char*);
  void UstawRozdzielczosc(int x, int y, int nowa_wys_fontu, int nowa_szer_fontu);
  void UstawKolory();
    void LosoweKolory();  // testowa funkcja
  void UstawWersje(int w, int wlow, int,int,int);
  void WyswietlPlansze(int co);
  void WyswietlGraczy();
  void WyswietlTryb();
  void WyswietlStop();
  void WyswietlBlokade();
  void WyswietlInformacje(int);
  void WyswietlInfoOMeczu();
  void WyswietlCzasGry();
  void WyswietlWszystko();
  void WyswietlInfoOProgramie();
  void WyswietlObwodke(int, int, int);  // wyswietl lub skasuj
    void WyswietlNapis(const char *);  // do testow
  void WyswietlPomoc(int);
  int  DajZdarzenie();
  int  CzekajNaZdarzenie(int czekaj=1);
  TEkran();
  ~TEkran();
  void SkonstruujMenu();
  TKolor DajKolorTla();
  TKolor DajKolorMenu();
  TKolor DajKolorNieaktMenu();
  TKolor DajKolorZolty();
  TKolor DajKolorGracza(int);
  TKolor DajKolorZielony();
  TKolor DajKolorZielonyTla();
  int DajRozdzX();
  int DajRozdzY();
  int CzyKrotkieImie();
  static char* RuchTekst(char *s, int x, int y);
#ifndef TEKSTOWY
  int DajOpcjeZaawansowane();
  int CzyCzcionkaBold();
  void WezOpcje(TSlowa &opcje);
  void PoczatekAnalizy();
  void MinimaxPoczatek();
  void JeszczeRazAktGleb();
  void OcenionyRuch(int gleb, int maxg, int ocena, TSekwencjaRuchow *r, int ile_r);
  void NowyRuch(int gleb, TJedenRuch r, int ktoryr, int ile_pierw_r, int ile_r);
  void WyswietlUCT(char **s, int n);
  void KoniecAnalizy();
  int  CzyPrzerwacAnalize();
  int  WezListeRuchow(unsigned char*);
  int  JakiKomentarz();
  char *DajTekstKoment() { return tekst_rysuj; };
  static TKolor kolory_suwaka[7];
  static TKolor kolory_ciemnego_suwaka[7];
  static TKolor kolory_przycisku[7];
  static TKolor kolory_przycisku_kilka_opcji[7];
  static TKolor kolory_przycisku_dwie_opcje[6];
  static TKolor kolory_wybor_przycisku[6];
  static TKolor kolory_edytora[5];
#endif
  };


extern TGra          gra;
extern TEkran        ekran;
extern TParametryGry pargry;

#endif
