#include <string.h>
#include <math.h>
#include <pthread.h>
#include "basic.h"
#include "pla_skl.h"
#include "mc.h"
#include "robaki.h"
#include "sstop3.h"

//#define DEBUG_PELNAANALIZA

pthread_rwlock_t uct_treerw_mutex;

int ZnajdzWolne(krint *pola_wolne, unsigned char* rozgrywka, unsigned char* plansz_p)
// zwraca liczbe wolnych pol do gry
{
  // znajdz liste wolnych pol
  int ile_wolnych=0;
  // usun narozniki:
  rozgrywka[WezIndeksTab(2,wlky+1)] += 10;
  rozgrywka[WezIndeksTab(wlkx+1,2)] += 10;
  for (int i=up.lg+1; i<up.pd; i++)
    if (upl_marg[i]>=2 && rozgrywka[i]==0 && (plansz_p[i] & 0xf)==0)
      pola_wolne[ile_wolnych++] = i;
  // odtworz narozniki:
  rozgrywka[WezIndeksTab(2,wlky+1)] -= 10;
  rozgrywka[WezIndeksTab(wlkx+1,2)] -= 10;
  return ile_wolnych;
}

SGFTree *drzewo_global;      // global variable used to store 'drzewo' for MC

#ifdef DEBUG_PELNAANALIZA
  char sgf_akt_r_gruct[4*max_powierzchnia_planszy];
#endif

void UaktualnijListePol(unsigned char *plansz_p, krint *pola_wolne, int &ile_wolnych)
{
  for (int i=ile_wolnych-1; i>=0; i--)
    if ((plansz_p[pola_wolne[i]] & 0xf)!=0)   // pole juz nie jest wolne!
      pola_wolne[i] = pola_wolne[--ile_wolnych];
}

int AddPossiblyFreePts(krint *dest, unsigned char *rozgr,
		       unsigned char *plansz_p, int move, int who)
{
  int mask_opp_terr = (who==1) ? 8:4;
  int count = 0;
  if ((move==0 || (plansz_p[move] & mask_opp_terr)) && zasady_gry!=0) {
    for (int i=up.llgg; i<=up.ppdd; i++)
      if ((plansz_p[i] & mask_opp_terr) && rozgr[i]==0)
	dest[count++] = i;
  }
  return count;
}


void CheckPossiblyFreePts(unsigned char *rozgr, unsigned char *plansz_p,
			  krint *dest, int &count)
// jak UaktualnijListePol, ale sprawdza jeszcze rozgrywke
{
  for (int i=count-1; i>=0; i--)
    if ((plansz_p[dest[i]] & 0xf)!=0 || rozgr[dest[i]])
      dest[i] = dest[--count];
}

int GrajRuchUCT(unsigned char *rozgr,
		unsigned char *plansz_p, TZdobycze wynik[2],
		krint *pola_wolne, int &ile_wolnych, int kto, int ruch, int pop_ruch,
		unsigned char *rozgr2=NULL, unsigned char *rozgr3=NULL)
{
  int ile_domysl,ile_zd,pow,pow2,ile_zd2;    TZobrist hzobr;
  int ile_dod = AddPossiblyFreePts(&pola_wolne[ile_wolnych], rozgr,
				   plansz_p, ruch, kto);
  int zamknij_stopy = 0;
  if (ile_dod) {
    zamknij_stopy = 1;
  }
#ifndef DEBUG_PELNAANALIZA
  int js =
    (ZrobRuch(rozgr, NULL, NULL, ile_domysl,
	      NULL, zamknij_stopy, plansz_p, ruch, kto, pop_ruch,
	      wynik, hzobr,
	      ile_zd,pow,pow2,ile_zd2,
	      ruchy_zam_NULL,
	      rozgr2, rozgr3) & 3);
#else
  sgf_akt_r_gruct[0]=0;
  int js =
    (ZrobRuch(rozgr, NULL, NULL, ile_domysl,
	      sgf_akt_r_gruct, zamknij_stopy, plansz_p, ruch, kto, pop_ruch,
	      wynik, hzobr,
	      ile_zd,pow,pow2,ile_zd2,
	      ruchy_zam_NULL,
	      rozgr2, rozgr3) & 3);
  drzewo_global->sgftreeAddPlay(kto==1 ? BLACK : WHITE, sgf_akt_r_gruct);
#endif
  if (js || ile_dod) {
    if (ile_dod) {
      CheckPossiblyFreePts(rozgr, plansz_p, &pola_wolne[ile_wolnych], ile_dod);
      ile_wolnych += ile_dod;
    }
    UaktualnijListePol(plansz_p, pola_wolne, ile_wolnych);
  }
  return js;
}


int CzyJestTuStop(unsigned char *rozgr,
		  const unsigned char *plansz_p,int kto, int ruch)
// returns  >0 if (kto) captures some dots after move (ruch)
// could also return number of captured dots
{
  rozgr[ruch] = kto;
  unsigned char *visited = plansze.PrzydzielPlansze();
  krint *stck = skladowe.PrzydzielSkladowa();
  int top = 0;
  for (int i=0; i<wlkx4wlky4; i++) {  // must be from 0 to wlkx4wlky4-1!
    if (rozgr[i] == kto && !(plansz_p[i] & 3))   // our dot not in a stop
      visited[i]=1;
    else if (upl_marg[i]==2) {   // must be not our dot in this case
      visited[i]=1;
      stck[top++] = i;
    }
    else
      visited[i] = (upl_marg[i]<2);
  }
  // now flood-fill
  while (top) {
    int point = stck[--top];
    // visit neighbours
    for (int i=0; i<4; i++) {
      int ind = point + up.dind[i];
      if (!visited[ind]) {
	visited[ind] = 1;
	stck[top++] = ind;
      }
    }
  }
  rozgr[ruch] = 0;
  skladowe.ZwolnijSkladowa(stck);
  // not visited points are inside our territory
  int our_terr_mask = (kto==1) ? 5 : 10;
  int enemy = 3-kto;
  //  int captures = 0;
  for (int i=up.lg; i<=up.pd; i++)
    if (!visited[i]) {
      if (rozgr[i] == enemy &&
	  !(plansz_p[i] & our_terr_mask)) {
	plansze.ZwolnijPlansze(visited);
	return 1;
	// captures++;
      }
    }
  plansze.ZwolnijPlansze(visited);
  return 0;   // return captures
}

#define FLAG_SKIP_ZAGR   0x8000
#define FLAG_SKIP_SPORNE 0x4000
// 0x2000 not used
#define MASK_MOVE   0x1fff

int ZamknijSporne(unsigned char *rozgr,
		  unsigned char *plansz_p, TZdobycze wynik[2],
		  int kto,
		  unsigned char *rozgr2, unsigned char *rozgr3,
		  unsigned short int &flags,
		  krint *nruchy=NULL)
// kto = kto ma zamknac sporne
// zwraca liczbe ruchow zamykajacych, gdy cos zamknal
{
  if (wynik[kto-1].pot_zd==0) return 0;     // kto nie ma czego zamykac
  if (flags & FLAG_SKIP_SPORNE) return 0;
  int przec = 3-kto;
  int maska_wewn_n = (kto==1) ? 0x10:0x20;
  int maska_zamkn_p = (kto==1) ? 0x20:0x10;
  int maska_ss_p    = (kto==1) ? 8:4;
  int zamkniete = 0;
  for (int indeks=up.llgg; indeks<=up.ppdd; indeks++)
    if (upl_marg[indeks]>=2 &&      // w zasadzie niepotrzebne
	rozgr2[indeks]==przec && 
	(plansz_p[indeks] & maska_wewn_n)) {
      // zamknij te kropke, jesli trzeba
      for (int k=0; k<4; k++)
	if (plansz_p[indeks + up.dind[k]] & maska_zamkn_p) {
	  // trzeba zamknac kropke [indeks]!!
	  int ile_domysl,ile_zd,pow,pow2,ile_zd2;    TZobrist hzobr;
	  ZrobRuch(rozgr, NULL, NULL, ile_domysl,
		   NULL, 0, plansz_p, indeks | 0x4000, kto, 0,
		   wynik, hzobr,
		   ile_zd,pow,pow2,ile_zd2,
		   ruchy_zam_NULL,
		   rozgr2, rozgr3);
	  if (nruchy)
	    nruchy[zamkniete] = indeks | 0x4000;
	  zamkniete++;
	  break;  // kropka [indeks] zamknieta...
	}
    }
  if (zamkniete==0)
    flags |= FLAG_SKIP_SPORNE;
  return zamkniete;
}

int ZamknijZagrozone(unsigned char *rozgr,
		     unsigned char *plansz_p, TZdobycze zdobycze[2],
		     int kto,
		     unsigned char *rozgr2, unsigned char *rozgr3,
		     const krint *szanse, int ile_szans,
		     unsigned short int &flags,
		     krint *nruchy=NULL)
// we:
//  kto = kto ma zamknac zagrozone brzuszki
//  (szanse, ile_szans) = potencjalne zagrozenia (szanse dla przeciwnika)
//  flags: bit
// wy:
//  zwraca !=0, gdy cos zamknal (konkretnie zwraca liczbe ruchow
//    zamykajacych)
{
  if (zasady_gry==0 || zdobycze[kto-1].pot_zd==0) return 0;
  int ile_zamykamy = 0;
  if (flags & MASK_MOVE) {
    int ile_domysl,ile_zd,pow,pow2,ile_zd2;    TZobrist hzobr;
    int pole = (flags & MASK_MOVE);
    ZrobRuch(rozgr, NULL, NULL, ile_domysl,
	     NULL, 0, plansz_p, pole | 0x4000, kto, 0,
	     zdobycze, hzobr,
	     ile_zd,pow,pow2,ile_zd2,
	     ruchy_zam_NULL,
	     rozgr2, rozgr3);
      if (nruchy)
	nruchy[ile_zamykamy++] = pole | 0x4000;
      else
	ile_zamykamy++;
  }
  if ((flags & FLAG_SKIP_ZAGR) || ile_szans==0) // no need to proceed
    return ile_zamykamy;
  unsigned char *pp = plansze.PrzydzielPlansze();
  int maska_n_basenu = (kto==1) ? 4 : 8;
  int maska_moge_zamknac = (kto==1) ? 0x10 : 0x20;

  for (int i=0; i<ile_szans; i++) {
    int ind = szanse[i];
    if (rozgr[ind]==0) {
    JeszczeRaz:;
      KopiujTablice(pp, plansz_p);
      int ile_domysl,ile_zd,pow,pow2,ile_zd2;    TZobrist hzobr;
      TZdobycze wynik[2];
      wynik[0].Zeruj();  wynik[1].Zeruj();
      int js =
	(ZrobRuch(rozgr, NULL, NULL, ile_domysl,
		  NULL, 1, pp, ind, 3-kto, 0,
		  wynik, hzobr,
		  ile_zd,pow,pow2,ile_zd2) & 3);
      rozgr[ind] = 0;
      if ((js & 3) && (wynik[2-kto].zd + wynik[2-kto].pot_zd>0) &&
	  (wynik[kto-1].pot_zd<0)) {
	// ok, trzeba zobaczyc, czy cos sie zamknelo...
	for (int pole = up.llgg; pole<=up.ppdd; pole++)
	  if (upl_marg[pole]>=3 &&
	      (plansz_p[pole] & maska_moge_zamknac) &&
	      (pp[pole] & maska_n_basenu)==0) {
	    // zamknij [pole]
	    int ile_domysl,ile_zd,pow,pow2,ile_zd2;    TZobrist hzobr;
	    ZrobRuch(rozgr, NULL, NULL, ile_domysl,
		     NULL, 0, plansz_p, pole | 0x4000, kto, 0,
		     zdobycze, hzobr,
		     ile_zd,pow,pow2,ile_zd2,
		     ruchy_zam_NULL,
		     rozgr2, rozgr3);
	    if (plansz_p[pole] & kto) { // zamknelismy rzeczywiscie
	      if (ile_zamykamy==0) {
		flags &= ~MASK_MOVE;
		flags |= pole;
	      }
	      if (nruchy)
		nruchy[ile_zamykamy++] = pole | 0x4000;
	      else
		ile_zamykamy++;
	      if (CzyJestTuStop(rozgr, plansz_p, 3-kto, ind))
		goto JeszczeRaz;
	      else
		break;
	    }
	  }
      }
    }
  }
  plansze.ZwolnijPlansze(pp);
  if (ile_zamykamy<=1)
    flags |= FLAG_SKIP_ZAGR;
  return ile_zamykamy;
}

int GrajLosowo1(unsigned char* rozgrywka, unsigned char* plansz_p,
	       int kto, int pop_ruch, TZdobycze zdobycze[2])
// zaczyna gracz kto, rozgrywa do konca (nie wypelniajac brzuszkow),
// zwraca wynik gry (0=wygral gracz 1, 1=remis, 2=wygral gracz 2)
// NISZCZY rozgrywka, plansz_p, zdobycze
{
  // znajdz liste wolnych pol
  krint* pola_wolne = skladowe.PrzydzielSkladowa();
  int ile_wolnych=ZnajdzWolne(pola_wolne, rozgrywka, plansz_p);
  // no i graj losowo...
  while (ile_wolnych) {
    int nr_ruchu = random(ile_wolnych);
    int ruch = pola_wolne[nr_ruchu];
    pola_wolne[nr_ruchu] = pola_wolne[--ile_wolnych];    // usun ruch
    GrajRuchUCT(rozgrywka, plansz_p, zdobycze,
		pola_wolne, ile_wolnych, kto, ruch, pop_ruch);
    kto ^= 3;  // zmien gracza na ruchu
    pop_ruch = ruch;
  }
  skladowe.ZwolnijSkladowa(pola_wolne);
  int wynik = 2*(zdobycze[0].zd + zdobycze[0].pot_zd) + zdobycze[0].ss -
    ( 2*(zdobycze[1].zd + zdobycze[1].pot_zd) + zdobycze[1].ss );
  return wynik;
}

int GrajLosowo2(unsigned char* rozgrywka, unsigned char* plansz_p,
	       int kto, int pop_ruch, TZdobycze zdobycze[2])
// zaczyna gracz kto, rozgrywa do konca (nie wypelniajac brzuszkow),
// zwraca wynik gry (0=wygral gracz 1, 1=remis, 2=wygral gracz 2)
// NISZCZY rozgrywka, plansz_p, zdobycze
// wersja 2:
//  wybiera w miare mozliwosci ruchy zamykajace
{
  // znajdz liste wolnych pol
  krint* pola_wolne = skladowe.PrzydzielSkladowa();
  krint* skl_tab = skladowe.PrzydzielSkladowa();
  int ile_wolnych=ZnajdzWolne(pola_wolne, rozgrywka, plansz_p);
  unsigned char *r2 = plansze.PrzydzielPlansze();
  unsigned char *r3 = plansze.PrzydzielPlansze();
  WezRozgr23(rozgrywka, r2, r3, plansz_p);
  TRobaki robaki[4];
  for (int i=0; i<4; i++) {
    robaki[i].Przydziel();
    robaki[i].UstawCzyje(1 + (i % 2), 0);
    robaki[i].Inicjuj(rozgrywka, r2, r3, plansz_p);
  }

  // no i graj losowo...
  int robaki_ind=0;
  while (ile_wolnych) {
    int nr_ruchu;
    CzyscTablice(skl_tab);
    robaki[robaki_ind].ZnajdzSkladowe(skl_tab, 1, r2);
    robaki[robaki_ind+1].ZnajdzSkladowe(skl_tab, 30001, r2);
    // znajdz szanse...
    int ile_szans = 0;
    for (int i=0; i< ile_wolnych; i++) {
      unsigned int ind = pola_wolne[i];
      if (CzyMozliwyStop(skl_tab, r2, upl_x[ind], upl_y[ind], kto)) {
	ile_szans++;
	pola_wolne[i] |= 0x4000;  // zaznacz pole
      }
    }
    if (ile_szans) {
      int kt = random(ile_szans);
      for (int i=0; i< ile_wolnych; i++)
	if (pola_wolne[i] & 0x4000) {
	  pola_wolne[i] &= ~(0x4000);
	  if (kt == 0)
	    nr_ruchu=i;
	  kt--;
	  if (--ile_szans == 0)
	    break;
	}
    }
    else
      nr_ruchu = random(ile_wolnych);
    int ruch = pola_wolne[nr_ruchu];
    pola_wolne[nr_ruchu] = pola_wolne[--ile_wolnych];    // usun ruch

    int js = GrajRuchUCT(rozgrywka, plansz_p, zdobycze,
			 pola_wolne, ile_wolnych, kto, ruch, pop_ruch, r2, r3);
    if (js & 1) {
      // sporne zamyka przeciwnik -- w zasadzie powinien w poprz ruchu!
      unsigned short int flags=0;
      ZamknijSporne(rozgrywka, plansz_p, zdobycze,
		    3-kto, r2, r3, flags);
    }
    // nie jestem pewien, czy to bedzie dzialalo -- w TAnaliza zadne 2 robaki sie nie powtarzaja,
    // a tu poprzedni poprzedni robak do r to znowu r...
    robaki[robaki_ind ^ 2].DodajKropke(robaki[robaki_ind],  rozgrywka, r2,
				       r3, plansz_p, ruch,
				       (js & 1), ((js & 2)!=0));
    robaki[(robaki_ind ^ 2)+1].DodajKropke(robaki[robaki_ind+1],  rozgrywka, r2,
					   r3, plansz_p, ruch,
					   (js & 1), ((js & 2)!=0));
    robaki_ind^=2;
    kto ^= 3;  // zmien gracza na ruchu
    pop_ruch = ruch;
  }
  skladowe.ZwolnijSkladowa(pola_wolne);  skladowe.ZwolnijSkladowa(skl_tab);
  plansze.ZwolnijPlansze(r2);  plansze.ZwolnijPlansze(r3);
  for (int i=0; i<4; i++) {
    robaki[i].Zwolnij();
  }
  int wynik = 2*(zdobycze[0].zd + zdobycze[0].pot_zd) + zdobycze[0].ss -
    ( 2*(zdobycze[1].zd + zdobycze[1].pot_zd) + zdobycze[1].ss );
  return wynik;
}


/* NaPewnoBezp.
   Znajdowanie ruchow bezsensownych poprzez szukanie skladowych na p.bezp.

*/

void NaPewnoBezp::Przydziel()
{
  tab  = skladowe.PrzydzielSkladowa();
  stos = skladowe.PrzydzielSkladowa();
}

void NaPewnoBezp::Zwolnij()
{
  skladowe.ZwolnijSkladowa(tab);  skladowe.ZwolnijSkladowa(stos);
  tab = NULL;  stos = NULL;
}

int NaPewnoBezp::IlePolBezp(unsigned char *r4, int ind) const
// ind: pole w odleglosci 1 od bandy (choc dziala dla dowolnego)
// zwraca liczbe pustych pol przy bandzie, ktore sasiaduja z [ind]
// (na ogol 0-1, ale moze byc =2 dla pol kolo naroznika)
{
  int ile=0;
  for (int s=0; s<4; s++)
    ile += (upl_marg[ind + up.dind[s]]==2 && r4[ind + up.dind[s]] == 0);
  return ile;
}

int NaPewnoBezp::IlePolBezp(int ind) const
// ind: pole w odleglosci 1 od bandy (choc dziala dla dowolnego)
// zwraca liczbe pustych pol przy bandzie, ktore sasiaduja z [ind]
// (na ogol 0-1, ale moze byc =2 dla pol kolo naroznika)
// dane o planszy bierze z tab[]
{
  int ile=0;
  for (int s=0; s<4; s++)
    ile += (upl_marg[ind + up.dind[s]]==2 && tab[ind + up.dind[s]] == 0);
  return ile;
}

void NaPewnoBezp::DodajSkl(unsigned char *r4, int ind)
// dodaje skladowa pola [ind] do tab
{
  int nr = 4*ind + r4[ind];
  int ile_na_liscie = 1, ost_z_listy = 0;
  tab[ind] = nr;
  int maska=0;
  // musza byc 4 pola, bo w 'case 3' ponizej moze byc ile==2+1==3
  const int maski_tab[4] = {0, 0x4000, 0xC000, 0xC000};
  switch (upl_marg[ind]) {
  case 2:  maska |= 0xC000;  break;     // (0x8000) na pewno bezpieczne
  case 3:
    maska = maski_tab[IlePolBezp(r4, ind)];          // (0x4000) pol-bezpieczne
    break;
  }
  stos[0]=ind;
  do {
    int pole = stos[ost_z_listy++];
    // odwiedz sasiadow
    for (int s=0; s<4; s++) {
      int npole = pole + up.dind[s];
      if (r4[npole]==r4[ind] && tab[npole]==0) {
	if (maska!=0xC000) {
	  switch (upl_marg[npole]) {
	  case 2:
	    maska = 0xC000;
	    break;
	  case 3: {
	    int ile = IlePolBezp(r4, npole);
	    ile += (maska != 0);      // maska = 0xC000 jest i tak wykluczona!
	    maska |= maski_tab[ile];  // (ale dzieki |= dziala niezaleznie od tego)
	    break;
	  }
	  }
	}
	tab[npole] = nr;
	stos[ile_na_liscie++] = npole;
      }
    }
  }
  while (ost_z_listy < ile_na_liscie);
  if (maska)
    for (int j=0; j<ile_na_liscie; j++)
      tab[stos[j]] |= maska;
}

void NaPewnoBezp::ZaznaczSkl(krint stara, krint nowa)
{
  for (int i=up.lg; i<=up.pd; i++)
    if (tab[i] == stara)
      tab[i] = nowa;
}

void NaPewnoBezp::Inicjuj(unsigned char *r4)
// r4 to rozgrywka posrednia miedzy rozgrywka a r3, a dokladniej:
// dla zasad_gry==0     r4 to to samo co r3,
// dla zasad_gry==1,2   r4 to to samo co r3 wewnatrz stopow, i to samo co rozgrywka poza tym
{
  CzyscTablice(tab);
  for (int i=up.lg; i<=up.pd; i++)
    if (r4[i] && tab[i]==0)
      // dodaj skladowa r4[i]
      DodajSkl(r4, i);
}

void NaPewnoBezp::Inicjuj(unsigned char *rozgr, unsigned char *plansz_p)
{
  unsigned char *rozgr4 = plansze.PrzydzielPlansze();
  WezRozgr4(rozgr, rozgr4, plansz_p);
  Inicjuj(rozgr4);
  plansze.ZwolnijPlansze(rozgr4);
}

void
NaPewnoBezp::DodajKropke_UsunPolbezp(int ind, int kto)
// works if there was no enclosure (and no new territory if rules==0)
// Assumes that we don't play on NaPewnoBezp-nonsense points.
{
  if (upl_marg[ind]==2) {
    int to_interior;      // neighbour of [ind] not on the edge
    for (int s=0; s<4; s++)
      if (upl_marg[ind + up.dind[s]] == 3) {
	to_interior = ind + up.dind[s];
	break;
      }
    int opponent = 3-kto;
    if ((tab[to_interior] & 0xc003) == (opponent | 0x4000)) {
      // [to_interior] was half-safe, so now it's not
      ZaznaczSkl(tab[to_interior], (tab[to_interior] & ~0x4000));
    }
  }
}

int  NaPewnoBezp::DodajKropke(int ind, int kto)
// dziala tylko gdy nie bylo stopu (ani stalego stopu dla zasad_gry==0)
// zwraca 1, gdy sa nowe nietrywialne bezpieczne (nietrywialne = wieksze niz 1 kropkowe)
{
  DodajKropke_UsunPolbezp(ind, kto);
  int ile_skl = 0;
  int skl[4];
  for (int i=0; i<4; i++) {
    int pole = ind + up.dind[i];
    if ((tab[pole] & 3) == kto) {
      skl[ile_skl] = tab[pole];
      for (int j=0; j<ile_skl; j++)
	if (skl[j] == tab[pole])
	  { ile_skl--;  break; }   // juz jest!
      ile_skl++;
    }
  }
  const int maski_tab[4] = {0, 0x4000, 0xC000, 0xC000};  // tu chyba wystarczyloby [3]
  if (ile_skl==0) {
    int nr = 4*ind + kto;
    switch (upl_marg[ind]) {
    case 2:
      tab[ind] = nr | 0xC000;
      break;
    case 3:
      tab[ind] = nr | maski_tab[IlePolBezp(ind)];
      break;
    default:
      tab[ind] = nr;
    }
    return 0;
  }
  if (ile_skl==1) {
    int nowe_bezp = 0;
    switch (skl[0] & 0xC000) {
    case 0xC000:   // najprostszy przypadek, skladowa byla juz bezpieczna
      tab[ind] = skl[0];
      break;
    case 0x4000:   // skladowa byla pol-bezpieczna
      if (upl_marg[ind]==2 || IlePolBezp(ind)>0) {
	tab[ind] = skl[0] | 0xC000;   // juz jest bezpieczna!
	ZaznaczSkl(skl[0], tab[ind]);
	nowe_bezp = 1;
      }
      else
	tab[ind] = skl[0];   // skladowa pozostaje pol-bezpieczna
      break;
    case 0:
      if (upl_marg[ind]==2)
	tab[ind] = skl[0] | 0xC000;   // juz jest bezpieczna!
      else if (upl_marg[ind]==3)
	tab[ind] = skl[0] | maski_tab[IlePolBezp(ind)];
      else
	tab[ind] = skl[0];
      if (tab[ind] != skl[0]) {
	ZaznaczSkl(skl[0], tab[ind]);
	if (tab[ind] & 0x8000) nowe_bezp = 1;
      }
      break;
    }
    return nowe_bezp;
  }
  // trzeba skleic skladowe
  // zobacz najpierw, czy ktoras juz byla bezpieczna
  for (int s=0; s<ile_skl; s++)
    if (skl[s] & 0x8000) {
      for (int j=0; j<ile_skl; j++)
	if (j!=s)
	  ZaznaczSkl(skl[j], skl[s]);
      tab[ind] = skl[s];
      return 1;
    }
  // czy sa 2 skladowe z 0x4000?
  int ile_pol_bezp = 2*(upl_marg[ind]==2) + (upl_marg[ind]==3 ? IlePolBezp(ind) : 0);
  for (int s=0; s<ile_skl; s++)
    if (skl[s] & 0x4000)
      ile_pol_bezp++;
  if (ile_pol_bezp >= 2) {
    // nowa skladowa juz bedzie bezpieczna
    tab[ind] = skl[0] | 0xC000;
    for (int s=0; s<ile_skl; s++)
      ZaznaczSkl(skl[s], tab[ind]);
    return 1;
  }
  // ...ale za to moze jest teraz pol-bezpieczna?
  if (ile_pol_bezp == 1) {
    for (int s=0; s<ile_skl; s++)
      if (skl[s] & 0x4000) {
	for (int j=0; j<ile_skl; j++)
	  if (j!=s)
	    ZaznaczSkl(skl[j], skl[s]);
	tab[ind] = skl[s];
	return 1;
      }
    // zadna jeszcze nie byla pol-bezp (czyli pol-bezp jest nowa kropka)
    tab[ind] = skl[0] | 0x4000;
    for (int s=0; s<ile_skl; s++)
      ZaznaczSkl(skl[s], tab[ind]);
    return 1;
  }
  // nowa skladowa nie jest nawet pol-bezpieczna
  for (int s=1; s<ile_skl; s++)
    ZaznaczSkl(skl[s], skl[0]);
  tab[ind] = skl[0];
  return 0;
}

int
NaPewnoBezp::Uaktualnij(unsigned char *rozgr, unsigned char *plansz_p,
			int byl_stop, int ruch, int kto,
			krint *pola, int &ile_pol)
{
  // uaktualnia wszystko co trzeba, do uzycia w Graj() itp. dla MC
  if ((byl_stop & 1) || ((byl_stop & 2) && zasady_gry==0)) {
    Inicjuj(rozgr, plansz_p);
    UsunBezs(pola, ile_pol);
  }
  else {
    if (!DodajKropke(ruch, kto)) {
      // usun bezsensownych sasiadow, jesli sa
      if (upl_marg[ruch]<=3) {
	for (int i=0; i<4; i++) {
	  int sasiad = ruch + up.dind[i];
	  if (upl_marg[sasiad]>=2 && upl_marg[sasiad]<=3 &&
	      rozgr[sasiad]==0 && PoleBezs(sasiad))
	    UsunBezsPole(pola, ile_pol, sasiad);
	}
      }
    }
    else
      UsunBezs(pola, ile_pol);
  }
}

int NaPewnoBezp::PoleBezs(int ind) const
// czy grac na polu [ind] jest bez sensu
// moze zwrocic 1 tylko dla pol na bandzie
{
  if (upl_marg[ind]==2)
    for (int i=0; i<4; i++) {
      int pole = ind + up.dind[i];
      if (upl_marg[pole] == 3)  // pole obok pola [ind], do wewnatrz planszy
	if (tab[pole] & 0x8000)    // ... jest bezpieczne?
	  return 1;                // to nie ma sensu na nim grac
	else
	  return 0;  // jest sens
    }
  return 0;
}

void NaPewnoBezp::UsunBezs(krint *pola, int &ile_pol)
{
  for (int i=ile_pol-1; i>=0; i--)
    if (PoleBezs(pola[i]))
      pola[i] = pola[--ile_pol];       // usun pola[i]
}

void NaPewnoBezp::UsunBezsPole(krint *pola, int &ile_pol, int do_usuniecia)
{
  for (int i=ile_pol-1; i>=0; i--)
    if (pola[i]==do_usuniecia) {
      pola[i] = pola[--ile_pol];       // usun pola[i]
      return;
    }
}

void
NaPewnoBezp::Skopiuj(NaPewnoBezp &zrodlo)
{
  KopiujTablice(tab, zrodlo.tab);
}

/* Klasa do znajdowania ruchow bezsensownych na bandzie.
   Ruch na bandzie jest bezsensowny, gdy na tej bandzie oraz w odl. 1
    od tej bandy nie ma zadnych kropek
*/
class BezsensowneNaBandzie {
  int wolne;  // 1=gorna banda, 2=lewa, 4=dol, 8=prawa
  enum maski_band { GORNAB=1, LEWAB=2, DOLNAB=4, PRAWAB=8};
public:
  void Inicjuj(unsigned char *rozgrywka);
  void DodajKropke(int indeks);
  int CzyPoleBezs(int indeks);
  void Wylacz() { wolne=0;};  // dla testow
  int operator==(const class BezsensowneNaBandzie& b) const { return wolne==b.wolne; };
};

void
BezsensowneNaBandzie::Inicjuj(unsigned char *rozgrywka)
{
  wolne = 0xf;
  // gorna banda
  int ind = WezIndeksTab(3,2);
  for (int i=1; i<wlkx-1; i++) {
    if (rozgrywka[ind] || rozgrywka[ind+W_D]) {
      wolne &= ~GORNAB;  break;
    }
    ind += W_P;
  }
  // dolna banda
  ind = WezIndeksTab(3,wlky);
  for (int i=1; i<wlkx-1; i++) {
    if (rozgrywka[ind] || rozgrywka[ind+W_D]) {
      wolne &= ~DOLNAB;  break;
    }
    ind += W_P;
  }
  // lewa banda
  ind = WezIndeksTab(2,3);
  for (int i=1; i<wlky-1; i++) {
    if (rozgrywka[ind] || rozgrywka[ind+W_P]) {
      wolne &= ~LEWAB;  break;
    }
    ind += W_D;
  }
  // prawa banda
  ind = WezIndeksTab(wlkx,3);
  for (int i=1; i<wlky-1; i++) {
    if (rozgrywka[ind] || rozgrywka[ind+W_P]) {
      wolne &= ~PRAWAB;  break;
    }
    ind += W_D;
  }
  // no i jeszcze pola w poblizu naroznikow
  if (WezUC(rozgrywka, 2, 3) || WezUC(rozgrywka, wlkx+1, 3))
    wolne &= ~GORNAB;
  if (WezUC(rozgrywka, 2, wlky) || WezUC(rozgrywka, wlkx+1, wlky))
    wolne &= ~DOLNAB;
  if (WezUC(rozgrywka, 3, 2) || WezUC(rozgrywka, 3, wlky+1))
    wolne &= ~LEWAB;
  if (WezUC(rozgrywka, wlkx, 2) || WezUC(rozgrywka, wlkx, wlky+1))
    wolne &= ~PRAWAB;
}

void
BezsensowneNaBandzie::DodajKropke(int indeks)
{
  //  assert(indeks>=0 && indeks<wlkx4wlky4);
  if (upl_marg[indeks]<=3) {
    // naroznik?
    if (indeks==WezIndeksTab(2,2) || indeks==WezIndeksTab(2,wlky+1) ||
	indeks==WezIndeksTab(wlkx+1,2) || indeks==WezIndeksTab(wlkx+1,wlky+1))
      return;
    if (upl_x[indeks]<=3)
      wolne &= ~LEWAB;
    if (upl_y[indeks]<=3)
      wolne &= ~GORNAB;
    if (upl_x[indeks]>=wlkx)
      wolne &= ~PRAWAB;
    if (upl_y[indeks]>=wlky)
      wolne &= ~DOLNAB;
  }
}

int
BezsensowneNaBandzie::CzyPoleBezs(int indeks)
{
  if (upl_marg[indeks]>=3) return 0;
  if (upl_x[indeks]==2 && (wolne & LEWAB)==0)
    return 0;
  if (upl_y[indeks]==2 && (wolne & GORNAB)==0)
    return 0;
  if (upl_x[indeks]==wlkx+1 && (wolne & PRAWAB)==0)
    return 0;
  if (upl_y[indeks]==wlky+1 && (wolne & DOLNAB)==0)
    return 0;
  return 1;
}


class Szanse {
  // NIEPEWNE oznacza, ze wszystkie szanse sa w tablicy,
  //   ale niekoniecznie wszystkie elementy tablicy sa szansami
  // PEWNE jw. ale niektore pola szans moga byc zajete
  //   (przez kropki lub stopy), i to jest *jedyna* mozliwosc,
  //   zeby szansa byla nieaktualna
  enum status_stale {NIEZNANE, NIEPEWNE, PEWNE };
  int status[2];
  int ile[2];
  krint *pola[2];
  void Znajdz(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
	      krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto);
  void DodajSasiadow(int ruch, int kto);
public:
  void UaktualnijPoRuchu(int js, int ile_skl, int ruch, int kto);
  void UaktualnijPoZamknZagr(int kto);
  Szanse() { pola[0] = pola[1] = NULL; };
  void Inicjuj();
  void Skopiuj(Szanse &sz);
  void ZnajdzWszystkie(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
		       krint *skl_tab, krint *pola_wolne, int ile_wolnych);
  void PrzydzielPamiec();
  void ZwolnijPamiec();
  int DajLosowa(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
		krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto,
		krint *zagrane=NULL);
  krint* DajSzanse(int &ile_sz, 
		   unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
		   krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto);

};

void
Szanse::Znajdz(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
	       krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto)
{
  switch (status[kto-1]) {
  case NIEZNANE:
    ile[kto-1]=0;
    if (zasady_gry==0) {
      for (int i=0; i< ile_wolnych; i++) {
	unsigned int ind = pola_wolne[i];
	if (CzyMozliwyStop(skl_tab, r2, upl_x[ind], upl_y[ind], kto)) {
	  pola[kto-1][ile[kto-1]++] = ind;
	}
      }
    }
    else {
      int maska = (kto==1) ? 7:11;   // wewnatrz panstwa lub naszego brzuszka
      for (int indeks=up.lg; indeks<=up.pd; indeks++)
	if (rozgrywka[indeks]==0 &&
	    upl_marg[indeks]>=2 &&
	    (plansz_p[indeks] & maska)==0 &&
	    CzyMozliwyStop(skl_tab, r2, upl_x[indeks], upl_y[indeks], kto)) {
	  pola[kto-1][ile[kto-1]++]=indeks;
	}
    }
    break;
  case NIEPEWNE: {
    int dokad=0;
    int maska = (zasady_gry==0) ? 15 : ((kto==1) ? 7:11);
    for (int i=0; i< ile[kto-1]; i++) {   // ile[kto-1], nie ile_wolnych!
      unsigned int ind = pola[kto-1][i];  // pola, nie pola_wolne!
      if (rozgrywka[ind]==0 && (plansz_p[ind] & maska)==0 &&
	  CzyMozliwyStop(skl_tab, r2, upl_x[ind], upl_y[ind], kto)) {
	pola[kto-1][dokad++] = ind;
      }
    }
    ile[kto-1] = dokad;
    break;
  }
  case PEWNE: {
    int dokad=0;
    int maska = (zasady_gry==0) ? 15 : ((kto==1) ? 7:11);
    for (int i=0; i< ile[kto-1]; i++) {   // ile[kto-1], nie ile_wolnych!
      unsigned int ind = pola[kto-1][i];  // pola, nie pola_wolne!
      if (rozgrywka[ind]==0 && (plansz_p[ind] & maska)==0) {
	pola[kto-1][dokad++] = ind;
      }
    }
    ile[kto-1] = dokad;
    break;
  }
  }
  status[kto-1] = PEWNE;
}


void
Szanse::ZnajdzWszystkie(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
			krint *skl_tab, krint *pola_wolne, int ile_wolnych)
{
  Znajdz(rozgrywka, r2, plansz_p, skl_tab, pola_wolne, ile_wolnych, 1);
  Znajdz(rozgrywka, r2, plansz_p, skl_tab, pola_wolne, ile_wolnych, 2);
}

void
Szanse::DodajSasiadow(int ruch, int kto)
// dodaje wszystkich sasiadow pola [ruch] do tablicy pola_szans
// nie sprawdza, czy pola sa puste, bo to i tak jest potem sprawdzane w ZnajdzSzanse()
// natomiast sprawdza, czy pola juz nie sa w tablicy
{
  int ost = ile[kto-1];
  for (int i=0; i<8; i++) {
    unsigned int ind = ruch + up.dind[i];
    if (upl_marg[ind]>=2) {
      // sprawdz czy [ind] jest juz w tablicy
      for (int s=0; s<ile[kto-1]; s++)
	if (pola[kto-1][s] == ind)
	  goto Juz_jest;
      // nie ma
      pola[kto-1][ost++] = ind;
    }
  Juz_jest:;
  }
  ile[kto-1] = ost;
}

void
Szanse::UaktualnijPoRuchu(int js, int ile_skl, int ruch, int kto)
// ile_skl = z iloma skladowymi sasiadowal wykonany [ruch]
// js = czy byl stop
{
  if (js) ile_skl=2;   // zmien status szans!
  switch (ile_skl) {
  case 0:
    break;  // nie trzeba zmieniac statusu szans!
  case 1:
    if (status[kto-1] != NIEZNANE) {
      status[kto-1] = NIEPEWNE;
      DodajSasiadow(ruch, kto);
    }
    break;
  default:
    status[kto-1] = NIEZNANE;
    if ((status[2-kto] == PEWNE) && ((js & 1) || ((js & 3) && zasady_gry==0)))
      status[2-kto] = NIEPEWNE;
  }
}

int
Szanse::DajLosowa(unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
		  krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto,
		  krint *zagrane)
// daje losowa szanse lub -1, gdy nie ma;
// pomija (zagrane) szanse  (zagrane moze byc = NULL, wtedy nic nie pomija)
{
  Znajdz(rozgrywka, r2, plansz_p, skl_tab, pola_wolne, ile_wolnych, kto);
  for (int i=ile[kto-1]-1; i>=0; i--) {
    // zamien losowa szanse z [i]
    int los = random(i+1);
    int pole = pola[kto-1][los];
    pola[kto-1][los]= pola[kto-1][i];
    pola[kto-1][i]  = pole;
    // pomin pole, jesli bylo zagrane
    if (zagrane && zagrane[pole]) continue;
    if (CzyJestTuStop(rozgrywka, plansz_p, kto, pole))
      return pole;
  }
  return -1;
}


void
Szanse::Inicjuj()
{
  for (int i=0; i<2; i++) {
    status[i] = NIEZNANE;
    ile[i] = 0;
  }
}

void
Szanse::Skopiuj(Szanse &sz)
{
  for (int i=0; i<2; i++) {
    status[i] = sz.status[i];
    ile[i]    = sz.ile[i];
    for (int j=0; j<ile[i]; j++)
      pola[i][j] = sz.pola[i][j];
  }
}

void
Szanse::PrzydzielPamiec()
{
  pola[0] = skladowe.PrzydzielSkladowa();
  pola[1] = skladowe.PrzydzielSkladowa();
}

void
Szanse::ZwolnijPamiec()
{
  skladowe.ZwolnijSkladowa(pola[0]);
  skladowe.ZwolnijSkladowa(pola[1]);
}

void
Szanse::UaktualnijPoZamknZagr(int kto)
{
  status[kto-1] = NIEZNANE;
  if (status[2-kto] == PEWNE)
    status[2-kto] = NIEPEWNE;
}


krint*
Szanse::DajSzanse(int &ile_sz, 
		  unsigned char *rozgrywka, unsigned char *r2, unsigned char *plansz_p,
		  krint *skl_tab, krint *pola_wolne, int ile_wolnych, int kto)
{
  Znajdz(rozgrywka, r2, plansz_p, skl_tab, pola_wolne, ile_wolnych, kto);
  ile_sz = ile[kto-1];
  return pola[kto-1];
}

class MonteCarlo {
  Szanse szanse;
  BezsensowneNaBandzie bezs_na_bandzie;
  NaPewnoBezp na_pewno_bezp;
  krint* pola_wolne;
  int ile_wolnych;
  krint* skl_tab, *skl_tab_pom;
  unsigned char *r2;
  unsigned char *r3;
public:
  unsigned char *rozgrywka;
  unsigned char *plansz_p;
private:
  // do odtwarzania stanu
  int zap_ruch, zap_ile_wolnych;
  unsigned char *zap_plansz_p, *zap_r2, *zap_r3;
  krint *zap_pola_wolne;
  TZdobycze zap_zdobycze[2];
  void ZapamietajStan(int ruch, TZdobycze zdob[2]);
  void OdtworzStan(TZdobycze zdob[2]);
  int CzyZdobytaKropka(TZdobycze zdob[2]);
public:
  void ZwolnijPamiec();
  void PrzydzielPamiec();
  int  Inicjuj(unsigned char* rozgrywka_arg, unsigned char* plansz_p_arg);
  void Inicjuj(MonteCarlo &mc);
  int Graj(int kto, int pop_ruch, TZdobycze zdobycze[2]);
  int GetFreePlace(int nr) { return pola_wolne[nr]; };
  krint* GetFreePlaces() { return pola_wolne; };
  void PlayOneMove(TZdobycze wynik[2], int who_now, int thismove, int prevmove,
		   int depth, unsigned short int &flags, int remove_from_fp=1);
  int GetRandomOpport(int who, krint *played); 
  int GetNumOfAddOpport();
  int GetNumberOfMovesLeft(krint *played);
  int GetRandomMove(krint *played, int moves_left);

};


void MonteCarlo::ZapamietajStan(int ruch, TZdobycze zdob[2])
{
  zap_ruch = ruch;
  KopiujTablice(zap_plansz_p, plansz_p);
  KopiujTablice(zap_r2, r2);
  KopiujTablice(zap_r3, r3);
  zap_ile_wolnych = ile_wolnych;
  for (int i=0; i<ile_wolnych; i++)
    zap_pola_wolne[i] = pola_wolne[i];
  zap_zdobycze[0] = zdob[0];
  zap_zdobycze[1] = zdob[1];
}

void MonteCarlo::OdtworzStan(TZdobycze zdob[2])
{
  rozgrywka[zap_ruch] = 0;
  // zamien miejscami tablice plansz_p i pola_wolne z zapamietanymi wersjami
  unsigned char *pom = plansz_p;  plansz_p = zap_plansz_p;  zap_plansz_p = pom;
  pom = r2;  r2 = zap_r2;   zap_r2 = pom;
  pom = r3;  r3 = zap_r3;   zap_r3 = pom;
  krint *poms = pola_wolne;  pola_wolne = zap_pola_wolne;  zap_pola_wolne = poms;
  ile_wolnych = zap_ile_wolnych;  
  // odtworz zdobycze
  zdob[0] = zap_zdobycze[0];
  zdob[1] = zap_zdobycze[1];
}

int
MonteCarlo::CzyZdobytaKropka(TZdobycze zdob[2])
{
  return (zdob[0].zd+zdob[0].pot_zd != zap_zdobycze[0].zd + zap_zdobycze[0].pot_zd ||
	  zdob[1].zd+zdob[1].pot_zd != zap_zdobycze[1].zd + zap_zdobycze[1].pot_zd);
}


void
MonteCarlo::PrzydzielPamiec()
// tylko przydziela pamiec, potem trzeba wywolac Inicjuj()
{
  rozgrywka = plansze.PrzydzielPlansze();
  plansz_p =  plansze.PrzydzielPlansze();
  zap_plansz_p = plansze.PrzydzielPlansze();
  zap_r2 = plansze.PrzydzielPlansze();
  zap_r3 = plansze.PrzydzielPlansze();
  zap_pola_wolne = skladowe.PrzydzielSkladowa();
  pola_wolne = skladowe.PrzydzielSkladowa();
  skl_tab = skladowe.PrzydzielSkladowa();
  skl_tab_pom = skladowe.PrzydzielSkladowa();
  r2 = plansze.PrzydzielPlansze();
  r3 = plansze.PrzydzielPlansze();
  szanse.PrzydzielPamiec();
  na_pewno_bezp.Przydziel();
}

void
MonteCarlo::ZwolnijPamiec()
{
  skladowe.ZwolnijSkladowa(pola_wolne);
  skladowe.ZwolnijSkladowa(skl_tab);  skladowe.ZwolnijSkladowa(skl_tab_pom);
  plansze.ZwolnijPlansze(r2);  plansze.ZwolnijPlansze(r3);
  szanse.ZwolnijPamiec();
  plansze.ZwolnijPlansze(zap_plansz_p);  plansze.ZwolnijPlansze(plansz_p);
  plansze.ZwolnijPlansze(zap_r2);  plansze.ZwolnijPlansze(zap_r3);
  plansze.ZwolnijPlansze(rozgrywka);
  skladowe.ZwolnijSkladowa(zap_pola_wolne);
  na_pewno_bezp.Zwolnij();
}

int
MonteCarlo::Inicjuj(unsigned char* rozgrywka_arg, unsigned char* plansz_p_arg)
// uwaga! jesli ile_wolnych==0, nie inicjuje wszystkiego!
// zwraca ile_wolnych
{
  // znajdz liste wolnych pol
  ile_wolnych=ZnajdzWolne(pola_wolne, rozgrywka_arg, plansz_p_arg);
  if (ile_wolnych) {
    KopiujTablice(rozgrywka, rozgrywka_arg);
    KopiujTablice(plansz_p, plansz_p_arg);
    WezRozgr23(rozgrywka, r2, r3, plansz_p);
    ZnajdzSkladowe(skl_tab, r2, 1);
    szanse.Inicjuj();
    //szanse.ZnajdzWszystkie(rozgrywka, r2, plansz_p, skl_tab, pola_wolne, ile_wolnych);
    bezs_na_bandzie.Inicjuj(rozgrywka);
    na_pewno_bezp.Inicjuj(rozgrywka, plansz_p);
    na_pewno_bezp.UsunBezs(pola_wolne, ile_wolnych);
  }
  return ile_wolnych;
}


void
MonteCarlo::Inicjuj(MonteCarlo &mc)
{
  KopiujTablice(rozgrywka, mc.rozgrywka);
  KopiujTablice(r2, mc.r2);
  KopiujTablice(r3, mc.r3);
  KopiujTablice(plansz_p, mc.plansz_p);
  KopiujTablice(skl_tab, mc.skl_tab);
  KopiujTablice(pola_wolne, mc.pola_wolne);
  ile_wolnych = mc.ile_wolnych;
  bezs_na_bandzie = mc.bezs_na_bandzie;
  szanse.Skopiuj(mc.szanse);
  na_pewno_bezp.Skopiuj(mc.na_pewno_bezp);
}

int MonteCarlo::GetNumberOfMovesLeft(krint *played)
{
  int moves_left = 0;
  for (int i=0; i<ile_wolnych; i++)
    if (!played[pola_wolne[i]]) moves_left++;
  return moves_left;
}

int
MonteCarlo::GetRandomOpport(int who, krint *played)
{
  int move = szanse.DajLosowa(rozgrywka, r2, plansz_p, skl_tab,
			      pola_wolne, ile_wolnych, who, played);
  if (move==-1)
    move = szanse.DajLosowa(rozgrywka, r2, plansz_p, skl_tab,
			    pola_wolne, ile_wolnych, 3-who, played);
  return move;
}

int MonteCarlo::GetNumOfAddOpport()
// out:
//   num_fp + number of opport (for any player) which are not in pola_wolne
//     (practically, these are points in sb's territory)
{
  int num_opp;
  krint *opp =
    szanse.DajSzanse(num_opp, rozgrywka, r2, plansz_p,
		     skl_tab, pola_wolne, ile_wolnych, 1);
  int ile_razem = ile_wolnych;
  for (int i=0; i<num_opp; i++) {
    // check if opp[i] is in pola_wolne[0,...,ile_wolnych]
    int it_is = 0;
    for (int j=0; j<ile_wolnych; j++)
      if (pola_wolne[j]==opp[i]) {
	it_is = 1;
	break;
      }
    if (!it_is)
      pola_wolne[ile_razem++] = opp[i];
  }
  // now second player
  opp = szanse.DajSzanse(num_opp, rozgrywka, r2, plansz_p,
			 skl_tab, pola_wolne, ile_wolnych, 2);
  for (int i=0; i<num_opp; i++) {
    // check if opp[i] is in pola_wolne[0,...,ile_razem-1]
    int it_is = 0;
    for (int j=0; j<ile_razem; j++)
      if (pola_wolne[j]==opp[i]) {
	it_is = 1;
	break;
      }
    if (!it_is)
      pola_wolne[ile_razem++] = opp[i];
  }
  return ile_razem;
}

int
MonteCarlo::GetRandomMove(krint *played, int moves_left)
{
  // no opportunities, get a random place (but not a nonsense one)
  int nr = moves_left>1 ? random(moves_left) : 0;
  // find the real index of a (left) move nr
  int starting = 0;
  for (;; starting++) {
    if (!played[pola_wolne[starting]]) {
      if (--nr < 0) break;
    }
    assert(starting < ile_wolnych);
  }
  nr = starting;
  while (bezs_na_bandzie.CzyPoleBezs(pola_wolne[nr])) {
    do {
      if (++nr==ile_wolnych) nr=0;
    }
    while (played[pola_wolne[nr]]);
    if (nr==starting)
      return -1;   // no good children left...
  }
  return pola_wolne[nr];
}

void
MonteCarlo::PlayOneMove(TZdobycze wynik[2], int who_now, int thismove, int prevmove,
			int depth, unsigned short int &flags, int remove_from_fp)
{
  if (remove_from_fp) {
    for (int j=0; j<ile_wolnych; j++)
      if (pola_wolne[j] == thismove) {
	pola_wolne[j] = pola_wolne[--ile_wolnych];
	break;
      }
  }
  int js, ile_skl=-1;
  int in_enemy_terr = (plansz_p[thismove] & (who_now==1 ? 8:4));
  if (js=GrajRuchUCT(rozgrywka, plansz_p, wynik, pola_wolne, ile_wolnych,     // js=, nie ==
		     who_now, thismove, prevmove, r2))
    ZnajdzSkladowe(skl_tab, r2, 1);
  else {
    ile_skl = DodajKropkeDoSkl(skl_tab_pom, skl_tab, r2, thismove, who_now, 42000+depth);
    // zamien skl_tab <--> skl_tab_pom
    krint *pom = skl_tab_pom;      skl_tab_pom = skl_tab;      skl_tab = pom;
  }
  szanse.UaktualnijPoRuchu(js, ile_skl, thismove, who_now);
  int zz=0;
  int ile_dod = AddPossiblyFreePts(&pola_wolne[ile_wolnych],
				   rozgrywka, plansz_p, 0, who_now);
  if ((flags & FLAG_SKIP_ZAGR)==0) {
    int ile_sz;
    krint *pola_szans =
      szanse.DajSzanse(ile_sz, rozgrywka, r2, plansz_p,
		       skl_tab, pola_wolne, ile_wolnych, 3-who_now);
    zz = ZamknijZagrozone(rozgrywka, plansz_p, wynik, who_now, r2, NULL,
			  pola_szans, ile_sz, flags);
  }
  else if (flags & MASK_MOVE) {    // we need to call ZamknijZagrozone to make 1 enclosure
    int ile_sz;
    zz = ZamknijZagrozone(rozgrywka, plansz_p, wynik, who_now, r2, NULL,
			  NULL, ile_sz, flags);
  }
  int zs=0;
  if ((depth==1 || in_enemy_terr) && (flags & FLAG_SKIP_SPORNE)==0)
    zs = ZamknijSporne(rozgrywka, plansz_p, wynik, who_now, r2, r3, flags);
  if (zz || zs) {
    js = 3;
    ZnajdzSkladowe(skl_tab, r2, 1);
    // tutaj nie trzeba dawac CheckPossiblyFreePts, bo rozgrywka sie nie zmienila
    ile_wolnych += ile_dod;
    UaktualnijListePol(plansz_p, pola_wolne, ile_wolnych);
    szanse.UaktualnijPoZamknZagr(who_now);
  }
  bezs_na_bandzie.DodajKropke(thismove);
  na_pewno_bezp.Uaktualnij(rozgrywka, plansz_p, js, thismove, who_now, pola_wolne, ile_wolnych);
}

int
MonteCarlo::Graj(int kto, int pop_ruch, TZdobycze zdobycze[2])
// zaczyna gracz kto, rozgrywa do konca (nie wypelniajac brzuszkow),
// zwraca wynik gry (0=wygral gracz 1, 1=remis, 2=wygral gracz 2)
// NISZCZY rozgrywka, zdobycze; ale nie plansz_p
// wersja 3:
//  wybiera w miare mozliwosci ruchy zamykajace,
//  a jesli nie ma, to wybiera ktorys z ruchow zamykajacych przeciwnika
//   -- to moze byc zle, bo czasami moze wstawic kropke ktora zaraz straci
//   -- ale moze za to pomoze na drabinki z wersji 2
{
  // no i graj losowo...
  /*
  // test:
  MonteCarlo pl;
  pl.PrzydzielPamiec();
  pl.Inicjuj(rozgrywka, plansz_p);
  if (pl.ile_wolnych != ile_wolnych) {
    assert(0);
  }
  if (pl.ile_wolnych && !(pl.bezs_na_bandzie == bezs_na_bandzie)) {
    assert(0);
  }
  pl.ZwolnijPamiec();
  */
 
  while (ile_wolnych) {
    int ruch, js;
    int juz_wykonany = 0;

    ruch = szanse.DajLosowa(rozgrywka, r2, plansz_p, skl_tab,
			    pola_wolne, ile_wolnych, kto);
    if (ruch==-1)
      ruch = szanse.DajLosowa(rozgrywka, r2, plansz_p, skl_tab,
			      pola_wolne, ile_wolnych, 3-kto);

    if (ruch==-1) {
      // nie bylo stopow ani dla nas, ani dla przeciwnika
      int nr_ruchu = random(ile_wolnych);
      ruch = pola_wolne[nr_ruchu];
      while (bezs_na_bandzie.CzyPoleBezs(ruch)) {
	// nie ma obaw o petle nieskonczona, bo jak jakis ruch na bandzie jest bez sensu,
	// to obok tej bandy jest cala linia wolna
	if (++nr_ruchu == ile_wolnych) nr_ruchu=0;
	ruch = pola_wolne[nr_ruchu];
      }
      pola_wolne[nr_ruchu] = pola_wolne[--ile_wolnych];    // usun ruch
    }
    else {
      // usun ruch
      for (int i=0; i< ile_wolnych; i++)
	if (pola_wolne[i] == ruch) {
	  pola_wolne[i] = pola_wolne[--ile_wolnych];    // usun ruch
	  break;
	}
    }

    unsigned short int flags = 0;
    PlayOneMove(zdobycze, kto, ruch, pop_ruch, 3000+ruch, flags, 0);

    /*
    js = GrajRuchUCT(rozgrywka, plansz_p, zdobycze,
		     pola_wolne, ile_wolnych, kto, ruch, pop_ruch, r2, r3);

    bezs_na_bandzie.DodajKropke(ruch);
    int ile_skl;
    if (js) {
      ZnajdzSkladowe(skl_tab, r2, 1);
      //ile_skl=2;  // zmien status szans!
    }
    else {
      ile_skl = DodajKropkeDoSkl(skl_tab_pom, skl_tab, r2, ruch, kto, 45000+ruch);
      // zamien skl_tab <--> skl_tab_pom
      krint *pom = skl_tab_pom;      skl_tab_pom = skl_tab;      skl_tab = pom;
    }
    szanse.UaktualnijPoRuchu(js, ile_skl, ruch, kto);
    // zamknij zagrozone pola...
    int ile_sz;
    krint *pola_szans =
      szanse.DajSzanse(ile_sz,
		       rozgrywka, r2, plansz_p,
		       skl_tab, pola_wolne, ile_wolnych, 3-kto);
    if (ZamknijZagrozone(rozgrywka, plansz_p, zdobycze, kto, r2, r3,
			 pola_szans, ile_sz)) {
      ZnajdzSkladowe(skl_tab, r2, 1);
      UaktualnijListePol(plansz_p, pola_wolne, ile_wolnych);
      szanse.UaktualnijPoZamknZagr(kto);
    }
    */

    kto ^= 3;  // zmien gracza na ruchu
    pop_ruch = ruch;
  }

  int wynik = 2*(zdobycze[0].zd + zdobycze[0].pot_zd) + zdobycze[0].ss -
    ( 2*(zdobycze[1].zd + zdobycze[1].pot_zd) + zdobycze[1].ss );
  {
    int ile_wolnego, ile_wolnego_poza_sts;
    IleWolnegoMiejsca(rozgrywka, plansz_p,
		      ile_wolnego, ile_wolnego_poza_sts);
    if (ile_wolnego & 1)
      wynik += (kto==2) ? 1: -1;
  }
  return wynik;
}

int GrajLosowo(unsigned char* rozgrywka, unsigned char* plansz_p,
	       int kto, int pop_ruch, TZdobycze zdobycze[2], int fun_mc)
{
  switch (fun_mc % 3) {
  case 1:
    return GrajLosowo1(rozgrywka, plansz_p, kto, pop_ruch, zdobycze);
  case 2:
    return GrajLosowo2(rozgrywka, plansz_p, kto, pop_ruch, zdobycze);
  default: {
     MonteCarlo monte_carlo;
     monte_carlo.PrzydzielPamiec();
     monte_carlo.Inicjuj(rozgrywka, plansz_p);
     int wynik = monte_carlo.Graj(kto, pop_ruch, zdobycze);
     monte_carlo.ZwolnijPamiec();
     return wynik;
  }
  }
}
// UCT ............................................................................
// Node:
//   num_sibl = number of siblings (free places), 0 if unknown;
//              stored (and used) only in the first sibling
//   flags    = for use in MonteCarlo::PlayOneMove, to avoid calling ZamknijZagr/Sporne

#define MAXNODE 150000100
struct Node {
  int wins, visits;
  int move;
  Node *child, *sibling;
  short int num_sibl;
  unsigned short int flags;
  //  int value;   // this is the exact result of 1 game obtained by MC, "+" means good for 1. player, "-" - 2.
};


pthread_mutex_t uct_node_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t uct_depths_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t uct_pamiec_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t uct_nsim_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t uct_ekran_mutex = PTHREAD_MUTEX_INITIALIZER;

class UCT {
  Node *pamiec;
  int uzyte;
  int node_table_size;
  krint *depths;     // for debug/show analysis purposes
  int  mc_function;  // which MC function to use
public:
  // variables that (will) allow parallel computations:
  MonteCarlo player_save;
  TZdobycze zdob_save[2];
  Node *root;
  int max_nsim, nsim;
  int kto_save;
public:
  static double FPU;
  UCT() { uzyte=0; node_table_size=0; pamiec = NULL; };
  ~UCT() { if (pamiec) delete[] pamiec; };
  Node* NewNode();
  void Free() { uzyte=0; };
  void AllocMem(int nsim);
  int Search(unsigned char *rozgr, unsigned char *plansz_p, TZdobycze zdob[2],
	     int kto, int max_nsim_arg, int mc_fun);
#ifndef TEKSTOWY
  void ShowAnalysis(Node *root);
#endif
  Node* FindBest(Node *n);
  int PlayOneSeq(Node *root, Node *node[500],
		 MonteCarlo &player, //unsigned char *r, unsigned char *pp,
		 //unsigned char *r2, krint *skl_tab, krint *skl_tab_2,
		 //BezsensowneNaBandzie bezs_na_bandzie,
		 //NaPewnoBezp &na_pewno_bezp, Szanse &szanse,
		 //krint *free_places, int num_fp,
		 TZdobycze wynik[2], int kto, int nsim);
  Node* Descend(Node *n, MonteCarlo &player, /*unsigned char *r, unsigned char *pp,
		unsigned char *r2, krint *skl_tab, krint *skl_tab_2,
		BezsensowneNaBandzie bezs_na_bandzie, Szanse &szanse,
		krint *free_places, int num_fp,*/ int kto);
  double UCTfun(int wins, int node_visits, int parent_visits);
  int isWon(int result, int who);
  void UpdateValue(Node *node[500], int n, int value);
  void UpdateValue10(Node *node[500], int n, int value);
  void ZapiszGalaz(FILE *f, Node *n, int depth);
  void ZapiszDrzewo(Node *root);

} uct;

double UCT::FPU = 1.1;

Node* UCT::NewNode()
{
  assert(uzyte<node_table_size);
  Node *n = &pamiec[uzyte++];
  n->child = NULL;
  n->sibling = NULL;
  n->wins=0;   n->visits=0;  n->move=0;
  n->num_sibl=0;
  n->flags = 0;
  //  n->value=0;
  return n;
}

int UCT::isWon(int result, int who)
{
  if (who==1)
    return (result>0) + (result>=0);
  else  // who==2
    return (result<0) + (result<=0);
}

void UCT::ZapiszGalaz(FILE *f, Node *n, int depth)
{
  char s[1000];
  for (int i=0; i<depth; i++) { s[3*i]=' '; s[3*i+1]=' '; s[3*i+2]=' '; }
  s[3*depth]=0;
  fprintf(f, "%s[%d] v=%d w=%d\n", s, n->move, n->visits, n->wins);//, n->value);
  if (n->child)
    ZapiszGalaz(f, n->child, depth+1);
  if (n->sibling)
    ZapiszGalaz(f, n->sibling, depth);
}

void UCT::ZapiszDrzewo(Node *root)
{
  FILE *f = fopen("drzewo.txt", "a+t");
  if (f==NULL) return;
  ZapiszGalaz(f, root, 0);
  fclose(f);
}

double UCT::UCTfun(int wins, int node_visits, int parent_visits)
{
  STOPER_START_UCTF;
  double uct_value = double(wins) / (2*node_visits);    // 2*, because win=2, draw=1, loss=0
  uct_value += sqrt(2*log(parent_visits) / node_visits);
  //uct_value += sqrt( pow(parent_visits, 0.66666667) / (16*node_visits));
  STOPER_STOP_UCTF;
  return uct_value;
}

void UCT::AllocMem(int nsim)
{
  if (pamiec==NULL) {
    node_table_size = nsim+10;
    if (node_table_size < 10010) node_table_size = 10010;
    pamiec = new Node[node_table_size];
  }
  else if (node_table_size < nsim+10) {
    node_table_size = nsim+10;
    delete[] pamiec;
    pamiec = new Node[node_table_size];
  }
}

void* SearchGlobal(void* arg)
{
  MonteCarlo player; // a class for (fast) game playing
  player.PrzydzielPamiec();
  TZdobycze wynik[2];
  Node* node[500];
  int ile_w_watku = 0;
  for (;;) {
    ile_w_watku++;
    pthread_mutex_lock(&uct_ekran_mutex);
    statystyka_dla_analizy.funk_ocen++;
    pthread_mutex_unlock(&uct_ekran_mutex);
    player.Inicjuj(uct.player_save);
    wynik[0]=uct.zdob_save[0];    wynik[1]=uct.zdob_save[1];
#ifdef DEBUG_PELNAANALIZA
    drzewo_global->sgftreeRestoreNode();
#endif
    if (!uct.PlayOneSeq(uct.root, node, player, wynik, uct.kto_save, uct.nsim))
      break;
#ifndef TEKSTOWY
    pthread_mutex_lock(&uct_nsim_mutex);
    if (uct.nsim % 2500==0) {
      pthread_mutex_unlock(&uct_nsim_mutex);
      pthread_mutex_lock(&uct_ekran_mutex);
      uct.ShowAnalysis(uct.root);
      if (ekran.CzyPrzerwacAnalize() > 0) {
	pthread_mutex_unlock(&uct_ekran_mutex);
	break;
      }
      pthread_mutex_unlock(&uct_ekran_mutex);
    }
    else
      pthread_mutex_unlock(&uct_nsim_mutex);
#endif
    // go on?
    pthread_mutex_lock(&uct_nsim_mutex);
    if (++uct.nsim >= uct.max_nsim) {
      pthread_mutex_unlock(&uct_nsim_mutex);
      break;
    }
    pthread_mutex_unlock(&uct_nsim_mutex);
  }
  /*
  pthread_mutex_lock(&uct_ekran_mutex);
  printf("%d", ile_w_watku);
  pthread_mutex_unlock(&uct_ekran_mutex);
  */
  player.ZwolnijPamiec();
}


int UCT::Search(unsigned char *rozgr, unsigned char *plansz_p, TZdobycze zdob[2],
		int kto, int max_nsim_arg, int mc_fun)
{
  mc_function = mc_fun;
  player_save.PrzydzielPamiec();
  switch (player_save.Inicjuj(rozgr, plansz_p)) {
  case 0: {
    int ile_wolnego, ile_wolnego_poza;
    IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza);
    if (ile_wolnego_poza) {
      int ktory = random(ile_wolnego_poza);
      for (int indeks = up.lg; indeks<=up.pd; indeks++)
	if (upl_marg[indeks]>=2) {
	  if ((plansz_p[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
	      rozgr[indeks]==0)        // nie ma tu jeszcze kropki
	    if ((ktory--) ==0) {
	      player_save.ZwolnijPamiec();
	      return indeks;
	    }
	}
    }
    else
      if (ile_wolnego) {
	int x, y, st_x=0, st_y=0;
	int ile=GraKoncowa(rozgr, plansz_p, kto, player_save.GetFreePlaces(), x, y, st_x, st_y);
	player_save.ZwolnijPamiec();
	if (x!=0) return WezIndeksTab(x,y);
	else return 0;
      }
    player_save.ZwolnijPamiec();
    return 0;
  }
  case 1: {
    int ind = player_save.GetFreePlace(0);
    player_save.ZwolnijPamiec();
    return ind;
  }
  }

  depths = skladowe.PrzydzielSkladowa();
  CzyscTablice(depths);
  max_nsim = max_nsim_arg;
  if (max_nsim<100) max_nsim=100;
  if (max_nsim>MAXNODE-10) max_nsim=MAXNODE-10;
  AllocMem(max_nsim);
  root = NewNode();
  nsim = 0;

  zdob_save[0] = zdob[0];  zdob_save[1] = zdob[1];
  kto_save = kto;

  pthread_rwlock_init(&uct_treerw_mutex, NULL);

#ifdef ONLY_1_THREAD
  SearchGlobal(NULL);
#else
  if (mc_fun <=3)
    SearchGlobal(NULL);
  else {
    int num_thr = 1 + ((mc_fun-1) / 3);
    if (num_thr>16) num_thr=16;
    pthread_t thread[16];
    int  iret[16];
    for (int i=0; i<num_thr; i++)
      iret[i] = pthread_create( &thread[i], NULL, SearchGlobal, NULL);
    for (int i=0; i<num_thr; i++)
      pthread_join( thread[i], NULL);
  }
#endif

  pthread_rwlock_destroy(&uct_treerw_mutex);

#ifndef TEKSTOWY
  ShowAnalysis(root);
  ekran.WyswietlUCT(NULL, 0);
#endif
  Free();
  skladowe.ZwolnijSkladowa(depths);
  player_save.ZwolnijPamiec();
  //  ZapiszDrzewo(root);
  Node *best = FindBest(root);
  if (best==NULL)
    return 0;
  else
    return best->move;
}


int UCT::PlayOneSeq(Node *root, Node *node[500], MonteCarlo &player,
		    TZdobycze wynik[2], int kto, int nsim)
// returns: 1=go on, 0=halt
// arg nsim is just for information purposes
{
  node[0]=root;
  int i=0;
  int who_now = kto;
  do {
    node[i+1] = Descend(node[i], player, who_now);
    if (node[i+1]==NULL) {
      int result;
      if ((mc_function % 3)==0)
	result = player.Graj(who_now, (i>0 ? node[i-1]->move:0), wynik);
      else
	result = GrajLosowo(player.rozgrywka, player.plansz_p,
			    who_now, (i>0 ? node[i-1]->move:0), wynik, mc_function);
      int win = isWon(result, who_now);
      int value =  16*win;
      UpdateValue10(node, i, value);
      //      return 0;   // halt... could be later...
      return 1;   // do not halt
    }
    i++;
    pthread_rwlock_rdlock(&uct_treerw_mutex);
    unsigned short int flags = node[i]->flags;
    unsigned short int flags2 = flags;
    pthread_rwlock_unlock(&uct_treerw_mutex);
    player.PlayOneMove(wynik, who_now, node[i]->move, node[i-1]->move, i, flags);
    if (flags!=flags2) {
      pthread_rwlock_wrlock(&uct_treerw_mutex);
      node[i]->flags = flags;
      pthread_rwlock_unlock(&uct_treerw_mutex);
    }
    who_now ^= 3;
    pthread_rwlock_rdlock(&uct_treerw_mutex);
    if (node[i]->visits == 0) {
      pthread_rwlock_unlock(&uct_treerw_mutex);
      break;
    }
    pthread_rwlock_unlock(&uct_treerw_mutex);
  }
  while (1); // while (node[i]->visits > 0);
#ifdef DEBUG_PELNAANALIZA
      char comm[14];
      sprintf(comm,"n=%d.",nsim);
      drzewo_global->sgftreeAddComment(comm);
#endif

  int result;
  if ((mc_function % 3)==0)
    result = player.Graj(who_now, (i>0 ? node[i-1]->move:0), wynik);
  else
    result = GrajLosowo(player.rozgrywka, player.plansz_p,
			who_now, (i>0 ? node[i-1]->move:0), wynik, mc_function);
  //  node[i]->value = result;
  UpdateValue(node, i, isWon(result, who_now ^ 3));
  return 1;
}

Node* UCT::Descend(Node *n, MonteCarlo &player, int kto)
// may return NULL if we're in terminal node
// DOES NOT play any move!
{
  krint *played = skladowe.PrzydzielSkladowa();   // played moves
  CzyscTablice(played);
  pthread_rwlock_rdlock(&uct_treerw_mutex);
  Node *ch = n->child;   // first child
  int nc = 0;          // number of children
  // find best child
  double best_uct = -10000000;
  Node *best_node = NULL;
  Node *chlast = ch;
  while (ch!=NULL) {
    played[ch->move] = 1;
    double uct_value = UCTfun(ch->wins, ch->visits, n->visits);
    if (uct_value > best_uct) {
      best_uct = uct_value;
      best_node = ch;
    }
    chlast = ch;
    ch = ch->sibling;
    nc++;
  }
  int all_moves_played =     // all are played or it is not known
    (n->child && n->child->num_sibl && nc==n->child->num_sibl);
  pthread_rwlock_unlock(&uct_treerw_mutex);
  if (all_moves_played || best_uct >= FPU) {  // best_uct >= FPU means no need to visit other
    skladowe.ZwolnijSkladowa(played);
    return best_node;    // possibly NULL, if we reached terminal node
  }
  if (n->child && n->child->num_sibl==0) {
    pthread_rwlock_wrlock(&uct_treerw_mutex);
    n->child->num_sibl = player.GetNumOfAddOpport();
    pthread_rwlock_unlock(&uct_treerw_mutex);
  }
  int move = player.GetRandomOpport(kto, played);
  // find the number of moves left in the free_places table
  int moves_left = player.GetNumberOfMovesLeft(played);
  // all children already visited
  if (move==-1 && moves_left==0) {
    skladowe.ZwolnijSkladowa(played);
    return best_node;    // possibly NULL, if we reached terminal node
  }
  // take some free place randomly as a new child, if no atari
  // or saving-stones move was found
  if (move==-1) {
    move = player.GetRandomMove(played, moves_left);
    if (move==-1) {
      chlast = best_node;   // no good children left...
      goto Exit_label;
    }
  }
  pthread_rwlock_wrlock(&uct_treerw_mutex);
  if (n->child==NULL)
    chlast = n->child = NewNode();
  else {
    // find the last node (it need not be chlast, because tree was not locked
    //  for other threads)
    ch = chlast!=NULL ? chlast->sibling : n->child;
    while (ch!=NULL) {
      chlast = ch;
      if (chlast->move == move) {
	pthread_rwlock_unlock(&uct_treerw_mutex);
	goto Exit_label;
      }
      ch = ch->sibling;
    }
    // now chlast is indeed the last sibling
    chlast->sibling = NewNode();
    chlast = chlast->sibling;
  }
  chlast->move = move;
  pthread_rwlock_unlock(&uct_treerw_mutex);
 Exit_label:;
  skladowe.ZwolnijSkladowa(played);
  return chlast;
}

Node* UCT::FindBest(Node *n)
{
  pthread_rwlock_rdlock(&uct_treerw_mutex);
  Node *best_node = NULL;
  double best_value = -10000000;
  Node *ch = n->child;
  while (ch!=NULL) {
    double curr_value = double(ch->wins) / ch->visits;
    if (curr_value > best_value) {
      best_value = curr_value;
      best_node = ch;
    }
    ch = ch->sibling;
  }
  pthread_rwlock_unlock(&uct_treerw_mutex);
  return best_node;    // possibly NULL, if we reached terminal node
}

#ifndef TEKSTOWY
void UCT::ShowAnalysis(Node *root)
{
  struct MoveValue {
    double value;
    int move, visits;
  } best[10];
  for (int i=0; i<10; i++) {
    best[i].value = -10000000;
    best[i].move  = -1;
  }
  pthread_rwlock_rdlock(&uct_treerw_mutex);
  Node *ch = root->child;
  while (ch!=NULL) {
    double curr_value = double(ch->wins) / ch->visits;
    for (int i=0; i<10; i++)
      if (curr_value > best[i].value) {
	for (int j=10-1; j>i; j--)
	  best[j] = best[j-1];
	best[i].move = ch->move;
	best[i].visits = ch->visits;
	best[i].value = curr_value;
	break;
      }
    ch = ch->sibling;
  }
  pthread_rwlock_unlock(&uct_treerw_mutex);
  char s[10+1][50], *sp[10+1];
  int num = 11;
  sprintf(s[0], "ruch ocena wizyt (gleb)");  sp[0]=s[0];
  for (int i=0; i<10; i++)
    if (best[i].move>0) {
      char ms[10];
      TEkran::RuchTekst(ms, upl_x[best[i].move]-2, upl_y[best[i].move]-2);
      sprintf(s[i+1], "%s=[%d] %3g %d (%d)", ms, best[i].move, best[i].value/2, best[i].visits, int(depths[best[i].move]));
      sp[i+1] = s[i+1];
    }
    else { num=i+1; break; }
  ekran.WyswietlUCT(sp, num);
}
#endif

void UCT::UpdateValue(Node *node[500], int n, int value)
{
  pthread_rwlock_wrlock(&uct_treerw_mutex);
  for (int i=n; i>=0; i--) {
    node[i]->wins += value;
    node[i]->visits++;
    value = 2-value;    // swap
  }
#ifndef TEKSTOWY
  if (depths[node[1]->move] < n)
    depths[node[1]->move] = n;
#endif
  pthread_rwlock_unlock(&uct_treerw_mutex);
}

void UCT::UpdateValue10(Node *node[500], int n, int value)
{
  pthread_rwlock_wrlock(&uct_treerw_mutex);
  for (int i=n-1; i>=0; i--) {
    node[i]->wins   += value;
    node[i]->visits += 0x10;
    value =32-value;    // swap
  }
  pthread_rwlock_unlock(&uct_treerw_mutex);
}

// UCT ............................................................................

int ZnajdzDomyslneIPotrzebneRuchy(unsigned char* rozgrywka, unsigned char* plansz_p,
			int ktory_gracz,
			krint *nruchy, int st_x, int st_y)
// we: nruchy[0] -- ruch do wykonania
// wy:
//   zwraca n = liczbe ruchow (co najmniej jeden),
//   a w nruchy[1],...,nruchy[n-1] -- domyslne ruchy zamykajace lub ruchy,
//     ktore trzeba wykonac, bo inaczej przeciwnik nam cos zabierze
{
  unsigned char *pp = plansze.PrzydzielPlansze();
  unsigned char *r = plansze.PrzydzielPlansze();
  unsigned char *r2 = plansze.PrzydzielPlansze();
  unsigned char *r3 = plansze.PrzydzielPlansze();
  KopiujTablice(r, rozgrywka);
  KopiujTablice(pp, plansz_p);
  WezRozgr23(r, r2, r3, plansz_p);
  int ile_domysl, ile_zd,pow,pow2,ile_zd2;
  TZdobycze zdobycze[2];   TZobrist htab_zobr;

  ZrobRuch(r, NULL, &nruchy[1], ile_domysl,
	   NULL, 0, pp, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
	   zdobycze, htab_zobr,
	   ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, r2, r3);

  krint *pola_szans = skladowe.PrzydzielSkladowa();
  int ile_sz=0;
  for (int i=up.lg; i<=up.pd; i++)
    if (upl_marg[i]>=2)
      pola_szans[ile_sz++] = i;   // nieefektywne! wszystkie pola jako szanse!

  unsigned short int flags=0;
  ile_domysl += ZamknijZagrozone(r, pp, zdobycze, ktory_gracz, r2, r3,
				 pola_szans, ile_sz, flags, &nruchy[ile_domysl+1]);
  ile_domysl += ZamknijSporne(r, pp, zdobycze, ktory_gracz, r2, r3,
			      flags, &nruchy[ile_domysl+1]);

  skladowe.ZwolnijSkladowa(pola_szans);
  plansze.ZwolnijPlansze(pp);  plansze.ZwolnijPlansze(r);
  plansze.ZwolnijPlansze(r2);  plansze.ZwolnijPlansze(r3);
  return ile_domysl + 1;
}


int ZnajdzNajlepszyRuchMC(unsigned char* rozgrywka_arg, unsigned char* plansz_p_arg,
			  int ktory_gracz, const TGraczO &gracz,
			  krint *nruchy, int &x, int &y, int st_x, int st_y,
			  TZdobycze zdob_arg[2], TZobrist zobr_arg, int wybierz_ruchy,
			  SGFTree *drzewo)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
{
 if (st_x==0 && st_y==0) {
   // to jest pierwsza kropka!
   int margx = (wlkx>>2)-1;
   margx=margx<2 ? 2:margx;
   int margy = (wlky>>2)-1;
   margy=margy<2 ? 2:margy;
   x = 2+margx+random(wlkx-2*margx);
   y = 2+margy+random(wlky-2*margy);
   nruchy[0]=WezIndeksTab(x,y);
   return 1;
 }
 // TAnaliza::czas_przekr=0;
 // TAnaliza::czas.Zeruj();   TAnaliza::czas.Start();
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
 x=0; y=0;  // potrzebne w petli zwiekszajacej glebokosc
 if (ile_wolnego_poza) { // sa jakies wolne miejsca poza stalymi stopami
#ifndef TEKSTOWY
   ekran.PoczatekAnalizy();
   ekran.MinimaxPoczatek();
#endif
#ifdef DEBUG_PELNAANALIZA
   drzewo->sgftreeSaveNode();
   drzewo_global = drzewo;
#endif
   UCT::FPU = gracz.funkcja_mc_FPU / 10.0;
   int ruch = uct.Search(rozgrywka_arg, plansz_p_arg, zdob_arg, ktory_gracz, gracz.iteracji,
			 gracz.funkcja_mc);
#ifndef TEKSTOWY
   //   ekran.KoniecAnalizy();
#endif
   if (ruch==0) {
     x=-1; y=-1; 
     return 0;
   }
   x = upl_x[ruch];
   y = upl_y[ruch];
   nruchy[0] = ruch;
   return
     ZnajdzDomyslneIPotrzebneRuchy(rozgrywka_arg, plansz_p_arg,
				   ktory_gracz, nruchy, st_x, st_y);
   
 }
 else if (ile_wolnego) {
   int ile=GraKoncowa(rozgrywka_arg, plansz_p_arg, ktory_gracz, nruchy, x, y, st_x, st_y);
   if (x!=0) return ile;
 }
 x=-1; y=-1;
 return 0;
}
