#if !defined(__BASIC_H)
#define __BASIC_H
#include <string.h>  //memset
#include "pla_skl.h"
#include "ekro.h"
#include "sstop3.h"
#include "basic.h"

// wylaczona SZYBKOSC daje mozliwosc sprawdzania zakresu w WezUC itp.
// ale spowalnia (dawno niesprawdzana opcja)
#define SZYBKOSC

extern int zasady_gry;
extern TRuchyZam ruchy_zam_NULL;  // zerowe ruchy zamykajace, do przekazywania jako domyslny par.

const int zobrist_maska[3] = {0, 0, 0x4000};   // maska ruchu dla (nikogo), gr.1, gr.2
const int zobrist_maska_stop[3] = {0, 0x2000, 0x6000};   // maska stopu dla (nikogo), gr.1, gr.2



extern unsigned long int bseed1;
extern unsigned long int bseed2;

struct TDwaUC
  {
  unsigned char x,y;
  int operator!=(TDwaUC p)
	 { return (this->x!=p.x || this->y!=p.y); };
  int operator==(TDwaUC p)
	 { return (this->x==p.x && this->y==p.y); };
  TDwaUC(unsigned char nx, unsigned char ny) { x=nx; y=ny; };
  TDwaUC() { ; };
  };


#ifdef SZYBKOSC
#define WezUC(t,x,y)  ((t)[(x)*(wlky+4)+(y)])
#define WezUI(t,x,y)  ((t)[(x)*(wlky+4)+(y)])
#define WezIndeksTab(x,y)  ((x)*(wlky+4)+(y))
#else

inline unsigned char& WezUC(unsigned char* tab, int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("UC: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return tab[x*(wlky+4)+y]; }

inline unsigned int WezIndeksTab(int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("IT: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return x*(wlky+4)+y; }

inline krint& WezUI(unsigned int* tab, int x, int y)
{
if (!(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4))
  {
  printf("UI: x=%d, y=%d",x,y);
  assert(x>=0 && x<wlkx+4 && y>=0 && y<wlky+4);
  }
return tab[x*(wlky+4)+y]; }
#endif  // ifdef SZYBKOSC

unsigned short int random(unsigned short int n);
void brandomize();
int SGFDajPole(char *wsp);

int CzyPolaczone(unsigned char*tab, int x1, int y1, int x2, int y2);


inline void  CzyscTablice(unsigned char* tab)
{ STOPER_START_TABL; memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void  CzyscTablice(krint* tab)
{ STOPER_START_TABL; memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void  CzyscTablice(skrint* tab)
{ STOPER_START_TABL;memset(tab, 0, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void  KopiujTablice(unsigned char* tab, const unsigned char* skad)
{ STOPER_START_TABL; memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void  KopiujTablice(krint *tab, const krint *skad)
{ STOPER_START_TABL;memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

inline void  KopiujTablice(skrint *tab, const skrint *skad)
{ STOPER_START_TABL;memcpy(tab, skad, sizeof(tab[0])*wlkx4wlky4); STOPER_STOP_TABL; }

/*
inline void  CzyscTablice(unsigned char* tab);
inline void  CzyscTablice(krint* tab);
inline void  CzyscTablice(skrint* tab);
inline void  KopiujTablice(unsigned char* tab, const unsigned char* skad);
inline void  KopiujTablice(krint *tab, const krint *skad);
inline void  KopiujTablice(skrint *tab, const skrint *skad);
*/

int UstawOtoczenie(unsigned char otoczenie[9]);

void ZnajdzSkladowa(krint *skl, unsigned char* pl,
                    unsigned int numskl,
                    unsigned int ind);


void WezRozgr23(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3,
                unsigned char *plansz_p);


void WezRozgr4(unsigned char *rozgrywka, unsigned char *rozgr4,
	       unsigned char *plansz_p);

void WezOtoczenie(unsigned char ot[9], int x, int y,
		  unsigned char* plansz_p, unsigned char* rozgrywka,
                  int ktory_gracz);



void WezOtoczenieUlatw(unsigned char ot[9], int x, int y,
                       unsigned char* rozgr2,
		       int ktory_gracz);



int PustePole(unsigned char *rozgrywka, unsigned char *plansz_p, unsigned char *rozgr3,
	      unsigned int ind);


int PrzejdzWnetrze(const unsigned char *rozgrywka, const unsigned char *plansz_p,
                   unsigned char *plan, unsigned int ind, unsigned int &lewo,
                   int kto);

int ZnajdzBrzegStopu(krint *dad, unsigned char *plan, unsigned int lewo);



int ZrobStopSGF(unsigned char* rozgrywka, unsigned char* stopy,
		char *sgf_ruch,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p,
		TZdobycze wynik[2], TZobrist& zobr);


void PostawKropke(unsigned char* rozgrywka,
		  unsigned char* rozgr2, unsigned char* rozgr3,
		  unsigned char* plansz_p, unsigned int ind, int kto,
		  TZdobycze wynik[2], TZobrist& zobr,
		  char *sgf_ruch=NULL);


int ZrobPanstwo(unsigned char* rozgrywka, unsigned char* stopy, 
		krint *nowe_ruchy, int &ile_domyslnych,
		char *sgf_ruch,
		int zostaw_stopy,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p, int x, int y, int ktory_gracz,
		TZdobycze zdakt[2], TZobrist &zobr,
		     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
		     int &punktacja_ss,
		TRuchyZam &ruchy_zam = ruchy_zam_NULL,
		int lancuchy=0);


int ZrobPanstwo(unsigned char* rozgrywka, unsigned char* stopy,
		unsigned char* rozgr2, unsigned char* rozgr3,
		unsigned char* plansz_p, int x, int y, int ktory_gracz,
		TZdobycze zdakt[2], TZobrist &zobr,
		     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
		     int &punktacja_ss,
		TRuchyZam &ruchy_zam = ruchy_zam_NULL,
		int lancuchy=0);


int ZrobRuch(unsigned char* rozgrywka, unsigned char* stopy,
	     krint *nowe_ruchy, int &ile_domyslnych,
	     char *sgf_ruch, int zostaw_stopy,
	     unsigned char* plansz_p, unsigned int ruch, int ktory_gracz,
	     unsigned int ind_st, TZdobycze wynik[2], TZobrist &zobr,
	     int &ile_zdobytych, int &powierzchnia, int &powierzchnia2,
	     int &ile_zdobytych2,
	     TRuchyZam &ruchy_zam = ruchy_zam_NULL,
	     unsigned char* rozgr2=NULL, unsigned char* rozgr3=NULL);


int CzyMozliwyStop(krint *skl, unsigned char *rozgr2, int i, int j, int ktory_gracz);
int CzyMozliwyStop(krint *skl, unsigned char *rozgr2, int ind, int ktory_gracz);


void IleWolnegoMiejsca(unsigned char* rozgrywka, unsigned char* plansz_p,
                       int &ile_wolnego, int &ile_wolnego_poza_sts);


void ZnajdzSkladowe(krint *skl_tab, unsigned char *rozg, int ktory_gracz);


int DodajKropkeDoSkl(krint *wynik, krint *we, unsigned char *rozgr2,
		     unsigned int indeks, int czyja, krint numskl);


int ZnajdzDomyslneRuchy(unsigned char* rozgrywka, unsigned char* plansz_p,
			int ktory_gracz,
			krint *nruchy, int st_x, int st_y);



int GraKoncowa(unsigned char* rozgrywka, unsigned char* plansz_p,
                int ktory_gracz, 
	       krint *nruchy, int &x, int &y, int st_x, int st_y);


#endif
