/*  Programik do gry w kropki; kro84.cc - glowny plik.
 *
 *  Copyright (C) 1999,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011
 *      Bartek Dyda <kropki@yahoo.co.uk>.
 *
 *  Some ideas by Rafal Pikula (1999,2001,2002,2003,2004,2005,2006,2007)
 *
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#define WERSJA_KROPEK 84
#define WERSJA_KROPEK_LOW 13

// to jesli chcesz ogladac pelna analize (az do liscia) na kazdej glebokosci
//#define DEBUG_PELNAANALIZA

// To potrzebne tez w pla_skl.h; odejmij 13 zeby dostac max. glebokosc analizy bez rozszerzen
//#define MAX_GLEB_ANALIZY (13+8+4+1)
// Nie mozna przesadzac z uwagi na (np.) historia_waga

//Wersja do rozgrywania turniejow w trybie tekstowym: wlacz TEKSTOWY
//#define TEKSTOWY

// super-stopery:
// #define SA_STOPERY


#include <stdlib.h>
#include <stdio.h>
#include <algorithm>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <assert.h>  // assert()
//#define assert(p) ;
#include <limits.h>
#include <ctype.h>

#ifdef TEKSTOWY
 #define GrFlush()
#include <iostream>
using std::cin;
using std::cout;

#endif

#ifndef USTALONA_WLK_PLANSZY
unsigned short int wlkx=20;
unsigned short int wlky=20;
unsigned int wlkx4wlky4= (20+4)*(20+4);
#endif

struct TOpcjeGry {
  int korzystaj_z_pop_ht;
  TOpcjeGry() { 
    korzystaj_z_pop_ht=0;
  };
} opcje_gry;

#include "basic.h"
#include "pla_skl.h"
#include "ekro.h"
#include "mc.h"
#include "robaki.h"
#include "sstop3.h"

// klasa "TPlansze", obiekt "plansze":
// klasa "TSkladowe", obiekt "skladowe":
// klasa "TTabliceLI", obiekt "tabliceLI":
TSkladowe skladowe;
TPlansze  plansze;
TTabliceLI tabliceLI;
TTabliceR tabliceR;
Tup       up;   // ustalone pomocnicze
//
TSlowa slowa;
TStatystykaDlaAnalizy  statystyka_dla_analizy;
TStatystyki   statystyki_prog;
#ifndef TEKSTOWY
  char nazwa_pliku_pomocy[256];
#endif

unsigned int zobrist[0x8000];   // 32 bity
unsigned long long int zobrist2[0x8000];

TZobrist& TZobrist::operator^=(TZobrist k)
{
  z ^= k.z;  z2 ^= k.z2;
  return *this;
}

TZobrist& TZobrist::operator^=(int nr)
{
  z ^= zobrist[nr];  z2 ^= zobrist2[nr];
  return *this;
}
   


TGra gra;
TEkran ekran;
TParametryGry pargry;
TStoper stoper[3];   // gracza 0, gracza 1, ogolny

//**************************** POCZWORNY STOS/KOLEJKA (KOLEJKA PRIORYTETOWA)
struct TStos4 {
  krint *stos[4];
  int   pocz[4],kon[4];
  TStos4();
  ~TStos4();
  void Wyczysc();
  };

TStos4::TStos4()
{
 for (int i=0; i<4; i++) {
   if ((stos[i] = (krint*) malloc(sizeof(krint)*2*max_powierzchnia_planszy)) ==NULL)
     {
       printf("Stos4[%d]: Za malo pamieci.",i);
       abort();
     }
 }
 Wyczysc();
}

TStos4::~TStos4()
{ for (int i=0; i<4; i++) free(stos[i]); }

void TStos4::Wyczysc()
{ pocz[0]=pocz[1]=pocz[2]=pocz[3]=max_powierzchnia_planszy;
  kon[0] =kon[1] =kon[2] =kon[3] =max_powierzchnia_planszy; }
//**************************** POCZWORNY STOS/KOLEJKA (KOLEJKA PRIORYTETOWA)
TStos4 q4;

//*************************************** TABLICA MIESZAJACA Z
// nowa tablica mieszajaca z kluczami Zobrista
//int HTABZ_ILE_TAB_WYKL = 16;
//int HTABZ_ILE_TAB      = (1<<HTABZ_ILE_TAB_WYKL);
int HTABZ_ILE_TAB      = (1<<16);
int HTABZ_MASKA        = (HTABZ_ILE_TAB-1);
#define HTABZ_PROG  10000;


struct HTablicaZKl {
  unsigned long long klucz;
  int ocena;   // 32 bity
  unsigned int czas;  // 32 bity
  unsigned short int niepotrzebne_pole;
  unsigned char gleb_i_rodzaj;
  unsigned char zobrist1;
  short int prop[2];
};
  
class HTablicaZ {
  HTablicaZKl *klucze;
  unsigned  int akt_czas;   // 32 bity
  unsigned  int nieprzeterm; 
  unsigned  int nieprz_poczan; 
  unsigned  int info_poczan, info_poczgl;   // informacyjne wartosci akt_czas
  int czas_prog;
  // dane na temat ocen:
  int wx, wy;      // wielkosc planszy
  TGraczO gracz1;  // gracz nr 1 (jesli oceniamy dla gr 2, trzeba ,,odbic'' agresje itp.)
public:
  HTablicaZ();
  ~HTablicaZ();
  void PrzydzielPamiec();
  int Wez(TZobrist klz, int &rodzaj, 
	       unsigned short int &prop0, unsigned short int &prop1, int od_liscia);
  void Wstaw(TZobrist klz, int gleb, int ocena, int rodzaj, 
	     unsigned short int prop0, unsigned short int prop1, int od_liscia);
  void AnulujWpisy(const TGraczO& gr);
  void NowaGlebokosc();
  unsigned int DajAktCzas() { return akt_czas; };
} htablicaZ;

HTablicaZ::HTablicaZ()
{
  klucze=NULL;
  akt_czas=1;
  nieprzeterm=1;
  nieprz_poczan=1;
  info_poczan = info_poczgl = 1;
  czas_prog=HTABZ_PROG;
  wx=wy=0;
}

void HTablicaZ::PrzydzielPamiec()
{
  int pam = sizeof(HTablicaZKl) * HTABZ_ILE_TAB*2;
  klucze = (HTablicaZKl*) malloc(pam);
  assert(klucze!=NULL);
  // memset(klucze, 0, pam);
  for (int i=0; i<HTABZ_ILE_TAB*2; i++)
    klucze[i].czas=0;
}

inline HTablicaZ::~HTablicaZ() { free(klucze); }

inline void HTablicaZ::AnulujWpisy(const TGraczO& gr)
{ 
  if (akt_czas > 1000000000) {  // zabezpieczenie np. przy b. dlugim turnieju
    for (int i=0; i<HTABZ_ILE_TAB*2; i++)
      klucze[i].czas=0;
    akt_czas=0;
    nieprzeterm  = nieprz_poczan = ++akt_czas;
    info_poczan = info_poczgl = akt_czas;
    akt_czas++;
    czas_prog=HTABZ_PROG;
  }
  else if (wx!=wlkx || wy!=wlky || !(gr==gracz1)
	   || !opcje_gry.korzystaj_z_pop_ht) {
    nieprzeterm  = nieprz_poczan = ++akt_czas;
    info_poczan = info_poczgl = akt_czas;
    akt_czas++;
    czas_prog=HTABZ_PROG;
    wx=wlkx;  wy=wlky;  gracz1=gr;
  }
  else {
    info_poczan = info_poczgl = ++akt_czas;
    akt_czas++;
    czas_prog=HTABZ_PROG;
  }
}

inline void HTablicaZ::NowaGlebokosc()  
{ 
  //  nieprzeterm  = ++akt_czas;
  info_poczgl = ++akt_czas;
  akt_czas++;
  czas_prog=HTABZ_PROG;
}

int HTablicaZ::Wez(TZobrist klz, int &rodzaj, 
			unsigned short int &prop0, unsigned short int &prop1,
			int od_liscia)
// od_liscia = ost_gleb-akt_gleb
// zwraca INT_MAX, gdy pozycji nie ma
// 2 dolne bity rodzaj: = 0: ocena dokladna; =1: ograniczenie dolne; =2: ograniczenie gorne
//    (np. =1 oznacza, ze prawdziwa ocena jest >= zwroconej oceny)
// rodzaj & 4  : czy jest ocena (czyli czy zwraca cos !=INT_MAX)
// gornych 5 bitow wyzerowanych
{
  STOPER_START_ZWEZ;
  int nr_tab = (klz.z & HTABZ_MASKA) << 1;
  HTablicaZKl *k = &klucze[nr_tab];
  for (int i=0; i<2; i++)
    if (k[i].klucz==klz.z2 && k[i].zobrist1==(klz.z>>24)) {
      // klucz jest, spr. czy nieprzeterminowany
      if (k[i].czas >= nieprzeterm) {
	rodzaj = (k[i].gleb_i_rodzaj & 3);
	prop0 = k[i].prop[0];   prop1 = k[i].prop[1];
	STOPER_STOP_ZWEZ;
	if ((k[i].gleb_i_rodzaj >> 2)==od_liscia) {
	  rodzaj|=4;
	  return k[i].ocena;
	}
	else return INT_MAX;
      }
      else {  // klucz przeterminowany 
	if (k[i].czas >= nieprz_poczan) {
	  prop0 = k[i].prop[0];   prop1 = k[i].prop[1];
	  rodzaj = (k[i].gleb_i_rodzaj & 3);   // pokaz, jak wartosciowe sa propozycje (rodzaj==0: wartosciowe)
	}
	else { prop0 = prop1 =0;    rodzaj=0; }
	STOPER_STOP_ZWEZ;  
	return INT_MAX; 
      }
    }
  rodzaj=0;
  prop0 = prop1 = 0;
  STOPER_STOP_ZWEZ;
  return INT_MAX;  // klucza w ogole nie ma
}
    
void HTablicaZ::Wstaw(TZobrist klz, int gleb, int ocena, int rodzaj, 
		      unsigned short int prop0, unsigned short int prop1,
		      int od_liscia)
// od_liscia = ost_gleb-akt_gleb
// wstaw z preferencja najnizszych glebokosci klucza dla gleb<=6,
// dla glebszych preferowane nowsze klucze;
// mozna to zmienic...
{
  STOPER_START_ZWST;
  //assert(prop0<wlkx4wlky4 && prop1<wlkx4wlky4);
  //assert(prop0==0 || (prop0!=prop1));
  int nr_tab = (klz.z & HTABZ_MASKA) << 1;
  HTablicaZKl *k = &klucze[nr_tab];
  for (int i=0; i<2; i++)
    if (k[i].klucz==klz.z2 && k[i].zobrist1==(klz.z>>24)) {
      // klucz jest, wstaw nowa ocene i rodzaj
      if (k[i].czas >= nieprz_poczan) {
	// dodaj propozycje
	if (prop0) 
	  if (prop0!=k[i].prop[0])
	    {
	      k[i].prop[1] = prop1 ? prop1 : k[i].prop[0];
	      k[i].prop[0] = prop0;
	    }
	  else if (prop1)
	    k[i].prop[1] = prop1;
      }
      else { k[i].prop[0] = prop0;   k[i].prop[1] = prop1; }
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (od_liscia<<2)+rodzaj;
      statystyki_prog.ht_kolizja[0]++;
      STOPER_STOP_ZWST;
      return;
    }
  // klucza nie ma, spr. czy moze jest jakis przeterminowany
  for (int i=0; i<2; i++)
    if (k[i].czas < info_poczan) {   // bylo nieprz_poczan
      k[i].klucz = klz.z2;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (od_liscia<<2)+rodzaj;
      k[i].zobrist1      = (klz.z >> 24);
      k[i].prop[0] = prop0;   k[i].prop[1] = prop1;
      statystyki_prog.ht_kolizja[0]++;
      STOPER_STOP_ZWST;
      return;
    }
  // a moze jest jakis czesciowo przeterminowany
  for (int i=1; i>=0; i--)  // odwrotna kolejnosc!
    if (k[i].czas < info_poczgl) {         // bylo < nieprzeterm
	//	k[i].gleb_i_rodzaj < (4<<2)) {   // tylko 3 od liscia
      k[i].klucz = klz.z2;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[i].czas  = akt_czas;
      k[i].ocena = ocena;
      k[i].gleb_i_rodzaj = (od_liscia<<2)+rodzaj;
      k[i].zobrist1      = (klz.z >> 24);
      k[i].prop[0] = prop0;   k[i].prop[1] = prop1;
      statystyki_prog.ht_kolizja[1]++;
      STOPER_STOP_ZWST;
      return;
    }
  // nie sa przeterminowane
  // moze jest jakis o mniejszej glebokosci (od_liscia) od akt. ?
  // (tutaj mozliwe inne strategie)
  if (gleb<=6) {
  int ag = (od_liscia<<2)+rodzaj;
  if (k[0].gleb_i_rodzaj < k[1].gleb_i_rodzaj)
    if (k[0].gleb_i_rodzaj < ag) {
      // wstaw
      k[0].klucz = klz.z2;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[0].czas  = akt_czas;
      k[0].ocena = ocena;
      k[0].gleb_i_rodzaj = ag;
      k[0].zobrist1      = (klz.z >> 24);
      k[0].prop[0] = prop0;   k[0].prop[1] = prop1;
      statystyki_prog.ht_kolizja[2]++;
      STOPER_STOP_ZWST;
      return;
    }
    else if (k[1].gleb_i_rodzaj < ag) {
       // wstaw
      k[1].klucz = klz.z2;
      if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
      k[1].czas  = akt_czas;
      k[1].ocena = ocena;
      k[1].gleb_i_rodzaj = ag;
      k[1].zobrist1      = (klz.z >> 24);
      k[1].prop[0] = prop0;   k[1].prop[1] = prop1;
      statystyki_prog.ht_kolizja[2]++;
      STOPER_STOP_ZWST;
      return;
    }
  }
  else
    { // ruch o gleb >=7
    int nr;
    if (k[0].gleb_i_rodzaj < (4<<2))      // zastepujemy tylko klucze na gleb < 4
      if (k[1].gleb_i_rodzaj < (4<<2))    // mamy dwoch kandydatow
	nr= (k[0].czas >= k[1].czas);  // wybierz starszego z kandydatow
      else nr=0;   // jeden kandydat, nr 0
    else
      if (k[1].gleb_i_rodzaj < (4<<2))
	nr=1;
      else { statystyki_prog.ht_kolizja[3]++; STOPER_STOP_ZWST; return; } // nie ma kandydatow
    // wstaw
    k[nr].klucz = klz.z2;
    if (--czas_prog<=0) { czas_prog = HTABZ_PROG;  akt_czas++; }
    k[nr].czas  = akt_czas;
    k[nr].ocena = ocena;
    k[nr].gleb_i_rodzaj = (od_liscia<<2)+rodzaj;
    k[nr].zobrist1      = (klz.z >> 24);
    k[nr].prop[0] = prop0;   k[nr].prop[1] = prop1;
    statystyki_prog.ht_kolizja[2]++;
    STOPER_STOP_ZWST;
    return;
  }

  statystyki_prog.ht_kolizja[3]++;
  STOPER_STOP_ZWST;
}
//*************************************** TABLICA MIESZAJACA Z -- koniec


void UstawZobrist()
{
  unsigned long int bs1 = bseed1, bs2 = bseed2;
  bseed1 = 2005;  bseed2=44441;
  zobrist[0]=0;  zobrist2[0]=0;
  for (int i=1; i<sizeof(zobrist)/sizeof(zobrist[0]); i++) {
    zobrist[i] = random(4096);
    zobrist[i] <<= 11;
    zobrist[i] |= random(2048);
    zobrist[i] <<= 9;    
    zobrist[i] |= random(512);
    zobrist2[i] = random(1024);
    for (int j=0; j<6; j++) {
      zobrist2[i] <<= 9;
      zobrist2[i] |=  random(512);
    }
  }
  bseed1=bs1;  bseed2=bs2;
}



int OszacujWynik_PrzejdzBasen(unsigned char *policzone,
			      unsigned char *rozgrywka, unsigned char *plansz_p, int ind, int kto)
// kto = czyj basen
{
  krint *stos = skladowe.PrzydzielSkladowa();
  int na_stosie=0;
  stos[na_stosie++] = ind;
  int ile_pol=1;                           // ile lacznie pol ma basen
  int ile_krop=(rozgrywka[ind]==3-kto);    // w tym ile jest w nim kropek przeciwnika
  int minx = upl_x[ind], maxx = upl_x[ind];
  int miny = upl_y[ind], maxy = upl_y[ind];
  policzone[ind] = 1;
  int maska = (kto==1) ? 4:8;
  do {
    int pole = stos[--na_stosie];
    if (upl_x[pole] < minx) minx = upl_x[pole];
    else if (upl_x[pole] > maxx) maxx = upl_x[pole];
    if (upl_y[pole] < miny) miny = upl_y[pole];
    else if (upl_y[pole] > maxy) maxy = upl_y[pole];
    // odwiedz sasiadow
    for (int k=0; k<4; k++) {
      int npole = pole+up.dind[k];
      if (plansz_p[npole] & maska && !policzone[npole]) {
	policzone[npole] = 1;
	stos[na_stosie++] = npole;
	if (rozgrywka[npole]==3-kto) ile_krop++;
	ile_pol++;   // to zawsze, nawet jak kropka przeciwnika
      }
    }
  }
  while (na_stosie);
  skladowe.ZwolnijSkladowa(stos);
  switch (ile_pol) {
  case 1:
  case 2:
    return ile_pol - ile_krop;
  case 3:
    return 2 - ile_krop;
  case 4:
    return (((minx+1==maxx) && (miny+1==maxy)) ? 2 : 3) - ile_krop;
  default:
    return 3-ile_krop;
  }
}

int OszacujAktWynik(int basp[2], int &kto_pierwszy_wstawia_do_basenu,
		    unsigned char* rozgrywka, unsigned char* plansz_p, TZdobycze wynik[2],
		    int na_ruchu)
// na_ruchu ==1 albo 2 (albo -1: koniec gry)
// zwraca wynik w kropkach, dodatni: gracz 1 wygrywa, ujemny: gracz 2 wygrywa
{
  int oszacowanie = (wynik[0].zd + wynik[0].pot_zd) - (wynik[1].zd + wynik[1].pot_zd);
  int ile_wolnego, ile_wolnego_poza;
  IleWolnegoMiejsca(rozgrywka, plansz_p, ile_wolnego, ile_wolnego_poza);
  kto_pierwszy_wstawia_do_basenu = (ile_wolnego_poza & 1) ? (3-na_ruchu) : na_ruchu;
  basp[0] = 0;   basp[1] = 0;    // baseny przeliczone
  if (zasady_gry==2) {
    basp[0] = wynik[0].ss;    basp[1] = wynik[1].ss;
  }
  if (ile_wolnego==0 && ile_wolnego_poza==0)
    return oszacowanie;
  if (zasady_gry!=2) {
    unsigned char *policzone = plansze.PrzydzielPlansze();
    CzyscTablice(policzone);
    for (int i=2; i<wlkx+2; i++)
      for (int j=2; j<wlky+2; j++) {
	int ind = WezIndeksTab(i,j);
	if (!policzone[ind] && rozgrywka[ind]==0)
	  if (plansz_p[ind] & 4)
	    basp[0]+=OszacujWynik_PrzejdzBasen(policzone, rozgrywka, plansz_p, ind, 1);
	  else if (plansz_p[ind] & 8)
	    basp[1]+=OszacujWynik_PrzejdzBasen(policzone, rozgrywka, plansz_p, ind, 2);
      }
    plansze.ZwolnijPlansze(policzone);
  }
  int baseny = basp[0] - basp[1];
  if ((baseny % 2) == 0)
    oszacowanie += (baseny/2);
  else if (kto_pierwszy_wstawia_do_basenu==1)
    oszacowanie += (baseny-1)/2;
  else if (kto_pierwszy_wstawia_do_basenu==2)
    oszacowanie += (baseny+1)/2;
  else
    oszacowanie += (baseny/2);   // na wszelki wypadek
  return oszacowanie;
}

long int Bouzy(unsigned char *terytorium, unsigned char *rozgr2,
	       unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max,
	       int dilations, int erosions, int waga_Bo1, int waga_Bo2, int punkt_za_pole)
// na podstawie algorytmu Bouzy'ego do znajdowania terytorium
// zob. <ftp://www.joy.ne.jp/welcome/igs/Go/computer/bbthese.ps.Z>
// Moze byc terytorium==NULL.
{
 skrint* gotowe =skladowe.PrzydzielSkladowaI();
 skrint* robocze =skladowe.PrzydzielSkladowaI();
 CzyscTablice(gotowe);
 for (int i=up.lg; i<=up.pd; i++)
   if (rozgr2[i]==1) gotowe[i]=128;
   else if (rozgr2[i]==2) gotowe[i]=-128;
 if (marg_min.x<=2)   marg_min.x=3;
 if (marg_max.x>wlkx) marg_max.x=wlkx;
 if (marg_min.y<=2)   marg_min.y=3;
 if (marg_max.y>wlky) marg_max.y=wlky;
 for (int d=0; d<dilations; d++)
  {
  KopiujTablice(robocze, gotowe);
  if (marg_min.x>3) marg_min.x--;
  if (marg_max.x<wlkx) marg_max.x++;
  if (marg_min.y>3) marg_min.y--;
  if (marg_max.y<wlky) marg_max.y++;
  for (int i=marg_min.x; i<=marg_max.x; i++)
   {
   unsigned int indeks = WezIndeksTab(i,marg_min.y);
   for (int j=marg_min.y; j<=marg_max.y; j++) {
     if (rozgr3[indeks]==0) {
       if (gotowe[indeks]>=0 &&
	   gotowe[indeks-1]>=0 && gotowe[indeks+1]>=0 &&
	   gotowe[indeks-wlky-4]>=0 && gotowe[indeks+W_P]>=0)
	 {
	   if (gotowe[indeks-1]>0) robocze[indeks]++;
	   if (gotowe[indeks+1]>0) robocze[indeks]++;
	   if (gotowe[indeks-wlky-4]>0) robocze[indeks]++;
	   if (gotowe[indeks+W_P]>0) robocze[indeks]++;
	 }
       if (gotowe[indeks]<=0 &&
	   gotowe[indeks-1]<=0 && gotowe[indeks+1]<=0 &&
	   gotowe[indeks-wlky-4]<=0 && gotowe[indeks+W_P]<=0)
	 {
	   if (gotowe[indeks-1]<0) robocze[indeks]--;
	   if (gotowe[indeks+1]<0) robocze[indeks]--;
	   if (gotowe[indeks-wlky-4]<0) robocze[indeks]--;
	   if (gotowe[indeks+W_P]<0) robocze[indeks]--;
	 }
     }
     indeks++;
     }
   }
  { skrint *pom=gotowe;  gotowe=robocze;  robocze=pom; }
  }
 for (int e=0; e<erosions; e++)
  {
  KopiujTablice(robocze, gotowe);
  for (int i=3; i<=wlkx; i++)
   {
   unsigned int indeks = WezIndeksTab(i,3);
   for (int j=3; j<=wlky; j++)
     {
     if (rozgr3[indeks]==0)
     if (gotowe[indeks]>0)
       {
       if (//j>0 && 
	   gotowe[indeks-1]<=0) robocze[indeks]--;
       if (//j<wlky-1 && 
	   gotowe[indeks+1]<=0) robocze[indeks]--;
       if (//i>0 && 
	   gotowe[indeks-wlky-4]<=0) robocze[indeks]--;
       if (//i<wlkx-1 && 
	   gotowe[indeks+W_P]<=0) robocze[indeks]--;
       if (robocze[indeks]<0) robocze[indeks]=0;
       }
     else if (gotowe[indeks]<0)
       {
       if (//j>0 && 
	   gotowe[indeks-1]>=0) robocze[indeks]++;
       if (//j<wlky-1 && 
	   gotowe[indeks+1]>=0) robocze[indeks]++;
       if (//i>0 && 
	   gotowe[indeks-wlky-4]>=0) robocze[indeks]++;
       if (//i<wlkx-1 && 
	   gotowe[indeks+W_P]>=0) robocze[indeks]++;
       if (robocze[indeks]>0) robocze[indeks]=0;
       }
     indeks++;
     }
   }
  { skrint *pom=gotowe;  gotowe=robocze;  robocze=pom; }
  }
 // ustaw terytorium
 if (terytorium!=NULL) {
   CzyscTablice(terytorium);
   for (int i=0; i<wlkx4wlky4; i++)
     if (gotowe[i] //&& upl_marg[i]>2
	 && rozgr3[i]==0)
       terytorium[i] = (gotowe[i]>0) ? 1:2;
 }
 // oblicz punktacje
 long int ocena=0;
 if (punkt_za_pole) {
   waga_Bo2=-waga_Bo2;
   for (int i=up.lg; i<=up.pd; i++)
     if (gotowe[i] //&& upl_marg[i]>2
	 && rozgr3[i]==0)
       ocena+= (gotowe[i]>0) ? waga_Bo1:waga_Bo2;
 }
 else {
   long int ocen1=0, ocen2=0;
   for (int i=up.lg; i<=up.pd; i++)
     if (rozgr3[i]==0)
       if (gotowe[i]>0) ocen1++;
       else if (gotowe[i]<0) ocen2++;
   ocena = ocen1*waga_Bo1 - ocen2*waga_Bo2;
 }
 skladowe.ZwolnijSkladowa(gotowe);   skladowe.ZwolnijSkladowa(robocze);
 return ocena;
}



int WolnyStozek(const unsigned char *rozg, krint *obszar,
                int x, int y, int dx1, int dx2, int dy1, int dy2,
                unsigned short int kierunek)
// we: rozg, pola wewnatrz stopow ustawione na 0.
//     (x,y) -- wierzcholek stozka,
//     kierunek -- kierunek stozka,
//                 &1 - zawiera polprosta PG, &2 - LG, &4 - LD, &8 - PD,
//                 czyli maski to: gora=3, lewo=6, dol=12, prawo=9
//     dx1, dx2 -- odleglosc x od lewego i prawego marginesu
//     dy1, dy2 -- odleglosc y od gornego i dolnego marginesu
// zwraca 1 i zeruje bit 0x100 w obszarze, gdy stozek jest wolny,
// w przeciwnym razie zwraca 0 i nie zmienia obszaru
// Uwaga: bierzemy pod uwage tylko brzeg stozka!
{
 unsigned int indeks=WezIndeksTab(x,y);
 if (rozg[indeks]) return 0;   // wierzcholek jest zajety
 // sprawdz kierunek PG
 if (kierunek & 1)
   {
   int dokad = std::min(dx2, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+3;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek LG
 if (kierunek & 2)
   {
   int dokad = std::min(dx1, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+5;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek LD
 if (kierunek & 4)
   {
   int dokad = std::min(dx1, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+3;
     if (rozg[ind]) return 0;
     }
   }
 // sprawdz kierunek PD
 if (kierunek & 8)
   {
   int dokad = std::min(dx2, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+5;
     if (rozg[ind]) return 0;
     }
   }
 // stozek jest wolny -- ustaw to w obszarze
 obszar[indeks] &= ~(0x100);  // wierzcholek
 // ustaw kierunek PG
 if (kierunek & 1)
   {
   int dokad = std::min(dx2, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+3;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek LG
 if (kierunek & 2)
   {
   int dokad = std::min(dx1, dy1);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+5;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek LD
 if (kierunek & 4)
   {
   int dokad = std::min(dx1, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind -= wlky+3;
     obszar[ind] &= ~(0x100);
     }
   }
 // ustaw kierunek PD
 if (kierunek & 8)
   {
   int dokad = std::min(dx2, dy2);
   unsigned int ind = indeks;
   for (int s=1; s<=dokad; s++)
     {
     ind += wlky+5;
     obszar[ind] &= ~(0x100);
     }
   }
 return 1;
}

void ZaznaczNiecki(krint *obszar, const unsigned char *r3, int kto, int maska_kto, int maska_prz, int indeks)
{
  int przec=3-kto;
  if (r3[indeks]==kto && r3[indeks+1]==kto) {
    // szukaj niecek w poziomie
    int indn = indeks+W_P;
    while (r3[indn]==kto && r3[indn+1]==0 && r3[indn+2]!=przec)
      indn += W_P;
    if (r3[indn]==kto && r3[indn+1]==kto)
      // jest niecka!
      for (int p=indeks+wlky+5; p<indn; p+=W_P)
	obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
    // szukaj niecek w poziomie u gory
    indn = indeks+wlky+5;
    while (r3[indn]==kto && r3[indn-1]==0 && r3[indn-2]!=przec)
      indn += W_P;
    if (r3[indn]==kto && r3[indn-1]==kto) {
      // jest niecka!
      indn--;
      for (int p=indeks+W_P; p<indn; p+=W_P)
	obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
    }
    // teraz po skosie (wolne po pd lub lg stronie)
    if (r3[indeks+W_P]==kto && r3[indeks+wlky+3]==kto) {
      // prawe dolne
      if (r3[indeks+2*wlky+7]==kto && 
	  r3[indeks+wlky+5]!=przec && r3[indeks+2*wlky+8]!=przec &&
	  r3[indeks+2*wlky+9]!=przec && r3[indeks+3*wlky+11]!=przec &&
	  r3[indeks+3*wlky+12]!=przec)
	if (r3[indeks+2]!=przec && r3[indeks+wlky+6]!=przec && 
	    r3[indeks+2*wlky+10]!=przec && r3[indeks+3*wlky+13]!=przec) {
	  if (r3[indeks+wlky+5]==0) 
	    obszar[indeks+wlky+5] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2*wlky+8]==0) 
	    obszar[indeks+2*wlky+8] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2*wlky+8]==0 && r3[indeks+2*wlky+6]==kto &&
		 r3[indeks+3*wlky+10]==kto)
	  obszar[indeks+2*wlky+8] |= (maska_kto|maska_prz);   // bezsensowne dla obu
      // lewe gorne
      if (r3[indeks-wlky-3]==kto &&
	  r3[indeks-wlky-4]!=przec && r3[indeks-wlky-5]!=przec &&
	  r3[indeks-1]!=przec && r3[indeks-2]!=przec && r3[indeks+wlky+2]!=przec)
	if (r3[indeks-2*wlky-9]!=przec && r3[indeks-2*wlky-8]!=przec &&
	    r3[indeks-2*wlky-7]!=przec && r3[indeks-wlky-6]!=przec) {
	  if (r3[indeks-wlky-4]==0) 
	    obszar[indeks-wlky-4] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks-1]==0) 
	    obszar[indeks-1] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks-1]==0 && r3[indeks+2*wlky+6]==kto && 
		 r3[indeks+2*wlky+7]==kto)
	  obszar[indeks-1] |= (maska_kto|maska_prz);   // bezsensowne dla obu
    }
    // po skosie (wolne po pg lub ld stronie)
    if (r3[indeks+wlky+5]==kto && r3[indeks+wlky+6]==kto) {
      // prawe gorne
      if (r3[indeks+2*wlky+10]==kto && r3[indeks+W_P]!=przec && 
	  r3[indeks+2*wlky+8]!=przec && r3[indeks+2*wlky+9]!=przec &&
	  r3[indeks+3*wlky+13]!=przec && r3[indeks+3*wlky+14]!=przec)
	if (r3[indeks-1]!=przec && r3[indeks+wlky+3]!=przec && 
	    r3[indeks+2*wlky+7]!=przec && r3[indeks+3*wlky+12]!=przec) {
	  if (r3[indeks+W_P]==0)
	    obszar[indeks+W_P] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2*wlky+9]==0)
	    obszar[indeks+2*wlky+9] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2*wlky+9]==0 && r3[indeks+2*wlky+11]==kto &&
		 r3[indeks+3*wlky+15]==kto)
	  obszar[indeks+2*wlky+9] |= (maska_kto|maska_prz);   // bezsensowne dla obu
      // lewe dolne
      if (r3[indeks-wlky-4]==kto &&
	  r3[indeks-wlky-3]!=przec && r3[indeks-wlky-2]!=przec &&
	  r3[indeks+2]!=przec && r3[indeks+3]!=przec && r3[indeks+wlky+7]!=przec)
	if (r3[indeks-wlky-1]!=przec && r3[indeks-2*wlky-8]!=przec &&
	    r3[indeks-2*wlky-7]!=przec && r3[indeks-2*wlky-6]!=przec) {
	  if (r3[indeks-wlky-3]==0)
	    obszar[indeks-wlky-3] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	  if (r3[indeks+2]==0)
	    obszar[indeks+2] |= (maska_kto|maska_prz);   // bezsensowne dla obu
	}
	else if (r3[indeks+2]==0 && r3[indeks+2*wlky+10]==kto && 
		 r3[indeks+2*wlky+11]==kto)
		 obszar[indeks+2] |= (maska_kto|maska_prz);   // bezsensowne dla obu
    }
    // i na koniec pionowe
    if (r3[indeks-wlky-4]==kto) {
      indn = indeks+1;
      while (r3[indn]==kto && r3[indn-wlky-4]==0 && r3[indn-2*wlky-8]!=przec)
	indn++;
      if (r3[indn]==kto && r3[indn-wlky-4]==kto) {
	indn -= wlky+4;
	for (int p=indeks-wlky-3; p<indn; p++)
	  obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
      }
    }
    // i drugie pionowe
    if (r3[indeks+W_P]==kto) {
      indn = indeks+1;
      while (r3[indn]==kto && r3[indn+W_P]==0 && r3[indn+2*wlky+8]!=przec)
	indn++;
      if (r3[indn]==kto && r3[indn+W_P]==kto) {
	indn += W_P;
	for (int p=indeks+wlky+5; p<indn; p++)
	  obszar[p] |= maska_prz;   // bezsensowne dla przeciwnika!
      }
    }
  }
}

int SprAntywezeObszar(const unsigned char *r3,int kto,int przec,unsigned int ind,int wbok, int wgore)
// zwraca indeks pola bezsensownego dla przec; przec tworzy weza
// szablon:
//
//                  (itd.)
//        o o o o o o o o o o o o o o o o
//      o o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o o
//    o o o o o o o o o o o o o o
//    o o o ? o o o o o o o o o
//    o o . x o o o o o o o o
//    o . x x . o o o o o o
//    . x x . o o o o o o
//        . o o o o o o
//
// x = kropka kto,    . = kropka przec
// o oznacza puste pole lub kropke x,
// ? - tu bedzie pole bezsensowne dla przec
// Kropka x w ld rogu ma wspolrzedna [ind], wbok, wgore jak na rysunku.
// Trzy lewe dolne kropki ,,x'' sa juz sprawdzone.
{
  if (r3[ind-wbok]!=przec || r3[ind+wgore]!=przec || r3[ind+2*wgore+wbok]!=przec ||
      r3[ind+wbok-wgore]!=przec || r3[ind+2*wbok]!=przec || r3[ind+2*wbok+wgore]!=kto ||
      r3[ind+2*(wbok+wgore)]!=kto || r3[ind+3*wbok+wgore]!=przec ||
      upl_marg[ind+2*wbok+3*wgore]<2)
    return 0;
  // sprawdzaj puste pola u gory
  {
    unsigned int ind0 = ind-wbok+wgore;
    do {
      unsigned int indakt = ind0;
      for (int i=0; i<6; i++) {   // pionowe odcinki dlugosci 6
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wgore;
      }
      ind0 += wgore+wbok;
    }
    while (upl_marg[ind0]>=2);
  }
  // sprawdzaj puste pola po prawej
  {
    unsigned int ind0 = ind+2*wbok-wgore;
    for (int y=0; y<4; y++) {
      unsigned int indakt = ind0;
      int dokad = (y<3) ? 6:8;
      for (int i=0; i<dokad; i++) {   // poziome odcinki dlugosci 6 lub 8
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wbok;
      }
      ind0 += (y<2) ? (wgore+wbok) : (wgore-wbok);
    }
  }
  // sprawdzaj puste pola po prawej u gory
  {
    unsigned int ind0 = ind+2*wbok+3*wgore;
    do {
      unsigned int indakt = ind0;
      for (int i=0; i<10; i++) {   // poziome odcinki dlugosci 10
	if (upl_marg[indakt]<2) break;
	if (r3[indakt]==przec) return 0;
	indakt+=wbok;
      }
      ind0 += wgore+wbok;
    }
    while (upl_marg[ind0]>=2);
  }
  return ind+2*wbok+3*wgore;
}

void ZnajdzObszary(krint *obszar, const unsigned char *rozg, const unsigned char *r3=NULL)
// wypelnia tablice obszar, znaczenie bitow:
//  maska 0x01  -- pole w otoczce wypuklej wszystkich kropek,
//  maska 0x02  -- pole w otoczce wypuklej wszystkich kropek z marginesem 1,
//  maska 0x04  -- pole w otoczce wypuklej wszystkich kropek z marginesem 2,
//  maska 0x08  -- pole w otoczce wypuklej wszystkich kropek z marginesem 3,
//  maska 0x10, 0x20  -- pole w odleglosci 1, 2 od kropki gracza 1
//  maska 0x40, 0x80  -- pole w odleglosci 1, 2 od kropki gracza 2
//  maska 0x100 -- pole w otoczce wypuklej wszystkich kropek z wcieciami,
//  maska 0x200 -- j.w. ale dodatkowo margines na 1, ale inny (metryka typu L^1)
//  maska 0x400 -- j.w. ale margines na 2
//  maska 0x800 -- j.w. ale margines na 3
//  maska 0x1000 -- pole chwilowo bezsensowne dla gracza 1 (np. wewnatrz niecek gracza 2)
//  maska 0x2000 -- pole chwilowo bezsensowne dla gracza 2 (np. wewnatrz niecek gracza 1)
//    maska 0x3000 wypelniane tylko gdy r3!=NULL
//  maska 0x4000 -- pole blisko bandy -- interesujace np. gdy ocena promieniowania wlaczona (84.03)
//                  zaznacza tez narozniki, wiec trzeba zwracac uwage na bezsensowne
// We: plansza z rozgrywka, pola wewnatrz stopow ustawione na 0.
//     Nie zmienia tablicy rozg ani r3 (opcjonalnej).
{
 // przygotuj tablice z parametrami ciec
 struct TCiecia  { int wspx, wspy, min, max; }
   ciecia[8];
 ciecia[0].wspx=1;  ciecia[0].wspy=0;   // te dwa musza
 ciecia[1].wspx=0;  ciecia[1].wspy=1;   // byc w tej kolejnosci!
 ciecia[2].wspx=1;  ciecia[2].wspy=1;
 ciecia[3].wspx=1;  ciecia[3].wspy=-1;
 ciecia[4].wspx=1;  ciecia[4].wspy=2;
 ciecia[5].wspx=2;  ciecia[5].wspy=1;
 ciecia[6].wspx=-1; ciecia[6].wspy=2;
 ciecia[7].wspx=2;  ciecia[7].wspy=-1;
 for (int i=0; i<8; i++)
   { ciecia[i].min=INT_MAX;  ciecia[i].max=-INT_MAX; }
 // teraz znajdz miejsca ciec
 for (int i=2; i<wlkx+2; i++)
  for (int j=2; j<wlky+2; j++)
   if (WezUC(rozg,i,j))
     {
     for (int c=0; c<8; c++)
       {
       int wart = ciecia[c].wspx*i + ciecia[c].wspy*j;
       if (wart > ciecia[c].max) ciecia[c].max=wart;
       if (wart < ciecia[c].min) ciecia[c].min=wart;
       }
	  }
 // i ustaw otoczke
 CzyscTablice(obszar);
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++)
  for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
    {
    int wewnatrz=0x101;
    for (int c=2; c<8; c++)
		{
      int wart = ciecia[c].wspx*i + ciecia[c].wspy*j;
      if (wart < ciecia[c].min || wart > ciecia[c].max)
        { wewnatrz=0; break; }
      }
    WezUI(obszar,i,j) = wewnatrz;
    }
 // teraz zrob wciecia, najpierw pionowe
 {
 int ys1 = ciecia[1].min, yk1 = ciecia[1].max;
 int ys2 = ciecia[1].max, yk2 = ciecia[1].min;
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++)
  {
  // wciecia od gory:
  {
  int do_konca=1;
  for (int y=ys1; y<=yk1; y++)
    if (!WolnyStozek(rozg, obszar, i,y, i-ciecia[0].min, ciecia[0].max-i,
         y-ciecia[1].min, ciecia[1].max-y, 3))
      {
      ys1=y-1;  if (ys1<ciecia[1].min) ys1=ciecia[1].min;
      yk1=y;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    ys1=yk1;
    if (++yk1>ciecia[1].max) yk1=ciecia[1].max;
    }
  }
  // wciecia od dolu:
  {
  int do_konca=1;
  for (int y=ys2; y>=yk2; y--)
    if (!WolnyStozek(rozg, obszar, i,y, i-ciecia[0].min, ciecia[0].max-i,
         y-ciecia[1].min, ciecia[1].max-y, 12))
      {
      ys2=y+1;  if (ys2>ciecia[1].max) ys2=ciecia[1].max;
      yk2=y;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    ys2=yk2;
    if (--yk2<ciecia[1].min) yk2=ciecia[1].min;
    }
  }
  }
 }
 // teraz wciecia poziome
 {
 int xs1 = ciecia[0].min, xk1 = ciecia[0].max;
 int xs2 = ciecia[0].max, xk2 = ciecia[0].min;
 for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
  {
  // wciecia z lewej:
  {
  int do_konca=1;
  for (int x=xs1; x<=xk1; x++)
    if (!WolnyStozek(rozg, obszar, x,j, x-ciecia[0].min, ciecia[0].max-x,
         j-ciecia[1].min, ciecia[1].max-j, 6))
      {
      xs1=x-1;  if (xs1<ciecia[0].min) xs1=ciecia[0].min;
      xk1=x;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    xs1=xk1;
    if (++xk1>ciecia[0].max) xk1=ciecia[0].max;
    }
  }
  // wciecia z prawej:
  {
  int do_konca=1;
  for (int x=xs2; x>=xk2; x--)
    if (!WolnyStozek(rozg, obszar, x,j, x-ciecia[0].min, ciecia[0].max-x,
         j-ciecia[1].min, ciecia[1].max-j, 9))
      {
      xs2=x+1;  if (xs2>ciecia[0].max) xs2=ciecia[0].max;
      xk2=x;
      do_konca=0;
      break;
      }
  if (do_konca)
    {
    xs2=xk2;
    if (--xk2<ciecia[0].min) xk2=ciecia[0].min;
    }
  }
  }
 }
 // teraz ustaw otoczke z marginesem i otoczenie kropek graczy 1 i 2
 for (int i=ciecia[0].min; i<=ciecia[0].max; i++) {
  unsigned int indeks = WezIndeksTab(i,ciecia[1].min);
  for (int j=ciecia[1].min; j<=ciecia[1].max; j++)
   {
   if (r3!=NULL) {
     ZaznaczNiecki(obszar, r3, 1, 0x1000, 0x2000, indeks);
     ZaznaczNiecki(obszar, r3, 2, 0x2000, 0x1000, indeks);
     // spr. antyweze
     if (r3[indeks]) {
       int kto=r3[indeks];
       int przec=3-kto;
       int maska = (przec<<12);  // == 0x1000 lub 0x2000
       if (r3[indeks+W_P]==kto)
	 if (r3[indeks+wlky+3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,W_P,-1)] |= maska;
	 else if (r3[indeks+wlky+5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,W_P,1)] |= maska;
       if (r3[indeks-wlky-4]==kto)
	 if (r3[indeks-wlky-5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-wlky-4,-1)] |= maska;
	 else if (r3[indeks-wlky-3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-wlky-4,1)] |= maska;
       if (r3[indeks-1]==kto)
	 if (r3[indeks-wlky-5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-1,-wlky-4)] |= maska;
	 else if (r3[indeks+wlky+3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,-1,W_P)] |= maska;
       if (r3[indeks+1]==kto)
	 if (r3[indeks-wlky-3]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,1,-wlky-4)] |= maska;
	 else if (r3[indeks+wlky+5]==kto)
	   obszar[SprAntywezeObszar(r3,kto,przec,indeks,1,W_P)] |= maska;
     }
   }
   // ustaw otoczke z marginesem -- bity 0x02, 0x04, 0x08
   if (obszar[indeks] & 1)
     {
     // wez margines
     for (int dx=-3; dx<=3; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-3; dy<=3; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int maska=8;    // ustaw pole na margines 3
       if (dx!=-3 && dx!=3 && dy!=-3 && dy!=3)
         {
         maska=12;     // ustaw pole na margines 2 i 3
         if (dx!=-2 && dx!=2 && dy!=-2 && dy!=2)
           maska=14;   // ustaw pole na margines 1,2 i 3
         }
		 WezUI(obszar,i+dx,j+dy) |= maska;
       }
     }
   // ustaw otoczenie kropek graczy 1 i 2 -- najstarsze 4 bity
   int gr=rozg[indeks];
   if (gr)
     {
     // wez margines
	  for (int dx=-2; dx<=2; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-2; dy<=2; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int maska= (gr==1) ? 0x20 : 0x80;    // ustaw pole na margines 2
       if (dx!=-2 && dx!=2 && dy!=-2 && dy!=2)
         maska= (gr==1) ? 0x30 : 0xc0;    // ustaw pole na margines 1 i 2
       WezUI(obszar,i+dx,j+dy) |= maska;
       }
     }
   // ustaw margines dla otoczki z wcieciami
   if (obszar[indeks] & 0x100)
     {
     for (int dx=-3; dx<=3; dx++) if (i+dx>=2 && i+dx<=wlkx+1)
      for (int dy=-3; dy<=3; dy++) if (j+dy>=2 && j+dy<=wlky+1)
       {
       int odl = (dx<0 ? -dx:dx) + (dy<0 ? -dy:dy);
       if (odl<=1)
         WezUI(obszar,i+dx,j+dy) |= 0xe00;
       else if (odl==2)
         WezUI(obszar,i+dx,j+dy) |= 0xc00;
       else if (odl==3)
         WezUI(obszar,i+dx,j+dy) |= 0x800;
       }
     }
   indeks++;
   }
 }
 // ustaw maski dla pol blisko bandy
 for (int i=up.lg; i<=up.pd; i++)
   if (upl_marg[i]>=2 && upl_marg[i]<=4 && rozg[i]==0)
     obszar[i] |= 0x4000;
 obszar[0]=0;  // wyzeruj ew. maske 0x1000/0x2000 ustawiona przy antywezach
}

unsigned long int szabl32_banda[5][3] =
// uklad pol: np.
//   0 . 1
//   2 3 4
  { {0x00ac, 0x00b1, 0x00e2 },
    {0x005c, 0x0072, 0x00d1 },
    {0x00a0, 0x00b5, 0x00ea },
    {0x0003, 0x0037, 0x00cb },
    {0x0050, 0x0076, 0x00d9 } };

unsigned long int szabl32[8][3] =
// uklad pol: np.
//   0 1 2
//   3 . 4
//   5 6 7
  { {0xf03000, 0xf5756a, 0xfaba95 },
    {0x000cc3, 0x656deb, 0x9a9ed7 },
    {0x3cc000, 0x7de9a9, 0xbed656 },
    {0x0003f0, 0x9557fa, 0x6aabf5 },
//    {0xffffff, 0x000000, 0x000000 },  srodkowe, niepotrzebne pole
    {0x00030f, 0x59abaf, 0xa6575f },
    {0xc3c000, 0xd7d69a, 0xebe965 },
    {0x000c3c, 0x569ebe, 0xa96d7d },
    {0x0f3000, 0x5fbaa6, 0xaf7559 } };

unsigned long long szabl_chwil[16][3] = {

  /* wersja 83.35-, szabl2_chwil.cc
{0xffffb7b78403dbdULL, 0xffffcfcf4bcce77ULL, 0xf03843030c35ULL },
{0x222205050509000ULL, 0xddddfffffaf6fc6ULL, 0x5050000039ULL },
{0xffffeded210cafbULL, 0xffff3f3f1e335feULL, 0xf00c21c0c00faULL },
{0x111182828242000ULL, 0xeeeeffff7dbd3f3ULL, 0x82820000c0cULL },
{0x444428282824000ULL, 0xbbbbffffd7dbf3cULL, 0x282800000c3ULL },
{0xffffdede12c0f6eULL, 0xfffff3f3e133f9bULL, 0xf000c0120c0cf0aULL },
{0x888850505090000ULL, 0x7777ffffaf6fcf9ULL, 0x50500000306ULL },
{0xffff7b7b48307d7ULL, 0xfffffcfcb4ccbedULL, 0xf00304803033c5ULL },
{0xffffb7b78403dbdULL, 0xf03843030c35ULL, 0xffffcfcf4bcce77ULL },
{0x222205050509000ULL, 0x5050000039ULL, 0xddddfffffaf6fc6ULL },
{0xffffeded210cafbULL, 0xf00c21c0c00faULL, 0xffff3f3f1e335feULL },
{0x111182828242000ULL, 0x82820000c0cULL, 0xeeeeffff7dbd3f3ULL },
{0x444428282824000ULL, 0x282800000c3ULL, 0xbbbbffffd7dbf3cULL },
{0xffffdede12c0f6eULL, 0xf000c0120c0cf0aULL, 0xfffff3f3e133f9bULL },
{0x888850505090000ULL, 0x50500000306ULL, 0x7777ffffaf6fcf9ULL },
{0xffff7b7b48307d7ULL, 0xf00304803033c5ULL, 0xfffffcfcb4ccbedULL }};
  */

  //  wersja z szabl3_chwil_nowe, z szablonami bezs dla jednego z graczy
{0xdfb7b7ffffdbdULL, 0x7fcfcfffffe77ULL, 0xf0384000fc35ULL },
{0x9405052222000ULL, 0xfbffffddddfc6ULL, 0x5050000039ULL },
{0xbfededffffafbULL, 0xef3f3fffff5feULL, 0xf0c2100f00faULL },
{0xc882821111000ULL, 0xf7ffffeeee3f3ULL, 0x82820000c0cULL },
{0x3228284444000ULL, 0xfdffffbbbbf3cULL, 0x282800000c3ULL },
{0xefdedefffff6eULL, 0xbff3f3fffff9bULL, 0xfc012f000f0aULL },
{0x6150508888000ULL, 0xfeffff7777cf9ULL, 0x50500000306ULL },
{0x7f7b7bffff7d7ULL, 0xdffcfcffffbedULL, 0xf30480f003c5ULL },
{0xdf00b7b7ffffdbdULL, 0x7f000384000fc35ULL, 0xf00cfcfffffe77ULL },
{0x940005052222000ULL, 0xfb0005050000039ULL, 0xffffddddfc6ULL },
{0xbf00ededffffafbULL, 0xef000c2100f00faULL, 0xf003f3fffff5feULL },
{0xc80082821111000ULL, 0xf70082820000c0cULL, 0xffffeeee3f3ULL },
{0x320028284444000ULL, 0xfd00282800000c3ULL, 0xffffbbbbf3cULL },
{0xef00dedefffff6eULL, 0xbf00c012f000f0aULL, 0xf00f3f3fffff9bULL },
{0x610050508888000ULL, 0xfe0050500000306ULL, 0xffff7777cf9ULL },
{0x7f007b7bffff7d7ULL, 0xdf0030480f003c5ULL, 0xf00fcfcffffbedULL }};
unsigned long long int szabl_chwil_maski[3]= 
  {0xfffffffffffULL, 0xfffffffffffffULL, 0xff00fffffffffffULL};



int PoleBezs12(unsigned char *rozgr3, unsigned int indeks, int chwilowe, int kto=0)
// chwilowe!=0 oznacza, ze bierzemy tez pod uwage chwilowe bezsensowne
//  w tym przypadku mozna podac gracza na ruchu (kto==0 oznacza, ze nie generujemy
//  bezsensownych dla jednego z graczy)
{
  if (upl_marg[indeks]<=2) return 0;   // bierzemy pod uwage tylko pola wewnetrzne
  STOPER_START_BEZS;
  {
  unsigned long int dozwolone = szabl32[0][rozgr3[indeks-wlky-4-1]];
  dozwolone &= szabl32[1][rozgr3[indeks-1]];
  dozwolone &= szabl32[2][rozgr3[indeks+wlky+4-1]];
  dozwolone &= szabl32[6][rozgr3[indeks+1]];
  if (dozwolone) {
    dozwolone &= szabl32[3][rozgr3[indeks-wlky-4]];
    dozwolone &= szabl32[4][rozgr3[indeks+W_P]];
    dozwolone &= szabl32[5][rozgr3[indeks-wlky-4+1]];
    dozwolone &= szabl32[7][rozgr3[indeks+wlky+4+1]];
    if (dozwolone) { STOPER_STOP_BEZS; return 1; }  // jest jakis szablon
  }
  }
  if (chwilowe) {
    for (int nrs=0; nrs<=8; nrs+=8) {
      unsigned long long int dozwolone = szabl_chwil[nrs+0][rozgr3[indeks-wlky-4-1]];
      dozwolone &= szabl_chwil[nrs+1][rozgr3[indeks-1]];
      dozwolone &= szabl_chwil[nrs+2][rozgr3[indeks+wlky+4-1]];
      dozwolone &= szabl_chwil[nrs+6][rozgr3[indeks+1]];
      if (dozwolone) {
	dozwolone &= szabl_chwil[nrs+3][rozgr3[indeks-wlky-4]];
	dozwolone &= szabl_chwil[nrs+4][rozgr3[indeks+W_P]];
	dozwolone &= szabl_chwil[nrs+5][rozgr3[indeks-wlky-4+1]];
	dozwolone &= szabl_chwil[nrs+7][rozgr3[indeks+wlky+4+1]];
	if (dozwolone & szabl_chwil_maski[kto])
	  { STOPER_STOP_BEZS; return 2; }  // jest jakis szablon chwilowy
      }
    }
  }
  STOPER_STOP_BEZS;
  return 0;
}


void ZnajdzBezs12(unsigned char *bezs, unsigned char *rozgr3,
                  TDwaUC marg1_min, TDwaUC marg1_max, int chwilowe=0)
// ustawia bezs[...] != 0, gdy nie ma sensu analizowac ruchow na polu [...]
// marg1_... - marginesy z zapasem na 1 pole
// Mozliwe ulepszenia: znalezienie skladowych _na_pewno_ bezpiecznych
//  -- takich skladowych nie ma sensu znowu laczyc z banda
// chwilowe!=0 oznacza, ze szukamy tez pol chwilowo bezs. (takie ustawione na 2)
{
 CzyscTablice(bezs);
 // narozniki sa zawsze bez sensu
 WezUC(bezs,2,2)=1;        WezUC(bezs,2,wlky+1)=1;
 WezUC(bezs,wlkx+1,2)=1;   WezUC(bezs,wlkx+1,wlky+1)=1;
 // zbadaj bandy
 if (marg1_min.x<=2)
   { // lewa banda
   unsigned int indeks = WezIndeksTab(2, marg1_min.y);
   for (int j=marg1_min.y; j<=marg1_max.y; j++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-1]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+1]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks+wlky+4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks+W_P  ]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks++;
     }
   }
 if (marg1_max.x>wlkx)
   { // prawa banda
   unsigned int indeks = WezIndeksTab(wlkx+1, marg1_min.y);
   for (int j=marg1_min.y; j<=marg1_max.y; j++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-1]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+1]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks-wlky-4  ]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks-wlky-4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks++;
     }
   }
 if (marg1_min.y<=2)
   { // gorna banda
   unsigned int indeks = WezIndeksTab(marg1_min.x, 2);
   for (int i=marg1_min.x; i<=marg1_max.x; i++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-wlky-4]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+W_P]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4+1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks       +1]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4+1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks+=W_P;
     }
   }
 if (marg1_max.y>wlky)
   { // dolna banda
   unsigned int indeks = WezIndeksTab(marg1_min.x, wlky+1);
   for (int i=marg1_min.x; i<=marg1_max.x; i++)
     {
     if (rozgr3[indeks]==0)
       {  // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
       unsigned long int dozwolone = szabl32_banda[0][rozgr3[indeks-wlky-4]];
       dozwolone &= szabl32_banda[1][rozgr3[indeks+W_P]];
       dozwolone &= szabl32_banda[2][rozgr3[indeks-wlky-4-1]];
       dozwolone &= szabl32_banda[3][rozgr3[indeks       -1]];
       dozwolone &= szabl32_banda[4][rozgr3[indeks+wlky+4-1]];
       if (dozwolone)   // jest jakis szablon
         bezs[indeks]=1;
       }
     indeks+=W_P;
     }
   }
 // zbadaj wnetrze
 if (marg1_min.x<=2) marg1_min.x=3;
 if (marg1_min.y<=2) marg1_min.y=3;
 if (marg1_max.x>wlkx) marg1_max.x=wlkx;
 if (marg1_max.y>wlky) marg1_max.y=wlky;
 for (int i=marg1_min.x; i<=marg1_max.x; i++)
  {
  unsigned int indeks = WezIndeksTab(i, marg1_min.y);
  for (int j=marg1_min.y; j<=marg1_max.y; j++)
    {
    if (rozgr3[indeks]==0)
      // puste pole -- sprawdz, czy jakis szablon pozwala uznac je za bezs.
      bezs[indeks]= PoleBezs12(rozgr3, indeks, chwilowe);
    indeks++;
    }
  }
}

void Spermutuj(krint *tab, int odkad, int dokad)
// Permutuje elementy:  tab[odkad], tab[odkad+1], ..., tab[dokad-1].
{
 for (int i=dokad-1; i>odkad; i--)
   {
   int np = random(i-odkad+1) + odkad;
   // zamien [np] z [i]
   krint tmp=tab[i];
   tab[i]=tab[np];  tab[np]=tmp;
   }
}


class TCiete {
public:
  short int pion_min[max_bok_planszy+2], pion_max[max_bok_planszy+2],
            poz_min[max_bok_planszy+2] , poz_max[max_bok_planszy+2];
private:
  int zmienione_pion_min, zmienione_pion_max,zmienione_poz_min, zmienione_poz_max;
  void UaktualnijCiecieMin(short int *ct, int ost_el);
  void UaktualnijCiecieMax(short int *ct, int ost_el);
public:
  void DodajKropke(int i, int j, int okrazana);
  void DodajKropke(int ind, int okrazana=1);
  void DodajOkrKropkeZOpozn(int ind);
  void DodajKropkeZOpozn(int ind, int okrazana);
  void Zeruj();
  void RozpocznijDodawanieZOpozn();
  void UaktualnijCiecia();
  void Skopiuj(const TCiete &arg);
  };

void TCiete::Skopiuj(const TCiete &arg)
{
  memcpy(&pion_min[2], &arg.pion_min[2], sizeof(pion_min[0])*wlkx);
  memcpy(&pion_max[2], &arg.pion_max[2], sizeof(pion_max[0])*wlkx);
  memcpy(&poz_min[2], &arg.poz_min[2], sizeof(poz_min[0])*wlky);
  memcpy(&poz_max[2], &arg.poz_max[2], sizeof(poz_max[0])*wlky);
}

void DodajKropkeDoCieciaMin(short int *ct, int i, int wart, int ost_el)
{
 if (ct[i]>wart)
   {
   ct[i]=wart;
   int nwart=wart+1;
   for (int x=i-1; x>=2; x--)
     if (ct[x]>nwart) ct[x]=nwart++;
     else break;
   nwart=wart+1;
   for (int x=i+1; x<ost_el; x++)
     if (ct[x]>nwart) ct[x]=nwart++;
     else break;
   }
}

void DodajKropkeDoCieciaMax(short int *ct, int i, int wart, int ost_el)
{
 if (ct[i]<wart)
   {
   ct[i]=wart;
   int nwart=wart-1;
   for (int x=i-1; x>=2; x--)
     if (ct[x]<nwart) ct[x]=nwart--;
     else break;
   nwart=wart-1;
   for (int x=i+1; x<ost_el; x++)
     if (ct[x]<nwart) ct[x]=nwart--;
     else break;
   }
}

void TCiete::DodajKropke(int i, int j, int okrazana)
// dodaje kropke (i,j) do tablicy ciec
{
 STOPER_START_CIET;
 if (okrazana)
   {
   if (i>2 && i<=wlkx && j>2 && j<=wlky)     // jest we wnetrzu planszy
    {
    if (j>=pion_max[i])
      DodajKropkeDoCieciaMax(pion_max, i,j+1, wlkx+2);  // (nie wlky+2)
    if (j<=pion_min[i])
      DodajKropkeDoCieciaMin(pion_min, i,j-1, wlkx+2);  // tu ma byc wlkx+2 !
    if (i>=poz_max[j])
      DodajKropkeDoCieciaMax(poz_max, j,i+1, wlky+2);
    if (i<=poz_min[j])
      DodajKropkeDoCieciaMin(poz_min, j,i-1, wlky+2);
    }
   }
 else {
   if (j>pion_max[i])
     DodajKropkeDoCieciaMax(pion_max, i,j, wlkx+2);
   if (j<pion_min[i])
     DodajKropkeDoCieciaMin(pion_min, i,j, wlkx+2);
   if (i>poz_max[j])
     DodajKropkeDoCieciaMax(poz_max, j,i, wlky+2);
   if (i<poz_min[j])
     DodajKropkeDoCieciaMin(poz_min, j,i, wlky+2);
   }
 STOPER_STOP_CIET;
}

void TCiete::DodajKropke(int ind, int okrazana)
{  DodajKropke(upl_x[ind], upl_y[ind], okrazana); }

inline void TCiete::RozpocznijDodawanieZOpozn()
{ zmienione_pion_min = zmienione_pion_max = zmienione_poz_min = zmienione_poz_max =0; }

void TCiete::DodajOkrKropkeZOpozn(int ind)
// potem trzeba wywolac TCiete::UaktualnijCiecia
{
  STOPER_START_CIET;
  if (upl_marg[ind]>2) {
    int i=upl_x[ind], j=upl_y[ind];
    if (j>=pion_max[i]) { pion_max[i]=j+1; zmienione_pion_max=1; }
    if (j<=pion_min[i]) { pion_min[i]=j-1; zmienione_pion_min=1; }
    if (i>=poz_max[j])  { poz_max[j]=i+1; zmienione_poz_max=1; }
    if (i<=poz_min[j])  { poz_min[j]=i-1; zmienione_poz_min=1; }
  }
  STOPER_STOP_CIET;
}

void TCiete::DodajKropkeZOpozn(int ind, int okrazana)
// potem trzeba wywolac TCiete::UaktualnijCiecia
{
  if (okrazana) DodajOkrKropkeZOpozn(ind);
  else {
    int i=upl_x[ind], j=upl_y[ind];
    if (j>pion_max[i]) { pion_max[i]=j; zmienione_pion_max=1; }
    if (j<pion_min[i]) { pion_min[i]=j; zmienione_pion_min=1; }
    if (i>poz_max[j])  { poz_max[j]=i; zmienione_poz_max=1; }
    if (i<poz_min[j])  { poz_min[j]=i; zmienione_poz_min=1; }
  }
}

void TCiete::Zeruj()
{ 
  short int maksxy=max_bok_planszy*2+8;
  for (int i=0; i<max_bok_planszy+2; i++)
    {
      pion_min[i] = maksxy;
      pion_max[i] = -maksxy;
      poz_min[i] = maksxy;
      poz_max[i] = -maksxy;
    }
}

void TCiete::UaktualnijCiecieMin(short int *ct, int ost_el)
// zmniejsza ct tak, aby bylo wykresem f. Lipchitza o stalej 1
// ost_el == wlkx+2 lub wlky+2
{
  // przejdz w prawo
  int nwart = ct[2]+1;
  for (int i=3; i<ost_el; i++) {
    if (nwart<ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart++;
  }
  // przejdz w lewo
  nwart = ct[ost_el-1]+1;
  for (int i=ost_el-2; i>=2; i--) {
    if (nwart<ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart++;
  }
}

void TCiete::UaktualnijCiecieMax(short int *ct, int ost_el)
// zwieksza ct tak, aby bylo wykresem f. Lipchitza o stalej 1
// ost_el == wlkx+2 lub wlky+2
{
  // przejdz w prawo
  int nwart = ct[2]-1;
  for (int i=3; i<ost_el; i++) {
    if (nwart>ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart--;
  }
  // przejdz w lewo
  nwart = ct[ost_el-1]-1;
  for (int i=ost_el-2; i>=2; i--) {
    if (nwart>ct[i]) ct[i]=nwart;
    else nwart=ct[i];
    nwart--;
  }
}

void TCiete::UaktualnijCiecia()
{
  STOPER_START_CIET;
  if (zmienione_pion_max) UaktualnijCiecieMax(pion_max, wlkx+2);
  if (zmienione_pion_min) UaktualnijCiecieMin(pion_min, wlkx+2);
  if (zmienione_poz_max) UaktualnijCiecieMax(poz_max, wlky+2);
  if (zmienione_poz_min) UaktualnijCiecieMin(poz_min, wlky+2);
  STOPER_STOP_CIET;
}

long int OcenSkladowe12(unsigned char *rozgr2, unsigned char *rozgr3,
			krint *goradol,
			krint *straty_skl,
			long int *oceny_skladowych,
			unsigned int ile_sklnr,
			unsigned char *zakazane, krint *mostki_arg,
			int ktory_gracz,
			const TCiete &ciete,
			krint *dad,  //dad==dod_pola, dodajemy do tego inne kropki
			int funkcja_sk, int waga_kropki)
// we: 
//     goradol -- indeks najnizej polozonej kropki 1,2,3,... skladowej (najnizej na ekranie)
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     mostki_arg -- mostki (z ZnajdzMostki12())
//     funkcja_sk -- ==2 (stara funkcja) lub ==3 (nowa funkcja oceniajaca) 
//                   kiedys (umiejetnosci & 8)
//     Funkcja obchodzi tylko pola zaznaczone w ciete, lub takie, dla ktorych
//      (dod_pola[...] ==60002). Tablica dod_pola nazywa sie (na liscie
//     argumentow) ,,dad'' i jest niszzczona!
{
 STOPER_START_OS12;
 krint *mostki  = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 krint *mostki_stos = skladowe.PrzydzielSkladowa();
 long int ocena = 0;
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++) {
   unsigned int gora = *goradol++;
   if (gora)   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       // jesli zmieniasz 60002 na cos innego, to zmien tez Antyweze()!
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j])
             if (rozgr3[indeks]==0)
              dad[indeks]=60002; // puste pole w obszarze? -- wstawiamy 60002
             else if (rozgr2[indeks]==przec)
              dad[indeks]=60000; // kropki przeciwnika ustawiamy w dad na 60000
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // przygotuj mostki usuwajac te, ktore wskakuja na pionowa linie
     // lub przez nia przechodza; dodaj kropki z pionowej linii do kolejki
     KopiujTablice(mostki, mostki_arg);
     q4.Wyczysc();
     {
     unsigned int indm2= gora-2*wlky-8;
     unsigned int ind  = gora;
     unsigned int indp1= gora  +   wlky + 4;
     unsigned int indp2= indp1 +   wlky + 4;
     for (int j=upl_y[gora]; j<wlky+2; j++)
       {
       mostki[indm2++] &= ~(0x20c);  // zabronione mostki typu PPx
       // dodaj kropke do kolejki (oczywiscie dla j==gora.y zawsze jest dad[ind]==0)
       if (dad[ind]==60000)
         { q4.stos[1][q4.kon[1]++]=ind;   dad[ind]=ind; }
       else if (dad[ind]==60002)
         { q4.stos[3][q4.kon[3]++]=ind;   dad[ind]=ind; }
       mostki[ind++  ] &= ~(0xde1);  // zabronione mostki typu LLx (0x8c0),
                                  // Lx(0x021) oraz D,G (0x500)
       mostki[indp1++] &= ~(0x8e1);  // zabronione mostki typu LLx i Lx
       mostki[indp2++] &= ~(0x8c0);  // zabronione mostki typu LLx
       }
     }
     // obejdz skladowa
     unsigned int skad, gdzie;
     long int dlug;
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = ind_pionowa_max - wlky-4;
     int na_stosie_m = 0;
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3]) teraz++;
       if (q4.pocz[teraz & 3] == q4.kon[teraz & 3])
         { // jesli jestes tutaj, to blad!
         printf("Blad: nie udalo sie obejsc skladowej.\n");
         printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
     #ifndef TEKSTOWY
         GrKeyRead();
     #endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
         exit(1);
         }
       int indeks_qteraz   = (teraz & 3);
       int indeks_qterazp2 = ((teraz+2) & 3);
       // FAZA 1: przejdz jeden poziom bez mostkow, zapamietujac ew. mostki
       //         na osobnym stosie mostki_stos
       do
         {
         // zdejmij ze stosu
         krint pn_ind = q4.stos[indeks_qteraz][q4.pocz[indeks_qteraz]++];
         krint gdzie_ind = dad[pn_ind];   // z jakiego pola wystartowalismy
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x  == gora.x-1
           gdzie = gdzie_ind;    // gdzie.x == gora.x
           dlug=teraz-1;
           goto Obeszlismy;
           }
	 if (!(zakazane[pn_ind] & ZAKAZ_G)) {
	   // idz w gore
	   krint ind=pn_ind-1;
	   if (dad[ind]>=60000) {
	     if (dad[ind]==60000)     // jest polaczenie bezposrednie?
	       q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
	     else
	       q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
	     dad[ind]=gdzie_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_D)) {
	   // idz w dol
	   krint ind=pn_ind+1;
	   if (dad[ind]>=60000) {
	     if (dad[ind]==60000)     // jest polaczenie bezposrednie?
	       q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
	     else
	       q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
	     dad[ind]=gdzie_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_L)) {
	   // idz w lewo
	   krint ind=pn_ind-wlky-4;
	   if (dad[ind]>=60000)
	     {
	       if (dad[ind]==60000)     // jest polaczenie bezposrednie?
		 q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
	       else
		 q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
	       dad[ind]=gdzie_ind;
	     }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         Idz_tylko_w_prawo:;
	 if (!(zakazane[pn_ind] & ZAKAZ_P)) {
	   // idz w prawo
	   krint ind=pn_ind+W_P;
	   if (dad[ind]>=60000)
	     {
	       if (dad[ind]==60000)     // jest polaczenie bezposrednie?
		 q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
	       else
		 q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
	       dad[ind]=gdzie_ind;
	     }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
           if (dad[ind]>=60000)
             {
             if (dad[ind]==60000)     // jest polaczenie bezposrednie?
               q4.stos[indeks_qteraz][--q4.pocz[indeks_qteraz]] = ind;
             else
               q4.stos[indeks_qterazp2][--q4.pocz[indeks_qterazp2]] = ind;
             dad[ind]=gdzie_ind;
             }
           }
         // sprawdz, czy sa jakies mostki do analizy w FAZIE 2
         if (mostki[pn_ind])
           {
           // (tu mozna sprawdzic, czy np. sa 3 mostki pod rzad lub 2 zle pod rzad)
           // W tej chwili to ciezko (w dad jest pole startu, a nie ostatnio
           // odwiedzone), ale to mozna osiagnac szybciej w FAZIE 2 -- przechodzac
           // mostek poziomy mozna zerowac flage dopuszczajaca taki mostek w polu,
           // na ktore skaczemy -- to pozwoli uniknac ,,2 zlych pod rzad''.
           // Wykrycie 3 pod rzad wymagaloby juz chyba pamietania informacji
           // w dodatkowej tablicy, ale to tez chyba lepiej robic w FAZIE 2.
           mostki_stos[na_stosie_m++]=pn_ind;
           }
         }
       while (q4.pocz[indeks_qteraz] < q4.kon[indeks_qteraz]);
       // wyczysc aktualny stos i wez nastepny priorytet
       q4.pocz[indeks_qteraz] = q4.kon[indeks_qteraz] = max_powierzchnia_planszy;
       teraz++;
       // FAZA 2 -- przejdz ewentualne mostki
       while (na_stosie_m)
         {
         unsigned int indeks = mostki_stos[--na_stosie_m];
         krint gdzie_ind = dad[indeks];   // z jakiego pola wystartowalismy
         krint  maska = 1;
         for (int m=0; m<12; m++)
           {
           if (mostki[indeks] & maska)
             {
             unsigned int ind = indeks + most12.dind[m];
             if (dad[ind]>=60000)   // pole jeszcze nie odwiedzone
               {
               dad[ind]=gdzie_ind;
               q4.stos[teraz & 3][q4.kon[teraz & 3]++] = ind;
               }
             }
           maska<<=1;
           }
         }
       }
     }
     Obeszlismy:;
     // moze mamy zabronione miejsce (anty-waz)?
     if (skad == gdzie-wlky-4 -1)
       {
       if (zakazane[skad] & ZAKAZ_PD) dlug+=2;
       }
     else if (skad == gdzie-wlky-4 +1)
       {
       if (zakazane[skad] & ZAKAZ_PG) dlug+=2;
       }
     else
       {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       skad+= W_P;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug+=2;
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug+=2;
       }
     // ocen skladowa
     {
     long int straty=straty_skl[kolejnaskl];
     if ((funkcja_sk==3) && straty==waga_kropki)
       {
       static long int oceny_1[9] =  {-34,-23,-17,-13,-11,-9,-6,-4,-2};
       // to stare wartosci dla waga_kropki==5: {-169,-113,-85,-67,-54,-44,-30,-20,-10};
       // stand. wsp. to {-169,-113,-85,-67,-54,-44,-37,-30,-25} (dla waga_kropki==5)
       if (dlug<9)
         ocena += oceny_skladowych[kolejnaskl] = straty*oceny_1[dlug];
       else
         ocena += oceny_skladowych[kolejnaskl] = -2*straty;
       }
     else
       {
       dlug <<= 1;
       ocena += oceny_skladowych[kolejnaskl] =
                dlug - straty - 4 - (straty << 7) / (dlug+4);
       }
     }
     }
   else oceny_skladowych[kolejnaskl] = 0;  // bezpieczna skladowa
   }
 skladowe.ZwolnijSkladowa(mostki);
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(mostki_stos);
 STOPER_STOP_OS12;
 return ocena;
}

inline long int OcenSkladowaBM(long int straty, int dlug, int funkcja_sk)
{
  if (funkcja_sk==4) {
    const int mnozniki[13] = {64,58,46,40,34,  27,22,17,13,10,  8,6,5}; 
    int skm = (dlug<13) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
    return (dlug<<2) - straty - 4 - skm; 
  }
  else {
    const int mnozniki[13] = {80,62,52,44,37,  31,25,20,15,11,  8,6,5};
    int skm = (dlug<13) ? ((straty*mnozniki[dlug])) : ((straty<<7) / (2*dlug+1));  // bylo << 6 i moze wtedy lepiej gral... (?)
    return (dlug<<2) - straty - 4 - (skm >> 1);   // TUTAJ skm>>1 !!
  }
}

long int OcenSkladoweBM(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			long int *oceny_skladowych,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
// UWAGA: oceny_skladowych[0..ile_sklnr-1] powinny byc ustawione na INT_MAX
//  lub na wlasciwa ocene
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 long int ocena = 0;
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if (gora) {   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
    if (oceny_skladowych[kolejnaskl]==INT_MAX) 
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      {
	      dad[indeks] = dad_tab[kary[indeks]];
//             if (rozgr3[indeks]==0)
//              assert(dad[indeks]==60001+kary[indeks]); // puste pole w obszarze? -- wstawiamy 60001,2,3
//             else if (rozgr2[indeks]==przec)
//              assert(dad[indeks]==60000); // kropki przeciwnika ustawiamy w dad na 60000
//	     else assert(dad[indeks]==0);
	      }
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     //     for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
     for (int ind=ind_pionowa_max; ind>ind_pionowa_min; ind--)  // 83.18
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   int nrt = dad[ind]-60000;
	   stos[nrt]++; *stos[nrt]=ind; q4.kon[nrt]++;  
	   dad[ind]=ind; 
	 }
     // obejdz skladowa
     unsigned int skad, gdzie;
     long int dlug=0;
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = WezIndeksTab(upl_x[gora]-1, wlky+1);
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) goto Znaleziony_najmn;
	 }
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
         krint gdzie_ind = dad[pn_ind];   // z jakiego pola wystartowalismy
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x==gora.x-1
           gdzie = gdzie_ind;    // gdzie.x==gora.x
           // dlug jest juz ustawione
           goto Obeszlismy;
           }
	 if (!(zakazane[pn_ind] & ZAKAZ_G)) {
	   // idz w gore
	   krint ind=pn_ind-1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_D)) {
	   // idz w dol
	   krint ind=pn_ind+1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_L)) {
	   // idz w lewo
	   krint ind=pn_ind-wlky-4;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
           }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
           }
         Idz_tylko_w_prawo:;
	 if (!(zakazane[pn_ind] & ZAKAZ_P)) {
	   // idz w prawo
	   krint ind=pn_ind+W_P;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	   }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind;
	     }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=gdzie_ind; 
	     }
           }
         }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       skad+=W_P;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug++;
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug++;
     }
     // ocen skladowa
     {
       //     const int mnozniki[18] = {64,52,46,40,35,  30,26,22,19,16,  14,12,10,8,7,  6,5,4};
       //     int skm = (dlug<18) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
     const int mnozniki[13] = {64,58,46,40,34,  27,22,17,13,10,  8,6,5}; 
     long int straty=straty_skl[kolejnaskl];
     int skm = (dlug<13) ? ((straty*mnozniki[dlug]) >> 1) : ((straty<<5) / dlug);
     oceny_skladowych[kolejnaskl] =
       (dlug<<2) - straty - 4 - skm;  //(straty << 6) / (dlug+2);
     }
     }
    ocena += oceny_skladowych[kolejnaskl];
   }
   else oceny_skladowych[kolejnaskl]=0;  // bezpieczna
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 STOPER_STOP_OS12;
 return ocena;
}

void OcenSkladoweBMsciezki(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			       krint *dlugosci, krint *sciezki,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 unsigned char przec = 3-ktory_gracz;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 CzyscTablice(sciezki);
 int maska=0x8000;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if ((maska<<=1)==0x10000) maska=1;
   if (gora)   // gora==0 oznacza skladowa bezpieczna (kolo bandy)
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      {
	      dad[indeks] = dad_tab[kary[indeks]];
//             if (rozgr3[indeks]==0)
//              assert(dad[indeks]==60001+kary[indeks]); // puste pole w obszarze? -- wstawiamy 60001,2,3
//             else if (rozgr2[indeks]==przec)
//              assert(dad[indeks]==60000); // kropki przeciwnika ustawiamy w dad na 60000
//	     else assert(dad[indeks]==0);
	      }
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     //for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
     for (int ind=ind_pionowa_max; ind>ind_pionowa_min; ind--)  // 83.18
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   int nrt = dad[ind]-60000;
	   stos[nrt]++; *stos[nrt]=ind; q4.kon[nrt]++;  
	   dad[ind]=ind; 
	 }
     // obejdz skladowa
     unsigned int skad;
     long int dlug=0;
     {
     krint ind_miejsce_min = gora-wlky-4;
     krint ind_miejsce_max = WezIndeksTab(upl_x[gora]-1, wlky+1);
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) goto Znaleziony_najmn;
	 }
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
         if (pn_ind <= ind_pionowa_max && pn_ind>=ind_pionowa_min)
           { // jestesmy na pionowej linii -- mozna isc tylko w prawo
           goto Idz_tylko_w_prawo;
           }
         else if (pn_ind <= ind_miejsce_max && pn_ind>=ind_miejsce_min)
           {  // doszlismy na miejsce
           skad = pn_ind;        // skad.x==gora.x-1
           // dlug jest juz ustawione
           goto Obeszlismy;
           }
	 if (!(zakazane[pn_ind] & ZAKAZ_G)) {
	   // idz w gore
	   krint ind=pn_ind-1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_D)) {
	   // idz w dol
	   krint ind=pn_ind+1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
           }
         }
	 if (!(zakazane[pn_ind] & ZAKAZ_L)) {
	   // idz w lewo
	   krint ind=pn_ind-wlky-4;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
           }
         }
         // idz na ukos
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
           }
         Idz_tylko_w_prawo:;
	 if (!(zakazane[pn_ind] & ZAKAZ_P)) {
	   // idz w prawo
	   krint ind=pn_ind+wlky+4;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	   }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     }
           }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind; 
	     }
           }
         }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     {  // moze trzeba dodac dlugosc kawalka linii pionowej?
       int gdzie=skad;
       do {
	 sciezki[gdzie] |= maska;
	 gdzie = dad[gdzie];
       } while (gdzie != dad[gdzie]);
       sciezki[gdzie] |= maska;
       skad+=W_P;
       for (int j=gdzie-1; j>skad; j--)
         if (rozgr2[j] !=przec) dlug++;   // tego nie dodawaj do sciezki
       for (int j=gdzie+1; j<skad; j++)
         if (rozgr2[j] !=przec) dlug++;
     }
     // zapamietaj dlugosc
     dlugosci[kolejnaskl] = dlug;
     }
   else dlugosci[kolejnaskl] = 0;  // bezpieczna skladowa
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 STOPER_STOP_OS12;
}


class TObieg {
  // katy sa ustawione w sposob naturalny (nie tak jak dla wsp. ekranowych),
  // nie jest to zreszta istotne (wplywa tylko na znak)
  short int katy[2*max_bok_planszy-1][2*max_bok_planszy-1];
  int biegunx, bieguny;
  struct TPoleOb {
    int x,y;   // tutaj short int to za malo (chyba ze dalej bedzie konwersja na int w mnozeniu)
    float tg;
  };
  void PosortujPola(TPoleOb*, int, int);
public:
  short int pelny_obrot, polowa_obrotu;
  TObieg();
  void UstawBiegun(int b);
  short int ZmianaKierunku(int ind0, int ind1);
} obieg;

TObieg::TObieg()
{
  for (int i=0; i<max_bok_planszy; i++)
    katy[max_bok_planszy-1+i][max_bok_planszy-1]=0;   // ustaw biegun i prawa polprosta
  TPoleOb *pola = new TPoleOb[(max_bok_planszy-1)*(max_bok_planszy-1)];
  int ilepol=0;
  for (int i=1; i<max_bok_planszy; i++)
    for (int j=1; j<max_bok_planszy; j++) {
      pola[ilepol].x = max_bok_planszy-1 +i;
      pola[ilepol].y = max_bok_planszy-1 +j;
      pola[ilepol].tg= float(i) / float(j);
      ilepol++;
    }
  // posortuj pola rosnaco ze wzgledu na .tg
  PosortujPola(pola, 0, ilepol-1);
  // ustawiaj kierunki
  int kier=1;  
  katy[pola[0].x][pola[0].y]=1;   // pierwsze pole ustaw recznie
  for (int i=1; i<ilepol; i++) {
    if (pola[i].x*pola[i-1].y != pola[i-1].x*pola[i].y)  // zmienil sie kierunek
      kier++;
    katy[pola[i].x][pola[i].y]=kier;
  }
  kier++;
  delete[] pola;
  // pozostale 3 cwiartki ustaw przez obroty
  for (int i=1; i<max_bok_planszy; i++)
    for (int j=0; j<max_bok_planszy; j++) {
      short int kat1 = katy[max_bok_planszy-1 +i][max_bok_planszy-1 +j];
      katy[max_bok_planszy-1 -j][max_bok_planszy-1 +i] = kat1 + kier;
      katy[max_bok_planszy-1 -i][max_bok_planszy-1 -j] = kat1 + 2*kier;
      katy[max_bok_planszy-1 +j][max_bok_planszy-1 -i] = kat1 + 3*kier;
    }
  polowa_obrotu = 2*kier;
  pelny_obrot   = 4*kier;
}

void TObieg::PosortujPola(TPoleOb* tab, int l, int r)
// sortuje tab[l],...,tab[p]  (rekurencyjne QuickSort ze stosem max. const*log(r-l))
{
  int i,j;
 Sortuj:;
  i=l, j=r;
  TPoleOb x = tab[(l+r)/2];
  do {
    while (tab[i].tg<x.tg) i++;
    while (x.tg<tab[j].tg) j--;
    if (i<=j) {
      TPoleOb tmp = tab[i];
      tab[i] = tab[j];
      tab[j] = tmp;
      i++;  j--;
    }
  } while (i<=j);
  if (j-l<r-i) {
    if (l<j) PosortujPola(tab, l,j);
    if (i<r) {  // posortuj (i,r)
      l=i; 
      goto Sortuj;
    }
  }
  else {
    if (i<r) PosortujPola(tab, i,r);
    if (l<j) {  // posortuj (l,j)
      r=j;
      goto Sortuj;
    }
  }
}  

void TObieg::UstawBiegun(int b)
{  biegunx=upl_x[b];  bieguny=upl_y[b]; }

short int TObieg::ZmianaKierunku(int ind0, int ind1)
// zmiana kierunku przy przejsciu z pola [ind0] na pole [ind1];
// biegun musi byc wczesniej ustawiony funkcja UstawBiegun()
{
  int wsp0x = upl_x[ind0] - biegunx;
  int wsp1x = upl_x[ind1] - biegunx;
  int wsp0y = upl_y[ind0] - bieguny;
  int wsp1y = upl_y[ind1] - bieguny;
  if (wsp0y+wsp1y!=-1 || wsp0x+wsp1x<=0)
    return katy[max_bok_planszy-1 + wsp1x][max_bok_planszy-1 + wsp1y] -
        katy[max_bok_planszy-1 + wsp0x][max_bok_planszy-1 + wsp0y];
  // jedna z kropek jest na prawej polprostej, a druga ponizej
  if (wsp0y<0)  // tutaj wsp1y=0 oraz wsp1x>0, wiec kierunek1 = 0
    return pelny_obrot - katy[max_bok_planszy-1 + wsp0x][max_bok_planszy-1 + wsp0y];
  // tutaj wsp0y=0 oraz wsp0x>0, wiec kierunek0 = 0
  return katy[max_bok_planszy-1 + wsp1x][max_bok_planszy-1 + wsp1y] - pelny_obrot;
}


long int OcenSkladoweBMkaty(const unsigned char *rozgr2, const unsigned char *rozgr3,
			const krint *goradol,
			const krint *straty_skl,
			       long int *oceny_skladowych,
			       krint *dlugosci, krint *sciezki,
			unsigned int ile_sklnr,
			const unsigned char *zakazane, 
			int ktory_gracz,
			const TCiete &ciete,
			const unsigned char *kary)
// we: goradol -- najwyzej, najnizej polozona kropka 1,2,3,... skladowej
//     ile_sklnr -- ile jest skladowych nierozerwalnych
//     rozgr2, rozgr3 -- plansze z rozgrywka (puste/wlasciciela wewn. stopow)
//     zakazane   -- zakazane kierunki (z UstawZakazane())
//     kary       -- z UstawKaryBM()
//     Funkcja obchodzi tylko pola zaznaczone w ciete.
// UWAGA: oceny_skladowych[0..ile_sklnr-1] powinny byc ustawione na INT_MAX
//  lub na wlasciwa ocene
// Moze byc oceny_skladowych==NULL albo (dlugosci==sciezki==NULL)  (wersja uniwersalna)
// Wersja ,,katy'' uzywa nowej klasy TObieg do badania, czy obeszlismy lancuch kropek
// dookola (83.28).
{
 STOPER_START_OS12;
 krint *dad     = skladowe.PrzydzielSkladowa();
 krint *dad_zap = skladowe.PrzydzielSkladowa();
 krint *dlug_sc = skladowe.PrzydzielSkladowa();   // dlugosc sciezki
 skrint *katy   = skladowe.PrzydzielSkladowaI();
 unsigned char przec = 3-ktory_gracz;
 long int ocena = 0;
 int juz_jest_dad=0;
 krint dad_tab[6] = {60001,60002,60003,60000,60001,0};
 if (sciezki) CzyscTablice(sciezki);
 int maska=0x8000;
 for (int kolejnaskl=0; kolejnaskl<ile_sklnr; kolejnaskl++)
   {
   unsigned int gora = *goradol++;
   if ((maska<<=1)==0x10000) maska=1;
   if (gora) {  // gora==0 oznacza skladowa bezpieczna (kolo bandy)
    if (oceny_skladowych==NULL || oceny_skladowych[kolejnaskl]==INT_MAX) 
     {
     // wstaw kropki do dad
     if (!juz_jest_dad)
       {
       CzyscTablice(dad);
       for (int i=2; i<wlkx+2; i++)
        {
        signed int j=ciete.pion_min[i];
        if (j<=ciete.pion_max[i])
          {
          unsigned int indeks = WezIndeksTab(i,j);
          do
            {
            if (i>=ciete.poz_min[j] && i<=ciete.poz_max[j]) // && dod_pola[indeks]==0)
	      dad[indeks] = dad_tab[kary[indeks]];
            j++;  indeks++;
            }
          while (j<=ciete.pion_max[i]);
          }
        }
       if (kolejnaskl<ile_sklnr-1)
         { juz_jest_dad=1; KopiujTablice(dad_zap, dad); }
       }
     else KopiujTablice(dad, dad_zap);
     // dad ustawione...
     krint *stos[4];
     for (int i=0; i<4; i++) {
       stos[i] = &q4.stos[i][max_powierzchnia_planszy];
       q4.kon[i] = 0;  // oznacza, ze stos pusty
     }
     krint ind_pionowa_min = gora;
     krint ind_pionowa_max = WezIndeksTab(upl_x[gora], wlky+1);
     int dlug_pocz_kropki;
     for (int ind=ind_pionowa_min+1; ind<=ind_pionowa_max; ind++)
       // dodaj kropke do kolejki
       if (dad[ind]>=60000)
         { 
	   // moze lepiej dodac nastepna kropke?
	   if (dad[ind+1]>=60000 && dad[ind+1]+2<=dad[ind]) ind++;
	   dlug_pocz_kropki = dad[ind]-60000;
	   stos[0]++; *stos[0]=ind; q4.kon[0]++;  
	   dad[ind]=ind;
	   katy[ind]=0;
	   dlug_sc[ind]=0;
	   break;   // TYLKO JEDNA KROPKE dodajemy!
	 }
     // obejdz skladowa
     obieg.UstawBiegun(gora);
     unsigned int pole1, pole2;
     long int dlug=0, dlug_zap=50000;   // 50000 = max. dlug
     {
     int teraz=1;
     for (;;)
       {
       // znajdz najmniejszy priorytet (czyli akt. poziom)
       if (q4.kon[0]==0) {
	 // przesuwaj stosy w dol do 3 razy...
	 for (int it=0; it<3; it++) {
	   krint *pom = stos[0];
	   for (int j=0; j<3; j++) {
	     stos[j]   = stos[j+1];
	     q4.kon[j] = q4.kon[j+1];
	   }
	   stos[3]=pom;
	   q4.kon[3]=0;
	   dlug++;
	   if (q4.kon[0]) 
	     if (2*dlug<dlug_zap)    // czy jeszcze trzeba obchodzic?
	       goto Znaleziony_najmn;   // tak, moze znajdzie sie jakas krotsza sciezka
	     else goto Obeszlismy;   // nie
	 }
	 if (dlug_zap<50000) goto Obeszlismy;
	 // jesli jestes tutaj, to blad!
	 printf("Blad: nie udalo sie obejsc skladowej.\n");
	 printf("ile_sklnr=%d, kolejnaskl=%d", int(ile_sklnr), int(kolejnaskl));
#ifndef TEKSTOWY
	 GrKeyRead();
#endif
	 strcpy(pargry.nz1, "krblads.z");
	 gra.ObsluzZdarzenie(ZD_ZAPIS);
	 exit(1);
       }
       Znaleziony_najmn:;
       //  przejdz jeden poziom
       do
         {
         // zdejmij ze stosu
         krint pn_ind = *stos[0];  stos[0]--; q4.kon[0]--;
	 skrint akt_kat = katy[pn_ind];
	 if (!(zakazane[pn_ind] & ZAKAZ_D)) {
	   // idz w dol
	   krint ind=pn_ind+1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
	 }
         if (!(zakazane[pn_ind] & ZAKAZ_LD))
           {
           // idz w lewo dol
           krint ind=pn_ind-wlky-4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_PD))
           {
           // idz w prawo dol
           krint ind=pn_ind+wlky+4 +1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
	       && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
	 if (!(zakazane[pn_ind] & ZAKAZ_L)) {
	   // idz w lewo
	   krint ind=pn_ind-wlky-4;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
	 }
	 if (!(zakazane[pn_ind] & ZAKAZ_P)) {
	   // idz w prawo
	   krint ind=pn_ind+W_P;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	   }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
	 }
	 if (!(zakazane[pn_ind] & ZAKAZ_G)) {
	   // idz w gore
	   krint ind=pn_ind-1;
	   if (dad[ind]>=60000) {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
           }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
	   }
         }
         if (!(zakazane[pn_ind] & ZAKAZ_PG))
           {
           // idz w prawo gore
           krint ind=pn_ind+wlky+4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
         if (!(zakazane[pn_ind] & ZAKAZ_LG))
           {
           // idz w lewo gore
           krint ind=pn_ind-wlky-4 -1;
	   if (dad[ind]>=60000)
	     {
	     int nrt = dad[ind]-60000;
	     stos[nrt]++;  *stos[nrt]=ind;  q4.kon[nrt]++;  
	     dad[ind]=pn_ind;
	     dlug_sc[ind]=dlug+nrt;
	     katy[ind]=akt_kat + obieg.ZmianaKierunku(pn_ind, ind);
	     }
	   else if (dad[ind]) {  // pole juz bylo odwiedzone - sprawdz skad
	     int roznica = akt_kat - katy[ind];
	     if ((roznica>obieg.polowa_obrotu || roznica < -obieg.polowa_obrotu)
		 && dlug + dlug_sc[ind] < dlug_zap) {
	       dlug_zap = dlug + dlug_sc[ind];
	       pole1 = ind;  pole2 = pn_ind;
	     }
           }
	   }
	 }
       while (q4.kon[0]);
       }
     }
     Obeszlismy:;
     // mozna by bylo sprawdzic, czy nie ma samoprzeciec... (pomijamy na razie)
     // (...)
     dlug = dlug_zap + dlug_pocz_kropki;
     if (sciezki) {
       // zaznacz sciezke
       do {
	 sciezki[pole1] |= maska;
	 pole1 = dad[pole1];
       } while (pole1 != dad[pole1]);
       sciezki[pole1] |= maska;
       do {
	 sciezki[pole2] |= maska;
	 pole2 = dad[pole2];
       } while (pole2 != dad[pole2]);
       // sciezki[pole2] |= maska;   // to juz niepotrzebne
       // zapamietaj dlugosc
       dlugosci[kolejnaskl] = dlug;
     }
     // ocen skladowa
     if (oceny_skladowych) {
       const int mnozniki[13] = {80,62,52,44,37,  31,25,20,15,11,  8,6,5};
       long int straty=straty_skl[kolejnaskl];
       int skm = (dlug<13) ? ((straty*mnozniki[dlug])) : ((straty<<7) / (2*dlug+1));   // bylo << 6
       oceny_skladowych[kolejnaskl] =
	 (dlug<<2) - straty - 4 - (skm >> 1);
     }
     }
    if (oceny_skladowych) ocena += oceny_skladowych[kolejnaskl];
   }
   else { 
     if (oceny_skladowych) oceny_skladowych[kolejnaskl]=0;  // bezpieczna
     if (dlugosci) dlugosci[kolejnaskl] = 0;  // bezpieczna skladowa
   }
   }
 skladowe.ZwolnijSkladowa(dad_zap);
 skladowe.ZwolnijSkladowa(dad);
 skladowe.ZwolnijSkladowa(dlug_sc);
 skladowe.ZwolnijSkladowa(katy);
 STOPER_STOP_OS12;
 return ocena;
}



struct TGrozby {
  // listy: (na (wlkx*wlky*2)/3 pol -- chyba tyle wystarczy, pewnie mniej)
  krint *lista;
  krint *zdobycze; // liczba zamykanych kropek
  unsigned long *id;   // klucz Zobrista zamykanych kropek
  unsigned char *czy;   // &1: czy grozba ,,singularna'', tj. z tylko jednym ruchem obronny
         // &2: czy grozba jest zawarta w innej (jesli tak, to ruch przec. tu bez sensu)
         //     UWAGA: ruch moze byc sensowny, jesli cos zamyka (tego nie sprawdzamy)
         // &4: czy grozba bez kropek (tylko brzuszek)
  int ile, ile_sing;
  int ile_ze_zd;   // ile grozb ze zdobyczami (nie brzuszki)
  int sa_odlegle;
  // skladowa:
  krint *zawarte;  // (skladowa) te pola sa zawarte w zamykanych przez grozby panstwach
  void DodajGrozby(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3,
		   unsigned char *plansz_p, krint *stare_skl, krint *skl, unsigned int ind);
  void SprawdzOdpPrzec(unsigned char *rozgrywka, unsigned char *rozgr3,
		       unsigned char *plansz_p, unsigned int ind);
  void UstawSing();
  TGrozby() { ile=0; ile_sing=0; };
private:
  void SprKandNaGrozbe(unsigned char *rozgrywka, unsigned char *rozgr3,
		       unsigned char *plansz_p, krint *skl, unsigned int ind, int indsrodka, int kto);
  int PrzejdzWnetrzeZobr(unsigned char *rozgrywka, unsigned char *plansz_p,
			 unsigned char *plan, unsigned int ind, int kto, 
			 unsigned long &zobr, int zazn_na, int &puste);
};
  
void TGrozby::DodajGrozby(unsigned char *rozgrywka, unsigned char *rozgr2, unsigned char *rozgr3,
			  unsigned char *plansz_p,
			  krint *stare_skl, krint *skl, unsigned int ind)
// [ind] to swiezo postawiona kropka gracz, ktorego grozb szukamy
// skl: skladowe po ostatnim ruchu (na polu [ind]), stare_skl: przed tym ruchem
// (rozgr3 oznacza zawsze rozgr3)
{
  STOPER_START_GROZ;
  ile=0;
  int kto = rozgrywka[ind];
  sa_odlegle=0;
  for (int i=0; i<8; i++) zawarte[ind+up.dind[i]]=0;
  zawarte[ind]=0;
  // sprawdz najpierw odlegle grozby
  int ile_skl=0;        // ile skladowych polaczyl ostatni ruch
  krint numery_ps[4];   // numery polaczonych ostatnim ruchem skladowych
  for (int i=0; i<8; i++) {
    unsigned int nind = ind+up.dind[i];
    if (skl[nind]==skl[ind]) {
      // dodaj stare_skl[nind] do zapamietanych numerow
      for (int s=0; s<ile_skl; s++)
	if (numery_ps[s]==stare_skl[nind])
	  goto Juz_jest_numer;
      numery_ps[ile_skl++] = stare_skl[nind];
    Juz_jest_numer:;
    }
  }
  if (ile_skl>=2) {     // tylko wtedy mozliwe odlegle grozby
    for (int i=2; i<=wlkx+1; i++) {
      unsigned int indg = WezIndeksTab(i,2);
      for (int j=2; j<=wlky+1; j++) {
	if (PustePole(rozgrywka, plansz_p,
		      rozgr3, indg) &&  // jest wolne pole, nie w sasiedztwie [ind]
	    (indg < ind+W_LG || indg > ind+W_PD ||
	     (indg>ind+W_LD && indg<ind+W_G ) ||
	     (indg>ind+W_D  && indg<ind+W_PG))) {
	  // sprawdz, czy sa polaczone skladowe obok pola [indg]
	  int stan=0;
	  for (int p=0; p<8; p++) {
	    unsigned int nind = indg + up.dind[p];
	    if (stare_skl[nind]==numery_ps[0]) stan|=1;
	    else if (stare_skl[nind]==numery_ps[1]) stan|=2;
	    else if (ile_skl>=3 && stare_skl[nind]==numery_ps[2]) stan|=4;
	    else if (ile_skl>=4 && stare_skl[nind]==numery_ps[3]) stan|=8;
	  }
	  if (stan==3 || (stan>=5 && stan!=8))  // sa dwie polaczone skladowe
	    SprKandNaGrozbe(rozgrywka, rozgr3, plansz_p, skl, indg, -1, kto);
	}
	indg++;
      }
    }
  }
  // a teraz sasiedzkie
  for (int i=0; i<8; i++) {
    int nind = ind + up.dind[i];
    if (PustePole(rozgrywka, plansz_p, rozgr3, nind) && upl_marg[nind]>=2 &&
	CzyMozliwyStop(skl, rozgr2, upl_x[nind], upl_y[nind], kto))
      SprKandNaGrozbe(rozgrywka, rozgr3, plansz_p, skl, nind, ind, kto);
  }
  STOPER_STOP_GROZ;
}

void TGrozby::UstawSing()
{
  STOPER_START_GROZ;
  // nie sa singularne grozby, dla ktorych istnieja gorsze grozby (gorsze, tzn. zamykajace
  // te same kropki + pewne dodatkowe)
  for (int i=0; i<ile; i++)
    if ((czy[i] & 4)==0     // nie szukaj wsrod grozb-brzuszkow
	&& zawarte[lista[i]])
      czy[i]=2;   // nie singularne (&1==0), ruch bezsensowny (&2==2)
  // a teraz sprawdz ,,rowne'' grozby (sprawdzenie powyzej nie wystarczy - jedna grozba zawsze zostanie!)
  for (int i=0; i<ile-1; i++)
    if (czy[i] & 1) // czy singularna?
      // sprawdz, czy aktualna grozba wystepuje tez pozniej
      for (int j=i+1; j<ile; j++)
	if (id[j]==id[i]) {
	  // jesli tak, to (prawdopodobnie) nie jest singularna
	  czy[i] &= ~1;
	  czy[j] &= ~1;
	}
  STOPER_STOP_GROZ;
}

int TGrozby::PrzejdzWnetrzeZobr(unsigned char *rozgrywka, unsigned char *plansz_p,
				unsigned char *plan, unsigned int ind, int kto, 
				unsigned long &zobr, int zazn_na,
				int &puste)
// zwraca liczbe zdobytych kropek, jesli jest stop (dla gracza kto)
// kropki wewnetrzne zostaja ustawione na ,,zazn_na'',
//   brzegowe -- niezaznaczone
// W zobr zwraca kod Zobrista zamknietych kropek.
// W puste zwraca ew. liczbe pustych pol w srodku, gdy brzuszek.
// Nie nalezy czyscic tablicy plan!
{
 STOPER_START_GROZ;
 krint* stos =skladowe.PrzydzielSkladowa();
 stos[0]=ind;
 plan[ind]=zazn_na;   // zaznacz jako wnetrze
 int na_stosie=1;
 int zdob = 0;
 puste= 0;
 zobr = 0;
 int przec = 3-kto;
 int maska = kto*0x11;   // wewnatrz stopu lub potencjalnego stopu gracza [kto]
 do{
   ind = stos[--na_stosie];
   if ((plansz_p[ind] & maska)==0)
     if (rozgrywka[ind]==przec) {
       // kropka przec nie wewnatrz naszego (potencjalnego) stopu
       zdob++;
       zobr ^= zobrist[ind];
     }
     else if (rozgrywka[ind]==0)
       puste++;    // moze bedzie brzuszek
   // idz na boki
   for (int k=0; k<4; k++)
     {
     unsigned int nind = ind + up.dind[k];
     if (rozgrywka[nind]==kto && (plansz_p[nind] & 3)==0)
       { // kropka brzegowa -- ale nic nie robimy...
       }
     else if (plan[nind]==0)
       {  // pole wewnatrz ew. stopu
       if (upl_marg[nind]<=2)
         {  // jestesmy na brzegu planszy, czyli stopu jednak nie ma
         skladowe.ZwolnijSkladowa(stos);
	 puste=0;
	 STOPER_STOP_GROZ;
         return 0;
         }
       stos[na_stosie++]=nind;
       plan[nind]=zazn_na;  // zaznacz jako wewnetrzne
       }
     else if (plan[nind]!=zazn_na)  // bylismy tu wczesniej, czyli stopu nie bedzie!
       {
         skladowe.ZwolnijSkladowa(stos);
	 puste=0;
	 STOPER_STOP_GROZ;
         return 0;
       }
     }
   }
 while (na_stosie);
 skladowe.ZwolnijSkladowa(stos);
 STOPER_STOP_GROZ;
 return zdob;
}

void TGrozby::SprKandNaGrozbe(unsigned char *rozgrywka, unsigned char *rozgr3,
			      unsigned char *plansz_p, krint *skl, 
			      unsigned int ind, int indsrodka, int kto)
// ind: potencjalna grozba
// indsrodka == -1 oznacza odlegla grozbe, w przeciwnym razie indsrodka wskazuje
//  wczesniej postawiona kropke gracza, ktorego grozb szukamy
// (rozgr3 oznacza zawsze rozgr3)
{
  STOPER_START_GROZ;
  unsigned char *plan = plansze.PrzydzielPlansze();
  CzyscTablice(plan);
  int zdob=0;
  unsigned long kod = 0;
  unsigned char zap_r3 = rozgr3[ind];
  rozgrywka[ind] = rozgr3[ind] = kto;
  // przechodz wolne pola
  unsigned char przec = 3-kto;
  int zaznaczone[5] = {0,0,0,0,0};
  int stop=0;
  for (int s=0; s<4; s++) {
    int nind = ind + up.dind[s];
    int zd;
    unsigned long zobr;
    int puste;
    if (plan[nind]==0 && 
	rozgrywka[nind]!=kto  /* && (plansz_p[nind] & 3)==0  - chyba niepotrzebne,
            bo kolo pola [nind] z potencjalna grozba nie moze byc pola wewn stopu */
        // stare wersje:
	//(rozgr3[nind]==przec || PustePole(rozgrywka, plansz_p, rozgr3, nind)) //rozgr3[nind]!=kto
	&& upl_marg[nind]>=3) {                                      // nieodwiedzone wolne pole
      if (zd = PrzejdzWnetrzeZobr(rozgrywka, plansz_p,
				  plan,  nind, kto, zobr, s+1, puste)) {
	zaznaczone[s+1]=1;
	zdob += zd;
	kod ^= zobr;
      }
      else stop+=puste;
    }
  }
  if (zdob) {
    if (ile==0 && indsrodka==-1) {
      CzyscTablice(zawarte);
      sa_odlegle=1;
    }
    lista[ile]    = ind;
    zdobycze[ile] = zdob;
    id[ile]       = kod;
    czy[ile]=1;         // tymczasowo...
    ile++;  ile_ze_zd++;
    // dodaj zamkniete pola do zawartych
    if (sa_odlegle) {
      // mozna by optymalizowac w przypadku indsrodka!=-1:
      // wtedy wystarczy sprawdzic pola na lista[0..ile-1] oraz sasiadow [indsrodka]
      for (int i=2; i<=wlkx+1; i++) {  // wystarczy margines odp.
	unsigned int nind = WezIndeksTab(i, 2);
	for (int j=2; j<=wlky+1; j++) {  // wystarczy margines odp.
	  if (zaznaczone[plan[nind]])
	    zawarte[nind]=1;
	  nind++;
	}
      }
    }
    else {
      // sprawdzaj tylko pola sasiednie do [indsrodka]
      for (int i=0; i<8; i++)
	if (zaznaczone[plan[indsrodka + up.dind[i]]])
	  zawarte[indsrodka + up.dind[i]]=1;
    }
  }
  else if (stop) {
    // dodaj grozbe brzuszka
    lista[ile]    = ind;
    zdobycze[ile] = stop;
    id[ile]       = 0;
    czy[ile]=4;        // tylko brzuszek
    ile++;
  }
  rozgrywka[ind] = 0;     // odtworz
  rozgr3[ind]    = zap_r3;
  plansze.ZwolnijPlansze(plan);
  STOPER_STOP_GROZ;
}

void TGrozby::SprawdzOdpPrzec(unsigned char *rozgrywka, unsigned char *rozgr3,
			      unsigned char *plansz_p, unsigned int ind)
// [ind] to swiezo postawiona kropka przeciwnika gracza, ktorego grozby sprawdzamy
// sprawdza, ktore grozby sa (byc moze) singularne
// Najpierw nalezy wywolac UstawSing()!
// (rozgr3 oznacza zawsze rozgr3)
{
  STOPER_START_GROZ;
  unsigned char *r=NULL, *pp=NULL;
  int kto;
  for (int i=0; i<ile; i++)
    if ((czy[i] & 1) && lista[i]!=ind) {  // czy singularna && ...
      if (rozgr3[lista[i]] == 0)  // mozna zagrac?
	{
	  if (r==NULL) {
	    r  = plansze.PrzydzielPlansze();
	    pp = plansze.PrzydzielPlansze();
	    kto= 3-rozgrywka[ind];
	  }
	  KopiujTablice(r, rozgrywka);
	  KopiujTablice(pp,plansz_p);
	  int ile_zd,pow,pow2,pss;
	  TZdobycze wynik[2];  TZobrist zobr;
	  ZrobPanstwo(r, NULL, NULL, NULL, pp, upl_x[lista[i]], upl_y[lista[i]],
		      kto, wynik, zobr, ile_zd,pow,pow2,pss);
	  if (ile_zd==0) czy[i] &= ~1;  // nie jest singularna
	}
      else czy[i] &= ~1;   // miejsce na nasza grozbe zostalo zamkniete => nie jest singul.
    }
  if (r!=NULL) { plansze.ZwolnijPlansze(r);    plansze.ZwolnijPlansze(pp);  }
  STOPER_STOP_GROZ;
}


void Antyweze(unsigned char *zakazane, krint *dod_pola,
              unsigned char *rozgr3, int kto,
              TDwaUC marg0_min, TDwaUC marg0_max)
// kto       -- dla kogo antyweze,
// marg0_... -- wsp. prostokata zawierajacego wszystkie kropki
// wy: uaktualnia zakazane i ustawia dod_pola
{
 STOPER_START_AW;
 unsigned char przec=3-kto;
 for (int i=marg0_min.x; i<=marg0_max.x; i++)
   {
   unsigned int indeks = WezIndeksTab(i, marg0_min.y);
   for (int j=marg0_min.y; j<=marg0_max.y; j++)
     {
     if (rozgr3[indeks]==przec)
       {
       if (rozgr3[indeks-1]==kto)
         { // mozliwe szablony:
         //       0 . ?             ? . 0
         //  (a)  0 x x        (b)  x x 0
         //       0 0 .             . 0 0
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         if (rozgr3[indeks+1]==0)
           {
           unsigned int ind_l = indeks-wlky-4;
           unsigned int ind_p = indeks+W_P;
           if (rozgr3[ind_l]==0)
             { // szablon (a) ??
             if (rozgr3[ind_l-1]==0 && rozgr3[ind_l+1]==0 &&
                 rozgr3[ind_p]==przec && rozgr3[ind_p+1]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_LG;
               zakazane[ind_l   ] |= ZAKAZ_PD;
               dod_pola[ind_l+1]=60002;
               }
             }
           else  // szablon (b) ??
             if (rozgr3[ind_l]==przec && rozgr3[ind_l+1]==kto &&
                 rozgr3[ind_p]==0 && rozgr3[ind_p-1]==0 && rozgr3[ind_p+1]==0)
               {
               zakazane[indeks+1] |= ZAKAZ_PG;
               zakazane[ind_p   ] |= ZAKAZ_LD;
               dod_pola[ind_p+1]=60002;
               }
           }
         }
       else if (rozgr3[indeks-1]==przec)
         { // mozliwe szablony:
         //       ? x .             . x ?
         //  (c)  . x 0        (d)  0 x .
         //       0 0 0             0 0 0
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+W_P;
         if (rozgr3[indeks+1]==0 && rozgr3[ind_l+1]==0 && rozgr3[ind_p+1]==0)
           {
           if (rozgr3[ind_l]==kto)
             { // szablon (c) ??
             if (rozgr3[ind_p]==0 && rozgr3[ind_p-1]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_PG;
               zakazane[ind_p   ] |= ZAKAZ_LD;
               dod_pola[ind_p+1]=60002;
               }
             }
           else  // szablon (d) ??
             if (rozgr3[ind_l]==0 && rozgr3[ind_l-1]==kto && rozgr3[ind_p]==kto)
               {
               zakazane[indeks+1] |= ZAKAZ_LG;
               zakazane[ind_l   ] |= ZAKAZ_PD;
               dod_pola[ind_l+1]=60002;
               }
           }
         }
       else if (rozgr3[indeks+1]==przec)  // tutaj rozgr3[indeks-1]==0
         { // mozliwe szablony:
         //       0 0 0             0 0 0
         //  (e)  . x 0        (f)  0 x .
         //       ? x .             . x ?
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+W_P;
         if (rozgr3[indeks-1]==0 && rozgr3[ind_l-1]==0 && rozgr3[ind_p-1]==0)
           {
           if (rozgr3[ind_l]==kto)
             { // szablon (e) ??
             if (rozgr3[ind_p]==0 && rozgr3[ind_p+1]==kto)
               {
               zakazane[indeks-1] |= ZAKAZ_PD;
               zakazane[ind_p   ] |= ZAKAZ_LG;
               dod_pola[ind_p-1]=60002;
               }
             }
           else  // szablon (f) ??
             if (rozgr3[ind_l]==0 && rozgr3[ind_l+1]==kto && rozgr3[ind_p]==kto)
               {
               zakazane[indeks-1] |= ZAKAZ_LD;
               zakazane[ind_l   ] |= ZAKAZ_PG;
               dod_pola[ind_l-1]=60002;
               }
           }
         }
       else if (rozgr3[indeks+1]==kto)  // tutaj rozgr3[indeks-1]==0
         { // mozliwe szablony:
         //       . 0 0             0 0 .
         //  (g)  x x 0        (h)  0 x x
         //       ? . 0             0 . ?
         // (x = kropka przec, . = kropka kto, 0 = puste, ? =cokolwiek)
         unsigned int ind_l = indeks-wlky-4;
         unsigned int ind_p = indeks+W_P;
         if (rozgr3[ind_l]==przec)
           { // szablon (g) ??
           if (rozgr3[ind_l-1]==kto &&
               rozgr3[ind_p]==0 && rozgr3[ind_p-1]==0 && rozgr3[ind_p+1]==0)
             {
             zakazane[indeks-1] |= ZAKAZ_PD;
             zakazane[ind_p   ] |= ZAKAZ_LG;
             dod_pola[ind_p-1]=60002;
             }
           }
         else  // szablon (h) ??
           if (rozgr3[ind_l]==0 && rozgr3[ind_p-1]==kto &&
               rozgr3[ind_l-1]==0 && rozgr3[ind_l+1]==0)
             {
             zakazane[indeks-1] |= ZAKAZ_LD;
             zakazane[ind_l   ] |= ZAKAZ_PG;
             dod_pola[ind_l-1]=60002;
             }
         }
       }
     indeks++;
     }
   }
 STOPER_STOP_AW;
}

/****************************************************************************/
struct TBanda {
  unsigned char *b, *wbezp[2];
  unsigned char btab[max_bok_planszy], wbezptab[2][max_bok_planszy];
  int ind0, wdol, wbok;   // nazwy jak dla lewej bandy; ind0 zawsze jest naroznikiem, ustawiane na zewnatrz
  int dlug;               // ==wlkx dla poziomej, ==wlky dla pionowej bandy
  static int tab_bezp[2][11+5], tab_nast_aktb[2][11+5];   // wystarczy 11, +5 dla wyrownania
  static int tab_wynik[14];
  void Ustaw(const unsigned char *r3);
  void DodajKropke(const TBanda &pop, int od_gory, int od_boku, int czyja);
  void UstawWewnBezp();   // ustawia wbezp[][] na podstawie b[]
  void UstawWnetrzeBandy(unsigned char *bezpieczne, const unsigned char *r3);
  int  UstawJesliZmienione(const unsigned char *r3, const TBanda &pop);
  void Kopiuj(const TBanda &pop);
  void KopiujBezpieczne(unsigned char *nbezp, const unsigned char *sbezp);
};

int TBanda::tab_bezp[2][16] = {{3,3,0,0, 4,4,0,0, 0,0,0,  0,0,0,0,0}, {3,0,3,0, 0,0,0,0, 4,0,4,  0,0,0,0,0}};
// stara wersja, dajaca bledne wyniki:
// int TBanda::tab_nast_aktb[2][16] = {{2,1,0,0, 1,1,0,0, 0,2,0,  0,0,0,0,0}, {2,0,1,0, 0,0,2,0, 1,0,1,  0,0,0,0,0}};
// nowa wersja (83.27+)
int TBanda::tab_nast_aktb[2][16] = {{3,1,0,0, 2,2,0,0, 0,0,0,  0,0,0,0,0}, {3,0,1,0, 0,0,0,0, 2,0,2,  0,0,0,0,0}};
int TBanda::tab_wynik[14] = {0,0,0,1,2, 2,2,2,2,2, 2,2,2,2 };

void TBanda::Ustaw(const unsigned char *r3)
{
  b = btab;
  int ind = ind0;
  for (int i=0; i<dlug; i++) {
    b[i] = (r3[ind] << 2) | r3[ind+wbok];
    ind += wdol;
  }
  UstawWewnBezp();
}

int TBanda::UstawJesliZmienione(const unsigned char *r3, const TBanda &pop)
{
  b = btab;
  int ind = ind0, zmienione=0;
  for (int i=0; i<dlug; i++) {
    b[i] = (r3[ind] << 2) | r3[ind+wbok];
    if (b[i]!=pop.b[i]) zmienione=1;
    ind += wdol;
  }
  if (zmienione) UstawWewnBezp();
  else {
    wbezp[0] = pop.wbezp[0];
    wbezp[1] = pop.wbezp[1];
  }
  return zmienione;
}

void TBanda::DodajKropke(const TBanda &pop, int od_gory, int od_boku, int czyja)
{
  switch (od_boku) {
  case 0:
    b=btab;
    for (int i=0; i<dlug; i++) b[i]=pop.b[i];
    b[od_gory] &= ~0xc;
    b[od_gory] |= (czyja << 2);
    UstawWewnBezp();
    break;
  case 1:
    b=btab;
    for (int i=0; i<dlug; i++) b[i]=pop.b[i];
    b[od_gory] &= ~3;
    b[od_gory] |= czyja;
    UstawWewnBezp();
    break;
  default:
    b=pop.b;
    wbezp[0]=pop.wbezp[0];    wbezp[1]=pop.wbezp[1];
    break;
  }
}

void TBanda::UstawWewnBezp()
// ustawia wbezp[][] na podstawie b[]
{
  for (int g=0; g<2; g++) {
    wbezp[g] = wbezptab[g];
    int p=2-g;
    { // idz w dol
      if ((b[0] & 3)==g+1) wbezp[g][0]=4;  // bezpieczne;   & 3 == obok bandy
      int pierwszy =1, akt_bezp = ((b[0] & 3) != p);
      for (int i=1; i<dlug-1; i++) {
	if (b[i]==(g?6:9))
	  { wbezp[g][i] = akt_bezp ? (2+pierwszy):0;     pierwszy=0; }
	else
	  wbezp[g][i] = ((b[i] & 3)==p) ? 0 : (tab_bezp[g][b[i]] + akt_bezp);
	switch (tab_nast_aktb[g][b[i]]) {
	case 0: akt_bezp=0; break;
	case 1: akt_bezp=1; pierwszy=0; break;
	case 2: akt_bezp=1; pierwszy=1; break;
	case 3: break;  // bez zmian
	}
      }
    }
    { // idz w gore
      if ((b[dlug-1] & 3)==g+1) wbezp[g][dlug-1]=4;  // bezpieczne
      int pierwszy =1, akt_bezp = ((b[dlug-1] & 3) != p);
      for (int i=dlug-2; i>=1; i--) {
	if ((b[i] & 3)!=p)
	  if (b[i]==(g?6:9))
	    { wbezp[g][i] += akt_bezp ? (2+pierwszy):0;     pierwszy=0; }
	  else
	    wbezp[g][i] += akt_bezp;  
	switch (tab_nast_aktb[g][b[i]]) {
	case 0: akt_bezp=0; break;
	case 1: akt_bezp=1; pierwszy=0; break;
	case 2: akt_bezp=1; pierwszy=1; break;
	case 3: break;  // bez zmian
	}
      }
    }
  }
}

void TBanda::UstawWnetrzeBandy(unsigned char *bezpieczne, const unsigned char *r3)
{
  int ind = ind0 + 2*wdol;
  for (int i=2; i<dlug-2; i++) {
    bezpieczne[ind] = r3[ind] ? 2:0;
    bezpieczne[ind+wbok] = r3[ind+wbok] ? tab_wynik[wbezp[r3[ind+wbok]-1][i]] : 0;
    ind += wdol;
  }
}
  
void TBanda::Kopiuj(const TBanda &pop)
{
  b=pop.b;    wbezp[0]=pop.wbezp[0];    wbezp[1]=pop.wbezp[1];
}

void TBanda::KopiujBezpieczne(unsigned char *nbezp, const unsigned char *sbezp)
{
  int ind=ind0;
  for (int i=0; i<dlug; i++) {
    nbezp[ind] = sbezp[ind];       nbezp[ind+wbok] = sbezp[ind+wbok];
    ind+=wdol;
  }
}

class TBandy {
  TBanda lewa,prawa,gora,dol;
  unsigned char *tab_bezp;
  void UstawLGrog(unsigned char *bezp, const unsigned char *r3);
  void UstawPGrog(unsigned char *bezp, const unsigned char *r3);
  void UstawLDrog(unsigned char *bezp, const unsigned char *r3);
  void UstawPDrog(unsigned char *bezp, const unsigned char *r3);
public:
  unsigned char *bezpieczne;
  void Inicjuj();
  void Zwolnij();
  void Kopiuj(const TBandy &pop);
  void UaktualnijBezpieczne(const TBandy &pop, const unsigned char *r3, int indeks, int czy_stop);
  void UstawBezpieczne(const unsigned char *r3);
};

void TBandy::Inicjuj()
{
  bezpieczne = tab_bezp = plansze.PrzydzielPlansze();
  CzyscTablice(tab_bezp);
  lewa.ind0 = WezIndeksTab(2,2);        lewa.wdol = 1;       lewa.wbok = W_P;    lewa.dlug = wlky;
  prawa.ind0 = WezIndeksTab(wlkx+1,2);  prawa.wdol = 1;      prawa.wbok = -wlky-4;  prawa.dlug = wlky;
  gora.ind0 = WezIndeksTab(2,2);        gora.wdol = W_P;  gora.wbok = 1;         gora.dlug = wlkx;
  dol.ind0 = WezIndeksTab(2,wlky+1);    dol.wdol = W_P;   dol.wbok = -1;         dol.dlug = wlkx;
}

void TBandy::Zwolnij()
{
  plansze.ZwolnijPlansze(tab_bezp);
}

void TBandy::UstawLGrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(2,2);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog+W_P]=r3[rog+W_P] ? 2:0;
  bezp[rog+1]=r3[rog+1] ? 2:0;
  rog+=wlky+5;
  if (r3[rog]) {
    int b = std::max(lewa.wbezp[r3[rog]-1][1] , gora.wbezp[r3[rog]-1][1]);
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawPGrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(wlkx+1,2);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog-wlky-4]=r3[rog-wlky-4] ? 2:0;
  bezp[rog+1]=r3[rog+1] ? 2:0;
  rog-=wlky+3;
  if (r3[rog]) {
    int b = std::max(prawa.wbezp[r3[rog]-1][1], gora.wbezp[r3[rog]-1][wlkx-2]);
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawLDrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(2,wlky+1);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog+W_P]=r3[rog+W_P] ? 2:0;
  bezp[rog-1]=r3[rog-1] ? 2:0;
  rog+=wlky+3;
  if (r3[rog]) {
    int b = std::max(dol.wbezp[r3[rog]-1][1], lewa.wbezp[r3[rog]-1][wlky-2]);
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UstawPDrog(unsigned char *bezp, const unsigned char *r3)
{
  int rog = WezIndeksTab(wlkx+1,wlky+1);
  bezp[rog]=r3[rog] ? 2:0;
  bezp[rog-wlky-4]=r3[rog-wlky-4] ? 2:0;
  bezp[rog-1]=r3[rog-1] ? 2:0;
  rog-=wlky+5;
  if (r3[rog]) {
    int b = std::max(dol.wbezp[r3[rog]-1][wlkx-2], prawa.wbezp[r3[rog]-1][wlky-2]);
    bezp[rog] = (b>=3) + (b>3);
  }
  else bezp[rog]=0;
}

void TBandy::UaktualnijBezpieczne(const TBandy &pop, const unsigned char *r3, int indeks, int czy_stop)
{
  if (czy_stop) {
    int zmienione;
    zmienione  = lewa.UstawJesliZmienione(r3, pop.lewa);
    zmienione |= prawa.UstawJesliZmienione(r3, pop.prawa);
    zmienione |= gora.UstawJesliZmienione(r3, pop.gora);
    zmienione |= dol.UstawJesliZmienione(r3, pop.dol);
    if (zmienione) {
      bezpieczne = tab_bezp;
      lewa.UstawWnetrzeBandy(bezpieczne, r3);  prawa.UstawWnetrzeBandy(bezpieczne, r3);
      gora.UstawWnetrzeBandy(bezpieczne, r3);  dol.UstawWnetrzeBandy(bezpieczne, r3);
      UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
      UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
    }
    else bezpieczne = pop.bezpieczne;
  }
  else if (upl_marg[indeks]<=3) {
   bezpieczne = tab_bezp;
   if (upl_x[indeks]<=3) {
     lewa.DodajKropke(pop.lewa, upl_y[indeks]-2, upl_x[indeks]-2, r3[indeks]);
     prawa.Kopiuj(pop.prawa);
   }
   else if (upl_x[indeks]>=wlkx) {
     prawa.DodajKropke(pop.prawa, upl_y[indeks]-2, wlkx+1-upl_x[indeks], r3[indeks]);
     lewa.Kopiuj(pop.lewa);
   }
   else {
     prawa.Kopiuj(pop.prawa);
     lewa.Kopiuj(pop.lewa);
   }
   if (upl_y[indeks]<=3) {
     gora.DodajKropke(pop.gora, upl_x[indeks]-2, upl_y[indeks]-2, r3[indeks]);
     dol.Kopiuj(pop.dol);
   }
   else if (upl_y[indeks]>=wlky) {
     dol.DodajKropke(pop.dol, upl_x[indeks]-2, wlky+1-upl_y[indeks], r3[indeks]);
     gora.Kopiuj(pop.gora);
   }
   else {
     dol.Kopiuj(pop.dol);
     gora.Kopiuj(pop.gora);
   }
   // teraz ustaw bezpieczne - wnetrza band
   if (upl_x[indeks]<=3) {
     lewa.UstawWnetrzeBandy(bezpieczne, r3);
     prawa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else if (upl_x[indeks]>=wlkx) {
     prawa.UstawWnetrzeBandy(bezpieczne, r3);
     lewa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else {
     prawa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
     lewa.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   if (upl_y[indeks]<=3) {
     gora.UstawWnetrzeBandy(bezpieczne, r3);
     dol.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else if (upl_y[indeks]>=wlky) {
     dol.UstawWnetrzeBandy(bezpieczne, r3);
     gora.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   else {
     dol.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
     gora.KopiujBezpieczne(bezpieczne, pop.bezpieczne);
   }
   // ustawianie naroznikow jest szybkie, nie warto juz chyba sprawdzac, ktore sie mogly zmienic
   UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
   UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
  }
  else // nic sie nie zmienilo
    Kopiuj(pop);
}

void TBandy::Kopiuj(const TBandy &pop)
{
  bezpieczne = pop.bezpieczne;
  lewa.Kopiuj(pop.lewa);
  prawa.Kopiuj(pop.prawa);
  gora.Kopiuj(pop.gora);
  dol.Kopiuj(pop.dol);
}

void TBandy::UstawBezpieczne(const unsigned char *r3)
{
  bezpieczne = tab_bezp;
  lewa.Ustaw(r3);  prawa.Ustaw(r3);  gora.Ustaw(r3);  dol.Ustaw(r3);
  lewa.UstawWnetrzeBandy(bezpieczne, r3);  prawa.UstawWnetrzeBandy(bezpieczne, r3);
  gora.UstawWnetrzeBandy(bezpieczne, r3);  dol.UstawWnetrzeBandy(bezpieczne, r3);
  UstawLGrog(bezpieczne, r3);              UstawPGrog(bezpieczne, r3);  
  UstawLDrog(bezpieczne, r3);              UstawPDrog(bezpieczne, r3);
}



/******************************************************************************************/
struct TZapisR23pp {
  unsigned char r[3];
  krint  i;
};

struct TAnaliza {
  unsigned char *rozgr2, *rozgr3, *plansz_p;
  krint         *skl_tab, *lista_ruchow;
  long int      *oceny_ht;            // oceny pobrane z htablicy (==INT_MAX: brak)
  krint         *propoz[2];           // propoz[...][ind]: najlepsze 2 kontynuacje po wykonaniu ruchu [ind]
  unsigned char *rodzaj_oc_ht;        // rodzaj oceny (1,0,2: oszacowanie dolne, dokladna, osz. gorne)
  int           byl_przeglad_ht;
  int           x,y;                  // wspolrzedne
  unsigned int  indeks;               //    ruchu
  int           stopy0, stopy1;       // poczatek i koniec listy stopow-wykonanych
  int           ktory_teraz;          // kto na ruchu
  int           nr_ruchu, ost_ruch;   // ruchy na liscie ruchow
  int           pocz_ruch;            // nr_ruchu=pocz_ruch,...,ost_ruch-1
  long int      zyski, straty;        // zyski = waga*zyski_k+zyski_ss, podobnie straty
  int           ile_kr_zd_teraz;      // ile kropek zdobylismy w _tym_ ruchu
  TZdobycze     zdobycze[2];          // bezwzgledne zdobycze (od pocz gry, [0] dla gracza 1)
  long int      ocena;                // ocena ruchu          <- gdy brak oceny
  long int      alfa,beta,alfapocz;   // do ciec alfa-beta (alfapocz wydaje sie niepotrzebne...)
  int           byl_stop;             // =1 gdy po drodze byl stop
  int           jest_stop_sstop;      // =1 gdy teraz byl (staly) stop
  TZobrist      htab_zobr;
  //  unsigned long htab_zobrist;
  //  unsigned long long htab_zobrist2;
  unsigned char *tab_r2, *tab_r3;     // tablice na rozgr2, rozgr3
  unsigned char *tab_pp;              // tablica na plansz_p
  TDwaUC        marg0_min, marg0_max;
  krint         *lista_ruchow_pelna, *lista_ruchow_lisc; // wskazniki do latwego
  int           ile_ruchow_pelna, ile_ruchow_lisc;         // przelaczania miedzy listami ruchow
  krint         maska_lisc, maska_upr, maska_pelna;           // maska do schemat_ruchow[]
  krint         najlepszyr;   // najlepsza kontynuacja
  TCiete        ciete[2];             // ciete obszary
  long long int historia_waga;        // te wartosc dodajemy do historii, gdy ruch daje ciecie beta
  int           ile_zagrozen;
  krint         *zagrozenia;
  TGrozby       grozby;
  int           sex_limit, sex_limit_podw;
  int           ost_gleb;
  struct TSasiedzi {
    krint parz[20], niep[20], lisc[8];
    int ile_p, ile_n, ile_lisc;
    static unsigned char* tab_sas;
    unsigned int antywaz;
    krint odblokowuja[10];
    } sasiedzi;
  TRobaki robaki[2];
  TBandy  bandy;     // do badania, ktore kropki bezpieczne
// statyczne pola
  static long long int historia[(max_bok_planszy+4)*(max_bok_planszy+4)];
  static long long int historia_max;
  static unsigned short int historia_sort[(max_bok_planszy+4)*(max_bok_planszy+4)];
  static unsigned char *bezp_na_zawsze;      // kropki na zawsze bezpieczne
  static krint* stopy_wykonane;   // dla zasad gry==2  (ale tez =0,1 teraz, bo robimy reczne stopy!)
  // symetrie:
  static int sa_symetrie;
  static unsigned char* symetrie;
  // stoper:
  static TStoper czas;
  static int     czas_przekr;
  static TGraczO gracz;
  // zapisywanie/odtwarzanie rozgr2, rozgr3, plansz_p
  struct TZapisR23pp zapis;
  // wyswietlanie:
#ifndef TEKSTOWY
  int ost_gleb_max;
#endif
  // metody
  void InicjujCiecia(unsigned char*);
  void UstawBezpNaZawsze();
  void UstawLancuchyWplanszp();   // 83.30+
  void DodajBezsensowne(unsigned char *schemat_ruchow);
  void ZapiszRozgr23pp(unsigned int ind);
  void OdtworzRozgr23pp() const;
  void ZapiszRozgr23pp(TZapisR23pp &zap, unsigned int ind);
  void OdtworzRozgr23pp(TZapisR23pp &zap) const;
  }
  ang[MAX_GLEB_ANALIZY+2];

int TAnaliza::czas_przekr;        
TGraczO TAnaliza::gracz;          
TStoper TAnaliza::czas;           
unsigned char* TAnaliza::TSasiedzi::tab_sas;
long long int TAnaliza::historia_max;
long long int TAnaliza::historia[];
unsigned short int TAnaliza::historia_sort[];
unsigned char* TAnaliza::bezp_na_zawsze;
krint* TAnaliza::stopy_wykonane;
int TAnaliza::sa_symetrie;
unsigned char* TAnaliza::symetrie;


void TAnaliza::ZapiszRozgr23pp(unsigned int ind)
{
  zapis.r[0] = rozgr2[ind];
  zapis.r[1] = rozgr3[ind];
  zapis.r[2] = plansz_p[ind];
  zapis.i    = ind;
}

void TAnaliza::OdtworzRozgr23pp() const
{
  rozgr2[zapis.i] = zapis.r[0];
  rozgr3[zapis.i] = zapis.r[1];
  plansz_p[zapis.i] = zapis.r[2];
}

void TAnaliza::ZapiszRozgr23pp(TZapisR23pp &zap, unsigned int ind)
{
  zap.r[0] = rozgr2[ind];
  zap.r[1] = rozgr3[ind];
  zap.r[2] = plansz_p[ind];
  zap.i    = ind;
}

void TAnaliza::OdtworzRozgr23pp(TZapisR23pp &zap) const
{
  rozgr2[zap.i] = zap.r[0];
  rozgr3[zap.i] = zap.r[1];
  plansz_p[zap.i] = zap.r[2];
}

/*
class TTestSasiadow {
  krint *ruchy, *ruchy_p;
  int ile_r, ile_r_p;
public:
  void Inicjacja();
  void Sprawdz(unsigned char *schemat_ruchow, int akt, int ost);
  void Koniec();
} test_sasiadow;
void TTestSasiadow::Inicjacja()
{
  ruchy=skladowe.PrzydzielSkladowa();
  ruchy_p=skladowe.PrzydzielSkladowa();
  ile_r   = ang[1].ost_ruch - ang[1].pocz_ruch;
  ile_r_p = ang[2].ost_ruch - ang[2].pocz_ruch;
  for (int i=0; i<ile_r; i++)
    ruchy[i] = ang[1].lista_ruchow[ ang[1].pocz_ruch+i ];
  for (int i=0; i<ile_r_p; i++)
    ruchy_p[i] = ang[2].lista_ruchow[ ang[2].pocz_ruch+i ];
}
void TTestSasiadow::Sprawdz(unsigned char *schemat_ruchow, int akt, int ost)
  // wywolywane z wypelnionym ang[akt].lista_ruchow
{
  int blad=0;
  if (ang[1].ost_ruch - ang[1].pocz_ruch !=ile_r)
    { ekran.WyswietlNapis("Inna liczba ruchow"); blad=1; }
  // porownaj liste ruchow
  unsigned char *bufor = plansze.PrzydzielPlansze();
  CzyscTablice(bufor);
  for (int i=0; i<ile_r; i++) bufor[ruchy[i]]=1;
  for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++)
    if (bufor[ang[1].lista_ruchow[i]]==1)
      bufor[ang[1].lista_ruchow[i]]=0;
    else
      { ekran.WyswietlNapis("Inne ruchy"); blad=1; }
  // badaj sasiadow
  if (akt==1) {
    int ok=1;
    for (int i=0; i<wlkx4wlky4; i++)
      if (ang[0].sasiedzi.tab_sas[i]) { ok=0; break; }
    if (!ok)
      { ekran.WyswietlNapis("Niepuste tab_sas"); blad=1; }
  }
  // sprawdz, czy nie ma podwojnych lub bezsensownych ruchow
  for (int g=2; g<=akt; g++) {
    CzyscTablice(bufor);
    for (int i=ang[g].pocz_ruch; i<ang[g].ost_ruch; i++) {
      unsigned int ind = ang[g].lista_ruchow[i];
      if (ind>=wlkx4wlky4 || upl_marg[ind]<2)
	{ ekran.WyswietlNapis("Nieprawidlowy ruch"); blad=1; }
      else {
	if (++bufor[ind] >=2)
	  { ekran.WyswietlNapis("Powtorzony ruch"); blad=1; }
	// sprawdz, czy ruch sensowny
	if ((schemat_ruchow[ind] & 0x3f)==0) { // nie chce mi sie dokladniej sprawdzac...
	  // sprawdz odleglosc od innych kropek
	  int ok=0;
	  for (int ig=1; ig<g; ig++) {
	    int d = ind-ang[ig].indeks;
	    if (d<0) d=-d;
	    if (upl_marg[d]<=2) { ok=1; break; }
	  }
	  if (!ok)
	    { ekran.WyswietlNapis("Dziwny ruch"); blad=1; }
	}
      }
    }
  }
  if (blad)
    {
      GrKeyRead();
    }
  plansze.ZwolnijPlansze(bufor);
}
void TTestSasiadow::Koniec()
{skladowe.ZwolnijSkladowa(ruchy); 
 skladowe.ZwolnijSkladowa(ruchy_p); } 
*/

void ZaznaczSymetrie_P()
// zaznacza prawa polplaszczyzne w TAnaliza::symetrie
{
  for (int i=(wlkx+5)/2; i<wlkx+2; i++) {
    unsigned int ind = WezIndeksTab(i,2);
    for (int j=0; j<wlky; j++)
      TAnaliza::symetrie[ind+j]=1;
  }
}

void ZaznaczSymetrie_D()
// zaznacza dolna polplaszczyzne w TAnaliza::symetrie
{
  for (int j=(wlky+5)/2; j<wlky+2; j++) {
    unsigned int ind = WezIndeksTab(1,j);
    for (int i=0; i<wlkx; i++)
      TAnaliza::symetrie[ind+=W_P]=1;
  }
}

void UstawSymetrie(unsigned char *r)
// we: plansza z rozgrywka (NIE rozgr2, NIE rozgr3)
// ustawia odpowiednio pola statyczne TAnaliza::symetrie oraz TAnaliza::sa_symetrie
{
  TAnaliza::sa_symetrie=0;
  CzyscTablice(TAnaliza::symetrie);
  // sprawdz symetrie wzgl. pionowej osi
  for (int i=2; i<=wlkx; i++) {
    unsigned int ind1 = WezIndeksTab(i,2);
    unsigned int ind2 = WezIndeksTab(wlkx+3-i,2);
    if (ind1>=ind2) {
      // jest symetria wzgl. pionowej osi!
      TAnaliza::sa_symetrie|=1;
      ZaznaczSymetrie_P();
      break;
    }
    // sprawdzaj kolumne
    for (int j=0; j<wlky; j++) {
      if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
	goto Nie_ma_symetrii_pion;
      ind1++; ind2++;
    }
  }
 Nie_ma_symetrii_pion:;
  // sprawdz symetrie wzgl. poziomej osi
  for (int j=2; j<=wlky; j++) {
    unsigned int ind1 = WezIndeksTab(2,j);
    unsigned int ind2 = WezIndeksTab(2,wlky+3-j);
    if (ind1>=ind2) {
      // jest symetria wzgl. poziomej osi!
      TAnaliza::sa_symetrie|=2;
      ZaznaczSymetrie_D();
      break;
    }
    // sprawdzaj wiersz
    for (int i=0; i<wlkx; i++) {
      if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
	goto Nie_ma_symetrii_poz;
      ind1+=W_P; ind2+=W_P;
    }
  }
 Nie_ma_symetrii_poz:;
  // sprawdz obrot o pi
  for (int ind1=up.lg; ind1<=up.pd; ind1++) {
    unsigned int ind2 = wlkx4wlky4 -1 -ind1;
    if (ind1>=ind2) {
      // jest obrot o pi
      if (TAnaliza::sa_symetrie==0) {
	TAnaliza::sa_symetrie|=4;
	if ((wlkx & 1)==0) ZaznaczSymetrie_P();   // wybierz lepsza wersje z dwoch
	else ZaznaczSymetrie_D();                 // (mozna by zawsze lepiej: czasami mozna usunac kawalek srodkowej linii)
      }
      break;
    }
    if (r[ind1]!=r[ind2] || ((ang[0].plansz_p[ind1] ^ ang[0].plansz_p[ind2]) & 0xf))
      goto Nie_ma_obrotu_o_pi;
  }
  Nie_ma_obrotu_o_pi:;
}

void TAnaliza::UstawBezpNaZawsze()
// Zzaznacza kropki na zawsze bezpieczne w TAnaliza::bezp_na_zawsze[].
// Wykorzystuje pole rozgr3.
{
  krint *stos = skladowe.PrzydzielSkladowa();
  CzyscTablice(TAnaliza::bezp_na_zawsze);
  if (zasady_gry==0) {
    for (int i=up.lg; i<=up.pd; i++)
      if (upl_marg[i]==2 && rozgr3[i] && TAnaliza::bezp_na_zawsze[i]==0) {
	// przejdz skladowa kropki [i]
	int kto=rozgr3[i], na_stosie=1;
	stos[0]=i;  TAnaliza::bezp_na_zawsze[i]=1;
	do {
	  int p=stos[--na_stosie];
	  for (int s=0; s<4; s++) {
	    int ps = p+up.dind[s];
	    if (rozgr3[ps]==kto && TAnaliza::bezp_na_zawsze[ps]==0) {
	      TAnaliza::bezp_na_zawsze[ps]=1;
	      stos[na_stosie++] = ps;
	    }
	  }
	}
	while (na_stosie);
      }
  }
  else {  // zasady gry>0
    for (int i=up.lg; i<=up.pd; i++)
      if (upl_marg[i]==2 && rozgr3[i] && TAnaliza::bezp_na_zawsze[i]==0) {
	// przejdz skladowa kropki [i]
	int kto=rozgr3[i], na_stosie=1;
	int maska_ss = (kto==1) ? 4:8;
	stos[0]=i;  TAnaliza::bezp_na_zawsze[i]=1;
	do {
	  int p=stos[--na_stosie];
	  for (int s=0; s<4; s++) {
	    int ps = p+up.dind[s];
	    if (rozgr3[ps]==kto && TAnaliza::bezp_na_zawsze[ps]==0
		&& !(plansz_p[ps] & maska_ss)) {   // nie wewn. naszego st. stopu -- to moze nie
	      //   byc bezpieczne
	      TAnaliza::bezp_na_zawsze[ps]=1;
	      stos[na_stosie++] = ps;
	    }
	  }
	}
	while (na_stosie);
      }
  }
  skladowe.ZwolnijSkladowa(stos);
}

void TAnaliza::UstawLancuchyWplanszp()
// korzysta z pol: rozgr2, rozgr3, bezp_na_zawsze
// modyfikuje    : bity lancuchow w plansz_p, rozgr2
{
  for (int i=up.lg; i<=up.pd; i++)
    if (upl_marg[i]<=3 && rozgr2[i]) {
      // najpierw sprawdz, czy jest sens...
      for (int k=0; k<4; k++)
	if (upl_marg[i+up.dind[k]]>=upl_marg[i])
	  if (!bezp_na_zawsze[i+up.dind[k]] || 
	      rozgr3[i+up.dind[k]]==0 || rozgr3[i+up.dind[k]]==rozgr2[i])
	    goto Kropka_potrzebna;
      // kolo naszej kropki sa trzy bezpieczne kropki przeciwnika -- nasza jest niepotrzebna
      // usun kropke z rozgr2
      plansz_p[i] |= 0x40;  // bit lancucha
      rozgr2[i]=0;
    Kropka_potrzebna:;
    }
}

void TAnaliza::DodajBezsensowne(unsigned char *schemat_ruchow)
// dodaje bezsensowne pola do tablicy schemat_ruchow (ustawia na 0xff)
// uzywa pol: rozgr3, bezp_na_zawsze
{
  unsigned char *skl     = plansze.PrzydzielPlansze();
  unsigned char *ciekawe = plansze.PrzydzielPlansze();
  krint *pola_skl = skladowe.PrzydzielSkladowa();
  krint *stos     = skladowe.PrzydzielSkladowa();
  CzyscTablice(ciekawe);
  CzyscTablice(skl);
  for (int i=2; i<wlkx+2; i++) {
    int ind = WezIndeksTab(i,2);
    for (int j=2; j<wlky+2; j++) {
      if (rozgr3[ind]==0 && skl[ind]==0) {
	// szukaj skladowej spojnosci pola [ind]
	stos[0]=ind;  skl[ind]=1;
	int ile_pol=0, na_stosie=1, skl_ok=1;
	do {
	  int indeks=stos[--na_stosie];
	  if (skl_ok) {
	    if (rozgr3[indeks-1] && !bezp_na_zawsze[indeks-1] ||
		rozgr3[indeks+1] && !bezp_na_zawsze[indeks+1] ||
		rozgr3[indeks-wlky-4] && !bezp_na_zawsze[indeks-wlky-4] ||
		rozgr3[indeks+W_P] && !bezp_na_zawsze[indeks+W_P])
	      skl_ok=0;
	    pola_skl[ile_pol++]=indeks;
	  }
	  // odwiedz i zaznacz sasiadow
	  if (rozgr3[indeks-1]==0 && upl_marg[indeks-1]>=2 && skl[indeks-1]==0)
	    skl[ stos[na_stosie++]=indeks-1 ] =1;
	  if (rozgr3[indeks+1]==0 && upl_marg[indeks+1]>=2 && skl[indeks+1]==0)
	    skl[ stos[na_stosie++]=indeks+1 ] =1;
	  if (rozgr3[indeks-wlky-4]==0 && upl_marg[indeks-wlky-4]>=2 && skl[indeks-wlky-4]==0)
	    skl[ stos[na_stosie++]=indeks-wlky-4 ] =1;
	  if (rozgr3[indeks+W_P]==0 && upl_marg[indeks+W_P]>=2 && skl[indeks+W_P]==0)
	    skl[ stos[na_stosie++]=indeks+W_P ] =1;
	}
	while (na_stosie);
	if (skl_ok) {
	  // sprawdz, gdzie sa mozliwe brzuszki
	  for (int p=0; p<ile_pol; p++) {
	    int ip = pola_skl[p];
	    if (upl_marg[ip]>=3) {
	      int kto=(rozgr3[ip-1] | rozgr3[ip+1] | rozgr3[ip-wlky-4] | rozgr3[ip+W_P]);
	      if (kto<3)  // mozliwy brzuszek w [ip]
		ciekawe[ip-1] = ciekawe[ip+1] = ciekawe[ip-wlky-4] = ciekawe[ip+W_P] = 1;
	    }
	  }
	  // pola, ktore sa nieciekawe zaznacz jako bezsensowne
	  for (int p=0; p<ile_pol; p++)
	    if (!ciekawe[pola_skl[p]])
	      schemat_ruchow[pola_skl[p]]=0xff;
	}
      }
      ind++;
    }
  }
  skladowe.ZwolnijSkladowa(pola_skl);
  skladowe.ZwolnijSkladowa(stos);
  plansze.ZwolnijPlansze(skl);
  plansze.ZwolnijPlansze(ciekawe);
}

/*****************************************************************/

void UwzglednijKillerMoveSortuj(krint *lista, int n, int r1, int r2, int wart1, int wart2)
// stand. wart1=29000, wart2=14500
// powinno byc r1!=r2 (ew. moze byc r1==r2==0)
// moze byc r1!=0 i r2==0, ale NIE NA ODWROT
{
  int ile = (r1!=0)+(r2!=0);
  switch (ile) {
  case 2: {
    TAnaliza::historia_sort[r1]+=wart1;   // 1. miejsce w km
    TAnaliza::historia_sort[r2]+=wart2;    // 2. miejsce w km
    int skad=n-1, jest1=0, jest2=0;
    int dokad=skad;
    while (skad>=0)
      if (lista[skad]==r1)       { skad--;  jest1=1; }
      else if (lista[skad]==r2)  { skad--;  jest2=1; }
      else lista[dokad--] = lista[skad--];
    if (jest1) {
      lista[0]=r1;
      if (jest2) lista[1]=r2;
    }
    else if (jest2) lista[0]=r2; 
  }
  break;
  case 1: {
    TAnaliza::historia_sort[r1]+=wart1;   // 1. miejsce w km
    int skad=n-1, jest1=0;
    int dokad=skad;
    while (skad>=0)
      if (lista[skad]==r1) { skad--;  jest1=1; }
      else lista[dokad--] = lista[skad--];
    if (jest1) lista[0]=r1;
  }
  break;
  }  
}

inline void UwzglednijKillerMove(int akt_gleb, int ost_gleb)
// sortuje ang[akt_gleb].lista_ruchow tak, aby
// ,,killer moves'' wyladowaly na poczatku
// Zaklada, ze akt_gleb jest >=2
{
  unsigned short int prop0, prop1;
  int rodzaj;
  if (akt_gleb<=3) {
    htablicaZ.Wez(ang[akt_gleb-1].htab_zobr, rodzaj, prop0, prop1, ost_gleb-akt_gleb);
    ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks] = prop0;
    ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks] = prop1;
  }
  else {
    prop0 = ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks];
    prop1 = ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks];
    rodzaj = (ang[akt_gleb-1].rodzaj_oc_ht[ang[akt_gleb-1].indeks] & 3);
    //assert(prop0<wlkx4wlky4 && prop1<wlkx4wlky4);
    //assert(prop0==0 || (prop0!=prop1));
  }
  //  if (akt_gleb<=5 || akt_gleb<ost_gleb-1)
  //  if (akt_gleb<=6 ||  akt_gleb<ost_gleb-2) {
  /*
    // calkiem dobre, choc kiepskie na test3/13 (79.22s)
  if (rodzaj==0 || akt_gleb<=5 || akt_gleb<ost_gleb-2) {
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : 500));
    int wart2 = rodzaj ? (wart1>>1) : 200;
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  /*
    // chyba lepsze, choc dalej kiepskie na test3/13 (ok. 76s)
  if (rodzaj==0 || akt_gleb<=5 || akt_gleb<ost_gleb-2) {
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    //    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : (ost_gleb-akt_gleb>=5 ? 2000 : 500)));
    //int wart2 = rodzaj ? (wart1>>1) : (akt_gleb<=3 ? 6000 : (ost_gleb-akt_gleb>=5 ? 800 : 200));
    int wart1 = (rodzaj ? 29500 : ((akt_gleb<=3 || ost_gleb-akt_gleb>=5) ? 15000 : 8000));
    int wart2 = rodzaj ? (wart1>>1) : ((akt_gleb<=3 || ost_gleb-akt_gleb>=5) ? 7000 : 2000);
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=3; wart2>>=4; }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  /*
  { // bardzo dobre! tylko test3/13 wolniej: 66.85s
    //    int wart1 = (rodzaj ? 29500/2 : 450/2) *(2*ost_gleb-1-akt_gleb) / (ost_gleb-1);
    //    int wart1 = (rodzaj ? 29500 : (akt_gleb<=3 ? 15000 : (ost_gleb-akt_gleb>=5 ? 2000 : 500)));
    //int wart2 = rodzaj ? (wart1>>1) : (akt_gleb<=3 ? 6000 : (ost_gleb-akt_gleb>=5 ? 800 : 200));
    int wart1 = (rodzaj ? 29500 : 22000);
    int wart2 = rodzaj ? 14500: 11000;
    //if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=3; wart2>>=5; }
    //    if (akt_gleb>1+2*(ost_gleb-akt_gleb)) { wart1>>=3; wart2>>=5; }
    int prog_akt[] = {0,3,5,9,11,12,15,16,17,18,19,20,21,21,21,21,21,21,21,21,21};
    //    if (akt_gleb>prog_akt[ost_gleb-akt_gleb]) { wart1>>=(4-(ost_gleb-akt_gleb)); wart2>>=(6-(ost_gleb-akt_gleb)); }
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=(5+(akt_gleb/8)); wart2>>=(6+(akt_gleb/4)); }
    if (akt_gleb>7 && akt_gleb==ost_gleb-2) { wart1>>=(1+(akt_gleb/8)); wart2>>=(3+(akt_gleb/4)); }
    //if (akt_gleb>5 && rodzaj) { wart1>>=2; wart2>>=5; }
    //    for (int i=4; i<akt_gleb; i++)
    //      if (2*(ost_gleb-akt_gleb)<=i-1) { wart1>>=1; wart2>>=1; }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
  */
  { // ,,bdb+'' (66.23)
    int wart1 = (rodzaj ? 29500 : 22000);
    int wart2 = rodzaj ? 14500: 11000;
    if (akt_gleb>3 && akt_gleb==ost_gleb-1) { wart1>>=(4+(rodzaj!=0)+(akt_gleb/8)); wart2>>=(5+(rodzaj!=0)+(akt_gleb/4)); }
    if (akt_gleb>6 && akt_gleb==ost_gleb-2) { wart1>>=(1+(rodzaj!=0)+(akt_gleb/8)); wart2>>=(3+2*(rodzaj!=0)+(akt_gleb/4)); }
    if (akt_gleb>8 && akt_gleb==ost_gleb-3) { wart1>>=(1+(rodzaj!=0));   wart2>>=(3+2*(rodzaj!=0)); }
    UwzglednijKillerMoveSortuj(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
			       ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch,
			       prop0, prop1, wart1, wart2);
  }
}


krint SasiedziAW(krint *odblokowuja, const unsigned char* rozgr3,
		 int kto, int przec, unsigned int pole, int wprawo, int wgore)
  // zwraca 0 lub indeks antyweza
  // szablon:
  //   n  
  // n   o o n
  //   . x o n          <-- x tutaj ma wspolrzedna [pole]
  //     x .
  // objasnienie: x - kropka przec, . - kropka kto, o - puste pole,
  //  n - puste pole lub kropka przec
{
  if (rozgr3[pole+wgore] != 0     || rozgr3[pole+wprawo] != 0 ||
      rozgr3[pole-wgore] != przec || rozgr3[pole-wprawo] != kto)
    return 0;
  if (rozgr3[pole+wgore+wprawo] != 0   || rozgr3[pole+wgore+2*wprawo] == kto ||
      rozgr3[pole+2*wprawo]     == kto || rozgr3[pole-wgore+wprawo] != kto)
    return 0;
  if (rozgr3[pole-wprawo+2*wgore]==kto || rozgr3[pole-2*wprawo+wgore]==kto)
    return 0;
  if (upl_marg[pole+wgore]<=2)
    return 0;   // nie blokujemy na samej bandzie, ani tym bardziej poza plansza
  unsigned int ind = pole+2*(wprawo+wgore);
  while (upl_marg[ind]>=1) {
    if (rozgr3[ind]==kto) return 0;
    else if (rozgr3[ind]!=0) break;
    if (rozgr3[ind+wprawo]==kto) return 0;
    else if (rozgr3[ind+wprawo]!=0) break;
    if (rozgr3[ind-wprawo]==kto) return 0;
    else if (rozgr3[ind-wprawo]!=0) break;
    if (rozgr3[ind+wprawo-wgore]==kto) return 0;
    else if (rozgr3[ind+wprawo-wgore]!=0) break;
    ind += wprawo+wgore;
  }
  // ok, ustaw antyweze
  odblokowuja[0] = pole+wprawo;
  odblokowuja[1] = pole+2*wprawo;
  odblokowuja[2] = odblokowuja[0]+wgore;
  odblokowuja[3] = odblokowuja[1]+wgore;
  odblokowuja[4] = odblokowuja[2]+wgore;
  odblokowuja[5] = odblokowuja[3]+wgore;
  odblokowuja[6] = odblokowuja[4]-wprawo;
  odblokowuja[7] = odblokowuja[6]-wprawo;
  odblokowuja[8] = odblokowuja[7]-wgore;
  odblokowuja[9] = odblokowuja[8]-wprawo;
  return pole+wgore;
}

int PonadDwieKropki(unsigned char *r, unsigned int ind)
// zwraca 1, gdy w 20-kropkowym sasiedztwie kropki [ind]
// sa co najmniej dwie kropki
{
  int ile=0;
  unsigned int indp = ind + wlky+4 -2;
  for (int i=0; i<5; i++)       // na prawo od [ind]
    ile += (r[indp+i] != 0);
  indp+= wlky+4+1;
  for (int i=0; i<3; i++)       // 2 na prawo od [ind]
    ile += (r[indp+i] != 0);
  if (ile>=2) return 1;
  indp = ind -wlky-4 -2;
  for (int i=0; i<5; i++)       // na lewo od [ind]
    ile += (r[indp+i] != 0);
  indp-= wlky+4-1;
  for (int i=0; i<3; i++)       // 2 na lewo od [ind]
    ile += (r[indp+i] != 0);
  if (ile>=2) return 1;
  ile+= (r[ind-2]!=0);
  ile+= (r[ind-1]!=0);
  ile+= (r[ind+1]!=0);
  ile+= (r[ind+2]!=0);
  return (ile>=2);
}

int DodajSasiadow(krint *listar, krint *sasiedzi, int ile_sas,
		  unsigned char *schemat_ruchow, int maska)
  // dodaje max. ile_sas sasiadow do listar, zwraca liczbe dodanych
  // sasiadow. Nie dodaje tych ruchow, ktore maja ustawiona maske
  // w schemacie ruchow.
  // Funkcja pomocnicza dla DodajSasiadow(uchar*, int, int)
{
  int iledod=0;
  for (int i=0; i<ile_sas; i++) {
    if ((schemat_ruchow[*sasiedzi] & maska)==0)
      { *listar++ = *sasiedzi;  iledod++; }
    sasiedzi++;
  }
  return iledod;
}

void RuchyQuickSort(krint *tab, int n);

/*
#define MAX_DRUGI_RUCH 100000
class TDrugiRuch {
  krint *tab;
  int *nr_ruchu;
  int ile_ruchow1, ile_ruchow2;
public:
  TDrugiRuch() { tab=new krint[MAX_DRUGI_RUCH]; nr_ruchu=new int[max_powierzchnia_planszy]; };
  ~TDrugiRuch() { delete[] tab; delete[] nr_ruchu; };
  void Inicjuj();
  void Zapisz();
  void Sortuj();
} drugi_ruch;

void TDrugiRuch::Inicjuj()
// korzysta z ang[1].pocz_ruch, .ost_ruch, ang[1].lista_ruchow
{
  ile_ruchow1 = ang[1].ost_ruch-ang[1].pocz_ruch;
  if (ile_ruchow1==0) return;  // na wszelki wypadek
  ile_ruchow2 = MAX_DRUGI_RUCH / ile_ruchow1;
  for (int i=0; i<wlkx4wlky4; i++)
    nr_ruchu[i] = -1;  // inicjuj na -1, zeby wiedziec, ktore ruchy sa
  for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++)
    tab[  nr_ruchu[ang[1].lista_ruchow[i]] = (i-ang[1].pocz_ruch)*ile_ruchow2  ] =0;

}

void TDrugiRuch::Zapisz()
// korzysta z ang[1].indeks, ang[2].lista_ruchow, .pocz_ruch, .ost_ruch
{
  int baza=nr_ruchu[ang[1].indeks];
  if (baza==-1) return;  // nie mamy ruchu w bazie
  int ile=ang[2].ost_ruch-ang[2].pocz_ruch;
  if (ile>ile_ruchow2) ile=ile_ruchow2;
  if (ile)
    memcpy(&tab[baza], &ang[2].lista_ruchow[ang[2].pocz_ruch], sizeof(tab[0])*ile);
  if (ile<ile_ruchow2) tab[baza+ile]=0;   // zero konczace liste ruchow
}

void TDrugiRuch::Sortuj()
// korzysta z ang[1].indeks, ang[2].lista_ruchow, .pocz_ruch, .ost_ruch
{
  int baza=nr_ruchu[ang[1].indeks];
  if (baza==-1 || tab[baza]==0) return;  // nie mamy ruchu w bazie
  int ile=ang[2].ost_ruch-ang[2].pocz_ruch;
  for (int i=0; i<ile; i++)
    TAnaliza::historia_sort[ang[2].lista_ruchow[ang[2].pocz_ruch+i]] = ile-i;
  for (int i=0; i<ile_ruchow2; i++)
    if (tab[baza+i])
      TAnaliza::historia_sort[tab[baza+i]] += ile_ruchow2-i;  //= 2*max_powierzchnia_planszy -i;
    else break;
  RuchyQuickSort(&ang[2].lista_ruchow[ang[2].pocz_ruch], ile);
}
*/

void DodajSasiadow(unsigned char *schemat_ruchow, int akt, int ost)
  // tutaj ost>=3, akt>=2, akt<ost (akt==akt_gleb, ost==ost_gleb)
  // dodaje na kazdej glebokosci
  // maski w schemat_ruchow:
  //  1,2: lisc
  //  4,8: upr
  // 0x10,0x20: pelna lista
  // maski w ang[0].sasiedzi.tab_sas:
  //  1  : sasiedzi dodawani do ruchow gracza ang[1].ktory_gracz
  //  2  : sasiedzi dodawani do ruchow gracza ang[2].ktory_gracz
  //  4  : (nieuzywane)
  //  8  : ruch zabroniony (anty-waz)
  // 0x10: pole odblokowujace zabroniony ruch (anty-waz)
  // 0x20: sasiedzi dodawani do liscia gdy akt jest nieparzyste
  // 0x40: sasiedzi dodawani do liscia gdy akt jest parzyste
{
  STOPER_START_DSAS;
  // dodajemy sasiadow ruchu [akt-1]
  // do niep i parz wszystkie wolne pola (trzeba potem sprawdzac,
  // czy ruchow nie ma juz na listach ruchow: pelnych lub upr),
  // do liscia od razu tylko te, ktorych jeszcze nie ma (w lisciach
  // lub dotychczasowych sasiadach)
  {
    krint *sas1, *sas12;
    int *ile_s1, *ile_s12;
    int maska1, maska12, maska_lisc;
    if (akt & 1) {
      sas1 = ang[akt].sasiedzi.niep;
      sas12= ang[akt].sasiedzi.parz;
      ile_s1 = &ang[akt].sasiedzi.ile_n;
      ile_s12= &ang[akt].sasiedzi.ile_p;
      maska1=1;   maska12=2;   maska_lisc=0x20;
    } else {
      sas1 = ang[akt].sasiedzi.parz;
      sas12= ang[akt].sasiedzi.niep;
      ile_s1 = &ang[akt].sasiedzi.ile_p;
      ile_s12= &ang[akt].sasiedzi.ile_n;
      maska1=2;   maska12=1;   maska_lisc=0x40;
    }
    *ile_s1=0;  *ile_s12=0;  ang[akt].sasiedzi.ile_lisc=0;
    for (int p=0; p<20; p++) {
      unsigned int ind = ang[akt-1].indeks + up.dind[p];
      //      if (PoleBezs12(ang[akt-1].rozgr3, ind, 1))
      //        continue;   // pole zupelnie lub chwilowo bezsensowne
      if (ang[akt-1].rozgr3[ind]==0 && upl_marg[ind]>=2) {  // wolne pole wewn. planszy
	if (p<8 && (ang[0].sasiedzi.tab_sas[ind] & maska1)==0) {
	  *sas1++ = ind;
	  (*ile_s1)++;
	  ang[0].sasiedzi.tab_sas[ind] |= maska1;
	}
	if ((ang[0].sasiedzi.tab_sas[ind] & maska12)==0) {
	  if (p<8 || upl_marg[ind]==3 || PonadDwieKropki(ang[akt-1].rozgr3,ind)) {
	    *sas12++ = ind;
	    (*ile_s12)++;
	    ang[0].sasiedzi.tab_sas[ind] |= maska12;
	  }
	}
	if (p<8 && (ang[0].sasiedzi.tab_sas[ind] & maska_lisc)==0 &&
	    (schemat_ruchow[ind] & ang[akt-1].maska_lisc)==0) {
	  ang[akt].sasiedzi.lisc[  ang[akt].sasiedzi.ile_lisc++  ]=ind;
	  ang[0].sasiedzi.tab_sas[ind] |= maska_lisc;
	}
      }
    }
  }
  // teraz dodaj sasiadow do listy
  if (akt==2) {
    // policz, ile sasiadow (z .parz) trzeba dodac
    int ile_dodac=0, ktore[8];
    for (int i=0; i<ang[2].sasiedzi.ile_p; i++) {
      unsigned int ind = ang[2].sasiedzi.parz[i];
      if ((schemat_ruchow[ind] & ang[2].maska_pelna)==0)
	{ ile_dodac++;  ktore[i]=1; }
      else ktore[i]=0;
    }
    if (ile_dodac) {
      // przesun w gore wszystkie ruchy z wyjatkiem 3 najlepszych (jesli sa 3)
      int skad = ang[2].pocz_ruch+3;
      for (int i=ang[2].ost_ruch-1; i>=skad; i--)
	ang[2].lista_ruchow[i+ile_dodac] = ang[2].lista_ruchow[i];
      // wstaw sasiadow
      if (ang[2].ost_ruch - ang[2].pocz_ruch <3)  skad=ang[2].ost_ruch;
      for (int i=0; i<ang[2].sasiedzi.ile_p; i++)
	if (ktore[i]) 
	  ang[2].lista_ruchow[skad++] = ang[2].sasiedzi.parz[i];
      ang[2].ost_ruch += ile_dodac;
    }
    /*
      // tu chyba tak nie mozna -- ang[2].lista_ruchow jest taka sama dla kolejnych pierwszych ruchow!
    if (ost>=6) {  // filtruj bezsensowne
      int dokad=0;
      for (int i=0; i<ang[2].ost_ruch; i++) {
	unsigned int ind = ang[2].lista_ruchow[ang[2].pocz_ruch + i];
	if (!PoleBezs12(ang[1].rozgr3, ind, 1))
	  ang[2].lista_ruchow[dokad++] = ind;
      }
      ang[2].pocz_ruch=0;
      ang[2].ost_ruch =dokad;
    }
    */
  } 
  else if (akt<ost-1) 
    {
    // tutaj mamy miec w [akt] pelna liste ruchow
    int iler = ang[akt-2].ost_ruch - ang[akt-2].pocz_ruch;
    int ilenajl = (iler<3) ? iler:3;
    // przepisz najlepsze
    for (int i=0; i<ilenajl; i++)
      ang[akt].lista_ruchow[i] = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
    int dokad = ilenajl;
    // przepisz sasiadow
    if (akt & 1) {
      // przepisz niep z poziomow [akt-1] i [akt]
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.niep,
			     ang[akt-1].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_pelna);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.niep,
			     ang[akt].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_pelna);
    } else { // j.w., ale przepisujemy z parz
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.parz,
			     ang[akt-1].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_pelna);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.parz,
			     ang[akt].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_pelna);
    }
    /*
      // tu tez tak nie mozna -- pozniej juz nigdy nie dodamy usunietych ruchow!
      // (one pozostana zaznaczone w schemat_ruchow)

    if (akt<ost-4) {
      // przegladnij, czy nie ma bezsensownych
      int dokad2=0;
      for (int i=0; i<dokad; i++)
	if (!PoleBezs12(ang[akt-1].rozgr3, ang[akt].lista_ruchow[i], 1))
	  ang[akt].lista_ruchow[dokad2++] = ang[akt].lista_ruchow[i];
      dokad=dokad2;
      // przepisz reszte ruchow filtrujac bezsensowne
      for (int i=ilenajl; i<iler; i++) {
	unsigned int ind = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
	if (!PoleBezs12(ang[akt-1].rozgr3, ind, 1))
	  ang[akt].lista_ruchow[dokad++] = ind;
      }
    }
    else  // przepisz reszte ruchow
    */
      for (int i=ilenajl; i<iler; i++)
	ang[akt].lista_ruchow[dokad++] = ang[akt-2].lista_ruchow[ang[akt-2].pocz_ruch + i];
    // ustaw pocz_ruch i ost_ruch
    ang[akt].pocz_ruch=0;
    ang[akt].ost_ruch =dokad;
  } 
  else 
    {  // akt==ost-1, akt>2
    // wypelnij tablice [akt].lista_ruchow uproszczonymi
    // przepisz do 3 najlepszych
    int dokad=0, skad=ang[akt-2].pocz_ruch;
    while (skad < ang[akt-2].ost_ruch) {
      unsigned int ind = ang[akt-2].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & (ang[akt].maska_upr | ang[akt].maska_pelna)) !=
	   ang[akt].maska_pelna) {
	// pow. warunek spelniony <=> ruch jest na liscie upr, lub nie ma go
	// na liscie pelnej, a w konsekwencji jest jednym z sasiadow
	ang[akt].lista_ruchow[dokad++] = ind;
	if (dokad==3) break;  // tylko 3 najlepsze!
      }
    }
    // przepisz sasiadow
    if (akt & 1) {
      // przepisz niep z poziomow [akt-1] i [akt]
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.niep,
			     ang[akt-1].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_upr);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.niep,
			     ang[akt].sasiedzi.ile_n, schemat_ruchow, ang[akt].maska_upr);
    } else { // j.w., ale przepisujemy z parz
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt-1].sasiedzi.parz,
			     ang[akt-1].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_upr);
      dokad += DodajSasiadow(&ang[akt].lista_ruchow[dokad], ang[akt].sasiedzi.parz,
			     ang[akt].sasiedzi.ile_p, schemat_ruchow, ang[akt].maska_upr);
    }
    // przepisz reszte ruchow
    while (skad < ang[akt-2].ost_ruch) {
      unsigned int ind = ang[akt-2].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & (ang[akt].maska_upr | ang[akt].maska_pelna)) !=
	   ang[akt].maska_pelna)
	// pow. warunek spelniony <=> ruch jest na liscie upr, lub nie ma go
	// na liscie pelnej, a w konsekwencji jest jednym z sasiadow
	ang[akt].lista_ruchow[dokad++] = ind;
    }
    // ustaw pocz_ruch i ost_ruch
    ang[akt].pocz_ruch=0;
    ang[akt].ost_ruch =dokad;
  } 
  // teraz zobacz, czy trzeba wypelnic lisc
  if (akt+1==ost) {
    int gleb_skad = (akt&1)+1;
    // przepisz do 3 najlepszych
    int dokad=0, skad=ang[gleb_skad].pocz_ruch;
    while (skad < ang[gleb_skad].ost_ruch) {
      unsigned int ind = ang[gleb_skad].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & ang[ost].maska_lisc)!=0) {
	ang[ost].lista_ruchow[dokad++] = ind;
	if (dokad==3) break;  // tylko 3 najlepsze!
      }
    }
    // przepisz wszystkich sasiadow
    //for (int g=gleb_skad+1; g<=akt; g+=2)
    for (int g=akt; g>=2; g-=2)                 // tak szybciej na ogol
      for (int r=0; r<ang[g].sasiedzi.ile_lisc; r++)
	ang[ost].lista_ruchow[dokad++] = ang[g].sasiedzi.lisc[r];
    // przepisz reszte ruchow
    while (skad < ang[gleb_skad].ost_ruch) {
      unsigned int ind = ang[gleb_skad].lista_ruchow[skad++];
      if ((schemat_ruchow[ind] & ang[ost].maska_lisc)!=0)
	ang[ost].lista_ruchow[dokad++] = ind;
    }

    /*
    // posortuj ruchy 3,..,dokad
    if (dokad>8) {
      int sortuj_do = dokad;  //>20 ? 20:dokad;

      ang[akt-1].robaki[ang[ost].ktory_teraz-1].UstawPolaczonyZ_sklad(TAnaliza::polaczony_z[0]);
      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
	int poziom_bezp;
	int ocena=
	  ang[akt-1].robaki[ang[ost].ktory_teraz-1].OcenRuch(
   	    ang[akt-1].rozgr3, 
	    TAnaliza::polaczony_z[0], ind, 1, poziom_bezp);
	TAnaliza::historia_sort[ind]= ocena + 2*(sortuj_do-i);
	} 

      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
	TAnaliza::historia_sort[ind] = 2*(sortuj_do-i);
      }

      int oceny[3]={2000,1000,500};
      for (int g=1; g<akt; g++) {
	for (int i=0; i<3; i++)
	  if (ang[g].pocz_ruch+i < ang[g].ost_ruch)
	    TAnaliza::historia_sort[ang[g].lista_ruchow[ang[g].pocz_ruch+i]] +=
	      oceny[i];
	oceny[0]*=5;   oceny[1]*=5;  oceny[2]*=5;  
	oceny[0]/=6;   oceny[1]/=6;  oceny[2]/=6;
      }
      for (int g=1; g<akt; g++) 
	TAnaliza::historia_sort[ang[g].indeks]=0;

      RuchyQuickSort(&ang[ost].lista_ruchow[0], sortuj_do);
      // odtworz
      for (int i=up.lg; i<=up.pd; i++)
      	TAnaliza::historia_sort[i]= 1;

      for (int i=0; i<sortuj_do; i++) {
	unsigned int ind = ang[ost].lista_ruchow[i];
      	TAnaliza::historia_sort[ind]= 1;
      }
    }
    */

    // ustaw pocz_ruch i ost_ruch
    ang[ost].pocz_ruch=0;
    ang[ost].ost_ruch =dokad;
  }
 if (TAnaliza::gracz.umiejetnosci & 0x40) {
 // zobacz czy sa nowe antyweze
 if ((akt & 1) && akt>=3) {
   unsigned int pole = ang[akt-1].indeks;
   int przec = ang[akt-1].ktory_teraz;
   int kto   = ang[akt].ktory_teraz;
   int wprawo[8] = {1,1,-1,-1,+W_P,+W_P,-wlky-4,-wlky-4 };
   int wgore [8] = {+W_P,-wlky-4,+W_P,-wlky-4, 1,-1, 1,-1 };
   for (int i=0; i<8; i++)
     if ((ang[akt].sasiedzi.antywaz =
	  SasiedziAW(ang[akt].sasiedzi.odblokowuja, ang[akt-1].rozgr3, //bylo ang[akt].rozgr3 (popr: 82.35)
		     kto, przec, pole, wprawo[i], wgore[i]))!=0)
       break;
   if (ang[akt].sasiedzi.antywaz) {
     ang[0].sasiedzi.tab_sas[ ang[akt].sasiedzi.antywaz ] |= 8;
     for (int i=0; i<10; i++)
       ang[0].sasiedzi.tab_sas[ ang[akt].sasiedzi.odblokowuja[i] ] |= 0x10;
   }
 }
 // zobacz, czy poprzedni ruch odblokowuje jakies zablokowane przez antyweze ruchy
 if (akt>=4 && (ang[0].sasiedzi.tab_sas[ ang[akt-1].indeks ] & 0x10)) {
   unsigned int ind = ang[akt-1].indeks;
   for (int g=3; g<akt; g+=2)
     if (ang[g].sasiedzi.antywaz)
       for (int i=0; i<10; i++)
	 if (ang[g].sasiedzi.odblokowuja[i] == ind)
	   { ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] &= (~8); break; }
 }
 // usun z listy ruchow ruchy zablokowane przez antyweze, dodaj odblokowane
 if ((akt & 1) && akt>=3) {
   int sa_antyweze = 0;
   for (int g=3; g<=akt; g++)
     if (ang[g].sasiedzi.antywaz) { sa_antyweze=1; break; }
   if (sa_antyweze) {
     int dokad = ang[akt].pocz_ruch;
     for (int i=ang[akt].pocz_ruch; i<ang[akt].ost_ruch; i++) {
       unsigned int ind = ang[akt].lista_ruchow[i];
       if ((ang[0].sasiedzi.tab_sas[ind] & 8) == 0)
	 ang[akt].lista_ruchow[dokad++] = ind;
     }
     ang[akt].ost_ruch = dokad;
     // dodaj odblokowane
     for (int g=3; g<akt; g+=2)
       if (ang[g].sasiedzi.antywaz && 
	   (ang[0].sasiedzi.tab_sas[ang[g].sasiedzi.antywaz] & 8) == 0) {
	 // dodaj ruch .antywaz, jesli go nie ma
	 int jest=0;
	 for (int i=ang[akt].pocz_ruch; i<ang[akt].ost_ruch; i++)
	   if (ang[akt].lista_ruchow[i] == ang[g].sasiedzi.antywaz)
	     { jest=1; break; }
	 if (!jest)
	   ang[akt].lista_ruchow[ ang[akt].ost_ruch++ ] = ang[g].sasiedzi.antywaz;
       }
   }
 }
 }
 // if (akt<=6) // && akt<ost-1) // drugi warunek: optymalizacja?? -- wywoluj rzadziej
 UwzglednijKillerMove(akt,ost);
 // if (akt==2)   drugi_ruch.Sortuj();
 STOPER_STOP_DSAS;
}


void UsunSasiadow(unsigned char *schemat_ruchow, int akt)
{
  if (akt==1) {
    // trzeba usunac sasiadow z listy ruchow
    int dokad=0;
    for (int skad=ang[2].pocz_ruch; skad<ang[2].ost_ruch; skad++) {
      unsigned int ind = ang[2].lista_ruchow[skad];
      if ((schemat_ruchow[ind] & ang[2].maska_pelna)!=0)
	ang[2].lista_ruchow[dokad++] = ind;
    }
    ang[2].pocz_ruch=0;   ang[2].ost_ruch=dokad;
  }
  for (int i=0; i<ang[akt+1].sasiedzi.ile_n; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.niep[i] ] &= (~1);
  for (int i=0; i<ang[akt+1].sasiedzi.ile_p; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.parz[i] ] &= (~2);
  int antymaska_lisc = (akt&1) ? ~0x40 : ~0x20;
  for (int i=0; i<ang[akt+1].sasiedzi.ile_lisc; i++)
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.lisc[i] ] &= antymaska_lisc;
  if (TAnaliza::gracz.umiejetnosci & 0x40) {
  // antyweze
  if ((akt & 1)==0 && ang[akt+1].sasiedzi.antywaz) {
    // usun odblokowujace
    for (int i=0; i<10; i++)
      ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.odblokowuja[i] ] &= (~0x10);
    // dodaj (z powrotem) poprzednie odblokowujace
    for (int g=3; g<akt; g+=2)
      if (ang[g].sasiedzi.antywaz)
	for (int i=0; i<10; i++)
	  ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.odblokowuja[i] ] |= 0x10;
    ang[0].sasiedzi.tab_sas[ ang[akt+1].sasiedzi.antywaz ] &= (~8);
  }
  // dodaj odblokowane poprzednio antyweze
  for (int g=3; g<=akt; g+=2)
    if (ang[g].sasiedzi.antywaz && 
	(ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] & 8)==0) {
      // czy ten [g].antywaz jest odblokowany?
      for (int gg=g+1; gg<akt; gg++) {
	unsigned int ind = ang[gg].indeks;
	for (int i=0; i<10; i++)
	  if (ang[gg].sasiedzi.odblokowuja[i] == ind)
	    goto Jednak_odblokowany;
      }
      ang[0].sasiedzi.tab_sas[ ang[g].sasiedzi.antywaz ] |= 8;
    Jednak_odblokowany:;
    }
  }
}

void ZamknijStopy_pole(unsigned char *rozgrywka, int akt_gleb, int &zap_rozgr,
		       unsigned int indeks)
// funkcja pomocnicza dla ZamknijStopy(),
// zamyka pole [indeks]
{
  ang[akt_gleb].stopy_wykonane[ang[akt_gleb].stopy1++] = indeks | 0x4000;
  if (zap_rozgr) {
    ang[akt_gleb].plansz_p = ang[akt_gleb].tab_pp;
    ang[akt_gleb].rozgr2 = ang[akt_gleb].tab_r2;
    ang[akt_gleb].rozgr3 = ang[akt_gleb].tab_r3;
    KopiujTablice(ang[akt_gleb].plansz_p, ang[akt_gleb-1].plansz_p);
    KopiujTablice(ang[akt_gleb].rozgr2  , ang[akt_gleb-1].rozgr2);
    KopiujTablice(ang[akt_gleb].rozgr3  , ang[akt_gleb-1].rozgr3);
    // usun wstawiona kropke
    ang[akt_gleb-1].OdtworzRozgr23pp();
    zap_rozgr=0;
  }
  TZdobycze wynik[2];  wynik[0].Zeruj(); wynik[1].Zeruj();
  int ile_zd=0, pow=0, pow2=0, ile_zd2=0, punktacja_ss, ile_domysl;
  ang[akt_gleb].jest_stop_sstop |=
    (ZrobRuch(rozgrywka, NULL, NULL, ile_domysl, NULL, 0, ang[akt_gleb].plansz_p,
	      indeks | 0x4000, ang[akt_gleb].ktory_teraz, 0,
	      wynik, ang[akt_gleb].htab_zobr,
	      ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL,
	      ang[akt_gleb].rozgr2, ang[akt_gleb].rozgr3) & 3);
  if (!(TAnaliza::gracz.umiejetnosci & 0x10))  // punktacja_ss (& 0x10) zamiast pow-pow2 (! & 0x10)
    punktacja_ss = pow-pow2;
  else
    punktacja_ss = wynik[ang[akt_gleb].ktory_teraz-1].pss;
  ang[akt_gleb].zyski  +=
    ((akt_gleb&1) ? TAnaliza::gracz.wagi_n.zd : TAnaliza::gracz.wagi_p.zd)*
    (TAnaliza::gracz.waga_kropki*ile_zd + punktacja_ss);
  ang[akt_gleb].zdobycze[0] += wynik[0];
  ang[akt_gleb].zdobycze[1] += wynik[1];
}

void ZamknijStopy(unsigned char *rozgrywka, int akt_gleb, int zap_rozgr, int czy_wyk12)
// Zamyka stopy, ktore warto zamknac juz teraz,
// wywolywane przez WykonajRuchNrJesliMozna() po postawieniu kropki.
// zap_rozgr != 0 oznacza, ze przed wykonaniem stopu nalezy
//   zapisac rozgr2, rozgr3, plansz_p 
// czy_wyk12:  & 1 -- czy zamykac stopy zagrozone,
//             & 2 -- czy zamykac sporne terytoria niezaleznie od akt_gleb
// Uwaga: sporne terytoria sa zawsze zamykane na akt_gleb==1, a pozniej na ogol nie,
//   bo potem ich nie powinno byc.
{
  if (zasady_gry<2) return;
  int kto = ang[akt_gleb].ktory_teraz;
  int przec = 3-kto;
  int maska_wewn_n = (kto==1) ? 0x10:0x20;
  int maska_zamkn_p = (kto==1) ? 0x20:0x10;
  int maska_ss_p    = (kto==1) ? 8:4;
  if (akt_gleb==1) czy_wyk12|=2;  // zamykaj sporne
  //   #define TEST_8343
  // -- mozna dla testu
  // zbadaj, czy trzeba robic cokolwiek
#ifndef TEST_8343
  if (ang[akt_gleb].zdobycze[kto-1].pot_zd==0)
    return;     // nie ma czego zamykac!
#else
  // testuj!
  int ile=0;
  for (int i=up.lg; i<up.pd; i++)
    if (ang[akt_gleb].plansz_p[i] & maska_wewn_n)
      ile++;
  if ((ile && ang[akt_gleb].zdobycze[kto-1].pot_zd==0) ||
      (ile==0 && ang[akt_gleb].zdobycze[kto-1].pot_zd)) {
    ekran.WyswietlNapis("no znowu...");
    sprintf(pargry.nz1, "krb%dg%d.z",int(bseed1), int(bseed2));
    gra.ObsluzZdarzenie(ZD_ZAPIS);
  }
#endif
  STOPER_START_ZAMS;
  // zamknij ostatnio wykonany stop, jesli taki jest
  if ((czy_wyk12 & 2)==0     // jesli bedziemy zamykac sporne, to to niepotrzebne
      && (ang[akt_gleb-1].plansz_p[ang[akt_gleb].indeks] & maska_ss_p)  // wstawilismy do brzuszka
      && ang[akt_gleb].jest_stop_sstop) {
    // zamknij stop(y)
    unsigned int indeks = ang[akt_gleb].indeks;
    for (int s=0; s<4; s++)
      if (ang[akt_gleb].plansz_p[indeks+up.dind[s]] & maska_wewn_n)
	// zamykamy [indeks+up.dind[s]]!
	ZamknijStopy_pole(rozgrywka, akt_gleb, zap_rozgr, indeks+up.dind[s]);
  }
  // teraz zamykaj sporne
  // nie mozna uzyc marginesow na akt. gleb., bo sa jeszcze nie zainicjowane
#ifndef TEST_8343
  if (czy_wyk12 & 2)
#endif
  for (int i=ang[akt_gleb-1].marg0_min.x; i<=ang[akt_gleb-1].marg0_max.x; i++) {
    unsigned int indeks = WezIndeksTab(i, ang[akt_gleb-1].marg0_min.y);
    for (int j=ang[akt_gleb-1].marg0_min.y; j<=ang[akt_gleb-1].marg0_max.y; j++) {
      if (ang[akt_gleb].rozgr2[indeks]==przec && 
	  (ang[akt_gleb].plansz_p[indeks] & maska_wewn_n)) {
	// zamknij te kropke, jesli trzeba
	for (int k=0; k<4; k++)
	  if (ang[akt_gleb].plansz_p[indeks + up.dind[k]] & maska_zamkn_p) {
	    // trzeba zamknac kropke [indeks]!!
#ifdef TEST_8343
	    if ((czy_wyk12 & 2)==0) {
	      ekran.WyswietlNapis("ojej");
	      sprintf(pargry.nz1, "krb%dp%d.z",int(bseed1), int(bseed2));
	      gra.ObsluzZdarzenie(ZD_ZAPIS);
	    }
#endif
	    ZamknijStopy_pole(rozgrywka, akt_gleb, zap_rozgr, indeks);
	    break;  // kropka [indeks] zamknieta...
	  }
      }
      indeks++;
    }
  }
  if (czy_wyk12 & 1) {
  // teraz zamknij stopy, ktore sa zagrozone
  // najpierw dodaj grozby zwiazane z ostatnim ruchem/ostatnimi ruchami do zagrozen
  int ile_g = ang[akt_gleb-1].ile_zagrozen;
  for (int a=0; a<akt_gleb; a++)
    if (ang[a].ktory_teraz != kto) {
      for (int i=0; i<ang[a].grozby.ile; i++)
	ang[akt_gleb-1].zagrozenia[ile_g++] = ang[a].grozby.lista[i];
      // zagrozenia z poprzednich glebokosci tez trzeba dodawac, bo niektore zagr
      // nie beda znalezione pozniej (ze wzgledu na to, ze moga byc uznane za bezs,
      // gdy mamy ruch zamykajacy wszystko, pozycja zs10, wersja 83.43;
      //  ruchy (10,10), (9,6), (9,7) i teraz (10,9) bezs. )
      for (int i=0; i<ang[a].ile_zagrozen; i++) {
	krint indz = ang[a].zagrozenia[i];
	for (int j=0; j<ile_g; j++)
	  if (ang[akt_gleb-1].zagrozenia[j]==indz)
	    goto Juz_bylo;
	ang[akt_gleb-1].zagrozenia[ile_g++] = indz;
      Juz_bylo:;
      }
    }
  unsigned char* plan =plansze.PrzydzielPlansze();
  krint* dad  =skladowe.PrzydzielSkladowa();
  krint* wnetrze =skladowe.PrzydzielSkladowa();
  for (int i=0; i<ile_g; i++) {
    unsigned int ind = ang[akt_gleb-1].zagrozenia[i];
    unsigned int lewo;
    if (rozgrywka[ind] || (ang[akt_gleb].plansz_p[ind] & 3))
      continue;   // zagrozenie nieaktualne
    for (int s=0; s<4; s++) {
      rozgrywka[ind] = ang[akt_gleb-1].ktory_teraz;
      if (PrzejdzWnetrze(rozgrywka, ang[akt_gleb].plansz_p, plan, ind+up.dind[s], lewo, 
			 ang[akt_gleb-1].ktory_teraz)) {
	ZnajdzBrzegStopu(dad, plan, lewo);
	rozgrywka[ind]=0;  // usun kropke
	int zamknieto=0;
	// przejdz brzeg stopu
	{
	  unsigned int pole=lewo;
	  plan[pole]=60;  // zaznacz pole brzegowe
	  do {
	    if (ang[akt_gleb].plansz_p[pole] & maska_wewn_n) {
	      // mozemy zamknac [pole]!
	      ZamknijStopy_pole(rozgrywka, akt_gleb, zap_rozgr, pole);
	      zamknieto=1;
	      // zaznacz reszte kropek brzegowych
	      while (pole!=lewo) {
		plan[pole]=60;  // zaznacz pole brzegowe
		pole=dad[pole];
	      }
	      break;  // kropka [pole] zamknieta...
	    }
	    pole=dad[pole];
	  }
	  while (pole!=lewo);
	}
	if (!zamknieto) {
	  // uratuj zdobycze, ktore sa wewn. przyszlego brzuszka przec
	  for (int x=ang[akt_gleb-1].marg0_min.x; x<=ang[akt_gleb-1].marg0_max.x; x++) {
	    unsigned int indeks = WezIndeksTab(x, ang[akt_gleb-1].marg0_min.y);
	    for (int y=ang[akt_gleb-1].marg0_min.y; y<=ang[akt_gleb-1].marg0_max.y; y++) {
	      if (plan[indeks] && plan[indeks]<60
		  && (ang[akt_gleb].plansz_p[indeks] & maska_wewn_n)) {
		// zamknij pole [indeks]!
		ZamknijStopy_pole(rozgrywka, akt_gleb, zap_rozgr, indeks);
	      }
	      indeks++;
	    }
	  }
	}	  
      }
    }
    rozgrywka[ind]=0;  // usun kropke
  }
  plansze.ZwolnijPlansze(plan);
  skladowe.ZwolnijSkladowa(dad);
  skladowe.ZwolnijSkladowa(wnetrze);
  }
  ang[akt_gleb].byl_stop = (ang[akt_gleb].jest_stop_sstop & 1);
  STOPER_STOP_ZAMS;
}

int WykonajRuchNrJesliMozna(unsigned char *rozgrywka, int akt_gleb, int czy_wyk12,
			    int sprawdzaj_bezs=0)
// zwraca 1, gdy mozna, 0 = nie mozna
// uaktualnia tez historia_sort
// wyjasnienie do czy_wyk12 jest w ZamknijStopy()
{
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  // wez aktualny ruch
  int i = angakt.x =
    upl_x[angakt.lista_ruchow[ angakt.nr_ruchu ]];
  int j = angakt.y =
    upl_y[angakt.lista_ruchow[ angakt.nr_ruchu ]];
  unsigned int indeks = angakt.indeks = 
    angakt.lista_ruchow[ angakt.nr_ruchu ];
  if (sprawdzaj_bezs) {
    int bezs = PoleBezs12(angpop.rozgr3, indeks, 1,   angakt.ktory_teraz);
    if (bezs) {
      TAnaliza::historia_sort[indeks] = bezs-1;  // wywal ruch na koniec lub calkowicie, gdy trwale bezs.
      return 0;  // nie wykonuj ruchu!
    }
  }
  // czy jest sens robic ten ruch?
  if (upl_marg[indeks]==2) {
    // sprawdz, czy kropka kolo pola jest bezpieczna
    int nind;
    if (i==2) nind=indeks+W_P;
    else if (i>wlkx) nind=indeks-wlky-4;
    else if (j==2) nind=indeks+1;
    else nind=indeks-1;
    if (angpop.bandy.bezpieczne[nind]>=2) {
      TAnaliza::historia_sort[indeks]=1;  // wywal ruch na koniec, bo
      return 0;                           // nie ma sensu go wykonywac!
    }
  }
  // czy mozna zrobic ten ruch?
  if (PustePole(rozgrywka, angpop.plansz_p, angpop.rozgr3, indeks)) {
    // mozna!
    angakt.htab_zobr = angpop.htab_zobr;   // przepisz klucz Zobrista
    angakt.zdobycze[0] = angpop.zdobycze[0];   // przepisz
    angakt.zdobycze[1] = angpop.zdobycze[1];   // zdobycze
    angakt.stopy0 = angakt.stopy1 = angpop.stopy1;
    int ile_zd=0, pow=0, pow2=0, ile_zd2=0;
    angakt.byl_stop = angpop.byl_stop;
    angpop.ZapiszRozgr23pp(indeks);
    // uwaga: ponizej jest rozgrywka[], bo ruch w angpop.indeks nie musial byc
    // wykonany przez gracza angpop.ktory_teraz
    // (jeden powod: SortujRuchyA(), ktora wywoluje od razu gleb 2 bez gleb 1,
    //  drugi powod: zrzekanie sie ruchu,
    //  trzeci (przyszly) powod: nullmove)
    int maska_obcego_ss = rozgrywka[angpop.indeks]==1 ? 8:4;
    if (CzyMozliwyStop(angpop.skl_tab, angpop.rozgr2, i,j, angakt.ktory_teraz) ||
	(angpop.plansz_p[angpop.indeks] & maska_obcego_ss)) {
      angakt.plansz_p = angakt.tab_pp;
      angakt.rozgr2 = angakt.tab_r2;
      angakt.rozgr3 = angakt.tab_r3;
      KopiujTablice(angakt.plansz_p, angpop.plansz_p);
      KopiujTablice(angakt.rozgr2  , angpop.rozgr2);
      KopiujTablice(angakt.rozgr3  , angpop.rozgr3);
      int punktacja_ss, ile_domysl;
      if (akt_gleb!=1) {
	angakt.jest_stop_sstop = 
	  ZrobRuch(rozgrywka, NULL, NULL, ile_domysl,
		   NULL, 0, angakt.plansz_p, indeks, angakt.ktory_teraz, angpop.indeks,
		   angakt.zdobycze, ang[akt_gleb].htab_zobr,
		   ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, angakt.rozgr2, angakt.rozgr3) & 3;
      }
      else {
	angakt.jest_stop_sstop = 
	  ZrobRuch(rozgrywka, NULL, &ang[1].stopy_wykonane[ang[1].stopy1], ile_domysl,
		   NULL, 0, angakt.plansz_p, indeks, angakt.ktory_teraz, angpop.indeks,
		   angakt.zdobycze, ang[akt_gleb].htab_zobr,
		   ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, angakt.rozgr2, angakt.rozgr3) & 3;
	ang[1].stopy1 += ile_domysl;
      }
      punktacja_ss = 
	(angakt.zdobycze[angakt.ktory_teraz-1].pss - 
	 angakt.zdobycze[2-angakt.ktory_teraz].pss) -
	(angpop.zdobycze[angakt.ktory_teraz-1].pss - 
	 angpop.zdobycze[2-angakt.ktory_teraz].pss);
      if (angakt.jest_stop_sstop) {
	angakt.byl_stop = (angakt.jest_stop_sstop & 1);
	if (!(TAnaliza::gracz.umiejetnosci & 0x10))  // punktacja_ss (& 0x10) zamiast pow-pow2 (! & 0x10)
	  punktacja_ss = pow-pow2;
	{
	  int punkty = (ile_zd << 11) + (punktacja_ss<<10);
	  TAnaliza::historia_sort[indeks] += (punkty<10000) ? punkty : 10000;
	}
	angakt.zyski  = ((akt_gleb&1) ? TAnaliza::gracz.wagi_n.zd : TAnaliza::gracz.wagi_p.zd)*
	  (TAnaliza::gracz.waga_kropki*ile_zd + punktacja_ss)
	  + angpop.straty;
      }
      else
	angakt.zyski  = angpop.straty;
    }
    else {
      // nie ma stopu, zrob ruch ,,recznie''
      angakt.rozgr2 = angpop.rozgr2;
      angakt.rozgr3 = angpop.rozgr3;
      angakt.plansz_p = angpop.plansz_p;
      PostawKropke(rozgrywka, angakt.rozgr2,  angakt.rozgr3,  angakt.plansz_p,
		   indeks, angakt.ktory_teraz, angakt.zdobycze,
		   angakt.htab_zobr);       // ... i ustaw klucz
      angakt.zyski  = angpop.straty;
      angakt.jest_stop_sstop = 0;
    }
    // przy zasadach gry==2, zamknij stopy, ktore dobrze zamknac w tej chwili
    ZamknijStopy(rozgrywka, akt_gleb, angakt.plansz_p == angpop.plansz_p, czy_wyk12);
    // przepisz straty (zyski juz sa), ustaw oceny na INT_MAX
    angakt.straty    = angpop.zyski;
    angakt.ile_kr_zd_teraz = ile_zd;
    //    angakt.jest_stop_sstop = (ile_zd || pow);
    angakt.ocena     = INT_MAX;
#ifndef TEKSTOWY
    angakt.ost_gleb_max = akt_gleb;
#endif 
    return 1;
  }
  else {
    TAnaliza::historia_sort[indeks]=0;  // wywal ruch na koniec (usun go), bo
    return 0;                           // nie da sie go wykonac
  }
}


void UstawKaryBMnasze(unsigned char *kary, TCiete &ciete, unsigned char *zakazane,
		      const unsigned char *r2, const unsigned char *r3, int ind, int kto, int przec)
// [ind] jest nasza, nieizolowana kropka
{
  if (upl_marg[ind]>=3) {
    if (r3[ind+1]==0) {
      if (r3[ind+W_P]==0 && r3[ind+wlky+5]==0 && (r3[ind-wlky-3]!=przec || r3[ind+wlky+3]!=przec)) {
	// naroznik PD
	if (kary[ind+wlky+5]==0) {
	  kary[ind+wlky+5]=1;  
	  // kiedys ciete.DodajOkrKropkeZOpozn(ind+wlky+5);
	  ciete.DodajKropkeZOpozn(ind+wlky+5, 0);   // 83.42+
	}
	zakazane[ind+1] |= ZAKAZ_PG;      zakazane[ind+W_P] |= ZAKAZ_LD;
      }
      if (r3[ind-wlky-4]==0 && r3[ind-wlky-3]==0 && (r3[ind-wlky-5]!=przec || r3[ind+wlky+5]!=przec)) {
	// naroznik LD
	if (kary[ind-wlky-3]==0) {
	  kary[ind-wlky-3]=1;  
	  // ciete.DodajOkrKropkeZOpozn(ind-wlky-3)
	  ciete.DodajKropkeZOpozn(ind-wlky-3, 0);   // 83.42+
	}
	zakazane[ind+1] |= ZAKAZ_LG;      zakazane[ind-wlky-4] |= ZAKAZ_PD;
      }
      if (kary[ind+1]==0) {
	kary[ind+1]=1;  ciete.DodajOkrKropkeZOpozn(ind+1);
      }
    }
    if (r3[ind-1]==0) {
      if (r3[ind+wlky+3]==0 && r3[ind+W_P]==0 && (r3[ind-wlky-5]!=przec || r3[ind+wlky+5]!=przec)) {
	// naroznik PG
	if (kary[ind+wlky+3]==0) {
	  kary[ind+wlky+3]=1;
	  // ciete.DodajOkrKropkeZOpozn(ind+wlky+3);
	  ciete.DodajKropkeZOpozn(ind+wlky+3, 0);   // 83.42+
	}
	zakazane[ind-1] |= ZAKAZ_PD;      zakazane[ind+W_P] |= ZAKAZ_LG;
      }
      if (r3[ind-wlky-5]==0 && r3[ind-wlky-4]==0 && (r3[ind-wlky-3]!=przec || r3[ind+wlky+3]!=przec)) {
	// naroznik LG
	if (kary[ind-wlky-5]==0) {
	  kary[ind-wlky-5]=1;
	  // ciete.DodajOkrKropkeZOpozn(ind-wlky-5);
	  ciete.DodajKropkeZOpozn(ind-wlky-5, 0);   // 83.42+
	}
	zakazane[ind-1] |= ZAKAZ_LD;      zakazane[ind-wlky-4] |= ZAKAZ_PG;
      }
      if (kary[ind-1]==0) {
	kary[ind-1]=1;  ciete.DodajOkrKropkeZOpozn(ind-1);
      }
    }
    if (r3[ind-wlky-4]==0 && kary[ind-wlky-4]==0)
      { kary[ind-wlky-4]=1;  ciete.DodajOkrKropkeZOpozn(ind-wlky-4); }
    if (r3[ind+W_P]==0 && kary[ind+W_P]==0)
      {	kary[ind+W_P]=1;  ciete.DodajOkrKropkeZOpozn(ind+W_P); }
  }
}

void UstawKaryBM(unsigned char *kary, TCiete &ciete, unsigned char *zakazane,
		 const unsigned char *r2, const unsigned char *r3, 
		 int kto,
		 TDwaUC marg3_min, TDwaUC marg3_max)
// we: r2,r3 -- plansze z rozgrywka (rozgr2, rozgr3 odpowiednio)
//              nie niszczy tych tablic!!!
//              Uwaga: zamiast r2 mozna podac r3, ale wtedy dziala wolniej!
//     (TAnaliza::gracz.testowe & 1) -- redukcja kar kolo mostkow przec
//     (TAnaliza::gracz.testowe & 2) -- wykrywanie hurraoptymistycznych atakow (antyweze) - ZMIENIONE W 83.30 !
//     (TAnaliza::gracz.testowe & 4) -- izolowane kropki tez generuja kary (choc mniejsze)
//     marg3_min, _max -- jaka czesc planszy nalezy obejsc
//                 NIE ZERUJE TABLICY kary NIGDZIE!
//                 Dlatego nalezy wyczyscic kary[] przed wolaniem tej funkcji.
//                 Moze dodac kary w promieniu 1 lub 2 pol od podanego marginesu.
// Funkcja jest ,,lokalna'' w tym sensie, ze jesli dodano kropke na polu (x,y),
// to wystarczy wyczyscic kary[] w kwadracie [x-1,x+1] x [y-1,y+1] i wywolac
// te funkcje w (nieco wiekszym!) kwadracie [x-2,x+2] x [y-2,y+2].
// Dodaje tez kropki do ciete.
// Dodaje rowniez kierunki zakazane.
// Czyszczenie tych kierunkow: po wykonaniu ruchu przec w obszarze [x-2,x+2]x[y-2,y+2].
// (W naszej sytuacji niepotrzebne, bo jako ostatni ruch wykonuje zawsze ,,kto'').
//
// ,,BM'' w nazwie jest skrotem od ,,bez mostkow'' (nazwa nowej f. oceniajacej).
//
// kary: ==0 puste pole bez kary
//       ==1 puste pole, kara +1
//       ==2 puste pole, kara +2  (aktualnie nieuzywane)
//       ==3 kropka przec bez kary
//       ==4 kropka przec, kara +1
//       ==5 pole wewnatrz stopu lub nasza kropka
{
 STOPER_START_KARY;
 int przec=3-kto;
 krint *pola_bez_kary = skladowe.PrzydzielSkladowa();
 int ile_pol_bez_kary=0;
 ciete.RozpocznijDodawanieZOpozn();
 for (int i=marg3_min.x; i<=marg3_max.x; i++)
  {
  unsigned int ind = WezIndeksTab(i,marg3_min.y);
  for (int j=marg3_min.y; j<=marg3_max.y; j++)
    {
      if (r2[ind]==kto) {

	if ( (r3[ind-1]==kto || r3[ind+1]==kto || r3[ind-wlky-4]==kto || r3[ind+W_P]==kto)
	     ||
	     // tutaj: nie ma sasiadow z boku!
	     ((r3[ind-wlky-5]==kto || r3[ind-wlky-3]==kto ||        // sa sasiedzi na ukos
	       r3[ind+wlky+3]==kto || r3[ind+wlky+5]==kto) &&       // (kropka nie jest izolowana)
	      ((TAnaliza::gracz.testowe & 2)==0 ||
	       (r3[ind-1]==przec)+(r3[ind+1]==przec)+(r3[ind-wlky-4]==przec)+(r3[ind+W_P]==przec) < 2)))
	  UstawKaryBMnasze(kary, ciete, zakazane, r2, r3, ind, kto, przec);
	else if ((TAnaliza::gracz.testowe & 4) && 
		 upl_marg[ind]>=3) {   // izolowana kropka nie kolo bandy
	  if (r3[ind-wlky-4]==0 && kary[ind-wlky-4]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind-wlky-4); kary[ind-wlky-4]=1; }
	  if (r3[ind+W_P]==0 && kary[ind+W_P]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind+W_P); kary[ind+W_P]=1; }
	  if (r3[ind-1]==0 && kary[ind-1]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind-1); kary[ind-1]=1; }
	  if (r3[ind+1]==0 && kary[ind+1]==0)
	    { ciete.DodajOkrKropkeZOpozn(ind+1); kary[ind+1]=1; }
	}

	kary[ind]=5;  // nasze kropki ustaw na 5 -- przeciwnik ich nie przechodzi
      }
      else if (r2[ind]==przec)
	{ if (kary[ind]==0) kary[ind]=3; }
      else if (r3[ind])  // tutaj r2[ind]==0, czyli jestesmy wewn. stopu
	kary[ind]=5;
      else   // tutaj wolne pole 
	if (TAnaliza::gracz.testowe & 1) { 
	  if ((r3[ind-wlky-4] & r3[ind-wlky-3] & przec) &&
	      (r3[ind+W_P] & r3[ind+wlky+5] & przec) &&
	      //	      r3[ind+1]!=przec)   // dolne mostki
	      r3[ind+1]==0)   // dolne mostki
	    pola_bez_kary[ile_pol_bez_kary++]=ind;
	  else
	    if ((r3[ind-wlky-4] & r3[ind-wlky-5] & przec) &&
		(r3[ind+W_P] & r3[ind+wlky+3] & przec) &&
		//	      r3[ind-1]!=przec)   // gorne mostki
		r3[ind-1]==0)   // gorne mostki
	      pola_bez_kary[ile_pol_bez_kary++]=ind;
	    else
	      if ((r3[ind-wlky-5] & r3[ind-1] & przec) &&
		  (r3[ind-wlky-3] & r3[ind+1] & przec) &&
		  //	      r3[ind-wlky-4]!=przec)   // lewe mostki
		  r3[ind-wlky-4]==0)   // lewe mostki
		pola_bez_kary[ile_pol_bez_kary++]=ind;
	      else
		if ((r3[ind+wlky+3] & r3[ind-1] & przec) &&
		    (r3[ind+wlky+5] & r3[ind+1] & przec) &&
		    //	      r3[ind+W_P]!=przec)   // prawe mostki
		    r3[ind+W_P]==0)   // prawe mostki
		  pola_bez_kary[ile_pol_bez_kary++]=ind;
	}
      ind++;
    }
  }
 if (TAnaliza::gracz.testowe & 1)
 for (int i=0; i<ile_pol_bez_kary; i++)
   if (kary[pola_bez_kary[i]]) kary[pola_bez_kary[i]]--;
 // for (int i=0; i<ile_pol_bez_kary; i++)
 //   kary[pola_bez_kary[i]]=0;
 skladowe.ZwolnijSkladowa(pola_bez_kary);
 ciete.UaktualnijCiecia();
 STOPER_STOP_KARY;
}



struct TPoziom {     // ta klasa zawiera zmienne sluzace do oceny JEDNEGO z graczy
  unsigned char *zakazane;
  krint         *dod_pola;
  krint         *mostki;  
  unsigned char *kary;
  TCiete        ciete;
  long int      *oceny_skladowych;
  //  krint         *sklnr;
  int           ile_sklnr, ile_sklnr_p;
  long int      ocena;           // ocena!=INT_MAX : byc moze tablice powyzej
  unsigned long long    zobr;    //   zawieraja aktualna informacje (trzeba jeszcze por. zobr)
  // zmienne optymalizacyjne (na gleb o 1 mniejszej)
  unsigned char *zakazane_p; 
  krint         *dod_pola_p;
  krint         *mostki_p;  
  unsigned char *kary_p;
  TCiete        ciete_p;
  int           sa_mostki, sa_zakazane, sa_kary, sa_oceny;         // czy tablice *..._p
  unsigned long long    zobr_p;                                    //   zawieraja aktualna informacje
  // pomocnicze:
  //  krint         *straty_skl;
  krint         *goradol, *goradol_p, *straty_skl_p, *dlugosci_p, *sciezki_p;
  //
  void Ocen(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  void OcenBM(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza const* ang1);
  void OcenBMsciezki(unsigned char *rozgrywka, TAnaliza& ang0, TAnaliza* ang1, int preferuj_sc);
  long int WezPoprawkeNaSklPop(unsigned char *rozgr3, int kto);
  void PrzydzielPamiec();    // przy okazji inicjuje obiekt
  void ZwolnijPamiec();
};


void TPoziom::PrzydzielPamiec()
{
  oceny_skladowych  = tabliceLI.Przydziel();
  zakazane = plansze.PrzydzielPlansze();
  dod_pola = skladowe.PrzydzielSkladowa();
  mostki   = skladowe.PrzydzielSkladowa();
  //  sklnr    = skladowe.PrzydzielSkladowa();
  ocena    = INT_MAX;
  zakazane_p = plansze.PrzydzielPlansze();
  dod_pola_p = skladowe.PrzydzielSkladowa();
  mostki_p   = skladowe.PrzydzielSkladowa();
  sa_mostki = 0;  sa_zakazane=0;  sa_kary=0;
  //  straty_skl = skladowe.PrzydzielSkladowa();
  goradol    = skladowe.PrzydzielSkladowa();
  // na ...BM nie przydzielamy pamieci, bo BM nie korzysta z dod_pola (ani mostki)
  kary   = (unsigned char*) dod_pola;
  kary_p = (unsigned char*) dod_pola_p;
  goradol_p = skladowe.PrzydzielSkladowa();
  straty_skl_p = skladowe.PrzydzielSkladowa();
  dlugosci_p = skladowe.PrzydzielSkladowa();
  sciezki_p = skladowe.PrzydzielSkladowa();
}
void TPoziom::ZwolnijPamiec()
{
  tabliceLI.Zwolnij(oceny_skladowych);
  plansze.ZwolnijPlansze(zakazane);
  skladowe.ZwolnijSkladowa(dod_pola);
  skladowe.ZwolnijSkladowa(mostki);
  //  skladowe.ZwolnijSkladowa(sklnr);
// i optymalizacyjne:
  plansze.ZwolnijPlansze(zakazane_p);
  skladowe.ZwolnijSkladowa(dod_pola_p);
  skladowe.ZwolnijSkladowa(mostki_p);
// pomocnicze:
  //  skladowe.ZwolnijSkladowa(straty_skl);
  skladowe.ZwolnijSkladowa(goradol);
  skladowe.ZwolnijSkladowa(goradol_p);
  skladowe.ZwolnijSkladowa(straty_skl_p);
  skladowe.ZwolnijSkladowa(dlugosci_p);
  skladowe.ZwolnijSkladowa(sciezki_p);
}

void TPoziom::Ocen(unsigned char *rozgrywka,
		   TAnaliza& ang0, TAnaliza const* ang1)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL)
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    STOPER_START_SSTO;
    CzyscTablice(zakazane);
    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
    //    UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
    //		    ang0.ktory_teraz,  ang0.marg0_min, ang0.marg0_max);
    ile_sklnr = 
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0; STOPER_STOP_SSTO; goto Zwolnij_pamiec; }
    // wypelnij mostki od poczatku
    CzyscTablice(mostki);
    ZnajdzMostki12(mostki, ang0.rozgr2, ang0.rozgr3,
		   ang0.marg0_min, ang0.marg0_max,
		   3-ang0.ktory_teraz);
    CzyscTablice(dod_pola);
    if (TAnaliza::gracz.umiejetnosci & 0x20)
      Antyweze(zakazane, dod_pola, ang0.rozgr3, 3-ang0.ktory_teraz,
	       ang0.marg0_min, ang0.marg0_max);
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj zakazanych z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobr.z2)  // czy sa mostki w poprzednim ruchu?
	{ 
        STOPER_START_POPR;
	sa_zakazane=1;   // nie ma, wiec je znajdz
	sa_mostki=0;
	zobr_p=ang1->htab_zobr.z2;
	CzyscTablice(zakazane_p);
	CzyscTablice(dod_pola_p);
	// usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	// moga byc wspolne dla roznych glebokosci
	TZapisR23pp  zapr;
	ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	ang1->OdtworzRozgr23pp();
	ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
//  	UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
//  			ang0.ktory_teraz,  // nie ang1 !
//  			ang1->marg0_min, ang1->marg0_max);

	if (TAnaliza::gracz.umiejetnosci & 0x20)        // to tutaj potrzebne, bo ma wplyw na zakazane
	  Antyweze(zakazane_p, dod_pola_p, ang1->rozgr3,
		   ang1->ktory_teraz,         // nie 3-ktory_gracz!
		   ang1->marg0_min, ang1->marg0_max);
	// odtworz kropki
	ang0.OdtworzRozgr23pp(zapr);
        STOPER_STOP_POPR;
	}
      KopiujTablice(zakazane, zakazane_p);
      KopiujTablice(dod_pola, dod_pola_p);   // to potrzebne, bo czyscimy ...WProstokacie().
      TDwaUC marg_most_min, marg_most_max;
      marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
      marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
      marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
      marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      CzyscZakazaneWProstokacie(zakazane, dod_pola, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);
      // Tu nie trzeba antywezy, pomimo ze one wplywaja na zakazane (bo ten wplyw nie
      // ma znaczenia dla ZnajdzRobakiMatki()).
      ile_sklnr = 
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec; }
      // trzeba jednak ustawic mostki...
      if (!sa_mostki)
	{ 
        STOPER_START_POPR;
	sa_mostki=1;   // nie ma, wiec je znajdz
	//zobr_p=ang1->htab_zobr.z2;   // ta rownosc musi zachodzic
	CzyscTablice(mostki_p);
	// usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	// moga byc wspolne dla roznych glebokosci
	TZapisR23pp  zapr;
	ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	ang1->OdtworzRozgr23pp();
	ZnajdzMostki12(mostki_p, ang1->rozgr2, ang1->rozgr3,
		       ang1->marg0_min, ang1->marg0_max,
		       ang1->ktory_teraz);  // nie 3-ktory_gracz!
	// odtworz kropki
	ang0.OdtworzRozgr23pp(zapr);
        STOPER_STOP_POPR;
	}
      KopiujTablice(mostki, mostki_p);
      ZnajdzMostki12(mostki, ang0.rozgr2, ang0.rozgr3,
		     marg_most_min, marg_most_max,
		     3-ang0.ktory_teraz);
      if (TAnaliza::gracz.umiejetnosci & 0x20)
	Antyweze(zakazane, dod_pola, ang0.rozgr3, 3-ang0.ktory_teraz,
		 marg_most_min, marg_most_max);
    }      
  ocena = 
    OcenSkladowe12(ang0.rozgr2, ang0.rozgr3,
		   goradol, straty_skl, oceny_skladowych,
		   ile_sklnr, zakazane, mostki,
		   ang0.ktory_teraz,
		   ang0.ciete[ang0.ktory_teraz-1],
		   dod_pola, TAnaliza::gracz.funkcja_sk, TAnaliza::gracz.waga_kropki);
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobr.z2;
}

long int TPoziom::WezPoprawkeNaSklPop(unsigned char *rozgr3, int kto)
// kto = kogo ocenialismy (1 lub 2)
{
  long int pop=0;
  for (int i=0; i<ile_sklnr; i++) {
    int gora = goradol[i];
    if (gora && rozgr3[gora]!=kto) pop += oceny_skladowych[i];
    }
  return pop;
}

void TPoziom::OcenBM(unsigned char *rozgrywka,
		     TAnaliza& ang0, TAnaliza const* ang1)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL)
// BM to skrot od ,,bez mostkow''
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    // wypelnij wszystko od poczatku
    STOPER_START_SSTO;
    CzyscTablice(zakazane);

    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
    //      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
    //		      ang0.ktory_teraz,
    //		      ang0.marg0_min, ang0.marg0_max);
    ile_sklnr=
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0; STOPER_STOP_SSTO;  goto Zwolnij_pamiec; }
    CzyscTablice(kary);
    //memcpy(&ciete, &ang0.ciete[ang0.ktory_teraz-1], sizeof(ciete));
    ciete.Skopiuj(ang0.ciete[ang0.ktory_teraz-1]);
    UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz,
		ang0.marg0_min, ang0.marg0_max);
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj tablic z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobr.z2)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_zakazane=1;   // nie ma, wiec je znajdz
  	  sa_kary=0;  sa_oceny=0;
	  zobr_p=ang1->htab_zobr.z2;
	  CzyscTablice(zakazane_p);
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  TZapisR23pp  zapr;
	  ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	  ang1->OdtworzRozgr23pp();
	  ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
	  //	    UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
	  //			    ang0.ktory_teraz,  // nie ang1 !
	  //			    ang1->marg0_min, ang1->marg0_max);
	  // odtworz kropki
	  ang0.OdtworzRozgr23pp(zapr);
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(zakazane, zakazane_p);
      TDwaUC marg_most_min, marg_most_max;
      /*
      if (TAnaliza::gracz.testowe & 3) {  // testowy antywaz   Wydaje sie, ze & 1 jest zupelnie niepotrzebne (83.28-83.30)
	marg_most_min.x = (ang0.x <=6) ? 2 : ang0.x-4;
	marg_most_min.y = (ang0.y <=6) ? 2 : ang0.y-4;
	marg_most_max.x = (ang0.x >=wlkx-3) ? wlkx+1 : ang0.x+4;
	marg_most_max.y = (ang0.y >=wlky-3) ? wlky+1 : ang0.y+4;
      }
      else */
      {
	marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
	marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
	marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
	marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      }
      // mozna by napisac funkcje do czyszczenia zakazanych specjalnie dla BM, teraz trzeba 
      // wpisywac bezsensowne ,,mostki''
      CzyscZakazaneWProstokacie(zakazane, mostki, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);
      ile_sklnr=
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec; }
      // trzeba jednak ustawic kary...
      if (!sa_kary)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_kary=1;   // nie ma, wiec je znajdz
	  //zobr_p=ang1->htab_zobr.z2;   // tutaj juz musi byc rownosc
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  TZapisR23pp  zapr;
	  ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	  ang1->OdtworzRozgr23pp();
	  //memcpy(&ciete_p, &(ang1->ciete[ang0.ktory_teraz-1]), sizeof(ciete_p));
	  ciete_p.Skopiuj(ang1->ciete[ang0.ktory_teraz-1]);
	  CzyscTablice(kary_p);
	  UstawKaryBM(kary_p, ciete_p, zakazane_p, ang1->rozgr2, ang1->rozgr3, ang0.ktory_teraz,
		      ang1->marg0_min, ang1->marg0_max);   // bylo poczatkowo DodajPolaBM()...
	  // odtworz kropki
	  ang0.OdtworzRozgr23pp(zapr);
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(kary, kary_p);
      //memcpy(&ciete, &ciete_p, sizeof(ciete));
      ciete.Skopiuj(ciete_p);
      ciete.DodajKropke(ang0.x, ang0.y, 1);
      /*
      if (TAnaliza::gracz.testowe & 2) {  // testowy antywaz   Chyba & 3, gdy powyzej tez & 3...
	// wyczysc kary w kwadracie 5x5 wokol akt. kropki
	int indeks0 = ang0.indeks-2*wlky-8;
	for (int i=0; i<5; i++) {
	  for (int j=-2; j<=2; j++)
	    kary[indeks0+j] = 0;
	  indeks0 += W_P;
	}
      }
      else */
      {
	// wyczysc kary w kwadracie 3x3 wokol akt. kropki
	for (int i=-wlky-4; i<=W_P; i+=W_P)
	  for (int j=-1; j<=1; j++)
	    kary[ang0.indeks+i+j] = 0;
      }
      UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz, 
		  marg_most_min, marg_most_max);
    }
  for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=INT_MAX;
  ocena = (TAnaliza::gracz.funkcja_sk==4) ?
    OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		   goradol, straty_skl, oceny_skladowych,
		   ile_sklnr, zakazane, 
		   ang0.ktory_teraz,
		   ciete, kary)
    :
    OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, oceny_skladowych, NULL, NULL,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobr.z2;
}

void TPoziom::OcenBMsciezki(unsigned char *rozgrywka,
			    TAnaliza& ang0, TAnaliza* ang1, int preferuj_sc)
// ang0 = akt. glebokosc; nie jest const z uwagi na uakt. robaki
// ang1 = poprzednia glebokosc (moze byc NULL); nie jest const z uwagi na uakt. robaki
// BM to skrot od ,,bez mostkow''
// preferuj_sc = 0 lub 1; gdy 1, to raczej znajdujemy sciezki
{
  krint *straty_skl = skladowe.PrzydzielSkladowa();
  if (ang0.jest_stop_sstop || ang1==NULL) {
    // wypelnij wszystko od poczatku
    STOPER_START_SSTO;
    CzyscTablice(zakazane);

    ang0.robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane, ang0.rozgr3, ang0.skl_tab);
//      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
//  		    ang0.ktory_teraz,
//  		    ang0.marg0_min, ang0.marg0_max);

    ile_sklnr=
      ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							ang0.marg0_min, ang0.marg0_max,
							goradol, straty_skl);
    if (ile_sklnr==0) { ocena=0;  STOPER_STOP_SSTO;  goto Zwolnij_pamiec; }
    CzyscTablice(kary);
    //memcpy(&ciete, &ang0.ciete[ang0.ktory_teraz-1], sizeof(ciete));
    ciete.Skopiuj(ang0.ciete[ang0.ktory_teraz-1]);
    UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz,
		ang0.marg0_min, ang0.marg0_max);
    for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=INT_MAX;
    ocena = (TAnaliza::gracz.funkcja_sk==4) ?
      OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		     goradol, straty_skl, oceny_skladowych,
		     ile_sklnr, zakazane, 
		     ang0.ktory_teraz,
		     ciete, kary)
      :
      OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
			 goradol, straty_skl, oceny_skladowych, NULL, NULL,
			 ile_sklnr, zakazane, 
			 ang0.ktory_teraz,
			 ciete, kary);      
    STOPER_STOP_SSTO;
  }
  else
    {  // uzyj tablic z poprzedniego ruchu
      if (!sa_zakazane || zobr_p!=ang1->htab_zobr.z2)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_zakazane=1;   // nie ma, wiec je znajdz
	  sa_kary=0;   sa_oceny=0;
	  zobr_p=ang1->htab_zobr.z2;
	  CzyscTablice(zakazane_p);
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  TZapisR23pp  zapr;
	  ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	  ang1->OdtworzRozgr23pp();
	  ang1->robaki[ang0.ktory_teraz-1].UstawZakazane(zakazane_p, ang1->rozgr3, ang1->skl_tab);
//  	  UstawZakazane12(zakazane_p, ang1->rozgr3, ang1->skl_tab,
//  			  ang0.ktory_teraz,  // nie ang1 !
//  			  ang1->marg0_min, ang1->marg0_max);

	  // odtworz kropki
	  ang0.OdtworzRozgr23pp(zapr);
	  STOPER_STOP_POPR;
	  }
      KopiujTablice(zakazane, zakazane_p);
      TDwaUC marg_most_min, marg_most_max;
      /*
      if (TAnaliza::gracz.testowe & 3) {  // testowy antywaz   Wydaje sie, ze & 1 jest zupelnie niepotrzebne (83.28-83.30)
	marg_most_min.x = (ang0.x <=6) ? 2 : ang0.x-4;
	marg_most_min.y = (ang0.y <=6) ? 2 : ang0.y-4;
	marg_most_max.x = (ang0.x >=wlkx-3) ? wlkx+1 : ang0.x+4;
	marg_most_max.y = (ang0.y >=wlky-3) ? wlky+1 : ang0.y+4;
      }
      else */
      {
	marg_most_min.x = (ang0.x <=4) ? 2 : ang0.x-2;
	marg_most_min.y = (ang0.y <=4) ? 2 : ang0.y-2;
	marg_most_max.x = (ang0.x >=wlkx) ? wlkx+1 : ang0.x+2;
	marg_most_max.y = (ang0.y >=wlky) ? wlky+1 : ang0.y+2;
      }
      // mozna by napisac funkcje do czyszczenia zakazanych specjalnie dla BM, teraz trzeba 
      // wpisywac bezsensowne ,,mostki''
      CzyscZakazaneWProstokacie(zakazane, mostki, marg_most_min, marg_most_max);
      UstawZakazane12(zakazane, ang0.rozgr3, ang0.skl_tab,
		      ang0.ktory_teraz,
		      marg_most_min, marg_most_max);

      krint *polaczony_z, *dolne_m;
      polaczony_z   = skladowe.PrzydzielSkladowa();
      dolne_m       = skladowe.PrzydzielSkladowa();
      ile_sklnr=
	ang0.robaki[ang0.ktory_teraz-1].ZnajdzRobakiMatki(ang0.plansz_p, zakazane, ang0.bandy.bezpieczne,
							  ang0.marg0_min, ang0.marg0_max,
							  goradol, straty_skl,
							  polaczony_z, dolne_m);
      if (ile_sklnr==0) { ocena=0; goto Zwolnij_pamiec_1; }
      // trzeba jednak ustawic kary i oceny...
      if (!sa_kary)  // czy sa tablice w poprzednim ruchu?
	{ 
	  STOPER_START_POPR;
	  sa_kary=1;   // nie ma, wiec je znajdz
	  //zobr_p=ang1->htab_zobr.z2;   // tutaj juz musi byc rownosc
	  // usun chwilowo kropki, to ma znaczenie, bo tablice na rozgr2,3
	  // moga byc wspolne dla roznych glebokosci
	  TZapisR23pp  zapr;
	  ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
	  ang1->OdtworzRozgr23pp();
	  //memcpy(&ciete_p, &(ang1->ciete[ang0.ktory_teraz-1]), sizeof(ciete_p));
	  ciete_p.Skopiuj(ang1->ciete[ang0.ktory_teraz-1]);
	  CzyscTablice(kary_p);
	  UstawKaryBM(kary_p, ciete_p, zakazane_p, ang1->rozgr2, ang1->rozgr3, ang0.ktory_teraz,
		      ang1->marg0_min, ang1->marg0_max);   // bylo poczatkowo DodajPolaBM()...
	  /*
	  int ile_na_ost;   // ile nowych robakow na ost. gleb. (0 lub 1)
	  {
	    int aktr = ang0.robaki[ang0.ktory_teraz-1].robaki[ang0.indeks];
	    ile_na_ost= (polaczony_z[aktr]!=aktr);   // jesli aktualna kropka nie tworzy nowego robaka-matki
	  }
	  if (ile_sklnr-ile_na_ost + preferuj_sc>=2) 
	  */
	  STOPER_STOP_POPR;    // tutaj stop, bo sciezek i tak nie mozna by znajdowac na 2 gleb. przed ostatnia
	  {
	    ang0.robaki[ang0.ktory_teraz-1].UsunKropke();	  
	    ile_sklnr_p=
	      ang1->robaki[ang0.ktory_teraz-1
	        ].ZnajdzRobakiMatki(ang1->plansz_p, zakazane_p, ang1->bandy.bezpieczne,
				    ang1->marg0_min, ang1->marg0_max,
				    goradol_p, straty_skl_p);
	    ang0.robaki[ang0.ktory_teraz-1].OdtworzKropke();	  
	    if (preferuj_sc+ile_sklnr_p>=2) {
	      sa_oceny=1;
	      if (TAnaliza::gracz.funkcja_sk==4)
		OcenSkladoweBMsciezki(ang1->rozgr2, ang1->rozgr3,
				      goradol_p, straty_skl_p,
				      dlugosci_p, sciezki_p,
				      ile_sklnr_p,
				      zakazane_p, 
				      ang0.ktory_teraz,
				      ciete_p, kary_p);
	      else
		OcenSkladoweBMkaty(ang1->rozgr2, ang1->rozgr3,
				   goradol_p, straty_skl_p,
				   NULL, dlugosci_p, sciezki_p,
				   ile_sklnr_p,
				   zakazane_p, 
				   ang0.ktory_teraz,
				   ciete_p, kary_p);
	    }
	  }
	  // odtworz kropki
	  ang0.OdtworzRozgr23pp(zapr);
	}
      KopiujTablice(kary, kary_p);
      //memcpy(&ciete, &ciete_p, sizeof(ciete));
      ciete.Skopiuj(ciete_p);
      ciete.DodajKropke(ang0.x, ang0.y, 1);
      /*
      if (TAnaliza::gracz.testowe & 2) {  // testowy antywaz   Chyba & 3, gdy powyzej tez & 3...
	// wyczysc kary w kwadracie 5x5 wokol akt. kropki
	int indeks0 = ang0.indeks-2*wlky-8;
	for (int i=0; i<5; i++) {
	  for (int j=-2; j<=2; j++)
	    kary[indeks0+j] = 0;
	  indeks0 += W_P;
	}
      }
      else
      */
      {
	// wyczysc kary w kwadracie 3x3 wokol akt. kropki
	for (int i=-wlky-4; i<=W_P; i+=W_P)
	  for (int j=-1; j<=1; j++)
	    kary[ang0.indeks+i+j] = 0;
      }
      UstawKaryBM(kary, ciete, zakazane, ang0.rozgr2, ang0.rozgr3, ang0.ktory_teraz, 
		  marg_most_min, marg_most_max);
      for (int i=0; i<ile_sklnr; i++) oceny_skladowych[i]=INT_MAX;
      if (sa_oceny) {
	// zaznacz zmienione sciezki
	int zmienione=0;
	{	
	  int indeks0 = ang0.indeks-2*wlky-8;
	  for (int i=0; i<5; i++) {
	    for (int j=-2; j<=2; j++)
	      if (kary[indeks0+j]!=kary_p[indeks0+j])
		zmienione |= sciezki_p[indeks0+j];
	      else {
		int doszly = zakazane[indeks0+j] & ~zakazane_p[indeks0+j];
		if (doszly) {
		  if (doszly & ZAKAZ_LG)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j-wlky-5]);
		  if (doszly & ZAKAZ_PG)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j+wlky+3]);
		  if (doszly & ZAKAZ_LD)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j-wlky-3]);
		  if (doszly & ZAKAZ_PD)
		    zmienione |= (sciezki_p[indeks0+j] & sciezki_p[indeks0+j+wlky+5]);
		}
	      }
	    indeks0 += W_P;
	  }
        }
	// teraz przepisz nie zmienione dlugosci
	int maska=0x8000;
	for (int i=0; i<ile_sklnr_p; i++) {
	  if ((maska<<=1)==0x10000) maska=1;
	  if ((zmienione & maska)==0) {
	    int kr = goradol_p[i];
	    if (kr==0) continue;
	    int nkr = dolne_m[polaczony_z[ang0.robaki[ang0.ktory_teraz-1].robaki[kr]]];
	    for (int j=0; j<ile_sklnr; j++)
	      if (goradol[j]==nkr) { 
		oceny_skladowych[j]=OcenSkladowaBM(straty_skl[j], dlugosci_p[i], TAnaliza::gracz.funkcja_sk);
	      break;
	      }
	  }
	}
      }

      ocena = (TAnaliza::gracz.funkcja_sk==4) ?
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, oceny_skladowych,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary)
	:
	OcenSkladoweBMkaty(ang0.rozgr2, ang0.rozgr3,
			   goradol, straty_skl, oceny_skladowych, NULL, NULL,
			   ile_sklnr, zakazane, 
			   ang0.ktory_teraz,
			   ciete, kary);

      /*
      {
      long int *test = tabliceLI.Przydziel();
      for (int i=0; i<ile_sklnr; i++) test[i]=INT_MAX;
      long int ocena_test = 
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, test,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);
      for (int i=0; i<ile_sklnr; i++)
	if (test[i]!=oceny_skladowych[i]) {
	  printf("Jest %ld, powinno byc %ld.",oceny_skladowych[i], test[i]);
	  if (test[i]==0 || oceny_skladowych==0)
	    printf(" POWAZNY BLAD!\n");
	  else printf("\n");
	}

      for (int i=0; i<ile_sklnr; i++) test[i]=INT_MAX;
      ocena_test = 
	OcenSkladoweBM(ang0.rozgr2, ang0.rozgr3,
		       goradol, straty_skl, test,
		       ile_sklnr, zakazane, 
		       ang0.ktory_teraz,
		       ciete, kary);

      tabliceLI.Zwolnij(test);
      }
      */

    Zwolnij_pamiec_1:;
      skladowe.ZwolnijSkladowa(polaczony_z);
      skladowe.ZwolnijSkladowa(dolne_m);
    }
 Zwolnij_pamiec:;
  skladowe.ZwolnijSkladowa(straty_skl);
  zobr = ang0.htab_zobr.z2;
}


int Ocena_PromieniowanieBandy(const unsigned char *rozgr3, const unsigned char *bezpieczne,
			      int kto_na_ruchu,
			      unsigned char *pr0 = NULL, unsigned char *pr1 = NULL)
// zwraca punkty (dla gracza 0) za opanowanie bandy
// (plansze musza miec margines co najmniej 1)
// kto_na_ruchu == 1 lub 2, gracz na ruchu nie ma kary za kropki pol-bezpieczne
// dla celow testowych mozna pobrac tablice promien[0] i [1]
{
  unsigned char *promien[2];    // promieniowanie kropek gracza 0,1
  if (pr0!=NULL && pr1!=NULL)
    { promien[0] = pr0;  promien[1]=pr1; }
  else {
    promien[0] = plansze.PrzydzielPlansze();  promien[1] = plansze.PrzydzielPlansze();
  }
  CzyscTablice(promien[0]);  CzyscTablice(promien[1]);
  // dolna i gorna banda
  for (int i=3; i<=wlkx; i++) {
    unsigned int ind = WezIndeksTab(i, 2);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_D] |= 16;
      promien[ rozgr3[ind]-1 ][ind+W_LD] |= 8;
      promien[ rozgr3[ind]-1 ][ind+W_PD] |= 8;
      //      promien[ rozgr3[ind]-1 ][ind+W_LLD] |= 2;
      //      promien[ rozgr3[ind]-1 ][ind+W_PPD] |= 2;
    }
    ind = WezIndeksTab(i, wlky+1);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_G] |= 16;
      promien[ rozgr3[ind]-1 ][ind+W_LG] |= 8;
      promien[ rozgr3[ind]-1 ][ind+W_PG] |= 8;
      //      promien[ rozgr3[ind]-1 ][ind+W_LLG] |= 2;
      //      promien[ rozgr3[ind]-1 ][ind+W_PPG] |= 2;
    }
  }
  // lewa i prawa banda
  for (int j=3; j<=wlky; j++) {
    unsigned int ind = WezIndeksTab(2, j);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_P] |= 16;
      promien[ rozgr3[ind]-1 ][ind+W_PD] |= 8;
      promien[ rozgr3[ind]-1 ][ind+W_PG] |= 8;
      //      promien[ rozgr3[ind]-1 ][ind+W_PDD] |= 2;
      //      promien[ rozgr3[ind]-1 ][ind+W_PGG] |= 2;
    }
    ind = WezIndeksTab(wlkx+1, j);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_L] |= 16;
      promien[ rozgr3[ind]-1 ][ind+W_LD] |= 8;
      promien[ rozgr3[ind]-1 ][ind+W_LG] |= 8;
      //      promien[ rozgr3[ind]-1 ][ind+W_LDD] |= 2;
      //      promien[ rozgr3[ind]-1 ][ind+W_LGG] |= 2;
    }
  }
  // w odl. 1 od bandy: dol i gora
  for (int i=3; i<=wlkx; i++) {
    unsigned int ind = WezIndeksTab(i, 3);
    if (rozgr3[ind]!=0 && bezpieczne[ind]) {
      int przesun_o = 0;
      if (bezpieczne[ind]==1 && rozgr3[ind]!=kto_na_ruchu)
	przesun_o = 1;   // o tyle przesuwamy w prawo, gdy sa pol-bezpieczne
      promien[ rozgr3[ind]-1 ][ind+W_L] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_P] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_LL] |= (4 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_PP] |= (4 >> przesun_o);
    }
    ind = WezIndeksTab(i, wlky);
    if (rozgr3[ind]!=0) {
      int przesun_o = 0;
      if (bezpieczne[ind]==1 && rozgr3[ind]!=kto_na_ruchu)
	przesun_o = 1;
      promien[ rozgr3[ind]-1 ][ind+W_L] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_P] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_LL] |= (4 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_PP] |= (4 >> przesun_o);
    }
  }
  // w odl. 1 od bandy: lewo i prawo
  for (int j=3; j<=wlky; j++) {
    unsigned int ind = WezIndeksTab(3, j);
    if (rozgr3[ind]!=0 && bezpieczne[ind]) {
      int przesun_o = 0;
      if (bezpieczne[ind]==1 && rozgr3[ind]!=kto_na_ruchu)
	przesun_o = 1;
      promien[ rozgr3[ind]-1 ][ind+W_D] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_G] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_DD] |= (4 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_GG] |= (4 >> przesun_o);
    }
    ind = WezIndeksTab(wlkx, j);
    if (rozgr3[ind]!=0 && bezpieczne[ind]) {
      int przesun_o = 0;
      if (bezpieczne[ind]==1 && rozgr3[ind]!=kto_na_ruchu)
	przesun_o = 1;
      promien[ rozgr3[ind]-1 ][ind+W_D] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_G] |= (16 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_DD] |= (4 >> przesun_o);
      promien[ rozgr3[ind]-1 ][ind+W_GG] |= (4 >> przesun_o);
    }
  }  
  // w odl. 2 od bandy: dol i gora
  for (int i=4; i<wlkx; i++) {
    unsigned int ind = WezIndeksTab(i, 4);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_G] |= 4;
      promien[ rozgr3[ind]-1 ][ind+W_LG] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_PG] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_LLG] |= 1;
      promien[ rozgr3[ind]-1 ][ind+W_PPG] |= 1;
    }
    ind = WezIndeksTab(i, wlky-1);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_D] |= 4;
      promien[ rozgr3[ind]-1 ][ind+W_LD] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_PD] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_LLD] |= 1;
      promien[ rozgr3[ind]-1 ][ind+W_PPD] |= 1;
    }
  }
  // w odl. 2 od bandy: lewo i prawo
  for (int j=4; j<wlky; j++) {
    unsigned int ind = WezIndeksTab(4, j);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_L] |= 4;
      promien[ rozgr3[ind]-1 ][ind+W_LD] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_LG] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_LDD] |= 1;
      promien[ rozgr3[ind]-1 ][ind+W_LGG] |= 1;
    }
    ind = WezIndeksTab(wlkx-1, j);
    if (rozgr3[ind]!=0) {
      promien[ rozgr3[ind]-1 ][ind+W_P] |= 4;
      promien[ rozgr3[ind]-1 ][ind+W_PD] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_PG] |= 2;
      promien[ rozgr3[ind]-1 ][ind+W_PDD] |= 1;
      promien[ rozgr3[ind]-1 ][ind+W_PGG] |= 1;
    }
  }
  // utworz liste pol w odl. 1 od bandy
  krint *lista = skladowe.PrzydzielSkladowa();
  int ile=0;
  for (int i=3; i<=wlkx; i++) {
    lista[ile++] = WezIndeksTab(i, 3);
    lista[ile++] = WezIndeksTab(i, wlky);
  }
  for (int j=4; j<wlky; j++) {
    lista[ile++] = WezIndeksTab(3, j);
    lista[ile++] = WezIndeksTab(wlkx, j);
  }
  // teraz licz punkty za promieniowanie    
  int punkty = 0;
  for (int i=0; i<ile; i++) {
    int pole = lista[i];
    if (rozgr3[pole]==0 && (promien[0][pole] | promien[1][pole]) > 0) {
      // kto ma wieksze promieniowanie?
      while ((promien[0][pole] | promien[1][pole]) > 1) {
	promien[0][pole] >>=1;
	promien[1][pole] >>=1;
      }
      if (promien[0][pole] > promien[1][pole])
	punkty++;
      else if (promien[0][pole] < promien[1][pole])
	punkty--;
    }
  }
  skladowe.ZwolnijSkladowa(lista);
  if (pr0==NULL || pr1==NULL) {
    plansze.ZwolnijPlansze(promien[0]);  plansze.ZwolnijPlansze(promien[1]);
  }
  return punkty;
}

class TOcenaLFO {
  signed char *punkty;
  int ocena_p, jest_ocena;
  static signed char tabocen[256];
  unsigned long long    zobr;
  inline signed char OcenPole(const unsigned char *rozgr3, int indeks);
  void  UstawPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max);
  int  ObliczPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max);
public:
  void Przydziel();
  void Zwolnij();
  void Zeruj() { jest_ocena=0; };
  long int Ocen(const TAnaliza& ang0, const TAnaliza* ang1);
};

signed char TOcenaLFO::tabocen[256] = {
 0, 1,-1, 0,  1, 2, 0, 0, -1, 0,-2, 0,  0, 0, 0, 0,
 1, 2, 0, 0,  2, 5, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
-1, 0,-2, 0,  0, 0,-1, 0, -2, 0,-5, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 1, 2, 0, 0,  2, 5, 1, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 2, 5, 0, 0,  5, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0,-1, 0,  1, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
-1, 0,-2, 0,  0, 0, 0, 0, -2,-1,-5, 0,  0, 0, 0, 0,
 0, 1, 0, 0,  0, 0, 0, 0, -1, 0, 0, 0,  0, 0, 0, 0,
-2, 0,-5, 0,  0, 0, 0, 0, -5, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
};

  
inline signed char TOcenaLFO::OcenPole(const unsigned char *rozgr3, int indeks)
{
  if (rozgr3[indeks]==0) {
    int nr = (int(rozgr3[indeks-1]) << 6) | (rozgr3[indeks+W_P] << 4) | (rozgr3[indeks+1] << 2) | rozgr3[indeks-wlky-4];
    return tabocen[nr];
  }
  else return 0;
}

void  TOcenaLFO::UstawPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max)
{
  if (marg_min.x>=3) marg_min.x--;
  if (marg_min.y>=3) marg_min.y--;
  if (marg_max.x<=wlkx) marg_max.x++;
  if (marg_max.y<=wlky) marg_max.y++;
  CzyscTablice((unsigned char*) punkty);
  ocena_p=0;
  for (int i=marg_min.x; i<=marg_max.x; i++) {
    unsigned int ind = WezIndeksTab(i, marg_min.y);
    for (int j=marg_min.y; j<=marg_max.y; j++) {
      ocena_p += punkty[ind] = OcenPole(rozgr3, ind);
      ind++;
    }
  }
}

int  TOcenaLFO::ObliczPunkty(const unsigned char *rozgr3, TDwaUC marg_min, TDwaUC marg_max)
{
  if (marg_min.x>=3) marg_min.x--;
  if (marg_min.y>=3) marg_min.y--;
  if (marg_max.x<=wlkx) marg_max.x++;
  if (marg_max.y<=wlky) marg_max.y++;
  int ocena=0;
  for (int i=marg_min.x; i<=marg_max.x; i++) {
    unsigned int ind = WezIndeksTab(i, marg_min.y);
    for (int j=marg_min.y; j<=marg_max.y; j++) {
      ocena += OcenPole(rozgr3, ind);
      ind++;
    }
  }
  return ocena;
}


void TOcenaLFO::Przydziel()
{  punkty = (signed char*) plansze.PrzydzielPlansze(); }

void TOcenaLFO::Zwolnij()
{  plansze.ZwolnijPlansze((unsigned char*) punkty); }

long int TOcenaLFO::Ocen(const TAnaliza& ang0, const TAnaliza* ang1)
{
  long int ocena;
  if (ang1==NULL || ang0.jest_stop_sstop)
    ocena = ObliczPunkty(ang0.rozgr3, ang0.marg0_min, ang0.marg0_max);
  else {
    if (!jest_ocena || zobr!=ang1->htab_zobr.z2)  // czy jest ocena w poprzednim ruchu?
      { jest_ocena=1;   // nie ma, wiec ja znajdz
	zobr=ang1->htab_zobr.z2;
	UstawPunkty(ang1->rozgr3, ang1->marg0_min, ang1->marg0_max);
      }
    unsigned int ind = ang0.indeks;
    ocena = ocena_p - (punkty[ind-wlky-4] + punkty[ind-1] + punkty[ind] + punkty[ind+1] + punkty[ind+W_P])
      + int(OcenPole(ang0.rozgr3, ind-wlky-4)) + int(OcenPole(ang0.rozgr3, ind-1))
      + int(OcenPole(ang0.rozgr3, ind+1))      + int(OcenPole(ang0.rozgr3, ind+W_P));
  }
  return (ang0.ktory_teraz==1) ? ocena : -ocena;
}


class TOcenaSkl12 {
  TPoziom poz[2];   // poc[0]: oceny na [ost], poc[1]: oceny na [ost-1]
  TOcenaLFO ocenalfo;
public:
  long int OcenPozycje12(unsigned char *rozgrywka, int ostatni_to_ja, 
			 TAnaliza& ang0, TAnaliza& ang1, TAnaliza *ang2, int sciezki);
  long int OcenPozycje12TylkoTaGleb(unsigned char *rozgrywka, int ostatni_to_ja, 
				    TAnaliza& ang0, const TAnaliza& ang1);
  void PrzydzielPamiec();
  void Zeruj();
  void ZwolnijPamiec();
}
osk12;

void TOcenaSkl12::PrzydzielPamiec()
{
  poz[0].PrzydzielPamiec();
  poz[1].PrzydzielPamiec();
  ocenalfo.Przydziel();
}
void TOcenaSkl12::ZwolnijPamiec()
{
  poz[0].ZwolnijPamiec();
  poz[1].ZwolnijPamiec();
  ocenalfo.Zwolnij();
}
void TOcenaSkl12::Zeruj()
{ poz[0].ocena = INT_MAX;  poz[1].ocena = INT_MAX;
  poz[0].sa_mostki=0;      poz[1].sa_mostki=0; 
  poz[0].sa_zakazane=0;    poz[1].sa_zakazane=0;   
  poz[0].sa_kary=0;        poz[1].sa_kary=0;
  ocenalfo.Zeruj();
} 


long int TOcenaSkl12::OcenPozycje12(unsigned char *rozgrywka, int ostatni_to_ja, 
				    TAnaliza& ang0, TAnaliza& ang1, TAnaliza* ang2,
				    int sciezki)
// ang0: ostatnia gleb, ang1: przedostatnia, ang2: przed-przedostatnia
// Moze byc ang2==NULL, co oznacza, ze jestesmy na glebokosci 1.
// Zmienna ostatni_to_ja mowi, czy ostatnim graczem jest ten, dla ktorego analizujemy,
// czyli ang[1].ktory_teraz; ostatni_to_ja == (akt_gleb & 1), gdzie akt_gleb to gleb. oceny;
// lub ostatni_to_ja == (ang[akt_gleb].ktory_teraz == ang[1].ktory_teraz).
// sciezki: -1 -> nie uzywaj w ogole OcenBMsciezki(),
//           0 -> uzywaj OcenBMsciezki(), ale nie znajduj sciezek, gdy malo skladowych
//           1 -> uzywaj OcenBMsciezki(); nie bedzie ciecia beta, wiec raczej znajdz sciezki
{ 
  long int ocena_Bo;
  if (TAnaliza::gracz.Bouzy_dil) {
    if (ang[0].ktory_teraz==2) {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_n.Bo, TAnaliza::gracz.wagi_p.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (!ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
    else {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_p.Bo, TAnaliza::gracz.wagi_n.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
  }
  else ocena_Bo=0;
  if (TAnaliza::gracz.Bouzy_er) {
    int ocpb = 
      Ocena_PromieniowanieBandy(ang0.rozgr3, ang0.bandy.bezpieczne, ang[1].ktory_teraz);
    if (ang[0].ktory_teraz==2 ? (!ostatni_to_ja) : ostatni_to_ja) ocpb = -ocpb;
    ocena_Bo += ocpb * TAnaliza::gracz.wagi_n.Bo;
  }
  if (TAnaliza::gracz.waga_latwe_pole)
    ocena_Bo += int(TAnaliza::gracz.waga_latwe_pole) * ocenalfo.Ocen(ang0, &ang1);
  if (TAnaliza::gracz.funkcja_sk) {
  // wez ocene skladowych drugiego gracza
  if (poz[1].ocena == INT_MAX || poz[1].zobr!=ang1.htab_zobr.z2) {
    // trzeba jednak ocenic...
    // usun kropke z rozgr2,3, rozgrywka (przed analiza o 1 plycej)
    TZapisR23pp  zapr;
    ang0.ZapiszRozgr23pp(zapr, ang0.indeks);
    ang1.OdtworzRozgr23pp();
    rozgrywka[ ang0.indeks ]=0;
    //
    switch (TAnaliza::gracz.funkcja_sk) {
    case 2:
    case 3:
      poz[1].Ocen(rozgrywka, ang1, ang2);
      break;
    case 4:
    case 5:     // funkcja T - inny algorytm okrazania
      if (sciezki>=0)
	poz[1].OcenBMsciezki(rozgrywka, ang1, ang2, sciezki);
      else
	poz[1].OcenBM(rozgrywka, ang1, ang2);
      break;
    }
    // odtworz kropke w rozgr2,3, rozgrywka (po ew. analiza o 1 plycej)
    ang0.OdtworzRozgr23pp(zapr);
    rozgrywka[ ang0.indeks ]=ang0.ktory_teraz;
  }

  // teraz ocena dla nas
  switch (TAnaliza::gracz.funkcja_sk) {
  case 2:
  case 3:
    poz[0].Ocen(rozgrywka, ang0, &ang1);
    break;
  case 4:
  case 5:     // funkcja T - inny algorytm okrazania
    if (sciezki>=0)
      poz[0].OcenBMsciezki(rozgrywka, ang0, &ang1, sciezki);
    else
      poz[0].OcenBM(rozgrywka, ang0, &ang1);
    break;
  }
  // jesli zdobylismy teraz jakies kropki, to ocena_skl_pop wymaga
  // poprawki (trzeba anulowac oceny zamknietych wlasnie skladowych)
  long int ocena;
  long int ocena_skl_pop = poz[1].ocena;
  long int ocena_skl     = poz[0].ocena;

  if (ang0.ile_kr_zd_teraz)
    ocena_skl_pop -= 
      poz[1].WezPoprawkeNaSklPop(ang0.rozgr3, ang1.ktory_teraz);
      //    ang1.robaki[ang1.ktory_teraz-1].WezPoprawkeNaSklPop(ang0.rozgr3, poz[1].oceny_skladowych);
  // oblicz ocene pozycji z punktu widzenia akt. gracza
  if (ostatni_to_ja)   // ocena dla komputera
    ocena = TAnaliza::gracz.wagi_n.sk*ocena_skl - ang0.straty
      - TAnaliza::gracz.wagi_p.sk*ocena_skl_pop + ang0.zyski;
  else  // ocena dla przeciwnika -- dlatego minus...
    ocena = -TAnaliza::gracz.wagi_n.sk*ocena_skl_pop + ang0.zyski +
      TAnaliza::gracz.wagi_p.sk*ocena_skl - ang0.straty;
  return ocena+ocena_Bo;
  }
  else
    return ocena_Bo + ang0.zyski - ang0.straty;
}

long int TOcenaSkl12::OcenPozycje12TylkoTaGleb(unsigned char *rozgrywka, int ostatni_to_ja, 
					       TAnaliza& ang0, const TAnaliza& ang1)
// jak OcenPozycje12(), ale ocenia tylko ang0
{
  long int ocena_Bo;
  if (TAnaliza::gracz.Bouzy_dil) {
    if (ang[0].ktory_teraz==2) {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_n.Bo, TAnaliza::gracz.wagi_p.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (!ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
    else {
      ocena_Bo =
	Bouzy(NULL, ang0.rozgr2,
	      ang0.rozgr3, ang0.marg0_min, ang0.marg0_max,
	      TAnaliza::gracz.Bouzy_dil, TAnaliza::gracz.Bouzy_er,
	      TAnaliza::gracz.wagi_p.Bo, TAnaliza::gracz.wagi_n.Bo,
	      (TAnaliza::gracz.opcje_Bouzy & 1));
      if (ostatni_to_ja) ocena_Bo=-ocena_Bo;
    }
  }
  else ocena_Bo=0;
  if (TAnaliza::gracz.waga_latwe_pole)
    ocena_Bo += int(TAnaliza::gracz.waga_latwe_pole) * ocenalfo.Ocen(ang0, &ang1);
  int funkcja_sk = TAnaliza::gracz.funkcja_sk ? TAnaliza::gracz.funkcja_sk : 3;    // wez ./x, gdy brak f.oc.
  // teraz ocena dla nas
  switch (funkcja_sk) {
  case 2:
  case 3:
    poz[0].Ocen(rozgrywka, ang0, &ang1);
    break;
  case 4:
  case 5:     // funkcja T - inny algorytm okrazania
    poz[0].OcenBM(rozgrywka, ang0, &ang1);
    break;
  }
  long int ocena;
  long int ocena_skl_pop = 0;
  long int ocena_skl     = poz[0].ocena;
  // oblicz ocene pozycji z punktu widzenia akt. gracza
  if (ostatni_to_ja)   // ocena dla komputera
    ocena = TAnaliza::gracz.wagi_n.sk*ocena_skl - ang0.straty
      - TAnaliza::gracz.wagi_p.sk*ocena_skl_pop + ang0.zyski;
  else  // ocena dla przeciwnika -- dlatego minus...
    ocena = -TAnaliza::gracz.wagi_n.sk*ocena_skl_pop + ang0.zyski +
      TAnaliza::gracz.wagi_p.sk*ocena_skl - ang0.straty;
  return ocena+ocena_Bo;
}


void TAnaliza::InicjujCiecia(unsigned char *rozgr)
// inicjuje ciete[0-1]
// zakladamy, ze rozgr nie jest pusta!
// TRZEBA UWAZAC na sytuacje, w ktorej wszystkie kropki leza na bandzie!
// (ale to istotne tylko wtedy, gdy jeden z graczy nie postawil jeszcze kropki)
// Nalezy wywolac z rozgr3!!
{
  unsigned char *bezp = plansze.PrzydzielPlansze();
  {
    CzyscTablice(bezp);
    int dind[4] = {-wlky-4,-1,1,W_P};
    // ustaw wewnetrzne bezpieczne
    for (int i=up.lg; i<=up.pd; i++)
      if (bezp_na_zawsze[i]) {
	int ile_sasiadow = 0;
	for (int k=0; k<4; k++)
	  ile_sasiadow += (bezp_na_zawsze[i+dind[k]]>0 || upl_marg[i+dind[k]]==1);
	bezp[i]= 1 + (ile_sasiadow==4);
      }
  }
  // bezp juz gotowe
  for (int i=0; i<2; i++) {
    ciete[i].Zeruj();
    ciete[i].RozpocznijDodawanieZOpozn();
  }
  /* bez wykorzystania bezp:
  for (int i=up.lg; i<=up.pd; i++)
    if (rozgr[i]) {
      ciete[0].DodajKropkeZOpozn(i, (rozgr[i]==1) );
      ciete[1].DodajKropkeZOpozn(i, (rozgr[i]==2) );
    }
  */
  for (int i=up.lg; i<=up.pd; i++)
    if (rozgr[i])
      if (bezp[i]==0){
	ciete[0].DodajKropkeZOpozn(i, (rozgr[i]==1) );
	ciete[1].DodajKropkeZOpozn(i, (rozgr[i]==2) );
      }
      else if (bezp[i]==1)
	ciete[2-rozgr[i]].DodajKropkeZOpozn(i,0);
  ciete[0].UaktualnijCiecia();   ciete[1].UaktualnijCiecia();
  plansze.ZwolnijPlansze(bezp);
}

void ZnajdzListeRuchow12(unsigned char *rozgrywka, unsigned char *plansz_p,
			 unsigned char *rozgr2, unsigned char *rozgr3,
			 krint *skl_tab, 
			 TDwaUC marg_min[4], TDwaUC marg_max[4],
			 int &ile_ruchow, int &ile_ruchow_przec,
			 krint *kolejne_ruchy,  krint *ruchy_przec,
			 unsigned char *schemat_ruchow,
			 const TGraczO &gracz,
			 int ktory_gracz)
// we: rozgrywka, plansz_p
//     pozostale tablice zostana wypelnione, ALE trzeba na nie przydzielic
//     pamiec na zewnatrz funkcji
// Ustawia tez ang[1].zagrozenia i ang[1].ile_zagrozen.
//           i ang[0].zagrozenia, ang[0].ile_zagrozen.
{
  // przydziel pamiec
  krint *zagrozenia  = skladowe.PrzydzielSkladowa();
  krint *szanse      = skladowe.PrzydzielSkladowa();
  unsigned char* dod_inf = plansze.PrzydzielPlansze();
  unsigned char* ile_razy= plansze.PrzydzielPlansze();
  unsigned char* plansz_p_arg = plansze.PrzydzielPlansze();
  unsigned char* rozgrywka_arg = plansze.PrzydzielPlansze();
  KopiujTablice(plansz_p_arg, plansz_p);
  KopiujTablice(rozgrywka_arg, rozgrywka);
  krint *obszar = skladowe.PrzydzielSkladowa();
  unsigned char *bezs = plansze.PrzydzielPlansze();

  // przygotuj plansze z rozgrywka, usuwajac (rozgr2)
  //  lub wstawiajac (rozgr3) kropki wewnatrz stopow
  WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
  // przygotuj tablice z numerami skladowych
  CzyscTablice(skl_tab);
  marg_min[0] = TDwaUC(wlkx+2, wlky+2), marg_max[0] = TDwaUC(0,0);
  int maska_naszego_stopu = ktory_gracz==1 ? 4+1:8+2;
  int maska_stopu_przec   = (maska_naszego_stopu ^ 0xf);
  {
    unsigned int num_skl_n=1;
    unsigned int num_skl_p=30001;
    TDwaUC p;
    for (p.x=2; p.x<wlkx+2; p.x++)
      for (p.y=2; p.y<wlky+2; p.y++)
	{
	  unsigned int indeks_ij = WezIndeksTab(p.x,p.y);
	  unsigned char kr=rozgr2[indeks_ij];
	  if (kr!=0)
	    {
	      if (p.x<marg_min[0].x) marg_min[0].x=p.x;
	      if (p.y<marg_min[0].y) marg_min[0].y=p.y;
	      if (p.x>marg_max[0].x) marg_max[0].x=p.x;
	      if (p.y>marg_max[0].y) marg_max[0].y=p.y;
	      if (skl_tab[indeks_ij]==0)
		if (kr==ktory_gracz)
		  ZnajdzSkladowa(skl_tab, rozgr2, num_skl_n++, indeks_ij);
		else
		  ZnajdzSkladowa(skl_tab, rozgr2, num_skl_p++, indeks_ij);
	    }
	}
  }
  // wez margines na jedno, dwa, trzy pola
  for (int i=1; i<4; i++)
    {
      marg_min[i].x = (marg_min[i-1].x>2) ? (marg_min[i-1].x-1) : 2;
      marg_max[i].x = (marg_max[i-1].x<=wlkx) ? (marg_max[i-1].x+1) : wlkx+1;
      marg_min[i].y = (marg_min[i-1].y>2) ? (marg_min[i-1].y-1) : 2;
      marg_max[i].y = (marg_max[i-1].y<=wlky) ? (marg_max[i-1].y+1) : wlky+1;
    }
  // znajdz zagrozenia
  // tablica dod_inf (dodatkowe informacje) -- znaczenie bitow:
  //   & 1  -- stawiajac tu kropke przeciwnik ma staly stop
  //   & 2  -- stawiajac tu kropke przeciwnik ma stop
  //   & 4  -- to pole moge zamknac natychmiast
  //           (czyli tu przeciwnik nie powinien stawiac kropki)
  //   & 8  -- stawiajac tu kropke mam stop (staly lub zwykly)
  //   & 16 -- to pole moze zostac natychmiast zamkniete przez przeciwnika
  //           (czyli tu nie powinienem stawiac kropki)
  //   & 32 -- ten ruch jest ,,ciekawy'' (zagrozenie lub szansa)
  //   & 64 -- jest w tablicy ruchy_przec[]
  //   & 128-- jest w tablicy kolejne_ruchy[]
  CzyscTablice(dod_inf);
  CzyscTablice(ile_razy);
  int ile_zagrozen=0;
  int ile_szans=0;
  int moga_byc_nieunikn=0;
  {
  for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
    for (int j=marg_min[1].y; j<=marg_max[1].y; j++){
      unsigned int indeks_ij = WezIndeksTab(i,j);
      if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij) && 
	  CzyMozliwyStop(skl_tab, rozgr2, i,j, 3-ktory_gracz)) {
	int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	TZdobycze wynik[2];  TZobrist zobr;
	unsigned char zap_pp = plansz_p[indeks_ij];
	int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz, wynik, zobr,
			    ile_zd,pow,pow2,punktacja_ss) & 3);
	rozgrywka[indeks_ij]=0;  // usun kropke
	if (ile_zd>0 || pow>0) {
	  zagrozenia[ile_zagrozen++]=indeks_ij;
	  if (pow>0)    dod_inf[indeks_ij]|=33;
	  if (ile_zd>0) dod_inf[indeks_ij]|=34;
	}
	if (js) {
	  for (int i=up.lg; i<=up.pd; i++)
	    if (plansz_p[i]!=plansz_p_arg[i]) {
	      if (plansz_p[i] & maska_stopu_przec) {   // czy wewn. stopu (moze byc nie, jesli przec wstawia kropke
		dod_inf[i]|=16;                        // do brzuszka
		if (ile_razy[i]<255) {
		  ile_razy[i]++;
		  if (!moga_byc_nieunikn)
		    moga_byc_nieunikn = (ile_razy[i] >= 2);
		}
	      }
	      plansz_p[i]=plansz_p_arg[i];
	    }
	}
	else plansz_p[indeks_ij] = zap_pp;
      }
    }
  }
  if (!moga_byc_nieunikn || gracz.dokl_analizy==1) {   // nieuniknione darujemy sobie na gleb==1
    // na pewno nie ma nieuniknionych zagrozen -- tylko znajdz szanse
    for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
      for (int j=marg_min[1].y; j<=marg_max[1].y; j++) {
	unsigned int indeks_ij = WezIndeksTab(i,j);
	if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij) && 
	    CzyMozliwyStop(skl_tab, rozgr2, i,j, ktory_gracz)) {
	  int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	  TZdobycze wynik[2];  TZobrist zobr;
	  unsigned char zap_pp = plansz_p[indeks_ij];
	  int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz, wynik, zobr,
			      ile_zd,pow,pow2, punktacja_ss) & 3);
	  rozgrywka[indeks_ij]=0;  // usun kropke
	  if (ile_zd>0 || pow>0) {
	    dod_inf[indeks_ij] |= 40;     // mozemy cos zamknac, wiec
	    dod_inf[indeks_ij] &= (~16);  // moze ten ruch nie jest taki zly...
	    // zapamietaj ruch jako ciekawy
	    szanse[ile_szans++]=indeks_ij;
	  }
	  if (js) {
	    for (int i=up.lg; i<=up.pd; i++)
	      if (plansz_p[i]!=plansz_p_arg[i]) {
		if (plansz_p[i] & maska_naszego_stopu)
		  dod_inf[i]|=4;
		plansz_p[i]=plansz_p_arg[i];
	      }
	  }
	  else plansz_p[indeks_ij]=zap_pp;
	}
      }
  }
  else {
    // znajdz szanse i zagrozenia, ktore nie sa nieuniknione (w 1. ruchu,
    //   bez analizy ew. naszych podw. uderzen)
    int maska_wewn_n = ktory_gracz==1 ? 0x10:0x20;
    {
      unsigned char* plansz_p2 = plansze.PrzydzielPlansze();
      unsigned char* pom       = plansze.PrzydzielPlansze();
      CzyscTablice(pom);
      for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	for (int j=marg_min[1].y; j<=marg_max[1].y; j++) {
	  unsigned int indeks_ij = WezIndeksTab(i,j);
	  int zbadaj_zagr=0;
	  if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij) && 
	      CzyMozliwyStop(skl_tab, rozgr2, i,j, ktory_gracz)) {
	    int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	    TZdobycze wynik[2];  TZobrist zobr;
	    unsigned char zap_pp = plansz_p[indeks_ij];
	    int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,ktory_gracz, wynik, zobr,
				ile_zd,pow,pow2, punktacja_ss) & 3);
	    rozgrywka[indeks_ij]=0;  // usun kropke
	    if (ile_zd>0 || pow>0) {
	      dod_inf[indeks_ij] |= 40;     // mozemy cos zamknac, wiec
	      dod_inf[indeks_ij] &= (~16);  // moze ten ruch nie jest taki zly...
	      // zapamietaj ruch jako ciekawy
	      szanse[ile_szans++]=indeks_ij;
	      zbadaj_zagr=1;
	    }
	    else plansz_p[indeks_ij]=zap_pp;
	    if (js) zbadaj_zagr=1;   // odtworz plansz_p!
	  }
	  else if ((plansz_p[indeks_ij] & maska_wewn_n) && rozgr2[indeks_ij]==3-ktory_gracz) {
	    TZdobycze wynik[2];  TZobrist zobr;
	    int ile_zd=0, pow=0, pow2=0, ile_zd2=0, ile_dom;
	    ZrobRuch(rozgrywka, NULL, NULL, ile_dom, NULL, 0, plansz_p, indeks_ij | 0x4000, ktory_gracz,
		     0, wynik, zobr, ile_zd, pow, pow2, ile_zd2);
	    zbadaj_zagr=1;
	  }
	  if (zbadaj_zagr) {
	    // sprawdz, czy likwiduje jakies zagrozenia
	    KopiujTablice(plansz_p2, plansz_p);
	    for (int z=0; z<ile_zagrozen; z++) {
	      if (zagrozenia[z]==indeks_ij)
		continue;  // zagrozenie nieaktualne - postawilismy kropke
	      int iz = upl_x[zagrozenia[z]];
	      int jz = upl_y[zagrozenia[z]];
	      unsigned int indeks_ijz = zagrozenia[z];
	      if (plansz_p[indeks_ijz] & maska_naszego_stopu)
		continue;  // zagrozenie nieaktualne - zamknelismy (staly) stop
	      // wykonaj ruch
	      int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	      TZdobycze wynik[2];  TZobrist zobr;
	      unsigned char zap_pp = plansz_p2[indeks_ijz];
	      int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, iz,jz,3-ktory_gracz,
				  wynik, zobr, ile_zd,pow,pow2, punktacja_ss) & 3);
	      rozgrywka[indeks_ijz]=0;  // usun kropke
	      if (js) {
		for (int i=up.lg; i<=up.pd; i++)
		  if (plansz_p2[i]!=plansz_p[i]) {
		    if (plansz_p2[i] & maska_stopu_przec)
		      pom[i]=1;
		    plansz_p2[i]=plansz_p[i];
		  }
	      }
	      else plansz_p2[indeks_ijz] = zap_pp;
	    }
	    // wyzeruj zlikwidowane zagrozenia
	    for (int i=up.lg; i<=up.pd; i++)
	      if (!pom[i])
		ile_razy[i]=0;   // wyzeruj ew. zagrozenie
	      else
		pom[i]=0;        // odtworz tablice pom (same zera)
	    for (int i=up.lg; i<=up.pd; i++)
	      if (plansz_p[i]!=plansz_p_arg[i]) {
		if (plansz_p[i] & maska_naszego_stopu)
		  dod_inf[i]|=4;
		plansz_p[i]=plansz_p_arg[i];
	      }
	  }
	}
      plansze.ZwolnijPlansze(plansz_p2);
      plansze.ZwolnijPlansze(pom);
    }
    
    // znajdz szanse zwiazane z naszymi podwojnymi uderzeniami, ktore pozwalaja
    // uniknac nieuniknionych, zdawaloby sie, zagrozen
    // (...)  na razie tego nie ma (...)
    //
    // to, czego sie nie da obronic, zamknij, zeby nas nie oglupialo
    // ale wstawiaj kropki tylko w (przynajmniej) podwojnie zagrozone miejsca
    {
      unsigned char* plansz_p2    = plansze.PrzydzielPlansze();
      // badaj zagrozenia
      moga_byc_nieunikn=0;
      for (int z=ile_zagrozen-1; z>=0; z--) {
	int iz = upl_x[zagrozenia[z]];
	int jz = upl_y[zagrozenia[z]];
	unsigned int indeks_ijz = zagrozenia[z];
	unsigned int indeks_ijz_d[4] =
	  {indeks_ijz-1, indeks_ijz+W_P, indeks_ijz+1, indeks_ijz-wlky-4 };
	if (ile_razy[indeks_ijz]<=1 &&
	    ((ile_razy[indeks_ijz_d[0]]>=2 && (plansz_p[indeks_ijz_d[0]] & 3)==0) ||
	     (ile_razy[indeks_ijz_d[1]]>=2 && (plansz_p[indeks_ijz_d[1]] & 3)==0) ||
	     (ile_razy[indeks_ijz_d[2]]>=2 && (plansz_p[indeks_ijz_d[2]] & 3)==0) ||
	     (ile_razy[indeks_ijz_d[3]]>=2 && (plansz_p[indeks_ijz_d[3]] & 3)==0))) {
	  KopiujTablice(plansz_p2, plansz_p);
	  // wykonaj ruch(y)
	  int ile_zd=0, pow=0, pow2=0;
	  int wyk[4] = {0,0,0,0};   // wykonane ruchy
	  int di[4] = {0,1,0,-1}, dj[4] = {-1,0,1,0};
	  int zap_rozg[4];
	  TZdobycze zap_wynik[2];
	  zap_wynik[0].Zeruj();
	  zap_wynik[1].Zeruj();
	  TZobrist zobr_nowy;
	  zobr_nowy.Zeruj();
	  for (int nr=0; nr<4; nr++)
	    if (ile_razy[indeks_ijz_d[nr]]>=2 && (plansz_p[indeks_ijz_d[nr]] & 3)==0
		&& rozgrywka[indeks_ijz_d[nr]]==0) {   // to dodane w 83.43
	      wyk[nr]=1;
	      zap_rozg[nr]=rozgrywka[indeks_ijz_d[nr]];
	      int punktacja_ss;
	      TZdobycze wynik[2];
	      ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, iz+di[nr],jz+dj[nr],
			  3-ktory_gracz, wynik, zobr_nowy,
			  ile_zd,pow,pow2, punktacja_ss);
	      zap_wynik[0]+=wynik[0];	      zap_wynik[1]+=wynik[1];
	    }
	  if (wyk[0] || wyk[1] || wyk[2] || wyk[3]) {
	    int zle=0;
	    for (int i=up.lg; i<=up.pd; i++)
	      if (plansz_p2[i]!=plansz_p[i] && (plansz_p[i] & maska_stopu_przec) && ile_razy[i]<=1)
		{zle=1; break; }
	    if (zle) {
	      // usun kropki
	      for (int nr=0; nr<4; nr++)
		if (wyk[nr]) rozgrywka[indeks_ijz_d[nr]]=zap_rozg[nr];
	      KopiujTablice(plansz_p, plansz_p2);
	    }
	    else {
	      moga_byc_nieunikn=1;
	      ang[0].zdobycze[0]+=zap_wynik[0];
	      ang[0].zdobycze[1]+=zap_wynik[1];
	      ang[0].htab_zobr ^= zobr_nowy;
	    }
	  }
	}
      }
      plansze.ZwolnijPlansze(plansz_p2);
    }
    if (moga_byc_nieunikn) {
      // ustaw na nowo skl_tab oraz rozgr2, rozgr3
      WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
      ZnajdzSkladowe(skl_tab, rozgr2, ktory_gracz);
      // wyzeruj bity przeciwnika w dod_inf
      for (int i=up.lg; i<=up.pd; i++)
	if (dod_inf[i] & 0x8)      // stawiajac tu kropke mam stop? (szansa)
	  dod_inf[i] &= ~(0x13);   // tak
	else
	  dod_inf[i] &= ~(0x33);   // nie! => wyzeruj tez bit ciekawego ruchu
      // ustaw na nowo dod_inf,
      // usun niepotrzebne zagrozenia (takie, ktore juz nie sa zagrozeniami)
      unsigned char *plansz_p2 = plansze.PrzydzielPlansze();
      for (int z=ile_zagrozen-1; z>=0; z--) {
	int iz = upl_x[zagrozenia[z]];
	int jz = upl_y[zagrozenia[z]];
	unsigned int indeks_ijz = zagrozenia[z];
	if (rozgrywka[indeks_ijz]==0 && (plansz_p[indeks_ijz] & 0x3)==0) {
	  int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	  KopiujTablice(plansz_p2, plansz_p);
	  TZdobycze wynik[2];  TZobrist zobr;
	  unsigned char zap_pp = plansz_p2[indeks_ijz];
	  int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, 
			      iz,jz,3-ktory_gracz, wynik, zobr,
			      ile_zd,pow,pow2, punktacja_ss) & 3);
	  rozgrywka[indeks_ijz]=0;  // usun kropke
	  if (js) {
	    if (pow>0)    dod_inf[indeks_ijz]|=33;
	    if (ile_zd>0) dod_inf[indeks_ijz]|=34;
	    for (int i=up.lg; i<=up.pd; i++)
	      if (plansz_p[i]!=plansz_p2[i] && (dod_inf[i] & 0x8)==0 && (plansz_p2[i] & maska_stopu_przec))
		// stawiajac tu kropke tylko ja tracimy...
		dod_inf[i]|=16;
	  }
	  else {
	    plansz_p2[indeks_ijz]=zap_pp;
	    zagrozenia[z] = zagrozenia[--ile_zagrozen];  // dziala nawet gdy [z] jest ostatnim zagrozeniem
	  }
	}
	else
	  zagrozenia[z] = zagrozenia[--ile_zagrozen];  // dziala nawet gdy [z] jest ostatnim zagrozeniem
      }
      // sprawdz, czy sa jakies nowe zagrozenia (to chyba niemozliwe...)
      // (ale ustaw tylko bity 0x1, 0x2, zeby moc pozniej unikac wywolywania
      //  ZrobPanstwo()).
      for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	for (int j=marg_min[1].y; j<=marg_max[1].y; j++) {
	  unsigned int indeks_ij = WezIndeksTab(i,j);
	   if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij) && 
	       (dod_inf[indeks_ij] & 0x3)==0 &&
	       CzyMozliwyStop(skl_tab, rozgr2, i,j, 3-ktory_gracz)) {
	     int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	     KopiujTablice(plansz_p2, plansz_p);
	     TZdobycze wynik[2];  TZobrist zobr;
	     ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p2, i,j,3-ktory_gracz,
				wynik, zobr, ile_zd,pow,pow2, punktacja_ss);
	     rozgrywka[indeks_ij]=0;  // usun kropke
	     if (ile_zd || pow || pow2) {
	       // zagrozenia[ile_zagrozen++]=indeks_ij;  // te nowe sztuczne zagr. nas nie interesuja
	       if (pow>0)    dod_inf[indeks_ij]|=1;
	       if (ile_zd>0) dod_inf[indeks_ij]|=2;
	     }
	   }
	}
      plansze.ZwolnijPlansze(plansz_p2);
    }
  }
  plansze.ZwolnijPlansze(ile_razy);
  // tutaj mamy ustawione:
  //   rozgrywka,plansz_p    -- w sposob pozwalajacy uniknac oglupiania;
  //   rozgr2,rozgr3,skl_tab,zagrozenia,szanse,dod_inf   -- jak zwykle.
  // wypelnij ang[1].zagrozenia
  ang[1].ile_zagrozen=0;
  for (int i=0; i<ile_szans; i++)
    if (dod_inf[szanse[i]] & 8)
      ang[1].zagrozenia[ ang[1].ile_zagrozen++ ] = szanse[i];
  // wypelnij ang[0].zagrozenia
  ang[0].ile_zagrozen=0;
  for (int i=0; i<ile_zagrozen; i++)
    if (dod_inf[zagrozenia[i]] & 3)
      ang[0].zagrozenia[ ang[0].ile_zagrozen++ ] = zagrozenia[i];
  // wypelnij kolejne_ruchy i ruchy_przec
  ile_ruchow=0, ile_ruchow_przec=0;
  ZnajdzObszary(obszar, rozgr2, rozgr3);
  most12.Inicjuj();    // trzeba wywolac przed ZnajdzMostki12() oraz TRobaki::OcenRuch
  {
    ZnajdzBezs12(bezs, rozgr3, marg_min[1], marg_max[1], 1);
    // zbadaj, czy sa kropki obu graczy
    int drugi_ruch;
    { 
      int sa[2]={0,0};
      for (int i=up.lg; i<=up.pd; i++) if (rozgr3[i]) sa[rozgr3[i]-1]++;
      drugi_ruch = (sa[0]==0 || sa[1]==0);
    }
    if (gracz.dokl_analizy>1)
      {
	// najpierw ruchy przeciwnika, wez sensowne zagrozenia
	for (int z=0; z<ile_zagrozen; z++)
	  {
	    unsigned int indeks_ijz = zagrozenia[z];
	    if ((dod_inf[indeks_ijz] & 7)!=4)   // gdy przeciwnik nie ma stopu, a moze stracic krope
	      {
		ruchy_przec[ile_ruchow_przec++] = zagrozenia[z];
		dod_inf[indeks_ijz] |= 0x40;
	      }
	  }
	if (!drugi_ruch) {
	  // wez otoczke
	  int maska_blisko = (ktory_gracz==1) ? 0x20a0 : 0x10a0;  // dla przeciwnika
	  for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
	    for (int j=marg_min[1].y; j<=marg_max[1].y; j++)
	      {
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if (rozgr3[indeks_ij]==0 &&         // puste pole
		    ((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
		     (obszar[indeks_ij] & maska_blisko) == 0xa0  // i jest blisko innych kropek
		     // (odl. 2-przec, 2-gracz), oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
		     && !bezs[indeks_ij])              // i nie jest ewidentnie bez sensu
		    || (dod_inf[indeks_ij] & 0x70)==0x20)   // lub jest ciekawy, nieanalizowany i niezagrozony
		  {
		    ruchy_przec[ile_ruchow_przec++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x40;
		  }
	      }
	  // bierz kolejne otoczki, jesli potrzeba
	  {
	    int maski[4]={1,0x200,0x400,0x800};
	    int maska_bezs = (ktory_gracz==1) ? 0x2000 : 0x1000;  // dla przeciwnika
	    for (int i=0; (i<gracz.listy_ruchow[1] || (i<4 && ile_ruchow_przec<2)); i++) {
	      int maska=maski[i];
	      if (i==2 && gracz.Bouzy_er)  // wlaczona ocena promieniowania
		maska |= 0x4000;
	      if ((maska & 0x4000)==0)   // nie bierzemy ruchow kolo bandy
		for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
		  for (int j=marg_min[2].y; j<=marg_max[2].y; j++) {
		    unsigned int indeks_ij = WezIndeksTab(i,j);
		    if (rozgr3[indeks_ij]==0 &&         // puste pole
			((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
			 (obszar[indeks_ij] & (maska | maska_bezs)) == maska  // jest w otoczce oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
			 && !bezs[indeks_ij]))              // i nie jest ewidentnie bez sensu
		      {
			ruchy_przec[ile_ruchow_przec++] = indeks_ij;
			dod_inf[indeks_ij] |= 0x40;
		      }
		  }
	      else {   // bierzemy ruchy kolo bandy
		for (int indeks_ij=up.lg; indeks_ij<=up.pd; indeks_ij++)
		  if (upl_marg[indeks_ij]>=2) {  // na wszelki wypadek...
		    if ((obszar[indeks_ij] & maska_bezs)==0
			&& (obszar[indeks_ij] & maska)!=0
			&& rozgr3[indeks_ij]==0            // puste pole
			&& ((dod_inf[indeks_ij] & 0x54)==0 // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
    		        && !bezs[indeks_ij])) {           // i nie jest ewidentnie bez sensu
		      ruchy_przec[ile_ruchow_przec++] = indeks_ij;
		      dod_inf[indeks_ij] |= 0x40;
		    }
		  }
	      }
	    }
	  }
	}
	else {  // to jest drugi ruch -- wez otoczke z marginesem 2
	  int maska = 4;
	  int maska_bezs = (ktory_gracz==1) ? 0x2000 : 0x1000;  // dla przeciwnika	  
	  for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
	    for (int j=marg_min[2].y; j<=marg_max[2].y; j++)
	      {
		unsigned int indeks_ij = WezIndeksTab(i,j);
		if (rozgr3[indeks_ij]==0 &&         // puste pole
		    ((dod_inf[indeks_ij] & 0x54)==0 &&   // nikt nie zamknie pola, pole nie jest jeszcze w ruchy_przec
		     (obszar[indeks_ij] & (maska | maska_bezs)) == maska  // jest w otoczce oraz nie jest bezs. ( & 0x1000/0x2000 == 0)
		     && !bezs[indeks_ij]))              // i nie jest ewidentnie bez sensu
		  {
		    ruchy_przec[ile_ruchow_przec++] = indeks_ij;
		    dod_inf[indeks_ij] |= 0x40;
		  }
	      }
	}
      }
    // wez ruchy dla nas
    {
    int ile_spermut=0;
    for (int i=marg_min[1].x; i<=marg_max[1].x; i++)
      for (int j=marg_min[1].y; j<=marg_max[1].y; j++) {
	unsigned int indeks_ij = WezIndeksTab(i,j);
	if ((dod_inf[indeks_ij] & 0x30)==0x20  // analizuj tylko ciekawe i takie, ze postawionej kropki nie stracimy natychmiast
	    && PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij)) {
	  kolejne_ruchy[ile_ruchow++] = indeks_ij;
	  dod_inf[indeks_ij] |= 0x80;
	}
      }
    Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
    ile_spermut=ile_ruchow;
    // teraz wez kolejne otoczki
    int maska_bezsensu = (ktory_gracz==1) ? 0x1000 : 0x2000;
    for (int m=0; (m<=4+gracz.listy_ruchow[0] || (m<=5 && ile_ruchow<3)); m++) {
      int maski[6]={0x50, 0xa0, 1, 0x200,0x400, 0x800};
      int maska=maski[m];
      if (m==2 && gracz.Bouzy_er)  // wlaczona ocena promieniowania
	maska |= 0x4000;
      if (drugi_ruch) maska = 4;
      if ((maska & 0x4000) == 0)  // nie bierzemy ruchow kolo bandy
	for (int i=marg_min[2].x; i<=marg_max[2].x; i++)
	  for (int j=marg_min[2].y; j<=marg_max[2].y; j++) {
	    unsigned int indeks_ij = WezIndeksTab(i,j);
	    if ((obszar[indeks_ij] & (maska|maska_bezsensu))==maska
		&& (dod_inf[indeks_ij] & 0x90)==0
		&& rozgr3[indeks_ij]==0
		&& !bezs[indeks_ij]) {
	      kolejne_ruchy[ile_ruchow++] = indeks_ij;
	      dod_inf[indeks_ij] |= 0x80;
	    }
	  }
      else // bierzemy ruchy kolo bandy
	for (int indeks_ij=up.lg; indeks_ij<=up.pd; indeks_ij++)
	  if (upl_marg[indeks_ij]>=2) {  // na wszelki wypadek...
	    if ((obszar[indeks_ij] & maska_bezsensu)==0
		&& (obszar[indeks_ij] & maska)!=0
		&& (dod_inf[indeks_ij] & 0x90)==0
		&& rozgr3[indeks_ij]==0
		&& !bezs[indeks_ij]) {
	      kolejne_ruchy[ile_ruchow++] = indeks_ij;
	      dod_inf[indeks_ij] |= 0x80;
	    }
	  }
      Spermutuj(kolejne_ruchy, ile_spermut, ile_ruchow);
      ile_spermut=ile_ruchow;
      if (drugi_ruch) break;
    }
    }
  }
  // ruchy do analizy gotowe, sprawdz, ile ich jest
  if (ile_ruchow<=1) {
    if (ile_ruchow==1)
      goto Zwolnij_pamiec;
    // trzeba znalezc jakis sensowny ruch (jesli tutaj dojdziemy,
    //  to chyba nie moze byc zadnych zagrozen! -- wiec mozna ten ruch
    //  wylosowac...
    int ile_wolnego, ile_wolnego_poza;
    IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
    int ktory=random(ile_wolnego_poza);
    for (int i=0; i<wlkx; i++) {
      unsigned int indeks=WezIndeksTab(i+2,2);
      for (int j=0; j<wlky; j++) {
	if ((plansz_p_arg[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
	    rozgrywka_arg[indeks]==0)        // nie ma tu jeszcze kropki
	  if ((ktory--) ==0) {
	    kolejne_ruchy[0] = WezIndeksTab(i+2,j+2);
	    ile_ruchow=1;  // zeby wybrac ruch nr 0
	    goto Zwolnij_pamiec;
	  }
	indeks++;
      }
    }
#ifndef TEKSTOWY
    printf("Blad... ,,pajak'' - przycisnij cos"); GrKeyRead();
#endif
    strcpy(pargry.nz1, "krbladp.z");
    gra.ObsluzZdarzenie(ZD_ZAPIS);
    exit(1);  // blad!
  }
  {
    // znajdz listy ruchow dla lisci
    CzyscTablice(schemat_ruchow);
    // ustaw marginesy na 0xff, to pozwoli nie analizowac ruchow poza plansza
    // zaznacz tez istniejace kropki, co nie jest konieczne, ale przyspiesza
    for (int i=0; i<wlkx4wlky4; i++)
      if (upl_marg[i]<2 ||
	  PustePole(rozgrywka, plansz_p, rozgr3, i)==0 ||
	  bezs[i]==1) schemat_ruchow[i]=0xff;   // || bezs[i]==1 : wersje 82.08+/83.12+
    {
      // ruchy dla nas
      krint maska = (ktory_gracz==1) ? 0x10: 0x40;  // maska ,,w odleglosci 1 od naszej kropki''
      if (gracz.listy_ruchow[3]) maska*=2;  // wez jednak maske ,,w odleglosci 2 od naszej kropki''
      krint maska_upr = (ktory_gracz==1) ? 0x60: 0x90;  // maska ,,2 od naszej kropki lub 1 od przeciwnika''
      if (gracz.listy_ruchow[2]) maska_upr=0xa0;  // wez jednak maske ,,w odleglosci 2 od jakiejkolwiek kropki''
      for (int r=0; r<ile_ruchow; r++) {
	unsigned int indeks = kolejne_ruchy[r];
	if (obszar[indeks] & maska)
	  schemat_ruchow[indeks] |= 1;
	if (obszar[indeks] & maska_upr)
	  //        && (obszar[indeks] & 2))       // jest w otoczce z marginesem 1
	  schemat_ruchow[indeks] |= 4;   // maska ruchu uproszczonego
      }
      if (gracz.listy_ruchow[3])
	maska ^= 0xa0;  // wez druga maske
      else
	maska ^= 0x50;  // wez druga maske
      if (!gracz.listy_ruchow[2])
	maska_upr ^= 0xf0;  //  wez druga maske
      else ;   // tutaj maska symetryczna!
      for (int r=0; r<ile_ruchow_przec; r++) {
	unsigned int indeks = ruchy_przec[r];
	if (obszar[indeks] & maska)
	  schemat_ruchow[indeks] |= 2;
	if (obszar[indeks] & maska_upr)
	  schemat_ruchow[indeks] |= 8;   // maska ruchu uproszczonego
      }
    }
    // uzupelnij dane w schemat_ruchow
    for (int i=0; i<ile_ruchow; i++)
      schemat_ruchow[kolejne_ruchy[i]] |= 0x10;
    for (int i=0; i<ile_ruchow_przec; i++)
      schemat_ruchow[ruchy_przec[i]] |= 0x20;
  }
 Zwolnij_pamiec:;
  plansze.ZwolnijPlansze(bezs);
  plansze.ZwolnijPlansze(dod_inf);
  plansze.ZwolnijPlansze(plansz_p_arg);
  plansze.ZwolnijPlansze(rozgrywka_arg);
  skladowe.ZwolnijSkladowa(zagrozenia);
  skladowe.ZwolnijSkladowa(szanse);
  skladowe.ZwolnijSkladowa(obszar);
}

void UaktualnijCiete(int akt_gleb, int ostatnia)
// ostatnia = (akt_gleb==ost_gleb)
{
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  if (ostatnia) {
      // uaktualnij ciete obszary, ale tylko dla akt. gracza
      int kto = angakt.ktory_teraz-1;
      //     memcpy(&angakt.ciete[kto], &angpop.ciete[kto], sizeof(angpop.ciete[0]));
      angakt.ciete[kto].Skopiuj(angpop.ciete[kto]);
      angakt.ciete[kto].DodajKropke(angakt.x,angakt.y,1);
  }
  else {
    //memcpy(&angakt.ciete[0], &angpop.ciete[0], 2*sizeof(angakt.ciete[0]));
    angakt.ciete[0].Skopiuj(angpop.ciete[0]);
    angakt.ciete[1].Skopiuj(angpop.ciete[1]);
    angakt.ciete[0].DodajKropke(angakt.x, angakt.y, angakt.ktory_teraz==1);
    angakt.ciete[1].DodajKropke(angakt.x, angakt.y, angakt.ktory_teraz==2);
  }
}

void UaktualnijMargSklBezp(int akt_gleb)
// najpierw ustaw robaki! (wazne dla skladowych!)
{
  STOPER_START_BEZP;
  // uaktualnij marginesy
  TAnaliza &angakt = ang[akt_gleb], &angpop = ang[akt_gleb-1];
  int i=angakt.x; 
  int j=angakt.y;
  angakt.marg0_min.x = std::min(i, (int) angpop.marg0_min.x);
  angakt.marg0_min.y = std::min(j, (int) angpop.marg0_min.y);
  angakt.marg0_max.x = std::max(i, (int) angpop.marg0_max.x);
  angakt.marg0_max.y = std::max(j, (int) angpop.marg0_max.y);
  // ustaw bezpieczne
  angakt.bandy.UaktualnijBezpieczne(angpop.bandy, angakt.rozgr3, angakt.indeks, angakt.jest_stop_sstop);
  STOPER_STOP_BEZP;
  // szukaj skladowych
  if (angakt.ile_kr_zd_teraz) {  //  || pow || pow2  -- to niepotrzebne...
    //    ZnajdzSkladowe(angakt.skl_tab, angakt.rozgr2, angakt.ktory_teraz);
    CzyscTablice(angakt.skl_tab);
    angakt.robaki[0].ZnajdzSkladowe(angakt.skl_tab, (angakt.ktory_teraz==1 ? 1:30001),
				    angakt.rozgr2);
    angakt.robaki[1].ZnajdzSkladowe(angakt.skl_tab, (angakt.ktory_teraz==1 ? 30001:1),
				    angakt.rozgr2);
    /*
    // test:
    krint *skltest = skladowe.PrzydzielSkladowa();
    ZnajdzSkladowe(skltest, angakt.rozgr2, angakt.ktory_teraz);
    krint slownik[0x10000];
    for (int i=0; i<wlkx4wlky4; i++)
      slownik[skltest[i]] = angakt.skl_tab[i];
    for (int i=0; i<wlkx4wlky4; i++) {
      if (skltest[i]) // && angakt.rozgr2[i])
	if (slownik[skltest[i]]==0 || slownik[skltest[i]] != angakt.skl_tab[i])
	  {
	    printf("Blad: %d.!",i);
	    abort();
	  }
	else;
      else if (angakt.skl_tab[i] && angakt.rozgr3[i]==0) {
	printf("Blad 0: %d.!",i);
	abort();
      }
    }        
    skladowe.ZwolnijSkladowa(skltest);
    */
  }
  else
    DodajKropkeDoSkl(angakt.skl_tab, angpop.skl_tab,
		     angakt.rozgr2, angakt.indeks, angakt.ktory_teraz,
                      15000+akt_gleb);
}

void UaktualnijRobaki(unsigned char *rozgrywka, int akt_gleb)
{
  ang[akt_gleb].robaki[0].DodajKropke(ang[akt_gleb-1].robaki[0], rozgrywka, ang[akt_gleb].rozgr2,
				      ang[akt_gleb].rozgr3, ang[akt_gleb].plansz_p, ang[akt_gleb].indeks,
				      ang[akt_gleb].byl_stop, ang[akt_gleb].jest_stop_sstop);
  ang[akt_gleb].robaki[1].DodajKropke(ang[akt_gleb-1].robaki[1], rozgrywka, ang[akt_gleb].rozgr2,
				      ang[akt_gleb].rozgr3, ang[akt_gleb].plansz_p, ang[akt_gleb].indeks,
				      ang[akt_gleb].byl_stop, ang[akt_gleb].jest_stop_sstop);
}

void RuchySieveDown(krint *tab, int l, int p)
// przesiewamy w dol wg wartosci TAnaliza::historia_sort[], malejaco
{
  int j=2*l+1;
  krint x=tab[l];
  while (j<=p) {
    if (j<p &&
	TAnaliza::historia_sort[tab[j]] > TAnaliza::historia_sort[tab[j+1]])
      j++;
    if (TAnaliza::historia_sort[x] > TAnaliza::historia_sort[tab[j]]) {
      tab[l]=tab[j];
      l=j;  j=2*l+1;
    }
    else break;
  }
  tab[l]=x;
}

void RuchyHeapSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  STOPER_START_SORT;
  for (int i=n/2-1; i>=0; i--)
    RuchySieveDown(tab,i,n-1);
  for (int i=n-1; i>0; i--) {
    krint pom=tab[0];
    tab[0]=tab[i];
    tab[i]=pom;
    RuchySieveDown(tab,0,i-1);
  }
  STOPER_STOP_SORT;
}

void RuchyInsertionSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  for (int i=1; i<n; i++) {
    krint v = tab[i];
    int wart = TAnaliza::historia_sort[v];
    int j=i;
    while (j>0 && TAnaliza::historia_sort[tab[j-1]] < wart)
      { tab[j]=tab[j-1]; j--; }
    tab[j] = v;
  }
}

void RuchyQuickSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
{
  STOPER_START_SORT;
  if (n<8) RuchyInsertionSort(tab,n);
  else {
    int na_stosie=2;
    int stos[32];      // potrzeba cos okolo 2 * log_2(maksymalne n)
    stos[0]=0;  stos[1]=n-1;
    do {
      int r=stos[--na_stosie];
      int l=stos[--na_stosie];
      do {
	// podziel tab[l],...,tab[r]
	int wart = TAnaliza::historia_sort[tab[(l+r)/2]];
	int i=l, j=r;
	do {
	  while (TAnaliza::historia_sort[tab[i]] > wart) i++;
	  while (TAnaliza::historia_sort[tab[j]] < wart) j--;
	  if (i<=j) { krint pom=tab[i];  tab[i]=tab[j];  tab[j]=pom; i++; j--; }
	}
	while (i<=j);
	// lista podzielona...
	if (j-l<r-i)
	  if (j-l<=5) {
	    RuchyInsertionSort(&tab[l], j-l+1);
	    if (r-i<=5)
	      { RuchyInsertionSort(&tab[i], r-i+1); break; }
	    else l=i;
	  }
	  else {
	    if (i<r) {
	      stos[na_stosie++] =i;
	      stos[na_stosie++] =r;
	    }
	    r=j;
	  }
	else
	  if (r-i<=5) {
	    RuchyInsertionSort(&tab[i], r-i+1);
	    if (j-l<=5)
	      { RuchyInsertionSort(&tab[l], j-l+1); break; }
	    else r=j;
	  }
	  else {
	    if (l<j) {
	      stos[na_stosie++] =l;
	      stos[na_stosie++] =j;
	    }
	    l=i;
	  }
      }
      while (l<r);
    }
    while (na_stosie);
    //    assert(TAnaliza::historia_sort[tab[0]] >= TAnaliza::historia_sort[tab[1]]);
    //    assert(TAnaliza::historia_sort[tab[1]] >= TAnaliza::historia_sort[tab[2]]);
  }
  STOPER_STOP_SORT;
}

void RuchySieveDown(krint *tab, int l, int p, long int *oceny)
// przesiewamy w dol wg wartosci oceny, malejaco
{
  int j=2*l+1;
  krint x=tab[l];
  while (j<=p) {
    if (j<p && oceny[tab[j]] > oceny[tab[j+1]])
      j++;
    if (oceny[x] > oceny[tab[j]]) {
      tab[l]=tab[j];
      l=j;  j=2*l+1;
    }
    else break;
  }
  tab[l]=x;
}

void RuchyHeapSort(krint *tab, int n, long int *oceny)
// sortujemy wg wartosci oceny, malejaco
{
  STOPER_START_SORT;
  for (int i=n/2-1; i>=0; i--)
    RuchySieveDown(tab,i,n-1,oceny);
  for (int i=n-1; i>0; i--) {
    krint pom=tab[0];
    tab[0]=tab[i];
    tab[i]=pom;
    RuchySieveDown(tab,0,i-1,oceny);
  }
  STOPER_STOP_SORT;
}


/*
void RuchyBubbleSort(krint *tab, int n)
// sortujemy wg wartosci TAnaliza::historia_sort[], malejaco
// metoda stabilna (nie zmienia kolejnosci takich samych kluczy)
// dziala szybko, gdy jest duzo zer w historia_sort[]
{
  for (int i=1; i<n; i++) {  // i=koniec
    int posort=1;
    for (int j=n-1; j>=i; j--)
      if (TAnaliza::historia_sort[tab[j]] > TAnaliza::historia_sort[tab[j-1]]) {
	krint pom = tab[j];
	tab[j]    = tab[j-1];
	tab[j-1]  = pom;
	posort=0;
      }
    if (posort) return;
  }
}
*/

int ZapamietajOcene12(int ocena, int akt_gleb, int ost_gleb,
		      krint *nruchy, int &liczba_nruchow, int &x, int &y, int sortuj=1)
// zapamietuje ocene, sortuje ruchy
// zwraca 1, gdy jest ciecie beta, 0, gdy nie ma
{
  STOPER_START_ZAPO;
#ifndef TEKSTOWY
  ang[akt_gleb-1].ost_gleb_max =std::max(ang[akt_gleb-1].ost_gleb_max, ang[akt_gleb].ost_gleb_max);
#endif
  unsigned int ind = ang[akt_gleb].indeks;
  if (-ocena < ang[akt_gleb-1].ocena) {  // dziala tez gdy (RHS)==INT_MAX
    ang[akt_gleb-1].ocena = -ocena;
    ang[akt_gleb-1].najlepszyr = ind;
    if (akt_gleb>=2)
      {
	int indpop = ang[akt_gleb-1].indeks;
	if (ang[akt_gleb-1].propoz[0][indpop] != ind) {
	  ang[akt_gleb-1].propoz[1][indpop] = ang[akt_gleb-1].propoz[0][indpop];
	  ang[akt_gleb-1].propoz[0][indpop] = ind;
	}
      }
    else
      if (akt_gleb==1) {
	x=ang[1].x;  y=ang[1].y;
	nruchy[0]=WezIndeksTab(x,y);
	for (int i=0; i<ang[1].stopy1-ang[1].stopy0; i++)
	  nruchy[i+1]=ang[1].stopy_wykonane[i+ang[1].stopy0];
	liczba_nruchow = 1+ang[1].stopy1-ang[1].stopy0;
      }
    if (sortuj)
    if (akt_gleb<=2) {
      if (akt_gleb==1) {
	ang[1].oceny_ht[ind] = ocena;   // wazne gdy sortuj==2 (dla else ponizej)
	// przesun na sama gore akt. ruch
	for (int i=ang[1].nr_ruchu; i>ang[1].pocz_ruch; i--)
	  ang[1].lista_ruchow[i] = ang[1].lista_ruchow[i-1];
	// zapamietaj najlepszy w [pocz]
	ang[1].lista_ruchow[ang[1].pocz_ruch] = ind;
      }
      else  // if (ocena<ang[0].ocena || sortuj==2)   // tylko gdy to dobry ruch! (ale to nie jest dobry pomysl)
      { // akt_gleb==2
	// przesun na sama gore akt. ruch
	for (int i=ang[2].nr_ruchu; i>ang[2].pocz_ruch; i--)
	  ang[2].lista_ruchow[i] = ang[2].lista_ruchow[i-1];
	// zapamietaj najlepszy w [pocz]
	ang[2].lista_ruchow[ang[2].pocz_ruch] = ind;
      }
    }
    else if (/*ost_gleb-akt_gleb>=2 &&*/ 
	     ang[akt_gleb].nr_ruchu > ang[akt_gleb].pocz_ruch+1) {
      ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu] =
	ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu-1];
      ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu-1] = ind;
    }

    // ciecia alfa-beta
    if (ocena>=ang[akt_gleb].alfa) ang[akt_gleb].alfa = ocena;
    if (ocena>=ang[akt_gleb].beta) {
      long long t = TAnaliza::historia[ind] += (ang[akt_gleb].historia_waga<<2);
      if (t>TAnaliza::historia_max) TAnaliza::historia_max = t;
      ang[akt_gleb-1].najlepszyr = 0;   // niekoniecznie jest najlepszy, tylko daje ciecie...
      STOPER_STOP_ZAPO;
      return 1;
    }
    else {  // dodaj mniej, bo tutaj nie ma ciecia...
      long long t = TAnaliza::historia[ind] += ang[akt_gleb].historia_waga;
      if (t>TAnaliza::historia_max) TAnaliza::historia_max = t;
    }
  }
  else if (sortuj==2 && akt_gleb==1) {
    ang[1].oceny_ht[ind]=ocena;
    // sortowanie
    int l=ang[1].pocz_ruch;
    int p=ang[1].nr_ruchu;   // przedzial [l,p)
    // znajdz miejsce dla akt. ruchu
    while (l<p) {
      int s=(l+p)/2;
      if (ang[1].oceny_ht[ang[1].lista_ruchow[s]] < ocena)
	p=s;
      else l=s+1;
    }
    if (l<ang[1].nr_ruchu) {
      for (int i=ang[1].nr_ruchu; i>l; i--)
	ang[1].lista_ruchow[i] = ang[1].lista_ruchow[i-1];
      ang[1].lista_ruchow[l] = ind;
    }
  } 
  STOPER_STOP_ZAPO;
  return 0;
}

void SortujRuchyA(unsigned char *rozgrywka, int akt_gleb)
  // akt_gleb==1 lub ==2
{
  osk12.Zeruj();
  if (akt_gleb==2) {
    ang[1].nr_ruchu = ang[1].pocz_ruch;
    ang[1].x=ang[0].x;               // zeby mozna bylo poprawnie
    ang[1].y=ang[0].y;               // zamykac brzuszki po wstawieniu don kropki przec
    ang[1].indeks = ang[0].indeks;   // (w ostatnim ruchu przed analiza, tj. ang[0])
    ang[1].rozgr2 = ang[0].rozgr2;
    ang[1].rozgr3 = ang[0].rozgr3;
    ang[1].plansz_p = ang[0].plansz_p;
    ang[1].zyski  = ang[1].straty = ang[1].ile_kr_zd_teraz = ang[1].jest_stop_sstop = 0;
    // przepisz marginesy
    ang[1].marg0_min = ang[0].marg0_min;
    ang[1].marg0_max = ang[0].marg0_max;
    // przepisz bezpieczne
    ang[1].bandy.Kopiuj(ang[0].bandy);
    // przepisz skladowe
    KopiujTablice(ang[1].skl_tab, ang[0].skl_tab);
    // przepisz zdobycze
    ang[1].zdobycze[0] = ang[0].zdobycze[0];
    ang[1].zdobycze[1] = ang[0].zdobycze[1];
    // i ciete oraz robaki
    memcpy(ang[1].ciete, ang[0].ciete, sizeof(ang[1].ciete));
    ang[1].robaki[0] = ang[0].robaki[0];
    ang[1].robaki[1] = ang[0].robaki[1];
    // na wszelki wypadek tez htab_zobr
    ang[1].htab_zobr = ang[0].htab_zobr;
  }
  ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;
  long int *oceny = tabliceLI.Przydziel();
  while (ang[akt_gleb].nr_ruchu<ang[akt_gleb].ost_ruch) {
    if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb, 3)) {
      // mozna wykonac ruch [akt_gleb].nr_ruchu!
      UaktualnijRobaki(rozgrywka, akt_gleb);
      UaktualnijMargSklBezp(akt_gleb);
      // ruch zrobiony, teraz go ocen
      UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
      oceny[ang[akt_gleb].indeks]
	= osk12.OcenPozycje12TylkoTaGleb(rozgrywka, (akt_gleb & 1), 
					 ang[akt_gleb], ang[akt_gleb-1]);
      // usun kropke
      ang[akt_gleb-1].OdtworzRozgr23pp();
      rozgrywka[ ang[akt_gleb].indeks ]=0;
      ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
    }
    ang[akt_gleb].nr_ruchu++;
  }
  RuchyHeapSort(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
		ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch, oceny);
  ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;  
  osk12.Zeruj();   // na wszelki wypadek
  tabliceLI.Zwolnij(oceny);
}


inline long int QuiescenceS(unsigned char *rozgrywka, int akt_gleb)
// Uwaga: nie robi zadnych ciec beta - zwraca dokladna ocene!
{
  statystyka_dla_analizy.funk_ocen++;
  if ((TAnaliza::gracz.umiejetnosci & 0x100)==0 || 
      (ang[akt_gleb-1].ile_zagrozen==0 && ang[akt_gleb-1].grozby.ile_ze_zd==0)) {
    UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
    return osk12.OcenPozycje12(rozgrywka, (akt_gleb & 1), 
			       ang[akt_gleb], ang[akt_gleb-1], 
			       (akt_gleb>=2 ? &ang[akt_gleb-2] : NULL),
			       ang[akt_gleb].beta==INT_MAX);
  }
  int czy_jest_Q=0;
  long int ocena = -INT_MAX;
  ang[akt_gleb+1].nr_ruchu = 0;
  if (ang[akt_gleb+1].ost_ruch = ang[akt_gleb-1].ile_zagrozen)  // =, nie ==
    memcpy(ang[akt_gleb+1].lista_ruchow, ang[akt_gleb-1].zagrozenia, 
	   ang[akt_gleb-1].ile_zagrozen*sizeof(ang[akt_gleb-1].zagrozenia[0]));
  // dodaj grozby
  for (int a=0; a<akt_gleb; a++)        // 83.43+
    if (ang[a].ktory_teraz!=ang[akt_gleb].ktory_teraz)
      for (int i=0; i<ang[a].grozby.ile; i++)
	if ((ang[a].grozby.czy[i] & 4)==0) {  // nie sprawdzaj grozb-brzuszkow (?)
	  krint ind = ang[a].grozby.lista[i];
	  // sprawdz, czy nie ma juz takiego ruchu
	  for (int j=ang[akt_gleb+1].ost_ruch-1; j>=0; j--)
	    if (ang[akt_gleb+1].lista_ruchow[j]==ind)
	      goto Juz_jest;
	  // nie ma, dodaj
	  ang[akt_gleb+1].lista_ruchow[ ang[akt_gleb+1].ost_ruch++ ]=ind;
	Juz_jest:;
	}
  while (ang[akt_gleb+1].nr_ruchu < ang[akt_gleb+1].ost_ruch) {
    if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb+1, 0)) {
      if (ang[akt_gleb+1].ile_kr_zd_teraz) {
	if (!czy_jest_Q) {
	  czy_jest_Q=1;
	  // ustaw to, co zostalo wczesniej pominiete
	  UaktualnijCiete(akt_gleb, 0);
	  // alfa, beta pomijamy - i tak nieuzywane...
	}
	else statystyka_dla_analizy.funk_ocen++;  // kolejna ocena (pierwsze ,,++'' jest na poczatku)
	// ocen ruch
	UaktualnijRobaki(rozgrywka, akt_gleb+1);
	UaktualnijMargSklBezp(akt_gleb+1);
	UaktualnijCiete(akt_gleb+1, 1);
	long int ocena2 = osk12.OcenPozycje12(rozgrywka, ((akt_gleb+1) & 1), 
					      ang[akt_gleb+1], ang[akt_gleb], &ang[akt_gleb-1], -1);
	if (ocena2>ocena) ocena=ocena2;
	ang[akt_gleb+1].robaki[0].UsunKropke();       ang[akt_gleb+1].robaki[1].UsunKropke();
      }
      // usun kropke
      ang[akt_gleb].OdtworzRozgr23pp();
      rozgrywka[ ang[akt_gleb+1].indeks ]=0;
    }
    // wez nastepny ruch
    ang[akt_gleb+1].nr_ruchu++;
  } 
  if (czy_jest_Q)
    return -ocena;
  UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb
  return osk12.OcenPozycje12(rozgrywka, (akt_gleb & 1), 
			     ang[akt_gleb], ang[akt_gleb-1], 
			     (akt_gleb>=2 ? &ang[akt_gleb-2] : NULL),
			     ang[akt_gleb].beta==INT_MAX);
}

inline void HTWstaw(int akt_gleb, int ost_gleb, int ost_gleb16, 
		    long int ocena, int rodzaj, short int prop0, short int prop1)
// powinno byc akt_gleb>=1
{
  htablicaZ.Wstaw(ang[akt_gleb].htab_zobr, akt_gleb, ocena, rodzaj, 
		  prop0, prop1, ost_gleb-akt_gleb);
}

inline long int HTWez(int akt_gleb, int ost_gleb, int ost_gleb16, int &rodzaj)
// powinno byc akt_gleb>=1
{
  return
    htablicaZ.Wez(ang[akt_gleb].htab_zobr, rodzaj,
		  ang[akt_gleb].propoz[0][ang[akt_gleb].indeks],
		  ang[akt_gleb].propoz[1][ang[akt_gleb].indeks], ost_gleb-akt_gleb);
}
   
int AlfaBeta12(unsigned char *rozgrywka, unsigned char *schemat_ruchow, 
	       int ost_gleb, const TGraczO& gracz,
#ifndef TEKSTOWY
	       int pokaz_analize_max_gleb, 
#endif
	       krint *nruchy, int& liczba_nruchow,
	       int &x, int &y, int bez_ciec_beta=0, int zapamietuj_drugi_ruch=0)
// moze da sie wykorzystac na x,y zmienne ang[0].x,y ?
{
  ang[0].ocena    = INT_MAX;     // oznacza, ze oceny nie ma
  ang[1].nr_ruchu = 0;
  ang[0].ost_gleb = ost_gleb;    // do wysw. analizy
  // analizuj kolejne ruchy
  int akt_gleb=1;
  int ost_gleb16 = (ost_gleb<<4);
  long int ocena;
 Analizuj_nastepny:;
  ang[akt_gleb].byl_przeglad_ht=0;
  if (akt_gleb>=2) ang[akt_gleb].ile_zagrozen=0;
  // zrob przeglad htablicy
  ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;

  if (akt_gleb<ost_gleb)
    if (akt_gleb>=2) {   // MUSI byc co najmniej: akt_gleb<ost_gleb && akt_gleb>=3 (inaczej nie zainicjowane propoz)
     int hist_shift = 0;
     { long long int test=TAnaliza::historia_max;  
     while (test>8000) { test>>=1; hist_shift++;} }
     if (akt_gleb>=3) ang[akt_gleb].byl_przeglad_ht=1;      
     while (ang[akt_gleb].nr_ruchu < ang[akt_gleb].ost_ruch) {
       int ind = ang[akt_gleb].lista_ruchow[ ang[akt_gleb].nr_ruchu ];
       ang[akt_gleb].oceny_ht[ind] = INT_MAX;
       TAnaliza::historia_sort[ind]+= (TAnaliza::historia[ind] >> hist_shift);
       if (WykonajRuchNrJesliMozna(rozgrywka, akt_gleb, 1, 1)) {
	 // mozna wykonac ruch [akt_gleb].nr_ruchu!
	 if (akt_gleb>=3) {
	   // czy pozycja jest w htablicy?
	   int rodzaj;
	   ang[akt_gleb].oceny_ht[ind] = ocena = HTWez(akt_gleb, ost_gleb, ost_gleb16, rodzaj);
	   ang[akt_gleb].rodzaj_oc_ht[ind] = rodzaj;
	   rodzaj &= 7;
	   if (rodzaj==4  ||
	       (rodzaj==5 && ocena>=ang[akt_gleb].beta) ||
	       (rodzaj==6 && ocena<=ang[akt_gleb].alfa)) {
	     statystyka_dla_analizy.wez_ht++;
	     if (ZapamietajOcene12(ocena, akt_gleb, ost_gleb, nruchy, liczba_nruchow, x, y, 0)) {
	       rozgrywka[ind] = 0;             // usun ruch
	       ang[akt_gleb-1].OdtworzRozgr23pp();
	       goto Ciecie_beta;
	     }
	     ang[akt_gleb].rodzaj_oc_ht[ind] |= 0x10;  // zaznacz ruch jako przegladniety
	   }
	   //if (rodzaj & 4)  // 83.36+
	   //  TAnaliza::historia_sort[ind]+= 3000;  // bonus za obecnosc w HT
	   //else if (ang[akt_gleb].propoz[0][ind])
	   //  TAnaliza::historia_sort[ind]+= 500;  // bonus za propozycje w HT
	 }
	 // sprawdz singularnosc grozb
	 if (ang[akt_gleb].jest_stop_sstop)
	   ang[akt_gleb-1].grozby.SprawdzOdpPrzec(rozgrywka, ang[akt_gleb].rozgr3,
						  ang[akt_gleb].plansz_p, ind);
	 // usun ruch
	 rozgrywka[ind] = 0;
	 ang[akt_gleb-1].OdtworzRozgr23pp();
	 // sprawdz, czy ruch na [akt_gleb-1] nie byl bezsensowny
	 if (ang[akt_gleb].ile_kr_zd_teraz && 
	     ang[akt_gleb].rozgr3[ang[akt_gleb-1].indeks] == ang[akt_gleb].ktory_teraz &&
	     ang[akt_gleb-1].ile_kr_zd_teraz <= 1) {
	   // ruch bezsensowny, zmniejsz glebokosc i wez kolejny ruch
	   akt_gleb--;
	   unsigned int ind = ang[akt_gleb].indeks;
	   rozgrywka[ind] = 0;
	   ang[akt_gleb-1].OdtworzRozgr23pp();
	   ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
	   if (ost_gleb>=3 && akt_gleb<ost_gleb-1) UsunSasiadow(schemat_ruchow, akt_gleb);
	   ost_gleb = ang[akt_gleb].ost_gleb;
	   goto Kolejny_ruch;
	 }
	 // czy jest szansa?
	 if (ang[akt_gleb].jest_stop_sstop)
	   ang[akt_gleb].zagrozenia[ ang[akt_gleb].ile_zagrozen++ ] = ind;
       }
       else
	 ang[akt_gleb].rodzaj_oc_ht[ind] = 0x20;  // zaznacz ruch jako niewykonalny
       ang[akt_gleb].nr_ruchu++;
     }
     ang[akt_gleb].nr_ruchu=ang[akt_gleb].pocz_ruch;
     ang[akt_gleb-1].grozby.ile_sing=0;
     // dodaj punkty za likwidowanie singularnych zagrozen
     for (int i=0; i<ang[akt_gleb-1].grozby.ile; i++)
       if (ang[akt_gleb-1].grozby.czy[i]==1) {  // singularna grozba i ruch nie bezsensowny
	 ang[akt_gleb-1].grozby.ile_sing++;
	 int punkty = (ang[akt_gleb-1].grozby.zdobycze[i] << 11);
	 TAnaliza::historia_sort[ang[akt_gleb-1].grozby.lista[i]] += 
	   (punkty<10000) ? punkty : 10000;
       }
     // posortuj ruchy!
     if (akt_gleb>=3) { // na gleb==2 sie nie oplaca (!)
            // jesli jednak chcesz akt_gleb>=2, pamietaj o zmianie inicjowania historia_sort...
            // (wtedy ponizej trzeba ustawiac na 1 rowniez na akt_gleb==1)
       // dodaj punkty za zlikwidowane zagrozenia
       for (int i=ang[akt_gleb-1].ile_zagrozen-1; i>=0; i--)
	 TAnaliza::historia_sort[ ang[akt_gleb-1].zagrozenia[i] ] += 750;
       RuchyQuickSort(&ang[akt_gleb].lista_ruchow[ang[akt_gleb].pocz_ruch],
		     ang[akt_gleb].ost_ruch - ang[akt_gleb].pocz_ruch);
       // usun niepotrzebne ruchy (dozwolne tylko dla akt_gleb>=3!!)
       while (ang[akt_gleb].ost_ruch > ang[akt_gleb].pocz_ruch) {
	 int ind = ang[akt_gleb].lista_ruchow[ang[akt_gleb].ost_ruch-1];
	 if (TAnaliza::historia_sort[ind]==0 &&
	     ((ang[akt_gleb].rodzaj_oc_ht[ind] & 0x20)!=0))
	   ang[akt_gleb].ost_ruch--;
	 else break;
       }
     }
    }
    else if (akt_gleb==1 && TAnaliza::sa_symetrie) {
      // symetrie!
      ang[1].byl_przeglad_ht=1;
      for (int i=ang[1].nr_ruchu; i < ang[1].ost_ruch; i++)
	ang[1].rodzaj_oc_ht[ ang[1].lista_ruchow[i] ] =
	  (TAnaliza::symetrie[ ang[1].lista_ruchow[i] ]) ? 0x10 : 0;   // przegladniety (=wywal) : do przegladniecia (=zostaw)

    }
   //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
   // analizuj kolejne ruchy!
   //_________________________________________________
   while (ang[akt_gleb].nr_ruchu < ang[akt_gleb].ost_ruch)
     {
       ang[akt_gleb].najlepszyr=0;
       if ((!ang[akt_gleb].byl_przeglad_ht || 
	    (ang[akt_gleb].rodzaj_oc_ht[ang[akt_gleb].lista_ruchow[ang[akt_gleb].nr_ruchu]] & 0x30)==0)
	   && WykonajRuchNrJesliMozna(rozgrywka, akt_gleb,
     akt_gleb<ost_gleb || ( (TAnaliza::gracz.umiejetnosci & 0x100)!=0 &&
			     (ang[akt_gleb-1].ile_zagrozen ||
			      ang[akt_gleb-1].grozby.ile_ze_zd)))) {
       // mozna wykonac ruch [akt_gleb].nr_ruchu!
#ifndef TEKSTOWY
	 if (akt_gleb<=pokaz_analize_max_gleb) {
	   ekran.NowyRuch(ang[0].ost_gleb,
			  TJedenRuch(ang[1].x-2, ang[1].y-2, ang[1].stopy1-ang[1].stopy0), 
			  ang[1].nr_ruchu-ang[1].pocz_ruch, ang[1].ost_ruch-ang[1].pocz_ruch, 
			  akt_gleb);
	 }
#endif
       ang[akt_gleb].robaki[0].UaktualnijGleb();       ang[akt_gleb].robaki[1].UaktualnijGleb();
       // ustaw alfa i beta na nastepnym poziomie
       if (akt_gleb<ost_gleb) {
	 if (!bez_ciec_beta) {
	   ang[akt_gleb+1].alfapocz = ang[akt_gleb+1].alfa = -ang[akt_gleb].beta;
	   ang[akt_gleb+1].beta = -ang[akt_gleb].alfa;
	 }
	 else {
	   ang[akt_gleb+1].alfapocz = ang[akt_gleb+1].alfa = -INT_MAX;
	   ang[akt_gleb+1].beta = INT_MAX;
	 }
       }
       // czy pozycja jest w htablicy??
       if (ang[akt_gleb].byl_przeglad_ht) {
	 int ind = ang[akt_gleb].indeks;
	 ocena = ang[akt_gleb].oceny_ht[ind];
	 int rodzaj = ang[akt_gleb].rodzaj_oc_ht[ind];
	 if (rodzaj==6) {
	   if (ocena<=ang[akt_gleb].alfa) {
	     statystyka_dla_analizy.wez_ht++;
	     goto Zapamietaj_ocene_ale_nie_w_ht;
	   }
	   // ogr. gorne, wez minimum
	   ang[akt_gleb+1].alfa = - std::min(ang[akt_gleb].beta, ocena);
	 }
	 else if (rodzaj==5)  // ogr. dolne, wez maksimum
	   ang[akt_gleb+1].beta = - std::max(ang[akt_gleb].alfa, ocena);
       }
       else if (akt_gleb>=3) {
	 int rodzaj;
	 ocena = HTWez(akt_gleb, ost_gleb, ost_gleb16, rodzaj);
	 ang[akt_gleb].rodzaj_oc_ht[ ang[akt_gleb].indeks ] = rodzaj;
	 if (ocena!=INT_MAX) {
	   statystyka_dla_analizy.wez_ht++;
	   goto Zapamietaj_ocene_ale_nie_w_ht;
	 } 
       }
       UaktualnijRobaki(rozgrywka, akt_gleb);
       UaktualnijMargSklBezp(akt_gleb);
       // ruch zrobiony, teraz ocen lub idz w glab
       if (akt_gleb < ost_gleb)
         {
         UaktualnijCiete(akt_gleb, 0);  // 0 oznacza, ze akt_gleb < ost_gleb
	 // zapamietaj limity sex
	 ang[akt_gleb].ost_gleb  =ost_gleb;
	 ang[akt_gleb+1].sex_limit      = ang[akt_gleb].sex_limit;
	 ang[akt_gleb+1].sex_limit_podw = ang[akt_gleb].sex_limit_podw;
	 // dodaj grozby
	 ang[akt_gleb].grozby.ile=0; 	 ang[akt_gleb].grozby.ile_ze_zd=0;
	 if (akt_gleb<ost_gleb-1) {
	   //  if ( akt_gleb>=2 || ang[1].sex_limit)  // teraz akt_gleb>=1, czyli zawsze wykonuj
	   {
	     ang[akt_gleb].grozby.DodajGrozby(rozgrywka, ang[akt_gleb].rozgr2,
					      ang[akt_gleb].rozgr3,
					      ang[akt_gleb].plansz_p, 
					      ang[akt_gleb-1].skl_tab, ang[akt_gleb].skl_tab, 
					      ang[akt_gleb].indeks);
	     ang[akt_gleb].grozby.UstawSing();
	     for (int i=up.lg; i<=up.pd; i++) TAnaliza::historia_sort[i]=1;
	   }
	   // sprawdz, czy powinnismy zrobic ,,singular extension''
	   if (//akt_gleb>=2 && 
	       ang[akt_gleb-1].grozby.ile_sing && 
	       ang[akt_gleb].sex_limit && 
	       (ang[akt_gleb-1].grozby.ile_sing==1 || ang[akt_gleb].sex_limit_podw)) {
	     // sprawdz, czy byla grozba singul
	     for (int i=0; i<ang[akt_gleb-1].grozby.ile; i++)
	       if ((ang[akt_gleb-1].grozby.czy[i] & 1) &&   // czy singularna
		   ang[akt_gleb-1].grozby.lista[i] == ang[akt_gleb].indeks) {
		 // trzeba wydluzyc!!
		 ang[akt_gleb+1].sex_limit--;
		 if (ang[akt_gleb-1].grozby.ile_sing>=2) ang[akt_gleb+1].sex_limit_podw--;
		 ost_gleb++;
		 break;
	       }
	   }
	 }
	 else if (TAnaliza::gracz.umiejetnosci & 0x100)   // queiscence search
	   ang[akt_gleb].grozby.DodajGrozby(rozgrywka, ang[akt_gleb].rozgr2,
					    ang[akt_gleb].rozgr3,
					    ang[akt_gleb].plansz_p,
					    ang[akt_gleb-1].skl_tab, ang[akt_gleb].skl_tab, 
					    ang[akt_gleb].indeks);
         akt_gleb++;
         if (ost_gleb>=3 && akt_gleb<ost_gleb)
           DodajSasiadow(schemat_ruchow, akt_gleb, ost_gleb);
	 else {
	   ang[akt_gleb-1].propoz[0][ang[akt_gleb-1].indeks]=0;
	   ang[akt_gleb-1].propoz[1][ang[akt_gleb-1].indeks]=0;
	 }
	 goto Analizuj_nastepny;
         }
       //       else   -- to jest w QuiescenceS()
       //         UaktualnijCiete(akt_gleb, 1);  // 1 oznacza, ze akt_gleb == ost_gleb

       Ocen_pozycje:;

       ocena = QuiescenceS(rozgrywka, akt_gleb);

       Zapamietaj_ocene:;
       if (akt_gleb==ost_gleb)
	 htablicaZ.Wstaw(ang[akt_gleb].htab_zobr, akt_gleb, 
			 ocena, 0,  0,0, 0);  // 0=ocena dokladna, 
               // 0,0 - brak propozycji kontynuacji, ostatnie 0: jestesmy w lisciu
       else
	 HTWstaw(akt_gleb, ost_gleb, ost_gleb16, ocena,
		 (ocena>=ang[akt_gleb].beta) ? 1 :        // 1 = ogr. dolne
		 ((ocena<=ang[akt_gleb].alfa) ? 2 : 0),  // .alfapocz ?; 2 = ogr. gorne
		 ang[akt_gleb].propoz[0][ang[akt_gleb].indeks],
		 ang[akt_gleb].propoz[1][ang[akt_gleb].indeks] );
       Zapamietaj_ocene_ale_nie_w_ht:;

       // usun kropke z rozgr2,3, rozgrywka
       ang[akt_gleb-1].OdtworzRozgr23pp();
       rozgrywka[ ang[akt_gleb].indeks ]=0;
       ang[akt_gleb].robaki[0].UsunKropke();       ang[akt_gleb].robaki[1].UsunKropke();
#ifndef TEKSTOWY
       if (akt_gleb<=pokaz_analize_max_gleb && akt_gleb<=7) {  // <=8 wymaga zmiany w ekran.cc:OcenionyRuch()
	 TSekwencjaRuchow ruchy;
	 for (int i=1; i<= akt_gleb; i++) {
	   ruchy.r[i-1].x = ang[i].x-2;  ruchy.r[i-1].y = ang[i].y-2;
	   ruchy.r[i-1].ile_zam = ang[i].stopy1 - ang[i].stopy0;
	 }
	 ekran.OcenionyRuch(ang[0].ost_gleb, ang[akt_gleb].ost_gleb_max, ocena, &ruchy, akt_gleb);
       }
#endif

         if (ZapamietajOcene12(ocena, akt_gleb, ost_gleb, nruchy, liczba_nruchow, 
			       x, y, 1+bez_ciec_beta))
	   break;   // ciecie beta
	 
	 // sprawdz czas
	 if (akt_gleb+2<=ost_gleb &&
	     (akt_gleb+3<=ost_gleb || akt_gleb<=2)) {
	   if (TAnaliza::gracz.czas_kiedy>=2 &&
	       (TAnaliza::gracz.czas_kiedy>2 ||
		(akt_gleb==1 && ang[1].nr_ruchu>ang[1].pocz_ruch)))
	     if (TAnaliza::czas.CzyJuz(TAnaliza::gracz.czas_sek, TAnaliza::gracz.czas_ssek)) {
	       TAnaliza::czas_przekr = 1;
	       return -ang[0].ocena;
	     }
#ifndef TEKSTOWY
	   if (TAnaliza::czas_przekr==2 && (akt_gleb==1 && ang[1].nr_ruchu>ang[1].pocz_ruch))
	     return -ang[0].ocena;   // wyjdz -- wcisnieto przycisk
	   // sprawdz klawiature
	   switch (ekran.CzyPrzerwacAnalize()) {
	   case -1:
	     TAnaliza::czas_przekr = 0;  // anuluj przerywanie analizy
	     break;
	   case 1:
	     TAnaliza::czas_przekr = 1;  // przerwij po glebokosci
	     break;
	   case 2:
	     TAnaliza::czas_przekr = 2;  // przerwij po zakonczeniu ruchu
	     break;
	   case 3:
	     TAnaliza::czas_przekr = 3;
	     return -ang[0].ocena;       // przerwij natychmiast
	   }
#endif
	 }
	 /*	 // przyspieszanie analizy (dla testu b. duzych glebokosci):
	 switch (random(10)) {
	 case 0: 
	 case 1:
	   break;
	 case 2: 
	 case 3:
	   ang[akt_gleb].nr_ruchu+=random(20); 
	   if (ang[akt_gleb].nr_ruchu>=ang[akt_gleb].ost_ruch)
	     ang[akt_gleb].nr_ruchu=ang[akt_gleb].ost_ruch-1;
	   break;
	 default:
	   ang[akt_gleb].nr_ruchu=ang[akt_gleb].ost_ruch-1;
	   break;
	   } */
       }
 Kolejny_ruch:;
     ang[akt_gleb].nr_ruchu++;
     if (akt_gleb<ost_gleb-1 && ang[akt_gleb].najlepszyr) { // && akt_gleb>=3) {
       // sortuj
       int najlepszy = ang[akt_gleb].najlepszyr;
       int pocz = ang[akt_gleb].nr_ruchu+1;
       if (akt_gleb==1 && pocz<ang[akt_gleb].pocz_ruch+4) pocz=ang[akt_gleb].pocz_ruch+4;   // tutaj nie przesuwaj za blisko poczatku
       int j=pocz;
       while (j<ang[akt_gleb].ost_ruch && ang[akt_gleb].lista_ruchow[j]!=najlepszy) j++;
       if (j<ang[akt_gleb].ost_ruch) {
	 // przenies ruchy w gore
	 for (int i=j; i>pocz; i--)
	   ang[akt_gleb].lista_ruchow[i] = ang[akt_gleb].lista_ruchow[i-1];
	 ang[akt_gleb].lista_ruchow[pocz] = najlepszy;
       }
     }
     }
 Ciecie_beta:;
   // przeszlismy cala galaz
   // zdejmij ze stosu
   akt_gleb--;
   if (ost_gleb>=3 && akt_gleb<ost_gleb-1) UsunSasiadow(schemat_ruchow, akt_gleb);
   ost_gleb = ang[akt_gleb].ost_gleb;
   // uwzglednij ocene ostatniej galezi, jesli jest oceniona
   if (akt_gleb>=1)
     {
     ocena = ang[akt_gleb].ocena;
     //     if (akt_gleb==1 && zapamietuj_drugi_ruch) drugi_ruch.Zapisz();
     if (ocena==INT_MAX)
       goto Ocen_pozycje;
     else
       goto Zapamietaj_ocene;  // usun kropke -- to jest w Zapamietaj_ocene
     }
   return -ang[0].ocena;
}


int ZnajdzNajlepszyRuch12(unsigned char* rozgrywka_arg, unsigned char* plansz_p_arg,
			  int ktory_gracz, const TGraczO &gracz,
			  krint *nruchy, int &x, int &y, int st_x, int st_y,
			  TZdobycze zdob_arg[2], TZobrist zobr_arg, int wybierz_ruchy)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
{
 int liczba_nruchow=0;
 if (st_x==0 && st_y==0)
	{
	// to jest pierwsza kropka!
     int margx = (wlkx>>2)-1;
     margx=margx<2 ? 2:margx;
     int margy = (wlky>>2)-1;
     margy=margy<2 ? 2:margy;
     x = 2+margx+random(wlkx-2*margx);
     y = 2+margy+random(wlky-2*margy);
     nruchy[0]=WezIndeksTab(x,y);
	return 1;
	}
 TAnaliza::gracz = gracz;    
 TRobaki::waga_kropki = gracz.waga_kropki;
 gracz_umiejetnosci = gracz.umiejetnosci;

 strcpy(TAnaliza::gracz.imie, gracz.imie);   // to ulatwia dodawanie testowych opcji...
 TAnaliza::czas_przekr=0;
 TAnaliza::czas.Zeruj();   TAnaliza::czas.Start();
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
 x=0; y=0;  // potrzebne w petli zwiekszajacej glebokosc
 if (ile_wolnego_poza) { // sa jakies wolne miejsca poza stalymi stopami

#ifndef TEKSTOWY
   if (gracz.dokl_analizy>=4) ekran.PoczatekAnalizy();
#endif
   int potrzeba_pamieci = gracz.dokl_analizy+1 + 
     ((gracz.dokl_analizy>=4) ? (gracz.sex_limit+gracz.sex_limit_podw) : 0) +
     ((gracz.dokl_analizy>=2) ? ((gracz.umiejetnosci & 0x100)!=0) : 0);
   // zapamietaj rozgrywke i plansz_p
   unsigned char* plansz_p  = plansze.PrzydzielPlansze();
   unsigned char* rozgrywka = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   KopiujTablice(rozgrywka, rozgrywka_arg);
   KopiujTablice(plansz_p, plansz_p_arg);
   ang[0].zdobycze[0] = zdob_arg[0];   ang[0].zdobycze[1] = zdob_arg[1];
   ang[0].htab_zobr = zobr_arg;
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   TDwaUC marg_min[4], marg_max[4];
   int ile_ruchow, ile_ruchow_przec;
   krint *kolejne_ruchy  = skladowe.PrzydzielSkladowa();
   krint *ruchy_przec    = skladowe.PrzydzielSkladowa();
   unsigned char *schemat_ruchow = plansze.PrzydzielPlansze();
   ang[0].zagrozenia = skladowe.PrzydzielSkladowa();
   ang[1].zagrozenia = skladowe.PrzydzielSkladowa();

   ZnajdzListeRuchow12(rozgrywka, plansz_p,
		       rozgr2, rozgr3,
		       skl_tab, 
		       marg_min,  marg_max,
		       ile_ruchow, ile_ruchow_przec,
		       kolejne_ruchy,  ruchy_przec,
		       schemat_ruchow,
		       gracz,
			 ktory_gracz
		       );
     
   if (ile_ruchow==1) {
     x=upl_x[kolejne_ruchy[0]];
     y=upl_y[kolejne_ruchy[0]];
     nruchy[0]=WezIndeksTab(x,y);
     liczba_nruchow =
       ZnajdzDomyslneRuchy(rozgrywka_arg, plansz_p_arg,
			   ktory_gracz,	nruchy, st_x, st_y);
     /*
     liczba_nruchow=1;

     KopiujTablice(rozgrywka, rozgrywka_arg);
     KopiujTablice(plansz_p, plansz_p_arg);
     int ile_domysl, ile_zd,pow,pow2,ile_zd2;
     ZrobRuch(rozgrywka, NULL, &nruchy[1], ile_domysl,
	      NULL, 0, plansz_p, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
	      ang[1].zdobycze, ang[1].htab_zobr,
	      ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, NULL, NULL);
     liczba_nruchow += ile_domysl;
     */
     goto Zwolnij_pamiec;
   }

   // znajdz dodatkowe bezsensowne ruchy, co wymaga wstepnego
   // zainicjowania niektorych pol ang[]
   ang[0].rozgr2   = rozgr2;
   ang[0].rozgr3   = rozgr3;
   ang[0].plansz_p = plansz_p;
   ang[0].marg0_min = marg_min[0];
   ang[0].marg0_max = marg_max[0];
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].UstawBezpNaZawsze();
   ang[0].UstawLancuchyWplanszp();  // eksperymentalne: 83.30+
   ang[0].DodajBezsensowne(schemat_ruchow);
   // teraz usun z list ruchow bezsensowne
   {
     int dokad=0, ruch=kolejne_ruchy[random(ile_ruchow)];
     for (int skad=0; skad<ile_ruchow; skad++)
       if (schemat_ruchow[kolejne_ruchy[skad]]!=0xff)
	 kolejne_ruchy[dokad++] = kolejne_ruchy[skad];
     ile_ruchow=dokad;
     if (ile_ruchow<=1) {
       if (ile_ruchow==0) { // wez wczesniej wylosowany ruch
	 x=upl_x[ruch];
	 y=upl_y[ruch];
       }
       else {
	 x=upl_x[kolejne_ruchy[0]];
	 y=upl_y[kolejne_ruchy[0]];
       }
       liczba_nruchow=1;
       nruchy[0]=WezIndeksTab(x,y);
       liczba_nruchow =
	 ZnajdzDomyslneRuchy(rozgrywka_arg, plansz_p_arg,
			     ktory_gracz, nruchy, st_x, st_y);

       /*
       KopiujTablice(rozgrywka, rozgrywka_arg);
       KopiujTablice(plansz_p, plansz_p_arg);
       int ile_domysl, ile_zd,pow,pow2,ile_zd2;
       ZrobRuch(rozgrywka, NULL, &nruchy[1], ile_domysl,
		NULL, 0, plansz_p, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
		ang[1].zdobycze, ang[1].htab_zobr,
		ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, NULL, NULL);
       liczba_nruchow += ile_domysl;
       */
       goto Zwolnij_pamiec2;
     }
     // teraz przeciwnika:
     dokad=0;
     for (int skad=0; skad<ile_ruchow_przec; skad++)
       if (schemat_ruchow[ruchy_przec[skad]]!=0xff)
	 ruchy_przec[dokad++] = ruchy_przec[skad];
     ile_ruchow_przec=dokad;
   }

   
   { 
   int docelowa_gleb=gracz.dokl_analizy;
   // przydziel pamiec na grozby:
   int ile_potrzeba_na_1_grozbe = (wlkx*wlky*2)/3;
   int ile_potrzeba_na_grozby = (potrzeba_pamieci+1) * ile_potrzeba_na_1_grozbe;
   ang[0].grozby.lista    = new krint[ile_potrzeba_na_grozby];
   ang[0].grozby.zdobycze = new krint[ile_potrzeba_na_grozby];
   ang[0].grozby.id       = new unsigned long int[ile_potrzeba_na_grozby];
   ang[0].grozby.czy      = new unsigned char[ile_potrzeba_na_grozby];
   ang[0].grozby.ile      = 0;
   ang[0].grozby.ile_ze_zd= 0;
   ang[0].stopy_wykonane  = skladowe.PrzydzielSkladowa();
   // przydziel pamiec, zainicjuj ang
   for (int i=0; i<=potrzeba_pamieci /*docelowa_gleb*/; i++) {
     ang[i].stopy0 = ang[i].stopy1 = 0;
     // grozby:
     if (i) {
       ang[i].grozby.lista    = &ang[i-1].grozby.lista[ile_potrzeba_na_1_grozbe];
       ang[i].grozby.zdobycze = &ang[i-1].grozby.zdobycze[ile_potrzeba_na_1_grozbe];
       ang[i].grozby.id       = &ang[i-1].grozby.id[ile_potrzeba_na_1_grozbe];
       ang[i].grozby.czy      = &ang[i-1].grozby.czy[ile_potrzeba_na_1_grozbe];
       ang[i].grozby.ile      = 0;
       ang[i].grozby.ile_ze_zd= 0;
     }
     ang[i].grozby.zawarte = skladowe.PrzydzielSkladowa();
     ang[i].tab_pp=plansze.PrzydzielPlansze();
     ang[i].tab_r2=plansze.PrzydzielPlansze();
     ang[i].tab_r3=plansze.PrzydzielPlansze();
     ang[i].propoz[0]= i ? skladowe.PrzydzielSkladowa() : NULL;
     ang[i].propoz[1]= i ? skladowe.PrzydzielSkladowa() : NULL;
     //     if (i) {  // dla testu, teoretycznie niepotrzebne
     //  CzyscTablice(ang[i].propoz[0]);  CzyscTablice(ang[i].propoz[1]); }
     ang[i].bandy.Inicjuj();
     ang[i].skl_tab=(i==0) ? skl_tab : skladowe.PrzydzielSkladowa();
     if (i>=2) ang[i].zagrozenia = skladowe.PrzydzielSkladowa();
     ang[i].pocz_ruch=0;
     //     ang[i].historia_waga = (i<=docelowa_gleb) ? (1 << (docelowa_gleb-i)) : 0;
     ang[i].historia_waga=0;  // ustawiamy pozniej...
     if (i<potrzeba_pamieci) //docelowa_gleb)
       ang[i].oceny_ht =tabliceLI.Przydziel();
     ang[i].rodzaj_oc_ht=plansze.PrzydzielPlansze();
     if (i&1) {
       ang[i].ktory_teraz = ktory_gracz;
       ang[i].lista_ruchow= kolejne_ruchy;
       ang[i].ost_ruch = ile_ruchow;
       ang[i].lista_ruchow_pelna = kolejne_ruchy;
       ang[i].ile_ruchow_pelna   = ile_ruchow;
       ang[i].maska_lisc         = 1;
       ang[i].maska_upr          = 4; 
       ang[i].maska_pelna        = 0x10; }
     else {
       ang[i].ktory_teraz = 3-ktory_gracz;
       ang[i].lista_ruchow= ruchy_przec;
       ang[i].ost_ruch = ile_ruchow_przec;
       ang[i].lista_ruchow_pelna = ruchy_przec;
       ang[i].ile_ruchow_pelna   = ile_ruchow_przec;
       ang[i].maska_lisc         = 2;
       ang[i].maska_upr          = 8; 
       ang[i].maska_pelna        = 0x20; }
     if (i>2)
       ang[i].lista_ruchow=skladowe.PrzydzielSkladowa();
     // robaki:
     ang[i].robaki[0].Przydziel();
     ang[i].robaki[1].Przydziel();
     ang[i].robaki[0].UstawCzyje(1, TAnaliza::gracz.umiejetnosci & 0x10);
     ang[i].robaki[1].UstawCzyje(2, TAnaliza::gracz.umiejetnosci & 0x10);
     }
   krint *lista_lisc     = skladowe.PrzydzielSkladowa();
   osk12.PrzydzielPamiec();
   // zainicjuj ang[0]
   //   ang[0].htab_zobr.Zeruj();  // na wszelki wypadek  -- NIE MOZNA JUZ (83.44)
   ang[0].zyski    = 0;
   ang[0].straty   = 0;
   ang[0].byl_stop = 0;
   ang[0].jest_stop_sstop = 0;
   ang[0].nr_ruchu = 0;
   //ang[0].indeks   = 0;   // zeby moc bezpiecznie ,,odtworzyc'' zmienne
   ang[0].x = st_x;                            // ustaw poprzedni ruch
   ang[0].y = st_y;                            //
   ang[0].indeks = WezIndeksTab(st_x, st_y);   //
   ang[0].ktory_teraz = 3-ktory_gracz;
   ang[1].sex_limit_podw = (docelowa_gleb>=4) ? gracz.sex_limit_podw : 0;
   ang[1].sex_limit      = (docelowa_gleb>=4) ? (gracz.sex_limit_podw + gracz.sex_limit) : 0;
   ang[0].InicjujCiecia(rozgr3);
   ang[0].bandy.UstawBezpieczne(rozgr3);
   ang[0].sasiedzi.ile_p   = ang[0].sasiedzi.ile_n = ang[0].sasiedzi.ile_lisc = 0;
   ang[1].sasiedzi.ile_p   = ang[1].sasiedzi.ile_n = ang[1].sasiedzi.ile_lisc = 0;
   ang[0].robaki[0].Inicjuj(rozgrywka, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[1].Inicjuj(rozgrywka, rozgr2, rozgr3, plansz_p);
   //drugi_ruch.Inicjuj();
// inicjuj pola statyczne
   ang[0].sasiedzi.tab_sas = plansze.PrzydzielPlansze();
   CzyscTablice(ang[0].sasiedzi.tab_sas);
   for (int i=0; i<wlkx4wlky4; i++) TAnaliza::historia_sort[i]=1;
   memset(TAnaliza::historia, 0, wlkx4wlky4*sizeof(TAnaliza::historia[0]));
   TAnaliza::historia_max = 0;
   TAnaliza::symetrie = plansze.PrzydzielPlansze();
   UstawSymetrie(rozgrywka);
#ifndef TEKSTOWY
   if (wybierz_ruchy) {
     unsigned char *wr = plansze.PrzydzielPlansze();
     CzyscTablice(wr);
     for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++) {
       unsigned int ind = ang[1].lista_ruchow[i];
       wr[ind] |= 1;
       if (!TAnaliza::symetrie[ind]) wr[ind]|=2;
     }
     switch (ekran.WezListeRuchow(wr)) {
     case 0:
       break;  // escape = nic nie rob
     case -1:
       TAnaliza::sa_symetrie=0;   // zaakceptowane wszystkie ruchy
       break;
     case 1:
       // wzielismy nietrywialna liste ruchow!
       CzyscTablice(TAnaliza::symetrie);
       TAnaliza::sa_symetrie=1;
       for (int i=0; i<wlkx4wlky4; i++)
	 if ((wr[i] & 4)==0)              // ruch zostal wybrany,
	   TAnaliza::symetrie[i]=1;       // wiec usun go z analizy
       break;
     }
     plansze.ZwolnijPlansze(wr);
   }
#endif
   
   // przenies wybrane ruchy w gore listy
   if (TAnaliza::sa_symetrie)
     for (int i=ang[1].pocz_ruch; i<ang[1].ost_ruch; i++) {
       unsigned int ind = ang[1].lista_ruchow[i];
       if (!TAnaliza::symetrie[ind]) {
	 // znajdz ostatni wybrany ruch na liscie, przenies posrednie w gore o jeden
	 int ost=i-1;
	 while (ost>=ang[1].pocz_ruch && TAnaliza::symetrie[ ang[1].lista_ruchow[ost] ]) {
	   ang[1].lista_ruchow[ost+1] = ang[1].lista_ruchow[ost];
	   ost--;
	 }
	 ang[1].lista_ruchow[ost+1] = ind;
       }
     }

   //test_sasiadow.Inicjacja();

#ifndef TEKSTOWY
#ifndef DEBUG_PELNAANALIZA
   if (docelowa_gleb>3)
#endif
      ekran.MinimaxPoczatek();
#endif
//#define POKAZ_MYSLENIE
   {
     TGraczO grtmp;
     grtmp = gracz;
     if (ktory_gracz==2)
       grtmp.Odbij();
     htablicaZ.AnulujWpisy(grtmp);  // to jest b. szybkie, wiec nie trzeba (ost_gleb>2)
   }
   for (int ost_gleb=2; ost_gleb<=docelowa_gleb; ost_gleb++)
   {
#ifndef TEKSTOWY
     int pokaz_analize_max_gleb = std::min(ost_gleb-3, 4);
#endif
   htablicaZ.NowaGlebokosc();  // to jest b. szybkie, wiec nie trzeba (ost_gleb>2)
   osk12.Zeruj();
   for (int i=1; i<ost_gleb; i++)
     ang[i].historia_waga = (2<<(ost_gleb-i));
   ang[ost_gleb].historia_waga = 1;
   // ustaw listy ruchow (uproszczone i liscie sa tez w DodajSasiadow())
   switch (ost_gleb)
     {
     case 2:
       if (docelowa_gleb>2) {
	 // posortuj ruchy na pelnej liscie
	 ang[2].lista_ruchow = ang[2].lista_ruchow_pelna;
	 ang[2].ost_ruch     = ang[2].ile_ruchow_pelna;
	 SortujRuchyA(rozgrywka, 2);
       }
       //SortujRuchyA(rozgrywka, 1);
       // ustaw ruchy w lisciu
       ang[2].lista_ruchow = lista_lisc;
       {
       int dokad=0;
       for (int i=0; i<ang[2].ile_ruchow_pelna; i++) {
	 unsigned int ind = ang[2].lista_ruchow_pelna[i];
	 if ((schemat_ruchow[ind] & ang[2].maska_lisc)!=0) {
	   ang[2].lista_ruchow[dokad++] = ind;
	 }
       }
       ang[2].ost_ruch = dokad;
       }
      break;
     case 3:
      ang[2].lista_ruchow = ang[2].lista_ruchow_pelna;
      ang[2].ost_ruch     = ang[2].ile_ruchow_pelna;
      break;
     }

   ang[1].alfapocz = ang[1].alfa = -INT_MAX;
   ang[1].beta     = INT_MAX; 
   int ocena = AlfaBeta12(rozgrywka, schemat_ruchow, ost_gleb, gracz, 
#ifndef TEKSTOWY
#ifdef DEBUG_PELNAANALIZA
			  ost_gleb,
#else
			  (docelowa_gleb>3) ? pokaz_analize_max_gleb : -1, 
#endif
#endif
			  nruchy, liczba_nruchow, x,y,
			  (docelowa_gleb>=5 && ost_gleb==2));
                   //	  (ost_gleb>3 && ost_gleb<docelowa_gleb));   // to nie przyspiesza!!

   if (x==0) {
     // trzeba wylosowac jakis ruch -- sa same bezsensowne!
     int ile_wolnego, ile_wolnego_poza;
     IleWolnegoMiejsca(rozgrywka_arg, plansz_p_arg, ile_wolnego, ile_wolnego_poza);
     int ktory=random(ile_wolnego_poza);
     for (int i=0; i<wlkx; i++)
       {
	 unsigned int indeks=WezIndeksTab(i+2,2);
	 for (int j=0; j<wlky; j++)
	   {
	     if ((plansz_p_arg[indeks] & 0xf)==0 &&  // nie wewnatrz stopu
		 rozgrywka_arg[indeks]==0)        // nie ma tu jeszcze kropki
	       if ((ktory--) ==0) {
		 x=i+2; y=j+2;
		 nruchy[0]=WezIndeksTab(x,y);
		 liczba_nruchow =
		   ZnajdzDomyslneRuchy(rozgrywka_arg, plansz_p_arg,
				       ktory_gracz, nruchy, st_x, st_y);
		 /*
		 liczba_nruchow=1;

		 KopiujTablice(rozgrywka, rozgrywka_arg);
		 KopiujTablice(plansz_p, plansz_p_arg);
		 int ile_domysl, ile_zd,pow,pow2,ile_zd2;

		 ZrobRuch(rozgrywka, NULL, &nruchy[1], ile_domysl,
			  NULL, 0, plansz_p, nruchy[0], ktory_gracz, WezIndeksTab(st_x, st_y),
			  ang[1].zdobycze, ang[1].htab_zobr,
			  ile_zd,pow,pow2,ile_zd2, ruchy_zam_NULL, NULL, NULL);
		 liczba_nruchow += ile_domysl;
		 */
		 goto Koniec_analizy;
	       }
	     indeks++;
	   }
       }
   }
   // sprawdz, czy trzeba wyjsc z analizy
   if (TAnaliza::czas_przekr || 
       (TAnaliza::gracz.czas_kiedy>=1 && 
	TAnaliza::czas.CzyJuzPolowa(TAnaliza::gracz.czas_sek, TAnaliza::gracz.czas_ssek))) {
     TAnaliza::czas_przekr = 1;
     break;  // wyjdz z analizy
   }

   }  // koniec analizy

   Koniec_analizy:;

   //test_sasiadow.Koniec();
   // koniec
   plansze.ZwolnijPlansze(TAnaliza::symetrie);
   plansze.ZwolnijPlansze(ang[0].sasiedzi.tab_sas);
   skladowe.ZwolnijSkladowa(lista_lisc);
   delete[] ang[0].grozby.lista;
   delete[] ang[0].grozby.zdobycze;
   delete[] ang[0].grozby.id;
   delete[] ang[0].grozby.czy;
   skladowe.ZwolnijSkladowa(ang[0].stopy_wykonane);
   for (int i=0; i<=potrzeba_pamieci /*docelowa_gleb*/; i++)
     {
     ang[i].bandy.Zwolnij();
     plansze.ZwolnijPlansze(ang[i].tab_pp);
     plansze.ZwolnijPlansze(ang[i].tab_r2);
     plansze.ZwolnijPlansze(ang[i].tab_r3);
     skladowe.ZwolnijSkladowa(ang[i].grozby.zawarte);
     if (i) {
       skladowe.ZwolnijSkladowa(ang[i].skl_tab);
       skladowe.ZwolnijSkladowa(ang[i].propoz[0]);
       skladowe.ZwolnijSkladowa(ang[i].propoz[1]);
     }
     if (i>=2) 
       skladowe.ZwolnijSkladowa(ang[i].zagrozenia);
     if (i<potrzeba_pamieci) //docelowa_gleb)
       tabliceLI.Zwolnij(ang[i].oceny_ht);
     plansze.ZwolnijPlansze(ang[i].rodzaj_oc_ht);
     if (i>2)  skladowe.ZwolnijSkladowa(ang[i].lista_ruchow);
     // robaki:
     ang[i].robaki[0].Zwolnij();
     ang[i].robaki[1].Zwolnij();
     }
   }
   osk12.ZwolnijPamiec();
   
 Zwolnij_pamiec2:;
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);

   Zwolnij_pamiec:;
#ifndef TEKSTOWY
#ifndef DEBUG_PELNAANALIZA
   if (gracz.dokl_analizy>=4)
#endif
      ekran.KoniecAnalizy();
#endif

   skladowe.ZwolnijSkladowa(ang[1].zagrozenia);
   skladowe.ZwolnijSkladowa(ang[0].zagrozenia);
   plansze.ZwolnijPlansze(schemat_ruchow);
   plansze.ZwolnijPlansze(rozgrywka);
   plansze.ZwolnijPlansze(plansz_p);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(ruchy_przec);
   skladowe.ZwolnijSkladowa(kolejne_ruchy);
   skladowe.ZwolnijSkladowa(skl_tab);
   return liczba_nruchow;
 }
else if (ile_wolnego)
  return GraKoncowa(rozgrywka_arg, plansz_p_arg, ktory_gracz, nruchy, x, y, st_x, st_y);
x=-1; y=-1;
return 0;
}
/****************************************************************************/

int ZnajdzNajlepszyRuch(unsigned char* rozgrywka, unsigned char* plansz_p,
			int ktory_gracz, int poziom_gry, int umiejetnosci,
			krint *nruchy, int &x, int &y, int st_x, int st_y)
// znajduje najlepszy ruch
// zwraca polozenie w (x,y)
// (st_x,st_y) - polozenie ostatnio postawionej kropki przeciwnika
//     (=0 - teraz pierwsza kropka)
{
 if (st_x==0 && st_y==0)
   {
   // to jest pierwsza kropka!
     int margx = (wlkx>>2)-1;
     margx=margx<2 ? 2:margx;
     int margy = (wlky>>2)-1;
     margy=margy<2 ? 2:margy;
     x = 2+margx+random(wlkx-2*margx);
     y = 2+margy+random(wlky-2*margy);
     nruchy[0] = WezIndeksTab(x,y);
   return 1;
   }
 int ile_wolnego, ile_wolnego_poza;
 IleWolnegoMiejsca(rozgrywka, plansz_p, ile_wolnego, ile_wolnego_poza);

 if (ile_wolnego_poza)  // sa jakies wolne miejsca poza stalymi stopami
   {
   // zapamietaj rozgrywke i plansz_p
   unsigned char* t1 = plansze.PrzydzielPlansze();
   unsigned char* t2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   KopiujTablice(t1, rozgrywka);
   KopiujTablice(t2, plansz_p);
   WezRozgr23(rozgrywka, rozgr2, rozgr3, plansz_p);
   // przygotuj tablice z numerami skladowych (wersja 20+)
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   CzyscTablice(skl_tab);
   int margx_min=wlkx+2, margx_max=0, margy_min=wlky+2, margy_max=0;
   {
   unsigned int num_skl_n=1;
   unsigned int num_skl_p=30001;
   TDwaUC p;
   for (p.x=2; p.x<wlkx+2; p.x++)
    for (p.y=2; p.y<wlky+2; p.y++)
      {
      unsigned int indeks_ij = WezIndeksTab(p.x,p.y);
      unsigned char kr=rozgr2[indeks_ij];
      if (kr!=0)
        {
        if (p.x<margx_min) margx_min=p.x;
        if (p.x>margx_max) margx_max=p.x;
        if (p.y<margy_min) margy_min=p.y;
        if (p.y>margy_max) margy_max=p.y;
        if (skl_tab[indeks_ij]==0)
        if (kr==ktory_gracz)
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_n++, indeks_ij);
        else
          ZnajdzSkladowa(skl_tab, rozgr2, num_skl_p++, indeks_ij);
        }
      }
   }
   // przygotuj tablice z zapamietanymi premiami
   unsigned char* premie = plansze.PrzydzielPlansze();
   CzyscTablice(premie);
   if (poziom_gry>6)
     {
     for (int i=margx_min; i<=margx_max-2; i++)   // -2, bo 2 kropki na prawo musi byc kropka
      for (int j=margy_min; j<=margy_max; j++)
       {
       unsigned int indeks_ij = WezIndeksTab(i,j);
       unsigned int akt_s=skl_tab[indeks_ij];
       if (akt_s==0) continue;
       if (akt_s==WezUI(skl_tab,i+2,j+2))
         { // szansa! sa 2 kropki jednego koloru w opozycji przekatnej
         unsigned int inna_s=WezUI(skl_tab,i+1,j+1);
         if (inna_s!=0 &&
              ((inna_s <30000 && akt_s>=30000) ||
               (inna_s>=30000 && akt_s <30000)) )
           {
           // pozostaje sprawdzic, czy pola sa wolne
           if (i>2 && j<wlky-1 &&
                !WezUI(skl_tab,i-1,j+1) && !WezUI(skl_tab,i,j+1) &&
                !WezUI(skl_tab,i  ,j+2) && !WezUI(skl_tab,i+1,j+2) &&
                !WezUI(skl_tab,i+1,j+3))
             {
             WezUC(premie,i,j+2)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i-1,j+1)+=4;
               WezUC(premie,i  ,j+1)+=6;
               WezUC(premie,i+1,j+2)+=6;
               WezUC(premie,i+1,j+3)+=4;
               }
             }
           // a moze pola sa wolne po przeciwnej stronie?
           if (j>2 && i<wlkx-1 &&
                !WezUI(skl_tab,i+1,j-1) && !WezUI(skl_tab,i+1,j  ) &&
                !WezUI(skl_tab,i+2,j  ) && !WezUI(skl_tab,i+1,j+1) &&
                !WezUI(skl_tab,i+3,j+1))
             {
             WezUC(premie,i+2,j)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i+1,j-1)+=4;
               WezUC(premie,i+1,j  )+=6;
               WezUC(premie,i+2,j+1)+=6;
               WezUC(premie,i+3,j+1)+=4;
               }
             }
           }
         }
       // druga przekatna
       if (akt_s==WezUI(skl_tab,i+2,j-2))
         { // szansa! sa 2 kropki jednego koloru w opozycji przekatnej
         unsigned int inna_s=WezUI(skl_tab,i+1,j-1);
         if (inna_s!=0 &&
              ((inna_s <30000 && akt_s>=30000) ||
               (inna_s>=30000 && akt_s <30000)) )
           {
           // pozostaje sprawdzic, czy pola sa wolne
           if (i>2 && j>4 &&
                !WezUI(skl_tab,i-1,j-1) && !WezUI(skl_tab,i,j-1) &&
                !WezUI(skl_tab,i  ,j-2) && !WezUI(skl_tab,i+1,j-2) &&
                !WezUI(skl_tab,i+1,j-3))
             {
             WezUC(premie,i,j-2)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i-1,j-1)+=4;
               WezUC(premie,i  ,j-1)+=6;
               WezUC(premie,i+1,j-2)+=6;
               WezUC(premie,i+1,j-3)+=4;
               }
             }
           // a moze pola sa wolne po przeciwnej stronie?
           if (j<wlky+1 && i<wlkx-1 &&   // +1, -1 to nie pomylka
                !WezUI(skl_tab,i+1,j+1) && !WezUI(skl_tab,i+1,j  ) &&
                !WezUI(skl_tab,i+2,j  ) && !WezUI(skl_tab,i+2,j-1) &&
                !WezUI(skl_tab,i+3,j-1))
             {
             WezUC(premie,i+2,j)+=12;
             if (akt_s>=30000)
               {
               WezUC(premie,i+1,j+1)+=4;
               WezUC(premie,i+1,j  )+=6;
               WezUC(premie,i+2,j-1)+=6;
               WezUC(premie,i+3,j-1)+=4;
               }
             }
           }
         }
       }
     }
   // znajdz zagrozenia
   krint *zagrozenia  = skladowe.PrzydzielSkladowa();
   krint *zagrozenia2 = skladowe.PrzydzielSkladowa();
   unsigned char* zagr_pola = plansze.PrzydzielPlansze();
   CzyscTablice(zagr_pola);
   int ile_zagrozen=0, ile_zagrozen2=0;
   {
   unsigned int indeks_zagrozen =0, ost_offset =(wlkx+4)*(wlky+4)-3;
   unsigned int indeks_zagrozen2=0, ost_offset2=(wlkx+4)*(wlky+4)-8;
   if (margx_min>2) margx_min--;
   if (margy_min>2) margy_min--;
   if (margx_max<wlkx+1) margx_max++;
   if (margy_max<wlky+1) margy_max++;
   for (int i=margx_min; i<=margx_max; i++)
    for (int j=margy_min; j<=margy_max; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij)) {
      unsigned char ot[9];
      // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
      WezOtoczenieUlatw(ot, i, j, rozgr2, 3-ktory_gracz);
      int is=UstawOtoczenie(ot), jest_zagr=0;
      if (is>=2)
        {
        int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	TZdobycze wynik[2];  TZobrist zobr;
	unsigned char zap_pp = plansz_p[indeks_ij];
        int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j,3-ktory_gracz, wynik, zobr,
			    ile_zd,pow,pow2, punktacja_ss) & 3);
        if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	rozgrywka[indeks_ij]=0;  // usun kropke
        if (ile_zd>0 || pow>0)
          {
          jest_zagr=1;
          ile_zagrozen++;
          zagrozenia[indeks_zagrozen++]=(i<<8)+j;
          zagrozenia[indeks_zagrozen++]=ile_zd;
          zagrozenia[indeks_zagrozen++]=pow-pow2;
          if (indeks_zagrozen>ost_offset)
            goto Za_duzo_zagrozen;
          }
        if (js)
          {
          int dokad=(wlkx+4)*(wlky+4);
          for (int i=dokad-1; i>=0; i--)
            if (plansz_p[i]!=t2[i])
              zagr_pola[i]=1;
          KopiujTablice(plansz_p, t2);
          }
	else
	  plansz_p[indeks_ij]=zap_pp;
        }
      // sprawdz, czy jest zagrozenie w dwoch ruchach
      if (!jest_zagr && poziom_gry>=6 && is>=1 &&
          indeks_zagrozen2<ost_offset2)  {
        rozgrywka[indeks_ij]=3-ktory_gracz;  // postaw kropke
        rozgr2[indeks_ij]   =3-ktory_gracz;  // postaw kropke
	unsigned char zap_r3=rozgr3[indeks_ij];
	rozgr3[indeks_ij]   =3-ktory_gracz;  // postaw kropke
        int ile_ruchow=0;
        for (int dy=-1; dy<=1; dy++)
         for (int dx=-1; dx<=1; dx++)
           {
           int nx=i+dx, ny=j+dy;
           unsigned int indeks = WezIndeksTab(nx,ny);
           if (upl_marg[indeks]>=2 &&          // jest w planszy
               PustePole(rozgrywka, plansz_p, rozgr3, indeks)) {
             unsigned char oto[9];
             WezOtoczenieUlatw(oto, nx, ny, rozgr2, 3-ktory_gracz);
             unsigned char is=UstawOtoczenie(oto);
             if (is>=2)
               {
               // szansa na stop
               int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	       TZdobycze wynik[2];  TZobrist zobr;
	       unsigned char zap_pp = plansz_p[indeks];
               int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, nx,ny, 3-ktory_gracz,
				   wynik, zobr, ile_zd,pow,pow2, punktacja_ss) & 3);
	       // if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	       if (ile_zd)
                 {
                 if (ile_ruchow==0)
                   {
                   zagrozenia2[indeks_zagrozen2+1]=(i<<8)+j;
                   zagrozenia2[indeks_zagrozen2+2]=ile_zd;
                   zagrozenia2[indeks_zagrozen2+3]=(nx<<8)+ny;
                   }
                 else
                   {
                   zagrozenia2[indeks_zagrozen2+3+ile_ruchow]=(nx<<8)+ny;
                   if (ile_zd > zagrozenia2[indeks_zagrozen2+2])
                     zagrozenia2[indeks_zagrozen2+2] = ile_zd;
                   }
                 ile_ruchow++;
                 }
               // odtworz
               if (js)
                 KopiujTablice(plansz_p, t2);
	       else
		 plansz_p[indeks]=zap_pp;
               rozgrywka[indeks]=0;
               }
             }
           }
        //
        if (ile_ruchow>=2)
          {
          // naprawde jest zagrozenie
          zagrozenia2[indeks_zagrozen2]=ile_ruchow;
          indeks_zagrozen2+=(3+ile_ruchow);
          ile_zagrozen2++;
          }
        rozgrywka[indeks_ij]=0;  // usun kropke
        rozgr2[indeks_ij]=0;  // usun kropke
	rozgr3[indeks_ij]=zap_r3;
        }
      }
     }
   }
   Za_duzo_zagrozen:;
   // analizuj kolejne ruchy
   struct TRuch  { unsigned char x,y; long int ocena; };
   TRuch najl_ruchy[2];
   int ile_najl=0;
   najl_ruchy[0].ocena=-1000000000l;   // w praktyce to
   najl_ruchy[1].ocena=-1000000000l;   // jest -nieskonczonosc
   {
   for (int i=2; i<wlkx+2; i++)
    for (int j=2; j<wlky+2; j++)
     {
     unsigned int indeks_ij = WezIndeksTab(i,j);
     if (PustePole(rozgrywka, plansz_p, rozgr3, indeks_ij)) {
      unsigned char ot[9];
      // zawsze sprawdzaj, czy pole nie lezy wewnatrz jakiegos stopu (... & 3)
      WezOtoczenieUlatw(ot, i, j, rozgr2, ktory_gracz);
      unsigned char ile_skl= UstawOtoczenie(ot);
      long int ocena=ile_skl+ile_skl;
      int odtworz_pp=0;
      int sa_zagr=0;
      if (ile_skl>=2)
        {
        // jest szansa na stop
        int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	TZdobycze wynik[2];  TZobrist zobr;
	unsigned char zap_pp = plansz_p[indeks_ij];
        int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, i,j, ktory_gracz, wynik, zobr,
			    ile_zd,pow,pow2, punktacja_ss) & 3);
	if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	ocena+=100l*ile_zd;
        ocena+= 30l*(pow-pow2);
        if (js)
          {
          // sprawdz zagrozenia
          long int ocena_przec=0;
          unsigned int ind_zagr=0;
          unsigned char *pom=plansze.PrzydzielPlansze();
          KopiujTablice(pom, plansz_p);
          for (int z=0; z<ile_zagrozen; z++)
            {
            int x=(zagrozenia[ind_zagr] >> 8);
            int y=(zagrozenia[ind_zagr] & 0xff);
            //int straty=zagrozenia[ind_zagr++];
            //int straty_st_st=zagrozenia[ind_zagr++];
            ind_zagr+=3;
            if ((WezUC(plansz_p,x,y) & 15) ==0 && (x!=i || y!=j))
              {
              // trzeba sprawdzic zagrozenie
              int pom_int=0, straty=0, straty_st_st=0, punktacja_ss;
	      TZdobycze wynik[2];  TZobrist zobr;
              ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, x,y,3-ktory_gracz, wynik, zobr,
                          straty,straty_st_st,pom_int,punktacja_ss);
	      if (umiejetnosci & 0x10) 
		straty_st_st=punktacja_ss;
	      else
		straty_st_st-=pom_int;
              long int tymcz=100l*straty + 30l*straty_st_st;
              //if (!sa_zagr) sa_zagr=(straty!=0);
               if (straty!=0) sa_zagr++;
              if (straty && tymcz>ocena_przec)  // stale stopy olewamy
                ocena_przec=tymcz;
              // odtworz
              KopiujTablice(plansz_p, pom);
              WezUC(rozgrywka,x,y)=0;
              }
            }
          ocena-=ocena_przec;
          plansze.ZwolnijPlansze(pom);
          //memcpy(plansz_p, t2, (wlkx+4)*(wlky+4));
          odtworz_pp=1;
          }
        else {
          //WezUC(rozgrywka,i,j)=0;  // usun kropke
          goto Zadnych_nowych_stopow;
          }
        //WezUC(rozgrywka,i,j)=0;  // usun kropke
        }
      else
        {
        Zadnych_nowych_stopow:
        // nie doszly zadne (stale) stopy
        long int ocena_przec=0;
        unsigned int ind_zagr=0;
        for (int z=0; z<ile_zagrozen; z++)
          {
          int x=(zagrozenia[ind_zagr] >> 8);
          int y=(zagrozenia[ind_zagr++] & 0xff);
          int straty=zagrozenia[ind_zagr++];
          int straty_st_st=zagrozenia[ind_zagr++];
          if (x!=i || y!=j)  // nie zlikwidowalismy zagrozenia
            {
            long int tymcz=100l*straty + 30l*straty_st_st;
            if (straty && tymcz>ocena_przec)  // stale stopy olewamy
              ocena_przec=tymcz;
            //if (!sa_zagr) sa_zagr=(straty!=0);
            if (straty!=0) sa_zagr++;
            }
          }
        // sprawdz, czy kropka nie zostanie od razu zamknieta
        if (WezUC(zagr_pola,i,j))
          {
          ocena_przec+=100;
          //sa_zagr++; //=1;
          }
        ocena-=ocena_przec;
        }
      // odejmij punkty za zagrozenia
      ocena-=5*sa_zagr;
      // a teraz sprawdz stopy w 2 ruchach
      int sa_mozl2=0;
      if (ile_skl>=1 && poziom_gry>=4 && !sa_zagr)
        {
        WezUC(rozgrywka,i,j)=ktory_gracz;  // postaw kropke
        WezUC(rozgr2   ,i,j)=ktory_gracz;  // postaw kropke
        unsigned char *pom=plansze.PrzydzielPlansze();
        KopiujTablice(pom, plansz_p);
        long int ocena_max1=-1000000000l, ocena_max2=-1000000000l;
        for (int dy=-1; dy<=1; dy++)
         for (int dx=-1; dx<=1; dx++)
           {
           int nx=i+dx, ny=j+dy;
           unsigned int indeks = WezIndeksTab(nx,ny);
           if (upl_marg[indeks]>=2 &&          // jest w planszy
               (plansz_p[indeks] & 15)==0 &&   // nie wewnatrz stopu
                rozgrywka[indeks]==0)          // nie ma tu kropki
             {
             unsigned char oto[9];
             //WezOtoczenie(oto, nx, ny, plansz_p, rozgrywka, ktory_gracz);
             WezOtoczenieUlatw(oto, nx, ny, rozgr2, ktory_gracz);
             unsigned char is=UstawOtoczenie(oto);
             if (is>=2)
               {
               // szansa na stop
               int ile_zd=0, pow=0, pow2=0, punktacja_ss;
	       TZdobycze wynik[2];  TZobrist zobr;
	       unsigned char zap_pp = plansz_p[indeks];
               int js=(ZrobPanstwo(rozgrywka, NULL,NULL,NULL,plansz_p, nx,ny, ktory_gracz,
				   wynik, zobr, ile_zd,pow,pow2, punktacja_ss) & 3);
	       if (umiejetnosci & 0x10) { pow=punktacja_ss;  pow2=0; }
	       long int tymcz = 45l*ile_zd + 3l*(pow-pow2);
               if (tymcz>ocena_max1)
                 {
                 ocena_max2=ocena_max1;
                 ocena_max1=tymcz;
                 }
               else
                 if (tymcz>ocena_max2)
                   ocena_max2=tymcz;
               // odtworz
               if (js) KopiujTablice(plansz_p, pom);
	       else plansz_p[indeks]=zap_pp;
               rozgrywka[indeks]=0;
               }
             }
           }
        //
        if (ocena_max1>-1000000000l) ocena+=ocena_max1;
        if (ocena_max2>-1000000000l)
          {
          ocena+=ocena_max2;
          sa_mozl2=1;
          }
        plansze.ZwolnijPlansze(pom);
        }
      if (odtworz_pp)
        KopiujTablice(plansz_p, t2);
      rozgrywka[indeks_ij]=0;  // usun kropke
      rozgr2[indeks_ij]=0;  // usun kropke
      // sprawdz zagrozenia w dwoch ruchach
      if (!sa_mozl2 && !sa_zagr && ile_zagrozen2)
        {
        unsigned int ind_zagr=0;
        for (int z=0; z<ile_zagrozen2; z++)
          {
          int ile_ruchow=zagrozenia2[ind_zagr++];
          int x=(zagrozenia2[ind_zagr] >> 8);
          int y=(zagrozenia2[ind_zagr++] & 0xff);
          int straty=zagrozenia2[ind_zagr++];
          if (x!=i || y!=j)  // nie zlikwidowalismy zagrozenia
            {
            int ile_zneutr=0;
            for (int nz=0; nz<ile_ruchow; nz++)
              {
              x=(zagrozenia2[ind_zagr] >> 8);            // wersja 80z3: General Protection Error
              y=(zagrozenia2[ind_zagr++] & 0xff);
              if (x==i && y==j)
                ile_zneutr++;   // zlikwidowalismy zagrozenie
              }
            if (ile_ruchow-ile_zneutr <=1)
              ocena+=17*straty;   // punkty za zlikwidowanie zagrozenia
            }
          else
            {
            ind_zagr+=ile_ruchow;               // dodane w wersji 80z3
            // punkty za zlikwidowanie zagrozenia
            ocena+=34*straty;
            }
          }
        }
      // a teraz dodatkowo "ocena intuicyjna"
      if (poziom_gry>=8)
      {
      unsigned int skl[8];
      int ile_skl_n=0, ile_skl_p=0, ile_razem=0;
      for (int dy=-1; dy<=1; dy++)
       for (int dx=-1; dx<=1; dx++)
         {
         int nx=i+dx, ny=j+dy;
         unsigned int s=WezUI(skl_tab, nx,ny);
         if (s)
           {
           for (int i=0; i<ile_razem; i++)
             if (skl[i]==s) goto Nast_punkt;
           if (WezUC(rozgr2,nx,ny)==ktory_gracz)
             ile_skl_n++;
           else
             ile_skl_p++;
           skl[ile_razem++]=s;
           }
         Nast_punkt:;
         }
      if (ile_skl_n>1)
        ocena+=3*(ile_skl_n-1); // punkty za laczenie wlasnych skladowych
      if (ile_skl_p>1)
        ocena+=5*(ile_skl_p-1); // punkty za utrudnianie przeciwnikowi laczenia
      }
      if (poziom_gry>6)
        ocena+=4*premie[indeks_ij];
      if (ile_skl>=1)
        {
        int lewo  = (ot[3] == ktory_gracz);
        int prawo = (ot[5] == ktory_gracz);
        int gora  = (ot[1] == ktory_gracz);
        int dol   = (ot[7] == ktory_gracz);
        if (lewo && gora)
          {
          if (ot[0]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[0]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (gora && prawo)
          {
          if (ot[2]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[2]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (prawo && dol)
          {
          if (ot[8]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[8]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        if (dol && lewo)
          {
          if (ot[6]==ktory_gracz)
            ocena-=6;  // kara za kwadracik
          if (ot[6]==3-ktory_gracz)
            ocena+=2;  // premia za blokowanie
          }
        }
      if (ile_skl==1)
        {
        if (ot[0]==ktory_gracz &&
          (WezUC(plansz_p,i-2,j) & 3)==0 &&
          WezUC(rozgrywka,i-2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j-2) & 3)==0 &&
          WezUC(rozgrywka,i,j-2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[2]==ktory_gracz &&
          (WezUC(plansz_p,i+2,j) & 3)==0 &&
          WezUC(rozgrywka,i+2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j-2) & 3)==0 &&
          WezUC(rozgrywka,i,j-2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[8]==ktory_gracz &&
          (WezUC(plansz_p,i+2,j) & 3)==0 &&
          WezUC(rozgrywka,i+2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j+2) & 3)==0 &&
          WezUC(rozgrywka,i,j+2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        if (ot[6]==ktory_gracz &&
          (WezUC(plansz_p,i-2,j) & 3)==0 &&
          WezUC(rozgrywka,i-2,j)==ktory_gracz &&
          (WezUC(plansz_p,i,j+2) & 3)==0 &&
          WezUC(rozgrywka,i,j+2)==ktory_gracz)
            ocena+=4;  // szykuja sie 2 stale stopy
        }
      /*
      if (ile_skl==1)  // premia za linie
        {
        if (ot[0] &&
          (WezUC(plansz_p,i-2,j-2) & 3)==0 &&
          WezUC(rozgrywka,i-2,j-2)==ktory_gracz)
          ocena++;
        if (ot[2] &&
          (WezUC(plansz_p,i+2,j-2) & 3)==0 &&
          WezUC(rozgrywka,i+2,j-2)==ktory_gracz)
          ocena++;
        if (ot[6] &&
          (WezUC(plansz_p,i-2,j+2) & 3)==0 &&
          WezUC(rozgrywka,i-2,j+2)==ktory_gracz)
          ocena++;
        if (ot[8] &&
          (WezUC(plansz_p,i+2,j+2) & 3)==0 &&
          WezUC(rozgrywka,i+2,j+2)==ktory_gracz)
          ocena++;
        } */
      // kara za duza odleglosc od kropki przeciwnika
      {
      int odl_x=i-st_x;            // tu bylo x zamiast st_x (wersje do 36)
      if (odl_x<0) odl_x=-odl_x;
      int odl_y=j-st_y;            // a tu y zamiast st_y    (wersje do 36)
      if (odl_y<0) odl_y=-odl_y;
      odl_x+=odl_y;
      if (odl_x>2) ocena--;
      if (odl_x>8) ocena--;
      if (odl_x>20) ocena--;
      if (odl_x>50) ocena--;
      }
      // sprawdz, jak dobry jest ten ruch
      if (ile_najl==2)
        {
        if (ocena>najl_ruchy[1].ocena)
          if (ocena>najl_ruchy[0].ocena)
            {
            najl_ruchy[1]=najl_ruchy[0];
            najl_ruchy[0].ocena=ocena;
            najl_ruchy[0].x    =i;
            najl_ruchy[0].y    =j;
            }
          else
            {
            najl_ruchy[1].ocena=ocena;
            najl_ruchy[1].x    =i;
            najl_ruchy[1].y    =j;
            }
        }
      else
        if (ile_najl==1 && ocena>najl_ruchy[0].ocena)
          {
          najl_ruchy[1]=najl_ruchy[0];
          najl_ruchy[0].ocena=ocena;
          najl_ruchy[0].x    =i;
          najl_ruchy[0].y    =j;
          }
        else
          {
          najl_ruchy[ile_najl].ocena=ocena;
          najl_ruchy[ile_najl].x    =i;
          najl_ruchy[ile_najl++].y    =j;
          }
      }
     }
   }
   if (poziom_gry==9)
     {
     int kt=0;
     if (ile_najl==2 && najl_ruchy[0].ocena==najl_ruchy[1].ocena)
       kt=random(2);
     x=najl_ruchy[kt].x;
     y=najl_ruchy[kt].y;
     }
   else
     {
     int ile = random(10000);
     if (ile>6000+poziom_gry*400 && ile_najl==2)
       {
       x=najl_ruchy[1].x;
       y=najl_ruchy[1].y;
       }
     else
       {
       x=najl_ruchy[0].x;
       y=najl_ruchy[0].y;
       }
     }
   plansze.ZwolnijPlansze(t1);
   plansze.ZwolnijPlansze(t2);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(zagr_pola);
   plansze.ZwolnijPlansze(premie);
   skladowe.ZwolnijSkladowa(zagrozenia);
   skladowe.ZwolnijSkladowa(zagrozenia2);
   skladowe.ZwolnijSkladowa(skl_tab);
   
   nruchy[0] = WezIndeksTab(x,y);
   return
     ZnajdzDomyslneRuchy(rozgrywka, plansz_p,
			 ktory_gracz, nruchy, st_x, st_y);
   }
 else if (ile_wolnego) {
   int ile=GraKoncowa(rozgrywka, plansz_p, ktory_gracz, nruchy, x, y, st_x, st_y);
   if (x!=0) return ile;
 }
 x=-1; y=-1;
 return 0;
}

//*****************************************************************************
// metody:
void TGraczO::DodajTekstCzas(char *s)
  // dodaje tekst ozn. ograniczenie czasowe do s
  // lub  ".bo"  (skrot od bez ograniczen)
{
  switch (czas_kiedy)
    {
    case 1: strcpy(s, "/g");  break;  // po kazdej glebokosci
    case 2: strcpy(s, "/r");  break;  // po kazdym ruchu
    case 3: strcpy(s, "/z");  break;  // zawsze
    default:  return;   // bez ograniczen
    }
  // dodaj czas
  if (czas_sek==0)
    { strcpy(&s[2], "1s");  return; }
  int ile_s = czas_sek + (czas_ssek>=50);
  if (ile_s<100 && ile_s!=60)
    { sprintf(&s[2], "%ds", ile_s); return; }
  int ile_m = ile_s/60 + (ile_s % 60 >=30);
  if (ile_m<100 && ile_m!=60)
    { sprintf(&s[2], "%dm", ile_m); return; }
  int ile_h = ile_m/60 + (ile_m % 60 >=30);
  if (ile_h<100 && ile_h % 24)
    { sprintf(&s[2], "%dh", ile_h); return; }
  int ile_d = ile_h/24 + (ile_h % 24 >=12);
  sprintf(&s[2], "%dd", ile_d);
}
 
void TGraczO::UstawImie()
// wstawia nazwe gracza komputerowego do pola imie_k
{
  memset(imie_k, 0, sizeof(imie_k));
  if (poziom_gry<=11) {
    sprintf(imie_k[0], "p%d", int(poziom_gry));
    if (poziom_gry==11) {
      if (wagi_n.sk+wagi_p.sk!=24)
	sprintf(&imie_k[0][strlen(imie_k[0])], "/%d-%d",
		int(wagi_n.sk), int(wagi_p.sk));
      else
	sprintf(&imie_k[0][strlen(imie_k[0])], "/%d", int(wagi_p.sk-12));
       int sa_um=0;
      if (umiejetnosci & 4)
	{ strcat(imie_k[0], "/m");  sa_um=1; }
      if (umiejetnosci & 0x10)
	if (sa_um) strcat(imie_k[0], "b");
	else { strcat(imie_k[0], "/b");  sa_um=1; }
      // ustaw imie 1
      sprintf(imie_k[1], "z%d-%d k=%d", int(wagi_n.zd), int(wagi_p.zd),
	      int(waga_kropki));
    }
    else {   // poziom 0-9
      if (umiejetnosci & 0x10)
	strcat(imie_k[0], "b");
    }
  }
  else if (poziom_gry==12)   {
    sprintf(imie_k[0], "%d", int(dokl_analizy));
    if (dokl_analizy>=2 && (umiejetnosci & 0x100)) strcat(imie_k[0],"q");
    else if ((sex_limit || sex_limit_podw) && dokl_analizy>=4)
      strcat(imie_k[0],"+");
    if ((sex_limit || sex_limit_podw) && dokl_analizy>=4) {
      sprintf(&imie_k[0][strlen(imie_k[0])], "%d", int(sex_limit));
      if (sex_limit_podw)
	sprintf(&imie_k[0][strlen(imie_k[0])], "+%d", int(sex_limit_podw));
    }
    DodajTekstCzas(&imie_k[0][strlen(imie_k[0])]);
    const char styl_gry[3][2] = {"A","n","D"};
    if (czas_kiedy || ekran.CzyKrotkieImie()) strcat(imie_k[0], "/");
    if (funkcja_sk>0 && funkcja_sk<6) {
      const char literki[][2]  = {"0","u",".","x","t","T"};
      if (!czas_kiedy && !ekran.CzyKrotkieImie()) strcat(imie_k[0], literki[funkcja_sk]);
      if (wagi_n.sk+wagi_p.sk!=24)
	strcat(imie_k[0], styl_gry[(wagi_n.sk>wagi_p.sk) + (wagi_n.sk>=wagi_p.sk)]);
      else
	sprintf(&imie_k[0][strlen(imie_k[0])], "%d", int(wagi_p.sk-12));
      if (czas_kiedy || ekran.CzyKrotkieImie()) strcat(imie_k[0], literki[funkcja_sk]);
    }
    if (!czas_kiedy && !ekran.CzyKrotkieImie()) {  // dodaj jeszcze umiejetnosci
      sprintf(&imie_k[0][strlen(imie_k[0])], ":%d", int(waga_kropki));
      int sa_um=0;
      if (umiejetnosci & 0x20)     // antywaz
	{ strcat(imie_k[0], "o");  sa_um=1; }
      if (umiejetnosci & 0x40)     // antywaz
	{ strcat(imie_k[0], "s");  sa_um=1; }
      if (umiejetnosci & 0x80)     // antywaz
	{ strcat(imie_k[0], "u");  sa_um=1; }
      if (umiejetnosci & 0x10)
	{ strcat(imie_k[0], "b");  sa_um=1; }
      if (umiejetnosci & 0x200)
	{ strcat(imie_k[0], "B");  sa_um=1; }
      if (Bouzy_dil>0)
	if (waga_latwe_pole>0)
	  { strcat(imie_k[0], "P");  sa_um=1; }
	else
	  { strcat(imie_k[0], "p");  sa_um=1; }
      else
	if (waga_latwe_pole>0)
	  { strcat(imie_k[0], "l");  sa_um=1; }
      if (!sa_um) strcat(imie_k[0], "(nic)");
      sprintf(&imie_k[0][strlen(imie_k[0])], "%d", testowe); 
    }
    // teraz imie 1
    sprintf(imie_k[1], "z%d-%d", int(wagi_n.zd), int(wagi_p.zd));
    if (funkcja_sk>0 && funkcja_sk<6)
      if (wagi_n.sk+wagi_p.sk!=24)
	sprintf(&imie_k[1][strlen(imie_k[1])], "/s%d-%d", int(wagi_n.sk), int(wagi_p.sk));
      else
	sprintf(&imie_k[1][strlen(imie_k[1])], "/%d", int(wagi_p.sk-12));
    int nr=2;
    if (Bouzy_dil)
      sprintf(imie_k[nr++], "B%d,%d: %d-%d %c", int(Bouzy_dil), int(Bouzy_er),
	      int(wagi_n.Bo), int(wagi_p.Bo),
	      (opcje_Bouzy & 1) ? 'j':' ');
    sprintf(imie_k[nr], "k=%d l=%d", int(waga_kropki), int(waga_latwe_pole));
    sprintf(&imie_k[nr][strlen(imie_k[nr])], " N%dP%d%c%c um=", int(listy_ruchow[0]), int(listy_ruchow[1]),
	    (listy_ruchow[2] ? 'U':'u'), (listy_ruchow[3] ? 'L':'l')); 
    int sa_um=0;
    if (umiejetnosci & 0x20)     // antywaz
      { strcat(imie_k[nr], "o");  sa_um=1; }
    if (umiejetnosci & 0x40)     // antywaz
      { strcat(imie_k[nr], "s");  sa_um=1; }
    if (umiejetnosci & 0x80)     // antywaz
      { strcat(imie_k[nr], "u");  sa_um=1; }
    if (umiejetnosci & 0x10)
      { strcat(imie_k[nr], "b");  sa_um=1; }
    if (umiejetnosci & 0x200)
      { strcat(imie_k[nr], "B");  sa_um=1; }
    if (!sa_um) strcat(imie_k[nr], "(nic)");
    sprintf(&imie_k[nr][strlen(imie_k[nr])], "%d", testowe); 
  }
  else {  // poziom 13 (MC)
    sprintf(imie_k[0], "MC %d %d", int(iteracji), int(funkcja_mc));   
  }
}

int TGraczO::Wstaw(unsigned char *s)
// Wstawia informacje o graczu z lancucha s, dlugosci 48 bajtow.
// W ,,s'' jest gracz w starym formacie TGracz, uzywanym
// jeszcze w plikach.
// Zwraca 1, gdy lancuch definiuje znanego gracza.
// Uwaga: nie zmienia imienia czlowieka, gdy gra komputer, ani parametrow kompa,
//        gdy gra czlowiek.
{
 if (s[0]==0 && s[1]==0)  // czlowiek?
   {
   komputer=0;
   s[39]=0;   // na wszelki wypadek, gdyby nie konczyl sie zerem
   strcpy(imie, (char*) &s[10]);
   return 1;
   }
 komputer=1;
 // poziom gry
 short int i= s[2] + (int(s[3])<<8);
 if (i>=0 && i<10 || i==12)
   poziom_gry=i;
 else return 0;
 int agresja;
 i= s[4] + (int(s[5])<<8);
 if (i>=-3 && i<=3)
   agresja = i*3;
 else if (i>=13 && i<=32)  // ,,nowa agresja''
   agresja = i-22;
 else return 0;   // zle ustawiona agresja
 wagi_n.sk = 12-agresja;   wagi_p.sk = 12+agresja;
 int przejmuje_sie;
 i= s[6] + (int(s[7])<<8);
 static int wsp_przejmuje_sie_tab[4]={32,40,51,64};
 if (i>=1 && i<=4)
   przejmuje_sie = wsp_przejmuje_sie_tab[i-1];
 else if (i>=30 && i<=129)
   przejmuje_sie = i;
 else return 0;   // zle ustawione przejmuje sie
 wagi_n.zd = przejmuje_sie*wagi_p.sk;   wagi_p.zd = przejmuje_sie*wagi_n.sk;
 // dokladnosc analizy
 i= s[8] + (int(s[9])<<8);
 if (i>=0 && i<=MAX_GLEB_ANALIZY-13)
   dokl_analizy= std::max((int) i, 2);
 else return 0;   // zle ustawiona dokladnosc analizy
 // umiejetnosci
 i= s[46] + (int(s[47])<<8);
 funkcja_sk = (i&8) ? 3:2;
 i|=1;  i&=~(2|8);
 if (i & ~(1|2|4|8|0x10|0x20|0x40|0x80|0x100|0x200))
   return 0;      // zle ustawione umiejetnosci
 else umiejetnosci=i;
 waga_kropki=5;
 czas_kiedy=0;
 sex_limit= sex_limit_podw=0;
 Bouzy_dil=0;
 iteracji = 10000;
 funkcja_mc = 3;
 for (int i=0; i<4; i++) listy_ruchow[i]=0;
 UstawImie();
 return 1;
}


TGraczO& TGraczO::operator&=(const TGraczO g)
// kopiuje informacje o graczu: jesli jest czlowiekiem, to tylko imie,
// jesli komputerem, to wszystko oprocz imienia
{
 if (komputer=g.komputer)  // ma byc =
   {
   poziom_gry  =g.poziom_gry;
   dokl_analizy=g.dokl_analizy;
   funkcja_sk  =g.funkcja_sk;
   Bouzy_dil   =g.Bouzy_dil;
   Bouzy_er    =g.Bouzy_er;
   opcje_Bouzy =g.opcje_Bouzy;
   waga_latwe_pole = g.waga_latwe_pole;
   czas_sek    =g.czas_sek;
   czas_ssek   =g.czas_ssek;
   czas_kiedy  =g.czas_kiedy;
   umiejetnosci=g.umiejetnosci;
   waga_kropki =g.waga_kropki;
   wagi_n      =g.wagi_n;
   wagi_p      =g.wagi_p;
   sex_limit   =g.sex_limit;
   sex_limit_podw =g.sex_limit_podw;
   testowe     =g.testowe;
   for (int i=0; i<4; i++) listy_ruchow[i]=g.listy_ruchow[i];   
   iteracji    =g.iteracji;
   funkcja_mc  =g.funkcja_mc;
   memcpy(imie_k, g.imie_k, sizeof(imie_k));
   }
 else
   strcpy(imie, g.imie);
 return *this;
}

int TGraczO::operator==(const TGraczO g) const
// zwraca 1, jesli gracze maja takie same ustawienia (ew. z wyj. glebokosci i czasu)
{
  if (poziom_gry  != g.poziom_gry) return 0;
  //   dokl_analizy=g.dokl_analizy;
  if (poziom_gry<=12) {
    if (funkcja_sk  !=g.funkcja_sk) return 0;
    if (Bouzy_dil   !=g.Bouzy_dil ) return 0;
    if (Bouzy_er    !=g.Bouzy_er  ) return 0;
    if (opcje_Bouzy !=g.opcje_Bouzy) return 0;
    if (waga_latwe_pole != g.waga_latwe_pole) return 0;
    // czas_sek    =g.czas_sek;
    //   czas_ssek   =g.czas_ssek;
    //   czas_kiedy  =g.czas_kiedy;
    if (umiejetnosci!=g.umiejetnosci) return 0;
    if (waga_kropki !=g.waga_kropki)  return 0;
    if (wagi_n      !=g.wagi_n)       return 0;
    if (wagi_p      !=g.wagi_p)       return 0;
    if (sex_limit   !=g.sex_limit)    return 0;
    if (sex_limit_podw!=g.sex_limit_podw) return 0;
    if (testowe     !=g.testowe)      return 0;
  }
  else if (poziom_gry==13) {
    if (iteracji    !=g.iteracji)     return 0;
    if (funkcja_mc  !=g.funkcja_mc) return 0;
  }
  return 1;
}

void TGraczO::Odbij()
{
  // odbija gracza
  TGraczO::TWagi  pom;
  pom = wagi_p;   wagi_p = wagi_n;   wagi_n = pom;
}

short int ShortInt(unsigned char *b)
{
  short int w = b[1];
  w <<= 8;
  return (w| b[0]);
}
long int LongInt(unsigned char *b)
{
  long int w = b[3];
  w <<= 8;
  w |= b[2];
  w <<= 8;
  w |= b[1];
  w <<= 8;
  return (w| b[0]);
}
int ZapiszSI(unsigned char* buf, short int n)
{
  buf[0]= (n & 0xff);
  buf[1]= (n >> 8);
  return 2;
}
int ZapiszLI(unsigned char* buf, long int n)
{
  buf[0]= (n & 0xff);
  buf[1]= (n >> 8) & 0xff;
  buf[2]= (n >> 16) & 0xff;
  buf[3]= (n >> 24);
  return 4;
}

void TGraczO::Zapisz(FILE *f)
{
  unsigned char buf[120];
  int ile=0;
  ile += ZapiszSI(&buf[ile], komputer);
  ile += ZapiszSI(&buf[ile], poziom_gry);
  ile += ZapiszSI(&buf[ile], dokl_analizy);
  ile += ZapiszSI(&buf[ile], funkcja_sk);
  ile += ZapiszSI(&buf[ile], Bouzy_dil);
  ile += ZapiszSI(&buf[ile], Bouzy_er);
  ile += ZapiszLI(&buf[ile], czas_sek);
  ile += ZapiszLI(&buf[ile], czas_ssek);
  ile += ZapiszLI(&buf[ile], czas_kiedy);
  ile += ZapiszLI(&buf[ile], umiejetnosci);
  ile += ZapiszLI(&buf[ile], waga_kropki);
  ile += ZapiszLI(&buf[ile], wagi_n.zd);
  ile += ZapiszLI(&buf[ile], wagi_n.sk);
  ile += ZapiszLI(&buf[ile], wagi_n.Bo);
  ile += ZapiszLI(&buf[ile], wagi_p.zd);
  ile += ZapiszLI(&buf[ile], wagi_p.sk);
  ile += ZapiszLI(&buf[ile], wagi_p.Bo);
  ile += ZapiszSI(&buf[ile], sex_limit);
  ile += ZapiszSI(&buf[ile], sex_limit_podw);
  ile += ZapiszLI(&buf[ile], testowe);
  ile += ZapiszSI(&buf[ile], opcje_Bouzy );
  ile += ZapiszSI(&buf[ile], waga_latwe_pole);
  for (int i=0; i<4; i++)
    buf[ile++] = listy_ruchow[i];
  ile += ZapiszLI(&buf[ile], iteracji);
  ile += ZapiszSI(&buf[ile], funkcja_mc);
  ile += ZapiszSI(&buf[ile], funkcja_mc_FPU);
  for (int i=0; i<10; i++)
    ile += ZapiszLI(&buf[ile], zapasowe[i]);
  assert(ile==sizeof(buf));
  fwrite(buf, 1, ile, f);
  fwrite(imie, 1, sizeof(imie), f);
  fwrite(imie_k, 1, sizeof(imie_k), f);
}

int TGraczO::Odczytaj(FILE *f)
  // zwraca 0, gdy blad; 1 gdy ok
{
  TGraczO pom;
  unsigned char buf[sizeof(TGraczO)];
  if (fread(&buf, 1, sizeof(TGraczO),f)!=sizeof(TGraczO))
    return 0;
  // wstaw buf do pom
  memcpy(&pom, buf, sizeof(pom));
//#ifdef HOST_WORDS_BIG_ENDIAN
  pom.komputer = ShortInt(&buf[0]);
  pom.poziom_gry = ShortInt(&buf[2]);
  pom.dokl_analizy = ShortInt(&buf[4]);
  pom.funkcja_sk = ShortInt(&buf[6]);
  pom.Bouzy_dil = ShortInt(&buf[8]);
  pom.Bouzy_er = ShortInt(&buf[10]);

  pom.czas_sek = LongInt(&buf[12]);
  pom.czas_ssek = LongInt(&buf[16]);
  pom.czas_kiedy = LongInt(&buf[20]);
  pom.umiejetnosci = LongInt(&buf[24]);
  pom.waga_kropki = LongInt(&buf[28]);
  pom.wagi_n.zd = LongInt(&buf[32]);
  pom.wagi_n.sk = LongInt(&buf[36]);
  pom.wagi_n.Bo = LongInt(&buf[40]);
  pom.wagi_p.zd = LongInt(&buf[44]);
  pom.wagi_p.sk = LongInt(&buf[48]);
  pom.wagi_p.Bo = LongInt(&buf[52]);

  pom.sex_limit = ShortInt(&buf[56]);
  pom.sex_limit_podw = ShortInt(&buf[58]);
  pom.testowe = LongInt(&buf[60]);
  pom.opcje_Bouzy = ShortInt(&buf[64]);
  pom.waga_latwe_pole = ShortInt(&buf[66]);
  //  signed char listy_ruchow[4];   // nasze, przec, przedost, lisc
  pom.iteracji = LongInt(&buf[72]);
  pom.funkcja_mc = ShortInt(&buf[76]);
  pom.funkcja_mc_FPU = ShortInt(&buf[78]);
  for (int i=0; i<10; i++)
    pom.zapasowe[i] = LongInt(&buf[80+4*i]);
//#endif  
  *this &= pom;
  return 1;
}

void TKalendarzRozgr::KazdyZKazdym(int ile_graczy)
{
 int wkol=(ile_graczy+1)/2;
 int nieparz = ile_graczy%2;
 int ost=0, pocz_kol=0;
 int dzielnik = ile_graczy-1+nieparz;
 int im=((ile_graczy-1)*(ile_graczy)) / 2;
 rozgr_w_sezonie = 2*im;
 if (mecze!=NULL) delete[] mecze;
 mecze = new TMecz[rozgr_w_sezonie];
 for (int kol=1; kol<=dzielnik; kol++)
   {
   for (int m=nieparz; m<wkol; m++)
     mecze[pocz_kol+m-nieparz].g1 = (ost+m) % dzielnik;
   ost = (ost+wkol) % dzielnik;
   for (int m=1; m<wkol; m++)
     mecze[pocz_kol+wkol-m-nieparz].g2 = (ost+m-1) % dzielnik;
   if (!nieparz)
     if (kol%2)
       mecze[pocz_kol].g2=ile_graczy-1;
     else
       {
       mecze[pocz_kol].g2=mecze[pocz_kol].g1;
       mecze[pocz_kol].g1=ile_graczy-1;
       }
   pocz_kol+=wkol-nieparz;
   }
 // dorob rewanze
 for (int i=0; i<im; i++)
   {
   mecze[im+i].g1 = mecze[im-1-i].g2;
   mecze[im+i].g2 = mecze[im-1-i].g1;
   }
}

TKalendarzRozgr& TKalendarzRozgr::operator=(TKalendarzRozgr& arg)
{
  if (mecze!=NULL) delete[] mecze;
  mecze = new TMecz[rozgr_w_sezonie = arg.rozgr_w_sezonie];
  memcpy(mecze, arg.mecze, sizeof(mecze[0])*rozgr_w_sezonie);
}

int TKalendarzRozgr::Odczytaj(FILE *f)
  // zwraca 0, gdy blad
{
  if (mecze!=NULL) delete[] mecze;
  unsigned char buf[4];
  // fread(&rozgr_w_sezonie, sizeof(rozgr_w_sezonie), 1, f);
  fread(buf, 1,2,f);
  rozgr_w_sezonie = ShortInt(buf);
  if (rozgr_w_sezonie<=0) return 0;
  mecze = new TMecz[rozgr_w_sezonie];
  // fread(mecze, sizeof(TMecz), rozgr_w_sezonie, f);
  for (int i=0; i<rozgr_w_sezonie; i++) {
    fread(buf, 1,4,f);
    mecze[i].g1 = ShortInt(&buf[0]);
    mecze[i].g2 = ShortInt(&buf[2]);
  }
  return 1;
}

int TKalendarzRozgr::Zapisz(FILE *f)
  // zwraca 0, gdy blad
{
  if (mecze!=NULL && rozgr_w_sezonie>0) {
    unsigned char buf[4];
    buf[0] = (rozgr_w_sezonie & 0xff);
    buf[1] = (rozgr_w_sezonie >> 8);
    fwrite(buf, 1,2,f);  //  fwrite(&rozgr_w_sezonie, sizeof(rozgr_w_sezonie), 1, f);
    for (int i=0; i<rozgr_w_sezonie; i++) {
      buf[0] = (mecze[i].g1 & 0xff);
      buf[1] = (mecze[i].g1 >> 8);
      buf[2] = (mecze[i].g2 & 0xff);
      buf[3] = (mecze[i].g2 >> 8);
      fwrite(buf, 1,4,f);
    }    // fwrite(mecze, sizeof(TMecz), rozgr_w_sezonie, f);
    return 1;
  }
  return 0;
}
 
void TTurniej::Zapisz()
// zapisuje akt. rozgrywke
{
 FILE *f=fopen(nazwa_t, "r+b");
 fseek(f, offset_rozgr + dlug_rozgr*
       (long(kalendarz.rozgr_w_sezonie)*ktory_sezon+ktory_mecz), SEEK_SET);
 gra.ZapiszRozgr(f, ktory_sezon, ktory_mecz);
 fclose(f);
}

inline int TTurniej::KtoryMecz()
{ return ktory_mecz; }

inline int  TTurniej::KtorySezon()
{ return ktory_sezon; }

void TTurniej::NowyMecz()
  // zaklada, ze aktualny mecz jest zakonczony i zapisany!
{
 if (++ktory_mecz == kalendarz.rozgr_w_sezonie)  { ktory_sezon++;  ktory_mecz=0; }
}

void TTurniej::WezGraczyWAktMeczu(TGraczO *gr)
{
 gr[0]&= gracze[ kalendarz.mecze[ktory_mecz].g1 ];
 gr[1]&= gracze[ kalendarz.mecze[ktory_mecz].g2 ];
}

int TTurniej::OdczytajNagl()
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje graczy, kalendarz i inne zmienne
//       i OTWIERA plik f!
{
 f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, zgry, gracze);
 if (jaki!=12 && jaki!=13) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 offset_rozgr=ftell(f);
 dlug_rozgr = 80+2*(jaki==12 ? plx*ply : tabliceR.IlePam(plx, ply));  // zob. TGra::ZapiszRozgr()
 return 1;
}

void TTurniej::UstawMecz(int nrs, int nrm)
{
  fseek(f,offset_rozgr+(nrs*kalendarz.rozgr_w_sezonie+nrm)*dlug_rozgr ,SEEK_SET);
}

int TTurniej::OdczytajInfoOMeczu(TMecz& m, int tylko_gra_srodkowa)
// zwraca pole startowe lub 0, gdy niedokonczona rozgrywka/koniec pliku
{ return TGra::OdczytajInfoOMeczu(f,m,zgry,tylko_gra_srodkowa); }

int TTurniej::ZapiszInfoOTurnieju(FILE *plik)
{
  long int gdzie = ftell(f);
  fseek(f,12,SEEK_SET);
  unsigned char buf[8];
  fread(buf,1,6,f);
  time_t czas = buf[5];  czas<<=8;
  czas|=buf[4];  czas<<=8;
  czas|=buf[3];  czas<<=8;
  czas|=buf[2];
  fprintf(plik,"Turniej rozpocz\352ty przez Kropki %d.%02d; %s",int(buf[0]),int(buf[1]),
	  ctime(&czas));
  // przedostatni mecz:
  fseek(f,-2*dlug_rozgr+12,SEEK_END);
  if (ftell(f)>offset_rozgr) {
    fread(buf,1,8,f);
    int whi = buf[1];  whi<<=8;  whi|=buf[0];
    int wlo = buf[3];  wlo<<=8;  wlo|=buf[2];
    czas = buf[7];  czas<<=8;
    czas|=buf[6];  czas<<=8;
    czas|=buf[5];  czas<<=8;
    czas|=buf[4];  
    fprintf(plik,"Przedostatni mecz zako\361czony przez Kropki %d.%02d; %s",whi,wlo,
	    ctime(&czas));
  }
  fseek(f,gdzie,SEEK_SET);
}

int TTurniej::Odczytaj(time_t &data_utw)
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje rozgrywke i graczy
{
 FILE *f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, zgry, gracze);
 if (jaki!=12 && jaki!=13) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 offset_rozgr=ftell(f);
 dlug_rozgr = 80+2*(jaki==12 ? plx*ply : tabliceR.IlePam(plx, ply));  // zob. TGra::ZapiszRozgr()
 fseek(f,0,SEEK_END);
 if (ftell(f)>offset_rozgr) {
   fseek(f, -dlug_rozgr, SEEK_END);
   int numery[2];
   if (!gra.OdczytajRozgr(f, zgry, data_utw, numery))
     { fclose(f);  return -7;  //  blad w pliku .t
     }
   ktory_sezon = numery[0];  ktory_mecz = numery[1];
   WezGraczyWAktMeczu(gra.gr);
 }
 else {
   ktory_sezon = ktory_mecz = 0;
   WezGraczyWAktMeczu(gra.gr);
   gra.NowaGra(plx, ply, zgry);
   data_utw=-1;  // nowa rozgrywka
 }
 fclose(f);
 return 1;
}

int TTurniej::OdczytajMecz(time_t &data_utw, int nrs, int nrm)
// zwraca
//   0 = brakuje pliku .t
//  <0 = blad w pliku .t (zwraca kod bledu)
//   1 = wszystko ok, wczytuje rozgrywke i graczy
{
 FILE *f = fopen(nazwa_t, "rb");
 if (f==NULL) return 0;
 int jaki = gra.DInfoOPliku(f, plx, ply, ile_graczy, zgry, gracze);
 if (jaki!=12 && jaki!=13) {
   fclose(f);
   return (jaki<=0) ? jaki : -6;  // -6 = plik innego typu niz .t
 }
 kalendarz.Odczytaj(f);
 dlug_rozgr = 80+2*(jaki==12 ? plx*ply : tabliceR.IlePam(plx, ply));  // zob. TGra::ZapiszRozgr()
 fseek(f, dlug_rozgr*(long(kalendarz.rozgr_w_sezonie)*nrs+nrm), SEEK_CUR);
 int numery[2];
 if (!gra.OdczytajRozgr(f, zgry, data_utw, numery)) {
   fclose(f);  return -7;  //  blad w pliku .t
 }
 ktory_sezon = numery[0];  ktory_mecz = numery[1];
 WezGraczyWAktMeczu(gra.gr);
 fclose(f);
 return 1;
}

int TTurniej::Nowy()
// zwraca
//   1 = udalo sie, wczytuje rozgrywke i graczy
//   0 = cos nie tak
{
 // utworz plik turniejowy
 FILE *f=fopen(nazwa_t, "wb");
 if (f==NULL) return 0;
 unsigned char nagl[32] = {'k','r','o','t',16,0};
 nagl[6]=(plx & 0xff);   nagl[7]=(plx >> 8);
 nagl[8]=(ply & 0xff);   nagl[9]=(ply >> 8);
 nagl[10]=(ile_graczy & 0xff);
 nagl[11]=(ile_graczy >> 8);
 // informacyjne rzeczy
 nagl[12]=WERSJA_KROPEK;  nagl[13]=WERSJA_KROPEK_LOW;
 time_t now;  time(&now);
 unsigned long int teraz = now;
 nagl[14]= teraz & 0xff;
 nagl[15]= (teraz >> 8) & 0xff;
 nagl[16]= (teraz >> 16) & 0xff;
 nagl[17]= (teraz >> 24) & 0xff;
 nagl[18]=(zgry & 0xff);   nagl[19]=(zgry >> 8);
 for (int i=20; i<32; i++) nagl[i]=0;
 fwrite(nagl, 1, 32, f);
 for (int i=0; i<ile_graczy; i++)
   gracze[i].Zapisz(f);  // fwrite(gracze, sizeof(gracze[0]), ile_graczy, f);
 //kalendarz.KazdyZKazdym(ile_graczy);
 kalendarz=pargry.kalendarz;
 kalendarz.Zapisz(f);
 offset_rozgr = ftell(f);
 dlug_rozgr = 80+2*tabliceR.IlePam(plx, ply);  // zob. TGra::ZapiszRozgr()
 ktory_sezon = ktory_mecz = 0;
 fclose(f);
 brandomize();
 WezGraczyWAktMeczu(gra.gr);
 gra.NowaGra(plx, ply, zgry);
 return 1;
}

//*************************

TGra::TGra()
{
 tryb=TRYB_GRA;    blokada=0;
 stop=0;
 drzewo=NULL;
 gr[0].komputer=0;     // zmodyfikuj domyslne ustawienia
}

void TGra::PrzydzielPamiec()
{
 rozgr    = plansze.PrzydzielPlansze();
 stopy    = plansze.PrzydzielPlansze();
 plansz_p = plansze.PrzydzielPlansze();
 historia = tabliceR.Przydziel();
 CzyscPlansze(1);
 CzyscDrzewo();
}

void TGra::CzyscDrzewo()
{
 delete drzewo;
 drzewo = new SGFTree;
 drzewo->sgftreeCreateHeaderNode(wlkx, wlky, zasady_gry);
}

int TGra::NowaGra(int x, int y, int zgry)
// zwraca 1, gdy ok
// przydziela na nowo pamiec dla drzewa sgf
{
#ifdef USTALONA_WLK_PLANSZY
  assert(x==wlkx && y==wlky);
  zasady_gry = zgry;
  CzyscPlansze(1);
#else
  if (x<min_bok_planszy || x>max_bok_planszy
      || y<min_bok_planszy || y>max_bok_planszy ||
      zgry<0 || zgry>2)
    return 0;   // zle parametry
 zasady_gry = zgry;
 if (x!=wlkx || y!=wlky)
   {
   // zwolnij pamiec
   plansze.ZwolnijPamiec();
   skladowe.ZwolnijPamiec();
   tabliceLI.ZwolnijPamiec();
   tabliceR.ZwolnijPamiec();
   //delete drzewo;
   wlkx=x;  wlky=y;
   // przydziel z powrotem pamiec
   plansze.PrzydzielPamiec();
   skladowe.PrzydzielPamiec();
   tabliceLI.PrzydzielPamiec();
   tabliceR.PrzydzielPamiec();
   PrzydzielPamiec();  // tutaj jest od razu CzyscPlansze(1);
   }
 else {
   CzyscPlansze(1);
   CzyscDrzewo();
 }
#endif
 ruchy_zam.Przydziel();  // ta funkcja jest odporna na wielokrotne przydzielanie pamieci
 return 1;
}

void TGra::CzyscPlansze(int zapamietaj_zarodek)
// rozpoczyna gre od nowa, nie zmienia wielkosci planszy ani graczy
{
 CzyscTablice(rozgr);
 CzyscTablice(stopy);
 CzyscTablice(plansz_p);
 ile_hist=1;   ile_hist_kr=0;   ile_hist_zapr=1;
 historia[0]=0;  // bezsensowne miejsce
 ktory_gracz=0;   // gracz na ruchu
 ile_zd_do_konc[0]=ile_zd_do_konc[1]=0;
 //ile_zd[0]=ile_zd[1]=pow_ss[0]=pow_ss[1]=0;
 pkt[0].Zeruj();  pkt[1].Zeruj();
 kl_zobr.Zeruj();
 koncowka=0;
 if (zapamietaj_zarodek) {
   zarodek_pocz[0] = bseed1;
   zarodek_pocz[1] = bseed2;
 }
 ruchy_zam.Zeruj();
 stop=0;          // wylacz przycisk stop, jesli wcisniety (zasady gry==2)
 StoperyOdNowa();
 STOPER_ZERUJ_WSZYSTKIE;
}

int TGra::OszacujWynik()
{
  int basp[2];
  int kto_pierwszy_do_basenu;
  return OszacujAktWynik(basp, kto_pierwszy_do_basenu, rozgr, plansz_p, pkt, ktory_gracz+1);
}

int TGra::OszacujWynikMC()
{
  unsigned char *pp = plansze.PrzydzielPlansze();
  unsigned char *r  = plansze.PrzydzielPlansze();
  int suma=0;
  int ost_ruch = DKropkeNr(ile_hist_kr);
  for (int i=0; i<5000; i++) {
    KopiujTablice(r , rozgr);
    KopiujTablice(pp, plansz_p);
    TZdobycze zdob[2];  zdob[0]=pkt[0];  zdob[1]=pkt[1];
    int wynik = GrajLosowo(r, pp, ktory_gracz+1, ost_ruch, zdob);
    suma += (wynik<0) + (wynik<=0);
  }
  plansze.ZwolnijPlansze(pp);  plansze.ZwolnijPlansze(r);
  return suma;
}

int TGra::DNajlepszyRuch(krint *ruchy, int& x, int& y, int wybierz_ruchy)
// daje najlepszy ruch gracza (komputerowego) i zwraca 1-n,
// lub zwraca 0, gdy koniec gry
// w tablicy ruchy jest ciag najlepszych ruchow (kropka + ruchy zamykajace),
//  funkcja zwraca liczbe ruchow.
// wybierz_ruchy==1   <==>  wcisnieto ,,w'' (analiza z wyborem listy ruchow)
{
  if (ktory_gracz>=0) {
    switch (gr[ktory_gracz].poziom_gry)
      {
      case 11:
	// bez break'a, zeby jakos gral
      case 12:
        return
	  ZnajdzNajlepszyRuch12(rozgr, plansz_p, ktory_gracz+1, gr[ktory_gracz],
				ruchy, x,y,
				upl_x[DKropkeNr(ile_hist_kr)], upl_y[DKropkeNr(ile_hist_kr)],
				pkt, kl_zobr, wybierz_ruchy );
      case 13:
        return
	  ZnajdzNajlepszyRuchMC(rozgr, plansz_p, ktory_gracz+1, gr[ktory_gracz],
				ruchy, x,y,
				upl_x[DKropkeNr(ile_hist_kr)], upl_y[DKropkeNr(ile_hist_kr)],
				pkt, kl_zobr, wybierz_ruchy, drzewo );
      default:
	return
	 ZnajdzNajlepszyRuch(rozgr, plansz_p, ktory_gracz+1, gr[ktory_gracz].poziom_gry,
			     gr[ktory_gracz].umiejetnosci,
			     ruchy, x,y,
			     upl_x[DKropkeNr(ile_hist_kr)], upl_y[DKropkeNr(ile_hist_kr)]);
	 break;
      }
    ruchy[0]=WezIndeksTab(x,y);
    return 1;
  }
  return 0;
}

void TGra::GlownaPetla()
{
 int zdarz = ZD_NIC;
 StoperyOdNowa();
 char sgf_akt_r[4*max_powierzchnia_planszy];
 for (;;)
   {
   Poczatek_petli:;
   if (ktory_gracz>=0)   // gra sie nie skonczyla
   if (gr[ktory_gracz].komputer)
     {
     zdarz = (tryb & TRYB_PAUZA) ? ekran.CzekajNaZdarzenie() :
              ekran.DajZdarzenie();
     if (zdarz!=ZD_NIC && zdarz!=ZD_KROPKA) // ZD_NIC i ZD_KROPKA sa ignorowane
       {
       if (zdarz==ZD_KONIEC) return;
       else
         {
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
         }
       }
     if (tryb & TRYB_PAUZA) goto Poczatek_petli;
     // znajdz najlepszy ruch
     int x,y, ilenr;
     krint *bufor = skladowe.PrzydzielSkladowa();
     ilenr = DNajlepszyRuch(bufor, x,y);
     // wykonaj ruch
     if (tryb !=TRYB_CZAS) {
       int kto_byl_nr = ktory_gracz;
       sgf_akt_r[0]=0;
       for (int i=0; i<ilenr; i++)
	 WykonajRuch(bufor[i], (i<ilenr-1), -1, sgf_akt_r);
       //ekran.WyswietlNapis(sgf_akt_r);
       drzewo->sgftreeAddPlay(kto_byl_nr==0 ? BLACK : WHITE, sgf_akt_r);
     }
     else {
       if (ile_hist<=ile_hist_czas) {
	 ktory_gracz = ((historia[ile_hist] & 0x8000) != 0);
	 WykonajRuch(historia[ile_hist] & ~0x8000);
       }
       // wykonaj wszystkie ruchy zamykajace
       while (ile_hist<=ile_hist_czas && (historia[ile_hist] & 0x4000)) {
	 ktory_gracz = ((historia[ile_hist] & 0x8000) != 0);
	 WykonajRuch(historia[ile_hist] & ~0x8000);
       }
       if (ile_hist>=ile_hist_czas && ktory_gracz!=-1) { // nie koniec gry, ale koniec testu szybk.
	 ktory_gracz = ktory_gracz_czas;  // odtworz gracza na ruchu
	 // wyswietl czas gry, wlacz pauze
	 StoperyWstrzymaj();
	 tryb = TRYB_GRA | TRYB_PAUZA;
	 ekran.WyswietlTryb();
	 ekran.WyswietlCzasGry();
       }
     }
     skladowe.ZwolnijSkladowa(bufor);
     StoperyWznow();
     }
   else  // na ruchu czlowiek
     {
     zdarz = ekran.CzekajNaZdarzenie();
     switch (zdarz)
       {
       case ZD_KROPKA:
        switch (stop) {
	 case 0:
           // postaw kropke, jesli to mozliwe
	   if ((WezUC(plansz_p,pargry.x+2,pargry.y+2) & 3)==0) { // nie wewnatrz stopu
	     int kto_byl_nr = ktory_gracz;
	     sgf_akt_r[0]=0;
	     if (WezUC(rozgr,pargry.x+2,pargry.y+2)==0)  // nie ma tu jeszcze kropki
	       WykonajRuch(WezIndeksTab(pargry.x+2,pargry.y+2), pargry.kod, -1, sgf_akt_r);
	     else if (pargry.kod==-1)
	       UstawRuch(pargry.x+2,pargry.y+2);
	     //ekran.WyswietlNapis(sgf_akt_r);
	     drzewo->sgftreeAddPlay(kto_byl_nr==0 ? BLACK : WHITE, sgf_akt_r);
	     //
	     drzewo->sgftreeNodeCheck();
	     if (NormujRuch(drzewo->lastnode) && !blokada)
	       ekran.WyswietlPlansze(WS_STOP);
	     //
	   }
	   break;
	 case 1:
	   // postaw kropke, jesli to mozliwe
	   if ((WezUC(plansz_p,pargry.x+2,pargry.y+2) & 3)==0) // nie wewnatrz stopu
	     if (WezUC(rozgr,pargry.x+2,pargry.y+2)==0) { // nie ma tu jeszcze kropki
	       sgf_akt_r[0]=0;
	       WykonajRuch(WezIndeksTab(pargry.x+2,pargry.y+2), -2, -1, sgf_akt_r);
	       stop=2;
	     }
	   break;
	case 2:
	  // zamknij panstwo
	  {
	    int maska = (ktory_gracz) ? 0x28:0x14;
	    if ((WezUC(plansz_p,pargry.x+2,pargry.y+2) & maska)==maska &&
		WezUC(rozgr, pargry.x+2, pargry.y+2) == 2-ktory_gracz)
	      WykonajRuch(WezIndeksTab(pargry.x+2,pargry.y+2) | 0x4000, -2, -1, sgf_akt_r);
	    break;
	  }
	}
	StoperyWznow();
	break;

       case ZD_STOP:
	 // wylacz stop
	 if (stop==2) {
	   int kto_byl_nr = ktory_gracz;
	   WykonajRuch(0,-3, -1, sgf_akt_r);
	   //ekran.WyswietlNapis(sgf_akt_r);
	   drzewo->sgftreeAddPlay(kto_byl_nr==0 ? BLACK : WHITE, sgf_akt_r);
	     //
	     drzewo->sgftreeNodeCheck();
	     if (NormujRuch(drzewo->lastnode) && !blokada)
	       ekran.WyswietlPlansze(WS_STOP);
	     //
	 }
	 stop=0;
	 ekran.WyswietlStop();
	 break;
       case ZD_STOP+1:
	 // wlacz stop
	 stop=1;
	 ekran.WyswietlStop();
	 break;
       case ZD_KONIEC: return;
       default:
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
       }
     }
   else  // koniec gry
     {
     zdarz = ekran.CzekajNaZdarzenie();
     switch (zdarz)
       {
       case ZD_KONIEC: return;
       default:
         ObsluzZdarzenie(zdarz);
         goto Poczatek_petli;
       }
     }
   // sprawdz, czy gra sie skonczyla
   if (ktory_gracz==-1)
     {
//     if (blokada) ekran.WyswietlPlansze(WS_CALAPLANSZA);
     if (tryb==TRYB_TURNIEJ)
       {
       ekran.WyswietlInfoOMeczu();   // inf. na koniec meczu
       char s[30];
       ekran.WyswietlCzasGry();
       // zapamietaj wynik akt. meczu
       turniej.Zapisz();
       turniej.NowyMecz();
       turniej.WezGraczyWAktMeczu(gr);
       CzyscPlansze(1);
       CzyscDrzewo();
       ekran.WyswietlInfoOMeczu();   // inf. na poczatkek meczu
       if (!blokada)
         {
         ekran.WyswietlPlansze(WS_CALAPLANSZA);
         ekran.WyswietlGraczy();
         }
       GrFlush();
#ifdef TEKSTOWY
       // sprawdz, czy jest plik ,,koniec''
       FILE *ck = fopen("koniec","rb");
       if (ck!=NULL) {
	 fclose(ck);
	 return;  // koniec!
       }
#endif
       }
     else
       {
       ekran.WyswietlCzasGry();
       if (tryb==TRYB_CZAS)
         { tryb=TRYB_GRA;  ekran.WyswietlTryb(); }
       GrFlush();
       }
     }
   }
}

void TGra::ObsluzZdarzenie(int zd)
// odczytuje zmienna globalna pargry
{
 if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ) turniej.Zapisz();
 switch (zd)
  {
  case ZD_NOWAGRA:
   gr[0]=pargry.gr[0];  gr[1]=pargry.gr[1];
   if (!gr[0].komputer || !gr[1].komputer)
     {
     if (blokada)
       { blokada=0;
       ekran.WyswietlBlokade();  
       GrFlush();
       }
     }
   NowaGra(pargry.x, pargry.y, pargry.zasady);
   if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ || (tryb & ~TRYB_PAUZA)==TRYB_CZAS)
     { tryb=TRYB_GRA | (tryb & TRYB_PAUZA);  ekran.WyswietlTryb(); }
   ekran.WyswietlPlansze(WS_NOWAPLANSZA);
   ekran.WyswietlGraczy();
   StoperyOdNowa();
   GrFlush();
   break;
  case ZD_COFNIJ: {
    int ile_rc = drzewo->lastnode->sgfMovesBefore();
    if (ile_rc>=1 && pargry.ile<ile_rc) { // jesli jest sens cofac
      // cofnij o (ile_rc - pargry.ile) ruchow
      drzewo->sgfPlayBack(ile_rc - pargry.ile);
      GrajDotadSGF(drzewo->lastnode);
      // ustaw tryb
      if (gr[ktory_gracz].komputer || (tryb & TRYB_PAUZA))
	tryb = TRYB_GRA | TRYB_PAUZA;
      else tryb = TRYB_GRA;
      ekran.WyswietlStop();
      ekran.WyswietlTryb();
      ekran.WyswietlPlansze(WS_CALAPLANSZA);
      StoperyWznow();
      GrFlush();         
    }
  }
    break;

    /*
    // stara wersja (sprzed 83.47):
   if (ile_hist_kr>=1 && pargry.ile<ile_hist_kr)  // jesli jest sens cofac
     {
     unsigned char *rozgr_zap = plansze.PrzydzielPlansze();
     KopiujTablice(rozgr_zap, rozgr);
     int dokad = ile_hist;
     int zap_hist = ile_hist_zapr;
     CzyscPlansze();
     // wykonuj ruchy (poniewaz cofnelismy, nie ma grozby zakonczenia gry)
     for (int i=0; i<dokad; i++)
       {
	 ktory_gracz = ((historia[i+1] & 0x8000)!=0);
	 if ((historia[i+1] & 0x4000)==0 && // nie stop
	     ile_hist_kr == pargry.ile)
	   break;
	 WykonajRuch(historia[i+1] & ~0x8000, 1, -1);
       }
     // ustaw gracza na ruchu
     //     ktory_gracz = rozgr_zap[DKropkeNr(ile_hist_kr)]-1;  // to jest wyzej
     plansze.ZwolnijPlansze(rozgr_zap);
     // ustaw tryb
     if (gr[ktory_gracz].komputer || (tryb & TRYB_PAUZA))
       tryb = TRYB_GRA | TRYB_PAUZA;
     else tryb = TRYB_GRA;
     ile_hist_zapr = zap_hist;
     ekran.WyswietlStop();
     ekran.WyswietlTryb();
     ekran.WyswietlPlansze(WS_CALAPLANSZA);
     StoperyWznow();
     GrFlush();     
     }
   break;
   */

  case ZD_TRYB:
   switch (pargry.tryb)
     {
     case TRYB_PAUZA:   // wylacz pauze
       tryb &= ~TRYB_PAUZA;
       ekran.WyswietlTryb();
       StoperyWznow();
       GrFlush();
       break;
     case TRYB_PAUZA+1: // wlacz pauze
       tryb |= TRYB_PAUZA;
       ekran.WyswietlTryb();
       StoperyWstrzymaj();
       GrFlush();
       break;
     case TRYB_GRA:
       if ((tryb & ~TRYB_PAUZA)!=TRYB_GRA)
         { tryb=TRYB_GRA | (tryb & TRYB_PAUZA);  
         ekran.WyswietlTryb();   GrFlush(); }
       break;
     case TRYB_CZAS:
       if ((tryb & ~TRYB_PAUZA) !=TRYB_TURNIEJ &&
           //ktory_gracz==-1 && 
	   gr[0].komputer && gr[1].komputer) {
	 ile_hist_czas = ile_hist;
	 ktory_gracz_czas = ktory_gracz;
	 int zap_hist = ile_hist_zapr;
         CzyscPlansze();
	 ile_hist_zapr = zap_hist;
         tryb=TRYB_CZAS;
	 bseed1=15666;  bseed2=0;
         ekran.WyswietlTryb();
         pargry.x=bseed1;  pargry.y=bseed2;
         ekran.WyswietlInformacje(WS_NOWYZARODEK);
         if (!blokada)
           ekran.WyswietlPlansze(WS_CALAPLANSZA);
         // czekaj na nastepne tykniecie zegara
         {
         TStoper czekaj;
         czekaj.Start();
         while (!czekaj.CzyJuz(0,2));
         }
         StoperyOdNowa();
         GrFlush();
	 }
       break;
     case TRYB_TURNIEJ:
       if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
         {  // rozpocznij/odczytaj turniej
         // przepisz parametry z pargry
         strcpy(turniej.nazwa_t, pargry.nz1);
         if (pargry.kod==2)  // nowy
           {
           turniej.ile_graczy = pargry.ile;
           turniej.plx = pargry.x; turniej.ply = pargry.y;
           for (int i=0; i<turniej.ile_graczy; i++)
             turniej.gracze[i] &= pargry.gr[i];
	   turniej.zgry = pargry.zasady;
           }
	 time_t data_utw=-1;
         if ((pargry.kod==1) ?  (turniej.Odczytaj(data_utw)!=1) : (turniej.Nowy()!=1))
           {
           ekran.WyswietlInformacje(WS_BLADPLIKU);
           GrFlush();
	   break;
           }
         // turniej rozpoczety!
 	 if (ktory_gracz==-1) {
	   // wczytalismy zakonczona rozgrywke, rozpocznij nowa
	   turniej.NowyMecz();
	   turniej.WezGraczyWAktMeczu(gr);
	   CzyscPlansze(1);
	   CzyscDrzewo();
	 }
         ekran.WyswietlPlansze(WS_NOWAPLANSZA);
         ekran.WyswietlGraczy();
         pargry.x=bseed1;  pargry.y=bseed2;
         ekran.WyswietlInformacje(WS_NOWYZARODEK);
         ekran.WyswietlInfoOMeczu();   // inf. na poczatkek meczu
         tryb=TRYB_TURNIEJ | (tryb & TRYB_PAUZA);
         ekran.WyswietlTryb();
	 GrFlush();
	 }
       break;
     }
   break;
  case ZD_ODCZYT_MECZU: {
   strcpy(turniej.nazwa_t, pargry.nz1);
   pargry.data_utw=-1;
   if (turniej.OdczytajMecz(pargry.data_utw, pargry.x, pargry.y)!=1)
     {
       ekran.WyswietlInformacje(WS_BLADPLIKU);
       GrFlush();
       break;
     }
   // gra wczytana!
   ekran.WyswietlInformacje(WS_ODCZYTMECZU);
   tryb=TRYB_GRA | TRYB_PAUZA;
   ekran.WyswietlTryb();
   ekran.WyswietlWszystko();
   GrFlush();
   }
   break;
  case ZD_BLOKADA: if (blokada!=pargry.blokada)   // czy cos sie zmienia?
   {
   if (pargry.blokada)  // wlaczyc blokade mozna tylko gdy nie gra czlowiek
     { if (gr[0].komputer && gr[1].komputer) blokada=1; }
   else blokada=0;  // a wylaczyc mozna zawsze
   ekran.WyswietlBlokade();
   GrFlush();
   }
   break;
  case ZD_ZAPIS:
   // zapisz do pliku pargry.nz1
   {
   FILE *f = fopen(pargry.nz1,"wb");
   if (f==NULL)
     {
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     break;
     }
   unsigned char nagl[32] = {'k','r','o','b',15,0};
   nagl[6]=(wlkx & 0xff);   nagl[7]=(wlkx >> 8);
   nagl[8]=(wlky & 0xff);   nagl[9]=(wlky >> 8);
   nagl[10]=((ile_hist_kr+1) & 0xff);   nagl[11]=((ile_hist_kr+1) >> 8);
   // informacyjne rzeczy
   nagl[12]=WERSJA_KROPEK;  nagl[13]=WERSJA_KROPEK_LOW;
   time_t now;  time(&now);
   unsigned long int teraz = now;
   nagl[14]= teraz & 0xff;
   nagl[15]= (teraz >> 8) & 0xff;
   nagl[16]= (teraz >> 16) & 0xff;
   nagl[17]= (teraz >> 24) & 0xff;
   nagl[18]= zasady_gry & 0xff;
   nagl[19]= zasady_gry >> 8;
   if (zasady_gry) nagl[4]=16;   // wersja 16 potrzebna dla zasad gry !=0
   for (int i=20; i<32; i++) nagl[i]=0;
   fwrite(nagl, 1, 32, f);
   for (int i=0; i<2; i++)    // zapisz obu graczy
     gr[i].Zapisz(f);         //   fwrite(gr, sizeof(TGraczO), 2, f);
   ZapiszRozgr(f);
   fclose(f);
   // i zapisz sgf
   char *nazwa = new char[strlen(pargry.nz1)+5];
   strcpy(nazwa, pargry.nz1);
   strcat(nazwa, ".sgf");
   writesgf(drzewo->root, nazwa);
   delete[] nazwa;
   }
   break;
  case ZD_ODCZYT:
   // odczytaj z pliku pargry.nz1
   {
   FILE *f = fopen(pargry.nz1,"rb");
   if (f==NULL)
     {
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     break;
     }
   int wx,wy,ile,zgry,ilzd[2],poss[2];
   TGraczO grtest[2];
   int r=DInfoOPliku(f, wx,wy,ile,zgry,grtest,ilzd,poss);
   time_t data_utw;
   if (r==-1)  // plik sgf?
     OdczytajSGF(pargry.nz1);
   else {
   if (r<=0 || (r&~8)<1 || (r&~8)>3 || (r>=8 && !OdczytajRozgr(f,zgry,data_utw)))
     {
     fclose(f);
     ekran.WyswietlInformacje(WS_BLADPLIKU);
     GrFlush();
     break;
     }
   gr[0] &= grtest[0];   gr[1] &= grtest[1];   // skopiuj graczy
   if (r<=3) {
     NowaGra(wx,wy,zgry);
     // wczytaj tablice
     fread(rozgr, sizeof(rozgr[0]), wlkx4wlky4, f);
     fread(stopy, sizeof(stopy[0]), wlkx4wlky4, f);
     fread(plansz_p, sizeof(plansz_p[0]), wlkx4wlky4, f);
     assert(sizeof(historia[0])==2);
     {
       unsigned char *buf = new unsigned char[2*wlkx4wlky4];
       assert(buf!=NULL);
       fread(buf, 1, 2*wlkx4wlky4, f);
       for (int i=0; i<wlkx4wlky4; i++) {
	 historia[i] = WezIndeksTab(buf[2*i+1], buf[2*i]);
	 if (historia[i]<wlkx4wlky4 && // historia[i]>=0 &&
	     rozgr[historia[i]]==2)
	   historia[i] |= 0x8000;
       }
       delete[] buf;
     }
     fclose(f);
     ktory_gracz=r-2;
     ile_hist = ile_hist_zapr = ile+1;

     pkt[0].Zeruj();     pkt[1].Zeruj();
     pkt[0].zd=ilzd[0];   pkt[1].zd=ilzd[1];
     pkt[0].ss=poss[0];   pkt[1].ss=poss[1];
     //ile_zd[0]=ilzd[0];   ile_zd[1]=ilzd[1];
     //pow_ss[0]=poss[0];   pow_ss[1]=poss[1];

     // nie jestesmy w turnieju, wiec nie musimy dokladnie znajdowac wyniku
     // po grze srodkowej...
     int ile_wolnego, ile_wolnego_poza_sts;
     IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
     if (koncowka = !ile_wolnego_poza_sts) {  // =, nie ==!
       //       ile_zd_do_konc[0] = ile_zd[0];   ile_zd_do_konc[1] = ile_zd[1];
       ile_zd_do_konc[0] = pkt[0].zd + pkt[0].pot_zd;
       ile_zd_do_konc[1] = pkt[1].zd + pkt[1].pot_zd;
       }
   }
   }  // if (r==-1) czyli sgf
   }
   tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer)?
             (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
   if (blokada && (!gr[0].komputer || !gr[1].komputer))
     {
     blokada=0;  ekran.WyswietlBlokade();
     }
   ekran.WyswietlPlansze(WS_NOWAPLANSZA);
   ekran.WyswietlGraczy();
   ekran.WyswietlTryb();
   ekran.WyswietlStop();
   StoperyOdNowa();
   GrFlush();
   break;

  case ZD_ROZGR_POCZ:
    if ((!gr[0].komputer && !gr[1].komputer) ||
	tryb==(TRYB_GRA | TRYB_PAUZA)) {
      pargry.ile=0;
      ObsluzZdarzenie(ZD_COFNIJ);
    }
    break;
  case ZD_ROZGR_KON:
    if ( (!gr[0].komputer && !gr[1].komputer) || tryb==(TRYB_GRA | TRYB_PAUZA)) {
      int byl = 0;
      while (GrajNastepnySGF(drzewo->lastnode)) byl=1;
      if (byl) {
	ekran.WyswietlStop();
	ekran.WyswietlTryb();
	ekran.WyswietlPlansze(WS_CALAPLANSZA);
	StoperyWznow();
	GrFlush();     
      }
    }
    break;

    /*
    if (( (!gr[0].komputer && !gr[1].komputer) || tryb==(TRYB_GRA | TRYB_PAUZA))
	&& ile_hist<ile_hist_zapr) {
      while (ile_hist<ile_hist_zapr) {
	ktory_gracz = ((historia[ile_hist] & 0x8000)!=0);
	WykonajRuch(historia[ile_hist] & ~0x8000, 1, -1);
      }
      ekran.WyswietlStop();
      ekran.WyswietlTryb();
      ekran.WyswietlPlansze(WS_CALAPLANSZA);
      StoperyWznow();
      GrFlush();     
    }
    break;
    */
  case ZD_ROZGR_NAST:
    if ( (!gr[0].komputer && !gr[1].komputer) || tryb==(TRYB_GRA | TRYB_PAUZA)) {
      if (GrajNastepnySGF(drzewo->lastnode)) {
	ekran.WyswietlStop();
	ekran.WyswietlTryb();
	ekran.WyswietlPlansze(WS_CALAPLANSZA);
	StoperyWznow();
	GrFlush();
      }
    }
    break;

    /*
    if (( (!gr[0].komputer && !gr[1].komputer) || tryb==(TRYB_GRA | TRYB_PAUZA))
	&& ile_hist<ile_hist_zapr) {
      int juz_jest=0;
      while (ile_hist<ile_hist_zapr) {
	if ((historia[ile_hist] & 0x4000)==0) // nie stop
	  if (juz_jest)
	    break;
	  else juz_jest=1;
	ktory_gracz = ((historia[ile_hist] & 0x8000)!=0);
	WykonajRuch(historia[ile_hist] & ~0x8000, 0, -1);
      }
      StoperyWznow();
    }
    break;
    */

  case ZD_ROZGR_POP:
    if ( (!gr[0].komputer && !gr[1].komputer) || tryb==(TRYB_GRA | TRYB_PAUZA)) {
      int ile_rc = drzewo->lastnode->sgfMovesBefore();
      if (ile_rc) {
	pargry.ile=ile_rc-1;
	ObsluzZdarzenie(ZD_COFNIJ);
      }
    }	   
    break;

  case ZD_USTAWZARODEK:
   if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
     { bseed1=pargry.x;  bseed2=pargry.y;
     ekran.WyswietlInformacje(WS_NOWYZARODEK);
     GrFlush();
     }
   break;
  case ZD_USTAWZARODEKLOSOWY:
   if ((tryb & ~TRYB_PAUZA)!=TRYB_TURNIEJ)
     { brandomize();
     pargry.x=bseed1;  pargry.y=bseed2;
     ekran.WyswietlInformacje(WS_NOWYZARODEK);
     GrFlush();
     }
   break;
  case ZD_OPUSCRUCH:
   if (ktory_gracz>=0 && !gr[ktory_gracz].komputer)
     {
     ktory_gracz=1-ktory_gracz;
     StoperyWznow();
     ekran.WyswietlPlansze(WS_KTONARUCHU);
     GrFlush();
     }
   break;
  case ZD_ZMIENGRACZY:
   if ((tryb & ~TRYB_PAUZA)==TRYB_TURNIEJ)
     tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer)?
                (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
   gr[0]=pargry.gr[0];  gr[1]=pargry.gr[1];
   if (!gr[0].komputer || !gr[1].komputer)
     {
     if ((tryb & ~TRYB_PAUZA)==TRYB_CZAS)
       tryb = (ktory_gracz>=0 && gr[ktory_gracz].komputer) ?
         (TRYB_GRA | TRYB_PAUZA) : TRYB_GRA;
     if (blokada)
       { blokada=0;
       ekran.WyswietlBlokade(); }
     }
   ekran.WyswietlGraczy();
   ekran.WyswietlTryb();
   StoperyWznow();
   GrFlush();
   break;
  }
}

void TGra::WykonajRuch(int ruch, int tylko_ruch, int zostaw_stopy, char *sgf_ruch)
// Wykonuje ruch [ruch...] (nie sprawdza poprawnosci!);
// modyfikuje zdobycze i historie;
// dopisuje wykonane ruchy do lancucha sgf_ruch, jesli jest on !=NULL,
//   ale jest klopot z ostatnim ruchem: ciezko dodac stopy drugiego gracza
//   (moze trzeba by dodac osobny wezel) -- w tej chwili dopisujemy do stopow;
// sprawdza, czy gra sie skonczyla:
//   jesli tak, to dodaje ostatni stop (jesli jest), zatrzymuje stoper;
//   jesli nie, to zmienia gracza na ruchu
// wywoluje WyswietlPlansze() z odp. parametrem, jesli nie ma blokady
// lub gra sie zakonczyla.
// Ta funkcja nie wie niczego o turnieju: nie ustawia nowego meczu po
// zakonczeniu gry. Nie wywoluje WyswietlCzas().
//  Jesli tylko_ruch==1, to wykonuje ruch, nie zmienia gracza na ruchu,
//  nie zatrzymuje stoperow, niczego nie wyswietla (potrzebne do odczytywania
//  rozgrywki).
//  tylko_ruch==2, to tak jak wyzej (==1), ale sprawdza czy gra sie zakonczyla
//  tylko_ruch==-1 oznacza to samo co 0, ale bez zmiany gracza (do ustawiania
//   pozycji do analizy)
//  tylko_ruch==-2 jest podobne do -1, ale nie ustawia konca gry: sluzy
//   do postawienia kropki z wcisnietym ,,stop''/do zamkniecia panstwa (reguly gry==2)
//  tylko_ruch==-3 oznacza, ze zakonczono zamykanie panstw (reguly gry==2),
//   tutaj tak naprawde nie wykonujemy ruchu, tylko zmieniamy gracza, ew. konczymy gre
//
// Gdy:
//  zostaw_stopy == 0  -- standardowe zachowanie,
//  zostaw_stopy == -1  -- nie zamyka ZADNYCH stopow (ktore trzeba zamknac, bo zasady
//       gry tego wymagaja, ani takich, ktore warto zamknac, bo nic nie wnosza),
//       potrzebne do wczytywania SGF i recznych stopow
//
// Dodatkowe bity w ruch: 0x4000 -- tylko zamknij stop,
//   czyli ruch gotowy do wywolania ZrobRuch().
{
 int ile_zdt=0,pow=0,pow2=0,ile_zdt2=0;
 int jest_stop=0;
 if (tylko_ruch!=-3) {
   int ile_dom;
   jest_stop|=ZrobRuch(rozgr,stopy, NULL, ile_dom, sgf_ruch, zostaw_stopy, plansz_p, ruch, ktory_gracz+1, 
		       DKropkeNr(ile_hist_kr), pkt, kl_zobr,
		       ile_zdt,pow,pow2,ile_zdt2, ruchy_zam);
   /*
   ile_zd[ktory_gracz]+=ile_zdt;
   pow_ss[ktory_gracz]+=pow;
   pow_ss[1-ktory_gracz]+=pow2;
   ile_zd[1-ktory_gracz]+=ile_zdt2;
   */
   krint nowy_ruch = ruch | (ktory_gracz==0 ? 0 : 0x8000);
   if (historia[ile_hist] != nowy_ruch) {
     historia[ile_hist++] = nowy_ruch;
     ile_hist_zapr=ile_hist;
   }
   else {
     ile_hist++; 
     if (ile_hist_zapr<ile_hist) ile_hist_zapr=ile_hist;
   }
   if ((ruch & 0x4000)==0) ile_hist_kr++;
 }
 // sprawdz, czy to juz koniec
 {
 int ile_wolnego, ile_wolnego_poza_sts;
 IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
 if (!ile_wolnego_poza_sts && !koncowka) {
   //   ile_zd_do_konc[0] = ile_zd[0];   ile_zd_do_konc[1] = ile_zd[1];
   ile_zd_do_konc[0] = pkt[0].zd + pkt[0].pot_zd;
   ile_zd_do_konc[1] = pkt[1].zd + pkt[1].pot_zd;
   koncowka=1;
 }
 if (tylko_ruch==1) return;  // w tym przypadku nie spr., czy koniec gry
 if (ile_wolnego || ile_wolnego_poza_sts)
   {
   if (tylko_ruch==0 || tylko_ruch==-3)
     ktory_gracz=1-ktory_gracz;
   }
 else if (tylko_ruch!=-2) {
   if (zasady_gry==2) {
     // zamknij wszystkie panstwa:
     int maska = (ktory_gracz) ? 0x28:0x14;
     for (unsigned int i=up.lg; i<=up.pd; i++)
       if ((plansz_p[i] & maska)==maska) {  // czy sie jeszcze da zamknac?
	 WykonajRuch((i | 0x4000), 1, zostaw_stopy, sgf_ruch);  // niegrozna rekurencja...
	 jest_stop=1;  // nie wiadomo, ale na wszelki wypadek
       }
     // i drugi gracz:
     ktory_gracz=1-ktory_gracz;
     maska ^= 0x3c;
     for (unsigned int i=up.lg; i<=up.pd; i++)
       if ((plansz_p[i] & maska)==maska) {   // czy sie jeszcze da zamknac?
	 WykonajRuch((i | 0x4000), 1, zostaw_stopy, sgf_ruch);  // niegrozna rekurencja...
	 jest_stop=1;  // nie wiadomo, ale na wszelki wypadek
       }
   }
   else {
     int ile_dom;
     jest_stop|=ZrobRuch(rozgr,stopy, NULL, ile_dom, sgf_ruch, 0, plansz_p, 0, 2-ktory_gracz,    // zostaw_stopy=0 tutaj?
			 DKropkeNr(ile_hist_kr), pkt, kl_zobr,
			 ile_zdt,pow,pow2,ile_zdt2, ruchy_zam);
   }
   //if (tylko_ruch!=2)   <-- po co to?  (83.47)
   {
     ktory_gracz=-1;      // ustaw koniec gry
     StoperyStop();
   }
 }
 }
 if (tylko_ruch==2) return;
 // wyswietl kropke i ew. kreski, zdobycze, itp.; nie wyswietlaj czasu gry!
 if (!blokada)
  {
  if (jest_stop & 1) ekran.WyswietlPlansze(WS_STOP);
  else if (jest_stop) ekran.WyswietlPlansze(WS_POWIERZCHNIA);
  else ekran.WyswietlPlansze(WS_KROPKA);
  GrFlush();
  }
 else if (ktory_gracz==-1)
  { ekran.WyswietlGraczy(); ekran.WyswietlPlansze(WS_CALAPLANSZA); 
  GrFlush(); }
}

void TGra::UstawRuch(int x, int y)
// Zamienia kropke na polu (x,y) na kropke gracza (jesli jest tam kropka przeciwnika)
// lub kasuje wlasna kropke.
// Pole (x,y) powinno byc NIE WEWNATRZ STOPU! (ale moze byc na brzegu stopu)
// Modyfikuje zdobycze i historie;
// sprawdza, czy gra sie skonczyla:
//   jesli tak, to dodaje ostatni stop (jesli jest), zatrzymuje stoper;
// wywoluje WyswietlPlansze() z odp. parametrem, jesli nie ma blokady
// lub gra sie zakonczyla.
// Nigdy nie zmienia gracza na ruchu.
{
  unsigned char *r = plansze.PrzydzielPlansze();
  KopiujTablice(r, rozgr);
  int ile_hist_zap = ile_hist;
  int kto = ktory_gracz;
  if (WezUC(rozgr,x,y)==ktory_gracz+1) {  // nasza kropka, trzeba ja skasowac
    int miejsce = WezIndeksTab(x,y);
    r[miejsce] = 0;
    int dokad=1;
    for (int i=1; i<ile_hist; i++)
      if ((historia[i] & ~0x8000)!=miejsce)
	historia[dokad++] = historia[i];
    ile_hist_zap--;
  }
  else  // zamien kropke przeciwnika na nasza
    WezUC(r,x,y) = ktory_gracz+1;
  // wyczysc plansze i zacznij od nowa
  CzyscPlansze(1);
  for (int i=1; i<ile_hist_zap; i++) {
    int indeks = historia[i] & ~0xc000;
    if (historia[i] & 0x4000) {  // zamkniecie stopu
      ktory_gracz = ((historia[i] & 0x8000) !=0);
      int maska = (ktory_gracz) ? 0x28:0x14;
      if ((plansz_p[indeks] & maska)==maska)   // czy sie jeszcze da zamknac?
	WykonajRuch((indeks | 0x4000), 2);
    }
    else {
      ktory_gracz = r[indeks]-1;
      WykonajRuch(indeks, 2);
    }
  }
  ktory_gracz=kto;
  // sprawdz, czy to juz koniec
  {
    int ile_wolnego, ile_wolnego_poza_sts;
    IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
    if (!ile_wolnego && !ile_wolnego_poza_sts) {
      ktory_gracz=-1;      // ustaw koniec gry
      StoperyStop();
    }
  }
  ile_hist_zapr=ile_hist;   // skasuj ew. dalsza (zapamietana) rozgrywke
  // wyswietl kropke i ew. kreski, zdobycze, itp.; nie wyswietlaj czasu gry!
  ekran.WyswietlPlansze(WS_CALAPLANSZA);
  GrFlush();
}

// funkcje zwracajace wartosci parametrow, ,,D'' od daj
int TGra::DTryb() { return tryb; }
int TGra::DBlokada() { return blokada; }
int TGra::DStop() { return stop; }
int TGra::DKropka(int x, int y) { return WezUC(rozgr,x+2,y+2); }
int TGra::DKreska(int x, int y) { return WezUC(stopy,x+2,y+2); }
int TGra::DKreska(int x, int y, int x2, int y2)
{ return CzyPolaczone(stopy, x+2, y+2, x2+2, y2+2); }
int TGra::DPlanszP(int x, int y) { return WezUC(plansz_p,x+2,y+2); }
int TGra::DIleKropek() { return ile_hist_kr; }
int TGra::DOstKropkaX()
{ 
  unsigned int ind = DKropkeNr(ile_hist_kr);
  return ind==0 ? -1: upl_x[ind]-2;
}
int TGra::DOstKropkaY()
{ 
  unsigned int ind = DKropkeNr(ile_hist_kr);
  return ind==0 ? -1: upl_y[ind]-2;
}
int TGra::DKropkeNr(int nr)
{ // pierwsza kropka ma numer 1
  if (nr>ile_hist_kr || nr<=0) return 0;  // nie ma takiej kropki
  for (int i=1; i<ile_hist; i++)
    if ((historia[i] & 0x4000)==0)
      if (--nr==0) return (historia[i] & ~0xc000);
  return 0;
}
int TGra::DNaRuchu() { return ktory_gracz; }
int TGra::DKomputerNaRuchu() 
{ return (ktory_gracz>=0) ? gr[ktory_gracz].komputer : 0; }
int TGra::DWlkX() { return wlkx; }
int TGra::DWlkY() { return wlky; }
int TGra::DZasadyGry() { return zasady_gry; }
int TGra::DIleZd(int ng) { return pkt[ng].zd + pkt[ng].pot_zd; }
int TGra::DIlePotZd(int ng) { return pkt[ng].pot_zd; }
int TGra::DPowSS(int ng) { return pkt[ng].ss; }
// int TGra::DIleZd(int ng) { return ile_zd[ng]; }
// int TGra::DPowSS(int ng) { return pow_ss[ng]; }
void TGra::DGracza(int nr, TGraczO &ngr) { ngr = gr[nr]; }
krint& TGra::DElTabl(krint* tab, int i, int j) const
{ return WezUI(tab,i+2,j+2); };
unsigned char& TGra::DElTabl(unsigned char* tab, int i, int j) const
{ return WezUC(tab,i+2,j+2); };
unsigned int TGra::DHTAktCzas()
{ return htablicaZ.DajAktCzas(); }
int TGra::DNrSezonu()
{ return turniej.KtorySezon()+1; }
int TGra::DNrMeczu()
{ return turniej.KtoryMecz()+1; }
int TGra:: DNrGracza(int gr)
{ return gr ? turniej.kalendarz.mecze[turniej.ktory_mecz].g2 : turniej.kalendarz.mecze[turniej.ktory_mecz].g1; }

void TGra::UstawImie(int nr, const char* noweimie)
{
  strncpy(gr[nr].imie, noweimie, sizeof(gr[nr].imie));
  gr[nr].imie[sizeof(gr[nr].imie)-1]=0;
}

int TGra::DPola(int *pola, int x, int y, int wx, int wy, int symetrie)
// dodaje od 1 do 8 pol do pola[]
{
  x+=2; y+=2;
  pola[0]=x*(wy+4)+y;
  int ile=1;
  if (symetrie) {
    // wez symetrie wzgledem x
    int wx4wy4 = (wx+4)*(wy+4);
    for (int i=ile-1; i>=0; i--) 
      if (pola[i]>=0 && pola[i]<wx4wy4) {
	x=pola[i] / (wy+4);   y=wy+3- pola[i] % (wy+4);
	int ind = x*(wy+4)+y;
	int juz_jest=0;
	for (int j=0; j<ile; j++)
	  if (pola[j]==ind) { juz_jest=1; break; }
	if (!juz_jest) pola[ile++]=ind;
      }
    // wez symetrie wzgledem y
    for (int i=ile-1; i>=0; i--)
      if (pola[i]>=0 && pola[i]<wx4wy4) {
	x=wx+3- pola[i]/(wy+4);   y= pola[i] % (wy+4);
	int ind = x*(wy+4)+y;
	int juz_jest=0;
	for (int j=0; j<ile; j++)
	  if (pola[j]==ind) { juz_jest=1; break; }
	if (!juz_jest) pola[ile++]=ind;
      }
    if (wx==wy) {
      // wez symetrie wzgl. przekatnej
      for (int i=ile-1; i>=0; i--)
	if (pola[i]>=0 && pola[i]<wx4wy4) {
	  x=pola[i] % (wy+4);   y=pola[i] / (wy+4);  // zamien x <--> y
	  int ind = x*(wy+4)+y;
	  int juz_jest=0;
	  for (int j=0; j<ile; j++)
	    if (pola[j]==ind) { juz_jest=1; break; }
	  if (!juz_jest) pola[ile++]=ind;
	}
    }
  }
  return ile;
}

int TGra::DSStoper(int i, char* s)
{
#ifdef SA_STOPERY
 char *nazwy[] = {"OcenSkl:", "UstawSk:", "ZrobPan:", "ZnMostk:", "aWeze  :", "ZnSklad:", 
		  "UstZak :", "DodSas :",
                  "UstKary:", "TCiete :", "RobDod :", "RobMatk:", "CzyStop:", "UaktBzp:",
		  "srtRuch:", "ZapOcen:", "bezsens:", "hWez   :", "hWstaw :",
		  "GdyStop:", "tablice:", "TGrozby:", "popGleb:", "ZamStop:",
                  "UCTfun :", "RobSkld:", "UaktOWP:"};
 if (i>=sizeof(nazwy)/sizeof(nazwy[0])) return 0;
 strcpy(s,nazwy[i]);
 sprintf(&s[8]," %d", int(ssPodaj(i)/10));
 // if (ssPodaj(i)<10 && ssPodaj(i)) strcat(s,"0");
 strcat(s,".");
 sprintf(&s[strlen(s)],"%d", int(ssPodaj(i)%10));
 strcat(s,"c");
 return 1;
#else
 return 0;
#endif
}

void TGra::DJakasTablice(krint* tabl, char *opis_bitow, int kod)
// funkcja dla testow
{
CzyscTablice(tabl);  memset(opis_bitow, 0, (16<<5));
 const char *cyferki="0123456789abcdef";
 switch (kod) {
 case 0:  // obszary
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   ZnajdzObszary(tabl, rozgr2, rozgr3);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   }
   strcpy(&opis_bitow[0<<5], "0: otoczka wszystkich kr");
   strcpy(&opis_bitow[1<<5], "1: j.w. ale margines 1");
   strcpy(&opis_bitow[2<<5], "2: j.w. ale margines 2");
   strcpy(&opis_bitow[3<<5], "3: j.w. ale margines 3");
   strcpy(&opis_bitow[4<<5], "4: odlegl. <=1 od gr 1");
   strcpy(&opis_bitow[5<<5], "5: odlegl. <=2 od gr 1");
   strcpy(&opis_bitow[6<<5], "6: odlegl. <=1 od gr 2");
   strcpy(&opis_bitow[7<<5], "7: odlegl. <=2 od gr 2");
   strcpy(&opis_bitow[8<<5], "8: otoczka z wcieciami");
   strcpy(&opis_bitow[9<<5], "9: j.w. ale L^1-marg. 1");
   strcpy(&opis_bitow[10<<5], "a: j.w. ale L^1-marg. 2");
   strcpy(&opis_bitow[11<<5], "b: j.w. ale L^1-marg. 3");
   strcpy(&opis_bitow[12<<5], "c: bezsensowne dla gr 1");
   strcpy(&opis_bitow[13<<5], "d: bezsensowne dla gr 2");
   strcpy(&opis_bitow[14<<5], "e: blisko bandy");
   break;
 case 1:
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].rozgr3 = rozgr3;
   ang[0].UstawBezpNaZawsze();
   ang[0].InicjujCiecia(rozgr3);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   }
   // przepisz obszary do tabl
   for (int i=2; i<wlkx+2; i++)
    {
    signed int j=ang[0].ciete[0].pion_min[i];
    if (j<=ang[0].ciete[0].pion_max[i])
      {
      unsigned int indeks = WezIndeksTab(i,j);
      do
        {
        if (i>=ang[0].ciete[0].poz_min[j] && i<=ang[0].ciete[0].poz_max[j])
          tabl[indeks]|=1;
        j++;  indeks++;
        }
      while (j<=ang[0].ciete[0].pion_max[i]);
      }
    }
   for (int i=2; i<wlkx+2; i++)
    {
    signed int j=ang[0].ciete[1].pion_min[i];
    if (j<=ang[0].ciete[1].pion_max[i])
      {
      unsigned int indeks = WezIndeksTab(i,j);
      do
        {
        if (i>=ang[0].ciete[1].poz_min[j] && i<=ang[0].ciete[1].poz_max[j])
          tabl[indeks]|=2;
        j++;  indeks++;
        }
      while (j<=ang[0].ciete[1].pion_max[i]);
      }
    }
   // przepisz ciecia do tabl
   for (int ktg=0; ktg<=1; ktg++) {
   for (int i=2; i<wlkx+2; i++)
     {
     if (ang[0].ciete[ktg].pion_min[i]>=2 && ang[0].ciete[ktg].pion_min[i]<=wlky+1)
       WezUI(tabl,i,ang[0].ciete[ktg].pion_min[i]) |= (4 << (4*ktg));
     if (ang[0].ciete[ktg].pion_max[i]>=2 && ang[0].ciete[ktg].pion_max[i]<=wlky+1)
       WezUI(tabl,i,ang[0].ciete[ktg].pion_max[i]) |= (8 << (4*ktg));
     }
   for (int j=2; j<wlky+2; j++)
     {
     if (ang[0].ciete[ktg].poz_min[j]>=2 && ang[0].ciete[ktg].poz_min[j]<=wlkx+1)
       WezUI(tabl,ang[0].ciete[ktg].poz_min[j],j) |= (16 << (4*ktg));
     if (ang[0].ciete[ktg].poz_max[j]>=2 && ang[0].ciete[ktg].poz_max[j]<=wlkx+1)
       WezUI(tabl,ang[0].ciete[ktg].poz_max[j],j) |= (32 << (4*ktg));
     } }
   strcpy(&opis_bitow[0<<5], "0: wokol g1");
   strcpy(&opis_bitow[1<<5], "1: wokol g2");
   strcpy(&opis_bitow[2<<5], "2: g1/min y");
   strcpy(&opis_bitow[3<<5], "3: g1/max y");
   strcpy(&opis_bitow[4<<5], "4: g1/min x");
   strcpy(&opis_bitow[5<<5], "5: g1/max x");
   strcpy(&opis_bitow[6<<5], "6: g2/min y");
   strcpy(&opis_bitow[7<<5], "7: g2/max y");
   strcpy(&opis_bitow[8<<5], "8: g2/min x");
   strcpy(&opis_bitow[9<<5], "9: g2/max x");
   break;
 case 2:  // terytorium
   {
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   unsigned char* pom = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   // znajdz terytorium
//   int dil[4] = {5,4,5,4}, ero[4]={21,13,13,7};
//    int dil[4] = {5,4,3,2}, ero[4]={13,7,3,1};
   int ktg = ktory_gracz>=0 ? ktory_gracz : 
     rozgr[DKropkeNr(ile_hist_kr)]-1;
   int dil = gr[ktg].Bouzy_dil;
   int ero = gr[ktg].Bouzy_er;
   Bouzy(pom, rozgr2, rozgr3, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1), dil, ero,
	 1,1,0);   // 2 wagi i punkt_za_pole
   for (int i=0; i<wlkx4wlky4; i++) tabl[i]=pom[i];
   plansze.ZwolnijPlansze(pom);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   sprintf(&opis_bitow[0<<5], "0: terytorium (%d,%d) gr 1",dil,ero);
   sprintf(&opis_bitow[1<<5], "1: terytorium (%d,%d) gr 2",dil,ero);
   }
   break;
 case 3:  // bezpieczne
   {
     // ustaw wstepnie sklnr
     unsigned char* rozgr2 = plansze.PrzydzielPlansze();
     unsigned char* rozgr3 = plansze.PrzydzielPlansze();
     unsigned char* pr0 = plansze.PrzydzielPlansze();
     unsigned char* pr1 = plansze.PrzydzielPlansze();
     WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
     TBandy bandy;
     bandy.Inicjuj();
     bandy.UstawBezpieczne(rozgr3);
     const int tabelkab[4] = {0,1,2,2};
     int kto_nr = ktory_gracz>=0 ? (ktory_gracz+1) : rozgr[DKropkeNr(ile_hist_kr)];
     if (kto_nr!=1 && kto_nr!=2) kto_nr = 1;
     Ocena_PromieniowanieBandy(rozgr3, bandy.bezpieczne, kto_nr, pr0, pr1);
     for (int i=0; i<wlkx4wlky4; i++) {
       tabl[i] = tabelkab[bandy.bezpieczne[i]];
       if (pr0[i] | pr1[i]) {
	 while ((pr0[i] | pr1[i]) > 1) {
	   pr0[i] >>=1;	   pr1[i] >>=1;
	 }
	 int wynik = pr1[i] - pr0[i] + 1;
	 const int tabelkaw[] = {16, 32, 64};
	 tabl[i] |= tabelkaw[wynik];
       }
     }
     bandy.Zwolnij();
     //
     NaPewnoBezp npb;
     npb.Przydziel();
     npb.Inicjuj(rozgr, plansz_p);
     for (int i=0; i<wlkx4wlky4; i++) 
       if (upl_marg[i]>=2) {
	 if (npb.DajTab(i) & 0x4000)
	   tabl[i] |= (1 << 7);
	 if (npb.DajTab(i) & 0x8000)
	   tabl[i] |= (1 << 8);
	 if (npb.PoleBezs(i))
	   tabl[i] |= (1 << 9);
       }
     npb.Zwolnij();
     //
     plansze.ZwolnijPlansze(pr0);     plansze.ZwolnijPlansze(pr1);
     plansze.ZwolnijPlansze(rozgr2);
     plansze.ZwolnijPlansze(rozgr3);
     strcpy(&opis_bitow[0<<5], "0: p\363\263-bezpieczne");
     strcpy(&opis_bitow[1<<5], "1: bezpieczne");
     sprintf(&opis_bitow[4<<5], "4: gracza 1%s", (kto_nr==1) ? " (na ruchu)" : "");
     strcpy(&opis_bitow[5<<5], "5: sporne");
     sprintf(&opis_bitow[6<<5], "6: gracza 2%s", (kto_nr==2) ? " (na ruchu)" : "");
     strcpy(&opis_bitow[7<<5], "7: NPB 0x4000 (pol)");
     strcpy(&opis_bitow[8<<5], "8: NPB 0x8000 (bezp)");
     strcpy(&opis_bitow[9<<5], "9: NPB Bezsens");
   // a teraz kropki bezpieczne na zawsze
   ang[0].rozgr2  = plansze.PrzydzielPlansze();
   ang[0].rozgr3  = plansze.PrzydzielPlansze();
   ang[0].plansz_p= plansze.PrzydzielPlansze();
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   unsigned char* bezs = plansze.PrzydzielPlansze();
   ang[0].marg0_min=TDwaUC(2,2);
   ang[0].marg0_max=TDwaUC(wlkx+1,wlky+1);
   KopiujTablice(ang[0].plansz_p, plansz_p);
   WezRozgr23(rozgr, ang[0].rozgr2, ang[0].rozgr3, ang[0].plansz_p);
   ang[0].UstawBezpNaZawsze();
   CzyscTablice(bezs);
   ang[0].DodajBezsensowne(bezs);
   for (int i=0; i<wlkx4wlky4; i++) 
     tabl[i] |= ((TAnaliza::bezp_na_zawsze[i]) ? 4 : 0) |   // bylo = zamiast |=, popr. w 83.15
       (bezs[i] ? 8:0);
   plansze.ZwolnijPlansze(bezs);
   plansze.ZwolnijPlansze(ang[0].rozgr2);
   plansze.ZwolnijPlansze(ang[0].rozgr3);
   plansze.ZwolnijPlansze(ang[0].plansz_p);
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   strcpy(&opis_bitow[2<<5], "2: bezp na zawsze");
   strcpy(&opis_bitow[3<<5], "3: bezsensowne");
   }
   break;
 case 4: { // lista ruchow
   int twp = plansze.ile_wolnych, tws=skladowe.ile_wolnych;
   unsigned char *rozgrywka = plansze.PrzydzielPlansze();
   unsigned char *plansz_p2 = plansze.PrzydzielPlansze();
   unsigned char *rozgr2    = plansze.PrzydzielPlansze();
   unsigned char *rozgr3    = plansze.PrzydzielPlansze();
   KopiujTablice(rozgrywka, rozgr);
   KopiujTablice(plansz_p2, plansz_p);
   
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   TDwaUC marg_min[4], marg_max[4];
   int ile_ruchow, ile_ruchow_przec;
   krint *kolejne_ruchy  = skladowe.PrzydzielSkladowa();
   krint *ruchy_przec    = skladowe.PrzydzielSkladowa();
   unsigned char *schemat_ruchow = plansze.PrzydzielPlansze();
   ang[1].zagrozenia = skladowe.PrzydzielSkladowa();
   int gleb = gr[ktory_gracz].dokl_analizy;
   gr[ktory_gracz].dokl_analizy=6;
   ZnajdzListeRuchow12(rozgrywka, plansz_p2,
		       rozgr2, rozgr3,
		       skl_tab, 
		       marg_min,  marg_max,
		       ile_ruchow, ile_ruchow_przec,
		       kolejne_ruchy,  ruchy_przec,
		       schemat_ruchow,
		       gr[ktory_gracz], ktory_gracz+1
		       );
   gr[ktory_gracz].dokl_analizy = gleb;
   for (int i=0; i<wlkx4wlky4; i++) {
     if (schemat_ruchow[i]==0xff)
       tabl[i] = (upl_marg[i]<=1) ? 0 : 0x40;
     else {
       if (schemat_ruchow[i] & 1)
	 tabl[i] |= 0x4;
       if (schemat_ruchow[i] & 2)
	 tabl[i] |= 0x20;
       if (schemat_ruchow[i] & 4)
	 tabl[i] |= 0x2;
       if (schemat_ruchow[i] & 8)
	 tabl[i] |= 0x10;
       if (schemat_ruchow[i] & 0x10)
	 tabl[i] |= 0x1;
       if (schemat_ruchow[i] & 0x20)
	 tabl[i] |= 0x8;
       if (PoleBezs12(rozgr3, i, 1)==2)
	 tabl[i] |= 0x80;	 
     }
   }
   {
     sprintf(&opis_bitow[0<<5], "0: ruchy gr%d",ktory_gracz+1);
     sprintf(&opis_bitow[1<<5], "1: ruchy gr%d, upr",ktory_gracz+1);
     sprintf(&opis_bitow[2<<5], "2: ruchy gr%d, li\266\346",ktory_gracz+1);
     sprintf(&opis_bitow[3<<5], "3: ruchy gr%d",2-ktory_gracz);
     sprintf(&opis_bitow[4<<5], "4: ruchy gr%d, upr",2-ktory_gracz);
     sprintf(&opis_bitow[5<<5], "5: ruchy gr%d, li\266\346",2-ktory_gracz);
     strcpy(&opis_bitow[6<<5], "6: pola bezsensowne/zakazane");
     strcpy(&opis_bitow[7<<5], "7: pola chwilowo bezsensowne");
   }
   plansze.ZwolnijPlansze(rozgrywka);
   plansze.ZwolnijPlansze(plansz_p2);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   plansze.ZwolnijPlansze(schemat_ruchow);
   skladowe.ZwolnijSkladowa(skl_tab);
   skladowe.ZwolnijSkladowa(kolejne_ruchy);
   skladowe.ZwolnijSkladowa(ruchy_przec);
   skladowe.ZwolnijSkladowa(ang[1].zagrozenia);
   assert(twp == plansze.ile_wolnych); assert(tws==skladowe.ile_wolnych);
 }
 break;
 case 5: 
   if (DOstKropkaX()>=0)   // jest jakas kropka na planszy
   {  // grozby
   TGrozby grozby;
   unsigned char* r      = plansze.PrzydzielPlansze();
   unsigned char* r2     = plansze.PrzydzielPlansze();
   unsigned char* r3     = plansze.PrzydzielPlansze();
   unsigned char* pp     = plansze.PrzydzielPlansze();
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   krint* skl_tab = skladowe.PrzydzielSkladowa();
   krint* skl_tab_pop = skladowe.PrzydzielSkladowa();
   grozby.lista    = skladowe.PrzydzielSkladowa();
   grozby.zdobycze = skladowe.PrzydzielSkladowa();
   grozby.id       = new unsigned long int[wlkx*wlky];
   grozby.czy      = plansze.PrzydzielPlansze();
   grozby.zawarte  = skladowe.PrzydzielSkladowa();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   int kto = rozgr[ WezIndeksTab(DOstKropkaX()+2,DOstKropkaY()+2) ];
   ZnajdzSkladowe(skl_tab, rozgr2, kto);
   {
     // znajdz poprzednie skladowe: cofnij rozgrywke o 1 ruch
     CzyscTablice(r);     CzyscTablice(pp);
     int ile_kr=0;
     for (int i=0; i<ile_hist; i++)
       {
	 int kto = ((historia[i+1] & 0x8000)!=0);
	 if ((historia[i+1] & 0x4000)==0) { // nie stop
	   ile_kr++;
	   if (ile_kr == ile_hist_kr) break;
	 }
	 TZdobycze zd[2];  TZobrist zobr;
	 int izd, pow, pow2, izd2, iledom;
	 ZrobRuch(r, NULL, NULL, iledom, NULL, 0, pp, historia[i+1] & ~0x8000, kto,
		  gra.DKropkeNr(ile_kr-1), zd, zobr, izd, pow, pow2, izd2);
       }
     WezRozgr23(r, rozgr2, rozgr3, pp);
     ZnajdzSkladowe(skl_tab_pop, rozgr2, kto);
   }
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);   // odtworz
   grozby.DodajGrozby(rozgr, rozgr2, rozgr3, plansz_p, skl_tab_pop,
		      skl_tab, WezIndeksTab(DOstKropkaX()+2,DOstKropkaY()+2));
   grozby.UstawSing();
   CzyscTablice(tabl);
   for (int i=0; i<grozby.ile; i++)
     if ((grozby.czy[i] & 4)==0)
       tabl[grozby.lista[i]] = (grozby.czy[i] & 1) ? 3:1;    // czy singularna
   for (int i=2; i<wlkx+2; i++)
     for (int j=2; j<wlky+2; j++) {
       unsigned int ind=WezIndeksTab(i,j);
       if (rozgr3[ind]==0) {
	 KopiujTablice(r,rozgr);
	 KopiujTablice(r2,rozgr2);
	 KopiujTablice(r3,rozgr3);
	 KopiujTablice(pp,plansz_p);
	 int ile_zd,pow,pow2,pss;
	 TZdobycze wynik[2];  TZobrist zobr;
	 ZrobPanstwo(r, NULL, r2, r3, pp, i,j, 3-kto, wynik, zobr, ile_zd,pow,pow2,pss);
	 if (ile_zd || pow || pow2)
	   grozby.SprawdzOdpPrzec(r, r3, pp, ind);
       }
     }
   for (int i=0; i<grozby.ile; i++) {
     if (grozby.czy[i] & 1) tabl[grozby.lista[i]] |= 4;  // singularne
     if (grozby.czy[i] & 2) tabl[grozby.lista[i]] |= 8;  // bezsensowne
     if (grozby.czy[i] & 4) tabl[grozby.lista[i]] |= 16;  // brzuszki
   }
   strcpy(&opis_bitow[0<<5], "0: wszystkie grozby");
   strcpy(&opis_bitow[1<<5], "1: byc moze singularne");
   strcpy(&opis_bitow[2<<5], "2: singularne");
   strcpy(&opis_bitow[3<<5], "3: ruchy bezs. dla przec");
   strcpy(&opis_bitow[4<<5], "4: grozby-brzuszki");
   plansze.ZwolnijPlansze(r);
   plansze.ZwolnijPlansze(r2);
   plansze.ZwolnijPlansze(r3);
   plansze.ZwolnijPlansze(pp);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(skl_tab_pop);
   skladowe.ZwolnijSkladowa(skl_tab);
   skladowe.ZwolnijSkladowa(grozby.lista);
   skladowe.ZwolnijSkladowa(grozby.zdobycze);
   delete[] grozby.id;
   plansze.ZwolnijPlansze(grozby.czy);
   skladowe.ZwolnijSkladowa(grozby.zawarte);
 }
 break;
 case 6: {  // rozne
   unsigned char* kary     = plansze.PrzydzielPlansze();
   unsigned char* zakazane = plansze.PrzydzielPlansze();
   unsigned char* rozgr2   = plansze.PrzydzielPlansze();
   unsigned char* rozgr3   = plansze.PrzydzielPlansze();
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   TAnaliza::gracz =  gr[  ktory_gracz>=0 ? ktory_gracz : 
			   rozgr[DKropkeNr(ile_hist_kr)] ];
   TAnaliza::bezp_na_zawsze = plansze.PrzydzielPlansze();
   ang[0].rozgr3 = rozgr3;
   ang[0].UstawBezpNaZawsze();
   for (int kto=1; kto<=2; kto++) {
     CzyscTablice(kary);
     ang[0].InicjujCiecia(rozgr3);
     UstawKaryBM(kary, ang[0].ciete[kto-1], zakazane,
		 rozgr2,  rozgr3, kto, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1));
     int maski[6] = {1,2,4,8,16,32};
     for (int i=0; i<wlkx4wlky4; i++) {
       tabl[i] |= (maski[kary[i]]<<(6*(kto-1)));
       int x=upl_x[i], y=upl_y[i];
       if (x>=ang[0].ciete[kto-1].poz_min[y]  && x<=ang[0].ciete[kto-1].poz_max[y] &&
	   y>=ang[0].ciete[kto-1].pion_min[x] && y<=ang[0].ciete[kto-1].pion_max[x])
	 tabl[i] |= (kto<<12);
     }
   }
   strcpy(&opis_bitow[0<<5], "0: kary==0 wokol gr 1");
   strcpy(&opis_bitow[1<<5], "1: kary==1 wokol gr 1");
   strcpy(&opis_bitow[2<<5], "2: kary==2 wokol gr 1");
   strcpy(&opis_bitow[3<<5], "3: kary==0p wokol gr 1");
   strcpy(&opis_bitow[4<<5], "4: kary==1p wokol gr 1");
   strcpy(&opis_bitow[5<<5], "5: wewn    wokol gr 1");
   strcpy(&opis_bitow[6<<5], "6: kary==0 wokol gr 2");
   strcpy(&opis_bitow[7<<5], "7: kary==1 wokol gr 2");
   strcpy(&opis_bitow[8<<5], "8: kary==2 wokol gr 2");
   strcpy(&opis_bitow[9<<5], "9: kary==0p wokol gr 2");
   strcpy(&opis_bitow[10<<5], "a: kary==1p wokol gr 2");
   strcpy(&opis_bitow[11<<5], "b: wewn    wokol gr 2");
   strcpy(&opis_bitow[12<<5], "c: ob.ciety wokol gr1");
   strcpy(&opis_bitow[13<<5], "d: ob.ciety wokol gr2");
   plansze.ZwolnijPlansze(TAnaliza::bezp_na_zawsze);
   plansze.ZwolnijPlansze(kary);
   plansze.ZwolnijPlansze(zakazane);
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
 }
 break;
 case 7: { // podstawowe
   for (int i=0; i<wlkx4wlky4; i++) {
     tabl[i] = plansz_p[i];
     if (rozgr[i]==0 && (plansz_p[i] & 0xf)==0) tabl[i] |= 0x80;
   }
   strcpy(&opis_bitow[0<<5], "0: panstwa gr 1");
   strcpy(&opis_bitow[1<<5], "1: panstwa gr 2");
   strcpy(&opis_bitow[2<<5], "2: brzuszki gr 1");
   strcpy(&opis_bitow[3<<5], "3: brzuszki gr 2");
   strcpy(&opis_bitow[4<<5], "4: do zamkn przez gr 1");
   strcpy(&opis_bitow[5<<5], "5: do zamkn przez gr 2");
   strcpy(&opis_bitow[6<<5], "6: punktowane/lancuchy");
   strcpy(&opis_bitow[7<<5], "7: wolne pola");
 }
 break;
 case 8: { // robaki-ocena
   unsigned char* rozgr2 = plansze.PrzydzielPlansze();
   unsigned char* rozgr3 = plansze.PrzydzielPlansze();
   krint *polaczony_z[2];
   WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[0].Przydziel();
   ang[0].robaki[1].Przydziel();
   ang[0].robaki[0].UstawCzyje(1, TAnaliza::gracz.umiejetnosci & 0x10);
   ang[0].robaki[1].UstawCzyje(2, TAnaliza::gracz.umiejetnosci & 0x10);
   ang[0].robaki[0].Inicjuj(rozgr, rozgr2, rozgr3, plansz_p);
   ang[0].robaki[1].Inicjuj(rozgr, rozgr2, rozgr3, plansz_p);
   for (int i=0; i<2; i++) {
     polaczony_z[i] = skladowe.PrzydzielSkladowa();
     ang[0].robaki[i].UstawPolaczonyZ_sklad(polaczony_z[0]);
   }
   most12.Inicjuj();
   int przedzialy_g[16] = {20,40,60,80, 100,125,150,175, 200,240,280,320, 370,420,470, 100000};
   {
   int dolny=0;
   for (int i=0; i<16; i++) {
     sprintf(&opis_bitow[i<<5], "%c: ocena [%d-%d]", cyferki[i], dolny, przedzialy_g[i]-1);
     dolny=przedzialy_g[i];
   }
   }
   for (int i=0; i<wlkx4wlky4; i++) 
     if (upl_marg[i]>=2 && rozgr3[i]==0) {
       int poziom_bezp;
       int ocena=6*ang[0].robaki[ktory_gracz].OcenRuch(rozgr3, polaczony_z[ktory_gracz],
						       i, 1, poziom_bezp);
       if (poziom_bezp)
	 ocena+=poziom_bezp *
	   ang[0].robaki[ktory_gracz^1].OcenRuch(rozgr3, polaczony_z[ktory_gracz],
						 i, 0, poziom_bezp);
       int nr=0;
       while (ocena>=przedzialy_g[nr]) nr++;
       tabl[i] |= (1<< nr);
     }
   ang[0].robaki[0].Zwolnij();
   ang[0].robaki[1].Zwolnij();
   plansze.ZwolnijPlansze(rozgr2);
   plansze.ZwolnijPlansze(rozgr3);
   skladowe.ZwolnijSkladowa(polaczony_z[0]);
   skladowe.ZwolnijSkladowa(polaczony_z[1]);
 }
   break;
 }
}

/*
int TGra::TestSzybkosci(int kod, int iteracji, TStoper &czas)
  // zwraca 1, gdy ok, 0=blad
  // kody:
  // 0 = OcenPozycje12(), wariant optymistyczny
  // 1 = OcenPozycje12(), wariant pesymistyczny
{
  switch (kod) {
  case 2:
  case 3: // odczyt z ht
   break;
  case 4: // Bouzy
  case 5:
    {
      unsigned char* rozgr2 = plansze.PrzydzielPlansze();
      unsigned char* rozgr3 = plansze.PrzydzielPlansze();
      unsigned char* pom = plansze.PrzydzielPlansze();
      WezRozgr23(rozgr, rozgr2, rozgr3, plansz_p);
      // znajdz terytorium
      int t=0;
      czas.Start();
      int d = kod==4?2:5;
      int e = kod==4?1:13;
      for (int i=0; i<iteracji; i++) {
	Bouzy(pom, rozgr2, rozgr3, TDwaUC(2,2), TDwaUC(wlkx+1,wlky+1), d,e, 1,1,0);   // 2 wagi i punkt_za_pole
	t+=pom[11];
      }
      plansze.ZwolnijPlansze(pom);
      plansze.ZwolnijPlansze(rozgr2);
      plansze.ZwolnijPlansze(rozgr3);
    }
    return 1;
  }
}
*/

void TGra::TZapis::Zapisz(FILE *f)
{   
  unsigned char buf[44];
  int ile=0;
  ile += ZapiszSI(&buf[ile], wx);
  ile += ZapiszSI(&buf[ile], wy);
  ile += ZapiszSI(&buf[ile], ik);
  ile += ZapiszSI(&buf[ile], ile_zd1);
  ile += ZapiszSI(&buf[ile], ile_zd2);
  ile += ZapiszSI(&buf[ile], slowo);
  ile += ZapiszSI(&buf[ile], wersja_hi);
  ile += ZapiszSI(&buf[ile], wersja_lo);

  ile += ZapiszLI(&buf[ile], (long int) data_utw);
  ile += ZapiszLI(&buf[ile], zarp1);
  ile += ZapiszLI(&buf[ile], zarp2);
  ile += ZapiszLI(&buf[ile], zark1);
  ile += ZapiszLI(&buf[ile], zark2);
  ile += ZapiszLI(&buf[ile], ktory_sezon);
  ile += ZapiszLI(&buf[ile], ktory_mecz);
  assert(ile==sizeof(buf));
  fwrite(buf, 1, ile, f);
}

int TGra::TZapis::Odczytaj(FILE *f)
// zwraca liczbe odczytanych bajtow
{
  unsigned char buf[44];
  int wynik = fread(buf, 1, 44, f);
  wx = ShortInt(&buf[0]);
  wy = ShortInt(&buf[2]);
  ik = ShortInt(&buf[4]);
  ile_zd1 = ShortInt(&buf[6]);
  ile_zd2 = ShortInt(&buf[8]);
  slowo = ShortInt(&buf[10]);
  wersja_hi = ShortInt(&buf[12]);
  wersja_lo = ShortInt(&buf[14]);

  data_utw = LongInt(&buf[16]);
  zarp1 = LongInt(&buf[20]);
  zarp2 = LongInt(&buf[24]);
  zark1 = LongInt(&buf[28]);
  zark2 = LongInt(&buf[32]);
  ktory_sezon = LongInt(&buf[36]);
  ktory_mecz = LongInt(&buf[40]);
  return wynik;
}

void TGra::ZapiszRozgr(FILE *f, int ktory_sezon, int ktory_mecz)
// Zapisuje rozgrywke.
// Format zapisu:
//  0-5 short int wlkx, wlky, ile_kropek (=ile_hist-1 czasami dla zasad_gry<2, ogolnie<=);
//  6-9 short int ile_zd1, ile_zd2;   (tylko do wyswietlania i statystyki)
//  10-11 unsigned short int slowo;  (slowo stanu -- na razie zdefiniowany
//           tylko bit 0: zakonczona rozgrywka?
//                 bit 1: ktory gracz na ruchu 0-1?)
//                 bit 2: czy zakonczona gra srodkowa? (83.37+, wczesniej zawsze 0)
//  12-15 short int num_wersji_hi, num_wersji_lo;
//  16-19 long int data_utw;  (=liczba sekund od 1 I 1970 roku)
//  20-27 long int zarodek_pocz1, zarodek_pocz2;
//  28-35 long int zarodek_kon1, zarodek_kon2;  // to ma sens tylko dla
//               niezakonczonych rozgrywek
//  36-43 long int ktory_sezon, ktory_mecz   // na potrzeby turnieju (normalnie =0)
//  44-67 TStoper.Zapisz() x3  // czas gry (stoper[3])
//  68-71 short int ile_zd_do_konc[2];   (do wysw. i stat., ile zd. w grze srodkowej)
//  72-73 short int  (ile_hist-1)
//  74-79  0,0,...,0  zarezerwowane
//   unsigned short int historia_[tabliceR.IlePam()]
//  w historii pamietamy kolejne ruchy, a w najstarszym bicie - czyj ruch
//  (gracza 0 czy 1?), w bicie & 0x4000: czy ruch zamykajacy? (bez postawienia kropki, zgry==2)
{
  // przygotuj historie, policz liczbe postawionych kropek
  unsigned char *pom = new unsigned char[2*tabliceR.IlePam(wlkx,wlky)];
  memset(pom, 0, 2*tabliceR.IlePam(wlkx,wlky));
  int ile_kr=0;
  for (int i=1; i<ile_hist; i++) {
    if ((historia[i] & 0x4000)==0) ile_kr++;
    unsigned short int ind = historia[i];
    ZapiszSI(&pom[2*(i-1)], ind);
  }
  // zapisz naglowek
  TZapis zapis;
  zapis.wx = wlkx;
  zapis.wy = wlky;  
  zapis.ik = ile_kr;  //kiedys bylo ile_hist-1;
  zapis.ile_zd1 = pkt[0].zd+pkt[0].pot_zd;
  zapis.ile_zd2 = pkt[1].zd+pkt[1].pot_zd;
  //  zapis.ile_zd1 = ile_zd[0];
  //  zapis.ile_zd2 = ile_zd[1];
  zapis.slowo = (ktory_gracz==-1) | ((ktory_gracz==1)<<1) | (koncowka ? 4:0);
  zapis.wersja_hi = WERSJA_KROPEK;
  zapis.wersja_lo = WERSJA_KROPEK_LOW;
  time_t now;  time(&now);
  zapis.data_utw = now;
  zapis.zarp1 = zarodek_pocz[0];
  zapis.zarp2 = zarodek_pocz[1];
  zapis.zark1 = bseed1;
  zapis.zark2 = bseed2;
  zapis.ktory_sezon= ktory_sezon;
  zapis.ktory_mecz = ktory_mecz;
  long int gdzie = ftell(f);
  zapis.Zapisz(f); //  fwrite(&zapis, 1, sizeof(zapis), f);
  for (int i=0; i<3; i++) stoper[i].Zapisz(f);
  assert(sizeof(ile_zd_do_konc[0])==2);
  {  
    unsigned char buf[6];
    ZapiszSI(&buf[0], ile_zd_do_konc[0]);
    ZapiszSI(&buf[2], ile_zd_do_konc[1]);
    ZapiszSI(&buf[4], ile_hist-1);
    fwrite(buf, 1, 6, f);  //  fwrite(ile_zd_do_konc, 2, 2, f);
  }
  int ile = gdzie +80 - ftell(f);
  static unsigned char zera[] = {0,0,0,0,0,0, 0,0,0,0,0,0};
  fwrite(zera, 1, ile, f);
  // zapisz historie
  fwrite(pom, 1, 2*tabliceR.IlePam(wlkx,wlky), f);
  delete[] pom;
}

int TGra::OdczytajRozgr(FILE *f, int zgry, time_t &data_utw, int *numery)
  // zobacz komentarz do ZapiszRozgr()
  // zwraca 1, gdy odczyta; 0, gdy blad 
  //  (w razie bledu wskaznik pliku bez zmian)
// we: zgry == nowe zasady gry (0,1,2)
{
  TZapis zapis;
  long int gdzie = ftell(f);
  zapis.Odczytaj(f);  //  fread(&zapis, 1, sizeof(zapis), f);
  if (zapis.wx>max_bok_planszy || zapis.wy>max_bok_planszy ||
      zapis.wx<min_bok_planszy || zapis.wx<min_bok_planszy)
    { fseek(f, gdzie, SEEK_SET);
    return 0;
    }
  NowaGra(zapis.wx, zapis.wy, zgry);
  for (int i=0; i<3; i++) stoper[i].Odczytaj(f);
  assert(sizeof(ile_zd_do_konc[0])==2);
  //  fread(ile_zd_do_konc, 2, 2, f);
  int ihist;
  {
    unsigned char buf[6];
    fread(buf, 1, 6, f);
    ile_zd_do_konc[0] = ShortInt(&buf[0]);
    ile_zd_do_konc[1] = ShortInt(&buf[2]);
    ihist = ShortInt(&buf[4]);
    if (zgry<2 && ihist==0) ihist = zapis.ik;   // dla zasad gry<2 moze nie byc zapisane ihist (moze byc =0)
  }
  koncowka = (zapis.slowo & 4)!=0;
  fseek(f, gdzie +80, SEEK_SET);
  // odczytaj historie
  unsigned char *pom = new unsigned char[2*tabliceR.IlePam(zapis.wx, zapis.wy)];
  //  fread(pom, 1, 2*(zgry<2 ? (zapis.wx*zapis.wy) : tabliceR.IlePam()), f);
  fread(pom, 1, 2*ihist, f);  // odczytaj tylko tyle, ile potrzeba
  historia[0]=0;  ile_hist=1; ile_hist_zapr=1;
  char sgf_akt_r[4*max_powierzchnia_planszy];
  for (int i=0; i<ihist; i++) {
    unsigned short int pomsi = ShortInt(&pom[2*i]);
    ktory_gracz = ((pomsi & 0x8000) != 0);
    sgf_akt_r[0]=0;
    WykonajRuch((pomsi & ~0x8000), 1+(i==ihist-1), 0, sgf_akt_r);
    drzewo->sgftreeAddPlay(ktory_gracz==0 ? BLACK : WHITE, sgf_akt_r);
    }
  delete[] pom;
  // ustaw numery
  if (numery!=NULL) { 
    numery[0] = zapis.ktory_sezon;
    numery[1] = zapis.ktory_mecz;
  }
  // ustaw gracza na ruchu
  ktory_gracz = (zapis.slowo&1) ? -1 : ((zapis.slowo & 2) != 0);
  // i zarodki
  bseed1 = zapis.zark1;
  bseed2 = zapis.zark2;
  data_utw = zapis.data_utw;
  return 1;
}

int TGra::ZagrajRuchSGF(SGFNode *node)
// zwraca 1, jesli ruch wykonany
{
  if (!node) return 0;
  int kto = node->find_move();
  int jest_jakis_ruch=0;
  char *ruch;
  switch (kto) {
  case EMPTY:
    kto=0;
    break;
  case WHITE:
    kto=2;
    node->sgfGetCharProperty("W ", &ruch);
    break;
  case BLACK:
    kto=1;
    node->sgfGetCharProperty("B ", &ruch);
    break;
  }
  if (kto) {
    // wykonaj ruch
    jest_jakis_ruch=1;
    if (ruch[0]!='.') {
      int pole = SGFDajPole(ruch);
      if (pole!=-1) {
	ktory_gracz = kto-1;
	WykonajRuch(pole, 1, -1);   // NIE sprawdzaj, czy zakonczona -- bo inaczej sie pozamykaja panstwa same
	ruch+=2;
      }
    }
    while (ruch[0]=='.') {
      ++ruch;
      ZrobStopSGF(rozgr, stopy, ruch, NULL, NULL, plansz_p, pkt, kl_zobr);
      ruch=strchr(ruch, '.');
      if (ruch==NULL) break;
    }
  }
  return jest_jakis_ruch;
}


void TGra::GrajDotadSGF(SGFNode *node)
// rozgrywa gre az do wezla node
// uaktualnia lastnode
{
  SGFNode *zap = node;
  int ile_r = node->sgfMovesBefore();
  SGFNode **wezly = new SGFNode*[ile_r];
  int nr = ile_r-1;
  do {
    if (node->is_move_node())
      wezly[nr--] = node;
    node = node->parent;
  } while (node && nr>=0);
  // rozegraj
  CzyscPlansze();
  int jest_jakis_ruch = 0;
  for (int i=0; i<ile_r; i++)
    jest_jakis_ruch |= ZagrajRuchSGF(wezly[i]);
  // sprawdz, czy koniec gry (byc moze zostaly jakies stopy do zamkniecia!)
  {
    int ile_wolnego, ile_wolnego_poza_sts;
    IleWolnegoMiejsca(rozgr, plansz_p, ile_wolnego, ile_wolnego_poza_sts);
    if (!ile_wolnego && !ile_wolnego_poza_sts)
      ktory_gracz = -1;
  }
  if (jest_jakis_ruch && ktory_gracz>=0)   // zmien gracza na ruchu, jesli nie poczatek i nie koniec gry
    ktory_gracz=1-ktory_gracz;
  drzewo->sgftreeSetLastNode(zap);
  delete[] wezly;
}

int TGra::GrajNastepnySGF(SGFNode *node)
// uaktualnia lastnode
// zwraca 1, jesli ruch zostal zagrany
{
  do {
    drzewo->lastnode = node;
    node = node->child;
    if (ZagrajRuchSGF(node)) {
      drzewo->lastnode = node;
      if (ktory_gracz>=0)
	ktory_gracz=1-ktory_gracz;
      return 1;
    }
  }
  while (node);
  return 0;
}

int TGra::CzyJestTagRU(const char *rules, const char *tag)
// np. rules = 'mustsurround=1,minimalarea=1,passmove=1,holes=1',  tag = 'mustsurround'
{
  char tag2[30];
  strcpy(tag2, tag);    strcat(tag2, "=0");
  if (strstr(rules, tag2) != NULL)  //  'tag=0'
    return 0;
  if (strstr(rules, tag) != NULL)  // 'tag' lub 'tag=1'
    return 1;
  return 0;   // domyslna wartosc zawsze 0
}

int TGra::OdczytajSGF(const char *nazwa)
// funkcja jest na razie malo odporna na bledy
// zwraca 1, jesli sie udalo, 0 gdy nie
// funkcja poprawia ruchy, jesli po ruchu pozycja jest niezgodna z regulami
//  gry (co jest mozliwe tylko dla zasad gry =0 lub 1)
{
  SGFParser *parser = new SGFParser;
  SGFNode *drz = parser->readsgffile(nazwa);
  if (drz!=NULL) {
    char sgf_akt_r[4*max_powierzchnia_planszy];
    char *wartosc;
    int nx=20, ny=20;
    if (drz->sgfGetCharProperty("SZ", &wartosc)) {
      char *gdzie_dwukr = strchr(wartosc, ':');
      if (gdzie_dwukr==NULL) {
	nx = ny = atoi(wartosc);
      }
      else {
	*gdzie_dwukr = 0;
	nx = atoi(wartosc);
	*gdzie_dwukr = ':';  // odtworz
	ny = atoi(gdzie_dwukr+1);
      }
    }
    ktory_gracz=1;   // zaczyna gracz 1
    // wez zasady gry
    int zg;
    char *rules;
    if (!drz->sgfGetCharProperty("RU", &rules))
      zg=2;   // domyslne
    else {
      // ustaw zasady...
      if (strlen(rules)==1) {
	zg = rules[0] - '0';
	if (zg<0 || zg>2) zg=2;
      }
      else {
	if (CzyJestTagRU(rules, "mustsurround") || CzyJestTagRU(rules, "MustSurr"))
	  zg = 1;
	else
	  zg = 2;
      }
    }
    if (!NowaGra(nx, ny, zg)) {
      delete drz;
      return 0;
    }
    int jest_jakis_ruch = 0;

    SGFNode *node = drz;
    while (node->child)
      node = node->child;
    GrajDotadSGF(node);

    delete drzewo;
    drzewo = new SGFTree;
    drzewo->root = drz;
    drzewo->lastnode = node;  //NULL;

    return 1;
  }
  else return 0;
}

int TGra::NormujRuch(SGFNode *node)
// zamyka odp. stopy tak, by bylo zgodnie z zasadami gry (=0 lub 1, przy zasadach gry=2
// nie nie robi)
// zwraca 1, gdy trzeba bylo cos zmieniac
{
  if (zasady_gry==2) return 0;
  int kto = node->is_move_node();
  char *ruch;
  switch (kto) {
  case 0:
    return 0;   // to nie jest wezel z ruchem
  case WHITE:
    kto=2;
    node->sgfGetCharProperty("W ", &ruch);
   break;
  case BLACK:
    kto=1;
    node->sgfGetCharProperty("B ", &ruch);
    break;
  }
  int maska_naszych_pot_zd = (kto==1) ? 0x10: 0x20;
  int przec = 3-kto;
  int normowane = 0;
  char sgf_akt_r[4*max_powierzchnia_planszy];
  sgf_akt_r[0]=0;
  for (int i=up.lg; i<=up.pd; i++)
    if (rozgr[i]==przec && (plansz_p[i] & maska_naszych_pot_zd)) {
      // zamknij stop!
      normowane = 1;
      int ile_domysl, ile_zdt,pow,pow2,ile_zdt2;
      ZrobRuch(rozgr, stopy, NULL, ile_domysl,
	       sgf_akt_r, -1,
	       plansz_p, i | 0x4000, kto,
	       0, pkt, kl_zobr,
	       ile_zdt,pow,pow2,ile_zdt2, ruchy_zam); 
    }
  if (ktory_gracz==-1) {  // trzeba dodatkowo zamknac stopy przeciwnika!
    int maska_przec_pot_zd = (kto==1) ? 0x20: 0x10;
    for (int i=up.lg; i<=up.pd; i++)
      if (rozgr[i]==kto && (plansz_p[i] & maska_przec_pot_zd)) {
	// zamknij stop!
	normowane = 1;
	int ile_domysl, ile_zdt,pow,pow2,ile_zdt2;
	ZrobRuch(rozgr, stopy, NULL, ile_domysl,
		 sgf_akt_r, -1,
		 plansz_p, i | 0x4000, przec,
		 0, pkt, kl_zobr,
		 ile_zdt,pow,pow2,ile_zdt2, ruchy_zam); 
      }
  }
  if (normowane) {
    // dopisz nowe ruchy do wezla
    char *nowe = new char[strlen(ruch)+strlen(sgf_akt_r)+1];
    strcpy(nowe, ruch);  strcat(nowe, sgf_akt_r);
    node->sgfOverwriteProperty(kto==1 ? "B ": "W ", nowe);
    delete []nowe;
  }
  return normowane;
}

int TGra::UstawRodzajGracza(char *rodzaj)
{
  gr[ktory_gracz].dokl_analizy=2;
  gr[ktory_gracz].komputer=1;
  gr[ktory_gracz].Bouzy_er=1;
  gr[ktory_gracz].wagi_n.Bo=15;
  gr[ktory_gracz].waga_kropki=5; 
  gr[ktory_gracz].funkcja_mc = 3;
  gr[ktory_gracz].funkcja_mc_FPU = 11;
  gr[ktory_gracz].poziom_gry=12;
  switch (rodzaj[1]) {
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
  case '0':
  case '1':
  case '2':
    gr[ktory_gracz].dokl_analizy= (rodzaj[1] - '0') >= 3 ? (rodzaj[1] - '0') : (rodzaj[1] - '0' +10);
    break;
  case 'A':
  case 'B':    // glebokosci 13-14
    gr[ktory_gracz].dokl_analizy= (rodzaj[1] - 'A') + 13;
    break;
  case 'm':
    gr[ktory_gracz].iteracji = 100;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'M':
    gr[ktory_gracz].iteracji = 500;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'c':
    gr[ktory_gracz].iteracji = 2500;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'C':
    gr[ktory_gracz].iteracji = 12500;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'r':
    gr[ktory_gracz].iteracji = 50000;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'R':
    gr[ktory_gracz].iteracji = 250000;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'l':
    gr[ktory_gracz].iteracji = 1000000;
    gr[ktory_gracz].poziom_gry=13;
    break;
  case 'L':
    gr[ktory_gracz].iteracji = 5000000;
    gr[ktory_gracz].poziom_gry=13;
    break;
  }
  if (strlen(rodzaj)>=3) {
    char s[20];
    strncpy(s, &rodzaj[2], 19);
    int mf = atoi(s);
    if (mf>=1 && mf<=16) gr[ktory_gracz].funkcja_mc = 3*mf;
  }
}


int TGra::Serwer(char *nazwa1, char *nazwa2, int tez_stdout, int tylko_normuj, char* rodzaj, int benchmark)
// zwraca <0, gdy blad, 0=ok
//  -1 = cos zle z plikiem wejsciowym
//  -2 = koniec gry
{
  if (!OdczytajSGF(nazwa1)) return -1;
  NormujRuch(drzewo->lastnode);
  if (ktory_gracz>=0 &&     // nie koniec gry
      !tylko_normuj) {
    // znajdz najlepszy ruch
    UstawRodzajGracza(rodzaj);
    //
    char sgf_akt_r[4*max_powierzchnia_planszy];
    int x,y, ilenr;
    krint *bufor = skladowe.PrzydzielSkladowa();
    TStoper bench;
    //    struct timespec real_time, cpu_time;
    unsigned int klock;
    if (benchmark) {
      gr[ktory_gracz].czas_kiedy = 0; // nie sprawdzaj czasu!
      bench.Start();
      klock = clock();
      //      clock_gettime(CLOCK_MONOTONIC, &real_time);
      //      clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &cpu_time);
    }
    ilenr = DNajlepszyRuch(bufor, x,y);
    if (benchmark) {
      //      struct timespec real_time2, cpu_time2;
      //      clock_gettime(CLOCK_MONOTONIC, &real_time2);
      //      clock_gettime(CLOCK_PROCESS_CPUTIME_ID, &cpu_time2);
      klock = clock() - klock;
      bench.Stop();
      char s[100];
      //printf("glebokosc: %d, kiedy=%d\n" , int(gr[ktory_gracz].dokl_analizy), int(gr[ktory_gracz].czas_kiedy));
      printf("g++ version : %d.%d.%d\n", int(__GNUC__), int(__GNUC_MINOR__), int(__GNUC_PATCHLEVEL__));
      printf("sizeof(int) : %d.\n", int(sizeof(int)));
      printf("sizeof(int*): %d.\n", int(sizeof(int*)));
      if (gr[ktory_gracz].poziom_gry == 12) {
	printf("Glebokosc   : %d.\n", int(gr[ktory_gracz].dokl_analizy));
	printf("Wlk hash table: %d x %d x %d.\n", int(HTABZ_ILE_TAB), int(2), int(sizeof(HTablicaZKl)));
#ifdef __MINGW32__
	printf("o=%I64d, h=%I64d\n", statystyka_dla_analizy.funk_ocen, statystyka_dla_analizy.wez_ht);
#else
	printf("o=%lld, h=%lld\n", statystyka_dla_analizy.funk_ocen, statystyka_dla_analizy.wez_ht);
#endif
      }else{
	printf("Watkow      : %d.\n", int((gr[ktory_gracz].funkcja_mc+2)/3));
	printf("Iteracji MC : %d.\n", int(gr[ktory_gracz].iteracji));
      }
      printf("Czas na ruch (stoper)  : %s.\n", bench.IleTrwalo(s));
      double cpu_time = double(klock) / CLOCKS_PER_SEC;
      printf("Czas na ruch (cpu time): %.4f.\n", cpu_time);
      long long ileTrw = bench.IleTrwalo();
      double d = double(1.0e10) / double(ileTrw);
      double dcpu = double(1.0e4) / cpu_time;
      printf("Benchmark (real-time): %.3f.\n",d);
      printf("Benchmark  (cpu-time): %.3f.\n",dcpu);
      /*
      int sekundy = real_time2.tv_sec - real_time.tv_sec;
      int nanosekundy = real_time2.tv_nsec - real_time.tv_nsec;
      if (nanosekundy<0) {
	sekundy--;  nanosekundy+=1000000000;
      }
      printf("Czas na ruch (clock): %d.%d.\n", sekundy, nanosekundy);
      sekundy = cpu_time2.tv_sec - cpu_time.tv_sec;
      nanosekundy = cpu_time2.tv_nsec - cpu_time.tv_nsec;
      if (nanosekundy<0) {
	sekundy--;  nanosekundy+=1000000000;
      }
      printf("Czas na ruch (cpu): %d.%d.\n", sekundy, nanosekundy); */
    }
    // wykonaj ruch
    int kto_byl_nr = ktory_gracz;
    sgf_akt_r[0]=0;
    for (int i=0; i<ilenr; i++)
      WykonajRuch(bufor[i], (i<ilenr-1), -1, sgf_akt_r);
    drzewo->sgftreeAddPlay(kto_byl_nr==0 ? BLACK : WHITE, sgf_akt_r);
    skladowe.ZwolnijSkladowa(bufor);
  }
  if (ktory_gracz==-1 && !drzewo->root->sgfHasProperty("RE")) {
    // zapisz wynik, bo nie ma
    int wynik = pkt[0].zd - pkt[1].zd;
    char s[30];
    if (wynik==0)
      strcpy(s, "0");
    else if (wynik<0)
      sprintf(s, "W+%d", -wynik);
    else
      sprintf(s, "B+%d", wynik);
    drzewo->root->sgfAddProperty("RE", s);
  }
  if (!benchmark)
    writesgf(drzewo->root, nazwa2);
  if (tez_stdout)
    writesgf(drzewo->root, "-");
  return 0;
}

#ifdef TEKSTOWY
int TGra::SerwerWKonsoli(char *rodzaj, char *path, int zapisywac_sgf)
// wczytuje z stdin kolejne wiersze, postaci:
// 2 wlkx wlky    (2=wersja protokolu, wlkx, wlky=wielkosc planszy)
// X Y color 0/1  (gdzie postawic kropke, color=0/1, 0/1 = czy generowac nast. ruch)
// ...
// -1  (=koniec danych)
{
  cout << "Kropki " << WERSJA_KROPEK << '.' << WERSJA_KROPEK_LOW << "\n";
  cout << "http://kropki.nongnu.org/\n";
  cout << "Current path:\n" << path << std::endl;
  int version, x, y;
  cin >> version;
  assert(version == 2);
  cin >> x >> y;
  if (!NowaGra(x, y, 1))  // 1 == zasady gry
    return 0;
  char sgf_akt_r[4*max_powierzchnia_planszy];
  krint *bufor = skladowe.PrzydzielSkladowa();
  for (;;) {
    int who, runAI;
    cin >> x;
    if (x == -1)
      break;
    cin >> y >> who >> runAI;
    ktory_gracz = who;
    int pole = WezIndeksTab(x+2, y+2);  // +2, bo x,y sa liczone od 0, a my liczymy od 2
    sgf_akt_r[0] = 0;
    WykonajRuch(pole, 2, 0, sgf_akt_r);
    drzewo->sgftreeAddPlay(who==0 ? BLACK : WHITE, sgf_akt_r);
    cout << x << " " << y << " " << who << std::endl;
    if (runAI) {
      ktory_gracz = 1-ktory_gracz;
      UstawRodzajGracza(rodzaj);
      int k = ktory_gracz;
      int ilenr = DNajlepszyRuch(bufor, x,y);
      cout << x-2 << " " << y-2 << " " << k << std::endl;
      sgf_akt_r[0] = 0;
      WykonajRuch(WezIndeksTab(x,y), 2, 0, sgf_akt_r);
      drzewo->sgftreeAddPlay(k==0 ? BLACK : WHITE, sgf_akt_r);
      if (zapisywac_sgf)
	writesgf(drzewo->root, "AImatch.sgf");
    }
  }
  if (zapisywac_sgf)
    writesgf(drzewo->root, "AImatch.sgf");
  // posprzataj
  skladowe.ZwolnijSkladowa(bufor);
  return 0;
}

int TGra::SerwerWKonsoliWer3(char *rodzaj, char *path, int zapisywac_sgf)
// wczytuje z stdin kolejne wiersze, postaci:
// 3 wlkx wlky    (3=wersja protokolu, wlkx, wlky=wielkosc planszy)
// 0 X Y color  (0 = wykonaj ruch, XY = gdzie postawic kropke, color=0/1)
// 1   = znajdz ruch i wykonaj go
// 2   = echo string
// -1  (=koniec danych)
{
  cout << "Kropki " << WERSJA_KROPEK << '.' << WERSJA_KROPEK_LOW << "\n";
  cout << "http://kropki.nongnu.org/\n";
  cout << "Current path:\n" << path << std::endl;
  int version, x, y;
  cin >> version;
  assert(version == 3);
  cin >> x >> y;
  if (!NowaGra(x, y, 1))  // 1 == zasady gry
    return 0;
  char sgf_akt_r[4*max_powierzchnia_planszy];
  krint *bufor = skladowe.PrzydzielSkladowa();
  for (;;) {
    int who, runAI;
    cin >> runAI;
    if (runAI == -1)
      break;
    switch (runAI) {
    case 2:
      {
	std::string buffer;
	getline(cin, buffer, '\n');
	cout << buffer << std::endl;
      }
      break;
    case 0:
      {
	cin >> x >> y >> who;
	ktory_gracz = who;
	int pole = WezIndeksTab(x+2, y+2);  // +2, bo x,y sa liczone od 0, a my liczymy od 2
	sgf_akt_r[0] = 0;
	WykonajRuch(pole, 2, 0, sgf_akt_r);
	drzewo->sgftreeAddPlay(who==0 ? BLACK : WHITE, sgf_akt_r);
	cout << x << " " << y << " " << who << std::endl;
	ktory_gracz = 1-ktory_gracz;
      }
      break;
    case 1:
      {
	UstawRodzajGracza(rodzaj);
	int k = ktory_gracz;
	int ilenr = DNajlepszyRuch(bufor, x,y);
	cout << x-2 << " " << y-2 << " " << k << std::endl;
	sgf_akt_r[0] = 0;
	WykonajRuch(WezIndeksTab(x,y), 2, 0, sgf_akt_r);
	drzewo->sgftreeAddPlay(k==0 ? BLACK : WHITE, sgf_akt_r);
	if (zapisywac_sgf)
	  writesgf(drzewo->root, "AImatch.sgf");
      }
      break;
    }
  }
  if (zapisywac_sgf)
    writesgf(drzewo->root, "AImatch.sgf");
  // posprzataj
  skladowe.ZwolnijSkladowa(bufor);
  return 0;
}
#endif

int TGra::Serwer_OszacujWynik(char *nazwa1)
// zwraca <0, gdy blad, 0=ok
//  -1 = cos zle z plikiem wejsciowym
// wypisuje oszacowany wynik
{
  if (!OdczytajSGF(nazwa1)) return -1;
  NormujRuch(drzewo->lastnode);
  int basp[2];
  int kto_pierwszy_do_basenu;
  int wynik=OszacujAktWynik(basp, kto_pierwszy_do_basenu, rozgr, plansz_p, pkt, ktory_gracz+1);
  printf("%d\n", wynik);
  printf("zdobycze: %d:%d\n", int(pkt[0].zd+pkt[0].pot_zd), int(pkt[1].zd+pkt[1].pot_zd));
  printf("baseny: %d:%d\n", basp[0], basp[1]);
  printf("kto pierwszy do basenu: %d\n", kto_pierwszy_do_basenu);
  return 0;
}


int TGra::OdczytajInfoOMeczu(FILE *f, TMecz& m, int zgry, int tylko_gra_srodkowa)
// 0 == koniec pliku lub niedokonczona rozgrywka
// w przeciwnym razie zwraca indeks pola startowego
{
  TZapis zapis;
  long int gdzie = ftell(f);
  if (zapis.Odczytaj(f) < sizeof(zapis))
    return 0;
  m.nr_sez  = zapis.ktory_sezon;
  m.nr_mecz = zapis.ktory_mecz;
  for (int i=0; i<3; i++) m.czas[i].Odczytaj(f);
  if (tylko_gra_srodkowa) {
    unsigned char buf[4];
    fread(buf, 1,4,f);
    zapis.ile_zd1 = ShortInt(&buf[0]);
    zapis.ile_zd2 = ShortInt(&buf[2]);
  }
  m.ile_zd[0] = zapis.ile_zd1;
  m.ile_zd[1] = zapis.ile_zd2;
  fseek(f, gdzie + 80, SEEK_SET);
  krint pole_start;
  {
    unsigned char buf[2];
    fread(buf, 1,2,f);
    pole_start = ShortInt(buf);
  }
  fseek(f, gdzie + 80 + 2*tabliceR.IlePam(zapis.wx, zapis.wy), SEEK_SET);
  return (zapis.slowo & 1) ? pole_start : 0;
}

int TGra::DInfoOPliku(const char* nazwa, int& wx, int& wy, int& ile, int &zgry,
                TGraczO* gracze, int* ile_zd, int* pow_ss)
// Kazdy ze wskaznikow gracze, ile_zd, pow_ss moze byc == NULL.
// zwraca 0, gdy plik nie istnieje
//  lub wartosc DInfoOPliku(plik)
{
 FILE *f = fopen(nazwa,"rb");
 if (f==NULL) return 0;
 int r=DInfoOPliku(f, wx,wy,ile,zgry,gracze,ile_zd,pow_ss);
 fclose(f);
 return r;
}

int TGra::DInfoOPliku(FILE* f, int& wx, int& wy, int& ile, int &zgry, TGraczO *gracze,
		      int *ile_zd, int *pow_ss)
// Kazdy ze wskaznikow gracze, ile_zd, pow_ss moze byc == NULL.
// zwraca 1 - zakonczona rozgrywka, plik ok
//        2 - niezakonczona rozgrywka, ruch gracza 1, plik ok
//        3 - niezakonczona rozgrywka, ruch gracza 2, plik ok
//        4 - plik .t turnieju, ok
//        5 - plik .m turnieju, ok
//        9,10,11 - rozgrywka w wersji 15-16, plik ok, odp.: zakonczona, na ruchu 1,2
//        12,13- plik .t turnieju w wersji 15,16, ok
// ujemna wartosc -- blad:
//  -1  zly ID
//  -2  zla wersja
//  -3  zly rozmiar planszy
//  -4  nieznany gracz
//  -5  za duzo lub za malo graczy (tylko dla turnieju, plik .t)
// wstawia
//   (wx,wy) - wielkosc planszy (typ pliku 1,2,3,4)
//    wx     - numer wersji (typ pliku 5)
//    ile    - ile kropek (typ 1,2,3), ile graczy (typ 4,12), ile sezonow (typ 5)
//    zgry   - zasady gry (0,1,2)
//    gracze - gracze (typ 1,2,3,4,12)
//    ile_zd,pow_ss - tylko dla typu 1,2,3
// W razie bledu nie zmienia wartosci *gracze, *ile_zd, *pow_ss,
// ale zmienia wx,wy,ile, jesli tylko blad jest <-2.
// W przypadku, gdy nie ma bledu, i plik jest typu 1,2,3,6 to wskaznik
// pliku jest ustawiony na poczatek tablic (rozgrywka, stopy, ...).
// UWAGA: W przypadku typu 9-11 nie ustawia ile_zd ani pow_ss (w wersji 15
//        te informacje sa w rozgrywce).
//
// Moga byc klopoty, jesli wolajacy spodziewa sie, ze podany plik
// ma n graczy, a w rzeczywistosci ma wiecej... (mozliwe np. przy podmianie
// dyskietki).
//
// Format pliku .z  (typ 1,2,3)
//   offset   typ        opis
//     +0     char[4]    'krob' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (11-14)
//     +6     int        wlkx planszy
//     +8     int        wlky planszy
//     +10    int        ile w historii (==ile postawiono kropek+1)
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int[7]     wolne pola (==0)
//     +32    TGracz[2]  gracze
//   kolejno...  rozgrywka, stopy, plansz_p, historia
// Wszystkie te tablice sa zapisane bez zadnego oszczedzania, tj. kazda
// ma (wlkx+4)*(wlky+4) pol.
// Uwagi: TGracz jest zapisywane bez ostatniego pola umiejetnosci (w. 11,12).
// Wersja 11 zapisuje przejmuje_sie wg starych zasad, 12 -- wg nowych.
// Wersja 13 zapisuje jak 12, ale z polem umiejetnosci.
// Wersja 14 ,,zna'' poziom 12 i nowy format agresji.
// Pola [+12] i [+14] pojawily sie w wersji 80 kropek.
//
// Format pliku .t  (typ 4)
//   offset   typ        opis
//     +0     char[4]    'krot' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (10-12)
//     +6     int        wlkx planszy (plx)
//     +8     int        wlky planszy (ply)
//     +10    int        ile_graczy
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int        zasady_gry (jesli != 0, to wersja==16)
//     +20    int[6]     wolne pola (==0)
//     +32    TGracz[ile_graczy]  gracze
// Wersje plikow:
//    10  -- stary format przejmuje_sie, bez pola umiejetnosci
//    11  -- nowy format przejmuje_sie, bez pola umiejetnosci
//    12  -- nowy format przejmuje_sie, z polem umiejetnosci
// Pola [+12] i [+14] pojawily sie w wersji 80 kropek.
  // Typ 12: jak wyzej, a potem TKalendarzRozgr i kolejne rozgrywki
//
// Format pliku .m  (typ 5)
//   offset   typ        opis
//     +0     char[4]    'krom' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (teraz 10)
//     +6     int        ile_sezonow (juz w calosci rozegranych), czyli aktualny sezon
//     +8     int[12]    wolne pola (==0)
//     +32    TMecz[ile_meczow_w_sezonie]    (ile_sezonow+1 razy)
//
// Format pliku .z (typ 9-11 -- wersja pliku==15 lub 16)
//   offset   typ        opis
//     +0     char[4]    'krob' -- identyfikator zbioru
//     +4     int        numer wersji potrzebnej (15)
//     +6     int        wlkx planszy
//     +8     int        wlky planszy
//     +10    int        ile postawiono kropek+1  (==ile w historii dla zasad_gry<2)
//      +12   int        numer wersji kropek (poczawszy od 80)
//      +14   long int   data utworzenia (liczba sekund od 1 stycznia 1970)
//     +18    int        zasady_gry (83.41+), gdy !=0, to wersja==16 
//     +20    int[6]     wolne pola (==0)
//     +32    TGraczO[2] gracze -- zob. TGraczO::Odczytaj()
//     +...   rozgrywka  -- zob. ZapiszRozgr().
{
 fseek(f,0,SEEK_SET);
 unsigned char nagl[32];
 memset(nagl, 0, 32);
 fread(nagl, 1, 32, f);
 if (nagl[0]!='k' || nagl[1]!='r' || nagl[2]!='o')
   return -1;  // nieprawidlowy ID
 int typ_pliku, wersja=nagl[4] + (nagl[5]<<8);
 switch (nagl[3])
   {
   case 'b':
     typ_pliku = 1;
     if (wersja<11 || wersja>16) return -2;   // nieznana wersja
     break;
   case 't':
     typ_pliku = 12 + (wersja==16);
     if (wersja!=15 && wersja!=16) return -2;   // nieznana wersja
     break;
   case 'm':
     // typ_pliku = 5;
     if (wersja!=10) return -2;   // nieznana wersja
     ile = (nagl[7] << 8) + nagl[6];
     wx = wersja;
     return 5;
   default:
     return -1;   // nieprawidlowy ID
   }
 wx = (nagl[7] << 8) + nagl[6];
 wy = (nagl[9] << 8) + nagl[8];
 ile = (nagl[11] << 8) + nagl[10];
 if (typ_pliku==1) ile--;   // z ile_hist zrob liczbe kropek
 zgry = (wersja==16) ? ((nagl[19] << 8) + nagl[18]) : 0;
 if (wx>max_bok_planszy || wy>max_bok_planszy ||
     wx<min_bok_planszy || wx<min_bok_planszy)
   return -3;   // zly rozmiar planszy
 if ((typ_pliku==12 || typ_pliku==13) && (ile<2 || ile>MAX_GRACZY_W_TURN))
   return -5;  // za duzo graczy
 int ile_graczy = (typ_pliku==12 || typ_pliku==13) ? ile : 2;
 TGraczO test_gr;
 if (wersja==15 || wersja==16) {
   for (int i=0; i<ile_graczy; i++)
     if (!test_gr.Odczytaj(f)) return -4;  // nieznany gracz
   if (gracze!=NULL) { // wez informacje o graczach, jesli trzeba
     fseek(f, 32, SEEK_SET);
     for (int i=0; i<ile_graczy; i++)
       gracze[i].Odczytaj(f);
   }
   if (typ_pliku==12 || typ_pliku==13) {  // turniej
     int zap = ftell(f);
     short int ile_meczow_w_sez;
     //     fread(&ile_meczow_w_sez, 1, sizeof(ile_meczow_w_sez), f);
     {
       unsigned char buf[2];
       fread(buf, 1,2, f);
       ile_meczow_w_sez = ShortInt(buf);
     }
     fseek(f, ile_meczow_w_sez*sizeof(TKalendarzRozgr::TMecz), SEEK_CUR);
     int pocz = ftell(f);
     fseek(f, 0, SEEK_END);
     // ponizej jest -1, bo interesuja nas pelne sezony
     int dg =  80+2*(typ_pliku==12 ? wx*wy : tabliceR.IlePam(wx,wy));  // zob. TGra::ZapiszRozgr()
     int ile = (ftell(f)-pocz-1) / (dg*ile_meczow_w_sez);
     fseek(f, zap, SEEK_SET);
     return typ_pliku;
   }
   TZapis zapis;
   zapis.Odczytaj(f); // fread(&zapis, 1, sizeof(zapis), f);
   fseek(f, -sizeof(zapis), SEEK_CUR);
   int kto = (zapis.slowo&1) ? -1 : ((zapis.slowo & 2) != 0);
   return 10+kto;   // rozgrywka w wersji 15
 }
 int dlug_TGracz = ((wersja + (typ_pliku==4)) >= 13) ? 48:46;
 int koniec_gry=0;
 unsigned char grs[12][48];
 for (int i=0; i<ile_graczy; i++)
   {
   grs[i][46]=1|4; grs[i][47]=0;  // ustaw umiejetnosci w razie gdyby dlug_TGracz==46
   fread(grs[i], 1, dlug_TGracz, f);
   if (!test_gr.Wstaw(grs[i]))
     return -4;  // nieznany gracz
   if (typ_pliku==4 && !test_gr.komputer)
     return -4;  // czlowiek w turnieju = nieznany gracz
   if (typ_pliku<4)
   if (grs[i][40]==0xff)   // koniec gry?
     koniec_gry++;
   else if (grs[i][40]==0)  // nie na ruchu?
     typ_pliku=3-i;
   }
 if (typ_pliku==1 && koniec_gry!=2)
   return -4;  // nie wiadomo, kto na ruchu -- blad ,,nieznany gracz''
 if (gracze!=NULL)  // wez informacje o graczach, jesli trzeba
 for (int i=0; i<ile_graczy; i++)
   {
   gracze[i].Wstaw(grs[i]);
   if (typ_pliku!=4)
     {
     if (ile_zd!=NULL)
       //       ile_zd[i] = grs[i][42] + (grs[i][43] << 8);
       pkt[i].zd = grs[i][42] + (grs[i][43] << 8);
     if (pow_ss!=NULL)
       // pow_ss[i] = grs[i][44] + (grs[i][45] << 8);
       pkt[i].ss = grs[i][44] + (grs[i][45] << 8);
     }
   }
 return typ_pliku;
}


void TGra::StoperyOdNowa()
{
  for (int i=0; i<3; i++) {
    stoper[i].Stop();
    stoper[i].Start();
    if ((i<2 && i!=ktory_gracz) || (tryb & TRYB_PAUZA))
      stoper[i].Wstrzymaj();
  }
}

void TGra::StoperyWstrzymaj()
{
  for (int i=0; i<3; i++) stoper[i].Wstrzymaj();
}

void TGra::StoperyWznow()
{
  if ((tryb & TRYB_PAUZA)==0) {
    if (ktory_gracz>=0) {
      stoper[ktory_gracz].Wznow();  
      stoper[1-ktory_gracz].Wstrzymaj();
    }
    else for (int i=0; i<2; i++) stoper[i].Wstrzymaj();
    stoper[2].Wznow();
  }
  else for (int i=0; i<3; i++) stoper[i].Wstrzymaj();
}

void TGra::StoperyStop()
{
  for (int i=0; i<3; i++) stoper[i].Stop();
}

int TGra::Str2Int(const char* s)
{
  char *endptr;
  errno = 0;
  int l=strtol(s, &endptr, 0);
  if ((errno == ERANGE && (l == INT_MAX || l == INT_MIN))
      || (errno != 0 && l == 0))
    return 0;   // blad
  if (endptr == s)
    return 0;   // nie bylo cyfr
  return l;
}

int main(int argc,char *arg[])
{
 UstawZobrist();
 brandomize();

 statystyka_dla_analizy.funk_ocen = statystyka_dla_analizy.wez_ht = 0;
 for (int i=0; i<4; i++)
   statystyki_prog.ht_kolizja[i]=0;

 char *katalog;
 if (strrchr(arg[0], '/')==NULL)
   katalog = NULL;
 else {
   katalog = new char[strlen(arg[0])+1];  // dla ulatwienia
   strcpy(katalog, arg[0]);
   *(strrchr(katalog, '/')+1) = 0;
 }

 #ifdef TEKSTOWY
 {
   TSlowa opcje;
   char *drugi_plik=NULL;
   if (katalog) {
     drugi_plik = new char[strlen(katalog) + 20];
     strcpy(drugi_plik, katalog);
     strcat(drugi_plik, "kropki.cfg");
   }
   int jest_cfg = (opcje.Wczytaj("kropki.cfg") || (katalog && opcje.Wczytaj(drugi_plik)));
   if (jest_cfg) {
     int pom=TGra::Str2Int(opcje["tabl_mieszajaca"]);
     if (pom>2000) pom=2000;
     if (pom>=0 && pom<=2000) {
       pom<<=20;  // przelicz na megabajty
       if (pom==0) pom = 200000;   // 200k
       int podstawa=12;
       for (;;) {
	 long long int pamiec = sizeof(HTablicaZKl) * 2;
	 pamiec <<= podstawa;
	 if (pamiec<=pom)
	   HTABZ_ILE_TAB = 1u << podstawa;
	 else break;
	 // wez nastepny
	 podstawa++;
       }
       HTABZ_MASKA = HTABZ_ILE_TAB-1;

     }
     if (katalog) {
       strcpy(drugi_plik, katalog);
       strcat(drugi_plik, "kropkipl");
     }
     if (!slowa.Wczytaj(opcje.DajSlowo("text")) && !slowa.Wczytaj("kropkipl")
	 && (katalog==NULL || !slowa.Wczytaj(drugi_plik))) {
       printf("Nie ma pliku %s z tekstami!\n", drugi_plik ? drugi_plik:"kropkipl");
       return 1;
     }
   }
   else {
     if (katalog) {
        strcpy(drugi_plik, katalog);
	strcat(drugi_plik, "kropkipl");
     }
     if (!slowa.Wczytaj("kropkipl")
	 && (katalog==NULL || !slowa.Wczytaj(drugi_plik))) {
       printf("Nie ma pliku %s z tekstami!\n", drugi_plik ? drugi_plik:"kropkipl");
       return 1;
     }
   }
   if (drugi_plik) delete[] drugi_plik;
 }
 if (argc>=2)
   {
   plansze.PrzydzielPamiec();
   skladowe.PrzydzielPamiec();
   tabliceLI.PrzydzielPamiec();
   tabliceR.PrzydzielPamiec();
   gra.PrzydzielPamiec();
   switch (arg[1][0]) {
   case 't':  // turniej
     if (argc<3)
       { printf("Potrzebny parametr: nazwa pliku turnieju (z roszszerzeniem).\n"); return 1; }
     pargry.tryb = TRYB_TURNIEJ;
     strcpy(pargry.nz1, arg[2]);
     pargry.kod=1;
     gra.ObsluzZdarzenie(ZD_TRYB);
     if (gra.DTryb()!=TRYB_TURNIEJ) return 1;   // blad w pliku (inf. sie juz wyswietlila)
     break;
   case 'b': // benchmark
     {
       if (argc<3)
	 { printf("Potrzebny parametr: plik_we.\n"); return 1; }
       for (int i=0; i<argc; i++)
	 printf("%s ", arg[i]);
       printf("\n");
       bseed1=15666;  bseed2=0;
       htablicaZ.PrzydzielPamiec();
       return gra.Serwer(arg[2], NULL, (arg[1][0]=='N'), 0, arg[1], 1);
     }
     break;
   case 'n':  // normuj ruch, dodatkowo wyswietlany sgf wyjsciowy
   case 'N':  // normuj ruch
     if (argc<4)
       { printf("Potrzebne 2 parametry: plik_we plik_wy.\n"); return 1; }
     return gra.Serwer(arg[2], arg[3], (arg[1][0]=='N'), 1, arg[1], 0);
   case 'R':  // ruch, dodatkowo wyswietlany sgf wyjsciowy
   case 'r':  // ruch
     if (argc<4)
       { printf("Potrzebne 2 parametry: plik_we plik_wy.\n"); return 1; }
     htablicaZ.PrzydzielPamiec();
     return gra.Serwer(arg[2], arg[3], (arg[1][0]=='R'), 0, arg[1], 0);
   case 'o':  // oszacuj wynik
     if (argc<3)
       { printf("Potrzebne parametr: plik_we.\n"); return 1; }
     htablicaZ.PrzydzielPamiec();
     return gra.Serwer_OszacujWynik(arg[2]);
   case 'c':  // gra w konsoli
     htablicaZ.PrzydzielPamiec();
     gra.SerwerWKonsoli(arg[1], arg[0], strlen(arg[1])>=3);
     return 0;
   case 'C':  // gra w konsoli - wersja 3 protokolu
     htablicaZ.PrzydzielPamiec();
     gra.SerwerWKonsoliWer3(arg[1], arg[0], strlen(arg[1])>=3);
     return 0;
   }

   }
 else  { printf("Potrzebna komenda: t (turniej), r (zrob ruch), n (normuj ostatni ruch), o (oszacuj wynik),\n"
"or c/C (command line, c for protocol version=2, C -- for version 3).\n"); return 1; }
 #else

 int rx=640, ry=480;
 int codepage = 1;   // which fonts to use...

#ifdef __XWIN__
 rx=750;   // domyslna wartosc dla XWIN
#endif
 // wez opcje z pliku ,,kropki.cfg''
 {
   char texts_file[256] = "kropkien";   // default...
   strcpy(nazwa_pliku_pomocy, "helpen");
   TSlowa opcje;
   if (opcje.Wczytaj("kropki.cfg")) {
     rx = TGra::Str2Int(opcje["rozdzx"]);
     ry = TGra::Str2Int(opcje["rozdzy"]);
     if (strcasecmp(opcje["language"],"english")==0) {
       codepage = 1;
       strcpy(texts_file, "kropkien");
       strcpy(nazwa_pliku_pomocy, "helpen");
     }
     else if (strcasecmp(opcje["language"],"polish")==0) {
       codepage = 2;
       strcpy(texts_file, "kropkipl");
       strcpy(nazwa_pliku_pomocy, "helppl");
     }
     else if (strcasecmp(opcje["language"],"ukrainian")==0) {
       codepage = 5;
       strcpy(texts_file, "kropkiua");
       strcpy(nazwa_pliku_pomocy, "helpua");
     }
     else if (strcasecmp(opcje["language"],"russian")==0) {
       codepage = 5;
       strcpy(texts_file, "kropkiru");
       strcpy(nazwa_pliku_pomocy, "helpru");
     }
     if (strcmp(opcje.DajSlowo("codepage"),"???"))
       codepage = TGra::Str2Int(opcje["codepage"]);
     if (strcmp(opcje.DajSlowo("text"), "???"))
       strcpy(texts_file, opcje["text"]);
     if (strcmp(opcje.DajSlowo("pomoc"), "???")!=0)
       strcpy(nazwa_pliku_pomocy, opcje["pomoc"]);
     int pom;
#ifndef USTALONA_WLK_PLANSZY
     pom=TGra::Str2Int(opcje["wlkx"]);
     if (pom>=min_bok_planszy && pom<=max_bok_planszy) wlkx=pom;
     pom=TGra::Str2Int(opcje["wlky"]);
     if (pom>=min_bok_planszy && pom<=max_bok_planszy) wlky=pom;
#endif
     if (strcmp(opcje["imie1"],"???")) gra.UstawImie(0, opcje["imie1"]);
     if (strcmp(opcje["imie2"],"???")) gra.UstawImie(1, opcje["imie2"]);
     if (strcmp(opcje["zasady_gry"],"???")) {
       zasady_gry=TGra::Str2Int(opcje["zasady_gry"]);
       if (zasady_gry<0 || zasady_gry>2) zasady_gry=2;
     }
     //
     pom=TGra::Str2Int(opcje["tabl_mieszajaca"]);
     if (pom>2000) pom=2000;
     if (pom>=0 && pom<=2000) {
       pom<<=20;  // przelicz na megabajty
       if (pom==0) pom = 200000;   // 200k
       int podstawa=12;
       for (;;) {
	 long long int pamiec = sizeof(HTablicaZKl) * 2;
	 pamiec <<= podstawa;
	 if (pamiec<=pom)
	   HTABZ_ILE_TAB = 1u << podstawa;
	 else break;
	 // wez nastepny
	 podstawa++;
       }
       HTABZ_MASKA = HTABZ_ILE_TAB-1;

     }
     ekran.WezOpcje(opcje);
     if (strcmp(opcje["korzystaj_z_pop_ht"], "???")!=0)
       if (strcmp(opcje["korzystaj_z_pop_ht"], "tak")==0)
	 opcje_gry.korzystaj_z_pop_ht=1;
       else
	 opcje_gry.korzystaj_z_pop_ht=0;
   }

   if (!slowa.Wczytaj(texts_file)) {
     printf("Nie ma pliku z tekstami!\n");
     return 1;
   }
   if (strcmp(slowa["imie1"],"???")) gra.UstawImie(0, slowa["imie1"]);
   if (strcmp(slowa["imie2"],"???")) gra.UstawImie(1, slowa["imie2"]);
 }
 // wez opcje z parametrow wywolania
 if (argc>=2) {
   rx = TGra::Str2Int(arg[1]);
   if (argc>=3)
     ry = TGra::Str2Int(arg[2]);
   else ry = (3*rx)/4;
 }
 //#ifdef __XWIN__
 if (rx<=634 || rx>2000) rx=640;
 if (ry<=427) ry=480;
 if (rx<=ry) ry=(3*rx)/4;
 /*
#else
 if (rx<800) rx=640;
 else if (rx<1024) rx=800;
 else rx=1024;
 ry=(3*rx)/4;
#endif
 */

 if (katalog) delete[] katalog;
 plansze.PrzydzielPamiec();
 skladowe.PrzydzielPamiec();
 tabliceLI.PrzydzielPamiec();
 tabliceR.PrzydzielPamiec();
 gra.PrzydzielPamiec();

 // GrSetMode(GR_width_height_color_graphics, rx,ry,16);
 X2GrxSetCodepage(codepage);
 GrSetMode(GR_width_height_bpp_graphics, rx,ry,16);
 rx=GrSizeX();   ry=GrSizeY();
 GrMouseInit();
 // GrZrobKursor();
 GrMouseDisplayCursor();

 if (!GrMouseDetect())
  {
  printf("Nie ma myszy ?!");
  return 0;
  }
 {
 char tytul[80];
 sprintf(tytul, "Kropki %d.%d",int(WERSJA_KROPEK), int(WERSJA_KROPEK_LOW));
 GrSetWindowTitle(tytul);
 }
 ekran.SkonstruujMenu();
// ekran.InicjujKolory();

 int nowa_wys_fontu = 0, nowa_szer_fontu = 0;
 #ifndef __XWIN__
 if (codepage==5) {   // font rosyjski jest wiekszy...
   nowa_wys_fontu=10;
   nowa_szer_fontu=7;
 }

 #endif
 ekran.UstawRozdzielczosc(rx,ry, nowa_wys_fontu, nowa_szer_fontu);
 ekran.WyswietlWszystko();
 #endif

 htablicaZ.PrzydzielPamiec();

 ekran.UstawWersje(WERSJA_KROPEK, WERSJA_KROPEK_LOW, 
		   HTABZ_ILE_TAB, 2, sizeof(HTablicaZKl));
 gra.GlownaPetla();
 #ifndef TEKSTOWY
 GrClose();
 #endif
}


