#! /usr/bin/env python
# -*- coding: utf-8 -*-

import sys



def wezInt(tekst):
    while tekst:
        if tekst[0] not in '1234567890':
            tekst = tekst[1:]
        else:
            break
    ind = tekst.find('.')
    if ind >= 0:
        return int(tekst[:ind])
    else:
        raise IndexError

def wezReal(tekst):
    while tekst:
        if tekst[0] not in '1234567890':
            tekst = tekst[1:]
        else:
            break
    ind = tekst.rfind('.')
    if ind >= 0:
        return float(tekst[:ind])
    else:
        raise IndexError


def wypiszBenchZPliku(f):
    benchmarki = ['kropki8413_32bit b5', 'kropki8413_32bit bC', 'kropki8413_64bit b5', 'kropki8413_64bit bC']
    mojeBench = {}
    cpuMHz = 0
    model = ''
    recording = False
    cpuInfo = []
    uname = ''
    note = ''
    for line in f:
        for b in benchmarki:
            if b in line:
                aktBench = b
                if aktBench == benchmarki[0] or aktBench == benchmarki[2]:
                    ileWatkow = 1
                    typ = 'alfaBeta'
                else:
                    typ = 'monteCarlo'
                if aktBench == benchmarki[0] or aktBench == benchmarki[1]:
                    bity = 32
                else:
                    bity = 64
                break
        if 'Watkow' in line:
            try:
                ileWatkow = wezInt(line)
            except:
                pass
            continue
        if 'Benchmark  (cpu-time)' in line and ileWatkow==1:
            benchV = wezReal(line)
            if typ in mojeBench:
                mojeBench[typ].append( (ileWatkow, benchV) )
            else:
                mojeBench[typ] = [ (ileWatkow, benchV) ]
            continue
        if 'Benchmark (real-time)' in line and ileWatkow>1:
            benchV = wezReal(line)
            if typ in mojeBench:
                mojeBench[typ].append( (ileWatkow, benchV) )
            else:
                mojeBench[typ] = [ (ileWatkow, benchV) ]
            continue
        if 'model name' in line:
            ind = line.find(':')
            model = line[ind+1:]
            continue
        if 'cpu MHz' in line:
            c = wezReal(line)
            if c > cpuMHz: cpuMHz = c
        if 'processor' in line and not cpuInfo:
            recording = True
        if recording:
            cpuInfo.append(line)
        if 'power management' in line:
            recording = False
        if uname == '!':
            uname = line
        if 'uname -rv' in line:
            uname = '!'  # zapisz nastepna linie
        if 'Note:' in line:
            note = line

    if not model or not cpuMHz:
        return None

    html = []
    html.append('<tr>')
    html.append('<td title="%s">%s</td><td>%s</td>' % ('             '.join(cpuInfo), model, cpuMHz))
    html.append('<td title="%s">%s</td>' % (uname.split()[0], '64 bit' if 'amd64' in uname else '32 bit'))
    b1=0; bmax=0; wmax=0
    for p in mojeBench['monteCarlo']:
        if p[0] == 1:
            b1 = p[1]
        if p[0] > wmax:
            wmax = p[0]
            bmax = p[1]

    kropkiMark = 9 / ((5/mojeBench['alfaBeta'][0][1]) + (1/b1) + (3/bmax))
    html.append('<td>%.3f</td><td>%.3f</td><td title="%d thread%s">%.3f</td>' % \
                    (mojeBench['alfaBeta'][0][1], b1, wmax, ('s' if wmax>1 else ''), bmax))
    html.append('<td>%.3f</td>' % kropkiMark)
    html.append('<td>%s</td>' % note)
    html.append('</tr>')
    return (''.join(html), kropkiMark, bity)


print '<html><body>'
# ************************ 32 bit
print '<h1>Kropki 84.13 32 bit</h1>'
print '<table style="border-spacing: 15px; word-wrap:break; ">'
print '<tr><th>CPU</th><th>MHz</th><th>Linux</th><th>AlfaBeta Mark</th><th>Monte Carlo 1 thread</th><th>Monte Carlo multithreaded</th><th>KropkiMark</th><th>Notes</th></tr>'
ben32 = []
ben64 = []
for fileName in sys.argv[1:]:
    f = open(fileName, 'r')
    dane =  wypiszBenchZPliku(f)
    if dane:
        if dane[2] == 32:
            ben32.append(dane)
        else:
            ben64.append(dane)
    f.close()

ben32.sort(lambda x,y: 1 if x[1]-y[1]<0 else 0 if x[1]==y[1] else -1)

for b in ben32:
    print b[0]

print '</table>'

# ************************ 64 bit
print '<hr>'
print '<h1>Kropki 84.13 64 bit</h1>'
print '<table style="border-spacing: 15px; word-wrap:break; ">'
print '<tr><th>CPU</th><th>MHz</th><th>Linux</th><th>AlfaBeta Mark</th><th>Monte Carlo 1 thread</th><th>Monte Carlo multithreaded</th><th>KropkiMark</th></tr>'
ben64.sort(lambda x,y: 1 if x[1]-y[1]<0 else 0 if x[1]==y[1] else -1)

for b in ben64:
    print b[0]

print '</table>'

print '</body></html>'
