/*
    CLIENT.C - THIS IS THE CLIENT OF THE LAMPIAO VERSION CONTROL.
    Copyright (C) 2005/6  Alexandre Mulatinho

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 ** CLIENTE DO SERVIDOR LAMPIO, SE CONECTA SETANDO A VARIAVEL LAMPIAOSERV COM O IP
 ** E UTILIZA A  FUNO SELECT  PARA QUE OCORRAM A MULTIPLEXIAO DE DADOS ENTRE O
 ** SERVIDOR E O CLIENTE.
 **/

#include "lampiao.h"
#include "strkey.c"

int client_cmd(int server, char *s, char *proj)
{
	char *arg0=NULL, *arg1=NULL, *p=NULL;
	char buf[SMAX], sbuf[SMAX], fpath[SMAX], fname[SMAX], twbuf[SMAX];
	int sbytes, rbytes, stat, loop, fp;
	struct dirent **files;
	struct stat obj;
	

	if (strncmp(s, "logoff", 6)==0 || strncmp(s, "exit", 4)==0 || strncmp(s, "quit", 4)==0)
		return 0;
			
	if (!strncmp(s, "mkdir", 5)) {
		arg0 = (char*)get_current_dir_name();
		arg1 = strkey(s, 1, ' ');

		if (arg1) {
			*(arg1 + strlen(arg1)-1) = '\0';
			snprintf(buf, SMAX-1, "mkdir %s/%s\0", proj, arg1);
		} else {
			snprintf(buf, SMAX-1, "mkdir\0");
		}

		write(server, buf, strlen(buf));
				
	}

	else if (!strncmp(s, "send", 4)) {
		p = strkey(s, 2, ' ');

		if (p) {
			*(p + strlen(p)-1) = '\0';

			if ((fp = open(p, O_RDONLY))) {
				snprintf(buf, SMAX-1, "send %s/%s %s\0", proj, arg0, p);
				write(server, s, strlen(sbuf));
				usleep(9);

				sbytes = 0;
				while ((sbytes=read(fp, buf, sizeof(buf)-1))) {
					buf[sbytes] = '\0';
					write(server, buf, strlen(buf));
				}
				memset(buf, 0, SMAX);
				close(fp);

				usleep(9);
				snprintf(buf,SMAX-1, "-eof\0");
				write(server, buf, strlen(buf));
			} else {
				fprintf(stdout, "this file doesnt exists.\n");
			}
		} else {
			arg0 = (char*)get_current_dir_name();
			arg1 = strkey(sbuf, 1, ' ');

			if (arg1)
				*(arg1 + strlen(arg1)-1) = '\0';
					
				stat = scandir(arg0, &files, 0, alphasort);
				for (loop=0; loop<stat; loop++) {
					if (files[loop]->d_name[0]!='.') {
						snprintf(fname, SMAX-1, "%s/%s\0", arg0, files[loop]->d_name);
						lstat(fname, &obj);
						usleep(9);

						//FIXME: update is_elf
						if (S_ISREG(obj.st_mode)) {
//						fprintf(stderr, "enviando: %s\n", fname);
//						if (!is_elf(fname)) {
						if ((fp = open(fname, O_RDONLY))) {
						// INFORMA O SERVIDOR.
							snprintf(fpath, SMAX-1, "send %s/%s %s\n\0", proj, arg1, files[loop]->d_name);
							write(server, fpath, strlen(fpath));
							sbytes=0;

							while ((sbytes=read(fp, twbuf, sizeof(twbuf)-1))) {
								usleep(9);
								twbuf[sbytes] = '\0';
								send(server, twbuf, strlen(twbuf), 0);
							}
							memset(twbuf, 0, strlen(twbuf));
							close(fp);
	
							usleep(9);
							snprintf(twbuf, SMAX-1, "-eof\0");
							write(server, twbuf, strlen(twbuf));
	
							usleep(9);
							while ((sbytes=read(server, twbuf, sizeof(twbuf)-1))) {
								twbuf[sbytes] = '\0';
								write(1, twbuf, strlen(twbuf));
				
								if (sbytes)
									break;
							}
						} 
//						}
					}
				}	
			}
		}
	
	} else {
		write(server, s, strlen(s));
	}

	return 0;
}

int main(void) 
{
	char *pass;
	fd_set slave, master;
	char rbuf[SMAX], sbuf[SMAX], buf[SMAX];
	struct sockaddr_in net, cln;
	struct hostent *he;
	struct stat obj;
	int sbytes, ibytes, fbytes, fdmax, loop, stat, tsiz, user, soq, fp;
	char *proj=NULL, *arg0=NULL, *arg1=NULL, *host=NULL, *p=NULL;

	p = getenv("LAMPIAOSERV");
	if (p) {
		proj = strkey(p, 0, '@');
		host = strkey(p, 1, '@');
	}

	if (!host || !proj || !p) {
		fprintf(stderr, "if you are new in lampiao, use:\n"
		                "\033[1mexport LAMPIAOSERV=newuser@host\033[m\n");
		return -0xDEAD;
	}

	if (!(he = gethostbyname(host))) {
		fprintf(stderr, "can't resolv address.\n");
		return -0xDEAD;
	}
	
	net.sin_port        = htons(PORT);
	net.sin_family      = AF_INET;
	net.sin_addr.s_addr = inet_addr(he->h_name);
	
	if ((soq = socket(AF_INET,SOCK_STREAM,0)) < 0)
		return -0x211;

	if (connect(soq, (struct sockaddr *)&net, sizeof(struct sockaddr)) < 0)
		return -0xB6F;

	usleep(9);
	read(soq, rbuf, SMAX-1);
	write(1, rbuf, strlen(rbuf));
	memset(rbuf, 0, SMAX);
	
	ibytes = 0; fbytes = 0;
	while (0x135) {
		if ((ibytes = read(0, sbuf, SMAX-1))) {
			sbuf[ibytes] = '\0';
			client_cmd(soq, sbuf, proj);
			
			while (!fbytes) {
				if ((fbytes = read(soq, rbuf, SMAX-1)) <= 0) {
					if (!fbytes) 
						fprintf(stderr, "[~] conexo fechada\033[1m:\033[m %s\n", inet_ntoa(cln.sin_addr));

					close(user);
				} else {
					if (!strncmp(rbuf, "password: ", strlen(rbuf))) {
						pass = getpass("password: "); usleep(5);
						write(soq, pass, strlen(pass));

						ibytes = 0;
						while (!(ibytes = recv(soq, sbuf, SMAX-1, 0)));
						sbuf[ibytes] = '\0';
						write(1, sbuf, strlen(sbuf));
					} else {	
						write(1, rbuf, fbytes);
					}
				}
			}
			fbytes = 0; ibytes = 0; 
			memset(rbuf, 0, SMAX);
			memset(sbuf, 0, SMAX);
		}
		usleep(9);
	}

	return 0;
}
