<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_ucp_request extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucuri = '';
public $sucmsg = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','ucp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $class = XF::sanitize_var(XF::ifset($input,'stage',''),'enum','o=report_posting');
  $data = XF::sanitize_var(XF::ifset($input,'data',''),'str');
  $this->gpc = array('class'=>$class,'data'=>$data);
  return true;
  }

  /**
  * execute a request sent by user (report a posting)
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
      switch ( $this->gpc['class'] ){
      case 'report_posting':
      $this->gpc['data'] = intval($this->gpc['data']);
      $sreq = XF::sql_query("SELECT COUNT(ur_hash) AS req_count FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING' AND ur_data_int = :postid",
      array('postid'=>array($this->gpc['data'],'int')),__METHOD__,__LINE__);
      $reqdata = $sreq->fetchObject();
      $sreq->closeCursor();
        if ( is_object($reqdata) && (int)$reqdata->req_count > 0 )
        $this->error = '{:posting_already_reported}';

        if ( empty($this->error) ){
          if ( !XF::sql_transaction('begin',array('user_request'=>'w')) )
          throw new XFE('unable to begin database transaction');
        $i = XF::sql_query("INSERT INTO ".XF::tbl('user_request')." (ur_class,ur_u_id,ur_time,ur_data_int) VALUES ('REPORT_POSTING',:userid,:time,:postid)",
        array('userid'=>array(XF::vault_query('current_user_id'),'int'),
        'time'=>array(XF::vault_query('uts'),'int'),
        'postid'=>array($this->gpc['data'],'int')),__METHOD__,__LINE__);
          if ( !$i )
          throw new XFE('cannot insert new user request for "REPORT_POSTING"');
        XF::logger('info','sub','REPORT_POSTING','postid',$this->gpc['data'],'option','+');
        XF::sql_transaction('commit');
        $reported = array(0);
        $sche = XF::sql_query("SELECT ur_data_int FROM ".XF::tbl('user_request')." WHERE ur_class = 'REPORT_POSTING'",'',__METHOD__,__LINE__);
          while ( $r = $sche->fetchObject() )
          $reported[] = intval($r->ur_data_int);
        $sche->closeCursor();
          if ( XF::$tpl->is_cached('mcp_request.tpl') )
          XF::$tpl->clear_cache('mcp_request.tpl');
        XF::tpl_use_cache_pool($this->gpc['data'],'begin');
          if ( XF::$tpl->is_cached('post.tpl',$this->gpc['data']) )
          XF::$tpl->clear_cache('post.tpl',$this->gpc['data']);
        XF::tpl_use_cache_pool(0,'reset');
        XFCache::put('simple','post_reported',$reported);
        $this->sucuri = XF::link('topic',array('post'=>$this->gpc['data']),false);
        $this->sucmsg = '{:posting_report_success}';
        $this->success = true;
        }
      break;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_ucp_request($input){
  $a = new XFAction_ucp_request();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success($a->sucuri,$a->sucmsg);
    else
    return xfaf_failure($a->get_error());
  }

?>