<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_ucp_blacklist extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucmsg = '';
public $sucid = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','ucp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * manage user blacklist
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $susr = XF::sql_query("SELECT COUNT(ub_u_id_dst) AS is_blacklisted FROM ".XF::tbl('user_blacklist')."
    WHERE ub_u_id_src = :myuid AND ub_u_id_dst = :hisuid",
    array('myuid'=>array(XF::vault_query('current_user_id'),'int'),
    'hisuid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $blacklistdata = $susr->fetchObject();
    $susr->closeCursor();

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user_blacklist'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $op = ( (int)$blacklistdata->is_blacklisted === 0 ) ? '+' : '-';

        if ( $op === '+' ){
        $i = XF::sql_query("INSERT INTO ".XF::tbl('user_blacklist')." (ub_u_id_src,ub_u_id_dst) VALUES (:myuid,:hisuid)",
        array('myuid'=>array(XF::vault_query('current_user_id'),'int'),
        'hisuid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          if ( !$i )
          throw new XFE('could not add blacklisting for userid "'.$this->gpc['id'].'"');
          if ( isset($_SESSION['xf_bookmark']) ){
            if ( !in_array($this->gpc['id'],$_SESSION['xf_blacklist'],true) )
            $_SESSION['xf_blacklist'][] = $this->gpc['id'];
          }
        }
        elseif ( $op === '-' ){
        $d = XF::sql_query("DELETE FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_src = :myuid AND ub_u_id_dst = :hisuid",
        array('myuid'=>array(XF::vault_query('current_user_id'),'int'),
        'hisuid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
          if ( !$d )
          throw new XFE('could not delete blacklisting for userid "'.$this->gpc['id'].'"');
          if ( isset($_SESSION['xf_blacklist']) ){
            foreach ( $_SESSION['xf_blacklist'] as $k=>$v ){
              if ( $this->gpc['id'] === $v )
              unset($_SESSION['xf_blacklist'][$k]);
            }
          }
        }

      XF::logger('info','userid',$this->gpc['id'],'option',$op);
      XF::sql_transaction('commit');
      $this->success = true;
      $this->sucmsg = ( $op === '+' ) ? '{:blacklist_has_been_added}' : '{:blacklist_has_been_removed}';
      $this->sucid = $op;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_ucp_blacklist($input){
  $a = new XFAction_ucp_blacklist();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success('',$a->sucmsg);
    else
    return xfaf_failure($a->get_error());
  }

?>