<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_member_list extends XFAction {
const USE_TAN = false;
/**
* @var integer how many users should be listed on a request? (default is 50)
*/
const LIMIT_MEMBER = 50;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $query = XF::sanitize_var(XF::ifset('get','query','*'),'str');
  $order = XF::sanitize_var(XF::ifset('get','order','name'),'enum','o=name,o=group,o=post_count,o=time_registration,o=rating');
  $sort = XF::sanitize_var(XF::ifset('get','sort','asc'),'enum','o=asc,o=desc');
  $this->gpc = array('query'=>$query,'order'=>$order,'sort'=>$sort);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'));
  unset($query,$sort,$order);

  $members = array();
  $groups = XF::get_group('*');
  $order_list = array('name'=>'username','group'=>'group','time_registration'=>'registration_date','rating_bonus'=>'rating','post_count'=>'post_count');
  $sort_list = array('asc'=>'ascending','desc'=>'descending');
    try {
      if ( !isset($order_list[$this->gpc['order']]) )
      throw new XFE('illegal order request');
      if ( !isset($sort_list[$this->gpc['sort']]) )
      throw new XFE('illegal sort request');
    } catch ( XFE $E ){ $E->handle(); }
  XF::sql_query('SELECT 1','-',__METHOD__,__LINE__);
  $like = ( __XF_SQL_ENGINE === 'pgsql' ) ? 'ILIKE' : 'LIKE';
  $qn = ( $this->gpc['query'] === '*' ) ? '' : 'AND u_name '.$like.' '.XF::$sql->quote(str_replace('*','%',$this->gpc['query']));
  $smem = XF::sql_query("SELECT u_id,u_name,u_group,u_time_registration,u_rating_bonus,u_post_count FROM ".XF::tbl('user')."
  WHERE u_active = true $qn AND u_id != :guest_uid
  ORDER BY u_".$this->gpc['order']." ".$this->gpc['sort']." LIMIT ".self::LIMIT_MEMBER." OFFSET 0",
  array('guest_uid'=>array(XF::get_cfg('main_guest_uid'),'int')),__METHOD__,__LINE__);
    while ( $r = $smem->fetchObject() ){
    $r->u_id = intval($r->u_id);
    $r->u_rating_bonus = intval($r->u_rating_bonus);
    $members[$r->u_id] = (array)$r;
    $members[$r->u_id]['__rating'] = '';
        if ( $r->u_rating_bonus !== 0 ){
        $img = ( $r->u_rating_bonus < 0 ) ? 'vote_negative' : 'vote_positive';
          for ( $a = 1 ; $a <= floor(abs($r->u_rating_bonus)/2) ; $a++ )
          $members[$r->u_id]['__rating'] .= '<img src="'.XFUI::image($img).'" alt="user rating: '.$r->u_rating_bonus.'" />';
        }
    $members[$r->u_id]['g_name'] = $groups[(int)$r->u_group]['g_name'];
    $members[$r->u_id]['g_color'] = $groups[(int)$r->u_group]['g_color'];
    }
  $smem->closeCursor();
  unset($qn);

  $ie = (int)$groups[XF::vault_query('current_group_id')]['g_executive'];
    if ( $ie === 1 ){
    XF::tan('acp_user_new');
    XFUI::ajax_init();
    }
  XFUI::html_head('{:member_list}');
  XF::$tpl->clear_cache('member_list.tpl');
  XF::$tpl->assign('input',$this->gpc);
  XF::$tpl->assign('member_listing',$members);
  XF::$tpl->assign('order_listing',$order_list);
  XF::$tpl->assign('sort_listing',$sort_list);
  XF::$tpl->assign('is_executive',$ie);
  XF::$tpl->display('member_list.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * list all members in database (directly done by run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>