<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_pp_delete extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('acp_overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * delete a post prefix
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $pp = XFUI::get_post_prefix_list();
      if ( !isset($pp[$this->gpc['id']]) ){
      $this->error = '{:no_valid_id}';
      return false;
      }
      else{
      $schk = XF::sql_query("SELECT COUNT(p_id) AS posts_have_this FROM ".XF::tbl('post_meta')." WHERE p_pp_id = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
      $post_data = $schk->fetchObject();
        if ( (int)$post_data->posts_have_this > 0 )
        $this->error = '{:prefix_is_not_empty}';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_prefix'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $d = XF::sql_query("DELETE FROM ".XF::tbl('post_prefix')." WHERE pp_id = :id",array(
      'id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        if ( !$d )
        throw new XFE('post prefix "'.$this->gpc['id'].'" could not be deleted');
      XF::logger('info','id',$this->gpc['id']);
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_pp_delete($input){
  $a = new XFAction_acp_pp_delete();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('acp_pp_list','',false),'{:delete_prefix_successful}');
    else
    return xfaf_failure($a->get_error());
  }

?>