<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_cfg_list extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','acpcfg');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $id = XF::sanitize_var(XF::ifset('get','id',''),'str','okifempty,length=0-16,restrict');
  $this->gpc = array('id'=>$id);
  unset($id);

  $hide = array('_','main_umask','main_uuid','main_version');
  $cfg = XF::get_cfg_data();
  $class = array('_'=>'config_seg_all');
  $data = array();
    foreach ( $cfg as $k=>$v ){
      if ( $k === '_' )
      continue;
    $seg = substr($k,0,strpos($k,'_'));
      if ( !isset($class[$seg]) )
      $class[$seg] = 'config_seg_'.$seg;
    }
  ksort($class);

    if ( $this->gpc['id'] !== '' && isset($class[$this->gpc['id']]) ){
    $scfg = XF::sql_query("SELECT * FROM ".XF::tbl('config')." WHERE c_id LIKE '".str_replace('_','%',$this->gpc['id'])."\_%' ORDER BY c_id",'',__METHOD__,__LINE__);
      while ( $r = $scfg->fetchObject() ){
        if ( in_array($r->c_id,$hide,true) || !isset($cfg[$r->c_id]) )
        continue;
      $b = array();

        if ( $cfg[$r->c_id][0] === 'enum' && isset($cfg[$r->c_id][1]) ){
        $cfg[$r->c_id][0] = 'enum_value';
        $a = explode(',',$cfg[$r->c_id][1]);
          foreach ( $a as $v )
          $b[] = str_replace('o=','',$v);
        sort($b);
        }
        elseif ( $cfg[$r->c_id][0] === 'lang' ){
        $cfg[$r->c_id][0] = 'enum_value';
        $b = explode(',',XF::vault_query('available_languages'));
        }
        elseif ( $cfg[$r->c_id][0] === 'style' ){
        $cfg[$r->c_id][0] = 'enum_value';
        $b = explode(',',XF::vault_query('available_styles'));
        }
        elseif ( $r->c_id === 'main_default_group' ){
        $cfg[$r->c_id][0] = 'enum_key';
        $g = XF::get_group('*');
        $b = array();
          foreach ( $g as $v )
          $b[$v['g_id']] = $v['g_name'];
        unset($g,$v);
        }

      $data[] = array('constraint'=>$cfg[$r->c_id][0],'key'=>$r->c_id,'value'=>$r->c_value,'explain'=>'cfg_explain_'.$r->c_id,'list'=>$b);
      }
    $scfg->closeCursor();
    XFUI::ajax_init();
    }

  XF::tan('cachemgr');
  XF::tan('acp_cfg_edit');
  XFUI::html_head('{:configuration}');
  XF::$tpl->clear_cache('form_acp_cfg.tpl');
  XF::$tpl->assign('link_to_cachemgr',XF::access_control('cachemgr'));
  XF::$tpl->assign('cachemgr_tan',(isset($_SESSION['xf_tan']['cachemgr']))?$_SESSION['xf_tan']['cachemgr']:'');
  XF::$tpl->assign('selected_action',$this->gpc['id']);
  XF::$tpl->assign('class_listing',$class);
  XF::$tpl->assign('cfg_aux','{:config_aux_'.$this->gpc['id'].'}');
  XF::$tpl->assign('cfg_data',$data);
  XF::$tpl->display('form_acp_cfg.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @since 1.0.0
  */
  protected function ajax($input){}

  /**
  * list configuration values (directly done in run())
  * @since 1.0.0
  */
  public function execute(){}

}
?>