CREATE TABLE {$PREFIX}acl (
  `a_id` int primary key auto_increment,
  `a_action` char(32) not null default '',
  `a_key` int not null default '0',
  `a_use_group` boolean not null default '1',
  `a_allow` boolean not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}config (
  `c_id` char(32) primary key,
  `c_value` char(255) not null default ''
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}config_task (
  `ct_command` char(16) primary key,
  `ct_parameter` char(255) not null default '',
  `ct_time_last` int not null default '0',
  `ct_time_interval` int not null default '0',
  `ct_active` boolean not null default '1'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}group (
  `g_id` int primary key auto_increment,
  `g_name` char(32) not null default '',
  `g_color` char(6) not null default '000000',
  `g_max_post_weight` smallint not null default '1',
  `g_post_approved` boolean not null default '1',
  `g_post_repeat` boolean not null default '0',
  `g_post_filter` boolean not null default '0',
  `g_read_unapproved` boolean not null default '0',
  `g_moderator` boolean not null default '0',
  `g_executive` boolean not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}log (
  `l_u_id` int not null default '0',
  `l_time` int not null default '0',
  `l_index_month` int not null default '0',
  `l_index_year` int not null default '0',
  `l_level` enum('system','info','error') not null default 'info',
  `l_action` char(32) not null default '',
  `l_ip` char(44) not null default '',
  `l_text` text not null default ''
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}post_data (
  `pd_id` int primary key auto_increment,
  `pd_p_id` int not null default '0',
  `pd_time` int not null default '0',
  `pd_spam_marker` int not null default '0',
  `pd_edit_u_id` int not null default '0',
  `pd_edit_reason` char(128) not null default '',
  `pd_is_last` boolean not null default '1',
  `pd_text` mediumtext not null
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}post_meta (
  `p_id` int primary key auto_increment,
  `p_is_topic` boolean not null default '1',
  `p_topic_id` int not null default '0',
  `p_parent_id` int not null default '0',
  `p_pd_id` int not null default '0',
  `p_u_id` int not null default '0',
  `p_pp_id` int not null default '0',
  `p_time` int not null default '0',
  `p_flags` smallint not null default '0',
  `p_weight` smallint not null default '0',
  `p_rating` smallint not null default '0',
  `p_approved` boolean not null default '1',
  `p_closed` boolean not null default '0',
  `p_license` char(6) not null default 'none',
  `p_subject` char(128) not null default '',
  `p_acl` char(255) not null default ''
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}post_prefix (
  `pp_id` int primary key auto_increment,
  `pp_name` char(64) not null default '',
  `pp_preset_acl` char(255) not null default '',
  `pp_list_as_request` boolean not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}post_rating (
  `pr_p_id` int not null default '0',
  `pr_u_id` int not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}search_result (
  `sr_hash` int not null default '0',
  `sr_time` int not null default '0',
  `sr_p_id` int not null default '0'
) TYPE=MEMORY CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}statistic (
  `st_day` smallint not null,
  `st_month` smallint not null,
  `st_year` smallint not null,
  `st_login_attempt` int not null default '0',
  `st_login_success` int not null default '0',
  `st_account_register` int not null default '0',
  `st_account_activation` int not null default '0',
  `st_password_request` int not null default '0',
  `st_password_activation` int not null default '0',
  `st_search_query` int not null default '0',
  `st_search_cached` int not null default '0',
  `st_filter_spam` int not null default '0',
  `st_filter_ham` int not null default '0',
  `st_submit_posting` int not null default '0',
  `st_exception` int not null default '0',
  primary key  (`st_day`,`st_month`,`st_year`)
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}tag_data (
  `td_t_id` int not null default '0',
  `td_p_id` int not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}tag_meta (
  `t_id` int primary key auto_increment,
  `t_name` char(64) not null default ''
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}user (
  `u_id` int primary key auto_increment,
  `u_active` boolean not null default '1',
  `u_uuid` char(36) not null default '',
  `u_name` char(32) not null default '',
  `u_password` char(80) not null default '',
  `u_mail` char(255) not null default '',
  `u_info` char(255) not null default '',
  `u_comment` char(255) not null default '',
  `u_warning_level` enum('none','low','medium','high') not null default 'none',
  `u_group` int not null default '1',
  `u_time_registration` int not null default '0',
  `u_time_last_read` int not null default '0',
  `u_rating_bonus` int not null default '0',
  `u_post_count` int not null default '0',
  `u_post_approved` enum('default','true','false') not null default 'default',
  `u_post_license` char(6) not null default 'none',
  `u_style` char(16) not null default '',
  `u_language` char(10) not null default '',
  `u_timezone` char(64) not null default '',
  `u_time24h` boolean not null default '1',
  `u_auto_bookmark` boolean not null default '0',
  `u_login_annoy` boolean not null default '0',
  `u_login_liberal` boolean not null default '0',
  `u_login_token` int not null default '0',
  `u_login_fail` smallint not null default '0',
  `u_login_count` smallint not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}user_blacklist (
  `ub_u_id_src` int not null default '0',
  `ub_u_id_dst` int not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}user_bookmark (
  `uk_u_id` int not null default '0',
  `uk_p_id` int not null default '0'
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/

CREATE TABLE {$PREFIX}user_request (
  `ur_class` enum('ACTIVATE_ACCOUNT','ACTIVATE_PASSWORD','REPORT_POSTING') not null default 'REPORT_POSTING',
  `ur_u_id` int not null default '0',
  `ur_time` int not null default '0',
  `ur_data_int` int not null default '0',
  `ur_data` char(255) not null default '',
  `ur_hash` char(16) not null default ''
) TYPE=MyISAM CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';/*###*/
