#!/usr/bin/env python
# -*- coding: iso-8859-1

# Copyright (C) 2005 Andre Kloss
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__title__="shuffle Last Played"
__version__="0.1"
__author__="Andre Kloss"
__email__="andre.kloss@gmx.net"

# some constants
headerSize = 18
songSize = 558
titleAddress = 33
titleLength = 522
shufflePosAddress = 3
base = "iPod_Control/iTunes/" # assuming you run from shuffle root

def int24(s):
	"""read a 24-bit(=3 char) string, return the integer value"""
	return ord(s[0]) + (ord(s[1])<<8) + (ord(s[2])<<16)

def string16(s):
	"""read the title strings (does not handle unicode yet)"""
	return "".join([x for x in s[0::2] if x != '\0'])

def getSong(iTunesSD, iTunesShuffle, shufflePos):
	"""for a position in the shuffle sequence, return the filename"""
	iTunesShuffle.seek(shufflePos * 3)
	trackNo = int24(iTunesShuffle.read(3))
	iTunesSD.seek(headerSize + (trackNo * songSize) + titleAddress)
	return string16(iTunesSD.read(titleLength))

def lastNplayed(n):
	"""return a string with newline-separated filenames of the n songs last played"""
	pState = file(base+"iTunesPState", "r")
	pState.seek(shufflePosAddress)
	sPos = int24(pState.read(3))
	pState.close()
	
	sd = file(base+"iTunesSD", "r")
	shuffle = file(base+"iTunesShuffle", "r")
	result = [getSong(sd, shuffle, no) for no in xrange(max(sPos-n, 0), sPos + 1)]
	result.reverse()
	shuffle.close()
	sd.close()
	
	return "\n".join(result)

if __name__ == '__main__':
	import sys
	try: n = int(sys.argv[1])
	except: n = 5
	print lastNplayed(n)
