/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

#include <stdio.h>

#include "Matrix.h"

void solve_matrix_cg(REAL *bo_ptr, int hdim, REAL cgtol2) {
  int iter, breakloop;
  REAL error2;
  Matrix bo, x2, a, tmpmat, r0, p0;
  M_InitWithLocal(bo, bo_ptr, hdim, hdim);
  M_Init(x2, hdim, hdim);
  M_Init(a, hdim, hdim);
  M_Init(tmpmat, hdim, hdim);
  M_Init(r0, hdim, hdim);
  M_Init(p0, hdim, hdim);
 
  M_Push(bo);
  M_Multiply(bo, bo, x2);
  M_Subtract(x2, bo, tmpmat);
  M_Multiply(2.0, tmpmat, a);
  M_AddIdentity(a);
  
  M_Multiply(a, bo, tmpmat);
  M_Subtract(tmpmat, x2, r0);
  M_Multiply(-1.0, r0, p0);

  iter = 0;
  breakloop = 0;
  while (breakloop == 0) {
    iter = iter + 1;
printf("Starting mult\n");
    M_Multiply(a, p0, tmpmat);
printf("Done mult\n");

printf("Starting CGIterate\n");
    error2=M_CGIterate(bo, p0, tmpmat, r0);
printf("Done CGIterate\n");
    if (error2 < cgtol2) {
      breakloop = 1;
    }
  }

  M_Pull(bo);

  M_DeallocateDevice(bo);
  M_DeallocateLocal(x2);
  M_DeallocateDevice(x2);
  M_DeallocateLocal(a);
  M_DeallocateDevice(a);
  M_DeallocateLocal(tmpmat);
  M_DeallocateDevice(tmpmat);
  M_DeallocateLocal(p0);
  M_DeallocateDevice(p0);
  M_DeallocateLocal(r0);
  M_DeallocateDevice(r0);
}

