!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE COULOMBARRAY

  USE MYPRECISION

  IMPLICIT NONE
  SAVE

  REAL(LATTEPREC) :: COULCUT ! Input - cutoff for the real space part
  REAL(LATTEPREC) :: COULACC ! Input - accuracy for the k-space part
  REAL(LATTEPREC) :: COULR1 ! Start of the cut off tail for real space
  REAL(LATTEPREC) :: LATTICEVECS(3,3), RECIPVECS(3,3)
  REAL(LATTEPREC) :: COULCUT2, KCUTOFF, KCUTOFF2
  REAL(LATTEPREC) :: CALPHA, CALPHA2, COULVOL 
  REAL(LATTEPREC) :: COULB(6)
  REAL(LATTEPREC), PARAMETER :: PI = 3.14159265358979323846264D0 
  REAL(LATTEPREC) :: TWOPI, PI2, SQRTPI
  REAL(LATTEPREC), PARAMETER :: KECONST = 14.3996437701414D0
  REAL(LATTEPREC), PARAMETER :: TFACT = 16.0D0/(5.0D0 * KECONST)
  REAL(LATTEPREC), ALLOCATABLE :: OLDDELTAQS(:), QLIST(:)
  
END MODULE COULOMBARRAY
