!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GETHDIM

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY

  IMPLICIT NONE

  INTEGER :: I, J

  HDIM = 0
  DELTADIM = 0

  DO I = 1, NATS
     DO J = 1, NOELEM

        IF (ATELE(I) .EQ. ELE(J)) THEN
           IF (BASIS(J) .EQ. "sp") THEN
              HDIM = HDIM + 4
           ELSEIF (BASIS(J) .EQ. "ss") THEN
              HDIM = HDIM + 1
           ENDIF
        ENDIF

     ENDDO
  ENDDO

  ! Allocate the Hamiltonian

  ALLOCATE(H(HDIM,HDIM))

  H = ZERO

  IF (SPINON .EQ. 0) THEN
     
     ! No spins: allocate 1 double-occupied bond order matrix

     ALLOCATE(BO(HDIM,HDIM))

     BO = ZERO

  ELSEIF (SPINON .EQ. 1) THEN

     ! We're going to have two Hamiltonians because I can't
     ! figure out a more elegant way to do it just yet...


     ! With spins, we need spin-up and spin-down density matrices

     ALLOCATE(HUP(HDIM, HDIM), HDOWN(HDIM, HDIM))
     ALLOCATE(RHOUP(HDIM, HDIM), RHODOWN(HDIM, HDIM))
     
     HUP = ZERO
     HDOWN = ZERO
     RHOUP = ZERO
     RHODOWN = ZERO

     ! And our spin-dependent H_(2) matrix

     DO I = 1, NATS
        DO J = 1, NOELEM

           IF (ATELE(I) .EQ. ELE(J)) THEN

              IF (BASIS(J) .EQ. "ss") THEN

                 DELTADIM = DELTADIM + 1

              ELSEIF (BASIS(J) .EQ. "sp") THEN

                 DELTADIM = DELTADIM + 2

              ENDIF
              
           ENDIF

        ENDDO
     ENDDO

     ALLOCATE(DELTASPIN(DELTADIM), OLDDELTASPIN(DELTADIM))

     DELTASPIN = ZERO
     OLDDELTASPIN = ZERO

  ENDIF

  RETURN

END SUBROUTINE GETHDIM
