!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GRADH

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE GSPARRAY
  USE NEBLISTARRAY
  USE SPINARRAY
  USE VIRIALARRAY
  USE MYPRECISION
  
  IMPLICIT NONE

  INTEGER :: I, J, K, KK, INDI, INDJ
  INTEGER :: NEWJ
  INTEGER :: PBCI, PBCJ, PBCK
  REAL(LATTEPREC) :: HSPS, HPSS, HPPS, HPPP
  REAL(LATTEPREC) :: RIJ(3), DC(3), SCLGSP, DGSPDR(3)
  REAL(LATTEPREC) :: L, M, N, L2, M2, N2, LM, LN, MN, LMN
  REAL(LATTEPREC) :: DSSSDR(3), DSPSDR(3), DPSSDR(3), DPPSDR(3), DPPPDR(3)
  REAL(LATTEPREC) :: MAGR, INVR, FTMP(3)
  REAL(LATTEPREC) :: PPSMPPP, PPSUBINVR
  CHARACTER(LEN=2) :: BASISI, BASISJ

  INDI = 0

  F = ZERO

  VIRBOND = ZERO

  DO I = 1, NATS

     DO K = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(K)) THEN
           BASISI = BASIS(K)
        ENDIF
     ENDDO

     DO NEWJ = 1, TOTNEBTB(I)
        
        J = NEBTB(I, NEWJ, 1)
        PBCI = NEBTB(I, NEWJ, 2)
        PBCJ = NEBTB(I, NEWJ, 3)
        PBCK = NEBTB(I, NEWJ, 4)        
        
        INDJ = 0
        DO K = 1, J-1
           DO KK = 1, NOELEM
              IF (ATELE(K) .EQ. ELE(KK)) THEN
                 IF (BASIS(KK) .EQ. "sp") THEN
                    INDJ = INDJ + 4
                 ELSEIF (BASIS(KK) .EQ. "ss") THEN
                    INDJ = INDJ + 1
                 ENDIF
              ENDIF
           ENDDO
        ENDDO
        
        DO K = 1, NOELEM
           IF (ATELE(J) .EQ. ELE(K)) THEN
              BASISJ = BASIS(K)
           ENDIF
        ENDDO

        RIJ(1) = CR(1,J) + FLOAT(PBCI)*(BOX(2,1)-BOX(1,1)) - CR(1,I)
        RIJ(2) = CR(2,J) + FLOAT(PBCJ)*(BOX(2,2)-BOX(1,2)) - CR(2,I)
        RIJ(3) = CR(3,J) + FLOAT(PBCK)*(BOX(2,3)-BOX(1,3)) - CR(3,I)  
         
        MAGR = SQRT(RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3))
        
        INVR = ONE/MAGR
        
        FTMP = ZERO
           
        ! 
        ! Direction cosines (DC)
        !
           
        DO K = 1, 3
           DC(K) = RIJ(K)/MAGR
        ENDDO
        
        L = DC(1)
        M = DC(2)
        N = DC(3)
           
        !
        ! We'll need the GSP and gradient of the GSP
        !
           
        IF (BASISI .EQ. "ss") THEN
           
           IF (BASISJ .EQ. "ss") THEN
              
              DO K = 1, NOINT
                 IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                      ATELE(J) .EQ. ELE2(K)) .OR. &
                      (ATELE(I) .EQ. ELE2(K) .AND. &
                      ATELE(J) .EQ. ELE1(K))) THEN
                    
                    IF (BTYPE(K) .EQ. "sss") THEN
                       
                       CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                       
                       DO KK = 1, 3
                          DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                       ENDDO
                       
                    ENDIF
                    
                 ENDIF
              ENDDO
              
              IF (SPINON .EQ. 0) THEN
                 
                 DO K = 1, 3                    
                    FTMP(K) = FTMP(K) - BO(INDI+1, INDJ+1)* &
                         DSSSDR(K)
                 ENDDO
                 
              ELSE
                 
                 DO K = 1, 3                    
                    FTMP(K) = FTMP(K) - DSSSDR(K) * &
                         (RHOUP(INDI+1, INDJ+1) + &
                         RHODOWN(INDI+1, INDJ+1))
                 ENDDO
                 
              ENDIF
              
           ELSEIF (BASISJ .EQ. "sp") THEN
              
              DO K = 1, NOINT
                 
                 IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                      ATELE(J) .EQ. ELE2(K)) .OR. &
                      (ATELE(I) .EQ. ELE2(K) .AND. &
                      ATELE(J) .EQ. ELE1(K))) THEN
                    
                    IF (BTYPE(K) .EQ. "sss") THEN
                       
                       CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                       DO KK = 1, 3
                          DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                       ENDDO
                       
                    ELSEIF (BTYPE(K) .EQ. "sps") THEN
                       
                       CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                       DO KK = 1, 3
                          DSPSDR(KK) = HR0(K)*DGSPDR(KK)
                       ENDDO
                       
                       HSPS = HR0(K)*SCLGSP
                       
                    ENDIF
                 ENDIF
              ENDDO
              
              L2 = L*L
              M2 = M*M
              N2 = N*N
              LM = L*M
              LN = L*N
              MN = M*N
              
              IF (SPINON .EQ. 0) THEN
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3
                    FTMP(K) = FTMP(K) - BO(INDI+1, INDJ+1)* &
                         DSSSDR(K)
                 ENDDO
                 
                 ! E_s1,x2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(1) + (L2 - ONE)*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(2) + LM*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(3) + LN*INVR*HSPS)
                 
                 ! E_s1,y2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(1) + LM*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(2) + (M2 - ONE)*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(3) + MN*INVR*HSPS)
                 
                 ! E_s1,z2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(1) + LN*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(2) + MN*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(3) + (N2 - ONE)*INVR*HSPS)
                 
              ELSE
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3
                    FTMP(K) = FTMP(K) - DSSSDR(K) * &
                         (RHOUP(INDI+1, INDJ+1) + &
                         RHODOWN(INDI+1, INDJ+1))
                 ENDDO
                 
                 
                 ! E_s1,x2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(1) + (L2 - ONE)*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(2) + LM*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(3) + LN*INVR*HSPS)
                 
                 ! E_s1,y2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(1) + LM*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(2) + (M2 - ONE)*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(3) + MN*INVR*HSPS)
                 
                 ! E_s1,z2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(1) + LN*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(2) + MN*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(3) + (N2 - ONE)*INVR*HSPS)
                 
              ENDIF
              
           ENDIF
           
        ELSEIF (BASISI .EQ. "sp") THEN
           
           IF (BASISJ .EQ. "ss") THEN
              
              DO K = 1, NOINT
                 
                 IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                      ATELE(J) .EQ. ELE2(K)) .OR. &
                      (ATELE(I) .EQ. ELE2(K) .AND. &
                      ATELE(J) .EQ. ELE1(K))) THEN
                    
                    IF (BTYPE(K) .EQ. "sss") THEN
                       
                       CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                       DO KK = 1, 3
                          DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                       ENDDO
                       
                    ELSEIF (BTYPE(K) .EQ. "sps") THEN
                       
                       CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                       DO KK = 1, 3
                          DPSSDR(KK) = MINUSONE*HR0(K)*DGSPDR(KK)
                       ENDDO
                       
                       HPSS = MINUSONE * HR0(K)*SCLGSP
                       
                    ENDIF
                 ENDIF
              ENDDO
              
              L2 = L*L
              M2 = M*M
              N2 = N*N
              LM = L*M
              LN = L*N
              MN = M*N
              
              IF (SPINON .EQ. 0) THEN
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3
                    FTMP(K) = FTMP(K) - BO(INDI+1, INDJ+1)* &
                         DSSSDR(K)
                 ENDDO
                 
                 ! E_x1,s2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(1) + (L2 - ONE)*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(2) + LM*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(3) + LN*INVR*HPSS)
                 
                 ! E_y1,s2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(1) + LM*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(2) + (M2 - ONE)*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(3) + MN*INVR*HPSS)
                 
                 ! E_z1,s2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(1) + LN*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(2) + MN*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(3) + (N2 - ONE)*INVR*HPSS)
                 
              ELSE
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3
                    FTMP(K) = FTMP(K) - (RHOUP(INDI+1, INDJ+1) + &
                         RHODOWN(INDI+1, INDJ+1)) * DSSSDR(K)
                 ENDDO
                 
                 ! E_x1,s2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1)) * &
                      (L*DPSSDR(1) + (L2 - ONE)*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1)) * &
                      (L*DPSSDR(2) + LM*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1)) * &
                      (L*DPSSDR(3) + LN*INVR*HPSS)
                 
                 ! E_y1,s2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(1) + LM*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(2) + (M2 - ONE)*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(3) + MN*INVR*HPSS)
                 
                 ! E_z1,s2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(1) + LN*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(2) + MN*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(3) + (N2 - ONE)*INVR*HPSS)
                 
              ENDIF
              
           ELSEIF (BASISJ .EQ. "sp") THEN
              
              IF (ATELE(I) .EQ. ATELE(J)) THEN
                 
                 DO K = 1, NOINT
                    
                    IF (ATELE(I) .EQ. ELE1(K) .AND. &
                         ATELE(J) .EQ. ELE2(K)) THEN
                       
                       IF (BTYPE(K) .EQ. "sss") THEN  
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                       ELSEIF (BTYPE(K) .EQ. "sps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          
                          DO KK = 1, 3
                             DSPSDR(KK) = HR0(K)*DGSPDR(KK)
                             DPSSDR(KK) = MINUSONE*DSPSDR(KK)
                          ENDDO
                          
                          HSPS = HR0(K)*SCLGSP
                          HPSS = MINUSONE * HSPS
                          
                       ELSEIF (BTYPE(K) .EQ. "pps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPS = HR0(K)*SCLGSP
                          
                       ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPPDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPP = HR0(K)*SCLGSP
                          
                       ENDIF
                    ENDIF
                 ENDDO
                 
              ELSEIF (ATELE(I) .NE. ATELE(J)) THEN
                 
                 DO K = 1, NOINT
                    
                    IF (ATELE(I) .EQ. ELE1(K) .AND. &
                         ATELE(J) .EQ. ELE2(K)) THEN
                       
                       IF (BTYPE(K) .EQ. "sss") THEN                 
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                       ELSEIF (BTYPE(K) .EQ. "sps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          
                          DO KK = 1, 3
                             DSPSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HSPS = HR0(K)*SCLGSP
                          
                       ELSEIF (BTYPE(K) .EQ. "pps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPS = HR0(K)*SCLGSP
                          
                       ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPPDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPP = HR0(K)*SCLGSP
                          
                       ENDIF
                       
                    ELSEIF (ATELE(I) .EQ. ELE2(K) .AND. &
                         ATELE(J) .EQ. ELE1(K)) THEN
                       
                       IF (BTYPE(K) .EQ. "sss") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DSSSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                       ELSEIF (BTYPE(K) .EQ. "sps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          
                          DO KK = 1, 3
                             DPSSDR(KK) = MINUSONE*HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPSS = MINUSONE*HR0(K)*SCLGSP 
                          
                       ELSEIF (BTYPE(K) .EQ. "pps") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPSDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPS = HR0(K)*SCLGSP                             
                          
                       ELSEIF (BTYPE(K) .EQ. "ppp") THEN
                          
                          CALL DGSP(MAGR, K, DC, DGSPDR, SCLGSP)
                          DO KK = 1, 3
                             DPPPDR(KK) = HR0(K)*DGSPDR(KK)
                          ENDDO
                          
                          HPPP = HR0(K)*SCLGSP
                          
                       ENDIF
                       
                    ENDIF
                 ENDDO
                 
              ENDIF
              
              PPSMPPP = HPPS - HPPP
              PPSUBINVR = PPSMPPP * INVR
              
              L2 = L*L
              M2 = M*M
              N2 = N*N
              LM = L*M
              LN = L*N
              MN = M*N
              LMN = LM*N
              
              IF (SPINON .EQ. 0) THEN
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3                    
                    FTMP(K) = FTMP(K) - BO(INDI+1, INDJ+1)* &
                         DSSSDR(K)
                 ENDDO
                 
                 ! E_s1,x2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(1) + (L2 - ONE)*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(2) + LM*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+2) * &
                      (L*DSPSDR(3) + LN*INVR*HSPS)
                 
                 ! E_s1,y2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(1) + LM*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(2) + (M2 - ONE)*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+3) * &
                      (M*DSPSDR(3) + MN*INVR*HSPS)
                 
                 ! E_s1,z2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(1) + LN*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(2) + MN*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+1, INDJ+4) * &
                      (N*DSPSDR(3) + (N2 - ONE)*INVR*HSPS)
                 
                 ! E_x1,s2       
                 
                 FTMP(1) = FTMP(1) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(1) + (L2 - ONE)*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(2) + LM*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+2, INDJ+1) * &
                      (L*DPSSDR(3) + LN*INVR*HPSS)
                 
                 ! E_x1,x2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+2, INDJ+2) * &
                      (L2*DPPSDR(1) + (ONE - L2)*DPPPDR(1) + &
                      TWO*L*(L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+2, INDJ+2) * &
                      (L2*DPPSDR(2) + (ONE - L2)*DPPPDR(2) + &
                      TWO*L2*M*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+2, INDJ+2) * &
                      (L2*DPPSDR(3) + (ONE - L2)*DPPPDR(3) + &
                      TWO*L2*N*PPSUBINVR)
                 
                 ! E_x1,y2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+2, INDJ+3) * &
                      (LM*(DPPSDR(1) - DPPPDR(1)) + &
                      M*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+2, INDJ+3) * &
                      (LM*(DPPSDR(2) - DPPPDR(2)) + &
                      L*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+2, INDJ+3) * &
                      (LM*(DPPSDR(3) - DPPPDR(3)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 ! E_x1,z2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+2, INDJ+4) * &
                      (LN*(DPPSDR(1) - DPPPDR(1)) + &
                      N*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+2, INDJ+4) * &
                      (LN*(DPPSDR(2) - DPPPDR(2)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+2, INDJ+4) * &
                      (LN*(DPPSDR(3) - DPPPDR(3)) + &
                      L*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_y1,s2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(1) + LM*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(2) + (M2 - ONE)*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+3, INDJ+1) * &
                      (M*DPSSDR(3) + MN*INVR*HPSS)
                 
                 ! E_y1,x2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+3, INDJ+2) * &
                      (LM*(DPPSDR(1) - DPPPDR(1)) + &
                      M*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+3, INDJ+2) * &
                      (LM*(DPPSDR(2) - DPPPDR(2)) + &
                      L*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+3, INDJ+2) * &
                      (LM*(DPPSDR(3) - DPPPDR(3)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 ! E_y1,y2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+3, INDJ+3) * &
                      (M2*DPPSDR(1) + (ONE - M2)*DPPPDR(1) + &
                      TWO*L*M2*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+3, INDJ+3) * &
                      (M2*DPPSDR(2) + (ONE - M2)*DPPPDR(2) + &
                      TWO*M*(M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+3, INDJ+3) * &
                      (M2*DPPSDR(3) + (ONE - M2)*DPPPDR(3) + &
                      TWO*N*M2*PPSUBINVR)
                 
                 ! E_y1,z2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+3, INDJ+4) * &
                      (MN*(DPPSDR(1) - DPPPDR(1)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+3, INDJ+4) * &
                      (MN*(DPPSDR(2) - DPPPDR(2)) + &
                      N*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+3, INDJ+4) * &
                      (MN*(DPPSDR(3) - DPPPDR(3)) + &
                      M*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,s2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(1) + LN*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(2) + MN*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+4, INDJ+1) * &
                      (N*DPSSDR(3) + (N2 - ONE)*INVR*HPSS)
                 
                 ! E_z1,x2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+4, INDJ+2) * &
                      (LN*(DPPSDR(1) - DPPPDR(1)) + &
                      N*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+4, INDJ+2) * &
                      (LN*(DPPSDR(2) - DPPPDR(2)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+4, INDJ+2) * &
                      (LN*(DPPSDR(3) - DPPPDR(3)) + &
                      L*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,y2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+4, INDJ+3) * &
                      (MN*(DPPSDR(1) - DPPPDR(1)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+4, INDJ+3)* &
                      (MN*(DPPSDR(2) - DPPPDR(2)) + &
                      N*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+4, INDJ+3) * &
                      (MN*(DPPSDR(3) - DPPPDR(3)) + &
                      M*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,z2
                 
                 FTMP(1) = FTMP(1) - BO(INDI+4, INDJ+4) * &
                      (N2*DPPSDR(1) + (ONE - N2)*DPPPDR(1) + &
                      TWO*L*N2*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - BO(INDI+4, INDJ+4) * &
                      (N2*DPPSDR(2) + (ONE - N2)*DPPPDR(2) + &
                      TWO*M*N2*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - BO(INDI+4, INDJ+4) * &
                      (N2*DPPSDR(3) + (ONE - N2)*DPPPDR(3) + &
                      TWO*N*(N2 - ONE)*PPSUBINVR)
                 
              ELSE
                 
                 ! E_s1,s2
                 
                 DO K = 1, 3                    
                    FTMP(K) = FTMP(K) - (RHOUP(INDI+1, INDJ+1) + &
                         RHODOWN(INDI+1, INDJ+1)) * DSSSDR(K)
                 ENDDO
                 
                 ! E_s1,x2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(1) + (L2 - ONE)*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(2) + LM*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+2) + &
                      RHODOWN(INDI+1, INDJ+2)) * &
                      (L*DSPSDR(3) + LN*INVR*HSPS)
                 
                 ! E_s1,y2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(1) + LM*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(2) + (M2 - ONE)*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+3) + &
                      RHODOWN(INDI+1, INDJ+3)) * &
                      (M*DSPSDR(3) + MN*INVR*HSPS)
                 
                 ! E_s1,z2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(1) + LN*INVR*HSPS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(2) + MN*INVR*HSPS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+1, INDJ+4) + &
                      RHODOWN(INDI+1, INDJ+4)) * &
                      (N*DSPSDR(3) + (N2 - ONE)*INVR*HSPS)
                 
                 ! E_x1,s2  
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1)) * &
                      (L*DPSSDR(1) + (L2 - ONE)*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1)) * &
                      (L*DPSSDR(2) + LM*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) -  (RHOUP(INDI+2, INDJ+1) + &
                      RHODOWN(INDI+2, INDJ+1))* &
                      (L*DPSSDR(3) + LN*INVR*HPSS)
                 
                 ! E_x1,x2
                 
                 FTMP(1) = FTMP(1) -  (RHOUP(INDI+2, INDJ+2) + &
                      RHODOWN(INDI+2, INDJ+2)) * &
                      (L2*DPPSDR(1) + (ONE - L2)*DPPPDR(1) + &
                      TWO*L*(L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+2, INDJ+2) + &
                      RHODOWN(INDI+2, INDJ+2)) * &
                      (L2*DPPSDR(2) + (ONE - L2)*DPPPDR(2) + &
                      TWO*L2*M*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+2, INDJ+2) + &
                      RHODOWN(INDI+2, INDJ+2)) * &
                      (L2*DPPSDR(3) + (ONE - L2)*DPPPDR(3) + &
                      TWO*L2*N*PPSUBINVR)
                 
                 ! E_x1,y2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+2, INDJ+3) + &
                      RHODOWN(INDI+2, INDJ+3)) * &
                      (LM*(DPPSDR(1) - DPPPDR(1)) + &
                      M*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+2, INDJ+3) + &
                      RHODOWN(INDI+2, INDJ+3)) * &
                      (LM*(DPPSDR(2) - DPPPDR(2)) + &
                      L*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+2, INDJ+3) + &
                      RHODOWN(INDI+2, INDJ+3)) * &
                      (LM*(DPPSDR(3) - DPPPDR(3)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 ! E_x1,z2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+2, INDJ+4) + &
                      RHODOWN(INDI+2, INDJ+4)) * &
                      (LN*(DPPSDR(1) - DPPPDR(1)) + &
                      N*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+2, INDJ+4) + &
                      RHODOWN(INDI+2, INDJ+4))* &
                      (LN*(DPPSDR(2) - DPPPDR(2)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+2, INDJ+4) + &
                      RHODOWN(INDI+2, INDJ+4)) * &
                      (LN*(DPPSDR(3) - DPPPDR(3)) + &
                      L*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_y1,s2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(1) + LM*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(2) + (M2 - ONE)*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+3, INDJ+1) + &
                      RHODOWN(INDI+3, INDJ+1)) * &
                      (M*DPSSDR(3) + MN*INVR*HPSS)
                 
                 ! E_y1,x2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+3, INDJ+2) + &
                      RHODOWN(INDI+3, INDJ+2)) * &
                      (LM*(DPPSDR(1) - DPPPDR(1)) + &
                      M*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+3, INDJ+2) + &
                      RHODOWN(INDI+3, INDJ+2)) * &
                      (LM*(DPPSDR(2) - DPPPDR(2)) + &
                      L*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+3, INDJ+2) + &
                      RHODOWN(INDI+3, INDJ+2)) * &
                      (LM*(DPPSDR(3) - DPPPDR(3)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 ! E_y1,y2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+3, INDJ+3) + &
                      RHODOWN(INDI+3, INDJ+3)) * &
                      (M2*DPPSDR(1) + (ONE - M2)*DPPPDR(1) + &
                      TWO*L*M2*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+3, INDJ+3) + &
                      RHODOWN(INDI+3, INDJ+3)) * &
                      (M2*DPPSDR(2) + (ONE - M2)*DPPPDR(2) + &
                      TWO*M*(M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+3, INDJ+3) + &
                      RHODOWN(INDI+3, INDJ+3)) * &
                      (M2*DPPSDR(3) + (ONE - M2)*DPPPDR(3) + &
                      TWO*N*M2*PPSUBINVR)
                 
                 ! E_y1,z2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+3, INDJ+4) + &
                      RHODOWN(INDI+3, INDJ+4)) * &
                      (MN*(DPPSDR(1) - DPPPDR(1)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+3, INDJ+4) + &
                      RHODOWN(INDI+3, INDJ+4)) * &
                      (MN*(DPPSDR(2) - DPPPDR(2)) + &
                      N*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) -  (RHOUP(INDI+3, INDJ+4) + &
                      RHODOWN(INDI+3, INDJ+4))* &
                      (MN*(DPPSDR(3) - DPPPDR(3)) + &
                      M*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,s2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(1) + LN*INVR*HPSS)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(2) + MN*INVR*HPSS)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+4, INDJ+1) + &
                      RHODOWN(INDI+4, INDJ+1)) * &
                      (N*DPSSDR(3) + (N2 - ONE)*INVR*HPSS)
                 
                 ! E_z1,x2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+4, INDJ+2) + &
                      RHODOWN(INDI+4, INDJ+2)) * &
                      (LN*(DPPSDR(1) - DPPPDR(1)) + &
                      N*(TWO*L2 - ONE)*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+4, INDJ+2) + &
                      RHODOWN(INDI+4, INDJ+2)) * &
                      (LN*(DPPSDR(2) - DPPPDR(2)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+4, INDJ+2) + &
                      RHODOWN(INDI+4, INDJ+2)) * &
                      (LN*(DPPSDR(3) - DPPPDR(3)) + &
                      L*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,y2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+4, INDJ+3) + &
                      RHODOWN(INDI+4, INDJ+3)) * &
                      (MN*(DPPSDR(1) - DPPPDR(1)) + &
                      TWO*LMN*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+4, INDJ+3) + &
                      RHODOWN(INDI+4, INDJ+3)) * &
                      (MN*(DPPSDR(2) - DPPPDR(2)) + &
                      N*(TWO*M2 - ONE)*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+4, INDJ+3) + &
                      RHODOWN(INDI+4, INDJ+3)) * &
                      (MN*(DPPSDR(3) - DPPPDR(3)) + &
                      M*(TWO*N2 - ONE)*PPSUBINVR)
                 
                 ! E_z1,z2
                 
                 FTMP(1) = FTMP(1) - (RHOUP(INDI+4, INDJ+4) + &
                      RHODOWN(INDI+4, INDJ+4)) * &
                      (N2*DPPSDR(1) + (ONE - N2)*DPPPDR(1) + &
                      TWO*L*N2*PPSUBINVR)
                 
                 FTMP(2) = FTMP(2) - (RHOUP(INDI+4, INDJ+4) + &
                      RHODOWN(INDI+4, INDJ+4)) * &
                      (N2*DPPSDR(2) + (ONE - N2)*DPPPDR(2) + &
                      TWO*M*N2*PPSUBINVR)
                 
                 FTMP(3) = FTMP(3) - (RHOUP(INDI+4, INDJ+4) + &
                      RHODOWN(INDI+4, INDJ+4)) * &
                      (N2*DPPSDR(3) + (ONE - N2)*DPPPDR(3) + &
                      TWO*N*(N2 - ONE)*PPSUBINVR)
                 
              ENDIF
              
           ENDIF
           
        ENDIF
        
        DO K = 1, 3
           F(K,I) = F(K,I) + FTMP(K)
        ENDDO
        
        VIRBOND(1) = VIRBOND(1) + RIJ(1)*FTMP(1)
        VIRBOND(2) = VIRBOND(2) + RIJ(2)*FTMP(2)
        VIRBOND(3) = VIRBOND(3) + RIJ(3)*FTMP(3)
        VIRBOND(4) = VIRBOND(4) + RIJ(1)*FTMP(2)
        VIRBOND(5) = VIRBOND(5) + RIJ(2)*FTMP(3)
        VIRBOND(6) = VIRBOND(6) + RIJ(3)*FTMP(1)
        
     ENDDO
     
     IF (BASISI .EQ. "sp") THEN
        INDI = INDI + 4
     ELSEIF (BASISI .EQ. "ss") THEN
        INDI = INDI + 1
     ENDIF
     
  ENDDO
  
  RETURN
  
END SUBROUTINE GRADH
