!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

PROGRAM LATTE
  
  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE PUREARRAY
  USE SPARSEIND
  USE COULOMBARRAY
  USE SPINARRAY
  USE MYPRECISION
  USE DIAGARRAY

  IMPLICIT NONE

  INTEGER :: I, J
  INTEGER :: START_CLOCK, STOP_CLOCK, CLOCK_RATE, CLOCK_MAX
  REAL :: TARRAY(2), RESULT, SYSTDIAG, SYSTPURE

  CHEMPOT = ZERO

  CALL READCONTROLS
  
  CALL READTB()

!  CALL PLOTGSP

  IF (MDON .EQ. 0 .OR. RESTART .EQ. 0) THEN
     CALL READCR()
  ELSEIF (MDON .EQ. 1 .AND. RESTART .EQ. 1) THEN
     CALL READRESTART
  ENDIF

  CALL READPPOT
  
  CALL GETHDIM

  CALL RHOZERO

  CALL GETBNDFIL()

  IF (MDON .EQ. 0 .AND. RELAXME .EQ. 0) THEN
    
     !
     ! Start the timers
     !

     CALL SYSTEM_CLOCK(START_CLOCK, CLOCK_RATE, CLOCK_MAX)
     CALL DTIME(TARRAY, RESULT)

     ! Set up neighbor lists for building the H and pair potentials

     CALL ALLOCATENEBARRAYS

     IF (ELECTRO .EQ. 1) THEN
     
        CALL ALLOCATECOULOMB
        CALL INITCOULOMB

     ENDIF

     CALL NEBLISTS(0)

     ! Test assigning atoms to molecules

     IF (ORDERNMOL .EQ. 1) THEN
        CALL FINDMOLECULES
     ENDIF
     
     ! Build the charge independent H matrix

     CALL BLDNEWH(0)   

     !
     ! If we're starting from a restart file, we need to modify H such
     ! that it agrees with the density matrix elements read from file
     !
     
     IF (RESTART .EQ. 1) THEN
        CALL IFRESTART
     ENDIF

     !
     ! See whether we need spin-dependence too
     !

     IF (SPINON .EQ. 1) THEN
        CALL GETDELTASPIN
        CALL BLDSPINH
     ENDIF

     IF (CONTROL .EQ. 1) THEN
        CALL ALLOCATEDIAG
     ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
        CALL ALLOCATEPURE
     ELSEIF (CONTROL .EQ. 3) THEN
        CALL FERMIALLOCATE
     ENDIF
     
     IF (SPARSEON .EQ. 1) THEN
        CALL ALLOCATENONZERO
     ENDIF

     IF (CONTROL .EQ. 5) THEN

        CONTROL = 2

        CALL QCONSISTENCY(0,1)

        CONTROL = 5

        CALL GERSHGORIN
        CALL SP2FERMIINIT
     ENDIF

     IF (ELECTRO .EQ. 0) THEN

        IF (CONTROL .EQ. 1) THEN
           CALL DIAGMYH
           CALL BOEVECS
        ELSEIF (CONTROL .EQ. 2) THEN

           CALL GERSHGORIN
          
           IF (SPARSEON .EQ. 0) THEN
              CALL SP2PURE
           ELSE 
              CALL INITSPARSESP2
              CALL SPARSESP2PURE
           ENDIF

        ELSEIF (CONTROL .EQ. 3) THEN
           
           IF (SPARSEON .EQ. 0) THEN
              CALL FERMIEXPANS
           ELSE
              CALL ALLOCATEPURE
              CALL GERSHGORIN
              CALL INITSPARSESP2
              CALL DEALLOCATEPURE
              CALL FERMIEXPANSSPARSE
           ENDIF

        ELSEIF (CONTROL .EQ. 4) THEN

           CALL GERSHGORIN
           CALL SP2T

        ELSEIF (CONTROL .EQ. 5) THEN

           CALL SP2FERMI

        ENDIF

        CALL ATOMCHARGE(0,1)

     ENDIF

     !
     ! This subroutine will get us our first set of charges in
     ! we don't have any defined, and will run cycles for self-
     ! consistency
     !
     ! FULLQCONV = 1 - we're going to run until all partial charges
     ! have converged to within ELEC_QTOL
     !
     ! If FULLQCONV = 0 - we're only going to run a user-specified
     ! number of 'SCF' cycles (useful for XBO MD)
     !
     !
     ! 0 = we don't have any charges yet
     !

     !
     ! We're going to do the spin stuff in qconsistency too
     !
             
     IF (ELECTRO .EQ. 1) THEN
        CALL QCONSISTENCY(0,1)
     ENDIF

     CALL TOTENG

     ENTE = ZERO
     IF (CONTROL .NE. 2 .AND. KBT .GT. 0.000001 ) THEN
        CALL ENTROPY
     ENDIF

     CALL GRADH

     CALL PPOTHYBRID

     CALL GETCOULE

     IF (SPINON .EQ. 1) THEN
        CALL GETSPINE
     ENDIF

!     CALL PLOTPPOTHYBRID

     IF (CONTROL .EQ. 1) THEN
        CALL DEALLOCATEDIAG
     ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
        CALL DEALLOCATEPURE
     ELSEIF (CONTROL .EQ. 3) THEN
        CALL FERMIDEALLOCATE
     ENDIF

     IF (SPARSEON .EQ. 1) THEN
        CALL DEALLOCATENONZERO
     ENDIF

     !
     ! Stop the clocks
     !

     CALL DTIME(TARRAY, RESULT)        
     CALL SYSTEM_CLOCK(STOP_CLOCK, CLOCK_RATE, CLOCK_MAX)

     CALL SUMMARY

!     CALL ASSESSOCC

     SYSTDIAG = TARRAY(1)

     PRINT*, "System time  = ", SYSTDIAG
     PRINT*, "Wall time = ", FLOAT(STOP_CLOCK - START_CLOCK)/FLOAT(CLOCK_RATE)

     IF (ELECTRO .EQ. 1) THEN
        CALL DEALLOCATECOULOMB
     ENDIF

     CALL DEALLOCATENEBARRAYS

  ELSEIF (MDON .EQ. 1 .AND. RELAXME .EQ. 0) THEN

     IF (XBOON .EQ. 1) THEN
        CALL ALLOCATEXBO
     ENDIF
     
     IF (ELECTRO .EQ. 1) THEN
        CALL ALLOCATECOULOMB
        CALL INITCOULOMB
     ENDIF

     ! Start the timers

     CALL SYSTEM_CLOCK(START_CLOCK, CLOCK_RATE, CLOCK_MAX)     
     CALL DTIME(TARRAY, RESULT)
     
     !
     ! Call TBMD
     !

     CALL TBMD

     ! Stop the timers
     
     CALL DTIME(TARRAY, RESULT)
     CALL SYSTEM_CLOCK(STOP_CLOCK, CLOCK_RATE, CLOCK_MAX)

     CALL SUMMARY

     IF (XBOON .EQ. 1) THEN
        CALL DEALLOCATEXBO
     ENDIF
     
     IF (ELECTRO .EQ. 1) THEN
        CALL DEALLOCATECOULOMB
     ENDIF

     SYSTPURE = TARRAY(1)
     WRITE(6,'("# System time for MD run = ", F12.2, " s")') SYSTPURE
     WRITE(6,'("# Wall time for MD run = ", F12.2, " s")') &
          FLOAT(STOP_CLOCK - START_CLOCK)/FLOAT(CLOCK_RATE)
     
  ELSEIF (MDON .EQ. 0 .AND. RELAXME .EQ. 1) THEN
     
     CALL MSRELAX
     
  ELSE

     WRITE(6,*) "You can't have RELAXME = 1 and MDON = 1"
     STOP
     
  ENDIF

  CALL DEALLOCATEALL
  
END PROGRAM LATTE
