!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE MSRELAX

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE NEBLISTARRAY
  USE SPARSEIND
  USE COULOMBARRAY
  USE VIRIALARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: ITER, I
  REAL(LATTEPREC) :: MAXF

  ITER = 0
  MAXF = 1.0D10
  
  OPEN(UNIT=20, STATUS="UNKNOWN", FILE="monitorrelax.pdb")
  
  DO I = 1, NATS
     WRITE(20,'("ATOM  ",I5,"  N   VAL A   1    ",3F8.3,F6.2,"  1.00        A1   N  ")') I, CR(1,I), CR(2,I), CR(3,I), 1.0
  ENDDO
  
  WRITE(20,'("END    ")')
  
  IF (CONTROL .EQ. 1) THEN
     CALL ALLOCATEDIAG
  ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
     CALL ALLOCATEPURE
  ELSEIF (CONTROL .EQ. 3) THEN
     CALL FERMIALLOCATE
  ENDIF

  IF (SPARSEON .EQ. 1) THEN
     CALL ALLOCATENONZERO
  ENDIF

  IF (ELECTRO .EQ. 1) THEN
     CALL ALLOCATECOULOMB
     CALL INITCOULOMB
  ENDIF

  !
  ! Allocate stuff for building the neighbor lists
  !

  CALL ALLOCATENEBARRAYS

  CALL NEBLISTS(0)  

  CALL BLDNEWH(0)

  IF (SPINON .EQ. 1) THEN
     CALL GETDELTASPIN
     CALL BLDSPINH
  ENDIF

  IF (CONTROL .EQ. 5) THEN
     CALL GERSHGORIN
     CALL SP2FERMIINIT
  ENDIF

  DO WHILE (ABS(MAXF) .GT. RLXFTOL .AND. ITER .LT. MXRLX )

     ITER = ITER + 1

     IF (ELECTRO .EQ. 0) THEN
        
        IF (CONTROL .EQ. 1) THEN
           CALL DIAGMYH        
           CALL BOEVECS
        ELSEIF (CONTROL .EQ. 2 .AND. SPARSEON .EQ. 0) THEN
           CALL GERSHGORIN
           CALL SP2PURE
        ELSEIF (CONTROL .EQ. 2 .AND. SPARSEON .EQ. 1) THEN
           CALL GERSHGORIN
           CALL INITSPARSESP2
           CALL SPARSESP2PURE
        ELSEIF (CONTROL .EQ. 3 .AND. SPARSEON .EQ. 0) THEN
           CALL FERMIEXPANS
        ELSEIF (CONTROL .EQ. 3 .AND. SPARSEON .EQ. 1) THEN
           CALL INITFERMISPARSE
           CALL FERMIEXPANSSPARSE
        ELSEIF (CONTROL .EQ. 4) THEN
           CALL GERSHGORIN
           CALL SP2T
        ELSEIF (CONTROL .EQ. 5) THEN
           CALL SP2FERMI
        ENDIF

        CALL ATOMCHARGE(0)
        
     ELSEIF (ELECTRO .EQ. 1) THEN
        
        CALL QCONSISTENCY(0, 1)
        
        CALL GETCOULE

     ENDIF

     CALL TOTENG

     CALL GRADH
     
     CALL PPOTHYBRID

     ENTE = ZERO

     IF (CONTROL .NE. 2) THEN
        CALL ENTROPY
     ENDIF

     ESPIN = ZERO
     IF (SPINON .EQ. 1) THEN
        CALL GETSPINE
     ENDIF

     IF (ELECTRO .EQ. 0) THEN

        TOTE = TRRHOH + EREP - ENTE

        FTOT = TWO*F + FPP

     ELSEIF (ELECTRO .EQ. 1) THEN

        TOTE = TRRHOH + EREP - ECOUL - ENTE
        
        FTOT = TWO*F + FPP + FCOUL

        IF (SPINON .EQ. 1) THEN

           TOTE = TOTE + ESPIN - ESPIN_ZERO
           
        ENDIF

     ENDIF

     CALL GETMAXF(MAXF)

     CALL GETPRESSURE

     WRITE(6,20) ITER, "MaxF = ", MAXF, "Total energy = ", TOTE, &
          "Pressure = ", PRESSURE, " GPa"
20   FORMAT(I6,1X,A7,1X,F12.8,1X,A15,1X,F12.6, 1X, A11, 1X, F6.1, 1X, A4)

     CALL STDESCENT(ITER, MAXF)

     !
     ! After moving atoms, apply PBCs again
     !

     IF (MOD(ITER,1) .EQ. 0) THEN
        CALL NEBLISTS(1)
     ENDIF

     DO I = 1, NATS
        WRITE(20,'("ATOM  ",I5,"  N   VAL A   1    ",3F8.3,F6.2,"  1.00        A1   N  ")') I, CR(1,I), CR(2,I), CR(3,I), 1.0
     ENDDO

     WRITE(20,'("END    ")')

     CALL BLDNEWH(1)

  ENDDO

  CLOSE(20)

  CALL WRTRESTART(ITER)

  IF (ELECTRO .EQ. 1) THEN
     CALL DEALLOCATECOULOMB
  ENDIF

  IF (CONTROL .EQ. 1) THEN
     CALL DEALLOCATEDIAG
  ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
     CALL DEALLOCATEPURE
  ELSEIF (CONTROL .EQ. 3) THEN
     CALL FERMIDEALLOCATE
  ENDIF
  
  IF (SPARSEON .EQ. 1) THEN
     CALL DEALLOCATENONZERO
  ENDIF

  RETURN

END SUBROUTINE MSRELAX
