!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE NVTRESCALE

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE MDARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, K, CURRITER
  REAL(LATTEPREC) :: PREFACTOR, PREPREFACT
  REAL(LATTEPREC) :: CHI, TMPTEMP, MYTEMP
  REAL(LATTEPREC) :: MAXCHI = 1.05D0
  REAL(LATTEPREC), PARAMETER :: CONV = 1.60219D-2/1.66053D0

  PREPREFACT = HALF*CONV*DT

  TMPTEMP = ZERO

  DO I = 1, AVEPER
     TMPTEMP = TMPTEMP + THIST(I)
  ENDDO

  MYTEMP = TMPTEMP/FLOAT(AVEPER)

  CHI = SQRT(TEMP/MYTEMP)

  CHI = MIN(CHI, MAXCHI)

!  PRINT*, "MYTEMP = ", MYTEMP, "CHI = ", CHI

  DO I = 1, NATS
     
     DO J = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(J)) THEN
           PREFACTOR = PREPREFACT/MASS(J)
        ENDIF
     ENDDO

     DO K = 1, 3

        !
        ! Half timestep advance in V with velocity rescale
        !

        V(K,I) = CHI*V(K,I) + PREFACTOR*FTOT(K,I)

        !
        ! Whole timestep advance in positions
        !

        CR(K,I) = CR(K,I) + DT*V(K,I)
        

     ENDDO
  ENDDO

  !
  ! Get new force to complete advance in V
  !
  
  CALL GETMDF(1, 2)

  !
  ! Now finish advancing V with F(t + dt)
  !

  DO I = 1, NATS
    
     DO J = 1, NOELEM
        IF (ATELE(I) .EQ. ELE(J)) THEN
           PREFACTOR = PREPREFACT/MASS(J)
        ENDIF
     ENDDO

     DO K = 1, 3

        V(K,I) = V(K,I) + PREFACTOR*FTOT(K,I)

     ENDDO

  ENDDO

  RETURN

END SUBROUTINE NVTRESCALE
        
