!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE PLOTPPOTHYBRID

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: K, IGS, II, KK
  REAL(LATTEPREC) :: JR1, JRCUT, R1, RCUT2
  REAL(LATTEPREC) :: PHI, FORCE
  REAL(LATTEPREC) :: MYR, MYR2, MYR3, MYR4, MAGR2, MAGR, R6
  CHARACTER(LEN=50) :: FLNM

  ! There are 4 different parts to the pair potential:
  !
  ! 1) Short range repulsion fitting to give bond lengths etc
  ! 2) The joining function from JOINR1 TO JOINRCUT
  ! 3) The vdW-type pair potential from JOINCUT to PPR1
  ! 4) The final cut off tail from PPR1 TO PPRCUT
  !

  DO KK = 1, NOPPS
     
     WRITE(FLNM,'("ppot_plot_k.",I1,".dat")') KK
     OPEN(UNIT=56, STATUS="UNKNOWN", FILE = FLNM)

     IGS = KK
     
     JR1 = JOINR1(IGS)
     JRCUT = JOINRCUT(IGS)
     R1 = PPR1(IGS)
     
     RCUT2 = PPRCUT(KK)*PPRCUT(KK)
     
     DO II = 1, 1000
        
        MAGR2 = (HALF + 11.0D0*FLOAT(II-1)/1000.0D0)**2
        
        MAGR = SQRT(MAGR2)
           
        IF (MAGR .LT. JR1) THEN
              
           PHI = ZERO
           FORCE = ZERO
           
           DO K = 1, PPK(IGS)
              
              IF (MAGR .LT. PPRK(K, IGS)) THEN
                 
                 MYR = PPRK(K, IGS) - MAGR
                 
                 PHI = PHI + PPAK(K,IGS)*MYR*MYR*MYR
                 
                 FORCE = FORCE - THREE*PPAK(K,IGS)*MYR*MYR
                 
              ENDIF
              
           ENDDO
           
        ELSEIF (MAGR .GE. JR1 .AND. MAGR .LT. JRCUT) THEN
              
           MYR = MAGR - JR1
           MYR2 = MYR*MYR
           MYR3 = MYR2*MYR
           MYR4 = MYR3*MYR
           
           PHI = JOINB(1,IGS) + JOINB(2,IGS)*MYR + JOINB(3,IGS)*MYR2 + &
                JOINB(4,IGS)*MYR3 + JOINB(5,IGS)*MYR4 + &
                JOINB(6,IGS)*MYR4*MYR
           
           FORCE = JOINB(2,IGS) + TWO*JOINB(3,IGS)*MYR + &
                THREE*JOINB(4,IGS)*MYR2 + FOUR*JOINB(5,IGS)*MYR3 + &
                FIVE*JOINB(6,IGS)*MYR4
           
        ELSEIF (MAGR .GE. JRCUT .AND. MAGR .LT. R1) THEN
           
           R6 = MAGR2*MAGR2*MAGR2
           
           PHI = MINUSONE*VDWC(IGS)/R6
           
           FORCE = MINUSONE*SIX*PHI/MAGR
           
        ELSEIF (MAGR .GE. R1) THEN
           
           MYR = MAGR - R1
           MYR2 = MYR*MYR
           MYR3 = MYR2*MYR
           MYR4 = MYR3*MYR
           
           PHI = PPCUTB(1,IGS) + PPCUTB(2,IGS)*MYR + PPCUTB(3,IGS)*MYR2 + &
                PPCUTB(4,IGS)*MYR3 + PPCUTB(5,IGS)*MYR4 + &
                PPCUTB(6,IGS)*MYR4*MYR
           
           FORCE = PPCUTB(2,IGS) + TWO*PPCUTB(3,IGS)*MYR + &
                   THREE*PPCUTB(4,IGS)*MYR2 + FOUR*PPCUTB(5,IGS)*MYR3 + &
                   FIVE*PPCUTB(6,IGS)*MYR4
           
        ENDIF
        
        WRITE(56,10) MAGR, PHI, FORCE

     ENDDO
        
     CLOSE(56)
     
  ENDDO

10 FORMAT(3F18.9)

  RETURN
  
END SUBROUTINE PLOTPPOTHYBRID

