!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE PPTAILCOEF

  USE CONSTANTS_MOD
  USE PPOTARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J
  REAL(LATTEPREC) :: DELTA, DELTA2, DELTA3, DELTA4
  REAL(LATTEPREC) :: X, Y, Z, MYR, R6

  !
  ! We're going to calculate the coefficients for the joining and cut
  ! off function in the pair potentials for each pair of species
  !

  !
  ! The cut-offs and joining functions look like this:
  !
  ! t(R) = B1 + B2*(R - R1) + B3*(R - R1)^2 + B4*(R - R1)^3 + 
  !          B5*(R - R1)^4 + B6*(R - R1)^5
  !

  ALLOCATE(JOINB(6,NOPPS), PPCUTB(6,NOPPS))

  DO I = 1, NOPPS
     DO J = 1, 6
        JOINB(J,I) = ZERO
     ENDDO
  ENDDO

  DO I = 1, NOPPS
     
     ! Fitting value, 1st, and 2nd derivate at R1 for the joining function

     DO J = 1, PPK(I)
        
        IF (JOINR1(I) .LT. PPRK(J,I)) THEN

           MYR = PPRK(J,I) - JOINR1(I)

           JOINB(1,I) = JOINB(1,I) + PPAK(J,I)*MYR*MYR*MYR
           JOINB(2,I) = JOINB(2,I) - THREE*PPAK(J,I)*MYR*MYR
           JOINB(3,I) = JOINB(3,I) + HALF*(SIX*PPAK(J,I)*MYR)

        ENDIF

     ENDDO

     R6 = JOINRCUT(I)*JOINRCUT(I)*JOINRCUT(I)*JOINRCUT(I)* &
          JOINRCUT(I)*JOINRCUT(I)

     ! Conditions for fitting value, 1st, and 2nd derivates at Rcut for
     ! the joining function

     X = MINUSONE*VDWC(I)/R6
     Y = MINUSONE*SIX*X/JOINRCUT(I)
     Z = MINUSONE*SEVEN*Y/JOINRCUT(I)

     DELTA = JOINRCUT(I) - JOINR1(I)
     DELTA2 = DELTA*DELTA
     DELTA3 = DELTA2*DELTA
     DELTA4 = DELTA3*DELTA

     JOINB(4,I) = (ONE/(TWO*DELTA3))*(FOUR*(FIVE*X - Y*DELTA) - &
          (FOUR*Y - Z*DELTA)*DELTA - SIX*JOINB(3,I)*DELTA2 - &
          TWELVE*JOINB(2,I)*DELTA - TWENTY*JOINB(1,I))

     JOINB(5,I) = (ONE/DELTA4)*(FIVE*X - Y*DELTA - &
          TWO*JOINB(4,I)*DELTA3 - THREE*JOINB(3,I)*DELTA2 &
          - FOUR*JOINB(2,I)*DELTA - FIVE*JOINB(1,I))

     JOINB(6,I) = (ONE/(DELTA4*DELTA))*(X - JOINB(5,I)*DELTA4 - &
          JOINB(4,I)*DELTA3 - JOINB(3,I)*DELTA2 - JOINB(2,I)*DELTA - &
          JOINB(1,I))

     !
     ! Now the same kind of thing but for the cut off tail at the
     ! end of the C/R^6 bit.
     !

     R6 = PPR1(I)*PPR1(I)*PPR1(I)*PPR1(I)*PPR1(I)*PPR1(I)

     PPCUTB(1,I) = MINUSONE*VDWC(I)/R6
     PPCUTB(2,I) = MINUSONE*SIX*PPCUTB(1,I)/PPR1(I)
     PPCUTB(3,I) = HALF*(MINUSONE*SEVEN*PPCUTB(2,I)/PPR1(I))

     DELTA = PPRCUT(I) - PPR1(I)

     DELTA2 = DELTA*DELTA
     DELTA3 = DELTA2*DELTA
     DELTA4 = DELTA3*DELTA

     PPCUTB(4,I) = (MINUSONE/DELTA3)*(THREE*PPCUTB(3,I)*DELTA2 + &
          SIX*PPCUTB(2,I)*DELTA + TEN*PPCUTB(1,I))

     PPCUTB(5,I) = (ONE/DELTA4)*(THREE*PPCUTB(3,I)*DELTA2 + &
          EIGHT*PPCUTB(2,I)*DELTA + FIFTEEN*PPCUTB(1,I))

     PPCUTB(6,I) = (MINUSONE/(TEN*DELTA3))*(SIX*PPCUTB(5,I)*DELTA2 + &
          THREE*PPCUTB(4,I)*DELTA + PPCUTB(3,I))

     
  ENDDO

  RETURN

END SUBROUTINE PPTAILCOEF

