!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE READPPOT()

  USE CONSTANTS_MOD
  USE PPOTARRAY

  IMPLICIT NONE

  INTEGER :: I, J
  CHARACTER(LEN=20) :: HD

  OPEN(UNIT=14,STATUS="OLD", FILE="TBparam/ppots.dat")

  READ(14,*) HD, NOPPS, HD, MAXK

  ALLOCATE(PPELE1(NOPPS), PPELE2(NOPPS), PPK(NOPPS), VDWC(NOPPS), &
       JOINR1(NOPPS), JOINRCUT(NOPPS), PPR1(NOPPS), PPRCUT(NOPPS), &
       PPRK(MAXK, NOPPS), PPAK(MAXK, NOPPS))

  DO I = 1, NOPPS

     ! Reading elements and number of node points in short range PP

     READ(14,*) HD, PPELE1(I), HD, PPELE2(I), HD, PPK(I)
     READ(14,*) HD, HD
     
     ! Reading the PPK node points and coefficients

     READ(14,*) (PPRK(J,I), PPAK(J,I), J = 1, PPK(I))

     ! Reading the start and finish of the function to join the
     ! short and long range PPs

     READ(14,*) HD, JOINR1(I), HD, JOINRCUT(I)

     ! Reading the coefficient for the long range -C/R^6 PP

     READ(14,*) HD, VDWC(I)

     ! Reading the cut off tail for the long range PP is to go

     READ(14,*) HD, PPR1(I), HD, PPRCUT(I)

     READ(14,*) HD

  ENDDO

  CLOSE(14)

  ! In PPTAILCOEF the coefficient for the cut off tails and joining
  ! functions are allocated and calculated

  CALL PPTAILCOEF

  RETURN
  
END SUBROUTINE READPPOT
