!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE SPARSESP2PURE

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PUREARRAY
  USE SPARSEIND
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, K, ITER
  INTEGER :: BREAKLOOP
  REAL(LATTEPREC) :: TRX, OCC
  REAL(LATTEPREC) :: TRXM1
  REAL(LATTEPREC) :: TRX2, TR2XX2, LIMIT1, LIMIT2
!  REAL(LATTEPREC) :: BREAKTOL = 1.0D-5

  OCC = BNDFIL*FLOAT(HDIM)

  TRX = ZERO

  BREAKLOOP = 0

  ITER = 0

  DO WHILE (BREAKLOOP .EQ. 0)

     ITER = ITER + 1

     IF (ITER .EQ. 100) THEN
        WRITE(6,*) "SP2 purification is not converging: STOP!"
        STOP
     ENDIF

     DO I = 1, HDIM
        DO J = 1, TOTNONZERO(I)
            X2(I, NONZERO(I,J)) = ZERO
           DO K = 1, TOTNONZERO(I)
              X2(I, NONZERO(I,J)) = X2(I,NONZERO(I,J)) + &
                   BO(I,NONZERO(I,K))*BO(NONZERO(I,K),NONZERO(I,J))
           ENDDO
        ENDDO
     ENDDO

     TRX2 = ZERO
     TR2XX2 = ZERO

!     DO I = 1, HDIM
!        DO J = 1, TOTNONZERO(I)
!           TWOXX2(I,NONZERO(I,J)) = TWO*X(I,NONZERO(I,J)) - &
!                X2(I,NONZERO(I,J))
!        ENDDO
!     ENDDO

     DO I = 1, HDIM
        TRX2 = TRX2 + X2(I,I)
        TR2XX2 = TR2XX2 + TWO*BO(I,I) - X2(I,I)
     ENDDO

     LIMIT1 = ABS(TRX2 - OCC)
     LIMIT2 = ABS(TR2XX2 - OCC)
     
     IF (LIMIT1 .LT. LIMIT2) THEN

        DO I = 1, HDIM
           DO J = 1, TOTNONZERO(I)
              BO(I,NONZERO(I,J)) = X2(I,NONZERO(I,J))
           ENDDO
        ENDDO

     ELSEIF  (LIMIT2 .LT. LIMIT1) THEN

        DO I = 1, HDIM
           DO J = 1, TOTNONZERO(I)
              BO(I,NONZERO(I,J)) = TWO*BO(I,NONZERO(I,J)) - X2(I,NONZERO(I,J))
           ENDDO
        ENDDO

     ENDIF

     TRXM1 = TRX
     TRX = ZERO

     DO I = 1, HDIM
        TRX = TRX + BO(I,I)
     ENDDO

     IF (ABS(ABS(TRX) - ABS(TRXM1)) .LT. BREAKTOL) THEN
        BREAKLOOP = 1
     ENDIF

  ENDDO

  BO = TWO*BO

  RETURN

END SUBROUTINE SPARSESP2PURE
