!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE TOTENG
  
  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPARSEIND
  USE SPINARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J

  COVE = ZERO
  TRRHOH = ZERO

  IF (SPINON .EQ. 0) THEN
     
     IF (SPARSEON .EQ. 0) THEN
           
        DO I = 1, HDIM
           DO J = I, HDIM
                 
              IF (I .EQ. J) THEN
                 TRRHOH = TRRHOH + (BO(J,I) - BOZERO(I))*H(J,I)
              ELSE
                 TRRHOH = TRRHOH + TWO*BO(J,I)*H(J,I)
              ENDIF
              
           ENDDO
        ENDDO
        
     ELSEIF (SPARSEON .EQ. 1) THEN
           
        DO I = 1, HDIM
           DO J = 1, TOTNONZERO(I)
                 
              IF (I .EQ. NONZERO(I,J)) THEN
                 
                 TRRHOH = TRRHOH + &
                      (BO(I,NONZERO(I,J)) - BOZERO(I))*H(NONZERO(I,J),I)
                 
              ELSE
                 
                 TRRHOH = TRRHOH + BO(I,NONZERO(I,J))*H(NONZERO(I,J),I)
                 
              ENDIF
              
           ENDDO
        ENDDO
        
     ENDIF
     
  ELSEIF (SPINON .EQ. 1) THEN

     !
     ! This is everything: tr(rhoup - rhoupzero)*Hup + 
     ! tr(rhodown - rhodownzero)*Hdown
     !
     ! Hup = H(Slater-Koster) + H(electrostatic) + H(spin)
     ! Hdown = H(Slater-Koster) + H(electrostatic) - H(spin)
     !
     ! Thus, we're calculating Covalent (from SK) + electrostatic (from H1) +
     ! spin (from H2) and we just need to add on the entropy and pairwise 
     ! bits to get the total energy
     !

     DO I = 1, HDIM
        DO J = I, HDIM

           IF (I .EQ. J) THEN

              TRRHOH = TRRHOH + ((RHOUP(I,I) + RHODOWN(I,I)) - &
                   (RHOUPZERO(I) + RHODOWNZERO(I)))*H(I,I)

           ELSE

              TRRHOH = TRRHOH + TWO*(RHOUP(J,I) + RHODOWN(J,I))*H(I,J)

           ENDIF

        ENDDO
     ENDDO

  ENDIF

  RETURN
  
END SUBROUTINE TOTENG
