/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: mousecoord.h,v 1.1 2004/06/19 11:14:48 jd Exp $

   Created 04/29/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/interactivity/mousecoord.h
  \brief mouse controler.
*/

#ifndef LEG_LIBS_INTERACTIVITY_MOUSECOORD_H
#define LEG_LIBS_INTERACTIVITY_MOUSECOORD_H

#include "leg/support/maths/vector.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace libs
{
namespace interactivity
{

using support::maths::real;

//! Mouse coordinates.
/*!
 * Any mouse has mouse coordinates.
 *
 * status:
 *    experimental.
 * 
 * info:
 *    none.
 *
 * @sa Mouse.
 */
class MouseCoord: public support::maths::Point<2>
{
   bool is_ranged_to_size; //!< is true when coordinates has been altered to 
			   //!< a range betwenn 0 and 1 regarding the screen
			   //!< window size.
   MouseCoord ();
   
   protected:
      
   unsigned int	  scr_width;	    //!< window screen width (in pixels).
   unsigned int	  scr_height;	    //!< window screen height (in pixels).
   float	  sensibility;	    //!< Sensibility of the mouse cursor (factor of coordinates). - not yet used.
   
   public:

   real x;
   real y;

   MouseCoord (unsigned int w, unsigned int h);

   ~MouseCoord ();
   
   //! Set the new coordinates.
   void
   Set (unsigned int vx, unsigned int vy);

   //! Get the current coordinates.
   void
   Get (const real& mx, const real& my);

   //! Range the coordinates to the screen size.
   /*!
    * This set the coordinates values between 0 and 1.
    */
   void
   RangeToSize ();

   //! Returns true if the coordinates are ranged to the screen size.
   bool
   IsRangedToSize ();

   //! Set the sensibility of the mouse (in development).
   /*!
    * The sensibility of the mouse is a floating value, greater than 0, that is
    * used as a factor to get the mouse coordinates.
    */
   void
   SetSensibility (float s);

   //! Get the sensibility.
   float
   GetSensibility ();

   private:

   void
   Range ();
};

}
}
}
#endif
