/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/27/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/message/basedeliverer.h
  \brief Base class for postoffice message delivering.
*/

#ifndef LEG_LIBS_MESSAGE_BASE_DELIVERER_H
#define LEG_LIBS_MESSAGE_BASE_DELIVERER_H

#include "common.h"

namespace leg
{
namespace libs
{
namespace message
{

//! Virtual base class for delivering message.
/*!
 * All deliverer capable classes should inherit from this class and take profit
 * from polymorphism. However, only the template class Deliverer that inherit 
 * from this class would work.
 * This class is not intended to make the delivering loop, but only allow 
 * messages to be delivered to the matching object. Have a look at PostOffice
 * if you want to know about the delivering loop.
 *
 * status:
 *    experimenting.
 *
 * info:
 *    Only Deliverer instances are used inside PostOffice.
 *
 * @sa Deliverer.
 */
class BaseDeliverer
{
   protected:

   BaseDeliverer(){}

   BaseDeliverer (const BaseDeliverer&){}
   
   public:

   virtual ~BaseDeliverer(){}

   const BaseDeliverer&
   operator = (const BaseDeliverer&)
   {
      return *this;
   }

   virtual BaseDeliverer&
   Clone() = 0;

   //! Delivers a message.
   /*!
    * Give the message to the object given in argument with PostOffice::Send*()
    * member functions.
    */
   virtual void
   Deliver (const Message&) = 0;
};

}
}
}

#endif
