/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: gravitron.h,v 1.1 2004/07/15 23:26:02 jd Exp $

   Created 07/03/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/physics/gravitron.h
  \brief A physics entity with gravity.
*/

#ifndef LEG_LIBS_PHYSICS_GRAVITRON_H
#define LEG_LIBS_PHYSICS_GRAVITRON_H

#include "simpleentity.h"
#include <list>

namespace leg
{
namespace libs
{
namespace physics
{

class Gravitron: public SimpleEntity
{
   protected:
   
   Vector		gravity_vector;
   std::list<Entity*>	graviton_list;

   typedef Entity SubmittableType;

   public:

   Gravitron();

   Gravitron (const Gravitron& g);

   virtual ~Gravitron();
/*
   Entity&
   Clone();
*/
   protected:

   void
   Copy (const Gravitron& g);

   public:

   const Vector&
   GetGravity() const;

   void
   SetGravity (const Vector& g);

   virtual real
   GetHeightAt (const Vector& pos);// = 0;

   virtual void
   Submit (Entity& e);

   void
   Update();
};

}
}
}

#endif
