/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: simpleentity.h,v 1.1 2004/07/15 23:26:02 jd Exp $

   Created 07/03/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/physics/simpleentity.h
  \brief An simple useable entity for physics.
*/

#ifndef LEG_LIBS_PHYSICS_SIMPLE_ENTITY_H
#define LEG_LIBS_PHYSICS_SIMPLE_ENTITY_H

#include "entity.h"

namespace leg
{
namespace libs
{
namespace physics
{

class SimpleEntity: public Entity
{
   protected:

   Vector	  position;
   Vector	  velocity;
   Vector	  acceleration;
   Orientation	  orientation;
   Vector	  angular_acceleration;
   Vector	  angular_speed;
   Vector	  gravity_center;
   Entity*	  revolution_center;
   Vector*	  gravity;
   Timing	  timing;
   GameTime	  time;
   GameTime	  last_time;
   real		  speed;
   real		  mass;
   MovingConfig	  moving_config;
   GravityConfig  gravity_config;
   SystemForces	  forces;

   SimpleEntity (const SimpleEntity& e);
   
   public:

   SimpleEntity();
   
   const SimpleEntity& 
   operator = (const SimpleEntity& e);

   ~SimpleEntity();

   void
   SetPosition (Vector& pos);

   const Vector&
   GetPosition() const;

   void
   SetVelocity (Vector& vel);

   const Vector&
   GetVelocity () const;

   void
   SetSpeed (real magnitude);

   real
   GetSpeed() const;

   void
   SetAcceleration (Vector& accel);

   const Vector&
   GetAcceleration() const;

   void
   SetAccelerationMagnitude (real magnitude);

   real
   GetAccelerationMagnitude();

   GameTime
   GetTime();

   void
   SetTime (GameTime gt);

   Orientation
   GetOrientation() const;

   Orientation
   GetOrientationFromVelocity() const;
   
   void
   SetOrientation (Orientation& orientation);

   void
   SetMass (real m);

   real
   GetMass();

   void
   SetRevolutionCenter (Entity& entity);

   const Entity*
   GetRevolutionCenter() const;

   void
   Update();
/*
   Entity&
   Clone ();
*/
   void
   SetMovingConfig (MovingConfig conf);

   MovingConfig
   GetMovingConfig() const;

   void
   SetGravityConfig (GravityConfig conf);

   GravityConfig
   GetGravityConfig() const;

   void
   SetExternalForce (Vector& f);

   const Vector&
   GetExternalForce();

   protected:

   void
   Update (GameTime dt);

   GameTime
   PreUpdate();

   void
   PostUpdate();

   void
   UpdatePosition (GameTime dt);

   void
   UpdateVelocity (GameTime dt);

   void
   UpdateAcceleration (GameTime dt);

   void
   UpdateOrientation (GameTime dt);

   void
   UpdateVelocityFromOrientation (GameTime dt);

   void 
   UpdateAngularSpeed (GameTime dt);

   void
   UpdateRevolution (GameTime dt);

   void
   UpdateGravity (Vector& g, real height);

   void
   UpdateTime ();

   void
   Copy (const SimpleEntity& e);

   virtual void
   Fall();
};

}
}
}

#endif
