/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 12/08/04 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/scene/io.h
  \brief files inputs/outputs & loading/saving.
*/

#ifndef LEG_LIBS_SCENE_IO_H
#define LEG_LIBS_SCENE_IO_H

#include "worldinterface.h"
#include "world.h"
#include "factory.h"
#include "leg/support/utils/errors.h"
#include <string>

namespace leg
{
namespace libs
{
namespace scene
{

const std::string format_begin = "LegSceneFormat";
const std::string format_end   = "End File";

class IO
{
   public:

   template <class TOrg>
   WorldInterface*
   Load (const std::string& filename)
   {
      WorldInterface *w;
      std::ifstream ifs;
      Entity *e = 0;

      ifs.open (filename.c_str(), std::ios_base::in);
      w = new World<TOrg>;

      std::string main_id;
      std::string sub_id;
      
      ifs >> main_id;
      if (main_id != format_begin){
	 support::utils::Warning ("Bad file identification, abort loading",
				  "libs::scene::IO::Load");
	 
	 return w;
      }
      
      while (!ifs.eof()){
	 ifs >> main_id >> sub_id;

	 if ((main_id == "End") && (sub_id == "File"))
	    break;
	 
	 e = ObjectFactory::Instance().Create (main_id, sub_id);
	 
	 if (!e){
	    delete w;
	    ifs.close();
	    support::utils::Error ("Cannot create object", "libs::scene::IO::Load");
	 }
	 
	 e->Read (ifs);
	 w->AddObject (*e);
	 main_id = "";
	 sub_id = "";
	 e = 0;
      }

      ifs.close();
      
      return w;
   }

   void
   Save (const std::string& filename, WorldInterface& w);
};

}
}
}

#endif // LEG_LIBS_SCENE_IO_H
