/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 12/08/04 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/scene/org.h
  \brief scene organisation.
*/

#ifndef LEG_LIBS_SCENE_ORG_H
#define LEG_LIBS_SCENE_ORG_H

#include "entity.h"
#include <list>

namespace leg
{
namespace libs
{
namespace scene
{

template
<
   class Container
>
class Organisation;

template<>
class Organisation<std::list<Entity*> >
{
   public:
   
   typedef std::list<Entity*> CType;
   typedef std::list<Entity*>::const_iterator CIterator;
   
   protected:
   
   CType main_container;
   CIterator it;

   public:
   
   void
   Add (Entity& e)
   {
      main_container.push_back (&e);
   }

   CIterator
   GetBegin()
   {
      return it = main_container.begin();
   }

   CIterator
   GetEnd() const
   {
      return main_container.end();
   }
   
   CIterator
   GetNext()
   {
      return ++it;
   }
   
   unsigned int
   GetSize() const
   {
      return main_container.size();
   }
};

}
}
}

#endif // LEG_LIBS_SCENE_ORG_H
