/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 12/08/04 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/scene/world.h
  \brief A generic world class.
*/

#ifndef LEG_LIBS_SCENE_WORLD_H
#define LEG_LIBS_SCENE_WORLD_H

namespace leg
{
namespace libs
{
namespace scene
{

template
<
   class Org
>
class World:public WorldInterface,
	    protected Org
{
   using Org::main_container;

   public:

   inline void
   AddObject (Entity& o)
   {
      Org::Add (o);
   }

   unsigned int
   CountObjects()
   {
      return Org::GetSize();
   }
   
   void
   Init()
   {
   }

   void
   Update()
   {
      typename Org::CIterator i;

      UpdateTime();

      i = Org::GetBegin();

      for (; i != Org::GetEnd(); ++i){
	 (*i)->Update();
      }
   }

   Entity* const
   GetBegin()
   {
      return *Org::GetBegin();
   }

   Entity* const
   GetNext()
   {
      typename Org::CIterator i;
      i = Org::GetNext();

      if (i != Org::GetEnd())
	 return *i;
      
      return 0;
   }
};

}
}
}

#endif // LEG_LIBS_SCENE_WORLD_H
