/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: inputs.h,v 1.2 2004/06/09 20:17:50 jd Exp $

   Created 06/01/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/threads/inputs.h
  \brief valid inputs for state threading.
*/

#ifndef LEG_LIBS_THREADS_INPUTS_H
#define LEG_LIBS_THREADS_INPUTS_H

#include <string>

namespace leg
{
namespace libs
{
namespace threads
{

//! libs::threads inputs are typedef of std::string.
/*!
 * Like almost all state-inputs under Leg, this thread layer will use them for
 * their inputs.
 */
typedef std::string  Input;

//! All valid inputs for libs::threads.
namespace input
{

using leg::libs::threads::Input;

//! This input is called when a thread has been destructed.
static const Input destructed	    = "destructed";

//! Each time a ThreaderCell is constructed, its state default to this value.
static const Input constructed	    = "constructed";

//! When the thread has been succesfully configured.
static const Input configured	    = "configured";

//! When the thread has been created.
static const Input created	    = "created";

//! When a thread has been locked.
static const Input locked	    = "locked";

//! When a thread has been unlocked.
static const Input unlocked	    = "unlocked";

//! When the thread is has been loaded.
static const Input loaded	    = "loaded";

//! If the thread enters a cancelable area.
static const Input cancelable	    = "cancelable";

//! If the thread enters a not cancelable area.
static const Input not_cancelable   = "not_cancelable";

//! When the thread is waiting for an external signal.
static const Input in_wait	    = "in_wait";

//! Just before a signal is sent, we call everything is ready.
static const Input ready	    = "ready";

//! When the thread is going to run.
static const Input run		    = "run";

//! When the thread has to be finished.
static const Input finish	    = "finish";

//! When the thread has been ended.
static const Input ended	    = "ended";

}

}
}
}
#endif
