/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: threadercell.h,v 1.5 2004/06/06 02:09:01 jd Exp $

   $Log: threadercell.h,v $
   Revision 1.5  2004/06/06 02:09:01  jd
   some changes

   Revision 1.4  2004/06/03 23:03:23  jd
   better support with independant state synchronization, and dispatching into files

   Revision 1.3  2004/06/03 03:01:50  jd
   some corrections

   Revision 1.2  2004/05/31 23:14:22  jd
   some doc for some files

   Revision 1.1  2004/05/31 20:40:56  jd
   first release


 
   Created 05/21/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/threads/threadercell.h
  \brief threaders.
*/

#ifndef LEG_LIBS_THREADS_THREADER_CELL_H
#define LEG_LIBS_THREADS_THREADER_CELL_H

#include "defaultsettingpolicy.h"
#include "threadablecell.h"
#include "threader.h"

namespace leg
{
namespace libs
{
namespace threads
{

//! Thread on a cell.
/*!
 * ThreaderCell is a thread running on a somewhat generic class called Cell and
 * that matches the wanting interface.
 *
 * template arguments description:
 *    Cell is a class that will inherit from TSync, 
 *    that will be able to use threading synchronization tools.
 *    
 *    TSync is a threading synchronization mean and will generally be a class
 *    inherited from support::threads::Mutex (libs::threads::Sync).
 *    Attention: TSync should not be Cond or CondMutex if the copy constructor
 *    is intended to be used. This is because cond cannot be copied yet.
 *    
 *    SettingPolicy is a template class implementing the behavior of the 
 *    settings of the resulting class (thread+cell).
 *    
 *    TCellSync is a threadable cell (a class ready to be used inside).
 *    
 *    ThreaderNoSync is a simple thread without synchronization.
 *
 * status:
 *    in development.
 *
 * info:
 *    needs state support...
 *
 * @sa DefaultSettingPolicy, TreadableCell, Threader, Sync, Cond.
 */
template
<
   template <class> class Cell,
   class TSync = libs::threads::Sync<>,
   template <class,class> class SettingPolicy = DefaultSettingPolicy,
   class TCellSync = ThreadableCell<Cell,TSync>,
   class ThreaderNoSync = Threader<support::threads::Thread,Syncless>
>
class ThreaderCell:  public SettingPolicy<TCellSync,ThreaderNoSync>
{
   protected:
   
   typedef SettingPolicy<TCellSync,ThreaderNoSync> Set;

   using Set::Load;
   using Set::Unload;
   using Set::Wait;
   using Set::Signal;
   
   public:
   
   //! Default constructor.
   ThreaderCell ():  Set()
   {
   }

   //! Copy constructor.
   /*!
    * Could be used to start some concurrent threading from a same cell.
    * You will generally avoid using this possibility, with preferring the 
    * default behavior that prefers to use different objects.
    */
   ThreaderCell (const ThreaderCell& c): Set (dynamic_cast<TCellSync&> (*this))
   {
   }
   
   const ThreaderCell& operator = (const ThreaderCell& tc)
   {
      Set::operator = (tc);
      return *this;
   }
   
   ~ThreaderCell()
   {
   }

   //! Run the thread.
   /*!
    * This first call the setting policy PreRun() function, then the cell Go()
    * function, then the policy PostRun(), and finally returns what the cell
    * Go() returned...
    */
   inline void*
   Go (void *args)
   {
      Set::PreRun ();
      void *ret = Set::Run (args);
      Set::PostRun ();
      return ret;
   }
};

}
}
}
#endif
