/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file leg/libs/window/inputs.h
  \brief default windowing policy.
*/

#ifndef LEG_LIBS_WINDOW_INPUTS_H
#define LEG_LIBS_WINDOW_INPUTS_H

#include <string>

namespace leg
{
namespace libs
{
namespace window
{

typedef std::string Input;

//! All available inputs for windowing states.
namespace input
{
   using leg::libs::window::Input;
   
   static const Input destruct      = "destruct";
   static const Input construct	    = "construct";
   
   static const Input configure	    = "configure";
   
   static const Input create	    = "create";
   static const Input destroy	    = "destroy";
   
   static const Input drawable	    = "drawable";
   static const Input refresh	    = "refresh";
   static const Input refreshed	    = "refreshed";
   static const Input redraw	    = "redraw";
   static const Input drawing	    = "drawing";
   
   static const Input hud_drawable  = "hud_drawable";
   static const Input hud_undrawable= "hud_undrawable";
   
   static const Input resize	    = "resize";
   static const Input sized	    = "sized";
   
   static const Input fullscreen    = "fullscreen";
   static const Input window	    = "window";
   
   static const Input pause	    = "pause";
   
   static const Input lock	    = "lock";
   static const Input unlock	    = "unlock";
   
   static const Input lock_draw	    = "lock_draw";
   static const Input unlock_draw   = "unlock_draw";
}
}
}
}
#endif
