/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: defaultviewingpolicy.h,v 1.2 2004/06/14 15:15:14 jd Exp $

   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file leg/support/graphics/defaultviewingpolicy.h
  \brief generic default viewing policy.
*/

// SHOULD BE MOVED INTO LIBS SURELY

#ifndef LEG_SUPPORT_GRAPHICS_DEFAULT_VIEWING_POLICY_H
#define LEG_SUPPORT_GRAPHICS_DEFAULT_VIEWING_POLICY_H

#include "viewmode.h"

namespace leg
{
namespace support
{
namespace graphics
{

//! need to be redefine each time one of the view template
// types change because constructors do not provide the
// same interface for all.
template
<
   class View,
   class Win
>
class DefaultViewingPolicy: public View
{
   protected:

   typedef typename View::Projection3D	  Projection3D;
   typedef typename View::Projection2D	  Projection2D;
   typedef typename View::Viewport	  Viewport;
   typedef typename View::Viewmatrix	  Viewmatrix;

   using View::SetViewport;
   using View::SetProjection3D;
   using View::SetProjection2D;

   unsigned int window_width;
   unsigned int window_height;
   unsigned int decale_width;
   unsigned int decale_height;
   unsigned int hud_width;
   unsigned int hud_height;
   unsigned int hud_decale_width;
   unsigned int hud_decale_height;
   float field_of_view;
   float ratio;
   float near_view;
   float far_view;
   float near_hud_view;
   float far_hud_view;

   DefaultViewingPolicy();
   
   public:

   explicit DefaultViewingPolicy (Win& win): View(),
					     window_width (0),
					     window_height (0),
					     decale_width (0),
					     decale_height (0),
					     hud_width (0),
					     hud_height (0),
					     hud_decale_width (0),
					     hud_decale_height (0),
					     field_of_view (90),
					     ratio (1.33333333),
					     near_view (.1),
					     far_view (1200000000.),
					     near_hud_view (-1),
					     far_hud_view (1)
   {
      win.GetAttributes().GetSize (window_width,window_height);
      SetViewport (decale_width,decale_height,window_width,window_height);
      ratio = (float) ((float)(window_width - decale_width) / (float)(window_height - decale_height));
      SetProjection3D (field_of_view,ratio,near_view,far_view);
      hud_width = window_width;
      hud_height = window_height;
      SetProjection2D (hud_decale_width,hud_width,hud_decale_height,hud_height,near_hud_view,far_hud_view);
   }

   ~DefaultViewingPolicy()
   {
   }

   //TODO: do all the interface functions for setting all the values (and calling the good functions to store them).
};

}
}
}
#endif
