/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: extensions.h,v 1.3 2004/06/15 07:05:07 jd Exp $

   Created 4/20/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/extensions.h
  \brief Support for OpenGL extensions.
*/

#ifndef LEG_SUPPORT_GRAPHICS_EXTENSIONS_H
#define LEG_SUPPORT_GRAPHICS_EXTENSIONS_H

#include <map>
#include <string>
#include <GL/glu.h>

namespace leg
{
namespace support
{
namespace graphics
{

//! All extensions loader.
/*!
 * When a window has been created and you received the supported extensions 
 * from the GraphicCard class, then you can construct an object of this
 * type, by giving the gl and glu extensions strings (well it may be best
 * if this class owns the extensions string instead of GraphicCard...
 *
 * status:
 *    in development.
 *
 * info:
 *    Very few extensions are really supported (see the source file for
 *    more details).
 *
 * @sa glextensions.h (gluextensions.h)
 */
class Extensions
{
   typedef std::map<std::string,bool> ExtMap;

   static std::string	  gl_extensions;
   static std::string	  glu_extensions;
   static ExtMap	  ext_map;
   
   Extensions();
   Extensions (const Extensions&);
   const Extensions& operator = (const Extensions&);
   ~Extensions();
 
   public:

   static void
   Load (bool force = false);

   static bool
   IsExtensionSupported (const std::string& ext_name);

   static void
   CoutExtensionsSupport();

   private:
   
   static void
   LoadGlExtension (const std::string& ext);

   static bool
   Check (const std::string& ext_name);
};

}
}
}

#endif // LEG_SUPPORT_GRAPHICS_EXTENSIONS_H
