/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glextensions.h,v 1.1 2004/06/08 20:02:24 jd Exp $

   Created 06/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/glextensions.h
  \brief some gl extensions.
*/

#ifndef LEG_SUPPORT_GRAPHICS_GL_EXTENSIONS_H
#define LEG_SUPPORT_GRAPHICS_GL_EXTENSIONS_H

//#define GL_GLEXT_PROTOTYPES
#ifndef WIN32
#include <GL/glx.h>
#else
#include <windows.h>
#endif
#include <GL/glext.h>
#include <string>

namespace leg
{
namespace support
{
namespace graphics
{

typedef void (*(*GetGlExtProcPtr) (const GLubyte *)) ();

#ifndef WIN32
const GetGlExtProcPtr GetFunctionPointer = static_cast<GetGlExtProcPtr> (glXGetProcAddressARB);
#else
const GetGlExtProcPtr GetFunctionPointer = static_cast<GetGlExtProcPtr> (wglGetProcAddressARB);
#endif


//
// Official GL ARB Extensions:
//

#ifndef WIN32
const std::string GLX_ARB_GET_PROC_ADDRESS	= "GLX_ARB_get_proc_address";
#else
const std::string WGL_ARB_GET_PROC_ADDRESS	= "WGL_ARB_get_proc_address";
#endif

const std::string GL_ARB_MULTITEXTURE		= "GL_ARB_multitexture";

const std::string GL_ARB_VERTEX_BUFFER_OBJECT	= "GL_ARB_vertex_buffer_object";

const std::string GL_ARB_OCCLUSION_QUERY	= "GL_ARB_occlusion_query";
/*
const std::string GL_ARB_VERTEX_PROGRAM		= "GL_ARB_vertex_program";
*/

typedef void
(*PFNGLXGETPROCADDRESSARBPROC) (const GLubyte*);
//static const GLubyte* get_proc_address_arb = (GLubyte*)		  "glxGetProcAddressARB";

typedef void
(*PFNGLMULTITEXCOORD2FVARBPROC) (GLenum t, GLfloat *tx);

typedef void
(*PFNGLACTIVETEXTUREARBPROC) (GLenum t);

typedef void
(*PFNGLCLIENTACTIVETEXTUREARBPROC) (GLenum t);

typedef void
(*PFNGLBINDBUFFERARBPROC) (GLenum target, GLuint buffer);

typedef void 
(*PFNGLDELETEBUFFERSARBPROC) (GLsizei n, const GLuint *buffers);

typedef void 
(*PFNGLGENBUFFERSARBPROC) (GLsizei n, GLuint *buffers);

typedef GLboolean 
(*PFNGLISBUFFERARBPROC) (GLuint buffer);

typedef void 
(*PFNGLBUFFERDATAARBPROC) (GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);

typedef void 
(*PFNGLBUFFERSUBDATAARBPROC) (GLenum target, GLintptrARB offset, GLsizeiptr size, const GLvoid *data);

typedef void 
(*PFNGLGETBUFFERSUBDATAARBPROC) (GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid *data);

typedef void 
(*PFNGLMAPBUFFERARBPROC) (GLenum target, GLenum access);
 
typedef GLboolean 
(*PFNGLUNMAPBUFFERARBPROC) (GLenum target);

typedef void 
(*PFNGLGETBUFFERPARAMETERIVARBPROC) (GLenum target, GLenum pname, GLint *params);

typedef void 
(*PFNGLGETBUFFERPOINTERVARB) (GLenum target, GLenum pname, GLvoid **params);

typedef void
(*PFNGLGENQUERIESARB) (GLsizei n, GLuint *ids);

typedef void
(*PFNGLDELETEQUERIESARB) (GLsizei n, const GLuint *ids);

typedef GLboolean
(*PFNGLISQUERYARB) (GLuint id);

typedef void
(*PFNGLBEGINQUERYARB) (GLenum target, GLuint id);

typedef void
(*PFNGLENDQUERYARB) (GLenum target);

typedef void
(*PFNGLGETQUERYIVARB) (GLenum target, GLenum pname, GLint *params);

typedef void
(*PFNGLGETQUERYOBJECTIVARB) (GLuint id, GLenum pname, GLint *params);

typedef void
(*PFNGLGETQUERYOBJECTUIVARB) (GLuint id, GLenum pname, GLuint *params);

//
// Official GL Extensions:
//

const std::string GL_EXT_COMPILED_VERTEX_ARRAY	= "GL_EXT_compiled_vertex_array";
const std::string GL_EXT_DRAW_RANGE_ELEMENTS	= "GL_EXT_draw_range_elements";
const std::string GL_EXT_VERTEX_ARRAY	   	= "GL_EXT_vertex_array";
const std::string GL_EXT_ACTIVE_STENCIL_FACE	= "GL_EXT_stencil_two_side";
const std::string GL_EXT_STENCIL_WRAP		= "GL_EXT_stencil_wrap";
//const std::string GL_EXT_MULTI_DRAW_ARRAYS	= "GL_EXT_multi_draw_arrays";

typedef void
(*PFNGLVERTEXPOINTEREXTPROC) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

typedef void
(*PFNGLNORMALPOINTEREXTPROC) (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

typedef void
(*PFNGLCOLORPOINTEREXTPROC) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

typedef void
(*PFNGLTEXCOORDPOINTEREXTPROC)
(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

typedef void
(*PFNGLINDEXPOINTEREXTPROC) (GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);

typedef void
(*PFNGLDRAWARRAYSEXTPROC) ( GLenum, GLint, GLsizei);

typedef void
(*PFNGLDRAWRANGEELEMENTSEXTPROC) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);

typedef void
(*PFNGLLOCKARRAYSEXTPROC) (GLint first, GLsizei count);

typedef void
(*PFNGLUNLOCKARRAYSEXTPROC) (void);

typedef void
(*PFNGLBINDTEXTUREEXTPROC) (GLenum target, GLuint texture);

typedef GLboolean
(*PFNGLARETEXTURESRESIDENTEXTPROC) (GLsizei n, const GLuint *textures, GLboolean *residences);

typedef void
(*PFNGLDELETETEXTURESEXTPROC) (GLsizei n, const GLuint *textures);

typedef void
(*PFNGLGENTEXTURESEXTPROC) (GLsizei n, GLuint *textures);

typedef GLboolean
(*PFNGLISTEXTUREEXTPROC) (GLuint texture);

typedef void
(*PFNGLPRIORITIZETEXTURESEXTPROC) (GLsizei n, const GLuint *textures, const GLclampf *priorities);

typedef void
(*PFNGLACTIVESTENCILFACEEXTPROC) (GLenum face);



//
// Nvidia Extensions:
// 

const std::string GL_NV_VERTEX_ARRAY_RANGE	   = "GL_NV_vertex_array_range";

#ifndef WIN32
typedef void*
(*PFNGLALLOCATEMEMORYNVPROC) (GLsizei size, GLfloat read_frequency, GLfloat write_frequency, GLfloat priority);

typedef void
(*PFNGLFREEMEMORYNVPROC) (void *p);

#else
typedef void*
(*PFNGLALLOCATEMEMORYNVPROC) (GLsizei size, GLfloat read_frequency, GLfloat write_frequency, GLfloat priority);	

typedef void
(*PFNGLFREEMEMORYNVPROC) ( void *p);
#endif

typedef void
(*PFNGLVERTEXARRAYRANGENV) (GLsizei size, const GLvoid *pointer);

typedef void
(*PFNGLFLUSHVERTEXARRAYRANGENVPROC) (void);


// global pointer functions to extensions:
//
// use those defined in gl instead in order to avoid multiple definition of...

// deprecated
#ifndef WIN32
extern PFNGLALLOCATEMEMORYNVPROC		AgpAllocateMemory;
extern PFNGLFREEMEMORYNVPROC			AgpFreeMemory;

#else
//! idem for windows
extern PFNGLALLOCATEMEMORYNVPROC		AgpAllocateMemory;
extern PFNGLFREEMEMORYNVPROC			AgpFreeMemory;
#endif

extern PFNGLVERTEXPOINTEREXTPROC		VertexPointer;
extern PFNGLNORMALPOINTEREXTPROC		NormalPointer;
extern PFNGLCOLORPOINTEREXTPROC			ColorPointer;
extern PFNGLTEXCOORDPOINTEREXTPROC		TexelPointer;
extern PFNGLINDEXPOINTEREXTPROC			IndexPointer;

extern PFNGLVERTEXARRAYRANGENV 			VertexArrayRange;
extern PFNGLFLUSHVERTEXARRAYRANGENVPROC		FlushVertexArrayRange;

extern PFNGLDRAWRANGEELEMENTSEXTPROC		DrawRangeElements;
extern PFNGLDRAWARRAYSEXTPROC			DrawArrays;

extern PFNGLLOCKARRAYSEXTPROC			LockArrays;
extern PFNGLUNLOCKARRAYSEXTPROC			UnlockArrays;

extern PFNGLMULTITEXCOORD2FVARBPROC		MultiTexCoord;
extern PFNGLACTIVETEXTUREARBPROC		ActiveTexture;
extern PFNGLCLIENTACTIVETEXTUREARBPROC		ClientActiveTexture;
extern PFNGLBINDTEXTUREEXTPROC			BindTexture;
extern PFNGLARETEXTURESRESIDENTEXTPROC		AreTexturesResident;
extern PFNGLDELETETEXTURESEXTPROC		DeleteTextures;
extern PFNGLGENTEXTURESEXTPROC			GenTextures;
extern PFNGLISTEXTUREEXTPROC			IsTexture;
extern PFNGLPRIORITIZETEXTURESEXTPROC		PrioritizeTextures;

extern PFNGLBINDBUFFERARBPROC			BindBuffer;
extern PFNGLDELETEBUFFERSARBPROC		DeleteBuffers;
extern PFNGLGENBUFFERSARBPROC			GenBuffers;
extern PFNGLISBUFFERARBPROC			IsBuffer;
extern PFNGLBUFFERDATAARBPROC			BufferData;
extern PFNGLBUFFERSUBDATAARBPROC		BufferSubData;
extern PFNGLGETBUFFERSUBDATAARBPROC		GetBufferSubData;
extern PFNGLMAPBUFFERARBPROC			MapBuffer;
extern PFNGLUNMAPBUFFERARBPROC			UnmapBuffer;
extern PFNGLGETBUFFERPARAMETERIVARBPROC		GetBufferParameteriv;
extern PFNGLGETBUFFERPOINTERVARB		GetBufferPointerv;

extern PFNGLGENQUERIESARB			GenQueries;
extern PFNGLDELETEQUERIESARB			DeleteQueries;
extern PFNGLISQUERYARB				IsQuery;
extern PFNGLBEGINQUERYARB			BeginQuery;
extern PFNGLENDQUERYARB				EndQuery;
extern PFNGLGETQUERYIVARB			GetQueryiv;
extern PFNGLGETQUERYOBJECTIVARB			GetQueryObjectiv;
extern PFNGLGETQUERYOBJECTUIVARB		GetQueryObjectuiv;

extern PFNGLACTIVESTENCILFACEEXTPROC		ActiveStencilFace;

}// namespace graphics
}// namespace support
}// namespace leg

#endif
