/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: graphics.h,v 1.3 2004/05/21 23:16:09 jd Exp $
   $Log: graphics.h,v $
   Revision 1.3  2004/05/21 23:16:09  jd
   correction for libs/window

   Revision 1.2  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1  2004/03/28 21:30:07  jechk
   Added the support/graphics module.



   Created 3/24/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/graphics.h
  \brief Low-level graphics utilities
*/

#ifndef LEG_SUPPORT_GRAPHICS_GRAPHICS_H
#define LEG_SUPPORT_GRAPHICS_GRAPHICS_H

#include <leg/support/graphics/color.h>
#include <leg/support/graphics/displaylist.h>
#include <leg/support/graphics/extensions.h>
#include <leg/support/graphics/glconfig.h>
#include <leg/support/graphics/quadrics.h>

#include "defaultviewingpolicy.h"
#include "viewmode.h"
#include "viewport.h"
#include "projectiontransformation.h"
#include "visionfrustum.h"
#include "frustum.h"
#include "perspective.h"
#include "ortho.h"
#include "ortho2d.h"

#endif // LEG_SUPPORT_GRAPHICS_GRAPHICS_H
